;------------------------------------------------------------------------------
;                  Relleno de tringulos con TEXTURA
;                           nt/*INCOGNITA*
;                       Version Color 16/15 bits
;------------------------------------------------------------------------------

.386p

AVOID_HOLES =   2               ; Para evitar que la interpolacin se salga
                                ; del intervalo debido a problemas de sub-
                                ; pixel. Debe ser como mnimo 1 para evitar
                                ; divisiones por 0

LOCALS

_DATA SEGMENT PAGE PUBLIC 'DATA'

EXTRN C virtual:dword
EXTRN C graphics_system:dword

INCLUDE vertex.inc

XR equ [graphics_system]
YR equ [graphics_system+4]
YS equ [graphics_system+8]

ALIGN 4

vr1     dd      ?               ; Punteros a los 3 vrtices
vr2     dd      ?
vr3     dd      ?

cur_x1  dd      ?
cur_x2  dd      ?
add_x1  dd      ?
add_x2  dd      ?
add_cte_u dd    ?
cur_u   dd      ?
add_u   dd      ?
add_cte_v dd    ?
cur_v   dd      ?
add_v   dd      ?
pscr    dd      ?               ; Direccin al frame_buffer
cur_h   dd      ?
map     dd      ?
add_cte_uv dd   ?

altura  dd      0               ; Y3-Y1
h12     dd      0
h23     dd      0
max_long dd     ?
xb      dd      ?
ub      dd      ?
vb      dd      ?
temp    dd      ?

_1      dd      1.0


_DATA ENDS

;       Trazador de lneas horizontales

HOR MACRO
        local @@inner,@@done_h,@@c1,@@c2,@@last_pix

;       Ebp = VV.vv UU.uu  --> Add_cte_u : 8.8
;             |
;             -------> Add_cte_v : 8.8

;   Clipping en Y

        cmp [cur_h],0
        jl @@done_h
        mov esi,YR
        cmp [cur_h],esi
        jge abs_fuera

        mov edi,[cur_x1]
        mov ecx,[cur_x2]

        sar edi,16
        mov edx,[cur_v]
        sar ecx,16
        mov ebx,[cur_u]

        sal edx,8               ; Cur_v
        and edx,0ffff0000h
        sar ebx,8               ; Cur_u
        and ebx,00000ffffh

        or edx,ebx

;   Clipping en X

        cmp edi,XR
        jge @@done_h
        test ecx,ecx
        js @@done_h

        mov eax,XR      ; if(cur_x >= Xresolution) cur_x= Xresolution;
        dec eax
        sub eax,ecx
        sbb esi,esi
        and esi,eax
        add ecx,esi

@@c1:   cmp edi,0
        jge @@c2
        add edx,ebp
        inc edi
        jmp @@c1
@@c2:

;       Edx = VV.vv UU.uu  --> Cur_cte_u : 8.8
;             |
;             -------> Cur_v : 8.8

        sub ecx,edi             ; Longitud de la linea horizontal
        js @@done_h
        lea edi,[edi*2]         ; 1 pixel = 2 bytes
        add edi,[pscr]          ; Edi -> destino
        inc ecx                 ; Para evitar agujeros negros
        lea ecx,[ecx*2]
        mov esi,[map]           ; Esi -> textura

        ; Ecx: longitud
        ; Edi: destino
        ; Esi: textura
        ; Ebp: avance_v + avance_u

        mov eax,edx
        shr eax,16
        mov al,dh
        add edx,ebp

        add edi,ecx
        neg ecx
        xor ebx,ebx

;--------------------------------INNER LOOP------------------------------------
@@inner:mov bl,[esi+eax]
        mov eax,edx
        shr eax,16
        and word ptr [edi+ecx-2],63455
        mov ebx,[esi+ebx*4+65536]
        mov al,dh
        add [edi+ecx-2],bx
        mov ebx,0
        shr word ptr [edi+ecx-2],1
        lea edx,[edx+ebp]
        add ecx,2
        jnz @@inner
;------------------------------------------------------------------------------

@@done_h:

ENDM

_TEXT SEGMENT PAGE PUBLIC 'CODE'
        assume cs:_text, ds:_data

        PUBLIC DRAW_TEXTURE_POLY16_

; void draw_texture_poly(VERTEX *, BYTE *);
; #pragma aux draw_texture_poly parm [esi][eax];

;       Esta es la rutina principal. Detecta si es necesario hacer clipping
;       del tringulo

DRAW_TEXTURE_POLY16_ PROC

        pushad

        lea edi,[esi+SIZE VERTEX]
        lea ebp,[esi+2*SIZE VERTEX]

;       Esi = Vrtice 1
;       Edi = Vrtice 2
;       Ebp = Vrtice 3

;       Los trangulos que entren completamente en la pantalla (0<=x<XS) ^
;       (0<=y<YS) son trazados por una rutina que no hace clipping
;       Las comparaciones son sin signo, luego estoy comparando simultaneamente
;       el lmite superior e inferior.

        mov ecx,XR
        mov ebx,YR
        cmp dword ptr [esi+vertex.x],ecx
        jae clip
        cmp dword ptr [edi+vertex.x],ecx
        jae clip
        cmp dword ptr [ebp+vertex.x],ecx
        jae clip

        cmp dword ptr [esi+vertex.y],ebx
        jae clip
        cmp dword ptr [edi+vertex.y],ebx
        jae clip
        cmp dword ptr [ebp+vertex.y],ebx
        jae clip

        jmp no_clip

DRAW_TEXTURE_POLY16_ ENDP

;------------------------------------------------------------------------------
;                 Trazador de tringulos con CLIPPING
;------------------------------------------------------------------------------

DRAW_CLIP_POLY PROC

;       Esta primera parte, por si se llama a la rutina independientemente

        pushad

        lea edi,[esi+SIZE VERTEX]
        lea ebp,[esi+2*SIZE VERTEX]

;       Esi = Vrtice 1
;       Edi = Vrtice 2
;       Ebp = Vrtice 3

clip:   mov [map],eax

;------------------------------------------------------------------------------
;       Clipping en X Sencillo : Aceptar/Rechazar
;------------------------------------------------------------------------------
        mov eax,[esi+vertex.x]
        mov ebx,[edi+vertex.x]
        cmp eax,ebx
        jge @@CX1
        mov ecx,ebx
        mov ebx,eax
        mov eax,ecx
@@CX1:  cmp eax,[ebp+vertex.x]
        jge @@CX2
        mov eax,[ebp+vertex.x]           ; Eax = X mayor
@@CX2:  cmp eax,0
        jl @@fuera
        cmp ebx,[ebp+vertex.x]
        jle @@CX3
        mov ebx,[ebp+vertex.x]           ; Ebx = X Menor
@@CX3:  cmp ebx,XR
        jg @@fuera
;------------------------------------------------------------------------------

;       Ordenar y1<y2<y3

        mov eax,[esi+vertex.y]
        cmp eax,[edi+vertex.y]
        jl @@sort1
        mov eax,esi
        mov esi,edi
        mov edi,eax
@@sort1:mov eax,[esi+vertex.y]
        cmp eax,[ebp+vertex.y]
        jl @@sort2
        mov eax,ebp
        mov ebp,esi
        mov esi,eax
@@sort2:mov eax,[edi+vertex.y]
        cmp eax,[ebp+vertex.y]
        jl @@sort3
        mov eax,edi
        mov edi,ebp
        mov ebp,eax
@@sort3:

;------------------------------------------------------------------------------
;       Clipping en Y Sencillo : Aceptar/Rechazar
;------------------------------------------------------------------------------
        mov eax,YR
        cmp [esi+vertex.y],eax
        jge @@fuera
        cmp [ebp+vertex.y],0
        jl @@fuera
;------------------------------------------------------------------------------

        mov [vr1],esi                   ; Guardar por si modificamos
        mov [vr2],edi
        mov [vr3],ebp

        mov eax,[esi+vertex.y]
        mov [cur_h],eax

        mov eax,[esi+vertex.y]
        imul eax,YS
        add eax,[virtual]
        mov [pscr],eax

        mov eax,[ebp+vertex.y]
        sub eax,[esi+vertex.y]          ; Y3-Y1
        jnz @@n_neg
        inc eax
@@n_neg:mov [altura],eax

        mov eax,[edi+vertex.y]
        sub eax,[esi+vertex.y]          ; Y2-Y1
        jz @@tri1                       ; Lado largo arriba
        mov [h12],eax

        mov eax,[altura]
        sub eax,[h12]                   ; Y3-Y2
        jz @@tri2                       ; Lado largo arriba
        mov [h23],eax

        fild [h12]
        fild [altura]
        fdiv                            ; h12/h13

        mov eax,[esi+vertex.x]
        mov ebx,[esi+vertex.u]
        mov ecx,[esi+vertex.v]
        sal eax,16
        sal ebx,16
        sal ecx,16
        add eax,32768
        mov [cur_u],ebx
        mov [cur_v],ecx
        mov [cur_x1],eax
        mov [cur_x2],eax

; Calculamos atributos del punto 4

; - Coordenada U

        mov edx,[ebp+vertex.u]
        sub edx,[esi+vertex.u]
        mov [temp],edx
        fild [temp]
        fmul st,st(1)

; - Coordenada V

        mov edx,[ebp+vertex.v]
        sub edx,[esi+vertex.v]
        mov [temp],edx
        fistp [ub]
        fild [temp]
        fmul st,st(1)

; - Coordenada X

        mov edx,[ebp+vertex.x]
        sub edx,[esi+vertex.x]
        mov [temp],edx
        fistp [vb]
        fild [temp]
        fmul

        mov edx,[esi+vertex.u]
        add [ub],edx
        mov edx,[esi+vertex.v]
        add [vb],edx

        fistp [xb]
        mov edx,[xb]
        add edx,[esi+vertex.x]

        cmp edx,[edi+vertex.x]
        mov [xb],edx
        jl @@tri3
        je @@fuera              ; x4=x2 Conviene pintarlo? :-???

;------------------------------------------------------------------------------
;                      Lado largo a la derecha 
;                     
;
;                               P1
;                               / \
;                             /     \
;                           /         \
;                         /             \
;                      P2 ----            \P4
;                             ----          \
;                                 ----        \
;                                     ----      \
;                                         ----   \
;                                             ----P3
;------------------------------------------------------------------------------

;   Divisiones en paralelo CPU || FPU

;   Add_x1      vs      Add_x2

        mov eax,[edi+vertex.x]
        fild [h12]              ;*
        sub eax,[esi+vertex.x]
        sal eax,16
        mov [temp],eax
        fild [temp]             ;*

        mov eax,[ebp+vertex.x]
        sub eax,[esi+vertex.x]
        sal eax,16
        mov edx,eax
        fdivr                   ;*
        sar edx,31
        idiv [altura]
        adc eax,1

        mov [add_x2],eax
        fistp [add_x1]

;   Add_cte_u  vs   Add_u

        mov eax,[xb]
        sub eax,[edi+vertex.x]
        add eax,AVOID_HOLES
        mov [max_long],eax
        fild [max_long]         ;*
        mov eax,[ub]
        sub eax,[edi+vertex.u]
        sal eax,8
        mov [temp],eax
        fild [temp]             ;*

        mov eax,[edi+vertex.u]
        sub eax,[esi+vertex.u]
        sal eax,16
        mov edx,eax
        fdivr                   ;*
        sar edx,31
        idiv [h12]
        adc eax,1               ; Redondeo

        mov [add_u],eax
        fistp [add_cte_u]

;   Add_cte_v  vs   Add_v

        fild [max_long]         ;*
        mov eax,[vb]
        sub eax,[edi+vertex.v]
        sal eax,8
        mov [temp],eax
        fild [temp]             ;*

        mov eax,[edi+vertex.v]
        sub eax,[esi+vertex.v]
        sal eax,16
        mov edx,eax
        fdivr                   ;*
        sar edx,31
        idiv [h12]
        adc eax,1               ; Redondeo

        mov [add_v],eax
        fistp [add_cte_v]

        fld [_1]
        fild [h23]
        fdiv                            ; 1/h23

        mov ebp,[add_cte_v]
        sal ebp,16
        mov edx,[add_cte_u]
        and edx,0ffffh
        or ebp,edx
        mov [add_cte_uv],ebp

;       -BUCLE EXTERIOR- (una vez por lnea horizontal)

@@ext3: HOR
        mov edi,[add_x2]
        mov ecx,[add_x1]
        add [cur_x2],edi
        add [cur_x1],ecx
        mov edi,[add_u]
        mov ecx,[add_v]
        add [cur_u],edi
        add [cur_v],ecx
        mov ecx,YS
        inc [cur_h]
        add [pscr],ecx
        dec [h12]
        jnz @@ext3


; Esi,Edi y Ebp han sido mofificados!!!!!!!

        mov edi,[vr2]
        mov ebp,[vr3]

        mov eax,[ebp+vertex.x]
        sub eax,[edi+vertex.x]
        sal eax,16
        mov [temp],eax
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.u]
        sub eax,[edi+vertex.u]
        sal eax,16
        mov [temp],eax
        fistp [add_x1]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v]
        sub eax,[edi+vertex.v]
        sal eax,16
        mov [temp],eax
        fistp [add_u]
        fild [temp]
        fmul

        mov ebp,[add_cte_uv]
        fistp [add_v]
@@ext4: HOR
        mov edi,[add_x2]
        mov ecx,[add_x1]
        add [cur_x2],edi
        add [cur_x1],ecx
        mov edi,[add_u]
        mov ecx,[add_v]
        add [cur_u],edi
        add [cur_v],ecx
        mov ecx,YS
        inc [cur_h]
        add [pscr],ecx
        dec [h23]
        jnz @@ext4

        jmp @@fuera


@@tri3:

;------------------------------------------------------------------------------
;                     Lado largo a la izquierda
;                     
;
;                               P1
;                              / \
;                             /   \
;                            /     \
;                        P4 /     --P2
;                          /   ---
;                         / ---
;                     P3 /--
;
;------------------------------------------------------------------------------

;   Divisiones en paralelo CPU || FPU

;   Add_x1      vs      Add_x2

        mov eax,[ebp+vertex.x]
        fild [altura]           ;*
        sub eax,[esi+vertex.x]
        sal eax,16
        mov [temp],eax
        fild [temp]             ;*

        mov eax,[edi+vertex.x]
        sub eax,[esi+vertex.x]
        sal eax,16
        mov edx,eax
        fdivr                   ;*
        sar edx,31
        idiv [h12]

        mov [add_x2],eax
        fistp [add_x1]

;   Add_cte_u  vs   Add_u

        mov eax,[edi+vertex.x]
        sub eax,[xb]
        add eax,AVOID_HOLES
        mov [max_long],eax
        fild [max_long]         ;*
        mov eax,[edi+vertex.u]
        sub eax,[ub]
        sal eax,8
        mov [temp],eax
        fild [temp]             ;*

        mov eax,[ebp+vertex.u]
        sub eax,[esi+vertex.u]
        sal eax,16
        mov edx,eax
        fdivr                   ;*
        sar edx,31
        idiv [altura]
        adc eax,1               ; Redondeo

        mov [add_u],eax
        fistp [add_cte_u]

;   Add_cte_v  vs   Add_v

        fild [max_long]         ;*
        mov eax,[edi+vertex.v]
        sub eax,[vb]
        sal eax,8
        mov [temp],eax
        fild [temp]             ;*

        mov eax,[ebp+vertex.v]
        sub eax,[esi+vertex.v]
        sal eax,16
        mov edx,eax
        fdivr                   ;*
        sar edx,31
        idiv [altura]
        adc eax,1               ; Redondeo

        mov [add_v],eax
        fistp [add_cte_v]

;   La tercera divisin tambin en paralelo, pues no leemos el resultado hasta
;   el siguiente loop

        mov eax,[ebp+vertex.x]
        fild [h23]
        sub eax,[edi+vertex.x]
        sal eax,16
        mov [temp],eax
        fild [temp]
        fdivr                   ;*

        mov ebp,[add_cte_v]
        sal ebp,16
        mov edx,[add_cte_u]
        and edx,0ffffh
        or ebp,edx
        mov [add_cte_uv],ebp

;       -BUCLE EXTERIOR- (una vez por lnea horizontal)

@@ext5: HOR
        mov edi,[add_x2]
        mov ecx,[add_x1]
        add [cur_x2],edi
        add [cur_x1],ecx
        mov edi,[add_u]
        mov ecx,[add_v]
        add [cur_u],edi
        add [cur_v],ecx
        mov ecx,YS
        inc [cur_h]
        add [pscr],ecx
        dec [h12]
        jnz @@ext5

; Esi,Edi y Ebp han sido mofificados

        fistp [add_x2]

        mov ebp,[add_cte_uv]
@@ext6: HOR
        mov edi,[add_x2]
        mov ecx,[add_x1]
        add [cur_x2],edi
        add [cur_x1],ecx
        mov edi,[add_u]
        mov ecx,[add_v]
        add [cur_u],edi
        add [cur_v],ecx
        mov ecx,YS
        inc [cur_h]
        add [pscr],ecx
        dec [h23]
        jnz @@ext6

@@fuera:
        popad
        ret

abs_fuera:
        fistp [temp]
        popad
        ret

;------------------------------------------------------------------------------
;                         Lado largo arriba
;                        
;                      P1                      P2
;                          -----------------
;                          -               -
;                           -             -
;                            -           -
;                             -         -
;                              -       -
;                               -     -
;                                -   -
;                                  -
;                                  P3
;----------------------------------------------------------------------------

@@tri1:

        fld [_1]
        fild [altura]
        fdiv                            ; 1/altura

; Ordenacin de P1X y P2X

        mov eax,[esi+vertex.x]
        cmp eax,[edi+vertex.x]
        jl @@no_problem
        mov eax,edi
        mov edi,esi
        mov esi,eax
@@no_problem:
        mov eax,[esi+vertex.x]
        mov ebx,[edi+vertex.x]
        sal eax,16
        sal ebx,16
        add eax,32768
        add ebx,32768
        mov [cur_x1],eax
        mov [cur_x2],ebx
        mov eax,[esi+vertex.u]
        mov ebx,[esi+vertex.v]
        sal eax,16
        sal ebx,16
        mov [cur_u],eax
        mov [cur_v],ebx

        fld [_1]
        mov eax,[edi+vertex.x]
        sub eax,[esi+vertex.x]
        add eax,AVOID_HOLES
        mov [max_long],eax
        fild [max_long]
        fdiv                            ; 1/max_long

; Clculos con [max_long]

        mov eax,[edi+vertex.u]          ; Add_cte_u
        sub eax,[esi+vertex.u]
        sal eax,8
        mov [temp],eax
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.v]          ; Add_cte_v
        sub eax,[esi+vertex.v]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_u]
        fild [temp]
        fmul


; Clculos con [altura]

        mov eax,[ebp+vertex.x]          ; Add_x1
        sub eax,[esi+vertex.x]
        sal eax,16
        mov [temp],eax
        fistp [add_cte_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.x]          ; Add_x2
        sub eax,[edi+vertex.x]
        sal eax,16
        mov [temp],eax
        fistp [add_x1]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.u]          ; Add_u
        sub eax,[esi+vertex.u]
        sal eax,16
        mov [temp],eax
        fistp [add_x2]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v]          ; Add_v
        sub eax,[esi+vertex.v]
        sal eax,16
        mov [temp],eax
        fistp [add_u]
        fild [temp]
        fmul
        fistp [add_v]

        mov ebp,[add_cte_v]
        sal ebp,16
        mov edx,[add_cte_u]
        and edx,0ffffh
        or ebp,edx

;       -BUCLE EXTERIOR- (una vez por lnea horizontal)

@@ext:  HOR
        mov edi,[add_x2]
        mov ecx,[add_x1]
        add [cur_x2],edi
        add [cur_x1],ecx
        mov edi,[add_u]
        mov ecx,[add_v]
        add [cur_u],edi
        add [cur_v],ecx
        mov ecx,YS
        inc [cur_h]
        add [pscr],ecx
        dec [altura]
        jnz @@ext

        jmp @@fuera


;------------------------------------------------------------------------------
;                         Lado largo abajo
;                        
;                                  P1
;                                  -
;                                -   -
;                               -     -
;                              -       -
;                             -         -
;                            -           -
;                           -             -
;                          -               -
;                          -----------------
;                         P2               P3
;----------------------------------------------------------------------------
@@tri2:

; --- Lado largo abajo ---

        fld [_1]
        fild [altura]
        fdiv                            ; 1/altura

; Ordenacin de P2X y P3X

        mov eax,[edi+vertex.x]
        cmp eax,[ebp+vertex.x]
        jl @@no_problem2
        mov eax,ebp
        mov ebp,edi
        mov edi,eax
@@no_problem2:
        mov eax,[esi+vertex.x]
        mov ebx,[esi+vertex.u]
        sal eax,16
        sal ebx,16
        add eax,32768
        mov [cur_x1],eax
        mov [cur_x2],eax
        mov [cur_u],ebx
        mov eax,[esi+vertex.v]
        sal eax,16
        mov [cur_v],eax

        fld [_1]
        mov eax,[ebp+vertex.x]
        sub eax,[edi+vertex.x]
        add eax,AVOID_HOLES
        mov [max_long],eax
        fild [max_long]
        fdiv                            ; 1/max_long

; Clculos con [max_long]

        mov eax,[ebp+vertex.u]          ; Add_cte_u
        sub eax,[edi+vertex.u]
        sal eax,8
        mov [temp],eax
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v]          ; Add_cte_v
        sub eax,[edi+vertex.v]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_u]
        fild [temp]
        fmul

; Clculos con [altura]

        mov eax,[edi+vertex.x]          ; Add_x1
        sub eax,[esi+vertex.x]
        sal eax,16
        mov [temp],eax
        fistp [add_cte_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.x]          ; Add_x2
        sub eax,[esi+vertex.x]
        sal eax,16
        mov [temp],eax
        fistp [add_x1]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.u]          ; Add_u
        sub eax,[esi+vertex.u]
        sal eax,16
        mov [temp],eax
        fistp [add_x2]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.v]          ; Add_v
        sub eax,[esi+vertex.v]
        sal eax,16
        mov [temp],eax
        fistp [add_u]
        fild [temp]
        fmul
        fistp [add_v]

        mov ebp,[add_cte_v]
        sal ebp,16
        mov edx,[add_cte_u]
        and edx,0ffffh
        or ebp,edx


;       -BUCLE EXTERIOR- (una vez por lnea horizontal)

@@ext2: HOR
        mov edi,[add_x2]
        mov ecx,[add_x1]
        add [cur_x2],edi
        add [cur_x1],ecx
        mov edi,[add_u]
        mov ecx,[add_v]
        add [cur_u],edi
        add [cur_v],ecx
        mov ecx,YS
        inc [cur_h]
        add [pscr],ecx
        dec [altura]
        jnz @@ext2

        jmp @@fuera

DRAW_CLIP_POLY ENDP

;------------------------------------------------------------------------------
;                 Trazador de tringulos sin CLIPPING
;------------------------------------------------------------------------------

;       Trazador de lneas horizontales sin clipping

HOR_NCLIP MACRO
        local @@inner,@@last_pix,@@fin

;       Ebp = VV.vv UU.uu  --> Add_cte_u : 8.8
;             |
;             -------> Add_cte_v : 8.8

        mov edi,[cur_x1]
        mov ecx,[cur_x2]

        sar edi,16
        mov edx,[cur_v]
        sar ecx,16
        mov ebx,[cur_u]

        sub ecx,edi             ; Longitud de la linea horizontal
;                jz @@fin
        lea edi,[edi*2]         ; 1 pixel = 2 bytes
        add edi,[pscr]          ; Edi -> destino
        inc ecx
        lea ecx,[ecx*2]
        mov esi,[map]           ; Esi -> textura

        ; Ecx: longitud
        ; Edi: destino
        ; Esi: textura
        ; Ebp: avance_v + avance_u

        sal edx,8               ; Cur_v
        add edi,ecx
        sar ebx,8               ; Cur_u
        neg ecx

        and edx,0ffff0000h
        and ebx,00000ffffh

        or edx,ebx

;       Edx = VV.vv UU.uu  --> Cur_cte_u : 8.8
;             |
;             -------> Cur_v : 8.8

        mov eax,edx
        shr eax,16
        mov al,dh
        add edx,ebp
        xor ebx,ebx

;--------------------------------INNER LOOP------------------------------------
@@inner:mov bl,[esi+eax]
        mov eax,edx
        shr eax,16
        and word ptr [edi+ecx-2],63455
        mov ebx,[esi+ebx*4+65536]
        mov al,dh
        add [edi+ecx-2],bx
        mov ebx,0
        shr word ptr [edi+ecx-2],1
        lea edx,[edx+ebp]
        add ecx,2
        jnz @@inner
;------------------------------------------------------------------------------
@@fin:

ENDM

DRAW_NCLIP_POLY PROC

;       Esta primera parte, por si se llama a la rutina independientemente

        pushad

        lea edi,[esi+SIZE VERTEX]
        lea ebp,[esi+2*SIZE VERTEX]

;       Esi = Vrtice 1
;       Edi = Vrtice 2
;       Ebp = Vrtice 3

no_clip: mov [map],eax

;       Ordenar y1<y2<y3

        mov eax,[esi+vertex.y]
        cmp eax,[edi+vertex.y]
        jl @@sort1
        mov eax,esi
        mov esi,edi
        mov edi,eax
@@sort1:mov eax,[esi+vertex.y]
        cmp eax,[ebp+vertex.y]
        jl @@sort2
        mov eax,ebp
        mov ebp,esi
        mov esi,eax
@@sort2:mov eax,[edi+vertex.y]
        cmp eax,[ebp+vertex.y]
        jl @@sort3
        mov eax,edi
        mov edi,ebp
        mov ebp,eax
@@sort3:

        mov [vr1],esi                   ; Guardar por si modificamos
        mov [vr2],edi
        mov [vr3],ebp

        mov eax,[esi+vertex.y]
        imul eax,YS
        add eax,[virtual]
        mov [pscr],eax

        mov eax,[ebp+vertex.y]
        sub eax,[esi+vertex.y]          ; Y3-Y1
        jnz @@n_neg
        inc eax
@@n_neg:mov [altura],eax

        mov eax,[edi+vertex.y]
        sub eax,[esi+vertex.y]          ; Y2-Y1
        jz @@tri1                       ; Lado largo arriba
        mov [h12],eax

        mov eax,[altura]
        sub eax,[h12]                   ; Y3-Y2
        jz @@tri2                       ; Lado largo arriba
        mov [h23],eax

        fild [h12]
        fild [altura]
        fdiv                            ; h12/h13

        mov eax,[esi+vertex.x]
        mov ebx,[esi+vertex.u]
        mov ecx,[esi+vertex.v]
        sal eax,16
        sal ebx,16
        sal ecx,16
        add eax,32768
        mov [cur_u],ebx
        mov [cur_v],ecx
        mov [cur_x1],eax
        mov [cur_x2],eax

; Calculamos atributos del punto 4

; - Coordenada U

        mov edx,[ebp+vertex.u]
        sub edx,[esi+vertex.u]
        mov [temp],edx
        fild [temp]
        fmul st,st(1)

; - Coordenada V

        mov edx,[ebp+vertex.v]
        sub edx,[esi+vertex.v]
        mov [temp],edx
        fistp [ub]
        fild [temp]
        fmul st,st(1)

; - Coordenada X

        mov edx,[ebp+vertex.x]
        sub edx,[esi+vertex.x]
        mov [temp],edx
        fistp [vb]
        fild [temp]
        fmul

        mov edx,[esi+vertex.u]
        add [ub],edx
        mov edx,[esi+vertex.v]
        add [vb],edx

        fistp [xb]
        mov edx,[xb]
        add edx,[esi+vertex.x]

        cmp edx,[edi+vertex.x]
        mov [xb],edx
        jl @@tri3
        je @@fuera              ; x4=x2 Conviene pintarlo? :-???

;------------------------------------------------------------------------------
;                      Lado largo a la derecha 
;                     
;
;                               P1
;                               / \
;                             /     \
;                           /         \
;                         /             \
;                      P2 ----            \P4
;                             ----          \
;                                 ----        \
;                                     ----      \
;                                         ----   \
;                                             ----P3
;------------------------------------------------------------------------------

;   Divisiones en paralelo CPU || FPU

;   Add_x1      vs      Add_x2

        mov eax,[edi+vertex.x]
        fild [h12]              ;*
        sub eax,[esi+vertex.x]
        sal eax,16
        mov [temp],eax
        fild [temp]             ;*

        mov eax,[ebp+vertex.x]
        sub eax,[esi+vertex.x]
        sal eax,16
        mov edx,eax
        fdivr                   ;*
        sar edx,31
        idiv [altura]
        adc eax,1

        mov [add_x2],eax
        fistp [add_x1]

;   Add_cte_u  vs   Add_u

        mov eax,[xb]
        sub eax,[edi+vertex.x]
        add eax,AVOID_HOLES
        mov [max_long],eax
        fild [max_long]         ;*
        mov eax,[ub]
        sub eax,[edi+vertex.u]
        sal eax,8
        mov [temp],eax
        fild [temp]             ;*

        mov eax,[edi+vertex.u]
        sub eax,[esi+vertex.u]
        sal eax,16
        mov edx,eax
        fdivr                   ;*
        sar edx,31
        idiv [h12]
        adc eax,1               ; Redondeo

        mov [add_u],eax
        fistp [add_cte_u]

;   Add_cte_v  vs   Add_v

        fild [max_long]         ;*
        mov eax,[vb]
        sub eax,[edi+vertex.v]
        sal eax,8
        mov [temp],eax
        fild [temp]             ;*

        mov eax,[edi+vertex.v]
        sub eax,[esi+vertex.v]
        sal eax,16
        mov edx,eax
        fdivr                   ;*
        sar edx,31
        idiv [h12]
        adc eax,1               ; Redondeo

        mov [add_v],eax
        fistp [add_cte_v]

        fld [_1]
        fild [h23]
        fdiv                            ; 1/h23

        mov ebp,[add_cte_v]
        sal ebp,16
        mov edx,[add_cte_u]
        and edx,0ffffh
        or ebp,edx
        mov [add_cte_uv],ebp

;       -BUCLE EXTERIOR- (una vez por lnea horizontal)

@@ext3: HOR_NCLIP
        mov edi,[add_x2]
        mov ecx,[add_x1]
        add [cur_x2],edi
        add [cur_x1],ecx
        mov edi,[add_u]
        mov ecx,[add_v]
        add [cur_u],edi
        add [cur_v],ecx
        mov ecx,YS
        add [pscr],ecx
        dec [h12]
        jnz @@ext3


; Esi,Edi y Ebp han sido mofificados!!!!!!!

        mov edi,[vr2]
        mov ebp,[vr3]

        mov eax,[ebp+vertex.x]
        sub eax,[edi+vertex.x]
        sal eax,16
        mov [temp],eax
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.u]
        sub eax,[edi+vertex.u]
        sal eax,16
        mov [temp],eax
        fistp [add_x1]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v]
        sub eax,[edi+vertex.v]
        sal eax,16
        mov [temp],eax
        fistp [add_u]
        fild [temp]
        fmul

        mov ebp,[add_cte_uv]
        fistp [add_v]
@@ext4: HOR_NCLIP
        mov edi,[add_x2]
        mov ecx,[add_x1]
        add [cur_x2],edi
        add [cur_x1],ecx
        mov edi,[add_u]
        mov ecx,[add_v]
        add [cur_u],edi
        add [cur_v],ecx
        mov ecx,YS
        add [pscr],ecx
        dec [h23]
        jnz @@ext4

        jmp @@fuera


@@tri3:

;------------------------------------------------------------------------------
;                     Lado largo a la izquierda
;                     
;
;                               P1
;                              / \
;                             /   \
;                            /     \
;                        P4 /     --P2
;                          /   ---
;                         / ---
;                     P3 /--
;
;------------------------------------------------------------------------------

;   Divisiones en paralelo CPU || FPU

;   Add_x1      vs      Add_x2

        mov eax,[ebp+vertex.x]
        fild [altura]           ;*
        sub eax,[esi+vertex.x]
        sal eax,16
        mov [temp],eax
        fild [temp]             ;*

        mov eax,[edi+vertex.x]
        sub eax,[esi+vertex.x]
        sal eax,16
        mov edx,eax
        fdivr                   ;*
        sar edx,31
        idiv [h12]

        mov [add_x2],eax
        fistp [add_x1]

;   Add_cte_u  vs   Add_u

        mov eax,[edi+vertex.x]
        sub eax,[xb]
        add eax,AVOID_HOLES
        mov [max_long],eax
        fild [max_long]         ;*
        mov eax,[edi+vertex.u]
        sub eax,[ub]
        sal eax,8
        mov [temp],eax
        fild [temp]             ;*

        mov eax,[ebp+vertex.u]
        sub eax,[esi+vertex.u]
        sal eax,16
        mov edx,eax
        fdivr                   ;*
        sar edx,31
        idiv [altura]
        adc eax,1               ; Redondeo

        mov [add_u],eax
        fistp [add_cte_u]

;   Add_cte_v  vs   Add_v

        fild [max_long]         ;*
        mov eax,[edi+vertex.v]
        sub eax,[vb]
        sal eax,8
        mov [temp],eax
        fild [temp]             ;*

        mov eax,[ebp+vertex.v]
        sub eax,[esi+vertex.v]
        sal eax,16
        mov edx,eax
        fdivr                   ;*
        sar edx,31
        idiv [altura]
        adc eax,1               ; Redondeo

        mov [add_v],eax
        fistp [add_cte_v]

;   La tercera divisin tambin en paralelo, pues no leemos el resultado hasta
;   el siguiente loop

        mov eax,[ebp+vertex.x]
        fild [h23]
        sub eax,[edi+vertex.x]
        sal eax,16
        mov [temp],eax
        fild [temp]
        fdivr                   ;*

        mov ebp,[add_cte_v]
        sal ebp,16
        mov edx,[add_cte_u]
        and edx,0ffffh
        or ebp,edx
        mov [add_cte_uv],ebp

;       -BUCLE EXTERIOR- (una vez por lnea horizontal)

@@ext5: HOR_NCLIP
        mov edi,[add_x2]
        mov ecx,[add_x1]
        add [cur_x2],edi
        add [cur_x1],ecx
        mov edi,[add_u]
        mov ecx,[add_v]
        add [cur_u],edi
        add [cur_v],ecx
        mov ecx,YS
        add [pscr],ecx
        dec [h12]
        jnz @@ext5

; Esi,Edi y Ebp han sido mofificados

        fistp [add_x2]

        mov ebp,[add_cte_uv]
@@ext6: HOR_NCLIP
        mov edi,[add_x2]
        mov ecx,[add_x1]
        add [cur_x2],edi
        add [cur_x1],ecx
        mov edi,[add_u]
        mov ecx,[add_v]
        add [cur_u],edi
        add [cur_v],ecx
        mov ecx,YS
        add [pscr],ecx
        dec [h23]
        jnz @@ext6

@@fuera:
        popad
        ret

;------------------------------------------------------------------------------
;                         Lado largo arriba
;                        
;                      P1                      P2
;                          -----------------
;                          -               -
;                           -             -
;                            -           -
;                             -         -
;                              -       -
;                               -     -
;                                -   -
;                                  -
;                                  P3
;----------------------------------------------------------------------------

@@tri1:

        fld [_1]
        fild [altura]
        fdiv                            ; 1/altura

; Ordenacin de P1X y P2X

        mov eax,[esi+vertex.x]
        cmp eax,[edi+vertex.x]
        jl @@no_problem
        mov eax,edi
        mov edi,esi
        mov esi,eax
@@no_problem:
        mov eax,[esi+vertex.x]
        mov ebx,[edi+vertex.x]
        sal eax,16
        sal ebx,16
        add eax,32768
        add ebx,32768
        mov [cur_x1],eax
        mov [cur_x2],ebx
        mov eax,[esi+vertex.u]
        mov ebx,[esi+vertex.v]
        sal eax,16
        sal ebx,16
        mov [cur_u],eax
        mov [cur_v],ebx

        fld [_1]
        mov eax,[edi+vertex.x]
        sub eax,[esi+vertex.x]
        add eax,AVOID_HOLES
        mov [max_long],eax
        fild [max_long]
        fdiv                            ; 1/max_long

; Clculos con [max_long]

        mov eax,[edi+vertex.u]          ; Add_cte_u
        sub eax,[esi+vertex.u]
        sal eax,8
        mov [temp],eax
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.v]          ; Add_cte_v
        sub eax,[esi+vertex.v]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_u]
        fild [temp]
        fmul


; Clculos con [altura]

        mov eax,[ebp+vertex.x]          ; Add_x1
        sub eax,[esi+vertex.x]
        sal eax,16
        mov [temp],eax
        fistp [add_cte_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.x]          ; Add_x2
        sub eax,[edi+vertex.x]
        sal eax,16
        mov [temp],eax
        fistp [add_x1]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.u]          ; Add_u
        sub eax,[esi+vertex.u]
        sal eax,16
        mov [temp],eax
        fistp [add_x2]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v]          ; Add_v
        sub eax,[esi+vertex.v]
        sal eax,16
        mov [temp],eax
        fistp [add_u]
        fild [temp]
        fmul
        fistp [add_v]

        mov ebp,[add_cte_v]
        sal ebp,16
        mov edx,[add_cte_u]
        and edx,0ffffh
        or ebp,edx

;       -BUCLE EXTERIOR- (una vez por lnea horizontal)

@@ext:  HOR_NCLIP
        mov edi,[add_x2]
        mov ecx,[add_x1]
        add [cur_x2],edi
        add [cur_x1],ecx
        mov edi,[add_u]
        mov ecx,[add_v]
        add [cur_u],edi
        add [cur_v],ecx
        mov ecx,YS
        add [pscr],ecx
        dec [altura]
        jnz @@ext

        jmp @@fuera


;------------------------------------------------------------------------------
;                         Lado largo abajo
;                        
;                                  P1
;                                  -
;                                -   -
;                               -     -
;                              -       -
;                             -         -
;                            -           -
;                           -             -
;                          -               -
;                          -----------------
;                         P2               P3
;----------------------------------------------------------------------------
@@tri2:

; --- Lado largo abajo ---

        fld [_1]
        fild [altura]
        fdiv                            ; 1/altura

; Ordenacin de P2X y P3X

        mov eax,[edi+vertex.x]
        cmp eax,[ebp+vertex.x]
        jl @@no_problem2
        mov eax,ebp
        mov ebp,edi
        mov edi,eax
@@no_problem2:
        mov eax,[esi+vertex.x]
        mov ebx,[esi+vertex.u]
        sal eax,16
        sal ebx,16
        add eax,32768
        mov [cur_x1],eax
        mov [cur_x2],eax
        mov [cur_u],ebx
        mov eax,[esi+vertex.v]
        sal eax,16
        mov [cur_v],eax

        fld [_1]
        mov eax,[ebp+vertex.x]
        sub eax,[edi+vertex.x]
        add eax,AVOID_HOLES
        mov [max_long],eax
        fild [max_long]
        fdiv                            ; 1/max_long

; Clculos con [max_long]

        mov eax,[ebp+vertex.u]          ; Add_cte_u
        sub eax,[edi+vertex.u]
        sal eax,8
        mov [temp],eax
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.v]          ; Add_cte_v
        sub eax,[edi+vertex.v]
        sal eax,8
        mov [temp],eax
        fistp [add_cte_u]
        fild [temp]
        fmul

; Clculos con [altura]

        mov eax,[edi+vertex.x]          ; Add_x1
        sub eax,[esi+vertex.x]
        sal eax,16
        mov [temp],eax
        fistp [add_cte_v]
        fild [temp]
        fmul st,st(1)

        mov eax,[ebp+vertex.x]          ; Add_x2
        sub eax,[esi+vertex.x]
        sal eax,16
        mov [temp],eax
        fistp [add_x1]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.u]          ; Add_u
        sub eax,[esi+vertex.u]
        sal eax,16
        mov [temp],eax
        fistp [add_x2]
        fild [temp]
        fmul st,st(1)

        mov eax,[edi+vertex.v]          ; Add_v
        sub eax,[esi+vertex.v]
        sal eax,16
        mov [temp],eax
        fistp [add_u]
        fild [temp]
        fmul
        fistp [add_v]

        mov ebp,[add_cte_v]
        sal ebp,16
        mov edx,[add_cte_u]
        and edx,0ffffh
        or ebp,edx


;       -BUCLE EXTERIOR- (una vez por lnea horizontal)

@@ext2: HOR_NCLIP
        mov edi,[add_x2]
        mov ecx,[add_x1]
        add [cur_x2],edi
        add [cur_x1],ecx
        mov edi,[add_u]
        mov ecx,[add_v]
        add [cur_u],edi
        add [cur_v],ecx
        mov ecx,YS
        add [pscr],ecx
        dec [altura]
        jnz @@ext2

        jmp @@fuera

DRAW_NCLIP_POLY ENDP

_TEXT ENDS

	END
