#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include <string.h>

#include <keyb_hnd.h>
#include <types.h>
#include <graphs.h>
#include <timer.h>
#include <icp.h>
#include <font.h>

#include "matrix.h"
#include "karate.h"


static TRI *tri_ready;                     // Buffer de tringulos a pintar
static TRI *first_tri;                     // Primer tringulo
static WORLD world;

extern BYTE *virtual;

static DWORD camera_frames;
static BOOLEAN camera_loaded;
static CAMERA_FRAME *track_camera;

static WORD triangles_2_draw;
static WORD max_tri=0;
static BYTE *goods;

static MATRIZ local;
static BYTE *buffer;
static float angulo;
static DWORD cur_frame=0,i,j;
static BYTE fps_info[15];
static float *trackpos,key;
static DWORD last_frame,temp_frame;
static float last_time,temp_time,time,last_ani,ani,fps=0;

void init_karateka(void) {

    WORD *obj;

    init_the_world();

    // Cargar objeto

    if((obj=lib_fopen("karate.icg"))==NULL)
        fatal_error("Can't load karate icg (init_karateka)");
    load_object(obj,0,0,0);
    free(obj);


}

void init_karateka2(void) {

    if((buffer=lib_fopen("karate.seq"))==NULL)
        fatal_error("Can't load karate seq (init_karateka)");

    world.frames=*((DWORD *)buffer);
    world.entidades=*((DWORD *)(buffer+4));
    trackpos=world.track=(float *)(buffer+8);

    // Cargar cmara
    load_camera("karate.cam");
    update_camera(0);

}

void init_karateka3(void) {

    graphics_system.xratio=(float)graphics_system.xresolution/(2*tan(60.0/360*PI));
    graphics_system.yratio=(float)(graphics_system.yresolution*640)/(2*480*tan(60.0/360*PI));

    frames_dr=frames=0;
    last_ani=last_time=lib_get_time();
    last_frame=0;
    ani=0.0;

}

void frame_karateka(void) {

    init_matriz(local);
    angulo=0.05;

    if(icg_boss) {

        if(K_UP) {
            translation(world.camara,0,0,-10);
            camera_loaded=FALSE;
        }
        if(K_DOWN) {
            translation(world.camara,0,0,10);
            camera_loaded=FALSE;
        }
        if(K_PGUP) {
            rotation_x(world.camara,-angulo);
            camera_loaded=FALSE;
        }
        if(K_PGDN) {
            rotation_x(world.camara,angulo);
            camera_loaded=FALSE;
        }
        if(K_LEFT) {
            rotation_y(world.camara,-angulo);
            camera_loaded=FALSE;
        }
        if(K_RIGHT) {
            rotation_y(world.camara,angulo);
            camera_loaded=FALSE;
        }
    }

    // Animacin
    time=lib_get_time();
    ani+=(time-last_ani)*29.2;

    last_ani=time;

    while(ani>=1.0 && cur_frame<world.frames) {

    for(i=0;i<world.entidades;i++) {

        key=*trackpos;

        if(key>3.0) {
            local[0][0]=1.0;
            local[0][1]=0.0;
            local[0][2]=0.0;
            local[1][0]=0.0;
            local[1][1]=1.0;
            local[1][2]=0.0;
            local[2][0]=0.0;
            local[2][1]=0.0;
            local[2][2]=1.0;
            local[3][0]=0.0;
            local[3][1]=0.0;
            local[3][2]=0.0;

            trackpos++;
        }
        else {

            local[0][0]=key;
            local[0][1]=*(trackpos+1);
            local[0][2]=*(trackpos+2);
            local[1][0]=*(trackpos+3);
            local[1][1]=*(trackpos+4);
            local[1][2]=*(trackpos+5);
            local[2][0]=*(trackpos+6);
            local[2][1]=*(trackpos+7);
            local[2][2]=*(trackpos+8);
            local[3][0]=0;
            local[3][1]=0;
            local[3][2]=0;

            trackpos+=9;
        }

        pre_mul_matriz(local,world.object[(world.entity+i+1)->w_object].o_space);

        if(i==0) {

            world.object[(world.entity+i+1)->w_object].o_space[3][0]=*(trackpos);
            world.object[(world.entity+i+1)->w_object].o_space[3][1]=-(*(trackpos+2));
            world.object[(world.entity+i+1)->w_object].o_space[3][2]=*(trackpos+1);

            trackpos+=3;

        }

        }

        cur_frame++;

//        if(++cur_frame>=world.frames) {
//            cur_frame=0;
//            trackpos=world.track;
//        }
        ani--;
    }

    update_camera(cur_frame);
    pre_mul_matriz(local,world.object[0].o_space);
    rotar_objects();
    if(world.n_dummies>=MAX_DUMMIES) credits();
    draw_objects();

    if(K_F && icg_boss) {
        temp_frame=frames_dr;
        temp_time=lib_get_time();
        if (temp_time-last_time>0.25) {
            fps=(float)(temp_frame-last_frame)/(temp_time-last_time);
            last_time=temp_time;
            last_frame=temp_frame;
        }
        sprintf(fps_info,"Fps: %4.3f",fps);
        lib_write_string(fps_info,0,0,31,virtual);
    }


}

void end_karateka(void) {

    for(i=0;i<world.n_materials;i++) {
        free((*(world.material+i))->bitmap);
        free(*(world.material+i));
    }

    free(world.material);

    for(i=0;i<world.n_objects;i++) {

        free((world.object+i)->vertices);
        free((world.object+i)->flags);
        free((world.object+i)->proyecciones);
        free((world.object+i)->rot_vertices);
        free((world.object+i)->tri);
        free((world.object+i)->ecuaciones);
        free((world.object+i)->normal);
        free((world.object+i)->color);
        free((world.object+i)->texel);
        if((world.object+i)->n_text)
            free((world.object+i)->map);
        free(goods);
        free(tri_ready);

        j=0;
        while((world.entity+j)->w_object<world.n_objects) {
            free((world.entity+j++)->child);
        }
        free(world.entity);

    }

    free(track_camera);
    free(buffer);

}

static void load_camera(BYTE *name) {

    BYTE *buffer;

    if((buffer=lib_fopen(name))==NULL)
        fatal_error("Can't load bump camera");

    camera_frames=*((DWORD *)buffer);

    if((track_camera=malloc(camera_frames*sizeof(CAMERA_FRAME)))==NULL)
        fatal_error("Not enough memory: loading %s",name);
    else {
        memcpy(track_camera,buffer+4,camera_frames*sizeof(CAMERA_FRAME));
        camera_loaded=TRUE;
        free(buffer);
    }

}

static BOOLEAN zero(float a) {

    if(a<EPSILON && a>-EPSILON) return TRUE;
    else return FALSE;

}


static void update_camera(DWORD frame) {

    VECTOR pos,dst;

    float alpha,beta;

    if(!camera_loaded) return;

    // Movimiento por splines precalculadas

    if(frame<camera_frames) {

        pos=(track_camera+frame)->pos;
        dst=(track_camera+frame)->target;

        dst.x-=pos.x;
        dst.y-=pos.y;
        dst.z-=pos.z;

        init_matriz(world.camara);

        world.camara[3][0]=-pos.x;
        world.camara[3][1]=pos.y;
        world.camara[3][2]=-pos.z;

        if(!zero(dst.x) || !zero(dst.z)) {

            alpha=acos(dst.z/(sqrt(dst.x*dst.x+dst.z*dst.z)));
            if(dst.x<0) alpha=-alpha;

            rotation_y(world.camara,alpha);

        }


        if(!zero(world.camara[2][0]))
            dst.z=-dst.x/world.camara[2][0];
        else
            dst.z=dst.z/world.camara[2][2];

        if(!zero(dst.z) || !zero(dst.y)) {

            beta=acos(dst.z/(sqrt(dst.z*dst.z+dst.y*dst.y)));
            if(dst.y<0) beta=-beta;

            rotation_x(world.camara,-beta);

        }

        rotation_z(world.camara,-(track_camera+frame)->roll);
    }

}

static void init_the_world(void) {

    world.n_objects=0;
    world.n_materials=0;
    init_matriz(world.camara);

    world.render=GOUR_TEXTURE;
    world.light.x=0;
    world.light.y=0;
    world.light.z=1;

}

void filter(BYTE *in, BYTE *out) {

    DWORD i=0;

    while(in[i]!='\0' && in[i]!='.') {
        out[i]=in[i];
        i++;
    }

    out[i]='\0';
    strcat(out,".gou");

}

static void load_object(WORD *buffer, float x, float y, float z) {

    BYTE out[20];
    OBJECT *cur_obj;
    WORD i,j,k,l,n_texturas;
    float *mtx;
    RTEXT *rtext;
    DWORD *wbuffer,tmp;
    BYTE *bbuffer,*base;

    j=*(buffer++);
    buffer+=2;          // Saltar puntero a jerarquas

    // Leer Texturas
    n_texturas=*(buffer++);
    world.material=malloc(n_texturas*sizeof(MATERIAL *));
    for(i=0;i<n_texturas;i++) {

        *(world.material+i)=malloc(sizeof(MATERIAL));
        filter((BYTE *)buffer,out);
        if((base=lib_fopen(out))==NULL)
            fatal_error("Can't load %s",out);
        (*(world.material+i))->bitmap=base;
        convert_pal(base+256*256*2+256*4);
        memcpy((*(world.material+i))->name,buffer,20*sizeof(BYTE));
        buffer+=10;
        world.n_materials++;
    }

    for(i=0;i<j;i++) {

    if(world.n_objects==MAX_OBJECTS) {
                        puts("\nMuchos objectos");
                        abort(); }

    cur_obj=world.object+world.n_objects;
    cur_obj->n_vertices=*(buffer++);

    cur_obj->vertices=(VECTOR *)malloc((cur_obj->n_vertices)*sizeof(VECTOR));
    if(cur_obj->vertices==NULL)
        fatal_error("No hay memoria (cargando vertices)");
    memcpy(cur_obj->vertices,buffer,(cur_obj->n_vertices)*sizeof(VECTOR));


    cur_obj->flags=(BYTE *)malloc((cur_obj->n_vertices)*sizeof(BYTE));
    if(cur_obj->flags==NULL)
        fatal_error("No hay memoria (cargando flags)");

    cur_obj->proyecciones=(PIXEL *)malloc((cur_obj->n_vertices)*sizeof(PIXEL));
    if(cur_obj->proyecciones==NULL)
        fatal_error("No hay memoria (cargando proyecciones)");

    cur_obj->rot_vertices=(VECTOR *)malloc((cur_obj->n_vertices)*sizeof(VECTOR));
    if(cur_obj->rot_vertices==NULL)
        fatal_error("No hay memoria (cargando rot_vertices)");

    buffer+=(cur_obj->n_vertices)*sizeof(VECTOR)/2;

    cur_obj->n_tri=*(buffer++);
    world.n_tri+=cur_obj->n_tri;      // Sumar a la cuenta global

    cur_obj->tri=(PTOS_TRI *)malloc((cur_obj->n_tri)*sizeof(PTOS_TRI));
    if(cur_obj->tri==NULL)
        fatal_error("No hay memoria (cargando caras)");
    memcpy(cur_obj->tri,buffer,(cur_obj->n_tri)*sizeof(PTOS_TRI));

    buffer+=(cur_obj->n_tri)*sizeof(PTOS_TRI)/2;

    cur_obj->ecuaciones=(EQ_TRI *)malloc((cur_obj->n_tri)*sizeof(EQ_TRI));
    if(cur_obj->ecuaciones==NULL)
        fatal_error("No hay memoria (cargando ecuaciones)");
    memcpy(cur_obj->ecuaciones,buffer,(cur_obj->n_tri)*sizeof(EQ_TRI));
    buffer+=(cur_obj->n_tri)*sizeof(EQ_TRI)/2;

    cur_obj->normal=(VECTOR *)malloc((cur_obj->n_vertices)*sizeof(VECTOR));
    if(cur_obj->normal==NULL)
        fatal_error("No hay memoria (cargando normales)");
    memcpy(cur_obj->normal,buffer,(cur_obj->n_vertices)*sizeof(VECTOR));


    cur_obj->color=(BYTE *)malloc((cur_obj->n_vertices)*sizeof(BYTE));
    buffer+=(cur_obj->n_vertices)*sizeof(VECTOR)/2;

    cur_obj->texel=(BYTE *)malloc((cur_obj->n_tri)*sizeof(BYTE));
    if(cur_obj->texel==NULL)
        fatal_error("No hay memoria (cargando materiales)");
    memcpy(cur_obj->texel,buffer,(cur_obj->n_tri)*sizeof(BYTE));
    bbuffer=(BYTE *)buffer;
    bbuffer+=(cur_obj->n_tri)*sizeof(BYTE);
    buffer=(WORD *)bbuffer;

    // Leer coordenadas a textura (si es que existen)

    cur_obj->n_text=*(buffer++);
    if(cur_obj->n_text) {
        cur_obj->map=(TEXT *)malloc((cur_obj->n_text)*sizeof(TEXT));
        if(cur_obj->map==NULL)
            fatal_error("No hay memoria (cargando mappings)");
        rtext=(RTEXT *)malloc((cur_obj->n_text)*sizeof(RTEXT));
        if(rtext==NULL) fatal_error("No hay memoria (cargando mappings)");
        memcpy(rtext,buffer,(cur_obj->n_text)*sizeof(RTEXT));
        for(k=0;k<cur_obj->n_text;k++) {
            (cur_obj->map+k)->u=255*(rtext+k)->u;
            (cur_obj->map+k)->v=255*(-(rtext+k)->v);
        }
        free(rtext);
        buffer+=(cur_obj->n_text)*sizeof(TEXT)/2;
    }

    cur_obj->orgx=x;
    cur_obj->orgy=y;
    cur_obj->orgz=z;

    if(cur_obj->n_tri>max_tri)  {
        goods=(BYTE *)realloc(goods,cur_obj->n_tri*sizeof(BYTE));
        if(goods==NULL) fatal_error("No hay memoria (goods)");
        max_tri=cur_obj->n_tri;
    }

    world.n_objects++;

    tri_ready=(TRI *)realloc(tri_ready,(world.n_tri+MAX_DUMMIES)*sizeof(TRI));
    if(tri_ready==NULL) fatal_error("No hay memoria (Tri_ready)");

    }

    // Jerarquas

    wbuffer=(DWORD *)buffer;
    tmp=*wbuffer++;
    world.entity=malloc(tmp*sizeof(ENTITY));
    if(world.entity==NULL) fatal_error("No hay memoria (cargando entidades)");
    for(k=0;k<tmp;k++) {
        (world.entity+k)->w_object=*wbuffer;
        if(*wbuffer++!=-1) {
            cur_obj=world.object+*(wbuffer-1);
            mtx=(float *)wbuffer;
            init_matriz(cur_obj->e_space);
            init_matriz(cur_obj->o_space);
            cur_obj->o_space[0][0]=*(mtx);
            cur_obj->o_space[0][1]=*(mtx+1);
            cur_obj->o_space[0][2]=*(mtx+2);
            cur_obj->o_space[1][0]=*(mtx+3);
            cur_obj->o_space[1][1]=*(mtx+4);
            cur_obj->o_space[1][2]=*(mtx+5);
            cur_obj->o_space[2][0]=*(mtx+6);
            cur_obj->o_space[2][1]=*(mtx+7);
            cur_obj->o_space[2][2]=*(mtx+8);

            cur_obj->o_space[3][0]=*(mtx+9);
            cur_obj->o_space[3][1]=*(mtx+10);
            cur_obj->o_space[3][2]=*(mtx+11);
        }

        wbuffer+=sizeof(float)*12/sizeof(DWORD);
        (world.entity+k)->no_child=*wbuffer;
        (world.entity+k)->child=malloc(*wbuffer++*sizeof(ENTITY *));
        if((world.entity+k)->child==NULL && (world.entity+k)->no_child)
            fatal_error("No hay memoria (Cargando hijo)");
        for(l=0;l<(world.entity+k)->no_child;l++)
            *((world.entity+k)->child+l)=world.entity+*wbuffer++;

    }
}

#pragma aux clrscr =   \
    "mov edi,virtual"  \
    "xor eax,eax"      \
    "rep stosd"        \
    modify [edi eax]    \
    parm [ecx];

static void rotar_objects(void) {

    DWORD i;
    VECTOR local_camara={0,0,0};
    VECTOR world_camara;

    first_tri=NULL;
    triangles_2_draw=0;         // De momento, nada que pintar
    world.n_dummies=0;

    // Posicin de la cmara en el mundo
    inv_transform(&world_camara,&local_camara,world.camara);

    for(i=0;i<world.entity->no_child;i++) {
        hierarchical_transform(world.entity->child[i],world.camara,TRUE);
        hierarchical_render(world.entity->child[i],world_camara,world.light,TRUE);
    }

}


static void hierarchical_transform(ENTITY *cur_child, MATRIZ eye, BYTE root) {

    DWORD i;
    OBJECT *obj=world.object+cur_child->w_object;

    if(root) {
        copy_matriz(obj->e_space,obj->o_space);
        obj->e_space[3][0]+=obj->orgx;
        obj->e_space[3][1]-=obj->orgy;
        obj->e_space[3][2]+=obj->orgz;
        post_mul_matriz(obj->e_space,eye);
    }
    else mul_matriz(obj->e_space,obj->o_space,eye);

    for(i=0;i<cur_child->no_child;i++)
        hierarchical_transform(cur_child->child[i],obj->e_space,FALSE);

}

static void hierarchical_render(ENTITY *cur_child, VECTOR camara, VECTOR luz, BYTE root) {

    DWORD i,j;
    SWORD color;
    BYTE *vis;
    OBJECT *obj;
    VECTOR *vertices,*rot_vertices,parent_camara,local_camara,local_luz;
    PTOS_TRI *cur_tri;
    EQ_TRI *eq_tri;
    float angulo;

    obj=world.object+cur_child->w_object;
    vertices=obj->vertices;
    cur_tri=obj->tri;
    rot_vertices=obj->rot_vertices;
    eq_tri=obj->ecuaciones;
    vis=obj->flags;

    parent_camara.x=camara.x;
    parent_camara.y=camara.y;
    parent_camara.z=camara.z;
    if(root) {
        parent_camara.x-=obj->orgx;
        parent_camara.y+=obj->orgy;
        parent_camara.z-=obj->orgz;
    }

    inv_transform(&local_camara,&parent_camara,obj->o_space);
    if(world.render!=WIRE)
       vr_inv_transform(&local_luz,&luz,obj->o_space);

    memset(vis,FALSE,obj->n_vertices*sizeof(BYTE));  // Ninguno visible

    // Goods --> Tringulos visibles
    // Vis   --> Puntos visibles

    back_face(obj->n_tri,goods,&local_camara,eq_tri,cur_tri,vis);

    transform_pts(obj->n_vertices,vis,vertices,rot_vertices,&obj->e_space,obj->proyecciones);

    for(j=0;j<obj->n_vertices;j++) {
        if(!*(vis+j)) continue;
        angulo=(local_luz.x*((obj->normal+j)->x)+
                local_luz.y*((obj->normal+j)->y)+
                local_luz.z*((obj->normal+j)->z));
        color=(NSHADES-1)*angulo;
        if(color<15) color=15;
        *(obj->color+j)=color;
    }

    for(j=0;j<obj->n_tri;j++)
        if(*(goods+j)==TRUE) zclipping(obj,cur_tri+j,color,j);


    for(i=0;i<cur_child->no_child;i++)
        hierarchical_render(cur_child->child[i],local_camara,local_luz,FALSE);

}

//-----------------------------------------------------------------------------
//                             RADIX SORT
//
//  La primera vez que tuve noticia de este algoritmo fue en el nmero 10 de la
//      revista Imphobia (Junio 1995). Realmente es ms rpido que el quicksort.
//  La implementacin que viene a continuacin es aun ms rpida ya que ordena
//      una lista de tringulos que estn enlazados por lo que no necesito nin-
//      gn tipo de buffer intermedio, ni destino. Muy rpido. Debo dar todos
//      mis agradecimientos a Yann/Iguana, en cuyas fuentes pude ver que real-
//      mente esta idea funcionaba y que me ayudaron a conseguir acabar esto.
//-----------------------------------------------------------------------------

//  2 pasadas, listas de 256
#define BITS    8
#define RADIX   256     // 2^BITS
#define PASS    2       // SIZE/RADIX

/*//  4 pasadas, listas de 16
#define BITS    4
#define RADIX   16      // 2^BITS
#define PASS    4       // SIZE/RADIX */

// Pointers rulezz!!
static TRI **pgroups[RADIX],*groups[RADIX],*cur_tri,**pfirst_tri;

static void radix_sort(void) {

    SWORD i,j,val;

    for(i=0;i<PASS;i++) {
        for(j=0;j<RADIX;j++) {
            pgroups[j]=groups+j;    // Iniciamos los punteros al principio
                                    //  de cada lista
            }
        // Empezar por el 1er tringulo
        for(cur_tri=first_tri;cur_tri;cur_tri=cur_tri->next_tri) {
            val=((cur_tri->depth)>>(i*BITS)) & (RADIX-1);
            *pgroups[val]=cur_tri;
            pgroups[val]=&cur_tri->next_tri;
        }

        // Tenemos en groups[], RADIX listas de tringulos ordenados segn la
        // pasada correspondiente.

        for(j=0;j<RADIX;j++) {
            *pgroups[j]=NULL;       // Finalizar la listas con NULLs
        }

        // Ahora enlazamos las listas que esten activas para que no queden los
        //  tringulos sueltos

        pfirst_tri=&first_tri;
        for(j=RADIX-1;j>=0;j--) {   // Ordenar de mayor Z a menos
            if(groups[j]) {
                *pfirst_tri=groups[j];  // Reenlazar las listas
                pfirst_tri=pgroups[j];
            }
        }
    }

}

static void draw_objects(void) {

    SDWORD x1,x2,x3,y1,y2,y3;
    OBJECT *obj;
    PIXEL *ptos;
    PTOS_TRI *cur_tri;
    BYTE *color;
    TEXT *env,*map;
    VERTEX points[3];
    TRI *buf_tri;

    radix_sort();
    buf_tri=first_tri;
    for(buf_tri=first_tri;buf_tri;buf_tri=buf_tri->next_tri) {

        obj=buf_tri->n_object;
        cur_tri=buf_tri->n_tri;
        ptos=obj->proyecciones;
        color=obj->color;
        env=obj->env;
        map=obj->map;

        points[0].x=x1=(ptos+cur_tri->a)->x;
        points[1].x=x2=(ptos+cur_tri->b)->x;
        points[2].x=x3=(ptos+cur_tri->c)->x;
        points[0].y=y1=(ptos+cur_tri->a)->y;
        points[1].y=y2=(ptos+cur_tri->b)->y;
        points[2].y=y3=(ptos+cur_tri->c)->y;

//            draw_clip_line(x1,y1,x2,y2,0xffffffff);
//            draw_clip_line(x2,y2,x3,y3,0xffffffff);
//            draw_clip_line(x3,y3,x1,y1,0xffffffff);

        if(buf_tri->bitmap!=0 && buf_tri->bitmap<=world.n_materials) {

            points[0].u=(map+cur_tri->a)->u;
            points[0].v=(map+cur_tri->a)->v;
            points[1].u=(map+cur_tri->b)->u;
            points[1].v=(map+cur_tri->b)->v;
            points[2].u=(map+cur_tri->c)->u;
            points[2].v=(map+cur_tri->c)->v;

            points[0].color=*(color+cur_tri->a);
            points[1].color=*(color+cur_tri->b);
            points[2].color=*(color+cur_tri->c);

            draw_gtexture_poly(points,(*(world.material+(buf_tri->bitmap)-1))->bitmap);

            }

    }

}


static void zclipping(OBJECT *obj,PTOS_TRI *tri,SDWORD color, DWORD plane) {

    DWORD flag=0;
    if((obj->rot_vertices+tri->a)->z < HITHER) flag|=1;
    if((obj->rot_vertices+tri->b)->z < HITHER) flag|=2;
    if((obj->rot_vertices+tri->c)->z < HITHER) flag|=4;

    // Polgono totalmente oculto
    if(flag==7) return;

    // Polgono totalmente visible
    if(!flag) {

        (tri_ready+triangles_2_draw)->n_object=obj;
        (tri_ready+triangles_2_draw)->n_tri=tri;
        (tri_ready+triangles_2_draw)->next_tri=first_tri;
        first_tri=tri_ready+triangles_2_draw;

        if(world.render!=WIRE) {
            (tri_ready+triangles_2_draw)->depth=
            (obj->rot_vertices+tri->a)->z  +
            (obj->rot_vertices+tri->b)->z  +
            (obj->rot_vertices+tri->c)->z;
            (tri_ready+triangles_2_draw)->bitmap=*(obj->texel+plane);
            if(world.render==FLAT) (tri_ready+triangles_2_draw)->color=color;
                }

        triangles_2_draw++;
    }

#if Z_CLIPPING==TRUE

    // Polgono con un punto fuera
    if(flag==1) one_clip(obj,tri->c,tri->b,tri->a,color);     // 001
    if(flag==2) one_clip(obj,tri->a,tri->c,tri->b,color);     // 010
    if(flag==4) one_clip(obj,tri->b,tri->a,tri->c,color);     // 100

    // Polgono con dos puntos fuera
    if(flag==3) two_clip(obj,tri->c,tri->a,tri->b,color);     // 011
    if(flag==6) two_clip(obj,tri->a,tri->b,tri->c,color);     // 110
    if(flag==5) two_clip(obj,tri->b,tri->c,tri->a,color);     // 101

#endif

    return;

}
