.386p

; Pintado de polgonos de n lados con textura. Correccin cada 32 pixels
; 16 bbp
; Versin Pentium (Compilar con Intel=1)

; Requiere que la FPU est en modo Ceil.
; Es recomendable bajar la precisin del copro para las divisiones

LOCALS

_DATA SEGMENT PAGE PUBLIC 'DATA'

IF Intel

INCLUDE types.inc

YS equ [graphics_system+8]

EXTRN C virtual:dword
EXTRN C graphics_system:dword

ALIGN 32

EXTRN _texel:dword

EXTRN _iwidth:dword
EXTRN _uadjust:dword
EXTRN _vadjust:dword
EXTRN _ulimit:dword
EXTRN _vlimit:dword

EXTRN _Oa:dword
EXTRN _Ha:dword
EXTRN _Va:dword

EXTRN _Ob:dword
EXTRN _Hb:dword
EXTRN _Vb:dword

EXTRN _Oc:dword
EXTRN _Hc:dword
EXTRN _Vc:dword

EXTRN _a0:dword
EXTRN _b0:dword
EXTRN _c0:dword

_64k      dd    65536.0
_32       dd    32.0
magic     dd    8388608.0

first_vrt dd    ?
last_vrt  dd    ?
vmin      dd    ?
vmax      dd    ?
miny      dd    ?
maxy      dd    ?
ceil_miny dd    ?

left_vrt  dd    ?
right_vrt dd    ?

ceil_y1   dd    ?
ceil_y2   dd    ?

left_dxdy dd    ?
left_x    dd    ?
left_height dd  ?

right_dxdy dd   ?
right_x    dd   ?
right_height dd ?

scan      dd    ?
x1        dd    ?
wdth      dd    ?

Ha32      dd    ?
Hb32      dd    ?
Hc32      dd    ?

a         dd    ?
b         dd    ?
c         dd    ?
cin       dd    ?
u         dd    ?
v         dd    ?
nextu     dd    ?
nextv     dd    ?
ustep     dd    ?
vstep     dd    ?
temp      dd    ?
dvdxfrac  dd    ?
duvdx     dd    ?,?

; 1/n desde 1 a 31 en formato 0.32

ALIGN 32

inv_1_31  dd      0h
          dd      0ffffffffh              ;1/1
          dd      07fffffffh              ;1/2
          dd      05555557fh              ;1/3
          dd      03fffffffh              ;1/4
          dd      03333333fh              ;1/5
          dd      02aaaaabfh              ;1/6
          dd      02492493fh              ;1/7
          dd      01fffffffh              ;1/8
          dd      01c71c71fh              ;1/9
          dd      01999999fh              ;1/10
          dd      01745d17fh              ;1/11
          dd      01555555fh              ;1/12
          dd      013b13b1fh              ;1/13
          dd      01249249fh              ;1/14
          dd      01111111fh              ;1/15
          dd      0fffffffh               ;1/16
          dd      0f0f0f0fh               ;1/17
          dd      0e38e38fh               ;1/18
          dd      0d79435fh               ;1/19
          dd      0ccccccfh               ;1/20
          dd      0c30c30fh               ;1/21
          dd      0ba2e8bfh               ;1/22
          dd      0b21642fh               ;1/23
          dd      0aaaaaafh               ;1/24
          dd      0a3d709fh               ;1/25
          dd      09d89d8fh               ;1/26
          dd      097b425fh               ;1/27
          dd      0924924fh               ;1/28
          dd      08d3dcafh               ;1/29
          dd      0888888fh               ;1/30
          dd      0842107fh               ;1/31

ENDIF

_DATA ENDS


_TEXT SEGMENT PAGE PUBLIC 'CODE'
        assume cs:_text, ds:_data

IF Intel

LEFT_SIDE MACRO
        local @@fwd,@@end_left

;    v1=left_vrt;
;    if(left_vrt==last_vrt) v2=first_vrt;
;    else v2=left_vrt+1;
;    left_vrt=v2;

        mov ebp,[left_vrt]
        mov ecx,ebp

        mov edx,[first_vrt]

        cmp ebp,[last_vrt]
        je @@fwd
        lea edx,[SIZE vertex+ebp]
@@fwd:  mov [left_vrt],edx

;       ecx -> v1
;       edx -> v2

        fld [ecx+vertex.y]              ; y1
        fld [edx+vertex.y]              ; y2|y1

        fistp [ceil_y2]
        fistp [ceil_y1]

        mov ebp,[ceil_y2]
        mov eax,[ecx+vertex.slope]
        sub ebp,[ceil_y1]
        jle @@end_left

;    left_dxdy=v1->slope;

        mov [left_dxdy],eax

;    left_x=v1->x*65536.0+(ceil(v1->y)-v1->y)*left_dxdy;

        fild [ceil_y1]                  ; cy1
        fld [ecx+vertex.x]              ; x1|cy1
        fmul [_64k]                     ; x1*64k|cy1
        fild [left_dxdy]                ; ldxdy|x1*64k|cy1
        fxch st(2)                      ; cy1|x1*64k|ldxdy
        fsub [ecx+vertex.y]             ; cy1-y1|x1*64k|ldxdy

        fmulp st(2)                     ; (cy1-y1)*ldxdy|x1*64k

        faddp                           ; (cy1-y1)*ldxdy+x1*64k
        fistp [left_x]

@@end_left:

ENDM

RIGHT_SIDE MACRO
        local @@fwd,@@end_right

;    v1=right_vrt;
;    if(right_vrt==first_vrt) v2=last_vrt;
;    else v2=right_vrt-1;

        mov ebp,[right_vrt]
        mov ecx,ebp

        mov edx,[last_vrt]

        cmp ebp,[first_vrt]
        je @@fwd
        lea edx,[ebp-SIZE vertex]
@@fwd:  mov [right_vrt],edx

;       ecx -> v1
;       edx -> v2

        fld [ecx+vertex.y]              ; y1
        fld [edx+vertex.y]              ; y2|y1

        fistp [ceil_y2]
        fistp [ceil_y1]

        mov ebp,[ceil_y2]
        mov eax,[edx+vertex.slope]
        sub ebp,[ceil_y1]
        jle @@end_right


;    right_dxdy=v2->slope;

        mov [right_dxdy],eax


;    right_x=v1->x*65536.0+(ceil(v1->y)-v1->y)*right_dxdy;

        fild [ceil_y1]                  ; cy1
        fld [ecx+vertex.x]              ; x1|cy1
        fmul [_64k]                     ; x1*64k|cy1
        fild [right_dxdy]               ; rdxdy|x1*64k|cy1
        fxch st(2)                      ; cy1|x1*64k|rdxdy
        fsub [ecx+vertex.y]             ; cy1-y1|x1*64k|rdxdy

        fmulp st(2)                     ; (cy1-y1)*rdxdy|x1*64k

        faddp                           ; (cy1-y1)*rdxdy+x1*64k

        fistp [right_x]

@@end_right:

ENDM

MLOOP MACRO

;            a0=a+x1*Ha;
;            b0=b+x1*Hb;
;            c0=c+x1*Hc;
                                   ; x1
        fld st(0)                  ; x1|x1                 1
        fmul [_Ha]                 ; x1*Ha|x1              2-4
        fld st(1)                  ; x1|x1*Ha|x1           3
        fmul [_Hb]                 ; x1*Hb|x1*Ha|x1        4-6
        fxch                       ; x1*Ha|x1*Hb|x1        4
        fadd [a]                   ; x1*Ha+a|x1*Hb|x1      5-7
        fxch st(2)                 ; x1|x1*Hb|x1*Ha+a      5
        fmul [_Hc]                 ; x1*Hc|x1*Hb|x1*Ha+a   6-8
        fxch                       ; x1*Hb|x1*Hc|x1*Ha+a   6
        fadd [b]                   ; x1*Hb+b|x1*Hc|x1*Ha+a 7-9
        fxch st(2)                 ; x1*Ha+a|x1*Hc|x1*Hb+b 7
        fstp [_a0]                 ; x1*Hc|x1*Hb+b         9
        fadd [c]                   ; x1*Hc+c|x1*Hb+b       10-12
        fxch                       ; x1*Hb+b|x1*Hc+c       10
        fstp [_b0]                 ; x1*Hc+c               12
        fst  [_c0]                 ; c0                    14

;            ci=65536.0/c0;
;            c0+=Hc32;
;            cin=65536.0/c0;

        fld [_64k]                 ; 64k|c0
        fdiv st(0),st(1)           ; 64k/c0|c0
        fxch                       ; c0|64k/c0
        fadd [Hc32]                ; c0+Hc32|64k/c0
        fld [_64k]                 ; 64k|c0+Hc32|64k/c0
        fdiv st(0),st(1)           ; 64k/(c0+Hc32)|c0+Hc32|64k/c0
        fxch                       ; c0+Hc32|64k/(c0+Hc32)|64k/c0
        fstp [_c0]                 ; cin|ci

;            u=uadjust+(DWORD)(a0*ci);
;            v=vadjust+(DWORD)(b0*ci);

        fld [_a0]                 ; a0|cin|ci
        fmul st(0),st(2)          ; a0*ci|cin|ci
        fld [_b0]                 ; b0|a0*ci|cin|ci
        fmulp st(3)               ; a0*ci|cin|b0*ci
        fxch                      ; cin|a0*ci|b0*ci
        fstp [cin]                ; a0*ci|b0*ci
        fistp [u]                 ; b0*ci
        fistp [v]                 ;

        mov eax,[u]
        mov ebx,[v]
        add eax,[_uadjust];
        add ebx,[_vadjust];

;            if(u>ulimit) u=ulimit;
;            else if(u<0) u=0;
;            if(v>vlimit) v=vlimit;
;            else if(v<0) v=0;

        cmp eax,[_ulimit]
        ja @@clamp1
@@ret_clamp1:
        cmp ebx,[_vlimit]
        ja @@clamp2
@@ret_clamp2:

        mov [u],eax
        mov [v],ebx

@@lspan:

;                if(width>=32) count=32;
;                else count=width;
;                width-=count;

        mov ecx,32
        cmp [wdth],32
        jae @@c32
        mov ecx,[wdth]
@@c32:  sub [wdth],ecx
        je @@divloop

;                    a0+=Ha32;
;                    b0+=Hb32;

        fld [_a0]               ; a0                            ;1
        fadd [Ha32]             ; a0+Ha32                       ;2-4
        fld [cin]               ; cin|a0+Ha32                   ;3
        fxch                    ; a0+Ha32|cin                   ;3
        fld [_b0]               ; b0|a0+Ha32|cin                ;4
        fadd [Hb32]             ; b0+Hb32|a0+Ha32|cin           ;5-7
        fxch                    ; a0+Ha32|b0+Hb32|cin           ;5
        fst [_a0]               ; a0+Ha32|b0+Hb32|cin           ;7

;                    nextu=uadjust+(DWORD)(a0*cin);
;                    nextv=vadjust+(DWORD)(b0*cin);
;                    c0+=Hc32;
;                    cin=65536.0/c0;

                                ; a0|b0|cin
        fmul st(0),st(2)        ; a0*cin|b0|cin                 ;5-7
        fld [_c0]               ; c0|a0*cin|b0|cin              ;6
        fadd [Hc32]             ; c0+Hc32|a0*cin|b0|cin         ;7-9
        fxch                    ; a0*cin|c0+Hc32|b0|cin         ;7
;        fadd [magic]            ; (a0*cin)|c0+Hc32|b0|cin       ;8-10
        fxch st(2)              ; b0|c0+Hc32|(a0*cin)|cin       ;8
        fst [_b0]               ; b0|c0+Hc32|(a0*cin)|cin       ;9-10
        fmulp st(3)             ; c0+Hc32|(a0*cin)|b0*cin       ;10-12
        fst [_c0]               ; c0|(a0*cin)|b0*cin            ;12
        fld [_64k]              ; 64k|c0|(a0*cin)|b0*cin        ;13
        fxch st(3)              ; b0*cin|c0|(a0*cin)|64k        ;13
;        fadd [magic]            ; (b0*cin)|c0|(a0*cin)|64k      ;14-16
        fxch st(2)              ; (a0*cin)|c0|(b0*cin)|64k      ;14
        fistp [nextu]            ; c0|(b0*cin)|64k               ;16
        fxch                    ; (b0*cin)|c0|64k               ;17
        fistp [nextv]            ; c0|64k                        ;19


; No podemos hacer la divisin hasta que pasemos todos los imul

        mov eax,[nextu]
        mov ebx,[nextv]
        add eax,[_uadjust];
        add ebx,[_vadjust];

;        if(nextu>ulimit) nextu=ulimit;
;        else if(nextu<0) nextu=0;

;        if(nextv>vlimit) nextv=vlimit;
;        else if(nextv<0) nextv=0;

        cmp eax,[_ulimit]
        ja @@clamp3
@@ret_clamp3:
        cmp ebx,[_vlimit]
        ja @@clamp4
@@ret_clamp4:

        mov [nextu],eax
        mov [nextv],ebx

;                    ustep=(nextu-u)>>5;
;                    vstep=(nextv-v)>>5;

        sub eax,[u]
        sub ebx,[v]
        sar eax,5
        mov edx,[u]
        sar ebx,5
        mov ebp,[v]
        mov [ustep],eax
        mov [vstep],ebx

;                    *(scan+x1++)=*(texel+((v>>16)*iwidth)+(u>>16));
;                    u+=ustep;
;                    v+=vstep;


        shr edx,16
        mov esi,[_texel]
        shr ebp,16
        lea esi,[esi+2*edx]

        imul ebp,[_iwidth]
        mov edx,eax

        sar edx,16
        lea esi,[esi+2*ebp]              ; esi -> pts a textura

        mov ebp,ebx
        sar ebp,16

        imul ebp,[_iwidth]
        add ebp,edx

; No hay ms imuls. Listos para dividir en paralelo

        fdivp                   ; 64k/c0

        mov [duvdx+4],ebp
        add ebp,[_iwidth]
        mov [duvdx],ebp

        shl ebx,16
        mov edx,eax

        shl edx,16
        mov [dvdxfrac],ebx

        shr esi,1
        mov eax,[u]

        shl eax,16
        add ecx,ecx

        mov ebx,[v]

        shl ebx,16
        add ebx,[dvdxfrac]
        sbb ebp,ebp

        push ecx

;       Esi : Posicin inicial de la textura
;       Edx      : Avance u (fraccin)
;       dvdxfrac : Avance v (fraccin)
;       Eax      : u (fraccin)
;       Ebx      : v (fraccin)
;       Edi+Ecx  : Destino a framebuffer
;       Ecx      : Ancho del scan

@@floop:

        i=0
        REPT 32
        add eax,edx             ;1
        mov ecx,[2*esi]         ;0
        adc esi,[duvdx+ebp*4+4] ;2
        add ebx,[dvdxfrac]      ;0
        sbb ebp,ebp             ;1
        mov [edi+i],cx          ;1
        i=i+2
        ENDM

        pop ecx
        add edi,ecx

;                u=nextu;
;                v=nextv;

        mov eax,[nextu]
        mov ebx,[nextv]

        mov [u],eax
        mov [v],ebx

        fstp [cin]

;       while (width>0);

        cmp [wdth],0
        ja @@lspan

        jmp @@end_scan

@@divloop:
;                    if(count>1) {
;                          count_1=(float)count-1;
;                            a0+=Ha*count_1;
;                            b0+=Hb*count_1;
;                            c0-=Hc32-count_1*Hc;
;                            cin=65536.0/c0;

        cmp ecx,1
        jbe @@one_loop

        dec ecx
        mov [temp],ecx

        fild [temp]                     ; count-1                  ;1-3
        fld [_Ha]                       ; Ha|c-1                   ;2
        fld [_Hb]                       ; Hb|Ha|c-1                ;3
        fmul st(0),st(2)                ; Hb*(c-1)|Ha|c-1          ;4-6
        fxch                            ; Ha|Hb*(c-1)|c-1          ;4
        fld [_a0]                       ; a0|Ha|Hb*(c-1)|c-1       ;5
        fxch                            ; Ha|a0|Hb*(c-1)|c-1       ;5

        fmul st(0),st(3)                ; Ha*(c-1)|a0|Hb*(c-1)|c-1 ;6-8
        fld [_b0]                       ; b0|Ha*(c-1)|a0|Hb*(c-1)|c-1 ;7
        faddp st(3)                     ; Ha*(c-1)|a0|b0+Hb*(c-1)|c-1 ;8-10
        faddp                           ; a0+Ha*(c-1)|b0+Hb*(c-1)|c-1 ;9-11
                                        ; a0|b0|c-1
        fxch st(2)                      ; c-1|b0|a0                 ;9
        fmul [_Hc]                      ; Hc*(c-1)|b0|a0            ;10-12
        fld [_c0]                       ; c0|Hc*(c-1)|b0|a0         ;11
        fsub [Hc32]                     ; c0-Hc32|Hc*(c-1)|b0|a0    ;12-14
        fld [_64k]                      ; 64k|c0-Hc32|Hc*(c-1)|b0|a0 ;13
        fxch                            ; c0-Hc32|64k|Hc*(c-1)|b0|a0 ;13
        faddp st(2)                     ; 64k|c0|b0|a0
        fdivrp                          ; cin|b0|a0


;                    nextu=uadjust+(DWORD)(a0*cin);
;                    nextv=vadjust+(DWORD)(b0*cin);

        fxch                            ; b0|cin|a0
        fmul st(0),st(1)                ; b0*cin|cin|a0
        fistp [nextv]                   ; cin|a0
        fmulp                           ; a0*cin
        fistp [nextu]

        mov eax,[nextu]
        mov ebx,[nextv]
        add eax,[_uadjust];
        add ebx,[_vadjust];

;                    if(nextu>ulimit) nextu=ulimit;
;                    else if(nextu<0) nextu=0;
;                    if(nextu>ulimit) nextu=ulimit;
;                    else if(nextu<0) nextu=0;

        cmp eax,[_ulimit]
        ja @@clamp5
@@ret_clamp5:
        cmp ebx,[_vlimit]
        ja @@clamp6
@@ret_clamp6:

;               ustep=(nextu-u)/(count-1);
;               vstep=(nextv-v)/(count-1);

        sub eax,[u]
        imul [inv_1_31+ecx*4]
        mov [ustep],edx

        sub ebx,[v]
        mov eax,ebx
        imul [inv_1_31+ecx*4]
        mov [vstep],edx

        inc ecx

@@one_loop:

        mov eax,[ustep]
        mov ebx,[vstep]

        mov edx,[u]
        mov ebp,[v]

        shr edx,16
        mov esi,[_texel]
        shr ebp,16
        lea esi,[esi+2*edx]

        imul ebp,[_iwidth]
        mov edx,eax

        sar edx,16
        lea esi,[esi+2*ebp]             ; esi -> ptr a textura

        mov ebp,ebx
        sar ebp,16

        imul ebp,[_iwidth]
        add ebp,edx

        mov [duvdx+4],ebp
        add ebp,[_iwidth]
        mov [duvdx],ebp

        shl ebx,16
        mov edx,eax

        shl edx,16
        mov [dvdxfrac],ebx
        add ecx,ecx
        mov eax,[u]
        add edi,ecx

        shl eax,16
        mov ebx,[v]

        shl ebx,16
        xor ecx,-1

        add ebx,[dvdxfrac]
        sbb ebp,ebp
        inc ecx

;       Esi : Posicin inicial de la textura
;       Edx      : Avance u (fraccin)
;       dvdxfrac : Avance v (fraccin)
;       Eax      : u (fraccin)
;       Ebx      : v (fraccin)
;       Edi+Ecx  : Destino a framebuffer
;       -Ecx     ; Ancho del scan

        shr esi,1

@@floop2:
        add eax,edx             ;1
        mov bx,[2*esi]          ;1
        adc esi,[duvdx+ebp*4+4] ;2
        add ebx,[dvdxfrac]      ;0
        sbb ebp,ebp             ;1
        mov [edi+ecx],bx        ;1

        add ecx,2               ;1
        jnz @@floop2            ;0

@@end_scan:

ENDM

;void scan_poly32(VERTEX *, DWORD);
;#pragma aux scan_poly parm [esi][ecx];

        PUBLIC SCAN_POLY32_

SCAN_POLY32_ PROC

        pushad

;    Ha32=Ha*32.0;
;    Hb32=Hb*32.0;
;    Hc32=Hc*32.0;

        fld [_Ha]
        fmul [_32]
        fld [_Hb]
        fmul [_32]
        fld [_Hc]
        fmul [_32]

;    first_vrt=vrt;
;    last_vrt=vrt+no_vrt-1;

        dec ecx
        mov [first_vrt],esi

        imul ecx,SIZE vertex
        mov [last_vrt],ecx
        add [last_vrt],esi

        fstp [Hc32]
        fstp [Hb32]
        fstp [Ha32]

;    vmin=vmax=vrt;
;    miny=vrt->y;
;    maxy=vrt->y;

        mov eax,[esi+ecx+vertex.y]

        mov [vmin],ecx
        mov [vmax],ecx

        mov [miny],eax
        mov [maxy],eax
        mov ebx,eax

        sub ecx,SIZE vertex

;    for(i=1;i<no_vrt;i++) {
;        if((vrt+i)->y<miny) {
;            vmin=vrt+i;
;            miny=(vrt+i)->y;
;        }
;        else if ((vrt+i)->y>maxy) {
;            vmax=vrt+i;
;            maxy=(vrt+i)->y;
;        }
;    }

        ; eax : mnima y (coma flotante)
        ; ebx : mxima y (coma flotante)

@@get_min:
        mov edx,[esi+ecx+vertex.y]
        cmp edx,eax
        jae @@no_min
        mov [vmin],ecx
        mov eax,edx
@@no_min:
        cmp edx,ebx
        jbe @@no_max
        mov [vmax],ecx
        mov ebx,edx
@@no_max:
        sub ecx,SIZE vertex
        jnz @@get_min

        mov [miny],eax
        mov [maxy],ebx

        fld [miny]

        add [vmin],esi
        add [vmax],esi
        mov edx,[vmin]

        mov [left_vrt],edx
        mov [right_vrt],edx

        fistp [ceil_miny]

;    do {
;        if(right_vrt==vmax) return;
;        right_height=right_side();
;    } while(right_height<=0);

;    do {
;        if(left_vrt==vmax) return;
;        left_height=left_side();
;    } while(left_height<=0);


@@left: mov edx,[vmax]
        cmp [left_vrt],edx
        je @@return

        LEFT_SIDE
        test ebp,ebp
        jle @@left
        mov [left_height],ebp

@@right:mov edx,[vmax]
        cmp [right_vrt],edx
        je @@return

        RIGHT_SIDE
        test ebp,ebp
        jle @@right
        mov [right_height],ebp

;    a=a0+ceil(miny)*Va;
;    b=b0+ceil(miny)*Vb;
;    c=c0+ceil(miny)*Vc;

        fild [ceil_miny]        ; cy
        fld st(0)               ; cy|cy
        fmul [_Va]              ; cy*Va|cy
        fld st(1)               ; cy|cy*Va|cy
        fmul [_Vb]              ; cy*Vb|cy*Va|cy
        fxch                    ; cy*Va|cy*Vb|cy
        fadd [_a0]              ; cy*Va+a0|cy*Vb|cy
        fxch st(2)              ; cy|cy*Vb|cy*Va+a0
        fmul [_Vc]              ; cy*Vc|cy*Vb|cy*Va+a0
        fxch                    ; cy*Vb|cy*Vc|cy*Va+a0
        fadd [_b0]              ; cy*Vb+b0|cy*Vc|cy*Va+a0
        fxch st(2)              ; cy*Va+a0|cy*Vc|cy*Vb+b0
        fstp [a]                ; cy*Vc|cy*Vb+b0
        fadd [_c0]              ; cy*Vc+c0|cy*Vb+b0
        fxch                    ; cy*Vb+b0|cy*Vc+c0
        fstp [b]                ; cy*Vc+c0


;    scan=virtual+((DWORD)ceil(miny))*graphics_system.xresolution;

        mov edx,[ceil_miny]
        imul edx,YS
        add edx,[virtual]
        mov [scan],edx

        fstp [c]                ; |

@@mloop:

;        x1 = (left_x+0xffff)>>16;
;        width = ((right_x+0xffff)>>16) - x1;

        mov edx,[left_x]
        mov eax,[right_x]
        add edx,0ffffh
        add eax,0ffffh

        shr edx,16
        mov edi,[scan]
        shr eax,16
        mov [x1],edx
        sub eax,edx
        jle @@ddraw

        fild [x1]
        mov [wdth],eax
        lea edi,[edi+2*edx]

;       edi = Destino
;       x1  = st(0)

        MLOOP

@@ddraw:

;        scan+=graphics_system.xresolution;

        mov eax,YS
        add [scan],eax

;        a+=Va;
;        b+=Vb;
;        c+=Vc;

        fld [a]
        fadd [_Va]
        fld [b]
        fadd [_Vb]
        fld [c]
        fadd [_Vc]
        fxch st(2)
        fstp [a]
        fstp [b]
        fstp [c]


;        if(--right_height<=0) {
;            do {
;                if(right_vrt==vmax) return;
;                right_height=right_side();
;            } while(right_height<=0);
;        }

        mov edx,[right_dxdy]
        dec [right_height]
        jg @@cedge

@@right2:mov edx,[vmax]
        cmp [right_vrt],edx
        je @@return

        RIGHT_SIDE
        test ebp,ebp
        jle @@right2
        mov [right_height],ebp
        jmp @@ncedge

@@cedge:
        add [right_x],edx

@@ncedge:

;        if(--left_height<=0) {
;            do {
;                if(left_vrt==vmax) return;
;                left_height=left_side();
;            } while(left_height<=0);
;        }
;        else left_x+=left_dxdy;

        mov edx,[left_dxdy]
        dec [left_height]
        jg @@cedge2

@@left2:mov edx,[vmax]
        cmp [left_vrt],edx
        je @@return

        LEFT_SIDE
        test ebp,ebp
        jle @@left2
        mov [left_height],ebp
        jmp @@ncedge2

@@cedge2:
        add [left_x],edx

@@ncedge2:

        jmp @@mloop

@@return:

        popad
        ret



@@clamp1:
        jg @@clamp_up1
        xor eax,eax
        jmp @@ret_clamp1
@@clamp_up1:
        mov eax,[_ulimit]
        jmp @@ret_clamp1

@@clamp2:
        jg @@clamp_up2
        xor ebx,ebx
        jmp @@ret_clamp2
@@clamp_up2:
        mov ebx,[_vlimit]
        jmp @@ret_clamp2

@@clamp3:
        jg @@clamp_up3
        xor eax,eax
        jmp @@ret_clamp3
@@clamp_up3:
        mov eax,[_ulimit]
        jmp @@ret_clamp3

@@clamp4:
        jg @@clamp_up4
        xor ebx,ebx
        jmp @@ret_clamp4
@@clamp_up4:
        mov ebx,[_vlimit]
        jmp @@ret_clamp4

@@clamp5:
        jg @@clamp_up5
        xor eax,eax
        jmp @@ret_clamp5
@@clamp_up5:
        mov eax,[_ulimit]
        jmp @@ret_clamp5

@@clamp6:
        jg @@clamp_up6
        xor ebx,ebx
        jmp @@ret_clamp6
@@clamp_up6:
        mov ebx,[_vlimit]
        jmp @@ret_clamp6


SCAN_POLY32_ ENDP

ENDIF

_TEXT ENDS

	END
