unit OneRes;

(* The Total Chaos "resource" .TPU for all standard shit, REALLY global
** vars, etc. etc. etc.
*)

{$F+}

interface

uses
	midas, sdevice, mplayer, modp, {mtm,} s3m, mfile, mmem, errors, mconfig, vgatext, ems,
	{timer,} zipvga, liktwk, crt, fastsine, libfile, edgetabl;

{const}
	(*modulePlayers : array[0..NUMMPLAYERS-1] of PModulePlayer =
		( @mpS3M, @mpMOD, @mpMTM );*)

var
	MP : PModulePlayer;
	SD : PSoundDevice;
	module : PmpModule;
	quit, error, i, isConfig : integer;
	masterVolume : word;                { music master volume }
	defAmplify : word;                  { default amplification }
	amplification : word;               { current amplification }
	fileName : string;
	str : array[0..256] of char;
	free1 : longint;
	configured : integer;
	SaveExit : pointer;
	info : PmpInformation;
	track, row : word;
	l : lib;
	lf : file;
	trapretrace : boolean;
	{sync : boolean;
	synchro : word;}

procedure NewModule (filename : PChar);
procedure StopModule;
procedure GetPos;

procedure GetEMS (var ptr; len : word);
procedure FreeEMS (var ptr);

function Fetch (filename : string) : longint;
procedure GetECP (var scr);

procedure brightness (b, l : word);

implementation

{procedure preVR;

begin
end;

procedure immVR;

begin
end;

procedure inVR;

begin;
	sync := true;
end;}

procedure ErrorExit(msg : string);

begin
		closevga;
		WriteLn('Error: ', msg);
		midasClose;
		Halt;
end;

procedure NewExit;

begin
	ExitProc := SaveExit;

	close (lf);
	MidasClose;
end;

procedure GetEMS (var ptr; len : word);

begin
	EmsAlloc (len, @ptr);
end;

procedure FreeEMS (var ptr);

begin
	EmsFree (@ptr);
end;

procedure NewModule(fileName : PChar);
var
		header : ^byte;
		f : fileHandle;
		error, mpNum, recognized : integer;

begin
		{ allocate memory for module header: }
		error := memAlloc(MPHDRSIZE, @header);
		if error <> OK then
				midasError(error);

		{ open module file: }
		error := fileOpen(fileName, fileOpenRead, @f);
		if error <> OK then
				midasError(error);

		{ read MPHDRSIZE bytes of module header: }
		error := fileRead(f, header, MPHDRSIZE);
		if error <> OK then
				midasError(error);

		error := fileClose(f);
		if error <> OK then
				midasError(error);

		{ Search through all Module Players to find one that recognizes the
			file header: }
		mpNum := 0; MP := NIL;

		(*while (mpNum < NUMMPLAYERS) and (MP = NIL) do
		begin
				error := modulePlayers[mpNum]^.Identify(header, @recognized);
				if error <> OK then
						midasError(error);

				if recognized = 1 then
						MP :=modulePlayers[mpNum];
				mpNum := mpNum + 1;
		end;*)

		MP := @mpS3M;
		error := MP^.Identify(header, @recognized);
		if error <> OK then
			midasError(error);

		(*if recognized = 1 then
			MP := mpS3M;*)
		if recognized <> 1 then
			ErrorExit ('Error: Corrupted music file!');

		{ deallocate module header: }
		error := memFree(header);
		if error <> OK then
				midasError(error);

		if MP = NIL then
				ErrorExit('Error: Corrupted file!');

		{ load the module file using correct Module Player: }
		(*module := midasLoadModule(fileName, MP, NIL);*)
		error := MP^.LoadModule(fileName, midasSD, {SaveSampleInfo} NIL, @module);
		if error <> OK then
				midasError(error);


		{ check that the module does not have too many channels: }
		(*if module^.numChans > MAXMUSCHANNELS then
				ErrorExit('Too many channels in module');*)

		{ start playing the module: }
		midasPlayModule(module, 0);
		{tmrSyncScr (synchro, @prevr, @immvr, @invr);}
end;

procedure StopModule;

begin
		{tmrstopscrsync;}
		midasStopModule(module);
		midasFreeModule(module);
end;

procedure GetPos;

begin
	MP^.GetInformation(@Info);
	Track := info^.pos;
	Row := info^.row;
end;

function Fetch (filename : string) : longint;

var
	s : section;

begin
	GetLibFile (l, filename, s);
	SeekToSection (lf, s);
	Fetch := s.flength;
end;

procedure GetECP (var scr);

var
	scr2 : ^screen;

begin
	scr2 := @scr;
	ReadTab (scr2^, lf);
end;

procedure brightness (b, l : word);

var
	i : word;

begin
	port[$3C8] := 0;
	for i := 0 to 767 do
		port[$3C9] := mini(63, i*b div 768 + l);
end;

begin
		SaveExit := ExitProc;
		ExitProc := @NewExit;

		quit := 0;
		masterVolume := 64;

		free1 := MaxAvail;

		(*{ Check that the configuration file exists: }
		error := fileExists('TtlChaos.CFG', @isConfig);
		if (isConfig <> 1) or (paramcount > 0) then
		begin
			midasSetDefaults;                   { set MIDAS defaults }

			{ Run MIDAS Sound System configuration: }
			configured := midasConfig;

			{ Reset display mode: }
			vgaSetMode($03);

			if configured = 1 then
			begin
					{ Configuration succesful - save configuration file: }
					midasSaveConfig('TtlChaos.CFG');
					WriteLn('Configuration written to TtlChaos.CFG');
			end
			else
			begin
					{ Configuration unsuccessful: }
					WriteLn('Configuration NOT saved');
			end;
		end;

		midasSetDefaults;                   { set MIDAS defaults }
		midasLoadConfig('TtlChaos.CFG');       { load configuration }*)

		InitVGA;
		Init60Hz256256256c;
		{tmrGetScrSync (@synchro);}
		CloseVGA;

		configured := midasConfig; { we're not allowed to save configfile... groan... }

		midasInit;                          { initialize MIDAS Sound System }
		SD := midasSD;                      { copy Sound Device pointer }

		{ Open channels for music and sound effects. The first FXCHANNELS
			channels will always be free for playing effects: }
		midasOpenChannels(14);

		{ Get Sound Device default amplification value: }
		error := SD^.GetAmplification(@defAmplify);
		if error <> OK then
				midasError(error);
		amplification := defAmplify;

		OpenLib (lf, l, 'onenight.001', 0);
end.