unit part5;

interface

procedure Run;

implementation

uses
	crt, zipvga, oneres;

const
	lastframe0 = 15*64+63;
	lastframe1 = 16*64+63;
	lastframe2 = 17*64+63;
	lastframe3 = 21*64+63;

type
	screen = array[0..65534] of byte;

var
	vscr : screen absolute $A000:0; { Video memory }
	scr, pic, wtabx, wtaby : ^screen; { Screen buffer, picture, wobble table }
	i, j : word; { Screen counter }
	x, y : integer; { Wobble thingy }
	f : word; { Frame }
	sintab : array[0..511] of shortint; { Sine table }
	frame : longint;

	procedure smile64; external; {$L smile64.obj}

procedure run;

begin
	new (scr);
	new (pic);
	new (wtabx);
	new (wtaby);

	asm
		mov ax, 013h
		int 10h
	 end;
port[ $3D4]:= $11 ; port[ $3D5]:=port[$3D5] AND $7F;
port[ $3C2]:= $E3;
port[ $3D4]:= $0; port[ $3D5]:= $5F;
port[ $3D4]:= $1; port[ $3D5]:= $3F;
port[ $3D4]:= $2; port[ $3D5]:= $40;
port[ $3D4]:= $3; port[ $3D5]:= $82;
port[ $3D4]:= $4; port[ $3D5]:= $4A;
port[ $3D4]:= $5; port[ $3D5]:= $9A;
port[ $3D4]:= $6; port[ $3D5]:= $23;
port[ $3D4]:= $7; port[ $3D5]:= $B2;
port[ $3D4]:= $8; port[ $3D5]:= $0;
port[ $3D4]:= $9; port[ $3D5]:= $61;
port[ $3D4]:= $10; port[ $3D5]:= $A;
port[ $3D4]:= $11; port[ $3D5]:= $AC;
port[ $3D4]:= $12; port[ $3D5]:= $FF;
port[ $3D4]:= $13; port[ $3D5]:= $20;
port[ $3D4]:= $14; port[ $3D5]:= $40;
port[ $3D4]:= $15; port[ $3D5]:= $7;
port[ $3D4]:= $16; port[ $3D5]:= $1A;
port[ $3D4]:= $17; port[ $3D5]:= $A3;
port[ $3C4]:= $1; port[ $3C5]:= $1;
port[ $3C4]:= $4; port[ $3C5]:= $E;
port[ $3CE]:= $5; port[ $3CF]:= $40;
port[ $3CE]:= $6; port[ $3CF]:= $5;

	for i := 0 to 511 do
		sintab[i] := trunc(sin(i*pi/256)*128);

	{ Starting picture }
	{for i := 0 to 65535 do
		vscr[i] := (i and 255 - 127)*(i div 256 - 127) div 256;}
	for i := 0 to 255 do
		setrgb (i, i div 2, i div 2, i div 8);

	{readkey;}

	f := 0;
	{ Wobble table }
	for i := 0 to 255 do
		for j := 0 to 255 do
		 begin
			wtabx^[i + j*256] := (sintab[(i*4) and 511] + sintab[(j*16) and 511] div 4) div 16;
			wtaby^[i + j*256] := (sintab[(j*2) and 511] + sintab[(i*32) and 511] div 2) div 16;
		 end;
	for i := 0 to 65535 do
		vscr[i] := pic^[i + wtabx^[i] + wtaby^[i]*256];

	{readkey;}

	{ Continuous wobble }
	move ((@smile64)^, scr^, 4096);
	for i := 0 to 65535 do
		vscr[i] := scr^[(i and 255) and 63 + ((i div 256) and 63)*64];
	pic^ := vscr;

	repeat
		for i := 0 to 65535 do
			scr^[i] := pic^[i + wtabx^[i + f*8] + wtaby^[i + f*256*8]*256];
		asm
			mov ax, 0A000h
			mov es, ax
			xor di, di

			push ds
				lds si, scr

				mov cx, 16384
				db $66; rep movsw
			pop ds
		 end;

		inc (f);
		getpos;
		frame := 64*track + row;
	until keypressed or (frame >= lastframe0);

	if keypressed then
		readkey;

	move ((@smile64)^, scr^, 4096);
	for i := 0 to 65535 do
		vscr[i] := scr^[(i and 255) div 4 + ((i div 256) div 4)*64];
	pic^ := vscr;

	repeat
		{retrace;}
		{setrgb (0, 31, 0, 0);}
		for i := 0 to 65535 do
			scr^[i] := pic^[i + wtabx^[i + f*8] + wtaby^[i + f*256*8]*256];
		{asm
			les di, pic
			xor cx, cx

			mov bx, f
			shl bx, 3

		 @Loop:
			push ds
				lds si, wtaby
				mov si, bx
				shl si, 8
				add si, di
				mov ah, ds:[si]
			pop ds
			push ds
				lds si, wtabx
				mov si, bx
				add si, di
				mov al, ds:[si]
			pop ds

			mov bx, ax
			mov al, es:[di+bx]
			push ds
				lds si, scr
				add si, di
				mov ds:[si], al
			pop ds

			inc di
			dec cx
			jnz @Loop
		 end;}
		{setrgb (0, 0, 0, 0);}

		asm
			{ Check for retrace }
			{Mov   DX,3d4h+6
			@rt:
			in    AL,DX
			test  AL,1000b
			jnz   @rt
			@n_rt:
			in    AL,DX
			test  AL,1000b
			jz    @n_rt}

			{ Copy the screen }
			mov ax, 0A000h
			mov es, ax
			xor di, di

			push ds
				lds si, scr

				mov cx, 16384
				db $66; rep movsw
			pop ds
		 end;

		inc (f);
		getpos;
		frame := 64*track + row;
	until keypressed or (frame >= lastframe1);

	if keypressed then
		readkey;

	move ((@smile64)^, scr^, 4096);
	for i := 0 to 65535 do
		vscr[i] := scr^[(i and 255) and 63 + ((i div 256) and 63)*64];
	pic^ := vscr;

	repeat
		for i := 0 to 65535 do
			scr^[i] := pic^[i + wtabx^[i + f*8] + wtaby^[i + f*256*8]*256];
		asm
			mov ax, 0A000h
			mov es, ax
			xor di, di

			push ds
				lds si, scr

				mov cx, 16384
				db $66; rep movsw
			pop ds
		 end;

		inc (f);
		getpos;
		frame := 64*track + row;
	until keypressed or (frame >= lastframe2);

	if keypressed then
		readkey;

	move ((@smile64)^, scr^, 4096);
	for i := 0 to 65535 do
		vscr[i] := scr^[(i and 255) div 4 + ((i div 256) div 4)*64];
	pic^ := vscr;

	repeat
		getpos;
		if row and 15 = 0 then
		 begin
			if row and 32 = 0 then
			 begin
				move ((@smile64)^, scr^, 4096);
				for i := 0 to 65535 do
					vscr[i] := scr^[(i and 255) div 4 + ((i div 256) div 4)*64];
				pic^ := vscr;
			 end
			else
			 begin
				move ((@smile64)^, scr^, 4096);
				for i := 0 to 65535 do
					vscr[i] := scr^[(i and 255) and 63 + ((i div 256) and 63)*64];
				pic^ := vscr;
			 end;
		 end
		else
			for i := 0 to 65535 do
				scr^[i] := pic^[i + wtabx^[i + f*8] + wtaby^[i + f*256*8]*256];
		asm
			mov ax, 0A000h
			mov es, ax
			xor di, di

			push ds
				lds si, scr

				mov cx, 16384
				db $66; rep movsw
			pop ds
		 end;

		inc (f);
		getpos;
		frame := 64*track + row;
		if frame > lastframe3 - 64 then
		 begin
			j := lastframe3 - frame;
			for i := 0 to 255 do
				setrgb (i, mini(j, (i div 2) and 63), mini(j, (i div 2) and 63), mini(j, i div 8));
		 end;
	until keypressed or (frame >= lastframe3);

	if keypressed then
		readkey;
end;

end.