
#include "pump.h"


byte *GL_ShadeTable, *GL_ShadeTablePtr;
byte GL_Pal[768];
byte *GL_WorkScreen;

XTRN_TStack GL_Stack;

// ----------------------------------------

PRIVATE void DoHandle(void) {
    VBL_FadeHandler();
    DVT_CallMusic();
}

PRIVATE void VBLHandler(void) {
    XTRN_StackExec(&GL_Stack, DoHandle);
}

extern void FinishProgram(void) {
    VBL_Done();
    POLY_EndShadeTable();
    LLK_End();
    LLS_End();
    LLK_BIOSFlush();

}

void *fload(char *fname) {
    unsigned int len;
    void *buf;

    len = JCLIB_FileSize(fname);
    buf = NEW(len);
    if (buf == NULL)
        BASE_Abort("fload");
    JCLIB_Load(fname, buf, len);
    return buf;
}


void main(int argc, char *argv[]) {

    ArgC = argc;
    ArgV = argv;

    if (BASE_CheckArg("win") > 0 || getenv("windir") != NULL)
        VBL_CompatibleMode = 70;

    REQUIRE(JCLIB_Init("pump.exe"));

    InitSinCos();
    POLY_InitDivTable();
    LLK_Init();
    XTRN_InitStack(&GL_Stack, 0x2000);

    GL_ShadeTable = NEW(32*256+255);
    if (GL_ShadeTable == NULL)
        BASE_Abort("Alloc ShadeTable");

    GL_ShadeTablePtr = (byte*)(((dword)GL_ShadeTable + 255) & ~255);
    POLY_InitShadeTable(GL_ShadeTablePtr);

    LLS_Init(LLSM_VIRTUAL, LLSVM_MODE13);
    VGA_ZeroPalette();
    GL_WorkScreen = NEW(LLS_Size);
    if (GL_WorkScreen == NULL)
        BASE_Abort("Alloc Workscreen");
    JCLIB_Load("pal.clr", GL_ShadeTablePtr, 32*256);
    JCLIB_Load("pal.pal", GL_Pal, 3*256);
    DRW_TranslatePtr = GL_ShadeTablePtr;

    VBL_Init(0);

    InitTun();
    InitDForm();

    DVT_Init();
    if (DVTInfo == NULL)
        BASE_Abort("DemoVT must be present");

    VBL_FullHandler = VBLHandler;
    DVT_JumpPos(1,1);
    DVT_BeginSync();
    DVT_WaitForStart();
    {
        DoDForm();
        if (LLK_SpacePressed == kESC)
            goto Fin;
        if (LLK_SpacePressed == kSPACE)
            DVT_MiddleSync(255, 6, 1);
        LLK_SpacePressed = 0;
    }
    {
        DoTun();
        if (LLK_SpacePressed == kESC)
            goto Fin;
        if (LLK_SpacePressed == kSPACE)
            DVT_MiddleSync(255, 11, 1);
        LLK_SpacePressed = 0;
    }
    {
        DoPlasma();
        if (LLK_SpacePressed == kESC)
            goto Fin;
        if (LLK_SpacePressed == kSPACE) {
            DVT_MiddleSync(255, 14, 32);
            DVTInfo->semaphores[3]++;   // Yann: Sin esto se queda 'bloqueado'
                                        //  al principio del phong!!!!!
        }
        LLK_SpacePressed = 0;
    }
//    DoLinTun();
//    F1Init();
//    F1Do1();
    {
        DoPhong();
        if (LLK_SpacePressed == kESC)
            goto Fin;
        if (LLK_SpacePressed == kSPACE)
            DVT_MiddleSync(255, 19, 1);
        LLK_SpacePressed = 0;
    }
    {
        InitRotblur();
        DoRotblur();
        if (LLK_SpacePressed == kESC)
            goto Fin;
        if (LLK_SpacePressed == kSPACE)
            DVT_MiddleSync(255, 24, 1);
        LLK_SpacePressed = 0;
    }
    {
        SHOW_Do();
        if (LLK_SpacePressed == kESC)
            goto Fin;
        if (LLK_SpacePressed == kSPACE)
            DVT_MiddleSync(255, 27, 1);
        LLK_SpacePressed = 0;
    }
    {
        SHOW2_Do();
        if (LLK_SpacePressed == kESC)
            goto Fin;
        if (LLK_SpacePressed == kSPACE)
            DVT_MiddleSync(255, 28, 58);
        LLK_SpacePressed = 0;
    }
    EPILEPSIA_Do();

  Fin:
    FinishProgram();

    //printf("%d, %d\n", (int)DVTInfo->seq, (int)DVTInfo->pos);
}

