
#include "pump.h"

#include <math.h>

#define PI 3.141592687

PRIVATE byte (*BlurTable)[256] = NULL;

PRIVATE byte *b1, *b2;

void InitRotblur(void) {
    int i, j;

    BlurTable = NEW(256*256);
    if (BlurTable == NULL)
        BASE_Abort("Alloc BlurTable");

    for (i = 0; i < 256; i++)
        for (j = 0; j < 256; j++) {
//            int c = (i*200+55*j)/256;
//            int c = (i*255+0*j)/256;
//            int c = (i*150+100*j)/256;
            int c = (i*170+82*j)/256;
            if (c > 63)
                c = 63;
            BlurTable[i][j] = c;
        }
}

extern void RB_DoRaster(byte *dest, const byte *org, const byte (*table)[256],
                        sint32 sx, sint32 sy);
#pragma aux RB_DoRaster parm [EDI] [ESI] [EBX] [EDX] [ECX]
extern sint32 RB_Dx, RB_Dy;

void DrawRotBlur(byte *dest, const byte *org, sint32 rad, word angle, word cang) {
    sint32 x, y, dx, dy;
    double c, s;
    int i, j;

/*
    dx = FPMult(rad, Cos(angle));
    dy = FPMult(rad, Sin(angle));
*/
    c = cos(angle*PI/32768.0);
    dx =  (double)rad*c;
    s = sin(angle*PI/32768.0);
    dy = -(double)rad*s;
    x = -160*dx/160 - (-100*dy/160);
    y = -160*dy/160 - ( 100*dx/160);
    c = cos(cang*PI/32768.0);
    s = sin(cang*PI/32768.0);
    x += c*rad/100;
    y += s*rad/100;

    dx /= 160;
    dy /= 160;

    RB_Dx = dx;
    RB_Dy = dy;

    for (i = 0; i < 200; i++) {
/*
        sint32 sx = x;
        sint32 sy = y;
        for (j = 0; j < 320; j++) {
            byte c = org[(sy >> 16)*512 + (sx >> 16)];
            *dest = BlurTable[c][*dest];
            dest++;
            sx += dx;
            sy += dy;
        }
*/
        RB_DoRaster(dest, org-256*512-256, BlurTable, x, y);
        dest += 512;
        x -= dy;
        y += dx;
    }
}


void DrawDot(byte *dest, int x, int y, int r) {
    static byte Shape[10][10] = {
/*
        {  0,  0,  0,  5, 15, 15,  5,  0,  0,  0},
        {  0,  5, 10, 15, 20, 20, 15, 10,  5,  0},
        {  0, 10, 15, 25, 30, 30, 25, 15, 10,  0},
        {  5, 15, 25, 35, 40, 40, 35, 25, 15,  5},
        { 15, 20, 30, 40, 40, 40, 40, 30, 20, 15},

        { 15, 20, 30, 40, 40, 40, 40, 30, 20, 15},
        {  5, 15, 25, 35, 40, 40, 35, 25, 15,  5},
        {  0, 10, 15, 25, 30, 30, 25, 15, 10,  0},
        {  0,  5, 10, 15, 20, 20, 15, 10,  5,  0},
        {  0,  0,  0,  5, 15, 15,  5,  0,  0,  0},
*/
        {  0,  0,  0,  5, 15, 15,  5,  0,  0,  0},
        {  0,  5, 10, 15, 20, 20, 15, 10,  5,  0},
        {  0, 10, 15, 25, 35, 35, 25, 15, 10,  0},
        {  5, 15, 25, 40, 40, 40, 40, 25, 15,  5},
        { 15, 20, 35, 40, 40, 40, 40, 35, 20, 15},

        { 15, 20, 35, 40, 40, 40, 40, 35, 20, 15},
        {  5, 15, 25, 40, 40, 40, 40, 25, 15,  5},
        {  0, 10, 15, 25, 35, 35, 25, 15, 10,  0},
        {  0,  5, 10, 15, 20, 20, 15, 10,  5,  0},
        {  0,  0,  0,  5, 15, 15,  5,  0,  0,  0},
    };
    int i, j;

    x += 256 - r/2;
    y += 256 - r/2;
    for (i = 0; i < 10; i++)
        for (j = 0; j < 10; j++) {
            byte c = dest[x+j + (y+i)*512] + Shape[i][j];
            if (c > 63)
                c = 63;
            dest[x+j + (y+i)*512] = c;
        }
}


void UpdateBlur(sint32 rad, word rot, word cang) {
    int i;
    DrawRotBlur(b2 + (512-200)/2*512 + (512-320)/2,
                b1 + 512*256         + 256,
                rad, rot, cang);
    for (i = 0; i < 200; i++)
        RepMovsb(LLS_Screen[i], b2 + ((512-200)/2+i)*512 + (512-320)/2, 320);
    {
        byte *t; t = b1; b1 = b2; b2 = t;
    }
}

void DoRotblur(void) {
    byte pal[768];
    int i;
    word a0, a1, a2, a3, a4;
    dword t;
    int state = 0;

    REQUIRE( (b1 = NEW(512*512)) != NULL);
    REQUIRE( (b2 = NEW(512*512)) != NULL);
    MemSetD(b1, 0, 512*512);
    MemSetD(b2, 0, 512*512);
    MemSetD((void *)0xA0000, 0, 64000);

    for (i = 0; !LLK_SpacePressed && i < 4; i++) {
        while (!LLK_SpacePressed && !DVTInfo->semaphores[5]);
        DVTInfo->semaphores[5]--;
        memset(pal, 63, 768);
        VBL_DumpPalette(pal, 0, 256);
        VBL_DestPal = NULL;
        VBL_DestRed = VBL_DestBlue = VBL_DestGreen = 0;
        VBL_FadeMode = VBL_FADEFAST;
        VBL_FadeStartColor = 0;
        VBL_FadeNColors = 64;
        VBL_FadePos = 1;
        VBL_FadeSpeed = 4;
    }

    for (i = 0; i < 64; i++) {
        pal[i*3+0] = 63;
        pal[i*3+1] = 63;
        pal[i*3+2] =  0;
    }
    LLS_SetMode(LLSM_DIRECT, LLSVM_MODE13);
    VBL_DumpPalette(pal, 0, 256);

    for (i = 0; i < 64; i++) {
        pal[i*3+0] = i;
        pal[i*3+1] = 10 + i*(64-10)/64;
        pal[i*3+2] =  5 + i*(64- 5)/64;
    }

    VBL_DestPal = pal;
    VBL_FadeMode = VBL_FADEFAST;
    VBL_FadeStartColor = 0;
    VBL_FadeNColors = 64;
    VBL_FadePos = 1;
    VBL_FadeSpeed = 1;

    state = 0;
    a0 = a1 = a2 = a3 = a4 = 0;
    VBL_VSync(0);
    t = 0;
    while (!LLK_SpacePressed && t < 20*70) {
        int nf;
        switch(state) {
            case 0:
                for (i = 0; i < 10; i++)
                    DrawDot(b1, rand()%160 - 80, rand()%100 - 50, 10);
                if (t > 7*70)
                    state = 1;
                break;
            case 1: {
                sint32 cx, cy;

                cx = FPMult(55, Cos(a3)) + FPMult(55, Cos(a2));
                cy = FPMult(20, Sin(a3)) + FPMult(20, Sin(a2));
                //for (i = -5; i < 5; i++)
                //    DrawDot(b1, cx + FPMult(9*i, Sin(a2)), cy + FPMult(9*i, Cos(a2)), 10);
                for (i = 0; i < 0x00010000UL; i += 0x1000)
                    DrawDot(b1, cx + FPMult(FPMult(50,Cos(i)), Sin(a4)), cy + FPMult(FPMult(Sin(i), 50), Cos(a4)), 10);
                if (t > 19*70+7) {
                    state = 2;
                    VBL_DestPal = NULL;
                    VBL_DestRed = VBL_DestBlue = VBL_DestGreen = 0;
                    VBL_FadeMode = VBL_FADEFAST;
                    VBL_FadeStartColor = 0;
                    VBL_FadeNColors = 256;
                    VBL_FadePos = 1;
                    VBL_FadeSpeed = 1;
                }
                break;
            }
            case 2:
/*
                for (i = 1; i < 11; i++)
                    DrawDot(b1, FPMult(9*i, Cos(a2+4000*i)), FPMult(6*i, Sin(a2+4000*i)), 10);
*/
                break;
        }
        UpdateBlur((154 << 16) + FPMult(2 << 16, Sin(a0)),
                    FPMult(600, Sin(a1)), a2);
        nf = VBL_VSync(1);
        a0 += 150*nf;
        a1 += 100*nf;
        a2 += 257*nf;
        a3 += 203*nf;
        a4 += 500*nf;
        t += nf;
    }

    LLS_SetMode(LLSM_VIRTUAL, LLSVM_MODE13);
    DISPOSE(b1);
    DISPOSE(b2);
    DISPOSE(BlurTable);
}
