Unit EMS;

Interface

Function EMM_Installed:Boolean;

Implementation

uses Dos,Crt;
Type
  ST3  = string[3];
  ST80 = string[80];
  ST5  = string[5];

Const
  EMM_INT                    = $67;
  DOS_Int                    = $21;
  GET_PAGE_FRAME             = $41;
  GET_UNALLOCATED_PAGE_COUNT = $42;
  ALLOCATE_PAGES             = $43;
  MAP_PAGES                  = $44;
  DEALLOCATE_PAGES           = $45;
  GET_VERSION                = $46;
  STATUS_OK                  = 0;


  {------------------------------------------------------------}
  { Assume the application needs one EMM page.                 }
  {------------------------------------------------------------}
  APPLICATION_PAGE_COUNT = 1;

Var
  Regs: Registers;

  Emm_handle,
  Page_Frame_Base_Address,
  Pages_Needed,
  Physical_Page,
  Logical_Page,
  Offset,
  Error_Code,
  Pages_EMM_Available,
  Total_EMM_Pages,
  Available_EMM_Pages: Integer;

  Version_Number,
  Pages_Number_String: ST3;

  Verify: Boolean;

  {------------------------------------------------------------}
  { The function Hex_String converts an integer into a four    }
  { character hexadecimal number (string) with leading zeros.  }
  {------------------------------------------------------------}
  Function Hex_String (Number: Integer): ST5;
    Function Hex_Char (Number: Integer): Char;
      Begin
        If Number < 10 then
          Hex_Char := Char (Number + 48)
        else
          Hex_Char := Char (Number + 55);
      end; { Function Hex_char }

  Var
    S: ST5;

  Begin
    S := '';
    S := Hex_Char ((Number shr 1) div 2048);
    Number := (((Number shr 1) mod 2048) shl 1) + (Number and 1);
    S := S + Hex_Char (Number div 256);
    Number := Number mod 256;
    S := S + Hex_Char (Number div 16);
    Number := Number mod 16;
    S := S + Hex_Char (Number);
    Hex_String := S + 'h';
  end; { Function Hex_String }


  {------------------------------------------------------------}
  { The function Emm_Installed checks to see if the            }
  { EMM is loaded in memory.  It does this by looking          }
  { for the string 'EMMXXXX0', which should be located         }
  { at 10 bytes from the beginning of the code segment the     }
  { EMM interrupt, 67h, points to.                             }
  {------------------------------------------------------------}
  Function Emm_Installed: Boolean;
    Var
      Emm_Device_Name   : string[8];
      Int_67_Device_Name: string[8];
      Position          : integer;
      Regs              : registers;

    Begin
      Int_67_Device_Name := '';
      Emm_Device_Name    := 'EMMXXXX0';
      with Regs do
        Begin
          {----------------------------------------------------}
          { Get the code segment interrupt 67h points to       }
          { the EMM interrupt by using DOS function 35h.       }
          { (get interrupt vector)                             }
          {----------------------------------------------------}
          AH := $35;
          AL := EMM_INT;
          Intr (DOS_Int, Regs);
          {----------------------------------------------------}
          { The ES pseudo-register contains the segment        }
          { address pointed to by interrupt 67h.  Create an    }
          { eight character string from the eight successive   }
          { bytes at address ES:$000A (10 bytes from ES)       }
          {----------------------------------------------------}
          For Position := 0 to 7 do
            Int_67_Device_Name :=
              Int_67_Device_Name + Chr (mem[ES:Position + $0A]);
          Emm_Installed := True;
          {----------------------------------------------------}
          { If the string is the EMM manager signature,        }
          { 'EMMXXXX0', then EMM is installed and ready for    }
          { use.  If not, then EMM is not present.             }
          {----------------------------------------------------}
          If Int_67_Device_Name <> Emm_Device_Name
            then Emm_Installed := False;
        end; { with Regs do }
    end; { Function Emm_Installed }

End.

