
#include "pump.h"


#define CLR_LEVELS 32
byte tex[64*64];

#define NUMEDGES 10

typedef struct {
    sint32 r;
    sint32 l;
    sint32 sl, tx, ty;
    sint32 sx, sy;
} TEdgePoint;

typedef struct {
    sint32 cx, cy;
    TEdgePoint p[NUMEDGES];
} TTunSec;

#define MAXTUNZ     300000
#define SECTIONZ     20000
#define NUMSECTIONS (MAXTUNZ/SECTIONZ)

TTunSec Tunel[NUMSECTIONS];
int     MaxTunSec = -1, NTunSec = -1, TunZ = SECTIONZ;
bool    TunFull = FALSE;

#define LIGHT_LEVELS 31

PUBLIC void CalcLights(O3DM_PObject obj, dword ang) {
    int i;
    dword l;
    O3DM_PVertex pv;
    assert(obj != NULL);

    l = 0;
    pv = obj->verts;
    for (i = 0; i < obj->nVerts; i++, pv++, l += (5 << 10)) {
//        pv->l = (16 << 16) + FPMult(15 << 16, Sin(ang + l));
        pv->l = 0x1F0000 - (Pow2(pv->x >> 3) + Pow2(pv->y) >> 1) + FPMult(Sin(ang),0x3FF00);
        if (pv->l > 0x1F0000)
            pv->l = 0x1F0000;
        else if (pv->l < 0)
            pv->l = 0;
    }
}

void obj_test(O3DM_PObject obj, int lz, R3D_PAngles ang) {
    R3D_TPosVector pos = { 000, 000, 10000 };
    R3D_TRotMatrix rm;

//        memset(LLS_Screen[0], 0, LLS_Size);
        pos[2] = lz;
        R3D_Gen3DMatrix(&rm, ang);
        O3DM_RotateObjVerts(obj, &rm);
        O3DM_RotateObjNormals(obj, &rm);
        O3DM_TranslateObj(obj, &pos);
        O3DM_ProjectObject(obj);
        O3DM_ParseVisibility(obj);
        CalcLights(obj, ang[1]);
        O3DM_Draw(obj);
}

PRIVATE O3DM_PObject obj[8];
PRIVATE byte *Pal = NULL, *Clr = NULL;

PUBLIC void InitTun(void) {
    int i;
    for (i = 0; i < SIZEARRAY(obj); i++) {
        char buf[100];
        sprintf(buf, "crdt%d.i3d", i);
        obj[i] = O3DM_LoadObject(buf);
        if (obj == NULL)
            BASE_Abort("No se puede cargar el objeto %d", buf);
    }
    Pal = NEW(768);
    Clr = NEW(32*256);
    JCLIB_Load("tuntex1.pix", tex, sizeof(tex));
    JCLIB_Load("tuntex1.pal", Pal, 768);
    JCLIB_Load("tuntex1.clr", Clr, 32*256);
}


PRIVATE void DoIt(void) {
    int nf;
    int i;
    int lz = 300000, nobj = 0;;
    R3D_TAngles ang = {0, 0, 0};
    bool fading = FALSE;

    MemSetD(LLS_Screen, 0x3F3F3F3F, LLS_Size);

//    POLY_MinX = 20;
//    POLY_MaxX = 300;
//    POLY_MinY = 20;
//    POLY_MaxY = 180;
    POLY_MinY = 20;
    POLY_MaxY = 180;
    LLS_UpdateMinY = POLY_MinY;
    LLS_UpdateMaxY = POLY_MaxY;

    R3D_FocusX = 2*256;
    R3D_FocusY = 2*256*5/6;

    while (LLK_SpacePressed == 0) {
        int i, j, k;

        MemSetD(LLS_Screen, 0x3F3F3F3F, LLS_Size);

        {
            sint32 z, pz;

            z = MAXTUNZ - 2*SECTIONZ + TunZ;
            if (MaxTunSec < NUMSECTIONS)
                i = MaxTunSec;
            else
                i = NTunSec;
            for (j = 0; j < MaxTunSec; j++, i = (i+NUMSECTIONS-1)%NUMSECTIONS) {
                sint32 x, y;
                if (z < 256)
                    pz = 256;
                else
                    pz = z;
                for (k = 0; k < NUMEDGES; k++) {
                    sint32 dl;
                    x = Tunel[i].cx + FPMult(3*Tunel[i].p[k].r, Cos(k*65536/NUMEDGES+i*100));
//                    x = Tunel[i].cx + (k-NUMEDGES/2)*0x4000;
                    Tunel[i].p[k].sx = 160 + FPMultDiv(x, 256, pz);
                    y = Tunel[i].cy + FPMult(Tunel[i].p[k].r, Sin(k*65536/NUMEDGES+i*100));
//                    y = Tunel[i].cy + Tunel[i].p[k].r;
                    Tunel[i].p[k].sy = 100 + FPMultDiv(y, 256, pz);
//                    Tunel[i].p[k].sy = 50 + FPMultDiv(y, 256, pz);
                    if (pz < MAXTUNZ/3)
                        Tunel[i].p[k].sl = Tunel[i].p[k].l;
                    else
                        Tunel[i].p[k].sl = FPMultDiv(Tunel[i].p[k].l, MAXTUNZ - pz, MAXTUNZ - MAXTUNZ/3);
                    if (nobj < SIZEARRAY(obj)) {
                        dl = 0x1F0000 - FPMultDiv(0x1F0000,
                                       Abs32(pz-lz),
                                       SECTIONZ);
                        if (Tunel[i].p[k].sl+dl > 0x1F0000)
                            Tunel[i].p[k].sl = 0x1F0000;
                        else if (dl >= 0)
                           Tunel[i].p[k].sl += dl;
                    }
                }
                z -= SECTIONZ;
            }

            if (MaxTunSec < NUMSECTIONS)
                i = MaxTunSec;
            else
                i = NTunSec;
            for (j = 1; j < MaxTunSec; j++, i = (i+NUMSECTIONS-1)%NUMSECTIONS) {
                for (k = 0; k < NUMEDGES; k++) {
//                for (k = 0; k < NUMEDGES-1; k++)
                    sint32 kk, i1;
                    kk = (k+1)%NUMEDGES;
                    i1 = (i+NUMSECTIONS-1)%NUMSECTIONS;
                    POLY_ScrapPoly[0].x = Tunel[i].p[k].sx;
                    POLY_ScrapPoly[0].y = Tunel[i].p[k].sy;
                    POLY_ScrapPoly[0].l = Tunel[i].p[k].sl;
                    POLY_ScrapPoly[0].tx = 0;
                    POLY_ScrapPoly[0].ty = 0;
                    POLY_ScrapPoly[1].x = Tunel[i].p[kk].sx;
                    POLY_ScrapPoly[1].y = Tunel[i].p[kk].sy;
                    POLY_ScrapPoly[1].l = Tunel[i].p[kk].sl;
                    POLY_ScrapPoly[1].tx = 64*POLY_TSMULT;
                    POLY_ScrapPoly[1].ty = 0;
                    POLY_ScrapPoly[2].x = Tunel[i1].p[kk].sx;
                    POLY_ScrapPoly[2].y = Tunel[i1].p[kk].sy;
                    POLY_ScrapPoly[2].l = Tunel[i1].p[kk].sl;
                    POLY_ScrapPoly[1].tx = 0;
                    POLY_ScrapPoly[1].ty = 64*POLY_TSMULT;
//                    if (!fading) {
                        POLY_ShadeTexDraw(POLY_ScrapPoly, 3, tex);
/*
                    } else {
                        POLY_Line(POLY_ScrapPoly[0].x, POLY_ScrapPoly[0].y,
                                  POLY_ScrapPoly[1].x, POLY_ScrapPoly[1].y,
                                  23);
                        POLY_Line(POLY_ScrapPoly[1].x, POLY_ScrapPoly[1].y,
                                  POLY_ScrapPoly[2].x, POLY_ScrapPoly[2].y,
                                  23);
                        POLY_Line(POLY_ScrapPoly[2].x, POLY_ScrapPoly[2].y,
                                  POLY_ScrapPoly[0].x, POLY_ScrapPoly[0].y,
                                  23);
                    }
*/
                    POLY_ScrapPoly[0].x = Tunel[i].p[k].sx;
                    POLY_ScrapPoly[0].y = Tunel[i].p[k].sy;
                    POLY_ScrapPoly[0].l = Tunel[i].p[k].sl;
                    POLY_ScrapPoly[0].tx = 0;
                    POLY_ScrapPoly[0].ty = 0;
                    POLY_ScrapPoly[1].x = Tunel[i1].p[kk].sx;
                    POLY_ScrapPoly[1].y = Tunel[i1].p[kk].sy;
                    POLY_ScrapPoly[1].l = Tunel[i1].p[kk].sl;
                    POLY_ScrapPoly[1].tx = 0;
                    POLY_ScrapPoly[1].ty = 64*POLY_TSMULT;
                    POLY_ScrapPoly[2].x = Tunel[i1].p[k].sx;
                    POLY_ScrapPoly[2].y = Tunel[i1].p[k].sy;
                    POLY_ScrapPoly[2].l = Tunel[i1].p[k].sl;
                    POLY_ScrapPoly[2].tx = 64*POLY_TSMULT;
                    POLY_ScrapPoly[2].ty = 64*POLY_TSMULT;
//                    if (!fading)
                        POLY_ShadeTexDraw(POLY_ScrapPoly, 3, tex);
                }
            }
        }

        ang[1] = 0;
        ang[0] = ang[2] = lz >> 3;
        if (nobj < SIZEARRAY(obj))
            obj_test(obj[nobj], lz, ang);

/*
        for (i = 0; i < DVTInfo->numChannels; i++) {
            if (DVTInfo->chansTrig[i]) {
                if (DVTInfo->chansData[i].ins == 9 || DVTInfo->chansData[i].ins == 9) {
*/
        if (DVTInfo != NULL) {
            if (!fading) {
                if (DVTInfo->semaphores[1] || DVTInfo->semaphores[2]) {
                    byte buf[768];
                    memset(buf, 63, 768);
                    VBL_DumpPalette(buf, 0, 256);
                    VBL_DestPal = GL_Pal;
                    VBL_FadeMode =  VBL_FADEFAST;
                    VBL_FadeStartColor = 0;
                    VBL_FadeNColors = 256;
                    VBL_FadePos = 1;
                    VBL_FadeSpeed = 8;
                }
                DVTInfo->semaphores[1] = DVTInfo->semaphores[2] = 0;
            }
            DVTInfo->chansTrig[i] = 0;
        }

        nf = VBL_VSync(1);
        LLS_Update();

        while (nf-- > 0) {
            lz -= 2*1024;
            if (lz < 1024) {
                nobj++;
                lz = 300000;
            }
            TunZ -= 2*512;
            if (TunZ < 0) {
                TunZ += SECTIONZ;
                if (MaxTunSec < NUMSECTIONS)
                    MaxTunSec++;
                NTunSec = (NTunSec+1)%NUMSECTIONS;
                Tunel[NTunSec].cx = (rand() & 0x1FFF)-0x1000;
                Tunel[NTunSec].cy = (rand() & 0x1FFF)-0x1000;
                for (k = 0; k < NUMEDGES; k++) {
                    Tunel[NTunSec].p[k].r = 0x3000 + (rand() % 0x1500);
                    Tunel[NTunSec].p[k].l = ((rand() << 10) % (0x1F0000-0x100000)) + 0x40000;
                }
            }
        }
        if (!fading && nobj > SIZEARRAY(obj)) {
            VBL_DestPal = NULL;
            VBL_DestRed = VBL_DestGreen = VBL_DestBlue = 0;
            VBL_FadeMode =  VBL_FADEFAST;
            VBL_FadeStartColor = 0;
            VBL_FadeNColors = 256;
            VBL_FadePos = 1;
            VBL_FadeSpeed = 1;
            fading = TRUE;
        }

        if (fading && VBL_FadePos == 0)
            break;
    }
    for (i = 0; i < SIZEARRAY(obj); i++)
        O3DM_DeleteObject(obj[i]);
}

PUBLIC void DoTun(void) {

    memset(LLS_Screen[0], 0, LLS_Size);
    LLS_Update();

    memcpy(GL_Pal, Pal, 768);
    memcpy(GL_ShadeTablePtr, Clr, 32*256);
    VBL_DestPal = GL_Pal;
    VBL_FadeStartColor = 0;
    VBL_FadeNColors = 256;
    VBL_FadeMode =  VBL_FADEFAST;
    VBL_FadePos = 1;
    VBL_FadeSpeed = 4;
    memset(Pal, 63, 768);
    VBL_DumpPalette(Pal, 0, 256);
    DISPOSE(Pal);
    DISPOSE(Clr);

    DoIt();
    LLS_UpdateMinY = 0;
    LLS_UpdateMaxY = LLS_SizeY;
}

