;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; Real 2 SuperReal Demo June/July 1995                                    ;
; SuperReal (our first SVGA demo)                                         ;
;                                                                         ;
; 3d engine                                                               ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ideal
p386
model flat
stack 4000h
codeseg

extrn debug           : near
Zero_Addr             dd ?
Environment_Address   dd ?
PSP_Address           dd ?
_0B8000h              dd ?
_0A0000h              dd ?

include "..\sine.asm"
include "..\vesa_l.asm"
include "..\r2sr_l.asm"
include "pg3asm.asm"

three_show_pal:
  X = 16 * 256
rept 63
  db                  (X / 256),(X / 256),(X / 256)
  X = X + 80h
endm

test_data1:
include "prism2.txt"

sample_info:
dd 80
dd 0,-100,0
dd 0,0,0
dd 2000
dd 640/2
dd 480/2

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc threed_show_ani
  mov    esi,offset three_show_pal
  mov    ecx,64*3
  mov    al,1
  @WritePalette

  mov    edx,(size tfacet_sort)*300
  mov    eax,0EE42h         ; allocate a DOS32 memory block
  Int    31h                ;  expects EDX = size; ret EAX=size, EDX->pointer
  mov    [_facet_sort],edx

  mov    edx,(size ttranstrifacet)*300
  mov    eax,0EE42h         ; allocate a DOS32 memory block
  Int    31h                ;  expects EDX = size; ret EAX=size, EDX->pointer
  mov    [_transformed],edx

  mov    eax,offset sample_info
  push   eax
  mov    eax,offset test_data1
  push   eax
  call   _calc_normals
  add    esp,8
@@l:
  call   clear_screen

  mov    eax,offset sample_info
  push   eax
  mov    eax,offset test_data1
  push   eax
  call   _paint_world
  add    esp,8
  mov    esi,offset sample_info
  add    [esi+tg3d_info.vangles.x],10
  add    [esi+tg3d_info.vangles.y],10
  add    [esi+tg3d_info.vangles.z],10

  mov    esi,[Rendbuff]
  call   update_screen

  call   key_pressed2
  jnc    @@l
  call   get_key
  cmp    al,27
  jne    @@l

  mov    eax,0EE40h
  int    31h
  mov    eax,0EE40h
  int    31h
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Start_gztrap:
  call   debug
  cld
  mov    eax,0EE02h      ; get DOS32 address information
  int    31h
  neg    ebx
  mov    [Zero_Addr],ebx
  add    ebx,0A0000h
  mov    [_0A0000h],ebx
  add    ebx,0B8000h-0A0000h
  mov    [_0B8000h],ebx
  mov    [Environment_Address],edi
  mov    [PSP_Address],esi

  call   setup_vesa

  call   threed_show_ani

  mov    eax,3h
  int    10h
  mov    eax,4c00h
  int    21h
ends

end Start_gztrap
