;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; Real 2 SuperReal Demo June/July 1995                                    ;
; SuperReal (our first SVGA demo)                                         ;
;                                                                         ;
; 3d engine                                                               ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

public                _sine
public                _cose
public                _sqrt
public                _write_line
extrn                 _calc_normals : near ;((char *)&prism1_data);
extrn                 _paint_world : near ;((char *)&prism1_data);
extrn                 _poly_l_clip : dword
extrn                 _poly_r_clip : dword
extrn                 _poly_t_clip : dword
extrn                 _poly_b_clip : dword
extrn                 _facet_sort : dword
extrn                 _transformed : dword
extrn                 _threed_pal_base : byte
extrn                 _threed_pal_size : byte
extrn                 _facet_sort : dword;
extrn                 _testbase : near

proc _sine
  mov    eax,[esp+4]
  @find_sine
  ret
endp

proc _cose
  mov    eax,[esp+4]
  @find_cosine
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;ͻ
; returns EAX with the SQUARE ROOT of EAX.                        
;                                                                 
; Uses newtons method:    Xn+1 = Xn -  f(Xn) / f'(Xn)             
;    f'(x) is the derivitive of f(x)                              
;                                                                 
; For square routes:  f(x) = x*x - ( Root value  i.e EAX)         
;  so     f'(x) = 2x                                              
;                                                                 
; For cube routes:  f(x) = x*x*x - ( Root value )                 
;  so     f'(x) = 3x                                              
;ͼ$
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc _sqrt
  mov    eax,[esp+4]
  push   ebp edi
  mov    edi,eax
  bsr    ecx,edi
  shr    cl,1
  mov    ebp,edi
  shr    ebp,cl
@@calc_sqrt_Loop:
  push   EBP
  mov    EBX,EBP
  shl    EBX,1
  mov    EAX,EBP
  mul    EBP
  sub    EAX,EDI
  sbb    EDX,0
  idiv   EBX
  sub    EBP,EAX
  pop    EAX
  cmp    EBP,EAX
  jne    @@calc_sqrt_Loop
  mov    eax,ebp
  pop    edi ebp
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; write_line(vline+xl,x_len,Crun,Crun_grad);                              ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
struc write_line_sk
  caller              dd ?
  addr                dd ?
  len                 dd ?
  Crun                dd ?
  Crun_grad           dd ?
ends

proc _write_line
  mov    eax,esp
  push   ebp esi edi
  mov    ebp,eax

  mov    ecx,[ebp+write_line_sk.len]
  cmp    ecx,0
  jle    @@end
  mov    edi,[ebp+write_line_sk.addr]
  add    edi,[Rendbuff]
  mov    edx,[ebp+write_line_sk.Crun]
  mov    esi,[ebp+write_line_sk.Crun_grad]
@@l:
  mov    eax,edx
  sar    eax,16
  mov    [edi],al
  inc    edi
  add    edx,esi
  dec    ecx
  jnz    @@l
@@end:
  pop    edi esi ebp
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
struc tvector
  x                   dd ?
  y                   dd ?
  z                   dd ?
ends

struc tGvector
  c                   dd ?
  x                   dd ?
  y                   dd ?
ends

struc tfacet_sort
  index               dd ?
  Z_average           dd ?
ends

struc ttranstrifacet
  p1                  tGvector <>
  p2                  tGvector <>
  p3                  tGvector <>
ends

struc tg3d_info
  NO_OF_SIDES         dd ?
  lightsource         tvector <>
  vangles             tvector <>
  scale               dd ?
  xpos                dd ?
  ypos                dd ?
ends

