;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; REAL 2 SuperReal Demo June/July 1995                                    ;
; SuperReal (my first SVGA demo)                                          ;
;                                                                         ;
; by Jason Nunn(JsNO)                                                     ;
;                                                                         ;
; Contacts:                                                               ;
;                                                                         ;
; Email: jsno@turtle.apana.org.au or root@superr.apana.org.au             ;
; Snail: 32 Rothdale Rd,Darwin,NT,0810,Australia                          ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ideal
p386
model flat
stack 4000h
codeseg

extrn debug           : near
Zero_Addr             dd ?
Environment_Address   dd ?
PSP_Address           dd ?
_0B8000h              dd ?
_0A0000h              dd ?
dma_buffer            dd ?

; data
include "funklite.asm"
include "sine.asm"
include "vesa_l2.asm"
include "r2sr_l.asm"
include "3d\pg3asm.asm"

FX_OCTAVE             = 1

ATTENTION_EFFECT      = 0ch ; sample
DOORSHUT_EFFECT       = 0dh
LAZER_EFFECT          = 0eh
SHIPBUZZ_EFFECT       = 0fh
DOORSHUT2_EFFECT      = 10h
MAINEXP3_EFFECT       = 12h
MAINEXPL_EFFECT       = 12h

ATTENTION_CHAN        = 8
DOORSHUT_CHAN         = 8
LASER_CHAN            = 8  ; NB/ takes up X chan and X+1 chan
SHIPBUZZ_CHAN         = 9
DOORSHUT2_CHAN        = 8
MAINEXP3_CHAN         = 8
MAINEXPL_CHAN         = 10 ; NB/ takes up X chan and X+1 chan

extrn gfx             : dword
extrn music           : dword

ISR_event             db ?
ISR_pc                dd ?

pic_mt1               dd ?
angle1                dd 0
angle2                dd 0
scaler1               dd 0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
START_SIZE            = 4000
start_pic             dd ?

LOGO_SIZE             = 125381
logo_pic              dd ?
logo_pal              dd ?

FONT_SIZE             = 39299
font_pic              dd ?
font_pal:
  db  11, 14, 14, 20, 25, 25, 20, 25, 25, 21, 26, 26
  db  22, 27, 27, 23, 28, 28, 24, 28, 28, 25, 29, 29, 26, 30, 30, 27, 31, 31
  db  27, 32, 32, 28, 32, 32, 29, 33, 33, 30, 34, 34, 31, 35, 35, 32, 35, 35
  db  33, 36, 36, 33, 37, 37, 34, 38, 38, 35, 38, 38, 36, 39, 39, 37, 40, 40
  db  38, 41, 41, 39, 41, 41, 39, 42, 42, 40, 43, 43, 41, 44, 44, 42, 45, 45
  db  43, 45, 45, 44, 46, 46, 45, 47, 47, 46, 48, 48
font_pal_size =$-font_pal

TEXT00_SIZE           = 66308
text00_pic            dd ?
text00_pal            dd ?

MERG_1_SIZE           = 66308
merg_1_pic            dd ?
merg_1_pal            dd ?

MERG_2_SIZE           = 65540
merg_2_pic            dd ?

INTRO_1_SIZE          = 125637
intro_1_pic           dd ?
intro_1_pal           dd ?

INTRO_2_SIZE          = (133*133)+4
intro_2_pic           dd ?

INTRO_3_SIZE          = (485*063)+4
intro_3_pic           dd ?

LITCH_F_SIZE          = 330156
litch_f_pic           dd ?
litch_f_pal           dd ?

FIRST_SIZE            = 39512
first_pic             dd ?
first_pal             dd ?

ANIROCKET_SIZE        = 1492
anirocket_pal:
  db  28, 24, 14, 30, 28, 21, 32, 32, 29, 35, 35, 37, 37, 39, 44
  db  23, 23, 23, 26, 26, 26, 29, 29, 29, 63, 63, 63, 60, 60, 63, 57, 57, 63
  db  54, 54, 63, 51, 51, 63, 48, 48, 63, 45, 45, 63, 42, 42, 63, 39, 39, 63
  db  36, 36, 63, 33, 33, 63, 30, 30, 63, 27, 27, 63
r_a_pic               dd ?
r_b_pic               dd ?

arcade_pal:
  db   0,  0,  0,  2,  2,  2,  5,  5,  5,  8,  8,  8, 11, 11, 11, 15, 15, 15
  db  18, 18, 18, 21, 21, 21, 24, 24, 24, 28, 28, 28, 31, 31, 31, 34, 34, 34
  db  38, 38, 38, 41, 41, 41, 44, 44, 44, 47, 47, 47, 51, 51, 51,  0,  0,  0
  db   0,  0,  4,  0,  0,  9,  0,  0, 13,  0,  0, 18,  0,  0, 22,  0,  0, 27
  db   0,  0, 32,  0,  0, 36,  0,  0, 41,  0,  0, 45,  0,  0, 50,  0,  0, 54
  db   0,  0, 59,  0,  0, 63,  0,  0,  0,  4,  0,  0,  8,  0,  0, 12,  0,  0
  db  16,  0,  0, 20,  0,  0, 24,  0,  0, 28,  0,  0, 32,  0,  0, 35,  0,  0
  db  39,  0,  0, 43,  0,  0, 47,  0,  0, 51,  0,  0, 55,  0,  0, 59,  0,  0
  db  63,  0,  0,  0,  0,  0,  4,  4,  0,  9,  9,  0, 13, 13,  0, 18, 18,  0
  db  22, 22,  0, 27, 27,  0, 32, 32,  0, 36, 36,  0, 41, 41,  0, 45, 45,  0
  db  50, 50,  0, 54, 54,  0, 59, 59,  0, 63, 63,  0,  0,  0,  0,  6,  3,  8
  db  12,  6, 15, 19, 10, 23, 25, 13, 31, 32, 17, 39, 38, 20, 47, 44, 23, 55
  db  51, 27, 63,  0,  0,  0,  0,  5,  0,  0, 10,  0,  1, 15,  1,  1, 20,  1
  db   1, 25,  1,  1, 30,  1,  2, 35,  2,  2, 40,  2,  2, 46,  2,  3, 51,  3
  db  15, 15, 63, 27, 15, 63, 39, 15, 63, 51, 15, 63, 63, 15, 63, 63, 15, 51
  db  63, 15, 39, 63, 15, 27, 63,  3, 15, 63,  3,  3, 63, 15,  3, 63, 27,  3
  db  63, 39,  3, 63, 51,  3, 63, 63,  3, 51, 63,  3, 39, 63,  3, 27, 63,  3
  db  15, 63,  3,  3, 63,  3,  3, 63, 15,  3, 63, 27,  3, 63, 39,  3, 63, 51
  db   3, 63, 63,  3, 51, 63,  3, 39, 63,  3, 27, 63,  3, 15, 63,  3,  3, 63
  db  15,  3, 63, 27,  3, 63, 39,  3, 63, 51,  3, 63, 63,  3, 63, 63,  3, 51
  db  63,  3, 39, 63,  3, 27, 51,  3, 15, 51,  3,  3, 51, 15,  3, 51, 27,  3
  db  51, 39,  3, 51, 51,  3, 39, 51,  3, 27, 51,  3, 15, 51,  3,  3, 51,  3
  db   3, 51, 15,  3, 51, 27,  3, 51, 39,  3, 51, 51,  3, 39, 51,  3, 27, 51
  db   3, 15, 51,  3,  3, 51, 15,  3, 51, 27,  3, 51, 39,  3, 51, 51,  3, 51
  db  51,  3, 39, 51,  3, 27, 39,  3, 15, 39,  3,  3, 39, 15,  3, 39, 27,  3
  db  39, 39,  3, 27, 39,  3, 15, 39,  3,  3, 39,  3,  3, 39, 15,  3, 39, 27
  db   3, 39, 39,  3, 27, 39,  3, 15, 39,  3,  3, 39, 15,  3, 39, 27,  3, 39
  db  39,  3, 39, 39,  3, 27, 27,  3, 15, 27,  3,  3, 27, 15,  3, 27, 27,  3
  db  15, 27,  3,  3, 27,  3,  3, 27, 15,  3, 27, 27,  3, 15, 27,  3,  3, 27
  db  15,  3, 27, 27,  3, 27, 15,  3,  3, 15, 15,  3,  3, 15,  3,  3, 15, 15
  db   3,  3, 15, 15,  3, 15, 27, 15, 15, 27, 27, 15, 15, 27, 15, 15, 27, 27
  db  15, 15, 27, 27, 15, 27, 39, 15, 15, 39, 27, 15, 39, 39, 15, 27, 39, 15
  db  15, 39, 15, 15, 39, 27, 15, 39, 39, 15, 27, 39, 15, 15, 39, 27, 15, 39
  db  39, 15, 39, 39, 15, 27, 51, 15, 15, 51, 27, 15, 51, 39, 15, 51, 51, 15
  db  39, 51, 15, 27, 51, 15, 15, 51, 15, 15, 51, 27, 15, 51, 39, 15, 51, 51
  db  15, 39, 51, 15, 27, 51, 15, 15, 51, 27, 15, 51, 39, 15, 51, 51, 15, 51
  db  51, 15, 39, 51, 15, 27, 51, 27, 27, 51, 39, 27, 51, 51, 27, 39, 51, 27
  db  27, 51, 27, 27, 51, 39
arcade_pal_size       =$-arcade_pal

SHIP1A_SIZE           = 7815
ship1a_pic            dd ?          ;ship1_a.vga

SHIP1B_SIZE           = 7815
ship1b_pic            dd ?          ;ship1_b.vga

LAZER1_SIZE           = 596
lazer1_pic            dd ?          ;lazer1.vga

SHIP2_SIZE            = 2928
ship2_pic             dd ?          ;ship2.vga

SHIP3_SIZE            = 1759
ship3_pic             dd ?          ;ship3.vga

MIS1_A_SIZE           = 652
mis1_a_pic            dd ?          ;mis1_a.vga

MIS1_B_SIZE           = 652
mis1_b_pic            dd ?          ;mis1_b.vga

EXPOZE1_SIZE          = 788
expoze1_pic           dd ?          ;expoze1.vga

EXPOZE2_SIZE          = 1028
expoze2_pic           dd ?          ;expoze2.vga

EXPOZE3_SIZE          = 904
expoze3_pic           dd ?          ;expoze3.vga

ARCADE_C_SIZE         = 1768
arcade_c_pic          dd ?          ;A_C.VGA

ARCADE_O_SIZE         = 1768
arcade_o_pic          dd ?          ;A_O.VGA

ARCADE_N_SIZE         = 1768
arcade_n_pic          dd ?          ;A_N.VGA

ARCADE_Q_SIZE         = 1768
arcade_q_pic          dd ?          ;A_Q.VGA

ARCADE_U_SIZE         = 1768
arcade_u_pic          dd ?          ;A_U.VGA

ARCADE_E_SIZE         = 1768
arcade_e_pic          dd ?          ;A_E.VGA

ARCADE_S_SIZE         = 1768
arcade_s_pic          dd ?          ;A_S.VGA

ARCADE_T_SIZE         = 1768
arcade_t_pic          dd ?          ;A_T.VGA

ARCADE_V_SIZE         = 1768
arcade_v_pic          dd ?          ;A_V.VGA

ARCADE_R_SIZE         = 1768
arcade_r_pic          dd ?          ;A_R.VGA

ARCADE_MESS2_SIZE     = 1828
arcade_mess2_pic      dd ?          ;A_LM2.VGA

ARCADE_MESS3_SIZE     = 20101
arcade_mess3_pic      dd ?          ;A_gr.VGA

CRUS64_SIZE           = (640*480)+768+4
crus64_pic            dd ?
crus64_pal            dd ?

PET1_SIZE             = 6245
pet1_pic              dd ?

PET2_SIZE             = 6245
pet2_pic              dd ?

gour_pal:
  db          18, 18,  0, 19, 10, 23, 25, 13, 31, 32, 17, 39, 38, 20, 47, 44
  db  23, 55, 63, 39,  3, 62, 38,  5, 62, 38,  6, 61, 37,  8, 61, 37, 10, 61
  db  37, 12, 60, 36, 14, 60, 36, 16, 60, 36, 18, 59, 35, 20, 59, 35, 22, 58
  db  34, 24, 58, 34, 26, 58, 34, 28, 57, 33, 30, 57, 33, 32, 56, 32, 34, 56
  db  32, 36, 56, 32, 37, 55, 31, 39, 55, 31, 41, 54, 30, 43, 54, 30, 45, 54
  db  30, 47, 53, 29, 49, 53, 29, 51, 53, 29, 53, 52, 28, 55, 52, 28, 57, 51
  db  27, 59, 51, 27, 61, 39, 15,  3, 39, 27,  3, 27, 15,  3, 27, 15, 15, 27
  db  15, 27, 39, 15, 15, 39, 27, 15, 39, 15, 39, 39, 15, 27, 51, 27, 15, 51
  db  27, 27
gour_pal_size = ($-gour_pal)/3

GOUR_SIZE             = 7229
gour_c_pic            dd ?
gour_o_pic            dd ?
gour_m_pic            dd ?
gour_n_pic            dd ?
gour_g_pic            dd ?
gour_u_pic            dd ?
gour_r_pic            dd ?
gour_a_pic            dd ?
gour_d_pic            dd ?

f004_SIZE             = 88804
f004_no_facets        dd ?
f004_world_ptr        dd ?
f004_pal:
  db   0,  0,  0, 20, 12, 20, 19, 12, 19, 18, 12, 18, 21, 12, 21, 22, 12, 22
  db  23, 12, 23, 24, 12, 24, 25, 12, 25, 27, 12, 27, 31, 12, 31, 35, 12, 35
  db  26, 12, 26, 29, 12, 29, 33, 12, 33, 28, 12, 28, 17, 12, 17, 16, 12, 16
  db  34, 12, 34, 38, 12, 38, 36, 12, 36, 30, 12, 30, 37, 12, 37, 39, 12, 39
  db  39, 12, 40, 42, 12, 44, 38, 12, 39, 15, 12, 15, 14, 12, 14, 32, 12, 32
  db  32, 12, 33, 37, 12, 39, 40, 12, 41, 32, 12, 36, 34, 12, 38, 33, 12, 37
  db  35, 12, 39, 35, 12, 37, 33, 12, 35, 35, 12, 36, 34, 12, 35, 37, 12, 38
  db  36, 12, 37, 36, 12, 39, 35, 12, 38, 42, 12, 46, 41, 12, 45, 37, 12, 41
  db  40, 12, 44, 41, 12, 44, 41, 12, 41, 40, 12, 40
f004_pal_size         = $-f004_pal

f005_no_facets        dd ?
f005_world_ptr        dd ?
f005_pal:
  db   0,  0,  0, 39, 50, 15, 40, 51, 15, 42, 51, 16, 50, 54, 18, 55, 51, 14
  db  56, 48, 13, 56, 45, 12, 56, 39, 12, 56, 30, 12, 56, 20, 12, 54, 29, 14
  db  54, 33, 14, 49, 23, 12, 37, 18, 12, 23, 12, 24, 14, 12, 39, 14, 12, 41
  db  13, 12, 48, 15, 12, 30, 28, 12, 28, 39, 12, 14, 41, 36, 15, 33, 31, 16
  db  18, 36, 18, 12, 31, 20,  7, 26, 21,  2, 22, 22, 51, 40, 15, 53, 47, 16
  db  45, 26, 12, 41, 19, 12, 27, 12, 18, 16, 12, 23, 39, 14, 17, 43, 27, 17
  db  36, 45, 16, 13, 32, 20, 39, 16, 27, 41, 19, 27, 27, 15, 39, 24, 12, 15
  db  29, 16, 19, 29, 43, 17, 38, 34, 26, 42, 27, 25, 36, 12, 24, 28, 16, 28
  db  48, 13, 12, 44, 13, 12, 37, 29, 26, 29, 36, 27, 24, 25, 37, 22, 12, 35
  db  37, 23, 18, 26, 24, 28, 21, 24, 38, 13, 24, 49, 14, 20, 40, 27, 23, 38
  db  40, 44, 14, 13, 20, 48, 40, 14, 23, 42, 16, 23, 37, 39, 19, 13, 24, 45
  db  14, 24, 37, 56, 14, 12, 41, 35, 28, 42, 15, 24, 30, 41, 29, 34, 32, 14
  db  28, 20, 15, 16, 27, 18, 14, 16, 39, 14, 16, 31, 23, 12, 14, 28, 24, 17
  db  36, 48, 16, 32, 25, 15, 23, 25, 26, 42, 38, 16, 33, 47, 15, 29, 45, 15
  db  43, 40, 16, 12, 31, 56, 16, 24, 41, 19, 15, 41, 19, 16, 41, 17, 16, 31
  db  40, 40, 24, 20, 16, 38, 21, 21, 23, 26, 34, 23, 23, 40, 17
f005_pal_size         = $-f005_pal

f001_no_facets        dd ?
f001_world_ptr        dd ?
f001_pal:
  db   0,  0,  0, 12, 37, 56, 27, 44, 41, 41, 42, 27, 56, 40, 12, 56, 39, 12
  db  56, 28, 12, 56, 23, 12, 44, 18, 12, 44, 27, 12, 50, 31, 12, 29, 13, 14
  db  23, 12, 14, 25, 12, 18, 34, 18, 18, 41, 18, 18, 42, 12, 12, 48, 12, 12
  db  56, 48, 12, 34, 19, 12, 28, 12, 27, 33, 12, 39, 48, 18, 39, 54, 20, 24
  db  54, 18, 12, 45, 35, 12, 27, 39, 41, 37, 13, 19, 55, 32, 12, 48, 25, 18
  db  48, 35, 18, 43, 20, 27, 50, 29, 27, 56, 14, 12, 41, 35, 27, 36, 35, 27
  db  12, 44, 56, 12, 48, 56, 21, 12, 18, 37, 12, 12, 47, 22, 32, 37, 12, 27
  db  48, 23, 18, 51, 14, 21, 41, 29, 27, 35, 24, 27, 33, 33, 33, 36, 18, 33
  db  29, 12, 48, 27, 12, 33, 33, 12, 40, 41, 12, 29, 54, 33, 25, 53, 12, 54
  db  55, 14, 41, 56, 29, 27, 12, 29, 56, 16, 24, 56, 20, 21, 56, 23, 21, 48
  db  23, 12, 48, 19, 12, 56, 25, 12, 56, 33, 20, 55, 24, 14, 46, 56, 23, 26
  db  24, 17, 56, 29, 24, 41, 56, 33, 26, 39, 20, 27, 29, 21, 41, 28, 18, 27
  db  37, 27, 37, 39, 27, 41, 31, 16, 48, 27, 25, 56, 15, 16, 56, 14, 14, 56
  db  14, 14, 41, 24, 16, 39, 37, 12, 56, 30, 17, 14, 31, 23, 16, 42, 18, 41
  db  50, 14, 27, 41, 12, 56, 35, 12, 55, 41, 12, 55, 52, 18, 40, 34, 21, 56
  db  43, 12, 43, 48, 12, 56, 14, 12, 12, 23, 12, 35, 15, 27, 30, 23, 12, 29
  db  15, 12, 16, 46, 14, 17, 15, 12, 27
f001_pal_size         = $-f001_pal

SR_BAR_SIZE           = 63166
sr_bar_1_pic          dd ?
sr_bar_2_pic          dd ?
sr_bar_3_pic          dd ?
sr_bar_pal:
  db              25,  0,  0, 28,  0,  0, 30,  0,  0, 33,  0,  0, 35,  0,  0
  db  38,  0,  0, 40,  0,  0, 43,  0,  0, 46,  0,  0, 48,  0,  0, 51,  0,  0
  db  53,  0,  0, 20,  0, 18
sr_bar_pal_size       = $-sr_bar_pal

KILLMESS_SIZE         = 5028
killmess_pic          dd ?

GATE_SIZE             = 307972
gate_pic              dd ?
gate_pal              dd ?

THEEND1_SIZE          = 36804
theend1_pic           dd ?

THEEND2_SIZE          = 36114
theend2_pic           dd ?

theend1_pal:
  db  58, 20, 63, 29,  3, 27, 36,  3, 54
theend1_pal_size      = $-theend1_pal


proc calc_data
  mov    esi,offset gfx
;entry ANSI
  mov    [start_pic],esi
  add    esi,START_SIZE
;logo piccy
  mov    [logo_pic],esi
  call   @@calc_pal
  mov    [logo_pal],eax
  add    esi,LOGO_SIZE
;font
  mov    [font_pic],esi
  add    esi,FONT_SIZE
;text00  ; 158 colours
  mov    [text00_pic],esi
  call   @@calc_pal
  mov    [text00_pal],eax
  add    esi,TEXT00_SIZE
;merg
  mov    [merg_1_pic],esi
  call   @@calc_pal
  mov    [merg_1_pal],eax
  add    esi,MERG_1_SIZE

  mov    [merg_2_pic],esi
  call   @@calc_pal
  add    esi,MERG_2_SIZE
;intro_1
  mov    [intro_1_pic],esi
  call   @@calc_pal
  mov    [intro_1_pal],eax
  add    esi,INTRO_1_SIZE
;intro_2
  mov    [intro_2_pic],esi
  add    esi,INTRO_2_SIZE
;intro_3
  mov    [intro_3_pic],esi
  add    esi,INTRO_3_SIZE
;litch_f2  ; 240 or so colours
  mov    [litch_f_pic],esi
  call   @@calc_pal
  mov    [litch_f_pal],eax
  add    esi,LITCH_F_SIZE
;first  ; 16 colours
  mov    [first_pic],esi
  call   @@calc_pal
  mov    [first_pal],eax
  add    esi,FIRST_SIZE
;rocket slides
  mov    [r_a_pic],esi
  add    esi,ANIROCKET_SIZE
  mov    [r_b_pic],esi
  add    esi,ANIROCKET_SIZE
;arcade game
  mov    [ship1a_pic],esi
  add    esi,SHIP1A_SIZE

  mov    [ship1b_pic],esi
  add    esi,SHIP1B_SIZE

  mov    [lazer1_pic],esi
  add    esi,LAZER1_SIZE

  mov    [ship2_pic],esi
  add    esi,SHIP2_SIZE

  mov    [ship3_pic],esi
  add    esi,SHIP3_SIZE

  mov    [mis1_a_pic],esi
  add    esi,MIS1_A_SIZE

  mov    [mis1_b_pic],esi
  add    esi,MIS1_B_SIZE

  mov    [expoze1_pic],esi
  add    esi,EXPOZE1_SIZE

  mov    [expoze2_pic],esi
  add    esi,EXPOZE2_SIZE

  mov    [expoze3_pic],esi
  add    esi,EXPOZE3_SIZE

  mov    [arcade_c_pic],esi
  add    esi,ARCADE_C_SIZE

  mov    [arcade_o_pic],esi
  add    esi,ARCADE_O_SIZE

  mov    [arcade_n_pic],esi
  add    esi,ARCADE_N_SIZE

  mov    [arcade_q_pic],esi
  add    esi,ARCADE_Q_SIZE

  mov    [arcade_u_pic],esi
  add    esi,ARCADE_U_SIZE

  mov    [arcade_e_pic],esi
  add    esi,ARCADE_E_SIZE

  mov    [arcade_s_pic],esi
  add    esi,ARCADE_S_SIZE

  mov    [arcade_t_pic],esi
  add    esi,ARCADE_T_SIZE

  mov    [arcade_v_pic],esi
  add    esi,ARCADE_V_SIZE

  mov    [arcade_r_pic],esi
  add    esi,ARCADE_R_SIZE

  mov    [arcade_mess2_pic],esi
  add    esi,ARCADE_MESS2_SIZE

  mov    [arcade_mess3_pic],esi
  add    esi,ARCADE_MESS3_SIZE

;cruisers ; 224 colours
  mov    [crus64_pic],esi
  call   @@calc_pal
  mov    [crus64_pal],eax
  add    esi,CRUS64_SIZE

; pets
  mov    [pet1_pic],esi
  add    esi,PET1_SIZE
  mov    [pet2_pic],esi
  add    esi,PET2_SIZE

;gourand ring scroller
  mov    [gour_c_pic],esi
  add    esi,GOUR_SIZE
  mov    [gour_o_pic],esi
  add    esi,GOUR_SIZE
  mov    [gour_m_pic],esi
  add    esi,GOUR_SIZE
  mov    [gour_n_pic],esi
  add    esi,GOUR_SIZE
  mov    [gour_g_pic],esi
  add    esi,GOUR_SIZE
  mov    [gour_u_pic],esi
  add    esi,GOUR_SIZE
  mov    [gour_r_pic],esi
  add    esi,GOUR_SIZE
  mov    [gour_a_pic],esi
  add    esi,GOUR_SIZE
  mov    [gour_d_pic],esi
  add    esi,GOUR_SIZE

;data f3d data 1
  mov    ebx,esi
  mov    eax,[ebx]
  mov    [f004_no_facets],eax
  add    ebx,4
  mov    [f004_world_ptr],ebx
  add    esi,f004_SIZE

;data f3d data 5
  mov    ebx,esi
  mov    eax,[ebx]
  mov    [f005_no_facets],eax
  add    ebx,4
  mov    [f005_world_ptr],ebx
  add    esi,f004_SIZE

;data f3d data 1
  mov    ebx,esi
  mov    eax,[ebx]
  mov    [f001_no_facets],eax
  add    ebx,4
  mov    [f001_world_ptr],ebx
  add    esi,f004_SIZE

;load superreal
  mov    [sr_bar_1_pic],esi
  add    esi,SR_BAR_SIZE

;load superrhip
  mov    [sr_bar_2_pic],esi
  add    esi,SR_BAR_SIZE

;load supercool!
  mov    [sr_bar_3_pic],esi
  add    esi,SR_BAR_SIZE

;load kill mess (used in gouraud shading scene).
  mov    [killmess_pic],esi
  add    esi,KILLMESS_SIZE

;gate piccy
  mov    [gate_pic],esi
  call   @@calc_pal
  mov    [gate_pal],eax
  add    esi,GATE_SIZE

;end piccys
  mov    [theend1_pic],esi
  add    esi,THEEND1_SIZE

  mov    [theend2_pic],esi
  add    esi,THEEND2_SIZE

  ret
proc @@calc_pal
  push   esi
  movzx  ecx,[word esi]
  movzx  eax,[word 2+esi]
  mul    ecx
  add    eax,4
  pop    esi
  add    eax,esi
  ret
endp
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; entry screen                                                            ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
kb_up                 = 4800h
kb_down               = 5000h

demo_card_type        db 0
demo_irq_type         db 0
demo_dma_type         db 0
demo_prec_type        db 0
demo_vbe_type         db 0

proc get_barline
  mov    [byte edi-(160*1)],0cah

@@l:
  push   edx ebx edi ecx
  xor    al,al
@@write_entry:
  push   edi ecx eax
  cmp    al,dl
  je     @@hle
  jmp    @@hlne
@@hle:
  mov    al,bh
  jmp    @@write_lin
@@hlne:
  mov    al,bl
@@write_lin:
  stosb
  inc    edi
  dec    ecx
  jnz    @@write_lin
  pop    eax ecx edi
  add    edi,160
  inc    al
  cmp    al,dh
  jb     @@write_entry
  pop    ecx edi ebx edx

  call   get_key
  cmp    al,13
  je     @@end
  cmp    al,27
  je     @@end
  cmp    ax,kb_up
  je     @@up
  cmp    ax,kb_down
  je     @@dn
  jmp    @@l
@@up:
  cmp    dl,0
  je     @@l
  dec    dl
  jmp    @@l
@@dn:
  mov    al,dh
  dec    al
  cmp    dl,al
  je     @@l
  inc    dl
  jmp    @@l
@@end:
  mov    [byte edi-(160*1)],04ch
  ret
endp

proc start_options
  mov    eax,3
  int    10h
  mov    ah,02h
  xor    bh,bh
  mov    edx,6400h
  int    10h

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

    ; set up registers to accsess one Bit plane  only
    ; set for sequentual memory addressing
        mov dx,3C4h             ; sequencer reg group
        mov al,4
        mov ah,0111b
        out dx,ax

        mov dx,3CEh             ; The Graphics Controller reg group
        mov al,5                ; Mode Register
        mov ah,00000000b
        out dx,ax

        mov dx,3ceh             ; The Graphics Controller reg group
    	mov al,6                ; Misellaneous Register
        mov ah,1100b
        out dx,ax

      ; set Map Mask Register
        mov dx,3c4h             ; sequencer reg group
    	mov al,2
        mov ah,0100b            ; to write to bit plane 2 ( font memory )
        out dx,ax

     ; can now fill up the video font memory

        mov     edi,[_0b8000h]
        xor     edx,edx
@@fill_font:
        mov     eax,[Dword PTR font_data+EDX]
        mov     [edi],eax
        mov     eax,[Dword PTR font_data+EDX+4]
        mov     [edi+4],eax
        mov     eax,[Dword PTR font_data+EDX+8]
        mov     [edi+8],eax
        mov     eax,[Dword PTR font_data+EDX+12]
        mov     [edi+12],ax
        mov     [word edi+14],0
        add     edi,32
        add     edx,14
        cmp     edx,255*8
        jb      @@fill_font

  ;      set up registers to accsess one Bit plane 0 and 1 chained together
  ; i.e return to it's normal write mode.
  ;
        mov dx,3C4h             ; sequencer reg group
        mov al,4
        mov ah,00011b           ; Chain four enabled
        out dx,ax

        mov dx,3CEh             ; The Graphics Controller reg group
        mov al,5                ; Mode Register
        mov ah,00010000b
        out dx,ax

        mov al,6                ; Miscellaneous Register
        mov ah,1110b
        out dx,ax

     ; set Map Mask Register
        mov dx,3c4h             ; sequencer reg group
    	mov al,2
        mov ah,0011b            ; to write to bit plane 0 and 1
        out dx,ax
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  mov    esi,[start_pic]
  mov    edi,[_0B8000h]
  mov    ecx,4000/4
  rep    movsd

;get card type
@@ct:
  mov    dh,5                            ; no of entries    ; hl
  mov    dl,[demo_card_type]             ; pos???
  mov    ebx,6770h                       ; colour of hl     ; colour of ll
  mov    edi,[_0b8000h]
  add    edi,1+(160*13)+(2*2)            ; screen pos
  mov    ecx,13                          ; length
  call   get_barline
  cmp    al,27
  je     @@ct
  mov    [demo_card_type],dl
  cmp    dl,3
  je     @@pt
  cmp    dl,4
  je     @@vt

;get irq type
@@it:
  mov    dh,7
  mov    dl,[demo_irq_type]
  mov    ebx,6770h
  mov    edi,[_0b8000h]
  add    edi,1+(160*13)+(2*20)
  mov    ecx,3
  call   get_barline
  mov    [demo_irq_type],dl
  cmp    al,27
  je     @@ct

;get dma type
@@dt:
  mov    dh,8
  mov    dl,[demo_dma_type]
  mov    ebx,6770h
  mov    edi,[_0b8000h]
  add    edi,1+(160*13)+(2*28)
  mov    ecx,3
  call   get_barline
  mov    [demo_dma_type],dl
  cmp    al,27
  je     @@it

;get dac precision type
@@pt:
  mov    dh,5
  mov    dl,[demo_prec_type]
  mov    ebx,6770h
  mov    edi,[_0b8000h]
  add    edi,1+(160*13)+(2*36)
  mov    ecx,13
  call   get_barline
  mov    [demo_prec_type],dl
  cmp    al,27
  jne    @@vt
  cmp    [byte demo_card_type],3
  je     @@ct
  jmp    @@dt
;get Vbe type
@@vt:
  mov    al,06eh
  call   @@hl

  mov    dh,3
  mov    dl,[demo_vbe_type]
  mov    ebx,6770h
  mov    edi,[_0b8000h]
  add    edi,1+(160*13)+(2*54)
  mov    ecx,18
  call   get_barline
  mov    [demo_vbe_type],dl
  cmp    al,27
  jne    @@hl_ddb

  cmp    [byte demo_card_type],4
  je     @@ct
  jmp    @@pt
;high light demo button
@@hl_ddb:
  mov    al,0ffh
  call   @@hl

  call   get_key
  cmp    al,27
  je     @@vt

  mov    eax,3
  int    10h

  ret
proc @@hl
  mov    edi,[_0b8000h]
  add    edi,1+(160*19)+(2*54)
  mov    cl,14
@@l2:
  mov    [edi],al
  add    edi,2
  dec    cl
  jnz    @@l2
  ret
endp
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; Plays a sample from the loaded Fnk song                                  ;
;                                                                          ;
; cl = channel to play                                                     ;
; dl = sample  dh = note                                                   ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc play_sample_ISR
  cmp    [byte init_settings.card_type],GUS_VARB_CARD
  je     @@cont
  cmp    [byte init_settings.card_type],GUS_FIXB_CARD
  je     @@cont
  ret
@@cont:
  mov    [@@note],dh
  mov    al,size tfunk_chan
  mul    cl                                         ;[byte pat_chan]
  movzx  edi,ax
  add    edi,offset funk_chan1
  mov    al,dl
  mov    [byte edi+tfunk_chan.sample],al
  movzx  eax,al
  shl    eax,5
  add    eax,[funk_hr_ptr]
  add    eax,offset (tfunk_hr).funk_sb
  cmp    [dword eax+tfunk_sb.length],0
  je     @@endendend
  mov    [byte edi+tfunk_chan.funkctrl],10b       ; set funkctrl
  mov    ebx,[dword eax+tfunk_sb.start]
  cmp    ebx,0ffffffffh
  je     @@dont_loop
  mov    [byte edi+tfunk_chan.funkctrl],11b       ; set funkctrl
@@dont_loop:
  mov    [dword edi+tfunk_chan.start],ebx
  mov    ebx,[dword eax+tfunk_sb.length]
  mov    [dword edi+tfunk_chan.length],ebx
  mov    bl,[byte eax+tfunk_sb.balance]
  mov    [byte edi+tfunk_chan.balance],bl
  mov    bl,[byte eax+tfunk_sb.pt_and_sop]        ; get both port type and sample ofs parm
  mov    dl,bl
  shr    bl,4
  and    dl,1111b
  mov    [byte edi+tfunk_chan.port_type],bl
  mov    [byte edi+tfunk_chan.sample_ofs_parm],dl
  mov    bl,[byte eax+tfunk_sb.vv_waveform]       ; get both vibrato wf & tremola wf
  mov    dl,bl
  shr    bl,4
  and    dl,1111b
  mov    [byte edi+tfunk_chan.vib_waveform],bl
  mov    [byte edi+tfunk_chan.vol_vib_waveform],dl
  mov    bl,[byte eax+tfunk_sb.rl_and_as]         ; get both retrig speed & arp speed
  mov    dl,bl
  shr    bl,4
  and    dl,1111b
  mov    [byte edi+tfunk_chan.retrig_limit],bl
  mov    [byte edi+tfunk_chan.arp_speed],dl
  mov    bl,[byte eax+tfunk_sb.volume]
  mov    [byte edi+tfunk_chan.volume],bl
  call   vol_to_realvol
  call   [dword CARD_volume_convert]
  mov    bl,[@@note]
  mov    [byte edi+tfunk_chan.note],bl
  @note_2_ifreq
  mov    [word edi+tfunk_chan.ifreq],bx
  call   ifreq_to_rfreq
  mov    [dword edi+tfunk_chan.rfreq],eax
  call   [dword CARD_freq_convert]
  movzx  esi,[byte edi+tfunk_chan.sample]
  lea    esi,[esi*4]
  mov    eax,[dword esi+funk_info.sample_ptrs]
  add    [dword edi+tfunk_chan.start],eax
  add    [dword edi+tfunk_chan.length],eax
  mov    [dword edi+tfunk_chan.CARD_sample_ptr],eax
@@endendend:
  ret
@@note   db ?
endp

macro @play_sample
  cli
  call   play_sample_ISR
  sti
endm

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; Display superreal logo                                                  ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
LOGO_FADEIN           = 0
LOGO_WAIT2            = 1
LOGO_FADEOUT          = 2
LOGO_WAIT3            = 3
LOGO_DONE             = 4

logo_fadepal          dd 0

proc logo_title_ISR
  cmp    [byte ISR_event],LOGO_FADEIN
  je     @@jLOGO_FADEIN
  cmp    [byte ISR_event],LOGO_WAIT2
  je     @@jLOGO_WAIT2
  cmp    [byte ISR_event],LOGO_FADEOUT
  je     @@jLOGO_FADEOUT
  cmp    [byte ISR_event],LOGO_WAIT3
  je     @@jLOGO_WAIT3
  ret
@@next_event:
  mov    [dword ISR_pc],0
  inc    [byte ISR_event]
  ret
@@jLOGO_FADEIN:
  cmp    [dword ISR_pc],256
  jae    @@next_event
  add    [dword ISR_pc],2
  mov    ebx,[logo_fadepal]
  mov    eax,2
  call   clip_ipal
  mov    [logo_fadepal],ebx
  ret
@@jLOGO_WAIT2:
  cmp    [byte demo_card_type],4
  je     @@nos_LOGO_WAIT2
  cmp    [byte funk_info.sequence_ofs],1
  jb     @@end
  jmp    @@next_event
@@nos_LOGO_WAIT2:
  cmp    [dword ISR_pc],400
  jae    @@next_event
  inc    [dword ISR_pc]
  ret
@@jLOGO_FADEOUT:
  cmp    [dword ISR_pc],256
  jae    @@next_event
  inc    [dword ISR_pc]
  mov    ebx,[logo_fadepal]
  mov    eax,1
  call   clip_dpal
  mov    [logo_fadepal],ebx
  ret
@@jLOGO_WAIT3:
  cmp    [dword ISR_pc],240
  jae    @@next_event
  inc    [dword ISR_pc]
@@end:
  ret
endp

proc logo_title
  call   totally_clear_screen

  mov    esi,[logo_pal]
  xor    eax,eax
  mov    ecx,256
  call   fade_pal_init

  xor    eax,eax
  mov    ecx,256
  mov    ebx,[logo_fadepal]
  call   fade_pal

  mov    eax,[logo_pic]
  mov    edx,eax
  add    eax,4
  push   eax
  push   [dword Rendbuff]
  mov    eax,640
  movzx  ebx,[word edx]
  sub    eax,ebx
  shr    eax,1
  push   eax
  mov    eax,480
  movzx  ebx,[word edx+2]
  sub    eax,ebx
  shr    eax,1
  push   eax
  xor    eax,eax
  mov    ax,[word edx]
  push   eax
  mov    ax,[word 2+edx]
  push   eax
  push   640
  call   RBBitmap
  add    esp,(size RBBitmap_stack)-8
  call   [update_screen]
  call   [update_screen]

  mov    [ISR_event],LOGO_FADEIN
  mov    [ISR_pc],0
  mov    eax,offset logo_title_ISR
  mov    [fg_calc],eax
@@paint:
  call   sync_screen_nochg
  cmp    [byte ISR_event],LOGO_DONE
  je     @@end
  cmp    [byte ISR_event],LOGO_FADEIN
  je     @@tLOGO_FADE
  cmp    [byte ISR_event],LOGO_FADEOUT
  je     @@tLOGO_FADE
  jmp    @@done
@@tLOGO_FADE:
  @WaitVertEnd
  xor    eax,eax
  mov    ecx,256
  mov    ebx,[logo_fadepal]
  call   fade_pal
  @WaitVert
@@done:
  call   key_pressed2
  jnc    @@paint
  call   get_key
  cmp    al,27
  je     @@end
  jmp    @@paint
@@end:
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; 2nd Scene: animate main "REAL 2 SUPERREAL" LOGO                         ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ADD_shifter           = 8

ANITITLE_ZOOMOUT1     = 0
ANITITLE_ZOOMIN1      = 1
ANITITLE_SPINWAIT     = 2
ANITITLE_WAIT         = 3
ANITITLE_SR1          = 4
ANITITLE_SR2          = 5
ANITITLE_WAIT1        = 6
ANITITLE_SR3          = 7
ANITITLE_WAIT2        = 8
ANITITLE_SR4          = 9
ANITITLE_DONE         = 10

intro_1_x             dd 640/2 - (30*10)
intro_1_y             dd 480/2

intro_1_dsx           dd (565*10) shl ADD_shifter
intro_1_dsy           dd (221*10) shl ADD_shifter

intro_3_x             dd -500
intro_3_y             = 280

i3_x                  dd 485
i3_y                  = 63

main_squeeze_x        dd 640

proc ani_title_ISR
  cmp    [byte ISR_event],ANITITLE_ZOOMOUT1
  je     @@jANITITLE_ZOOMOUT1
  cmp    [byte ISR_event],ANITITLE_ZOOMIN1
  je     @@jANITITLE_ZOOMIN1
  cmp    [byte ISR_event],ANITITLE_SPINWAIT
  je     @@jANITITLE_SPINWAIT
  cmp    [byte ISR_event],ANITITLE_WAIT
  je     @@jANITITLE_WAIT
  cmp    [byte ISR_event],ANITITLE_SR1
  je     @@jANITITLE_SR1
  cmp    [byte ISR_event],ANITITLE_SR2
  je     @@jANITITLE_SR2
  cmp    [byte ISR_event],ANITITLE_WAIT1
  je     @@jANITITLE_WAIT
  cmp    [byte ISR_event],ANITITLE_SR4
  je     @@jANITITLE_SR4
  cmp    [byte ISR_event],ANITITLE_WAIT2
  je     @@jANITITLE_WAIT2
  ret
@@next_event:
  mov    [dword ISR_pc],0
  inc    [byte ISR_event]
  ret
@@jANITITLE_ZOOMOUT1:
  cmp    [dword ISR_pc],100
  jae    @@next_event
  inc    [dword ISR_pc]
  mov    eax,[intro_1_dsx]
  sar    eax,5
  sub    [intro_1_dsx],eax
  mov    eax,[intro_1_dsy]
  sar    eax,5
  sub    [intro_1_dsy],eax
  add    [intro_1_x],3

  add    [angle1],8
  and    [angle1],0fffh
  ret
@@jANITITLE_ZOOMIN1:
  cmp    [dword ISR_pc],115
  jae    @@next_event
  inc    [dword ISR_pc]
  mov    eax,[intro_1_dsx]
  sar    eax,7
  add    [intro_1_dsx],eax
  mov    eax,[intro_1_dsy]
  sar    eax,7
  add    [intro_1_dsy],eax
  sub    [intro_1_y],1

  add    [angle1],8
  and    [angle1],0fffh
  ret
@@jANITITLE_SPINWAIT:
  cmp    [dword @@hl_sw],4
  je     @@ign_hl_sw2
  cmp    [dword @@hl_sw],0
  ja     @@ign_hl_sw1
  mov    edx,03c8h
  xor    al,al
  out    dx,al
  inc    edx
  rept 3
  mov    al,20
  out    dx,al
  endm
  jmp    @@ign_hl_sw2
@@ign_hl_sw1:
  cmp    [dword @@hl_sw],3
  jb     @@ign_hl_sw2
  mov    edx,03c8h
  xor    al,al
  out    dx,al
  inc    edx
  rept 3
  mov    al,0
  out    dx,al
  endm
@@ign_hl_sw2:
  inc    [dword @@hl_sw]
  cmp    [angle1],0800h
  jae    @@next_event
  add    [angle1],9
  and    [angle1],0fffh
  ret
@@hl_sw               dd 0
@@jANITITLE_WAIT:
  cmp    [dword ISR_pc],20
  jae    @@next_event
  inc    [dword ISR_pc]
  ret
@@jANITITLE_SR1:
  mov    eax,[@@slide_factor]
  sar    eax,16
  add    [intro_3_x],eax
  sub    [dword @@slide_factor],0a000h
  cmp    [dword @@slide_factor],0
  jl     @@SR1_1
  add    [i3_x],10
  ret
@@SR1_1:
  cmp    [intro_3_x],50
  jle    @@SR1_2a  ;@@next_event
  sub    [i3_x],10
  ret
@@SR1_2a:
  mov    [intro_3_x],50
  jmp    @@next_event
  ret
@@jANITITLE_SR2:
  cmp    [i3_x],485
  jle    @@SR2
  sub    [i3_x],30
  ret
@@SR2:
  mov    [i3_x],485
  jmp    @@next_event
@@jANITITLE_WAIT2:
  cmp    [dword ISR_pc],150
  jae    @@next_event
  inc    [dword ISR_pc]
  ret
@@jANITITLE_SR4:
  cmp    [dword ISR_pc],40 + 20
  jae    @@next_event
  inc    [dword ISR_pc]
  sub    [dword main_squeeze_x],(640/40)
  ret
@@slide_factor        dd 200000h
endp

proc ani_title
  cmp    [byte demo_card_type],4
  je     @@nosound
@@wait_until2np:
  cmp    [byte funk_info.sequence_ofs],2
  jb     @@wait_until2np
@@nosound:

  call   totally_clear_screen
  xor    al,al
  mov    ecx,256*3
  mov    esi,[intro_1_pal]
  @WritePalette

  mov    edx,133*133*2
  mov    eax,0EE42h         ; allocate a DOS32 memory block
  Int    31h                ;  expects EDX = size; ret EAX=size, EDX->pointer
  mov    [pic_mt1],edx

  mov    edi,[pic_mt1]                ; init bm rotator
  mov    eax,133
  mov    ebx,133
  call   BM_rotate_init

  mov    edx,SCREEN_X*SCREEN_Y        ; allocate extra screen
  mov    eax,0EE42h                   ; allocate a DOS32 memory block
  Int    31h
  mov    [Rendbuff2],edx

  mov    [ISR_event],ANITITLE_ZOOMOUT1
  mov    [ISR_pc],0
  mov    eax,offset ani_title_ISR
  mov    [fg_calc],eax
@@paint:
  cmp    [byte ISR_event],ANITITLE_ZOOMOUT1
  je     @@zoom_in
  cmp    [byte ISR_event],ANITITLE_ZOOMIN1
  je     @@zoom_in
  cmp    [byte ISR_event],ANITITLE_SPINWAIT
  je     @@zoom_in
  cmp    [byte ISR_event],ANITITLE_WAIT
  je     @@zoom_in
  cmp    [byte ISR_event],ANITITLE_SR1
  je     @@p3_rush
  cmp    [byte ISR_event],ANITITLE_SR2
  je     @@p3_rush
  cmp    [byte ISR_event],ANITITLE_WAIT1
  je     @@p3_rush
  cmp    [byte ISR_event],ANITITLE_SR3
  je     @@copy_scr
  cmp    [byte ISR_event],ANITITLE_SR4
  je     @@fin_squeeze
  jmp    @@cont
;main thing zoom in/out;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@zoom_in:
  call   clear_screen
  mov    esi,[intro_1_pic]
  mov    eax,4
  add    eax,esi
  push   eax
  push   [dword Rendbuff]

  mov    ebx,[intro_1_x]
  mov    eax,[intro_1_dsx]
  sar    eax,ADD_shifter+1
  sub    ebx,eax
  push   ebx

  mov    ebx,[intro_1_y]
  mov    eax,[intro_1_dsy]
  sar    eax,ADD_shifter+1
  sub    ebx,eax
  push   ebx

  movzx  eax,[word esi]
  push   eax
  movzx  eax,[word esi+2]
  push   eax
  mov    eax,[intro_1_dsx]
  sar    eax,ADD_shifter
  push   eax
  mov    eax,[intro_1_dsy]
  sar    eax,ADD_shifter
  push   eax
  push   640
  call   pscaler
  add    esp,(size pscaler_stack)-8

;pic rotate
  mov    esi,[intro_2_pic]
  mov    eax,esi
  add    eax,4
  push   eax
  mov    edi,[intro_1_pic]
  add    edi,4
  push   edi
  push   [pic_mt1]
  push   455-(133/2)
  push   111-(133/2)
  push   [angle1]
  movzx  eax,[word esi]
  push   eax
  movzx  eax,[word esi+2]
  push   eax
  movzx  eax,[word edi-4]
  push   eax
  call   BM_rotate
  add    esp,(size BM_rotate_stack)-4
  jmp    @@cont
;;;intro 3 pic rush;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@p3_rush:
  mov    edi,[Rendbuff]
  add    edi,(640*280)
  mov    ecx,(640*63)/4
  xor    eax,eax
  rep    stosd
  mov    esi,[intro_3_pic]
  mov    eax,4
  add    eax,esi
  push   eax
  push   [dword Rendbuff]
  push   [intro_3_x]
  push   intro_3_y
  movzx  eax,[word esi]
  push   eax
  movzx  eax,[word esi+2]
  push   eax
  push   [i3_x]
  push   i3_y
  push   640
  call   pscaler
  add    esp,(size pscaler_stack)-8
  jmp    @@cont
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@copy_scr:
  mov    esi,[Rendbuff]
  mov    edi,[Rendbuff2]
  mov    ecx,(SCREEN_X*SCREEN_Y)/4
  rep    movsd
  mov    [dword ISR_pc],0
  inc    [byte ISR_event]
  jmp    @@cont
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@fin_squeeze:
  call   clear_screen
  cmp    [main_squeeze_x],0
  jle    @@cont
  push   [dword Rendbuff2]
  push   [dword Rendbuff]
  mov    ebx,640/2
  mov    eax,[main_squeeze_x]
  sar    eax,1
  sub    ebx,eax
  push   ebx
  push   0
  push   640
  push   480
  push   [main_squeeze_x]
  push   480
  push   640
  call   pscaler
  add    esp,(size pscaler_stack)-8
@@cont:

  call   [sync_screen]
  cmp    [byte ISR_event],ANITITLE_DONE
  je     @@end
  call   key_pressed2
  jnc    @@paint
  call   get_key
  cmp    al,27
  je     @@end
  jmp    @@paint
@@end:
  mov    eax,0EE40h           ; delocate rotational mult table
  int    31h
  mov    eax,0EE40h           ; delocate screen
  int    31h
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; "1st SVGA dEMO by JsNO" unfold, zoomin,fade                             ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
FIRST_FADEIN          = 0
FIRST_WAIT            = 1
FIRST_UNFOLD          = 2
FIRST_FOLD            = 3
FIRST_FADEOUT         = 4
FIRST_DONE            = 5

first_xsize           dd 0
litch_f_pos           dd 0

proc first_ISR
  dec    [dword litch_f_pos]

  cmp    [byte ISR_event],FIRST_FADEIN
  je     @@jFIRST_FADEIN
  cmp    [byte ISR_event],FIRST_WAIT
  je     @@jFIRST_WAIT
  cmp    [byte ISR_event],FIRST_UNFOLD
  je     @@jFIRST_UNFOLD
  cmp    [byte ISR_event],FIRST_FOLD
  je     @@jFIRST_FOLD
  cmp    [byte ISR_event],FIRST_FADEOUT
  je     @@jFIRST_FADEOUT
  ret
@@next_event:
  mov    [dword ISR_pc],0
  inc    [byte ISR_event]
  ret
@@jFIRST_FADEIN:
  cmp    [dword ISR_pc],100h/4
  jae    @@next_event
  inc    [dword ISR_pc]
  mov    ebx,[logo_fadepal]
  mov    eax,4
  call   clip_ipal
  mov    [logo_fadepal],ebx
  ret
@@jFIRST_WAIT:
  cmp    [dword ISR_pc],50
  jae    @@next_event
  inc    [dword ISR_pc]
  ret
@@jFIRST_UNFOLD:
  cmp    [dword ISR_pc],30+200
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [first_xsize],260/30
  cmp    [first_xsize],260
  ja     @@jFIRST_UNFOLD_2
  ret
@@jFIRST_UNFOLD_2:
  mov    [first_xsize],267
  ret
@@jFIRST_FOLD:
  cmp    [dword ISR_pc],30+80
  jae    @@next_event
  inc    [dword ISR_pc]
  sub    [first_xsize],260/30
  cmp    [first_xsize],0
  jl     @@jFIRST_FOLD_2
  ret
@@jFIRST_FOLD_2:
  mov    [first_xsize],0
  ret
@@jFIRST_FADEOUT:
  cmp    [dword RBBitmap_clipT],400
  jae    @@next_event
  add    [dword RBBitmap_clipT],4
  ret
endp

proc first
  mov    [logo_fadepal],0
  call   totally_clear_screen

  mov    esi,[litch_f_pal]
  xor    eax,eax
  mov    ecx,240
  call   fade_pal_init

  xor    eax,eax
  mov    ecx,240
  mov    ebx,[logo_fadepal]
  call   fade_pal

  mov    al,240
  mov    ecx,16*3
  mov    esi,[first_pal]
  add    esi,240*3
  @WritePalette

  mov    [ISR_event],FIRST_FADEIN
  mov    [ISR_pc],0
  mov    eax,offset first_ISR
  mov    [fg_calc],eax
@@paint:

  cmp    [byte ISR_event],FIRST_FADEOUT
  jne    @@tdontc
  call   clear_screen
@@tdontc:

  mov    eax,[litch_f_pic]
  mov    edx,eax
  add    eax,4
  push   eax
  push   [dword Rendbuff]
  mov    eax,[litch_f_pos]
  sar    eax,2
  push   eax
  push   0
  xor    eax,eax
  mov    ax,[word edx]
  push   eax
  mov    ax,[word 2+edx]
  push   eax
  push   640
  call   RBBitmap
  add    esp,(size RBBitmap_stack)-8

  cmp    [first_xsize],0
  jle    @@cont
  mov    eax,[first_pic]
  add    eax,4
  push   eax
  push   [dword Rendbuff]
  mov    ebx,640/2
  mov    eax,[first_xsize]
  sar    eax,1
  sub    ebx,eax
  push   ebx
  push   (480/2)-(149/2)
  push   260
  push   149
  push   [first_xsize]
  push   149
  push   640
  call   pscaler_TRANS
  add    esp,(size pscaler_stack)-8
@@cont:

  call   [sync_screen]
  cmp    [byte ISR_event],FIRST_DONE
  je     @@end
  cmp    [byte ISR_event],FIRST_FADEIN
  je     @@tFIRST_FADEIN
  jmp    @@done
@@tFIRST_FADEIN:
  xor    eax,eax
  mov    ecx,240
  mov    ebx,[logo_fadepal]
  call   fade_pal
@@done:
  call   key_pressed2
  jnc    @@paint
  call   get_key
  cmp    al,27
  je     @@end
  jmp    @@paint
@@end:
  mov    [RBBitmap_clipT],0
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; foreground scroller                                                     ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
scroll_text:               ;*
db "hello, back with another",13
db "demo by me jsno, for the",13
db "oz96 compo$"

db "in 640x480 resolution!,",13
db "slow but looks great$"

db "i wanted to see what it",13
db "would look like$"


db "2400 facets..$"

db "..listening to my aweful",13
db "music..$"

db "..and watching my not so",13
db "hot gfx either.$"

db "my greetings to$"

db "jase,therew,turtle,30sc",13
db "adam seychell,tom v.",13
db "dickydick,sh0ck,party$"

db "snowman,trixter,ior",13
db "pallbearer,stony,diab.",13
db "meredith,digger,floss$"

db "and of course the oz96",13
db "organisers!$"


MAX_LETTERS           = 100

struc tletter
  letter              db ?
  x                   dd ?
  y                   dd ?
ends

SHIFT_LETTER          = 8
scroll_pack_buf       tletter MAX_LETTERS dup(<>)
scroll_ptr            dd 0
cletters              dd ?

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                      ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc t_traject_pack ;load next font string
  mov    [cletters],0
  mov    edi,offset scroll_pack_buf
  mov    esi,[scroll_ptr]
  xor    ecx,ecx   ;x pos
  xor    ebx,ebx   ;y pos
@@l:
  movzx  eax,[byte esi+scroll_text]
  mov    [edi+tletter.letter],al
  mov    [edi+tletter.x],ebx
  mov    [edi+tletter.y],ecx
  cmp    al,"$"
  je     @@endpack
  inc    esi
  push   edi
  mov    edi,[font_pic]
  call   get_FNT_size     ;edi = fontdata;ebx = character;returns = eax
  pop    edi
  add    ebx,eax
  add    ebx,2

  cmp    [byte esi+scroll_text-1]," "
  je     @@dont_adv
  add    edi,size tletter
  inc    [cletters]
@@dont_adv:
  cmp    [byte esi+scroll_text],13
  jne    @@l
;nextline
  mov    ebx,0
  add    ecx,60
  inc    esi
  jmp    @@l
@@endpack:
  inc    esi
  mov    [scroll_ptr],esi

  mov    ecx,[cletters]
  mov    edi,offset scroll_pack_buf
  xor    edx,edx
  xor    ebx,ebx
@@l2:
  mov    eax,[edi+tletter.x]
  cmp    eax,ebx
  jle    @@dux
  mov    ebx,eax
@@dux:
  mov    eax,[edi+tletter.y]
  cmp    eax,edx
  jle    @@duy
  mov    edx,eax
@@duy:
  add    edi,size tletter
  dec    ecx
  jnz    @@l2

  shr    ebx,1
  shr    edx,1
  mov    eax,(640/2)-20
  sub    eax,ebx
  mov    ecx,(480/2)-80
  sub    ecx,edx

  mov    edx,[cletters]
  mov    edi,offset scroll_pack_buf
@@l3:
  add    [edi+tletter.x],eax
  add    [edi+tletter.y],ecx
  add    edi,size tletter
  dec    edx
  jnz    @@l3

  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                      ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
struc ttrajl
  status              db 0
  x                   dd ?
  y                   dd ?
  dx                  dd ?
  dy                  dd ?
  max_dx              dd 7fffffffh
  max_dy              dd 7fffffffh
  delay               dd ?
  donef_x             db 0
  donef_y             db 0
ends
trajl                 ttrajl MAX_LETTERS dup(<>)
trajl_trail           dd 0

;ebx = [esi+ttrajl.x]
;esi = [edi+tletter.x]
;edi = [esi+ttrajl.delay]
;ecx = [esi+ttrajl.dx]
;ebp = max dx
;dl  = [esi+ttrajl.donef]
proc traj_calc_x
  cmp    dl,1
  je     @@endx
  mov    eax,ebx
  sar    eax,SHIFT_LETTER
  cmp    eax,esi
  jl     @@lessthan
  jg     @@greaterthan
  mov    eax,ecx
  cmp    eax,0
  jge    @@nabsx
  neg    eax
@@nabsx:
  cmp    eax,ebp
  je     @@finishx
  jg     @@dsdxmax
  mov    ebp,eax
@@dsdxmax:
  jmp    @@donex
@@finishx:
  mov    dl,1
  jmp    @@endx
@@lessthan:
  add    ecx,edi
  cmp    ecx,0
  jge    @@donex
  add    ecx,edi
  jmp    @@donex
@@greaterthan:
  sub    ecx,edi
  cmp    ecx,0
  jle    @@donex
  sub    ecx,edi
  jmp    @@donex
@@donex:
  mov    eax,ecx
  sar    eax,SHIFT_LETTER
  add    ebx,eax
@@endx:
  ret
endp

proc traject_rand
  cmp    [@@skip],10
  je     @@cont
  inc    [@@skip]
  ret
@@cont:
  mov    [@@skip],0
  mov    esi,offset trajl
  mov    ecx,[cletters]
@@l:
  cmp    [esi+ttrajl.status],1
  je     @@ignore
  mov    eax,[trajl_trail]
  @find_sine
  and    eax,0fffffff0h
  sal    eax,SHIFT_LETTER-1
  add    eax,640/2 shl SHIFT_LETTER
  mov    [esi+ttrajl.x],eax
  mov    [esi+ttrajl.dx],1000h
  mov    [esi+ttrajl.max_dx],7fffffffh
  mov    [esi+ttrajl.donef_x],0
  mov    eax,[trajl_trail]
  mov    [esi+ttrajl.y],-50 shl SHIFT_LETTER
  mov    [esi+ttrajl.dy],1000h
  mov    [esi+ttrajl.max_dy],7fffffffh
  mov    [esi+ttrajl.donef_y],0
  mov    [esi+ttrajl.delay],0700h

  mov    [esi+ttrajl.status],1
  add    [trajl_trail],20h
  ret
@@ignore:
  add    esi,size ttrajl
  dec    ecx
  jnz    @@l
  ret
@@skip                dd 0
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
T_TRAG_1              = 0
T_TRAG_2              = 1
TRAG_init1            = 2
T_TRAG_3              = 3
T_TRAG_4              = 4
TRAG_init2            = 5
T_TRAG_5              = 6
TRAG_init3            = 7
T_TRAG_6              = 8
T_TRAG_DONE           = 9

t_traj_ISR_event      db ?
t_traj_ISR_pc         dd ?

proc t_traject_ISR
  cmp    [byte t_traj_ISR_event],T_TRAG_1
  je     @@jT_TRAG_1
  cmp    [byte t_traj_ISR_event],T_TRAG_2
  je     @@jT_TRAG_2
  cmp    [byte t_traj_ISR_event],T_TRAG_3
  je     @@jT_TRAG_3
  cmp    [byte t_traj_ISR_event],T_TRAG_4
  je     @@jT_TRAG_4
  cmp    [byte t_traj_ISR_event],T_TRAG_5
  je     @@jT_TRAG_5
  cmp    [byte t_traj_ISR_event],T_TRAG_6
  je     @@jT_TRAG_6
  ret
@@next_event:
  mov    [dword t_traj_ISR_pc],0
  inc    [byte t_traj_ISR_event]
  ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jT_TRAG_1:
  cmp    [dword t_traj_ISR_pc],1300
  jae    @@next_event
  inc    [dword t_traj_ISR_pc]

  call   traject_rand
  mov    esi,offset trajl
  mov    edi,offset scroll_pack_buf
  mov    ecx,[cletters]
@@TRAG1_ani:
  cmp    [esi+ttrajl.status],0
  je     @@ignore
  push   ecx
;;;;;
  mov    eax,[edi+tletter.x]
  mov    ebx,[esi+ttrajl.x]
  mov    ecx,[esi+ttrajl.dx]
  mov    ebp,[esi+ttrajl.max_dx]
  push   edi
  mov    edi,[esi+ttrajl.delay]
  mov    dl,[esi+ttrajl.donef_x]
  push   esi
  mov    esi,eax
  call   traj_calc_x
  pop    esi edi
  mov    [esi+ttrajl.donef_x],dl
  mov    [esi+ttrajl.max_dx],ebp
  mov    [esi+ttrajl.dx],ecx
  mov    [esi+ttrajl.x],ebx
;;;;;
  mov    eax,[edi+tletter.y]
  mov    ebx,[esi+ttrajl.y]
  mov    ecx,[esi+ttrajl.dy]
  mov    ebp,[esi+ttrajl.max_dy]
  push   edi
  mov    edi,[esi+ttrajl.delay]
  mov    dl,[esi+ttrajl.donef_y]
  push   esi
  mov    esi,eax
  call   traj_calc_x
  pop    esi edi
  mov    [esi+ttrajl.donef_y],dl
  mov    [esi+ttrajl.max_dy],ebp
  mov    [esi+ttrajl.dy],ecx
  mov    [esi+ttrajl.y],ebx

  pop    ecx
@@ignore:
  add    esi,size ttrajl
  add    edi,size tletter
  dec    ecx
  jnz    @@TRAG1_ani
  ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jT_TRAG_2:
  cmp    [dword t_traj_ISR_pc],300
  jae    @@next_event
  inc    [dword t_traj_ISR_pc]

  mov    edi,offset scroll_pack_buf
  mov    edx,[edi+tletter.y]
@@sub_line1:
  cmp    [edi+tletter.y],edx
  jne    @@next_line1
  sub    [edi+tletter.x],2
  add    edi,size tletter
  jmp    @@sub_line1
@@next_line1:

  mov    edx,[edi+tletter.y]
@@sub_line2:
  cmp    [edi+tletter.y],edx
  jne    @@next_line2
  add    [edi+tletter.x],2
  add    edi,size tletter
  jmp    @@sub_line2
@@next_line2:

;  mov    edx,[edi+tletter.y]
@@sub_line4:
  cmp    [edi+tletter.letter],"$"
  je     @@next_line4
  sub    [edi+tletter.x],2
  add    edi,size tletter
  jmp    @@sub_line4
@@next_line4:
  ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jT_TRAG_3:
  cmp    [dword t_traj_ISR_pc],800
  jae    @@next_event
  inc    [dword t_traj_ISR_pc]

  call   t_traject_3_c
  mov    esi,offset trajl
  mov    edi,offset scroll_pack_buf
  mov    ecx,[cletters]
@@t_t3l:
  cmp    [esi+ttrajl.status],1
  jne    @@ignt_t3
  add    [esi+ttrajl.y],4
  mov    eax,[edi+tletter.y]
  cmp    [esi+ttrajl.y],eax
  jl     @@ignt_t3
  mov    [esi+ttrajl.status],2
  mov    [esi+ttrajl.y],eax
@@ignt_t3:
  add    esi,size ttrajl
  add    edi,size tletter
  dec    ecx
  jnz    @@t_t3l
  ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jT_TRAG_4:
  cmp    [dword t_traj_ISR_pc],800
  jae    @@next_event
  inc    [dword t_traj_ISR_pc]

  call   t_traject_4_c
  mov    esi,offset trajl
  mov    edi,offset scroll_pack_buf
  mov    ecx,[cletters]
@@t_t4l:
  cmp    [esi+ttrajl.status],3
  jne    @@ignt_t4
  sub    [esi+ttrajl.y],4
  cmp    [esi+ttrajl.y],-50
  jge    @@ignt_t4
  mov    [esi+ttrajl.status],4
@@ignt_t4:
  add    esi,size ttrajl
  add    edi,size tletter
  dec    ecx
  jnz    @@t_t4l
  ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jT_TRAG_5:
  cmp    [dword t_traj_ISR_pc],1000
  jae    @@next_event
  inc    [dword t_traj_ISR_pc]

  call   t_traject_5_c
  mov    esi,offset trajl
  mov    edi,offset scroll_pack_buf
  mov    ecx,[cletters]
@@t_t5l:
  cmp    [esi+ttrajl.status],1
  je     @@loop
  cmp    [esi+ttrajl.status],2
  je     @@noloop
  cmp    [esi+ttrajl.status],3
  je     @@ignt_t5
  jmp    @@ignt_t5
@@loop:
  mov    eax,[esi+ttrajl.dy]
  add    [esi+ttrajl.y],eax
  add    [esi+ttrajl.dy],100h/30h
  cmp    [esi+ttrajl.y],400 shl SHIFT_LETTER
  jle    @@ignt_t5
  neg    [esi+ttrajl.dy]
  mov    [esi+ttrajl.status],2
  jmp    @@ignt_t5
@@noloop:
  mov    eax,[esi+ttrajl.dy]
  add    [esi+ttrajl.y],eax
  add    [esi+ttrajl.dy],(215h/30h)-2
  mov    eax,[esi+ttrajl.y]
  sar    eax,SHIFT_LETTER
  cmp    eax,[edi+tletter.y]
  jge    @@ignt_t5
  mov    [esi+ttrajl.status],3
  mov    eax,[edi+tletter.y]
  sal    eax,SHIFT_LETTER
  mov    [esi+ttrajl.y],eax
@@ignt_t5:
  add    esi,size ttrajl
  add    edi,size tletter
  dec    ecx
  jnz    @@t_t5l
  ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jT_TRAG_6:
  cmp    [dword t_traj_ISR_pc],500
  jae    @@next_event
  inc    [dword t_traj_ISR_pc]

  mov    esi,offset trajl
  mov    ecx,[cletters]
@@t_t6l:
  mov    eax,[esi+ttrajl.dx]
  add    [esi+ttrajl.x],eax
  mov    eax,[esi+ttrajl.dy]
  add    [esi+ttrajl.y],eax
  add    esi,size ttrajl
  dec    ecx
  jnz    @@t_t6l
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc t_traject_init
  mov    al,256-32
  mov    ecx,font_pal_size
  mov    esi,offset font_pal
  @WritePalette

  call   t_traject_pack
  mov    [byte t_traj_ISR_event],T_TRAG_1
  mov    [dword t_traj_ISR_pc],0
  ret
endp

proc t_traject_3_c
  cmp    [@@skip],10
  je     @@cont
  inc    [@@skip]
  ret
@@cont:
  mov    [@@skip],0
  mov    esi,offset trajl
  mov    edi,offset scroll_pack_buf
  mov    ecx,[cletters]
@@l:
  cmp    [esi+ttrajl.status],0
  jne    @@ignore
  mov    eax,[edi+tletter.x]
  mov    [esi+ttrajl.x],eax
  mov    [esi+ttrajl.y],-50
  mov    [esi+ttrajl.status],1
  ret
@@ignore:
  add    esi,size ttrajl
  add    edi,size tletter
  dec    ecx
  jnz    @@l
  ret
@@skip                dd 0
endp

proc t_traject_4_c
  cmp    [@@skip],10
  je     @@cont
  inc    [@@skip]
  ret
@@cont:
  mov    [@@skip],0
  mov    esi,offset trajl
  mov    edi,offset scroll_pack_buf
  mov    ecx,[cletters]
@@l:
  cmp    [esi+ttrajl.status],2
  jne    @@ignore
  mov    [esi+ttrajl.status],3
  ret
@@ignore:
  add    esi,size ttrajl
  add    edi,size tletter
  dec    ecx
  jnz    @@l
  ret
@@skip                dd 0
endp

proc t_traject_5_c
  cmp    [@@skip],10
  je     @@cont
  inc    [@@skip]
  ret
@@cont:
  mov    [@@skip],0
  mov    esi,offset trajl
  mov    edi,offset scroll_pack_buf
  mov    ecx,[cletters]
@@l:
  cmp    [esi+ttrajl.status],0
  jne    @@ignore
  mov    eax,[edi+tletter.x]
  mov    [esi+ttrajl.x],eax

  mov    eax,[edi+tletter.y]
  sub    eax,250
  sal    eax,SHIFT_LETTER
  mov    [esi+ttrajl.y],eax
  mov    [esi+ttrajl.dy],0
  mov    [esi+ttrajl.status],1
  ret
@@ignore:
  add    esi,size ttrajl
  add    edi,size tletter
  dec    ecx
  jnz    @@l
  ret
@@skip                dd 0
endp

proc t_traject
  cmp    [byte t_traj_ISR_event],T_TRAG_1
  je     @@jT_TRAG_1
  cmp    [byte t_traj_ISR_event],T_TRAG_2
  je     @@jT_TRAG_2
  cmp    [byte t_traj_ISR_event],TRAG_init1
  je     @@jTRAG_init1
  cmp    [byte t_traj_ISR_event],T_TRAG_3
  je     @@jT_TRAG_3
  cmp    [byte t_traj_ISR_event],T_TRAG_4
  je     @@jT_TRAG_4
  cmp    [byte t_traj_ISR_event],TRAG_init2
  je     @@jTRAG_init2
  cmp    [byte t_traj_ISR_event],T_TRAG_5
  je     @@jT_TRAG_5
  cmp    [byte t_traj_ISR_event],TRAG_init3
  je     @@jTRAG_init3
  cmp    [byte t_traj_ISR_event],T_TRAG_6
  je     @@jT_TRAG_6

  jmp    @@paint_done
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jT_TRAG_1:
  mov    esi,offset trajl
  mov    edi,offset scroll_pack_buf
  mov    ecx,[cletters]
@@TRAG1_ani:
  cmp    [esi+ttrajl.status],0
  je     @@ignore
  push   ecx esi edi

  xor    eax,eax
  mov    al,[edi+tletter.letter]
  push   eax
  push   [font_pic]
  push   [Rendbuff]
  mov    ebx,[esi+ttrajl.x]
  mov    eax,[esi+ttrajl.y]
  sar    ebx,SHIFT_LETTER
  sar    eax,SHIFT_LETTER
  push   ebx
  push   eax
  push   640
  call   draw_FNT
  add    esp,(size draw_FNT_stack)-4

  pop    edi esi ecx
@@ignore:
  add    esi,size ttrajl
  add    edi,size tletter
  dec    ecx
  jnz    @@TRAG1_ani
  jmp    @@paint_done
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jT_TRAG_2:
  mov    edi,offset scroll_pack_buf
  mov    ecx,[cletters]
@@TRAG2_so:
  push   ecx edi
  xor    eax,eax
  mov    al,[edi+tletter.letter]
  push   eax
  push   [font_pic]
  push   [Rendbuff]
  push   [edi+tletter.x]
  push   [edi+tletter.y]
  push   640
  call   draw_FNT
  add    esp,(size draw_FNT_stack)-4
  pop    edi ecx
  add    edi,size tletter
  dec    ecx
  jnz    @@TRAG2_so
  jmp    @@paint_done
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jTRAG_init1:
  call   t_traject_pack
  mov    esi,offset trajl
  mov    ecx,[cletters]
@@clr_tt_s:
  mov    [esi+ttrajl.status],0
  add    esi,size ttrajl
  dec    ecx
  jnz    @@clr_tt_s
  mov    [dword t_traj_ISR_pc],0
  inc    [byte t_traj_ISR_event]
  jmp    @@paint_done
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jT_TRAG_3:
  mov    esi,offset trajl
  mov    edi,offset scroll_pack_buf
  mov    ecx,[cletters]
@@t_traj_3_l:
  cmp    [esi+ttrajl.status],0
  je     @@it_traj_3_l
  push   ecx esi edi

  xor    eax,eax
  mov    al,[edi+tletter.letter]
  push   eax
  push   [font_pic]
  push   [Rendbuff]
  push   [esi+ttrajl.x]
  push   [esi+ttrajl.y]
  push   640
  call   draw_FNT
  add    esp,(size draw_FNT_stack)-4
  pop    edi esi ecx
@@it_traj_3_l:
  add    esi,size ttrajl
  add    edi,size tletter
  dec    ecx
  jnz    @@t_traj_3_l
  jmp    @@paint_done
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jT_TRAG_4:
  mov    esi,offset trajl
  mov    edi,offset scroll_pack_buf
  mov    ecx,[cletters]
@@t_traj_4_l:
  cmp    [esi+ttrajl.status],4
  je     @@it_traj_4_l
  push   ecx esi edi

  xor    eax,eax
  mov    al,[edi+tletter.letter]
  push   eax
  push   [font_pic]
  push   [Rendbuff]
  push   [esi+ttrajl.x]
  push   [esi+ttrajl.y]
  push   640
  call   draw_FNT
  add    esp,(size draw_FNT_stack)-4
  pop    edi esi ecx
@@it_traj_4_l:
  add    esi,size ttrajl
  add    edi,size tletter
  dec    ecx
  jnz    @@t_traj_4_l
  jmp    @@paint_done
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jTRAG_init2:
  call   t_traject_pack
  mov    esi,offset trajl
  mov    ecx,[cletters]
@@l:
  mov    [esi+ttrajl.status],0
  add    esi,size ttrajl
  dec    ecx
  jnz    @@l
  mov    [dword t_traj_ISR_pc],0
  inc    [byte t_traj_ISR_event]
  jmp    @@paint_done
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jT_TRAG_5:
  mov    esi,offset trajl
  mov    edi,offset scroll_pack_buf
  mov    ecx,[cletters]
@@t_traj_5_l:
  cmp    [esi+ttrajl.status],0
  je     @@it_traj_5_l
  push   ecx esi edi

  xor    eax,eax
  mov    al,[edi+tletter.letter]
  push   eax
  push   [font_pic]
  push   [Rendbuff]
  push   [esi+ttrajl.x]
  mov    eax,[esi+ttrajl.y]
  sar    eax,SHIFT_LETTER
  push   eax
  push   640
  call   draw_FNT
  add    esp,(size draw_FNT_stack)-4
  pop    edi esi ecx
@@it_traj_5_l:
  add    esi,size ttrajl
  add    edi,size tletter
  dec    ecx
  jnz    @@t_traj_5_l
  jmp    @@paint_done
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jTRAG_init3:
  mov    esi,offset trajl
  mov    edi,offset scroll_pack_buf
  mov    ecx,[cletters]
@@lTinit3:
  call   random
  mov    ebx,100h
  test   al,1
  jz     @@lTinit3x1
  neg    ebx
@@lTinit3x1:
  mov    [esi+ttrajl.dx],ebx
  mov    ebx,100h
  test   ah,1
  jz     @@lTinit3y1
  neg    ebx
@@lTinit3y1:
  mov    [esi+ttrajl.dy],ebx

  mov    eax,[edi+tletter.x]
  sal    eax,SHIFT_LETTER
  mov    [esi+ttrajl.x],eax
  mov    eax,[edi+tletter.y]
  sal    eax,SHIFT_LETTER
  mov    [esi+ttrajl.y],eax

  add    esi,size ttrajl
  add    edi,size tletter
  dec    ecx
  jnz    @@lTinit3
  mov    [dword t_traj_ISR_pc],0
  inc    [byte t_traj_ISR_event]
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jT_TRAG_6:
  mov    esi,offset trajl
  mov    edi,offset scroll_pack_buf
  mov    ecx,[cletters]
@@t_traj_6_l:
  cmp    [esi+ttrajl.status],0
  je     @@it_traj_6_l
  push   ecx esi edi

  xor    eax,eax
  mov    al,[edi+tletter.letter]
  push   eax
  push   [font_pic]
  push   [Rendbuff]
  mov    eax,[esi+ttrajl.x]
  sar    eax,SHIFT_LETTER
  push   eax
  mov    eax,[esi+ttrajl.y]
  sar    eax,SHIFT_LETTER
  push   eax
  push   640
  call   draw_FNT
  add    esp,(size draw_FNT_stack)-4
  pop    edi esi ecx
@@it_traj_6_l:
  add    esi,size ttrajl
  add    edi,size tletter
  dec    ecx
  jnz    @@t_traj_6_l
@@paint_done:
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; background scroller                                                     ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
MAINBK_00_FADEIN      = 0
MAINBK_00_WAIT        = 1
MAINBK_00_FADEOUT     = 2
MAINBK_01_FADEIN      = 3
MAINBK_01_WAIT        = 4
MAINBK_01_FADEOUT     = 5
MAINBK_DONE           = 6

mainbk_picptr         dd ?
mainbk_pal_fade       dd 0

sine_ptr1             dd 0
sine_ptr2             dd 0
paint_bk_mapx         dd -600
paint_bk_mapy         dd -600

ft_2_x                dd -256 shl BREAK_shifter
ft_2_y                dd -256 shl BREAK_shifter

ROCKET_SHIFTV         = 4
struc trocket_a
  status              db ?
  x                   dd ?
  y                   dd ?
  dx                  dd ?
ends

NO_OF_ROCKETS         = 25
rocket_a              trocket_a NO_OF_ROCKETS dup(<-1,0,0>)

proc rocket_create
  call   random
  and    al,0fh
  jz     @@cont
  ret
@@cont:
  mov    ecx,NO_OF_ROCKETS
  mov    esi,offset rocket_a
@@l:
  cmp    [byte esi+trocket_a.status],-1
  jne    @@skip
  mov    [esi+trocket_a.y],-100 shl ROCKET_SHIFTV
  call   random
  and    eax,01ffh
  add    eax,(640/2)-(1ffh/2)
  sal    eax,ROCKET_SHIFTV
  mov    [esi+trocket_a.x],eax
  call   random
  and    eax,01fh
  sub    eax,0fh
  mov    [esi+trocket_a.dx],eax
  mov    [byte esi+trocket_a.status],0
  jmp    @@end
@@skip:
  add    esi,size trocket_a
  dec    ecx
  jnz    @@l
@@end:
  ret
endp

proc rocket_calc
  mov    ecx,NO_OF_ROCKETS
  mov    esi,offset rocket_a
@@l:
  cmp    [byte esi+trocket_a.status],-1
  je     @@skip
  mov    eax,[esi+trocket_a.dx]
  add    [esi+trocket_a.x],eax
  add    [esi+trocket_a.y],4 shl ROCKET_SHIFTV
  cmp    [esi+trocket_a.y],480 shl ROCKET_SHIFTV
  jl     @@skip
  mov    [byte esi+trocket_a.status],-1
@@skip:
  add    esi,size trocket_a
  dec    ecx
  jnz    @@l
@@end:
  ret
endp

proc pmain_bk_sine00
  mov    eax,[sine_ptr1]
  @find_sine
  sar    eax,2
  sub    eax,600
  mov    [paint_bk_mapx],eax

  mov    eax,[sine_ptr2]
  @find_sine
  sar    eax,2
  sub    eax,600
  mov    [paint_bk_mapy],eax

  sub    [dword sine_ptr1],3
  add    [dword sine_ptr2],5
  ret
endp

proc pmain_bk_sine01
  mov    eax,[sine_ptr1]
  @find_sine
  sar    eax,3
  sub    eax,600
  mov    [paint_bk_mapx],eax

  mov    eax,[sine_ptr2]
  @find_cosine
  sar    eax,3
  sub    eax,600
  mov    [paint_bk_mapy],eax

  sub    [dword sine_ptr1],3
  add    [dword sine_ptr2],2
  ret
endp

spin_mb_ISR_pc        dd 0
spin_mb_ISR_event     dd 0

proc spin_mb
  cmp    [byte spin_mb_ISR_event],0
  je     @@j0
  cmp    [byte spin_mb_ISR_event],1
  je     @@jspindown
  cmp    [byte spin_mb_ISR_event],2
  je     @@jexpand
  cmp    [byte spin_mb_ISR_event],3
  je     @@jspin1
  cmp    [byte spin_mb_ISR_event],4
  je     @@jspin2
  cmp    [byte spin_mb_ISR_event],5
  je     @@jspin3
  cmp    [byte spin_mb_ISR_event],6
  je     @@jspin4
  cmp    [byte spin_mb_ISR_event],7
  je     @@jspin5
  ret
@@next_event:
  mov    [dword spin_mb_ISR_pc],0
  inc    [byte spin_mb_ISR_event]
  ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@j0:
  cmp    [dword spin_mb_ISR_pc],110
  jae    @@next_event
  inc    [dword spin_mb_ISR_pc]
  add    [angle1],10
  add    [ft_2_x],500h
  add    [ft_2_y],500h
  ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jspindown:
  cmp    [dword spin_mb_ISR_pc],50
  jae    @@next_event
  inc    [dword spin_mb_ISR_pc]
  add    [angle1],16
  ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jexpand:
  cmp    [dword spin_mb_ISR_pc],50
  jae    @@next_event
  inc    [dword spin_mb_ISR_pc]

  add    [angle1],3
  add    [scaler1],200h
  sub    [ft_2_x],0a0h
  sub    [ft_2_y],0a0h
  ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jspin1:
  cmp    [dword spin_mb_ISR_pc],70
  jae    @@next_event
  inc    [dword spin_mb_ISR_pc]
  sub    [angle1],12
  sub    [ft_2_x],200h
  sub    [ft_2_y],100h
  ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jspin2:
  cmp    [dword spin_mb_ISR_pc],140
  jae    @@next_event
  inc    [dword spin_mb_ISR_pc]
  add    [scaler1],20*40
  sub    [angle1],16
  add    [ft_2_x],220h
  sub    [ft_2_y],040h
  ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jspin3:
  cmp    [dword spin_mb_ISR_pc],40
  jae    @@next_event
  inc    [dword spin_mb_ISR_pc]
  sub    [scaler1],20*140
  sub    [angle1],12
  sub    [ft_2_x],600h
  add    [ft_2_y],100h
  ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jspin4:
  cmp    [dword spin_mb_ISR_pc],70
  jae    @@next_event
  inc    [dword spin_mb_ISR_pc]
  add    [scaler1],100h
  add    [angle1],8
  add    [ft_2_x],600h
  add    [ft_2_y],300h
  ret
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@jspin5:
  cmp    [dword spin_mb_ISR_pc],120
  jae    @@next_event
  inc    [dword spin_mb_ISR_pc]
  sub    [scaler1],300h
  add    [angle1],12
  sub    [ft_2_x],200h
  sub    [ft_2_y],280h
  ret
endp

proc pmainbk_ISR
  call   t_traject_ISR           ; foreground scroller calc
  cmp    [byte ISR_event],MAINBK_00_FADEIN
  je     @@jMAINBK_00_FADEIN
  cmp    [byte ISR_event],MAINBK_00_WAIT
  je     @@jMAINBK_00_WAIT
  cmp    [byte ISR_event],MAINBK_00_FADEOUT
  je     @@jMAINBK_00_FADEOUT

  cmp    [byte ISR_event],MAINBK_01_FADEIN
  je     @@jMAINBK_01_FADEIN
  cmp    [byte ISR_event],MAINBK_01_WAIT
  je     @@jMAINBK_01_WAIT
  cmp    [byte ISR_event],MAINBK_01_FADEOUT
  je     @@jMAINBK_01_FADEOUT
  ret
@@next_event:
  mov    [dword ISR_pc],0
  inc    [byte ISR_event]
  ret
@@jMAINBK_00_FADEIN:
  call   rocket_calc
  cmp    [dword ISR_pc],256
  jae    @@next_event
  inc    [dword ISR_pc]
  call   pmain_bk_sine00
  mov    eax,1
  mov    ebx,[dword mainbk_pal_fade]
  call   clip_ipal
  mov    [dword mainbk_pal_fade],ebx
  ret
@@jMAINBK_00_WAIT:
  call   rocket_calc
  cmp    [dword ISR_pc],300
  jae    @@next_event
  inc    [dword ISR_pc]
  call   pmain_bk_sine00
  ret
@@jMAINBK_00_FADEOUT:
  call   rocket_calc
  cmp    [dword ISR_pc],256
  jae    @@jMAINBK_00_CHANGE
  add    [dword ISR_pc],1
  call   pmain_bk_sine00
  mov    eax,1
  mov    ebx,[dword mainbk_pal_fade]
  call   clip_dpal
  mov    [dword mainbk_pal_fade],ebx
  ret
@@jMAINBK_00_CHANGE:
  mov    eax,[merg_1_pic]
  mov    [mainbk_picptr],eax
  mov    esi,[merg_1_pal]
  xor    eax,eax
  mov    ecx,224
  call   fade_pal_init
  mov    [scaler1],10000h
  mov    [angle1],0
  jmp    @@next_event
@@jMAINBK_01_FADEIN:
  cmp    [dword ISR_pc],256
  jae    @@next_event
  add    [dword ISR_pc],1
  call   pmain_bk_sine01
  mov    eax,1
  mov    ebx,[dword mainbk_pal_fade]
  call   clip_ipal
  mov    [dword mainbk_pal_fade],ebx
  call   spin_mb
  ret
@@jMAINBK_01_WAIT:
  cmp    [dword ISR_pc],200
  jae    @@next_event
  inc    [dword ISR_pc]
  call   pmain_bk_sine01
  call   spin_mb
  ret
@@jMAINBK_01_FADEOUT:
  cmp    [dword ISR_pc],256
  jae    @@next_event
  add    [dword ISR_pc],1
  call   pmain_bk_sine01
  mov    eax,1
  mov    ebx,[dword mainbk_pal_fade]
  call   clip_dpal
  mov    [dword mainbk_pal_fade],ebx
  call   spin_mb
  ret
endp

proc paint_mainbk
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  mov    edx,256*256
  mov    eax,0EE42h         ; allocate a DOS32 memory block
  Int    31h                ;  expects EDX = size; ret EAX=size, EDX->pointer
  mov    [pic_mt1],edx
  mov    edi,edx

  mov    esi,[merg_2_pic]
  add    esi,4
  xor    ebx,ebx
  mov    ch,8
@@alloc_y:
  push   esi

  mov    cl,8
@@alloc_x:
  push   ecx esi

  mov    dl,32
@@copy_d:                   ;copy section of data to box
  mov    ecx,32/4
  rep    movsd
  add    esi,256-32
  dec    dl
  jnz    @@copy_d

  pop    esi ecx
  add    esi,32
  dec    cl
  jnz    @@alloc_x

  pop    esi
  add    esi,256*32
  dec    ch
  jnz    @@alloc_y

;;
  mov    esi,offset ba_r
  mov    ch,8
  mov    ebx,((-32*4) + (32/2)) shl BREAK_shifter
@@s_coordy:
  mov    eax,((-32*4) + (32/2)) shl BREAK_shifter
  mov    cl,8
@@s_coordx:
  mov    [esi+tba_r.x],eax
  mov    [esi+tba_r.y],ebx
  add    eax,32 shl BREAK_shifter
  add    esi,size tba_r
  dec    cl
  jnz    @@s_coordx
  add    ebx,32 shl BREAK_shifter
  dec    ch
  jnz    @@s_coordy
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  call   totally_clear_screen

  mov    esi,[text00_pal]
  xor    eax,eax
  mov    ecx,256-64
  call   fade_pal_init

  mov    al,256-64
  mov    ecx,21*3
  mov    esi,offset anirocket_pal
  @WritePalette

  mov    eax,[text00_pic]
  mov    [mainbk_picptr],eax

  mov    [ISR_event],MAINBK_00_FADEIN
  mov    [ISR_pc],0
  mov    eax,offset pmainbk_ISR
  mov    [fg_calc],eax
@@paint:
  mov    edx,[mainbk_picptr]
  mov    ebx,[paint_bk_mapx]
  mov    esi,[paint_bk_mapy]
  mov    ecx,5
@@mp_y:
  push   ecx ebx
  cmp    esi,-256
  jl     @@ign_y
  cmp    esi,640+256
  jg     @@ign_y
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  mov    ecx,6
@@pm_x:
  cmp    ebx,-256
  jl     @@ign_x
  cmp    ebx,640+256
  jg     @@ign_x
  push   edx ecx ebx esi
  mov    eax,edx
  add    eax,4
  push   eax
  push   [dword Rendbuff]
  push   ebx
  push   esi
  xor    eax,eax
  mov    ax,[word edx]
  push   eax
  mov    ax,[word 2+edx]
  push   eax
  push   640
  call   RBBitmap
  add    esp,(size RBBitmap_stack)-8
  pop    esi ebx ecx edx
@@ign_x:
  xor    eax,eax
  mov    ax,[word edx]
  add    ebx,eax
  dec    ecx
  jnz    @@pm_x
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@ign_y:
  xor    eax,eax
  mov    ax,[word edx+2]
  add    esi,eax
  pop    ebx ecx
  dec    ecx
  jnz    @@mp_y

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  cmp    [byte ISR_event],MAINBK_01_FADEIN
  jb     @@skip2

  mov    edi,offset ba_r
  mov    esi,[pic_mt1]
  xor    edx,edx
  mov    ch,8
@@alloc_y2:
  xor    ebx,ebx
  mov    cl,8
@@alloc_x2:
  push   ebx ecx esi edi

  push   esi
  push   [dword Rendbuff]

  mov    esi,[angle1]
  mov    eax,[scaler1]
  imul   [edi+tba_r.x]
  shrd   eax,edx,16
  mov    ebx,eax

  mov    esi,[angle1]
  mov    eax,[scaler1]
  imul   [edi+tba_r.y]
  shrd   eax,edx,16
  mov    ecx,eax

  call   RotateXY
  sub    ebx,(32/2) shl BREAK_shifter
  sub    ecx,(32/2) shl BREAK_shifter
  add    ebx,[ft_2_x]
  sar    ebx,BREAK_shifter
  add    ecx,[ft_2_y]
  sar    ecx,BREAK_shifter
  push   ebx
  push   ecx
  push   32
  push   32
  push   640
  call   RBBitmap
  add    esp,(size RBBitmap_stack)-8


  pop    edi esi ecx ebx
  add    edi,size tba_r
  add    esi,32*32
  dec    cl
  jnz    @@alloc_x2
  dec    ch
  jnz    @@alloc_y2
@@skip2:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  cmp    [byte ISR_event],MAINBK_00_WAIT
  ja     @@jdont_create
  call   rocket_create
@@jdont_create:
  mov    ecx,NO_OF_ROCKETS
  mov    esi,offset rocket_a
@@l:
  push   ecx esi
  cmp    [byte esi+trocket_a.status],-1
  je     @@skip
  mov    eax,[r_b_pic]
  xchg   eax,[r_a_pic]
  mov    [r_b_pic],eax
  mov    edx,eax
  add    eax,4
  push   eax
  push   [dword Rendbuff]
  mov    eax,[dword esi+trocket_a.x]
  sar    eax,ROCKET_SHIFTV
  push   eax
  mov    eax,[dword esi+trocket_a.y]
  sar    eax,ROCKET_SHIFTV
  push   eax
  xor    eax,eax
  mov    ax,[word edx]
  push   eax
  mov    ax,[word 2+edx]
  push   eax
  push   640
  call   RBBitmap_TRANS
  add    esp,(size RBBitmap_stack)-8
@@skip:
  pop    esi ecx
  add    esi,size trocket_a
  dec    ecx
  jnz    @@l
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  cmp    [byte ISR_event],MAINBK_DONE
  je     @@end
  cmp    [byte ISR_event],MAINBK_00_FADEIN
  je     @@fade_pal
  cmp    [byte ISR_event],MAINBK_00_FADEOUT
  je     @@fade_pal
  cmp    [byte ISR_event],MAINBK_01_FADEIN
  je     @@fade_pal2
  cmp    [byte ISR_event],MAINBK_01_FADEOUT
  je     @@fade_pal2
  jmp    @@cont
@@fade_pal:
  mov    ecx,180
  jmp    @@fade_c
@@fade_pal2:
  mov    ecx,224
@@fade_c:
  xor    eax,eax
  mov    ebx,[dword mainbk_pal_fade]
  call   fade_pal
@@cont:
  call   t_traject            ;paint foreground scroller
  call   [sync_screen]
  call   key_pressed2
  jnc    @@paint
  call   get_key
  cmp    al,27
  je     @@end
  jmp    @@paint
@@end:

  mov    eax,0EE40h         ; delocate
  int    31h
  ret
endp


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; ARCADE GAME scene                                                       ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; "CONQUEST OVER" ring scroller                                           ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
a_rings_rotate        dd 0

struc ta_rings_data
  pic_addr            dd ?
  angle               dd ?
ends

a_rings_data          ta_rings_data 12 dup(<>)

ARING_SPACING         = 145

proc a_rings_init
  mov    edx,42*42*2
  mov    eax,0EE42h         ; allocate a DOS32 memory block
  Int    31h                ;  expects EDX = size; ret EAX=size, EDX->pointer
  mov    [pic_mt1],edx

  mov    edi,[pic_mt1]                ; init bm rotator
  mov    eax,42
  mov    ebx,42
  call   BM_rotate_init

  mov    eax,[arcade_c_pic]
  mov    [a_rings_data+(size ta_rings_data*00).pic_addr],eax
  mov    [a_rings_data+(size ta_rings_data*00).angle],ARING_SPACING*0

  mov    eax,[arcade_o_pic]
  mov    [a_rings_data+(size ta_rings_data*01).pic_addr],eax
  mov    [a_rings_data+(size ta_rings_data*01).angle],ARING_SPACING*1

  mov    eax,[arcade_n_pic]
  mov    [a_rings_data+(size ta_rings_data*02).pic_addr],eax
  mov    [a_rings_data+(size ta_rings_data*02).angle],ARING_SPACING*2

  mov    eax,[arcade_q_pic]
  mov    [a_rings_data+(size ta_rings_data*03).pic_addr],eax
  mov    [a_rings_data+(size ta_rings_data*03).angle],ARING_SPACING*3

  mov    eax,[arcade_u_pic]
  mov    [a_rings_data+(size ta_rings_data*04).pic_addr],eax
  mov    [a_rings_data+(size ta_rings_data*04).angle],ARING_SPACING*4

  mov    eax,[arcade_e_pic]
  mov    [a_rings_data+(size ta_rings_data*05).pic_addr],eax
  mov    [a_rings_data+(size ta_rings_data*05).angle],ARING_SPACING*5

  mov    eax,[arcade_s_pic]
  mov    [a_rings_data+(size ta_rings_data*06).pic_addr],eax
  mov    [a_rings_data+(size ta_rings_data*06).angle],ARING_SPACING*6

  mov    eax,[arcade_t_pic]
  mov    [a_rings_data+(size ta_rings_data*07).pic_addr],eax
  mov    [a_rings_data+(size ta_rings_data*07).angle],ARING_SPACING*7

  mov    eax,[arcade_o_pic]
  mov    [a_rings_data+(size ta_rings_data*08).pic_addr],eax
  mov    [a_rings_data+(size ta_rings_data*08).angle],ARING_SPACING*9

  mov    eax,[arcade_v_pic]
  mov    [a_rings_data+(size ta_rings_data*09).pic_addr],eax
  mov    [a_rings_data+(size ta_rings_data*09).angle],ARING_SPACING*10

  mov    eax,[arcade_e_pic]
  mov    [a_rings_data+(size ta_rings_data*10).pic_addr],eax
  mov    [a_rings_data+(size ta_rings_data*10).angle],ARING_SPACING*11

  mov    eax,[arcade_r_pic]
  mov    [a_rings_data+(size ta_rings_data*11).pic_addr],eax
  mov    [a_rings_data+(size ta_rings_data*11).angle],ARING_SPACING*12

  ret
endp

proc a_rings_deinit
  mov    eax,0EE40h           ; delocate rotational mult table
  int    31h
  ret
endp

proc paint_a_rings
  mov    esi,offset a_rings_data
  mov    cl,12
@@l:
  push   ecx esi
  mov    eax,[a_rings_rotate]
  add    eax,[esi+ta_rings_data.angle]
  @find_sine
  sar    eax,2
  add    eax,(640/2)-(42/2)
  mov    [@@x_pos],eax

  mov    eax,[a_rings_rotate]
  add    eax,[esi+ta_rings_data.angle]
  @find_cosine
  sar    eax,2
  add    eax,(480/2)-(42/2)
  mov    [@@y_pos],eax

  mov    edx,[esi+ta_rings_data.pic_addr]
  mov    eax,edx
  add    eax,4
  push   eax
  push   [Rendbuff]
  push   [pic_mt1]
  push   [@@x_pos]
  push   [@@y_pos]
  mov    eax,[a_rings_rotate]
  add    eax,[esi+ta_rings_data.angle]
  and    eax,0fffh
  neg    eax
  push   eax
  movzx  eax,[word edx]
  push   eax
  movzx  eax,[word edx+2]
  push   eax
  push   640
  call   BM_rotate_TRANS
  add    esp,(size BM_rotate_stack)-4

  pop    esi ecx
  add    esi,size ta_rings_data
  dec    cl
  jnz    @@l
  ret
@@x_pos               dd ?
@@y_pos               dd ?
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; star code                                                               ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
no_stars              = 100

struc tstar_map
  type                db ?
  x                   dd ?
  y                   dd ?
ends
star_map              tstar_map no_stars dup(<-1,0,0>)

proc create_star
  call   random
  and    eax,003h
  jz     @@cont
  ret
@@cont:
  xor    ecx,ecx
@@create_stars:
  lea    esi,[ecx*8+ecx]
  cmp    [byte esi+star_map.type],-1
  jne    @@ignore
  call   random
  and    eax,03ffh
  cmp    eax,640
  jge    @@ignore
  mov    [dword esi+star_map.x],eax
  mov    [dword esi+star_map.y],0
  call   random
  and    al,0fh
  mov    [esi+star_map.type],al
  jmp    @@end
@@ignore:
  inc    ecx
  cmp    ecx,no_stars
  jb     @@create_stars
@@end:
  ret
endp

proc mapp_star_calc
  xor    ecx,ecx
@@display_stars:
  lea    esi,[ecx*8+ecx]
  cmp    [byte esi+star_map.type],-1
  je     @@done
  cmp    [dword esi+star_map.y],480
  jl     @@display_star
  mov    [byte esi+star_map.type],-1
  jmp    @@done
@@display_star:
  inc    [dword esi+star_map.y]
@@done:
  inc    ecx
  cmp    ecx,no_stars
  jb     @@display_stars
  ret
endp

proc mapp_star_init
  mov    edx,480
@@l:
  push   edx
  call   create_star
  call   mapp_star_calc
  pop    edx
  dec    edx
  jnz    @@l
  ret
endp

proc mapp_star
  call   clear_screen
  call   create_star
  xor    ecx,ecx
@@display_stars:
  push   ecx
  lea    esi,[ecx*8+ecx]
  cmp    [byte esi+star_map.type],-1
  je     @@done
  mov    edi,[dword esi+star_map.y]
  cmp    edi,480
  jl     @@pd
  mov    [byte esi+star_map.type],-1
  jmp    @@done
@@pd:
  shl    edi,7
  mov    ebx,edi
  lea    edi,[edi*4]
  add    edi,ebx
  add    edi,[dword esi+star_map.x]
  add    edi,[dword Rendbuff]
  mov    al,[byte esi+star_map.type]
  mov    [edi],al
;  inc    [dword esi+star_map.y]
@@done:
  pop    ecx
  inc    ecx
  cmp    ecx,no_stars
  jb     @@display_stars
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; arcade scene                                                            ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
arcade_gtimer         dd 0

SHIP1_SHIFT           = 6
ship1_posx            dd 640/2
ship1_posy            dd 350
ship1_x_d             dd 0
ship1_y_d             dd 0
gameover_flag         db 0
start_mess_flag       db 200
end_mess_flag         dd 500

ALIVE                 = 0
HIT                   = 1
HIT2                  = 2
DEAD                  = 3

ship1_status          dd ALIVE
ship1_expozes         dd 0

arcade_fadepal        dd 0

;eax = A1      returns
;ebx = A2          CY = pass
;ecx = B1          CN = fail
;edx = B2
macro @test_range
local @@a,@@b,@@c,@@pass,@@fail,@@end
  cmp    eax,ecx
  jle    @@a
  jmp    @@b
@@a:
  cmp    ebx,ecx
  jge    @@pass
@@b:

  cmp    ecx,ebx
  jle    @@c
  jmp    @@fail
@@c:
  cmp    edx,ebx
  jge    @@pass
  jmp    @@fail
@@pass:
  stc
  jmp    @@end
@@fail:
  clc
@@end:
endm

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
LAZER1_SHIFT          = 4
LAZER1_BACKOUT        = 0
LAZER1_DONE           = 1

NO_OF_LAZERS          = 20
struc tlazer_ins
  event               db LAZER1_DONE
  posx                dd ?
  posy                dd ?
  xd                  dd ?
  xs                  dd ?
  yd                  dd ?
  size                dd ?
  skip                db 0
ends
lazer_ins             tlazer_ins NO_OF_LAZERS dup(<>)

proc create_lazer1
  mov    esi,offset lazer_ins
  mov    cl,NO_OF_LAZERS
@@l:
  cmp    [byte esi+tlazer_ins.event],LAZER1_DONE
  jne    @@end
  mov    [byte esi+tlazer_ins.skip],0
  mov    eax,[ship1_posx]
  mov    [esi+tlazer_ins.posx],eax
  mov    eax,[ship1_posy]
  mov    [esi+tlazer_ins.posy],eax
  mov    [dword esi+tlazer_ins.xs],2
  mov    [dword esi+tlazer_ins.xd],-4 shl LAZER1_SHIFT
  call   random
  test   al,1
  jnz    @@e
  neg    [dword esi+tlazer_ins.xd]
  neg    [dword esi+tlazer_ins.xs]
@@e:
  mov    [dword esi+tlazer_ins.yd],-4 shl LAZER1_SHIFT ;-10 shl LAZER1_SHIFT
  mov    [dword esi+tlazer_ins.size],10 shl LAZER1_SHIFT
  mov    [byte esi+tlazer_ins.event],LAZER1_BACKOUT

  mov    cl,LASER_CHAN      ; do lazer sound <=================!
  xor    [byte @@fireside],1
  jnz    @@dsfireside
  mov    cl,LASER_CHAN+1
@@dsfireside:
  mov    dl,LAZER_EFFECT
  mov    dh,(12*FX_OCTAVE)+8
  @play_sample
  jmp    @@fin
@@end:
  add    esi,size tlazer_ins
  dec    cl
  jnz    @@l
@@fin:
  ret
@@fireside            db 0
endp

proc calc_lazer1
  mov    esi,offset lazer_ins
  mov    cl,NO_OF_LAZERS
@@l:
  cmp    [byte esi+tlazer_ins.event],LAZER1_DONE
  je     @@end
  mov    eax,[esi+tlazer_ins.yd]
  sar    eax,LAZER1_SHIFT
  sub    [esi+tlazer_ins.posy],eax
  add    [esi+tlazer_ins.yd],1 ;10

  cmp    [byte esi+tlazer_ins.skip],4
  je     @@cont
  inc    [byte esi+tlazer_ins.skip]
  jmp    @@endxc
@@cont:
  mov    [byte esi+tlazer_ins.skip],0
  mov    eax,[esi+tlazer_ins.xd]
  sar    eax,LAZER1_SHIFT
  sub    [esi+tlazer_ins.posx],eax
  mov    eax,[dword esi+tlazer_ins.xs]
  add    [esi+tlazer_ins.xd],eax
@@endxc:
  add    [dword esi+tlazer_ins.size],20h
  cmp    [dword esi+tlazer_ins.size],74 shl LAZER1_SHIFT
  jbe    @@e2
  mov    [dword esi+tlazer_ins.size],74 shl LAZER1_SHIFT
@@e2:
  cmp    [esi+tlazer_ins.posy],-100
  jg     @@end
  mov    [byte esi+tlazer_ins.event],LAZER1_DONE
@@end:
  add    esi,size tlazer_ins
  dec    cl
  jnz    @@l
  ret
endp

proc paint_lazer1
  mov    esi,offset lazer_ins
  mov    cl,NO_OF_LAZERS
@@l:
  push   ecx esi
  cmp    [byte esi+tlazer_ins.event],LAZER1_DONE
  je     @@end
  mov    edx,[lazer1_pic]
  mov    eax,4
  add    eax,edx
  push   eax
  push   [dword Rendbuff]
  movzx  ebx,[word edx]
  shr    ebx,1
  mov    eax,[esi+tlazer_ins.posx]
  sub    eax,ebx
  push   eax
  mov    ebx,[esi+tlazer_ins.size]
  sar    ebx,1+LAZER1_SHIFT
  mov    eax,[esi+tlazer_ins.posy]
  sub    eax,ebx
  push   eax
  movzx  eax,[word edx]
  push   eax
  movzx  eax,[word edx+2]
  push   eax
  movzx  eax,[word edx]
  push   eax
  mov    eax,[esi+tlazer_ins.size]
  sar    eax,LAZER1_SHIFT
  push   eax
  push   640
  call   pscaler_TRANS
  add    esp,(size pscaler_stack)-8
@@end:
  pop    esi ecx
  add    esi,size tlazer_ins
  dec    cl
  jnz    @@l
  ret
endp

proc lazer1_cdetect
  mov    edi,offset lazer_ins
  mov    cl,NO_OF_LAZERS
@@l:
  push   ecx
  cmp    [byte edi+tlazer_ins.event],LAZER1_DONE
  je     @@exit

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;test ship1's;;;;;;;;;;;;;;;;;
  mov    esi,offset enemy1_ins
  mov    cl,NO_OF_ENEMY1
@@tship1:
  push   ecx
  cmp    [byte esi+tenemy1_ins.event],ENEMY1_RUN
  jne    @@endship1
  mov    eax,[edi+tlazer_ins.posy]
  mov    ebx,eax
  sub    eax,74/2
  add    ebx,74/2
  mov    ecx,[esi+tenemy1_ins.posy]
  sar    ecx,LAZER1_SHIFT
  mov    edx,ecx
  sub    ecx,43/2
  add    edx,43/2
  @test_range
  jnc    @@endship1

  mov    eax,[edi+tlazer_ins.posx]
  mov    ebx,eax
  sub    eax,8/2
  add    ebx,8/2
  mov    ecx,[esi+tenemy1_ins.posx]
  sar    ecx,LAZER1_SHIFT
  mov    edx,ecx
  sub    ecx,68/2
  add    edx,68/2
  @test_range
  jnc    @@endship1
  mov    [byte edi+tlazer_ins.event],LAZER1_DONE
  mov    [byte esi+tenemy1_ins.event],ENEMY1_HIT
  mov    [dword esi+tenemy1_ins.expozes],2
  pop    ecx

  call   @@do_sample
  jmp    @@exit
@@endship1:
  pop    ecx
  add    esi,(size tenemy1_ins) * ENEMY1_STEP
  dec    cl
  jnz    @@tship1

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;test ship2's;;;;;;;;;;;;;;;;;
  mov    esi,offset enemy2_ins
  mov    cl,NO_OF_ENEMY2
@@tship2:
  push   ecx
  cmp    [byte esi+tenemy2_ins.event],ENEMY2_RUN
  jne    @@endship2
  mov    eax,[edi+tlazer_ins.posy]
  mov    ebx,eax
  sub    eax,74/2
  add    ebx,74/2
  mov    ecx,[esi+tenemy2_ins.posy]
  sar    ecx,LAZER1_SHIFT
  mov    edx,ecx
  sub    ecx,45/2
  add    edx,45/2
  @test_range
  jnc    @@endship2

  mov    eax,[edi+tlazer_ins.posx]
  mov    ebx,eax
  sub    eax,8/2
  add    ebx,8/2
  mov    ecx,[esi+tenemy2_ins.posx]
  sar    ecx,LAZER1_SHIFT
  mov    edx,ecx
  sub    ecx,39/2
  add    edx,39/2
  @test_range
  jnc    @@endship2
  mov    [byte edi+tlazer_ins.event],LAZER1_DONE
  mov    [byte esi+tenemy2_ins.event],ENEMY2_HIT
  mov    [dword esi+tenemy2_ins.expozes],2
  dec    [byte esi+tenemy2_ins.lives]
  pop    ecx
  call   @@do_sample
  jmp    @@exit
@@endship2:
  pop    ecx
  add    esi,size tenemy2_ins
  dec    cl
  jnz    @@tship2

@@exit:
  pop    ecx
  add    edi,size tlazer_ins
  dec    cl
  jnz    @@l

  ret
proc @@do_sample
  xor    [byte @@sss],1

  mov    cl,MAINEXPL_CHAN      ; do sound <=================!
  add    cl,[byte @@sss]
  mov    dl,MAINEXPL_EFFECT
  mov    dh,(12*FX_OCTAVE+1)+8
  @play_sample
  ret
@@sss                 db 1
endp
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ENEMY1_RUN            = 0
ENEMY1_HIT            = 1
ENEMY1_HIT2           = 2
ENEMY1_DONE           = 3

NO_OF_ENEMY1          = 10
ENEMY1_STEP           = 3
struc tenemy1_ins
  event               db ENEMY1_RUN
  posx                dd 0 shl LAZER1_SHIFT
  posy                dd -1000 shl LAZER1_SHIFT
  xd                  dd 0
  yd                  dd 80 shl LAZER1_SHIFT
  expozes             dd ?
ends
enemy1_ins            tenemy1_ins NO_OF_ENEMY1*4 dup(<>)

proc calc_enemy1
  mov    esi,offset enemy1_ins + (((NO_OF_ENEMY1*ENEMY1_STEP)-1) * size tenemy1_ins)
  mov    eax,[esi+tenemy1_ins.posx]
  sar    eax,LAZER1_SHIFT
  cmp    eax,[ship1_posx]
  jl     @@go_right
  jg     @@go_left
  jmp    @@donex
@@go_right:
  cmp    [esi+tenemy1_ins.xd],20
  jg     @@donex
  add    [esi+tenemy1_ins.xd],1
  jmp    @@donex
@@go_left:
  cmp    [esi+tenemy1_ins.xd],-20
  jl     @@donex
  sub    [esi+tenemy1_ins.xd],1
@@donex:
  mov    eax,[esi+tenemy1_ins.xd]
  add    [esi+tenemy1_ins.posx],eax
  cmp    [esi+tenemy1_ins.posy],0 shl LAZER1_SHIFT
  jle    @@dont_retract
  sub    [esi+tenemy1_ins.yd],((20h+8h)*5)/10
@@dont_retract:
  add    [esi+tenemy1_ins.yd],(8h*4)/10
  mov    eax,[esi+tenemy1_ins.yd]
  sar    eax,LAZER1_SHIFT
  add    [esi+tenemy1_ins.posy],eax
  cmp    [esi+tenemy1_ins.posy],500 shl LAZER1_SHIFT
  jl     @@end
  mov    [esi+tenemy1_ins.posy],-1000 shl LAZER1_SHIFT
@@end:

;;;expozation animation
  mov    esi,offset enemy1_ins
  mov    cl,NO_OF_ENEMY1
@@l:
  push   ecx

  cmp    [byte esi+tenemy1_ins.event],ENEMY1_HIT
  je     @@calc_shipexpoze
  cmp    [byte esi+tenemy1_ins.event],ENEMY1_HIT2
  je     @@calc_shipimpoze
  jmp    @@end_ch2e
@@calc_shipexpoze:
  add    [esi+tenemy1_ins.expozes],2
  cmp    [esi+tenemy1_ins.expozes],100
  jl     @@end_ch2e
  mov    [byte esi+tenemy1_ins.event],ENEMY1_HIT2
  jmp    @@end_ch2e
@@calc_shipimpoze:
  sub    [esi+tenemy1_ins.expozes],1
  cmp    [esi+tenemy1_ins.expozes],2
  jg     @@end_ch2e
  mov    [byte esi+tenemy1_ins.event],ENEMY1_DONE
  mov    [esi+tenemy1_ins.expozes],2
@@end_ch2e:

  pop    ecx
  add    esi,(size tenemy1_ins) * ENEMY1_STEP
  dec    cl
  jnz    @@l

  ret
endp

proc paint_enemy1
  mov    esi,offset enemy1_ins
  mov    cl,NO_OF_ENEMY1
@@l:
  push   ecx esi
  cmp    [byte esi+tenemy1_ins.event],ENEMY1_DONE
  je     @@end
  cmp    [byte esi+tenemy1_ins.event],ENEMY1_HIT2
  je     @@no_ship
  push   esi
  mov    eax,[ship2_pic]
  mov    edx,eax
  add    eax,4
  push   eax
  push   [dword Rendbuff]
  mov    eax,[esi+tenemy1_ins.posx]
  sar    eax,LAZER1_SHIFT
  movzx  ebx,[word edx]
  shr    ebx,1
  sub    eax,ebx
  push   eax
  mov    eax,[esi+tenemy1_ins.posy]
  sar    eax,LAZER1_SHIFT
  movzx  ebx,[word edx+2]
  shr    ebx,1
  sub    eax,ebx
  push   eax
  xor    eax,eax
  mov    ax,[word edx]
  push   eax
  mov    ax,[word 2+edx]
  push   eax
  push   640
  call   RBBitmap_TRANS
  add    esp,(size RBBitmap_stack)-8
  pop    esi
  cmp    [byte esi+tenemy1_ins.event],ENEMY1_HIT
  jne    @@end
@@no_ship:
  mov    eax,[expoze2_pic]
  mov    edx,eax
  add    eax,4
  push   eax
  push   [dword Rendbuff]

  mov    ebx,[esi+tenemy1_ins.posx]
  sar    ebx,LAZER1_SHIFT
  mov    ecx,[esi+tenemy1_ins.expozes]
  sar    ecx,1
  sub    ebx,ecx
  push   ebx

  mov    ebx,[esi+tenemy1_ins.posy]
  sar    ebx,LAZER1_SHIFT
  sub    ebx,ecx
  push   ebx

  movzx  eax,[word edx]
  push   eax

  movzx  eax,[word edx+2]
  push   eax
  push   [esi+tenemy1_ins.expozes]
  push   [esi+tenemy1_ins.expozes]
  push   640
  call   pscaler_TRANS
  add    esp,(size pscaler_stack)-8
@@end:
  pop    esi ecx
  add    esi,(size tenemy1_ins) * ENEMY1_STEP
  dec    cl
  jnz    @@l

  mov    cl,(NO_OF_ENEMY1*ENEMY1_STEP)-1
  mov    esi,offset enemy1_ins
  mov    edi,esi
@@shift_buf:
  mov    eax,[edi+(size tenemy1_ins)+tenemy1_ins.posx]
  mov    ebx,[edi+(size tenemy1_ins)+tenemy1_ins.posy]
  mov    [edi+tenemy1_ins.posx],eax
  mov    [edi+tenemy1_ins.posy],ebx
  add    edi,size tenemy1_ins
  dec    cl
  jnz    @@shift_buf
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                         ;
; ENEMY 2                                 ;
;                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ENEMY2_RUN            = 0
ENEMY2_HIT            = 1
ENEMY2_HIT2           = 2
ENEMY2_DONE           = 3

NO_OF_ENEMY2          = 10
struc tenemy2_ins
  event               db ENEMY2_DONE
  posx                dd 0
  posy                dd 0
  missile_status      db ENEMY2_DONE
  missile_y           dd 0
  missile_dy          dd 0
  expozes             dd ?
  lives               db 1
ends
enemy2_ins            tenemy2_ins NO_OF_ENEMY2 dup(<>)

proc create_enemy2
  cmp    [byte @@skip],30
  je     @@cont
  inc    [byte @@skip]
  ret
@@cont:
  mov    [byte @@skip],0
  mov    esi,offset enemy2_ins
  mov    cl,NO_OF_ENEMY2
@@l:
  cmp    [byte esi+tenemy2_ins.event],ENEMY2_DONE
  jne    @@end
  cmp    [byte esi+tenemy2_ins.lives],0
  je     @@end
  call   random
  and    eax,03ffh
  cmp    eax,640
  jge    @@end
  sal    eax,LAZER1_SHIFT
  mov    [esi+tenemy2_ins.posx],eax
  mov    [esi+tenemy2_ins.posy],-100 shl LAZER1_SHIFT
  mov    [byte esi+tenemy2_ins.event],ENEMY2_RUN
  jmp    @@fin
@@end:
  add    esi,size tenemy2_ins
  dec    cl
  jnz    @@l
@@fin:
  ret
@@skip                db 0
endp

proc calc_enemy2
  mov    esi,offset enemy2_ins
  mov    cl,NO_OF_ENEMY2
@@l:
  cmp    [byte esi+tenemy2_ins.event],ENEMY2_DONE
  je     @@end_ch2e

  mov    eax,[esi+tenemy2_ins.posx]
  sar    eax,LAZER1_SHIFT
  cmp    eax,[ship1_posx]
  jl     @@go_right
  jg     @@go_left
@@fire_missle:
  mov    eax,[esi+tenemy2_ins.posy]
  cmp    eax,100
  jl     @@donex
  cmp    [byte esi+tenemy2_ins.missile_status],ENEMY2_RUN
  je     @@donex
  mov    [esi+tenemy2_ins.missile_y],eax
  mov    [esi+tenemy2_ins.missile_dy],0
  mov    [byte esi+tenemy2_ins.missile_status],ENEMY2_RUN
  jmp    @@donex
@@go_right:
  add    [esi+tenemy2_ins.posx],4
  jmp    @@donex
@@go_left:
  sub    [esi+tenemy2_ins.posx],4
@@donex:
  add    [esi+tenemy2_ins.posy],10

  cmp    [esi+tenemy2_ins.missile_status],ENEMY2_RUN
  jne    @@dont_calc_mis
  mov    eax,[esi+tenemy2_ins.missile_dy]
  add    [esi+tenemy2_ins.missile_y],eax
  cmp    [esi+tenemy2_ins.missile_y],500 shl LAZER1_SHIFT
  jl     @@cont_calc_m
  mov    [esi+tenemy2_ins.missile_status],ENEMY2_DONE
  jmp    @@dont_calc_mis
@@cont_calc_m:
  cmp    [esi+tenemy2_ins.missile_dy],50
  jg     @@dont_calc_mis
  add    [esi+tenemy2_ins.missile_dy],1
@@dont_calc_mis:
  cmp    [esi+tenemy2_ins.posy],500 shl LAZER1_SHIFT
  jl     @@end
  call   random
  and    eax,03ffh
  cmp    eax,640
  jge    @@end
  sal    eax,LAZER1_SHIFT
  mov    [esi+tenemy2_ins.posx],eax
  mov    [esi+tenemy2_ins.posy],-100 shl LAZER1_SHIFT
@@end:

;;;;;exposeation animation;;;;;;;
  cmp    [byte esi+tenemy2_ins.event],ENEMY2_HIT
  je     @@calc_shipexpoze
  cmp    [byte esi+tenemy2_ins.event],ENEMY2_HIT2
  je     @@calc_shipimpoze
  jmp    @@end_ch2e
@@calc_shipexpoze:
  add    [esi+tenemy2_ins.expozes],2
  cmp    [esi+tenemy2_ins.expozes],150
  jl     @@end_ch2e
  mov    [byte esi+tenemy2_ins.event],ENEMY2_HIT2
  jmp    @@end_ch2e
@@calc_shipimpoze:
  sub    [esi+tenemy2_ins.expozes],1
  cmp    [esi+tenemy2_ins.expozes],2
  jg     @@end_ch2e
  mov    [byte esi+tenemy2_ins.event],ENEMY2_DONE
  mov    [esi+tenemy2_ins.expozes],2
@@end_ch2e:

  add    esi,size tenemy2_ins
  dec    cl
  jnz    @@l
  ret
endp

proc paint_enemy2
  call   create_enemy2
  mov    esi,offset enemy2_ins
  mov    cl,NO_OF_ENEMY2
@@l:
  push   ecx esi
  cmp    [byte esi+tenemy2_ins.event],ENEMY2_DONE
  je     @@end
  cmp    [byte esi+tenemy2_ins.event],ENEMY2_HIT2
  je     @@no_ship
  push   esi

;;;;;paint missile;;;;;;;;;;;;;;;;;
  cmp    [byte esi+tenemy2_ins.missile_status],ENEMY2_RUN
  jne    @@dont_paint_mis
  push   esi
  mov    eax,[mis1_b_pic]
  xchg   eax,[mis1_a_pic]
  mov    [mis1_b_pic],eax
  mov    edx,eax
  add    eax,4
  push   eax
  push   [dword Rendbuff]
  mov    eax,[esi+tenemy2_ins.posx]
  sar    eax,LAZER1_SHIFT
  add    eax,10
  movzx  ebx,[word edx]
  shr    ebx,1
  sub    eax,ebx
  push   eax
  mov    eax,[esi+tenemy2_ins.missile_y]
  sar    eax,LAZER1_SHIFT
  movzx  ebx,[word edx+2]
  shr    ebx,1
  sub    eax,ebx
  push   eax
  xor    eax,eax
  mov    ax,[word edx]
  push   eax
  mov    ax,[word 2+edx]
  push   eax
  push   640
  call   RBBitmap_TRANS
  add    esp,(size RBBitmap_stack)-8
  pop    esi
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@dont_paint_mis:
  mov    eax,[ship3_pic]
  mov    edx,eax
  add    eax,4
  push   eax
  push   [dword Rendbuff]
  mov    eax,[esi+tenemy2_ins.posx]
  sar    eax,LAZER1_SHIFT
  movzx  ebx,[word edx]
  shr    ebx,1
  sub    eax,ebx
  push   eax
  mov    eax,[esi+tenemy2_ins.posy]
  sar    eax,LAZER1_SHIFT
  movzx  ebx,[word edx+2]
  shr    ebx,1
  sub    eax,ebx
  push   eax
  xor    eax,eax
  mov    ax,[word edx]
  push   eax
  mov    ax,[word 2+edx]
  push   eax
  push   640
  call   RBBitmap_TRANS
  add    esp,(size RBBitmap_stack)-8
;;;;;;;;expoze1;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  pop    esi
  cmp    [byte esi+tenemy2_ins.event],ENEMY2_HIT
  jne    @@end
@@no_ship:
  mov    eax,[expoze3_pic]
  mov    edx,eax
  add    eax,4
  push   eax
  push   [dword Rendbuff]

  mov    ebx,[esi+tenemy2_ins.posx]
  sar    ebx,LAZER1_SHIFT
  mov    ecx,[esi+tenemy2_ins.expozes]
  sar    ecx,1
  sub    ebx,ecx
  push   ebx

  mov    ebx,[esi+tenemy2_ins.posy]
  sar    ebx,LAZER1_SHIFT
  sub    ebx,ecx
  push   ebx

  movzx  eax,[word edx]
  push   eax

  movzx  eax,[word edx+2]
  push   eax
  push   [esi+tenemy2_ins.expozes]
  push   [esi+tenemy2_ins.expozes]
  push   640
  call   pscaler_TRANS
  add    esp,(size pscaler_stack)-8
@@end:
  pop    esi ecx
  add    esi,size tenemy2_ins
  dec    cl
  jnz    @@l
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc arcade_game_ISR
  call   t_traject_ISR           ; foreground scroller calc

  cmp    [ship1_status],ALIVE
  jne    @@ignore_die_c
  cmp    [arcade_gtimer],500
  jl     @@dontend
  mov    [ship1_status],HIT
  mov    [ship1_expozes],2

  mov    cl,MAINEXP3_CHAN      ; do sound <=================!
  mov    dl,MAINEXP3_EFFECT
  mov    dh,(12*FX_OCTAVE)+0
  @play_sample
  mov    cl,MAINEXP3_CHAN+1
  mov    dl,MAINEXP3_EFFECT
  mov    dh,(12*FX_OCTAVE)+0
  @play_sample

@@dontend:
  inc    [arcade_gtimer]
@@ignore_die_c:

  add    [a_rings_rotate],2
  cmp    [arcade_fadepal],100h
  ja     @@dont_udp
  add    [arcade_fadepal],4
@@dont_udp:

  cmp    [byte @@star_calc_miss],4
  je     @@calc_s
  inc    [byte @@star_calc_miss]
  jmp    @@cont
@@calc_s:
  mov    [byte @@star_calc_miss],0
  call   mapp_star_calc
@@cont:
  call   calc_lazer1
  call   calc_enemy1
  call   calc_enemy2

  cmp    [ship1_status],HIT
  je     @@calc_ship1expoze
  cmp    [ship1_status],HIT2
  je     @@calc_ship1impoze
  jmp    @@end_ch2e
@@calc_ship1expoze:
  add    [ship1_expozes],6
  cmp    [ship1_expozes],800
  jl     @@end_ch2e
  mov    [ship1_status],HIT2
  jmp    @@end_ch2e
@@calc_ship1impoze:
  sub    [ship1_expozes],4
  cmp    [ship1_expozes],2
  jg     @@end_ch2e
  mov    [ship1_status],DEAD
  mov    [ship1_expozes],2
@@end_ch2e:
  cmp    [start_mess_flag],0
  je     @@ddmf
  dec    [start_mess_flag]
@@ddmf:

  cmp    [gameover_flag],0
  je     @@smf
  cmp    [end_mess_flag],0
  je     @@smf
  dec    [end_mess_flag]
@@smf:

  mov    eax,[ship1_x_d]
  sar    eax,SHIP1_SHIFT
  add    [ship1_posx],eax

  cmp    [ship1_posx],40
  jge    @@skipcliplx
  mov    [ship1_posx],40
  mov    [ship1_x_d],0
@@skipcliplx:

  cmp    [ship1_posx],640-40
  jle    @@skipcliprx
  mov    [ship1_posx],640-40
  mov    [ship1_x_d],0
@@skipcliprx:

  cmp    [ship1_posy],480
  jle    @@skipclipby
  mov    [ship1_posy],480
  mov    [ship1_y_d],0
@@skipclipby:

  mov    eax,[ship1_y_d]
  sar    eax,SHIP1_SHIFT
  add    [ship1_posy],eax

  cmp    [dword ship1_x_d],0
  je     @@ix
  jl     @@xs
  dec    [dword ship1_x_d]
  jmp    @@ix
@@xs:
  inc    [dword ship1_x_d]
@@ix:
  cmp    [dword ship1_y_d],0
  je     @@iy
  jl     @@ys
  dec    [dword ship1_y_d]
  jmp    @@iy
@@ys:
  inc    [dword ship1_y_d]
@@iy:

  ret
@@star_calc_miss      db 0
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc test_endgame
  cmp    [byte gameover_flag],1
  je     @@notover
  inc    [@@skip]
  and    [@@skip],3fh
  jz     @@cont
  ret
@@cont:
  cmp    [ship1_status],DEAD
  je     @@end
  mov    esi,offset enemy1_ins
  mov    cl,NO_OF_ENEMY1
@@l:
  cmp    [byte esi+tenemy1_ins.event],ENEMY1_DONE
  jne    @@notover
  add    esi,(size tenemy1_ins) * ENEMY1_STEP
  dec    cl
  jnz    @@l

  mov    esi,offset enemy2_ins
  mov    cl,NO_OF_ENEMY2
@@l2:
  cmp    [byte esi+tenemy2_ins.event],ENEMY2_DONE
  jne    @@notover
  add    esi,size tenemy2_ins
  dec    cl
  jnz    @@l2
@@end:
  mov    [gameover_flag],1

  mov    cl,ATTENTION_CHAN      ; do attention sound <=================!
  mov    dl,ATTENTION_EFFECT
  mov    dh,(12*FX_OCTAVE)+8
  @play_sample
  mov    cl,ATTENTION_CHAN+1
  mov    dl,ATTENTION_EFFECT
  mov    dh,(12*FX_OCTAVE)+8
  @play_sample
  ret
@@notover:
  ret
@@skip                db 0
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc auto_ship1
  cmp    [ship1_status],HIT
  jae    @@exit
;;if enemy1 one in the way, fire lazer;;;;;;;;;;;;;;;;;
  mov    esi,offset enemy1_ins
  mov    cl,NO_OF_ENEMY1
@@tship1:
  push   ecx
  cmp    [byte esi+tenemy1_ins.event],ENEMY1_HIT
  jae    @@endship1

  mov    eax,[esi+tenemy1_ins.posy]
  sar    eax,LAZER1_SHIFT
  cmp    eax,-500
  jl     @@endship1

  mov    eax,[ship1_posx]
  mov    ebx,eax
  sub    eax,200/2
  add    ebx,200/2
  mov    ecx,[esi+tenemy1_ins.posx]
  sar    ecx,LAZER1_SHIFT
  mov    edx,ecx
  sub    ecx,68/2
  add    edx,68/2
  @test_range
  jnc    @@endship1
;fire lazer, retreat backwards
  call   create_lazer1
  mov    [ship1_y_d],0
  cmp    [ship1_posy],420
  jge    @@drb
  mov    eax,3 shl SHIP1_SHIFT
  call   @@inc_dy
@@drb:
  pop    ecx
  jmp    @@exit
@@endship1:
  pop    ecx
  add    esi,(size tenemy1_ins) * ENEMY1_STEP
  dec    cl
  jnz    @@tship1
;;if enemy2 one in the way, fire lazer;;;;;;;;;;;;;;;;;
  mov    esi,offset enemy2_ins
  mov    cl,NO_OF_ENEMY2
@@tship2:
  push   ecx
  cmp    [byte esi+tenemy2_ins.event],ENEMY2_DONE
  je     @@endship3
  mov    eax,[ship1_posx]
  mov    ebx,eax
  sub    eax,100/2
  add    ebx,100/2
  mov    ecx,[esi+tenemy2_ins.posx]
  sar    ecx,LAZER1_SHIFT
  mov    edx,ecx
  sub    ecx,9/2
  add    edx,9/2
  @test_range
  jnc    @@endship3
;fire_lazer, go forward
  call   create_lazer1
  mov    [ship1_y_d],0
  mov    eax,[esi+tenemy2_ins.posy]
  sar    eax,LAZER1_SHIFT
  sub    eax,[ship1_posy]
  cmp    eax,50
  jl     @@m2backoff
  cmp    [ship1_posy],350
  jle    @@dattack
  mov    eax,-1 shl SHIP1_SHIFT-4
  call   @@inc_dy
  jmp    @@dattack
@@m2backoff:
  cmp    [ship1_posy],420
  jge    @@dattack
  mov    eax,2 shl SHIP1_SHIFT-4
  call   @@inc_dy
@@dattack:

  cmp    [byte esi+tenemy2_ins.missile_status],ENEMY2_DONE
  je     @@dontdodge
  mov    eax,[esi+tenemy2_ins.posx]
  sar    eax,LAZER1_SHIFT
  cmp    eax,[ship1_posx]
  jg     @@dodgex_gr
  jl     @@dodgex_gl
  mov    [ship1_x_d],0
  jmp    @@dodgex_end
@@dodgex_gr:
  mov    eax,3 shl SHIP1_SHIFT-4
  call   @@inc_dx
  jmp    @@dodgex_end
@@dodgex_gl:
  mov    eax,-3 shl SHIP1_SHIFT-4
  call   @@inc_dx
@@dodgex_end:


@@dontdodge:
  pop    ecx
  jmp    @@exit
@@endship3:
  pop    ecx
  add    esi,size tenemy2_ins
  dec    cl
  jnz    @@tship2
@@centre:
  cmp    [@@idle_count],240
  jg     @@centre2
  inc    [@@idle_count]
  ret
@@centre2:
  cmp    [ship1_posx],640/2-10
  jl     @@cx_gr
  cmp    [ship1_posx],640/2+10
  jg     @@cx_gl
  mov    [ship1_x_d],0
  jmp    @@cx_end
@@cx_gr:
  mov    eax,2 shl SHIP1_SHIFT-4
  call   @@inc_dx
  jmp    @@cx_end
@@cx_gl:
  mov    eax,-2 shl SHIP1_SHIFT-4
  call   @@inc_dx
@@cx_end:

  cmp    [ship1_posy],350-10
  jl     @@cy_gr
  cmp    [ship1_posy],350+10
  jg     @@cy_gl
  mov    [ship1_y_d],0
  jmp    @@cy_end
@@cy_gr:
  mov    eax,1 shl SHIP1_SHIFT-4
  call   @@inc_dy
  jmp    @@cy_end
@@cy_gl:
  mov    eax,-1 shl SHIP1_SHIFT-4
  call   @@inc_dy
@@cy_end:
  ret
@@exit:
  mov    [@@idle_count],0
  ret
@@idle_count          db 0

;eax = inc
proc @@inc_dx
  cmp    [ship1_x_d],1 shl SHIP1_SHIFT
  jg     @@miss
  cmp    [ship1_x_d],-1 shl SHIP1_SHIFT
  jl     @@miss
  add    [ship1_x_d],eax
@@miss:
  ret
endp

;eax = inc
proc @@inc_dy
  cmp    [ship1_y_d],1 shl SHIP1_SHIFT
  jg     @@miss
  cmp    [ship1_y_d],-1 shl SHIP1_SHIFT
  jl     @@miss
  add    [ship1_y_d],eax
@@miss:
  ret
endp

endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc arcade_game
  call   a_rings_init

  mov    esi,offset arcade_pal
  xor    eax,eax
  mov    ecx,arcade_pal_size/3
  call   fade_pal_init

  call   mapp_star_init

  mov    eax,offset arcade_game_ISR
  mov    [fg_calc],eax
@@paint:
  call   mapp_star
  call   paint_enemy2
  call   paint_enemy1
  call   paint_lazer1
  call   lazer1_cdetect
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  cmp    [ship1_status],DEAD
  je     @@nothing
  cmp    [ship1_status],HIT2
  je     @@no_ship
  mov    eax,[ship1b_pic]
  xchg   eax,[ship1a_pic]
  mov    [ship1b_pic],eax
  mov    edx,eax
  add    eax,4
  push   eax
  push   [dword Rendbuff]
  mov    ecx,[ship1_posx]
  movzx  ebx,[word edx]
  shr    ebx,1
  sub    ecx,ebx
  push   ecx
  mov    ebx,[ship1_posy]
  movzx  eax,[word edx+2]
  shr    eax,1
  sub    ebx,eax
  push   ebx
  xor    eax,eax
  mov    ax,[word edx]
  push   eax
  mov    ax,[word 2+edx]
  push   eax
  push   640
  call   RBBitmap_TRANS
  add    esp,(size RBBitmap_stack)-8
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  cmp    [ship1_status],HIT
  jne    @@no_expoze
@@no_ship:
  mov    eax,[expoze1_pic]
  mov    edx,eax
  add    eax,4
  push   eax
  push   [dword Rendbuff]

  mov    ebx,[ship1_posx]
  mov    ecx,[ship1_expozes]
  sar    ecx,1
  sub    ebx,ecx
  push   ebx

  mov    ebx,[ship1_posy]
  sub    ebx,ecx
  push   ebx

  movzx  eax,[word edx]
  push   eax

  movzx  eax,[word edx+2]
  push   eax
  push   [ship1_expozes]
  push   [ship1_expozes]
  push   640
  call   pscaler_TRANS
  add    esp,(size pscaler_stack)-8

  cli
  xor    al,al
  mov    edx,03c8h
  out    dx,al
  inc    edx
  mov    eax,[ship1_expozes]
  shr    eax,6
  out    dx,al
  mov    eax,[ship1_expozes]
  shr    eax,6
  out    dx,al
  mov    eax,[ship1_expozes]
  shr    eax,6
  out    dx,al
  sti
@@no_expoze:

@@nothing:
  mov    eax,[dword arcade_mess3_pic]
  cmp    [start_mess_flag],0
  jne    @@paint_mess
  cmp    [gameover_flag],0
  je     @@nogo
  call   paint_a_rings
  mov    eax,[dword arcade_mess2_pic]
;  cmp    [ship1_status],DEAD
;  je     @@paint_mess
;  mov    eax,[dword arcade_mess_pic]
@@paint_mess:
  mov    edx,eax
  add    eax,4
  push   eax
  push   [dword Rendbuff]
  mov    ecx,640/2
  movzx  ebx,[word edx]
  shr    ebx,1
  sub    ecx,ebx
  push   ecx
  mov    ebx,480/2
  movzx  eax,[word edx+2]
  shr    eax,1
  sub    ebx,eax
  push   ebx
  xor    eax,eax
  mov    ax,[word edx]
  push   eax
  mov    ax,[word 2+edx]
  push   eax
  push   640
  call   RBBitmap_TRANS
  add    esp,(size RBBitmap_stack)-8
@@nogo:
  call   test_endgame

  mov    ebx,[arcade_fadepal]
  cmp    ebx,100h
  ja     @@dont_udp
  xor    eax,eax
  mov    ecx,arcade_pal_size/3
  call   fade_pal
@@dont_udp:

  call   t_traject            ;paint foreground scroller
  call   [sync_screen]

  cmp    [byte t_traj_ISR_event],T_TRAG_4
  jbe    @@no_endyet
  cmp    [end_mess_flag],0
  je     @@end
@@no_endyet:

  call   auto_ship1
  call   key_pressed2
  jnc    @@paint
  call   get_key
  cmp    al,27
  je     @@end
  jmp    @@paint
@@end:
  call   a_rings_deinit
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; ZOOM scene                                                              ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ZOOMEND_ZO            = 0
ZOOMEND_ZO2           = 1
ZOOMEND_SP            = 2
ZOOMEND_CLRSRC        = 3
ZOOMEND_ZI            = 4
ZOOMEND_FADE          = 5
ZOOMEND_WAIT          = 6
ZOOMEND_DONE          = 7

zoomend_dx            dd 640 shl ADD_shifter
zoomend_dy            dd 480 shl ADD_shifter

zoomend_pal_hl        dd 100h

proc zoomend_ISR
  call   t_traject_ISR           ; foreground scroller calc
  cmp    [byte ISR_event],ZOOMEND_ZO
  je     @@jZOOMEND_ZO
  cmp    [byte ISR_event],ZOOMEND_ZO2
  je     @@jZOOMEND_ZO2
  cmp    [byte ISR_event],ZOOMEND_ZI
  je     @@jZOOMEND_ZI
  cmp    [byte ISR_event],ZOOMEND_FADE
  je     @@jZOOMEND_FADE
  cmp    [byte ISR_event],ZOOMEND_WAIT
  je     @@jZOOMEND_WAIT
  ret
@@next_event:
  mov    [dword ISR_pc],0
  inc    [byte ISR_event]
  ret
@@jZOOMEND_ZO:
  cmp    [dword ISR_pc],300-40h
  jae    @@next_event
  inc    [dword ISR_pc]

  mov    eax,[zoomend_dx]
  sar    eax,6
  add    [zoomend_dx],eax
  mov    eax,[zoomend_dy]
  sar    eax,6
  add    [zoomend_dy],eax
  ret
@@jZOOMEND_ZO2:
  cmp    [dword ISR_pc],60h
  jae    @@next_event
  inc    [dword ISR_pc]

  mov    eax,[zoomend_dx]
  sar    eax,6
  add    [zoomend_dx],eax
  mov    eax,[zoomend_dy]
  sar    eax,6
  add    [zoomend_dy],eax

  sub    [zoomend_pal_hl],2
  cmp    [zoomend_pal_hl],0
  jle    @@dont_dpl
  ret
@@dont_dpl:
  mov    [zoomend_pal_hl],0
  ret
@@jZOOMEND_ZI:
  mov    eax,[zoomend_dx]
  sar    eax,6
  sub    [zoomend_dx],eax
  mov    eax,[zoomend_dy]
  sar    eax,6
  sub    [zoomend_dy],eax

  cmp    [zoomend_dx],640 shl ADD_shifter
  jle    @@ZEZI_done
  ret
@@ZEZI_done:
  mov    [zoomend_dx],640 shl ADD_shifter
  mov    [zoomend_dy],480 shl ADD_shifter
  jmp    @@next_event
@@jZOOMEND_FADE:
  cmp    [dword ISR_pc],60h
  jae    @@next_event
  inc    [dword ISR_pc]

  dec    [zoomend_pal_hl]
  cmp    [zoomend_pal_hl],0
  jle    @@dont_dpl2
  ret
@@dont_dpl2:
  mov    [zoomend_pal_hl],0
  ret
@@jZOOMEND_WAIT:
  cmp    [dword ISR_pc],100
  jae    @@next_event
  inc    [dword ISR_pc]
  ret
endp

proc zoomend
  mov    edx,SCREEN_X*SCREEN_Y
  mov    eax,0EE42h         ; allocate a DOS32 memory block
  Int    31h                ;  expects EDX = size; ret EAX=size, EDX->pointer
  mov    [pic_mt1],edx

  mov    esi,offset arcade_pal
  xor    eax,eax
  mov    ecx,arcade_pal_size/3
  call   fade_pal_init

  mov    esi,[Rendbuff]
  mov    edi,[pic_mt1]
  mov    ecx,(SCREEN_X*SCREEN_Y)/4
  rep    movsd

  mov    [ISR_event],ZOOMEND_ZO
  mov    [ISR_pc],0
  mov    eax,offset zoomend_ISR
  mov    [fg_calc],eax

@@zoomout_l:
  cmp    [byte ISR_event],ZOOMEND_SP
  je     @@set_next_pal
  cmp    [byte ISR_event],ZOOMEND_CLRSRC
  je     @@clr_scr
  cmp    [byte ISR_event],ZOOMEND_ZO
  je     @@paint_rend
  cmp    [byte ISR_event],ZOOMEND_ZO2
  je     @@paint_rend
  mov    esi,[crus64_pic]
  mov    eax,4
  add    eax,esi
  push   eax
  push   [Rendbuff]
  mov    ebx,640/2
  mov    eax,[zoomend_dx]
  sar    eax,ADD_shifter+1
  sub    ebx,eax
  push   ebx
  mov    ebx,480/2
  mov    eax,[zoomend_dy]
  sar    eax,ADD_shifter+1
  sub    ebx,eax
  push   ebx
  movzx  eax,[word esi]
  push   eax
  movzx  eax,[word esi+2]
  push   eax
  mov    eax,[zoomend_dx]
  sar    eax,ADD_shifter
  push   eax
  mov    eax,[zoomend_dy]
  sar    eax,ADD_shifter
  push   eax
  push   640
  call   pscaler
  add    esp,(size pscaler_stack)-8

  cmp    [byte ISR_event],ZOOMEND_FADE
  jne    @@endpaint
  xor    eax,eax
  mov    ecx,224
  mov    ebx,[zoomend_pal_hl]
  call   fade_pal

  jmp    @@endpaint
@@paint_rend:
  push   [pic_mt1]
  push   [Rendbuff]
  mov    ebx,640/2
  mov    eax,[zoomend_dx]
  sar    eax,ADD_shifter+1
  sub    ebx,eax
  push   ebx
  mov    ebx,480/2
  mov    eax,[zoomend_dy]
  sar    eax,ADD_shifter+1
  sub    ebx,eax
  push   ebx
  push   640
  push   480
  mov    eax,[zoomend_dx]
  sar    eax,ADD_shifter
  push   eax
  mov    eax,[zoomend_dy]
  sar    eax,ADD_shifter
  push   eax
  push   640
  call   pscaler
  add    esp,(size pscaler_stack)-8

  cmp    [byte ISR_event],ZOOMEND_ZO
  je     @@endpaint
  xor    eax,eax
  mov    ecx,224
  mov    ebx,[zoomend_pal_hl]
  call   fade_pal
  jmp    @@endpaint
@@set_next_pal:
  call   clear_screen
  call   t_traject            ;paint foreground scroller
  call   [sync_screen]
  call   [sync_screen]

  xor    al,al
  mov    ecx,224*3
  mov    esi,[crus64_pal]
  @WritePalette

  mov    esi,[crus64_pal]
  xor    eax,eax
  mov    ecx,224
  call   fade_pal_init

  mov    [zoomend_pal_hl],100h
  mov    [dword ISR_pc],0
  inc    [byte ISR_event]
  jmp    @@endpaint2
@@endpaint:
  call   t_traject            ;paint foreground scroller
  call   [sync_screen]
@@endpaint2:
  cmp    [byte ISR_event],ZOOMEND_DONE
  je     @@end
  call   key_pressed2
  jnc    @@zoomout_l
  call   get_key
  cmp    al,27
  je     @@end
  jmp    @@zoomout_l
@@end:

  mov    eax,0EE40h         ; delocate screen
  int    31h
  ret
@@clr_scr:
  call   clear_screen
  mov    [dword ISR_pc],0
  inc    [byte ISR_event]
  jmp    @@endpaint
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; BREAK AWAY SCENE                                                        ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
BREAK_shifter         = 8

BA_START              = 0
BA_FADEOUT            = 1
BA_DONE               = 2

struc tba_r
  status              db 0
  x                   dd ?
  y                   dd ?
  xsize               dd 64 shl BREAK_shifter
  ysize               dd 48 shl BREAK_shifter
ends

break_away_pic        dd ?
ba_r                  tba_r 10*10 dup(<>)
ba_rel_seq:
  db 90
  db 91,80
  db 70,81,92
  db 93,82,71,60
  db 50,61,72,83,94
  db 95,84,73,62,51,40
  db 30,41,52,63,74,85,96
  db 97,86,75,64,53,42,31,20
  db 10,21,32,43,54,65,76,87,98
  db 99,88,77,66,55,44,33,22,11,00
  db 01,12,23,34,45,56,67,78,89
  db 79,68,57,46,35,24,13,02
  db 03,14,25,36,47,58,69
  db 59,48,37,26,15,04
  db 05,16,27,38,49
  db 39,28,17,06
  db 07,18,29
  db 19,08
  db 09
ba_rel_seq_ptr        dd 0

proc ba_create
  mov    eax,[ba_rel_seq_ptr]
  cmp    eax,100
  jae    @@ignore
  movzx  eax,[byte eax+ba_rel_seq]
  mov    ecx,size tba_r
  mul    ecx
  mov    esi,eax
  add    esi,offset ba_r
  mov    [esi+tba_r.status],1

  inc    [ba_rel_seq_ptr]
@@ignore:
  ret
endp

proc ba_calc_ISR
  call   t_traject_ISR           ; foreground scroller calc
  cmp    [byte ISR_event],BA_START
  je     @@jBA_START
  cmp    [byte ISR_event],BA_FADEOUT
  je     @@jBA_FADEOUT
  ret
@@next_event:
  mov    [dword ISR_pc],0
  inc    [byte ISR_event]
  ret
@@jBA_START:
  cmp    [dword ISR_pc],200
  jae    @@next_event
  inc    [dword ISR_pc]

  call   ba_create
  mov    esi,offset ba_r
  mov    cl,100
@@bac_l:
  cmp    [esi+tba_r.status],1
  jne    @@bac_l_cont
  sub    [esi+tba_r.x],100h
  add    [esi+tba_r.y],100h

  sub    [esi+tba_r.xsize],64*3
  sub    [esi+tba_r.ysize],48*3

  cmp    [esi+tba_r.xsize],2 shl BREAK_shifter
  jle    @@end_calc_i
  cmp    [esi+tba_r.ysize],2 shl BREAK_shifter
  jle    @@end_calc_i

@@bac_l_cont:
  add    esi,size tba_r
  dec    cl
  jnz    @@bac_l
  ret
@@end_calc_i:
  mov    [esi+tba_r.status],2
  jmp    @@bac_l_cont
@@jBA_FADEOUT:
  cmp    [dword ISR_pc],300
  jae    @@next_event
  inc    [dword ISR_pc]

  sub    [zoomend_pal_hl],1
  js     @@set_z
  ret
@@set_z:
  mov    [zoomend_pal_hl],0
  ret
endp

proc break_away
;  mov    esi,[crus64_pal]
;  xor    eax,eax
;  mov    ecx,224
;  call   fade_pal_init

  mov    edx,SCREEN_X*SCREEN_Y
  mov    eax,0EE42h         ; allocate a DOS32 memory block
  Int    31h                ;  expects EDX = size; ret EAX=size, EDX->pointer
  mov    [break_away_pic],edx
  mov    edi,edx

  mov    esi,[crus64_pic]
  add    esi,4
  xor    ebx,ebx
  mov    ch,10
@@alloc_y:
  push   esi

  mov    cl,10
@@alloc_x:
  push   ecx esi

  mov    dl,48
@@copy_d:                   ;copy section of data to box
  mov    ecx,64/4
  rep    movsd
  add    esi,640-64
  dec    dl
  jnz    @@copy_d

  pop    esi ecx
  add    esi,64
  dec    cl
  jnz    @@alloc_x

  pop    esi
  add    esi,640*48
  dec    ch
  jnz    @@alloc_y

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  mov    esi,offset ba_r
  mov    ch,10
  xor    ebx,ebx
@@s_coordy:
  xor    eax,eax
  mov    cl,10
@@s_coordx:
  mov    [esi+tba_r.x],eax
  mov    [esi+tba_r.y],ebx
  add    eax,64 shl BREAK_shifter
  add    esi,size tba_r
  dec    cl
  jnz    @@s_coordx
  add    ebx,48 shl BREAK_shifter
  dec    ch
  jnz    @@s_coordy

;;paint;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  mov    [ISR_event],BA_START
  mov    [ISR_pc],0
  mov    eax,offset ba_calc_ISR
  mov    [fg_calc],eax

@@ani:
  mov    edi,[Rendbuff]
  mov    ecx,(SCREEN_X*SCREEN_Y)/4
  mov    eax,09090909h
  rep    stosd

  cmp    [byte ISR_event],BA_START
  jne    @@ignore_p
  mov    esi,offset ba_r
  mov    edi,[break_away_pic]
  mov    cl,10*10
@@paint:
  cmp    [esi+tba_r.status],2
  je     @@dontpaint
  push   ecx esi edi
  push   edi
  push   [Rendbuff]

  mov    eax,64 shl BREAK_shifter
  sub    eax,[esi+tba_r.xsize]
  sar    eax,1
  add    eax,[esi+tba_r.x]
  sar    eax,BREAK_shifter
  push   eax

  mov    eax,48 shl BREAK_shifter
  sub    eax,[esi+tba_r.ysize]
  sar    eax,1
  add    eax,[esi+tba_r.y]
  sar    eax,BREAK_shifter
  push   eax

  push   64
  push   48
  mov    eax,[esi+tba_r.xsize]
  sar    eax,BREAK_shifter
  push   eax
  mov    eax,[esi+tba_r.ysize]
  sar    eax,BREAK_shifter
  push   eax
  push   640
  call   pscaler
  add    esp,(size pscaler_stack)-8
  pop    edi esi ecx
@@dontpaint:
  add    esi,size tba_r
  add    edi,64*48
  dec    cl
  jnz    @@paint
  jmp    @@ignore_p
@@ignore_p:
  call   t_traject            ;paint foreground scroller
  call   [sync_screen]

  cmp    [byte ISR_event],BA_FADEOUT
  jne    @@dset_p
  xor    eax,eax
  mov    ecx,224
  mov    ebx,[zoomend_pal_hl]
  call   fade_pal
@@dset_p:

  cmp    [byte ISR_event],BA_DONE
  je     @@end
  call   key_pressed2
  jnc    @@ani
  call   get_key
  cmp    al,27
  je     @@end
  jmp    @@ani
@@end:

  mov    eax,0EE40h         ; delocate
  int    31h
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; 3D SHOW                                                                 ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; "COMMON GOURAUD" ring scroller                                          ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
cg_rings_rotate       dd 0
cg_rings_scale        dd 5000h

struc ta_rings_data
  pic_addr            dd ?
  angle               dd ?
ends

cg_rings_data         ta_rings_data 13 dup(<>)

CGRING_SPACING        = 145
CGRING_SPACING2       = 100

proc cg_rings_init
  mov    esi,offset gour_pal
  mov    eax,256-(32*3)
  mov    ecx,gour_pal_size
  call   fade_pal_init
  mov    eax,256-(32*3)
  mov    ecx,gour_pal_size
  xor    ebx,ebx
  call   fade_pal

  mov    edx,85*85*2
  mov    eax,0EE42h         ; allocate a DOS32 memory block
  Int    31h                ;  expects EDX = size; ret EAX=size, EDX->pointer
  mov    [pic_mt1],edx

  mov    edi,[pic_mt1]                ; init bm rotator
  mov    eax,85
  mov    ebx,85
  call   BM_rotate_init

  mov    eax,[gour_c_pic]
  mov    [cg_rings_data+(size ta_rings_data*00).pic_addr],eax
  mov    [cg_rings_data+(size ta_rings_data*00).angle],CGRING_SPACING*0

  mov    eax,[gour_o_pic]
  mov    [cg_rings_data+(size ta_rings_data*01).pic_addr],eax
  mov    [cg_rings_data+(size ta_rings_data*01).angle],CGRING_SPACING*1

  mov    eax,[gour_m_pic]
  mov    [cg_rings_data+(size ta_rings_data*02).pic_addr],eax
  mov    [cg_rings_data+(size ta_rings_data*02).angle],CGRING_SPACING*2

  mov    eax,[gour_m_pic]
  mov    [cg_rings_data+(size ta_rings_data*03).pic_addr],eax
  mov    [cg_rings_data+(size ta_rings_data*03).angle],CGRING_SPACING*3

  mov    eax,[gour_o_pic]
  mov    [cg_rings_data+(size ta_rings_data*04).pic_addr],eax
  mov    [cg_rings_data+(size ta_rings_data*04).angle],CGRING_SPACING*4

  mov    eax,[gour_n_pic]
  mov    [cg_rings_data+(size ta_rings_data*05).pic_addr],eax
  mov    [cg_rings_data+(size ta_rings_data*05).angle],CGRING_SPACING*5

  mov    eax,[gour_g_pic]
  mov    [cg_rings_data+(size ta_rings_data*06).pic_addr],eax
  mov    [cg_rings_data+(size ta_rings_data*06).angle],(CGRING_SPACING*6)+CGRING_SPACING2

  mov    eax,[gour_o_pic]
  mov    [cg_rings_data+(size ta_rings_data*07).pic_addr],eax
  mov    [cg_rings_data+(size ta_rings_data*07).angle],(CGRING_SPACING*7)+CGRING_SPACING2

  mov    eax,[gour_u_pic]
  mov    [cg_rings_data+(size ta_rings_data*08).pic_addr],eax
  mov    [cg_rings_data+(size ta_rings_data*08).angle],(CGRING_SPACING*8)+CGRING_SPACING2

  mov    eax,[gour_r_pic]
  mov    [cg_rings_data+(size ta_rings_data*09).pic_addr],eax
  mov    [cg_rings_data+(size ta_rings_data*09).angle],(CGRING_SPACING*9)+CGRING_SPACING2

  mov    eax,[gour_a_pic]
  mov    [cg_rings_data+(size ta_rings_data*10).pic_addr],eax
  mov    [cg_rings_data+(size ta_rings_data*10).angle],(CGRING_SPACING*10)+CGRING_SPACING2

  mov    eax,[gour_u_pic]
  mov    [cg_rings_data+(size ta_rings_data*11).pic_addr],eax
  mov    [cg_rings_data+(size ta_rings_data*11).angle],(CGRING_SPACING*11)+CGRING_SPACING2

  mov    eax,[gour_d_pic]
  mov    [cg_rings_data+(size ta_rings_data*12).pic_addr],eax
  mov    [cg_rings_data+(size ta_rings_data*12).angle],(CGRING_SPACING*12)+CGRING_SPACING2

  ret
endp

proc cg_rings_deinit
  mov    eax,0EE40h           ; delocate rotational mult table
  int    31h
  ret
endp

proc paint_cg_rings
  mov    esi,offset cg_rings_data
  mov    cl,13
@@l:
  push   ecx esi
  mov    eax,[cg_rings_rotate]
  add    eax,[esi+ta_rings_data.angle]
  @find_sine
  imul   [dword cg_rings_scale]
  sar    eax,16
  add    eax,(640/2)-(85/2)
  mov    [@@x_pos],eax

  mov    eax,[cg_rings_rotate]
  add    eax,[esi+ta_rings_data.angle]
  @find_cosine
  imul   [cg_rings_scale]
  sar    eax,16
  add    eax,(480/2)-(85/2)
  mov    [@@y_pos],eax

  mov    edx,[esi+ta_rings_data.pic_addr]
  mov    eax,edx
  add    eax,4
  push   eax
  push   [Rendbuff]
  push   [pic_mt1]
  push   [@@x_pos]
  push   [@@y_pos]
  mov    eax,[cg_rings_rotate]
  add    eax,[esi+ta_rings_data.angle]
  and    eax,0fffh
  neg    eax
  push   eax
  movzx  eax,[word edx]
  push   eax
  movzx  eax,[word edx+2]
  push   eax
  push   640
  call   BM_rotate_TRANS
  add    esp,(size BM_rotate_stack)-4

  pop    esi ecx
  add    esi,size ta_rings_data
  dec    cl
  jnz    @@l
  ret
@@x_pos               dd ?
@@y_pos               dd ?
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
three_show_pal:
  X = 16 * 256
rept 64
  db                  (X / 256),(X / 256),(X / 256)
  X = X + 80h
endm

prism1_data:
include "3d\prism.txt"

prism1_3d_info:
dd 230
dd 0,-100,0
dd 0,0,0
dd 1500
dd -150
dd 480/2

prism2_data:
include "3d\prism2.txt"

prism2_3d_info:
dd 80
dd 0,-100,0
dd 0,0,0
dd 1500
dd 640/2
dd 500

prism_pos             dd 500 shl 1

threed_ISR_event      db ?
threed_ISR_pc         dd ?

THREED_PRISM2         = 0
THREED_SETUP_PRISM1   = 1
THREED_PRISM1         = 2

threed_x_r            dd 0
threed_y_r            dd 0
threed_z_r            dd 0

proc prism2_3d_calc
  cmp    [byte threed_ISR_event],THREED_PRISM2
  je     @@prism2
  cmp    [byte threed_ISR_event],THREED_SETUP_PRISM1
  je     @@prism1_setup
  cmp    [byte threed_ISR_event],THREED_PRISM1
  je     @@prism1
  ret
@@prism2:
  mov    esi,offset prism2_3d_info
  add    [threed_x_r],3
  add    [threed_y_r],3
  add    [threed_z_r],3

  dec    [prism_pos]

  cmp    [prism_pos],-220
  jl     @@next_event
  ret
@@prism1_setup:
  mov    [prism_pos],-200 shl 1
  jmp    @@next_event
@@prism1:
  mov    esi,offset prism1_3d_info
  add    [threed_x_r],3
;  add    [threed_y_r],4
;  add    [threed_z_r],3

  add    [prism_pos],2
  cmp    [prism_pos],800 shl 1
  jg     @@next_event
  ret
@@next_event:
  mov    [dword threed_ISR_pc],0
  inc    [byte threed_ISR_event]
  ret
endp

proc threed_sani_init
  mov    [byte _threed_pal_base],20
  mov    [byte _threed_pal_size],64

  mov    esi,offset three_show_pal
  mov    ecx,64*3
  mov    al,20
  @WritePalette

  mov    edx,(size tfacet_sort)*300
  mov    eax,0EE42h         ; allocate a DOS32 memory block
  Int    31h                ;  expects EDX = size; ret EAX=size, EDX->pointer
  mov    [_facet_sort],edx

  mov    edx,(size ttranstrifacet)*300
  mov    eax,0EE42h         ; allocate a DOS32 memory block
  Int    31h                ;  expects EDX = size; ret EAX=size, EDX->pointer
  mov    [_transformed],edx

  mov    eax,offset prism1_3d_info
  push   eax
  mov    eax,offset prism1_data
  push   eax
  call   _calc_normals
  add    esp,8

  mov    eax,offset prism2_3d_info
  push   eax
  mov    eax,offset prism2_data
  push   eax
  call   _calc_normals
  add    esp,8

  mov    [threed_ISR_event],THREED_PRISM2
  mov    [threed_ISR_pc],0
;  mov    eax,offset prism2_3d_calc
;  mov    [fg_calc],eax
  ret
endp

proc threed_sani_deinit
  mov    eax,0EE40h
  int    31h
  mov    eax,0EE40h
  int    31h
  ret
endp

proc threed_sani
;  call   threed_sani_init
;@@l:
;;;;;;;;;;;; set values
  cli

  mov    eax,[prism_pos]
  sar    eax,1

  cmp    [byte threed_ISR_event],THREED_PRISM1
  je     @@prism1_set
  cmp    [byte threed_ISR_event],THREED_PRISM2
  je     @@prism2_set

@@prism1_set:
  mov    esi,offset prism1_3d_info
  mov    [esi+tg3d_info.xpos],eax
  jmp    @@set_v
@@prism2_set:
  mov    esi,offset prism2_3d_info
  mov    [esi+tg3d_info.ypos],eax
  jmp    @@set_v

@@set_v:
  mov    eax,[threed_x_r]
  mov    [esi+tg3d_info.vangles.x],eax
  mov    eax,[threed_y_r]
  mov    [esi+tg3d_info.vangles.y],eax
  mov    eax,[threed_z_r]
  mov    [esi+tg3d_info.vangles.z],eax

  sti
;;;;;;;;;;;;

  cmp    [byte threed_ISR_event],THREED_PRISM1
  je     @@prism1
  cmp    [byte threed_ISR_event],THREED_PRISM2
  je     @@prism2
  jmp    @@done
@@prism1:
  mov    eax,offset prism1_3d_info
  push   eax
  mov    eax,offset prism1_data
  push   eax
  call   _paint_world
  add    esp,8
  jmp    @@done
@@prism2:
  mov    eax,offset prism2_3d_info
  push   eax
  mov    eax,offset prism2_data
  push   eax
  call   _paint_world
  add    esp,8
@@done:

;  call   [sync_screen]
;  call   key_pressed2
;  jnc    @@l
;  call   get_key
;  cmp    al,27
;  jne    @@l
;
;  call   threed_sani_deinit
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
star_palette2:
  X = 0
rept 16
  db                  (X / 256),(X / 256),((X + 800h) / 256)
  X = X + 2d0h
endm

TDPS_FADEIN           = 0
TDPS_WAIT             = 1
TDPS_WAIT2            = 2
TDPS_WAIT3            = 3
TDPS_WAIT4            = 4
TDPS_WAIT5            = 5
TDPS_WAITn            = 6
TDPS_FADEOUT          = 7
TDPS_DONE             = 8

TDPS_fadep            dd 0h
killmess_x            dd 640

proc TDPS_dec_kmx
  cmp    [dword killmess_x],0
  jz     @@end
  sub    [dword killmess_x],4
@@end:
  ret
endp

proc TDPS_ISR
  call   prism2_3d_calc

  cmp    [byte @@star_calc_miss],2
  je     @@calc_s
  inc    [byte @@star_calc_miss]
  jmp    @@cont
@@calc_s:
  mov    [byte @@star_calc_miss],0
  call   mapp_star_calc
@@cont:

  cmp    [byte ISR_event],TDPS_FADEIN
  je     @@jFADEIN
  cmp    [byte ISR_event],TDPS_WAIT
  je     @@jWAIT
  cmp    [byte ISR_event],TDPS_WAIT2
  je     @@jWAIT2
  cmp    [byte ISR_event],TDPS_WAIT3
  je     @@jWAIT3
  cmp    [byte ISR_event],TDPS_WAIT4
  je     @@jWAIT4
  cmp    [byte ISR_event],TDPS_WAIT5
  je     @@jWAIT5
  cmp    [byte ISR_event],TDPS_WAITn
  je     @@jWAITn
  cmp    [byte ISR_event],TDPS_FADEOUT
  je     @@jFADEOUT
  ret
@@next_event:
  mov    [dword ISR_pc],0
  inc    [byte ISR_event]
  ret
@@jFADEIN:
  add    [cg_rings_rotate],4
  cmp    [dword ISR_pc],100h
  jae    @@next_event
  add    [dword ISR_pc],2
  mov    ebx,[TDPS_fadep]
  mov    eax,2
  call   clip_ipal
  mov    [TDPS_fadep],ebx
  ret
@@jWAIT:
  add    [cg_rings_rotate],3
  cmp    [dword ISR_pc],14h  ;;
  jae    @@next_event
  inc    [dword ISR_pc]
  call   TDPS_dec_kmx
  ret
@@jWAIT2:
  add    [cg_rings_rotate],4
  cmp    [dword ISR_pc],3ah  ;;
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [cg_rings_scale],50h
  call   TDPS_dec_kmx
  ret
@@jWAIT3:
  add    [cg_rings_rotate],4
  cmp    [dword ISR_pc],50h  ;;
  jae    @@next_event
  inc    [dword ISR_pc]
  call   TDPS_dec_kmx
  ret
@@jWAIT4:
  add    [cg_rings_rotate],-3
  cmp    [dword ISR_pc],60h  ;;
  jae    @@next_event
  inc    [dword ISR_pc]
  sub    [cg_rings_scale],80h
  call   TDPS_dec_kmx
  ret
@@jWAIT5:
  add    [cg_rings_rotate],3
  cmp    [dword ISR_pc],30h  ;;
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [cg_rings_scale],110h
  ret
@@jWAITn:
  add    [cg_rings_rotate],4
  cmp    [dword ISR_pc],400h-(14h+3ah+50h+60h+30h)        ;400h
  jae    @@next_event
  inc    [dword ISR_pc]

  add    [@@cgrs_d],2
  mov    eax,[@@cgrs_d]
  sub    [cg_rings_scale],eax

  cmp    [cg_rings_scale],2000h
  jg     @@jwaitnd
  neg    [@@cgrs_d]
@@jwaitnd:
  ret
@@jFADEOUT:
  add    [cg_rings_rotate],-5
  cmp    [dword ISR_pc],100h
  jae    @@next_event
  inc    [dword ISR_pc]
  mov    ebx,[TDPS_fadep]
  mov    eax,2
  call   clip_dpal
  mov    [TDPS_fadep],ebx
  sub    [cg_rings_scale],80h
  ret
@@star_calc_miss      db 0
@@cgrs_d              dd 0
endp

proc TDPS_paint_star
  call   totally_clear_screen

  mov    esi,offset star_palette2
  xor    eax,eax
  mov    ecx,16
  call   fade_pal_init
  xor    eax,eax
  mov    ecx,16
  xor    ebx,ebx
  call   fade_pal

  call   mapp_star_init
  mov    [ISR_event],TDPS_FADEIN
  mov    [ISR_pc],0
  mov    eax,offset TDPS_ISR
  mov    [fg_calc],eax
@@l:
  cmp    [byte ISR_event],TDPS_FADEIN
  jne    @@fade
  cmp    [byte ISR_event],TDPS_FADEOUT
  jne    @@fade
  jmp    @@ign_fadeout
@@fade:
  xor    eax,eax
  mov    ecx,16
  mov    ebx,[dword TDPS_fadep]
  call   fade_pal

  mov    eax,256-(32*3)
  mov    ecx,gour_pal_size
  mov    ebx,[dword TDPS_fadep]
  call   fade_pal
@@ign_fadeout:

  call   mapp_star
  call   threed_sani
  call   paint_cg_rings

  mov    eax,[killmess_pic]
  mov    edx,eax
  add    eax,4
  push   eax
  push   [dword Rendbuff]
  push   [dword killmess_x]
  push   470
  xor    eax,eax
  mov    ax,[word edx]
  push   eax
  mov    ax,[word 2+edx]
  push   eax
  push   640
  call   RBBitmap_TRANS
  add    esp,(size RBBitmap_stack)-8

  call   [sync_screen]
  cmp    [byte ISR_event],TDPS_DONE
  je     @@end
  call   key_pressed2
  jnc    @@l
  call   get_key
  cmp    al,27
  jne    @@l
@@end:
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PET_PAL_SHIFTER       = 2

pet_pal:
db  0,0,0,58 shr 2,46 shr 2,46 shr 2,66 shr 2,53 shr 2,53 shr 2,74 shr 2,59 shr 2,59 shr 2

pet1_col              dd -79 shl PET_PAL_SHIFTER
pet2_col              dd 0   shl PET_PAL_SHIFTER

TDPS2_FADEIN          = 0
TDPS2_WAIT            = 1
TDPS2_FADEOUT         = 2
TDPS2_DONE            = 3

proc TDPS2_inc_kmx
  cmp    [dword killmess_x],640
  ja     @@end
  add    [dword killmess_x],4
@@end:
  ret
endp

proc TDPS2_ISR
  call   prism2_3d_calc

  add    [angle1],10
  and    [angle1],0ffffh ;shl PET_PAL_SHIFTER

  add    [angle2],-3
  and    [angle2],0ffffh ;shl PET_PAL_SHIFTER

  inc    [pet1_col]
  cmp    [pet1_col],0
  jl     @@dont_rpet1
  mov    [pet1_col],-79 shl PET_PAL_SHIFTER
@@dont_rpet1:

  dec    [pet2_col]
  cmp    [pet2_col],-79 shl PET_PAL_SHIFTER
  jg     @@dont_rpet2
  mov    [pet2_col],0
@@dont_rpet2:

  cmp    [byte ISR_event],TDPS2_FADEIN
  je     @@jFADEIN
  cmp    [byte ISR_event],TDPS2_WAIT
  je     @@jWAIT
  cmp    [byte ISR_event],TDPS2_FADEOUT
  je     @@jFADEOUT
  ret
@@next_event:
  mov    [dword ISR_pc],0
  inc    [byte ISR_event]
  ret
@@jFADEIN:
  cmp    [dword ISR_pc],100h
  jae    @@next_event
  add    [dword ISR_pc],2
  mov    ebx,[TDPS_fadep]
  mov    eax,2
  call   clip_ipal
  mov    [TDPS_fadep],ebx
  ret
@@jWAIT:
  cmp    [dword ISR_pc],300h
  jae    @@next_event
  inc    [dword ISR_pc]
  call   TDPS2_inc_kmx
  ret
@@jFADEOUT:
  cmp    [dword ISR_pc],100h
  jae    @@next_event
  inc    [dword ISR_pc]
  mov    ebx,[TDPS_fadep]
  mov    eax,2
  call   clip_dpal
  mov    [TDPS_fadep],ebx
  ret
@@star_calc_miss      db 0
endp

proc TDPS2_pet_paint
  mov    [angle1],0
  mov    [angle2],0
  mov    [TDPS_fadep],0

  mov    edx,79*79*2
  mov    eax,0EE42h         ; allocate a DOS32 memory block
  Int    31h                ;  expects EDX = size; ret EAX=size, EDX->pointer
  mov    [pic_mt1],edx

  mov    edi,[pic_mt1]                ; init bm rotator
  mov    eax,79
  mov    ebx,79
  call   BM_rotate_init

  mov    edx,79*79          ; allocate pettle rotated block
  mov    eax,0EE42h
  Int    31h
  mov    [Rendbuff2],edx

  mov    edx,79*79          ; allocate pettle rotated block
  mov    eax,0EE42h
  Int    31h
  mov    [Rendbuff3],edx

  mov    esi,offset pet_pal
  xor    eax,eax
  mov    ecx,4
  call   fade_pal_init
  xor    eax,eax
  mov    ecx,4
  xor    ebx,ebx
  call   fade_pal

  mov    [ISR_event],TDPS2_FADEIN
  mov    [ISR_pc],0
  mov    eax,offset TDPS2_ISR
  mov    [fg_calc],eax
@@l:
;--------fade etc
  cmp    [byte ISR_event],TDPS2_FADEIN
  jne    @@fade
  cmp    [byte ISR_event],TDPS2_FADEOUT
  jne    @@fade
  jmp    @@ign_fadeout
@@fade:
  xor    eax,eax
  mov    ecx,4
  mov    ebx,[dword TDPS_fadep]
  call   fade_pal

@@ign_fadeout:

;clear screen
  mov    edi,[Rendbuff]
  mov    ecx,(640*480)/4
  mov    eax,01010101h
  rep    stosd

;petal 1 rotate
  mov    eax,[pet1_pic]
  add    eax,4
  push   eax
  push   [Rendbuff2]
  push   [pic_mt1]
  push   0
  push   0
  mov    eax,[angle1]
  sar    eax,PET_PAL_SHIFTER
  push   eax
  push   79
  push   79
  push   79
  call   BM_rotate
  add    esp,(size BM_rotate_stack)-4
;petal 2 rotate
  mov    eax,[pet2_pic]
  add    eax,4
  push   eax
  push   [Rendbuff3]
  push   [pic_mt1]
  push   0
  push   0
  mov    eax,[angle2]
  sar    eax,PET_PAL_SHIFTER
  push   eax
  push   79
  push   79
  push   79
  call   BM_rotate
  add    esp,(size BM_rotate_stack)-4

  mov    edx,[pet1_col]
  sar    edx,PET_PAL_SHIFTER
;create column stars
  xor    ebx,ebx
  mov    ch,3
@@paint_starrow:
  push   edx
  mov    cl,9
@@paint_starcol:
  push   ecx edx ebx
  push   [Rendbuff2]
  push   [Rendbuff]
  push   edx
  push   ebx
  push   79
  push   79
  push   640
  call   RBBitmap_TRANS
  add    esp,(size RBBitmap_stack)-8
  pop    ebx edx ecx
  add    edx,79
  dec    cl
  jnz    @@paint_starcol
  add    ebx,79*2
  pop    edx
  dec    ch
  jnz    @@paint_starrow

  mov    edx,[pet2_col]
  sar    edx,PET_PAL_SHIFTER
;create column petals
  mov    ebx,80
  mov    ch,3
@@paint_petrow:
  push   edx
  mov    cl,9
@@paint_petcol:
  push   ecx edx
  push   [Rendbuff3]
  push   [Rendbuff]
  push   edx
  push   ebx
  push   79
  push   79
  push   640
  call   RBBitmap_TRANS
  add    esp,(size RBBitmap_stack)-8
  pop    edx ecx
  add    edx,79
  dec    cl
  jnz    @@paint_petcol
  add    ebx,79*2
  pop    edx
  dec    ch
  jnz    @@paint_petrow

  call   threed_sani

  mov    eax,[killmess_pic]
  mov    edx,eax
  add    eax,4
  push   eax
  push   [dword Rendbuff]
  push   [dword killmess_x]
  push   470
  xor    eax,eax
  mov    ax,[word edx]
  push   eax
  mov    ax,[word 2+edx]
  push   eax
  push   640
  call   RBBitmap_TRANS
  add    esp,(size RBBitmap_stack)-8

  call   [sync_screen]
  cmp    [byte ISR_event],TDPS2_DONE
  je     @@end
  call   key_pressed2
  jnc    @@l
  call   get_key
  cmp    al,27
  jne    @@l
@@end:
  mov    eax,0EE40h
  int    31h
  mov    eax,0EE40h
  int    31h
  mov    eax,0EE40h
  int    31h
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc do_3d_show
  call   threed_sani_init
  call   cg_rings_init
  call   TDPS_paint_star
  cmp    [last_get_key],27
  je     @@end
  call   TDPS2_pet_paint
@@end:
  call   cg_rings_deinit
  call   threed_sani_deinit
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; VIRTUAL FRACTCAL LAST BIT                                               ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
end_credits_1a        = 1
end_credits_1b        = 2
end_credits_1c        = 3
end_credits_1d        = 4
end_credits_1e        = 5
end_credits_2load     = 6
end_credits_2a        = 7
end_credits_2b        = 8
end_credits_2c        = 9
end_credits_2d        = 10
end_credits_2e        = 11
end_credits_3load     = 12
end_credits_3a        = 13
end_credits_3b        = 14
end_credits_3c        = 15
end_credits_3d        = 16
end_credits_3e        = 17

end_credits_4load     = 18
end_credits_4         = 19
end_credits_4wait     = 20

end_credits_5load     = 21
end_credits_5         = 22
end_credits_5wait     = 23

end_credits_6load     = 24
end_credits_6         = 25
end_credits_6wait     = 26

end_credits_7load     = 27
end_credits_7         = 28

end_credits_DONE      = 29

end_credits_ISR_event db ?
end_credits_ISR_pc    dd ?

end_credits_x         dd ?
end_credits_y         dd ?
end_credits_y_inc     dd ?

proc end_credits_ISR
  cmp    [byte end_credits_ISR_event],end_credits_1a
  je     @@jend_credits_1a
  cmp    [byte end_credits_ISR_event],end_credits_1b
  je     @@jend_credits_1b
  cmp    [byte end_credits_ISR_event],end_credits_1c
  je     @@jend_credits_1c
  cmp    [byte end_credits_ISR_event],end_credits_1d
  je     @@jend_credits_1d
  cmp    [byte end_credits_ISR_event],end_credits_1e
  je     @@jend_credits_1e

  cmp    [byte end_credits_ISR_event],end_credits_2a
  je     @@jend_credits_2a
  cmp    [byte end_credits_ISR_event],end_credits_2b
  je     @@jend_credits_2b
  cmp    [byte end_credits_ISR_event],end_credits_2c
  je     @@jend_credits_1c
  cmp    [byte end_credits_ISR_event],end_credits_2d
  je     @@jend_credits_2d
  cmp    [byte end_credits_ISR_event],end_credits_2e
  je     @@jend_credits_2e

  cmp    [byte end_credits_ISR_event],end_credits_3a
  je     @@jend_credits_2a
  cmp    [byte end_credits_ISR_event],end_credits_3b
  je     @@jend_credits_2b
  cmp    [byte end_credits_ISR_event],end_credits_3c
  je     @@jend_credits_1c
  cmp    [byte end_credits_ISR_event],end_credits_3d
  je     @@jend_credits_2d
  cmp    [byte end_credits_ISR_event],end_credits_3e
  je     @@jend_credits_2e

  cmp    [byte end_credits_ISR_event],end_credits_4
  je     @@jend_credits_4
  cmp    [byte end_credits_ISR_event],end_credits_4wait
  je     @@jend_credits_4wait

  cmp    [byte end_credits_ISR_event],end_credits_5
  je     @@jend_credits_4
  cmp    [byte end_credits_ISR_event],end_credits_5wait
  je     @@jend_credits_4wait
  cmp    [byte end_credits_ISR_event],end_credits_6
  je     @@jend_credits_4
  cmp    [byte end_credits_ISR_event],end_credits_6wait
  je     @@jend_credits_4wait
  cmp    [byte end_credits_ISR_event],end_credits_7
  je     @@jend_credits_4
  ret
@@next_event:
  mov    [dword end_credits_ISR_pc],0
  inc    [byte end_credits_ISR_event]
  ret
@@jend_credits_1a:
  cmp    [dword end_credits_ISR_pc],298 ;600
  jae    @@next_event
  inc    [dword end_credits_ISR_pc]
  mov    eax,[end_credits_y_inc]
  sub    [end_credits_y],eax
  ret
@@jend_credits_1b:
  mov    eax,[end_credits_y_inc]
  sub    [end_credits_y],eax
  sub    [dword end_credits_y_inc],8 ;4
  jz     @@next_event
  ret
@@jend_credits_1c:
  cmp    [dword end_credits_ISR_pc],200
  jae    @@next_event
  inc    [dword end_credits_ISR_pc]
  ret
@@jend_credits_1d:
  mov    eax,[end_credits_y_inc]
  add    [end_credits_y],eax
  add    [dword end_credits_y_inc],8 ;4
  cmp    [dword end_credits_y_inc],3 shl 8 ;1 shl 8
  je     @@next_event
  ret
@@jend_credits_1e:
  cmp    [dword end_credits_ISR_pc],300
  jae    @@next_event
  inc    [dword end_credits_ISR_pc]
  mov    eax,[end_credits_y_inc]
  add    [end_credits_y],eax
  ret
@@jend_credits_2a:
  cmp    [dword end_credits_ISR_pc],145
  jae    @@next_event
  inc    [dword end_credits_ISR_pc]
  mov    eax,[end_credits_y_inc]
  sub    [end_credits_x],eax
  ret
@@jend_credits_2b:
  mov    eax,[end_credits_y_inc]
  sub    [end_credits_x],eax
  sub    [dword end_credits_y_inc],8
  jz     @@next_event
  ret
@@jend_credits_2c:
  cmp    [dword end_credits_ISR_pc],400
  jae    @@next_event
  inc    [dword end_credits_ISR_pc]
  mov    eax,[end_credits_y_inc]
  sub    [end_credits_x],eax
  ret
@@jend_credits_2d:
  mov    eax,[end_credits_y_inc]
  sub    [end_credits_x],eax
  add    [dword end_credits_y_inc],8
  cmp    [dword end_credits_y_inc],3 shl 8
  je     @@next_event
  ret
@@jend_credits_2e:
  cmp    [dword end_credits_ISR_pc],230
  jae    @@next_event
  inc    [dword end_credits_ISR_pc]
  mov    eax,[end_credits_y_inc]
  sub    [end_credits_x],eax
  ret
@@jend_credits_4:
  cmp    [dword end_credits_ISR_pc],250
  jae    @@next_event
  inc    [dword end_credits_ISR_pc]
  ret
@@jend_credits_4wait:
  cmp    [dword end_credits_ISR_pc],50
  jae    @@next_event
  inc    [dword end_credits_ISR_pc]
  ret
endp

proc end_credits_init
  mov    [dword end_credits_x],0
  mov    [dword end_credits_y],700 shl 8
  mov    [dword end_credits_y_inc],2 shl 8 ;1 shl 8

  call   t_traject_pack
  mov    [end_credits_ISR_event],end_credits_1a
  mov    [end_credits_ISR_pc],0
  ret
endp

proc end_credits
  cmp    [byte end_credits_ISR_event],end_credits_4wait
  je     @@end
  cmp    [byte end_credits_ISR_event],end_credits_5wait
  je     @@end
  cmp    [byte end_credits_ISR_event],end_credits_6wait
  je     @@end

  cmp    [byte end_credits_ISR_event],end_credits_2load
  je     @@load2
  cmp    [byte end_credits_ISR_event],end_credits_3load
  je     @@load2
  cmp    [byte end_credits_ISR_event],end_credits_4load
  je     @@load4
  cmp    [byte end_credits_ISR_event],end_credits_5load
  je     @@load4
  cmp    [byte end_credits_ISR_event],end_credits_6load
  je     @@load4
  cmp    [byte end_credits_ISR_event],end_credits_7load
  je     @@load4
  cmp    [byte end_credits_ISR_event],end_credits_DONE
  jne    @@display_scroll
@@end:
  ret
@@load2:
  call   t_traject_pack
  inc    [byte end_credits_ISR_event]

  mov    [dword end_credits_x],600 shl 8
  mov    [dword end_credits_y],50 shl 8
  mov    [dword end_credits_y_inc],3 shl 8
  ret
@@load4:
  call   t_traject_pack
  inc    [byte end_credits_ISR_event]
  mov    [dword end_credits_x],0
  mov    [dword end_credits_y],50 shl 8
  ret
@@display_scroll:
  mov    esi,offset scroll_pack_buf
  mov    ebx,[dword end_credits_x]
  mov    ecx,[dword end_credits_y]
  sar    ebx,8
  sar    ecx,8
@@l:
  push   esi ebx ecx
  mov    al,[esi+tletter.letter]
  cmp    al,"$"
  je     @@done_ps
  and    eax,0ffh
  push   eax
  push   [font_pic]
  push   [Rendbuff]
  mov    eax,[esi+tletter.x]
  add    eax,ebx
  push   eax
  mov    eax,[esi+tletter.y]
  add    eax,ecx
  push   eax
  push   640
  call   draw_FNT
  add    esp,(size draw_FNT_stack)-4

  pop    ecx ebx esi
  add    esi,size tletter
  jmp    @@l
  ret
@@done_ps:
  pop    ecx ebx esi
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
sr_bar_src            dd ?
sr_bar_tar            dd ?
sr_bar_xl             dd ?
sr_bar_yl             dd ?
sr_bar_xl_inc         dd ?


sr_bar_src2           dd ?
sr_bar_tar2           dd ?

proc paint_sr_bloc
  mov    dl,10
@@sr_bar_lxl:
  mov    eax,[esi]
  mov    [edi],eax
  mov    eax,[esi+4]
  mov    [edi+4],eax
  mov    ax,[esi+8]
  mov    [edi+8],ax
  mov    al,[esi+10]
  mov    [edi+10],al
  add    esi,638
  add    edi,640
  dec    dl
  jnz    @@sr_bar_lxl
  ret
endp

proc paint_sr_bar
  cmp    [dword sr_bar_yl],0
  jz     @@end_srb

  mov    esi,[sr_bar_src]
  mov    edi,[sr_bar_tar]
  call   paint_sr_bloc

  mov    esi,[sr_bar_src2]
  mov    edi,[sr_bar_tar2]
  call   paint_sr_bloc

  dec    [dword sr_bar_xl]
  jz     @@loop_x

  mov    eax,[sr_bar_xl_inc]
  add    [sr_bar_src],eax
  add    [sr_bar_tar],eax

  sub    [sr_bar_src2],eax
  sub    [sr_bar_tar2],eax
@@end_srb:
  ret
@@loop_x:
  mov    [dword sr_bar_xl],58
  add    [dword sr_bar_src],638*10
  add    [dword sr_bar_tar],640*10

  sub    [dword sr_bar_src2],638*10
  sub    [dword sr_bar_tar2],640*10

  neg    [dword sr_bar_xl_inc]
  dec    [dword sr_bar_yl]
  ret
endp

proc paint_sr_bloc_init
  add    eax,4
  mov    [sr_bar_src],eax
  add    eax,(638*99)-(11+(638*10))
  mov    [sr_bar_src2],eax

  mov    eax,[rendbuff]
  inc    eax
  mov    [sr_bar_tar],eax
  add    eax,(640*99)-(13+(640*10))
  mov    [sr_bar_tar2],eax

  mov    [dword sr_bar_xl],58
  mov    [dword sr_bar_yl],5
  mov    [dword sr_bar_xl_inc],11

  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; f3d_start
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
F3D_START_ANI1        = 0
F3D_START_DONE        = 1

proc f3d_start_ISR
  cmp    [byte ISR_event],F3D_START_ANI1
  je     @@jF3D_START_ANI1
  ret
@@next_event:
  mov    [dword ISR_pc],0
  inc    [byte ISR_event]
  ret
@@jF3D_START_ANI1:
  cmp    [dword ISR_pc],500
  jae    @@next_event
  inc    [dword ISR_pc]
  ret
endp

proc f3d_start
  cmp    [byte demo_card_type],4
  je     @@nosound
@@wait_until2np:
  cmp    [byte funk_info.sequence_ofs],1bh
  jb     @@wait_until2np
@@nosound:

  mov    eax,[sr_bar_2_pic]
  call   paint_sr_bloc_init

  mov    [ISR_event],F3D_START_ANI1
  mov    [ISR_pc],0
  mov    eax,offset f3d_start_ISR
  mov    [fg_calc],eax
@@paint:
  call   paint_sr_bar
  call   paint_sr_bar
  call   [sync_screen]

  cmp    [byte demo_card_type],4
  je     @@nosound2
  cmp    [byte funk_info.sequence_ofs],1dh
  jae    @@end
  jmp    @@cont
@@nosound2:
  cmp    [byte ISR_event],F3D_START_DONE
  je     @@end
@@cont:
  call   key_pressed2
  jnc    @@paint
  call   get_key
  cmp    al,27
  je     @@end
  jmp    @@paint
@@end:
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
F3D_1_ANI1            = 1
F3D_1_ANI2            = 2
F3D_1_ANI4            = 3
F3D_1_ANI5            = 4
F3D_1_DONE            = 5

f3d1_xangle_inc       dd 800h
f3d1_xangle           dd 0
f3d1_zangle           dd 0
f3d1_focus_z          dd 0
f3d1_distance         dd 60000
f3d1_posty            dd 480/2

proc f3d_1_ISR
  call   end_credits_ISR

  cmp    [byte ISR_event],F3D_1_ANI1
  je     @@jF3D_1_ANI1
  cmp    [byte ISR_event],F3D_1_ANI2
  je     @@jF3D_1_ANI2
  cmp    [byte ISR_event],F3D_1_ANI4
  je     @@jF3D_1_ANI4
  cmp    [byte ISR_event],F3D_1_ANI5
  je     @@jF3D_1_ANI5
  ret
@@next_event:
  mov    [dword ISR_pc],0
  inc    [byte ISR_event]
  ret
@@jF3D_1_ANI1:
  cmp    [dword ISR_pc],400
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [dword f3d1_xangle],600h
  mov    eax,[f3d1_distance]
  sar    eax,6
  sub    [f3d1_distance],eax
  ret
@@jF3D_1_ANI2:
  cmp    [dword ISR_pc],100
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [dword f3d1_xangle],600h
  ret
@@jF3D_1_ANI4:
  cmp    [dword ISR_pc],150
  jae    @@next_event
  inc    [dword ISR_pc]
  mov    eax,[f3d1_xangle_inc]
  add    [dword f3d1_xangle],eax
  sub    [dword f3d1_xangle_inc],20h
  ret
@@jF3D_1_ANI5:
  cmp    [dword ISR_pc],460
  jae    @@next_event
  inc    [dword ISR_pc]
  mov    eax,[f3d1_xangle_inc]
  add    [dword f3d1_xangle],eax
  mov    eax,[f3d1_distance]
  sar    eax,6
  add    [f3d1_distance],eax
  inc    [dword f3d1_distance]
  ret
endp

proc f3d_1
  mov    eax,[f004_no_facets]
  mov    [f3d_no_facets],eax
  mov    eax,[f004_world_ptr]
  mov    [f3d_world_ptr],eax

  mov    esi,offset f004_pal
  mov    ecx,f004_pal_size
  xor    al,al
  @WritePalette

;  mov    eax,[sr_bar_2_pic]
;  call   paint_sr_bloc_init
  call   f3d_init

  mov    [ISR_event],F3D_1_ANI1
  mov    [ISR_pc],0
  mov    eax,offset f3d_1_ISR
  mov    [fg_calc],eax
@@paint:
  cli
  mov    eax,[f3d1_xangle]
  sar    eax,8
  mov    [f3d_xangle],eax
  mov    eax,[f3d1_distance]
  mov    [f3d_distance],eax
  sti

  call   paint_sr_bar
  call   paint_sr_bar

  mov    edi,[Rendbuff]
  add    edi,100*640
  mov    ecx,(640*380)/4
  xor    eax,eax
  rep    stosd

  call   f3d_project_world
  call   f3d_draw_world
  call   end_credits

  call   [sync_screen]
  cmp    [byte ISR_event],F3D_1_DONE
  je     @@end
  call   key_pressed2
  jnc    @@paint
  call   get_key
  cmp    al,27
  je     @@end
  jmp    @@paint
@@end:

  call   f3d_deinit
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
F3D_2_ANI1            = 1
F3D_2_ANI2            = 2
F3D_2_ANIWAIT         = 3
F3D_2_ANI4            = 4
F3D_2_ANI4_1          = 5
F3D_2_ANI4_2          = 6
F3D_2_ANI4_3          = 7
F3D_2_ANI5            = 8
F3D_2_ANI6            = 9
F3D_2_DONE            = 10

proc f3d_2_ISR
  call   end_credits_ISR

  cmp    [byte ISR_event],F3D_2_ANI1
  je     @@jF3D_2_ANI1
  cmp    [byte ISR_event],F3D_2_ANI2
  je     @@jF3D_2_ANI2
  cmp    [byte ISR_event],F3D_2_ANIWAIT
  je     @@jF3D_2_ANIWAIT
  cmp    [byte ISR_event],F3D_2_ANI4
  je     @@jF3D_2_ANI4
  cmp    [byte ISR_event],F3D_2_ANI4_1
  je     @@jF3D_2_ANI4_1
  cmp    [byte ISR_event],F3D_2_ANI4_2
  je     @@jF3D_2_ANI4_2
  cmp    [byte ISR_event],F3D_2_ANI4_3
  je     @@jF3D_2_ANI4_3
  cmp    [byte ISR_event],F3D_2_ANI5
  je     @@jF3D_2_ANI5
  cmp    [byte ISR_event],F3D_2_ANI6
  je     @@jF3D_2_ANI6
  ret
@@next_event:
  mov    [dword ISR_pc],0
  inc    [byte ISR_event]
  ret
@@jF3D_2_ANI1:
  cmp    [dword ISR_pc],220
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [dword f3d1_xangle],400h
  mov    eax,[f3d1_distance]
  sar    eax,6
  sub    [f3d1_distance],eax
  ret
@@jF3D_2_ANI2:
  cmp    [dword ISR_pc],140
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [dword f3d1_xangle],400h
  sub    [f3d1_zangle],1
  mov    eax,[f3d1_distance]
  sar    eax,6
  sub    [f3d1_distance],eax
  ret
@@jF3D_2_ANIWAIT:
  cmp    [dword ISR_pc],100
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [dword f3d1_xangle],400h
  ret
@@jF3D_2_ANI4:
  cmp    [dword ISR_pc],140
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [dword f3d1_xangle],400h
  sub    [dword f3d1_zangle],2h
  add    [dword f3d1_distance],20
  add    [dword f3d1_focus_z],10
  ret
@@jF3D_2_ANI4_1:
  cmp    [dword ISR_pc],300
  jae    @@next_event
  inc    [dword ISR_pc]
  sub    [dword f3d1_distance],7
  mov    eax,[f3d1_xangle_inc]
  add    [dword f3d1_xangle],eax
  sub    [dword f3d1_xangle_inc],9h
  sub    [dword f3d1_focus_z],3
  ret
@@jF3D_2_ANI4_2:
  cmp    [dword ISR_pc],200
  jae    @@next_event
  inc    [dword ISR_pc]
  mov    eax,[f3d1_xangle_inc]
  add    [dword f3d1_xangle],eax
  ret
@@jF3D_2_ANI4_3:
  cmp    [dword ISR_pc],150
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [dword f3d1_distance],10
  mov    eax,[f3d1_xangle_inc]
  add    [dword f3d1_xangle],eax
  add    [dword f3d1_xangle_inc],20h
  add    [dword f3d1_focus_z],3
  ret
@@jF3D_2_ANI5:
  cmp    [dword ISR_pc],100
  jae    @@next_event
  inc    [dword ISR_pc]
  mov    eax,[f3d1_xangle_inc]
  add    [dword f3d1_xangle],eax
  sub    [dword f3d1_xangle_inc],40h
  ret
@@jF3D_2_ANI6:
  cmp    [dword ISR_pc],95                ;<=========
  jae    @@next_event
  inc    [dword ISR_pc]
  mov    eax,[f3d1_xangle_inc]
  add    [dword f3d1_xangle],eax

  mov    eax,[f3d1_distance]
  sar    eax,5
  sub    [f3d1_distance],eax
  sub    [dword f3d1_distance],20

  sub    [dword f3d1_focus_z],20
  add    [dword f3d1_posty],1
  ret
endp

proc f3d_2
  mov    eax,[f005_no_facets]
  mov    [f3d_no_facets],eax
  mov    eax,[f005_world_ptr]
  mov    [f3d_world_ptr],eax

  mov    esi,offset f005_pal
  mov    ecx,f005_pal_size
  xor    al,al
  @WritePalette

  mov    eax,[sr_bar_3_pic]
  call   paint_sr_bloc_init
  call   f3d_init

  mov    [f3d1_xangle_inc],400h
  mov    [f3d1_zangle],1024+512
  mov    [f3d1_distance],60000

  mov    [ISR_event],F3D_2_ANI1
  mov    [ISR_pc],0
  mov    eax,offset f3d_2_ISR
  mov    [fg_calc],eax
@@paint:
  cli
  mov    eax,[f3d1_xangle]
  sar    eax,8
  mov    [f3d_xangle],eax
  mov    eax,[f3d1_zangle]
  mov    [f3d_zangle],eax
  mov    eax,[f3d1_distance]
  mov    [f3d_distance],eax
  mov    eax,[f3d1_focus_z]
  mov    [f3d_focus_z],eax
  mov    eax,[f3d1_posty]
  mov    [f3d_posty],eax
  sti

  call   paint_sr_bar
  call   paint_sr_bar
  call   paint_sr_bar
  call   paint_sr_bar

  mov    edi,[Rendbuff]
  add    edi,100*640
  mov    ecx,(640*380)/4
  xor    eax,eax
  rep    stosd

  call   f3d_project_world
  call   f3d_draw_world
  call   end_credits

  call   [sync_screen]
  cmp    [byte ISR_event],F3D_2_DONE
  je     @@end
  call   key_pressed2
  jnc    @@paint
  call   get_key
  cmp    al,27
  je     @@end
  jmp    @@paint
@@end:

  call   f3d_deinit
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
F3D_3_ANI1            = 1
F3D_3_ANI2            = 2
F3D_3_ANI3            = 3
F3D_3_DONE            = 4

proc f3d_3_ISR
  call   end_credits_ISR

  cmp    [byte ISR_event],F3D_3_ANI1
  je     @@jF3D_3_ANI1
  cmp    [byte ISR_event],F3D_3_ANI2
  je     @@jF3D_3_ANI2
  cmp    [byte ISR_event],F3D_3_ANI3
  je     @@jF3D_3_ANI3
  ret
@@next_event:
  mov    [dword ISR_pc],0
  inc    [byte ISR_event]
  ret
@@jF3D_3_ANI1:
  cmp    [dword ISR_pc],600
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [dword f3d1_xangle],400h
  mov    eax,[f3d1_distance]
  sar    eax,7
  sub    [f3d1_distance],eax
  ret
@@jF3D_3_ANI2:
  cmp    [dword ISR_pc],600
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [dword f3d1_xangle],400h
  ret
@@jF3D_3_ANI3:
  cmp    [dword ISR_pc],400
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [dword f3d1_xangle],400h
  mov    eax,[f3d1_distance]
  sar    eax,6
  add    [f3d1_distance],eax
  ret
endp

proc f3d_3
  mov    eax,[f001_no_facets]
  mov    [f3d_no_facets],eax
  mov    eax,[f001_world_ptr]
  mov    [f3d_world_ptr],eax

  mov    esi,offset f001_pal
  mov    ecx,f001_pal_size
  xor    al,al
  @WritePalette

  mov    eax,[sr_bar_1_pic]
  call   paint_sr_bloc_init
  call   f3d_init

  mov    [dword f3d1_xangle_inc],800h
  mov    [dword f3d1_xangle],0
  mov    [dword f3d_zangle],1024+170
  mov    [dword f3d_focus_z],0
  mov    [dword f3d1_distance],60000
  mov    [dword f3d_posty],480/2

  mov    [ISR_event],F3D_3_ANI1
  mov    [ISR_pc],0
  mov    eax,offset f3d_3_ISR
  mov    [fg_calc],eax
@@paint:
  cli
  mov    eax,[f3d1_xangle]
  sar    eax,8
  mov    [f3d_xangle],eax
  mov    eax,[f3d1_distance]
  mov    [f3d_distance],eax
  sti

  call   paint_sr_bar
  call   paint_sr_bar
  call   paint_sr_bar
  call   paint_sr_bar

  mov    edi,[Rendbuff]
  add    edi,100*640
  mov    ecx,(640*380)/4
  xor    eax,eax
  rep    stosd

  call   f3d_project_world
  call   f3d_draw_world
  call   end_credits

  call   [sync_screen]
  cmp    [byte ISR_event],F3D_3_DONE
  je     @@end
  call   key_pressed2
  jnc    @@paint
  call   get_key
  cmp    al,27
  je     @@end
  jmp    @@paint
@@end:

  call   f3d_deinit
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc sr3_play
  call   totally_clear_screen

  call   end_credits_init

  mov    esi,offset sr_bar_pal
  mov    ecx,sr_bar_pal_size
  mov    al,211
  @WritePalette

  call   f3d_start
  cmp    [last_get_key],27
  je     @@end

  call   f3d_1
  cmp    [last_get_key],27
  je     @@end

  call   f3d_2
  cmp    [last_get_key],27
  je     @@end

  call   f3d_3
@@end:
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; END gate shut and "the end bitmaps"                                     ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
epseudos_ypos         dd -240

epseudos_SHIFT        = 16

epseudos_xpos1        dd -320 shl epseudos_SHIFT
epseudos_x1d          dd 8 shl epseudos_SHIFT
epseudos_xpos2        dd 640 shl epseudos_SHIFT
epseudos_x2d          dd 8 shl epseudos_SHIFT

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
EPSEUDO_SHUT          = 0
EPSEUDO_ZOOMTE        = 1
EPSEUDO_ZOOMTE2       = 2
EPSEUDO_DONE          = 3

proc epseudos_zoom_dect
  mov    eax,[epseudos_x1d]
  sar    eax,epseudos_SHIFT
  jz     @@end_ZTE

  mov    eax,[epseudos_x1d]
  add    [epseudos_xpos1],eax

  cmp    [dword epseudos_xpos1],-20 shl epseudos_SHIFT
  jle    @@end_ZTE
  sub    [dword epseudos_x1d],3000h
@@end_ZTE:
  ret
endp

proc epseudos_zoom_dect2
  mov    eax,[epseudos_x2d]
  sar    eax,epseudos_SHIFT
  jz     @@end_ZTE

  mov    eax,[epseudos_x2d]
  sub    [epseudos_xpos2],eax

  cmp    [dword epseudos_xpos2],320 shl epseudos_SHIFT
  jge    @@end_ZTE
  sub    [dword epseudos_x2d],3000h
@@end_ZTE:
  ret
endp

proc do_shutting_sound
  cmp    [byte @@sss],0
  je     @@cont
  ret
@@cont:
  mov    [byte @@sss],1
  mov    cl,DOORSHUT_CHAN
  mov    dl,DOORSHUT_EFFECT
  mov    dh,(12*FX_OCTAVE)+1
  @play_sample
  mov    cl,DOORSHUT_CHAN+1
  mov    dl,DOORSHUT_EFFECT
  mov    dh,(12*FX_OCTAVE)+1
  @play_sample
  ret
@@sss                 db 0
endp

proc do_shutting_sound2
  cmp    [byte @@sss],0
  je     @@cont
  ret
@@cont:
  mov    [byte @@sss],1
  mov    cl,DOORSHUT2_CHAN
  mov    dl,DOORSHUT2_EFFECT
  mov    dh,(12*FX_OCTAVE)+1
  @play_sample
  mov    cl,DOORSHUT2_CHAN+1
  mov    dl,DOORSHUT2_EFFECT
  mov    dh,(12*FX_OCTAVE)+1
  @play_sample
  ret
@@sss                 db 0
endp

proc do_shipbuzz_sound
  cmp    [byte @@sss],0
  je     @@cont
  ret
@@cont:
  mov    [byte @@sss],1
  mov    cl,SHIPBUZZ_CHAN
  mov    dl,SHIPBUZZ_EFFECT
  mov    dh,(12*FX_OCTAVE)+8
  @play_sample
  mov    cl,SHIPBUZZ_CHAN+1
  mov    dl,SHIPBUZZ_EFFECT
  mov    dh,(12*FX_OCTAVE)+8
  @play_sample
  ret
@@sss                 db 0
endp

proc epseudos_zoom_ISR
  cmp    [byte ISR_event],EPSEUDO_SHUT
  je     @@jEPSEUDO_SHUT
  cmp    [byte ISR_event],EPSEUDO_ZOOMTE
  je     @@jEPSEUDO_ZOOMTE
  cmp    [byte ISR_event],EPSEUDO_ZOOMTE2
  je     @@jEPSEUDO_ZOOMTE2
  ret
@@next_event:
  mov    [dword ISR_pc],0
  inc    [byte ISR_event]
  ret
@@jEPSEUDO_SHUT:
  cmp    [dword ISR_pc],200
  jae    @@next_event
  inc    [dword ISR_pc]

  cmp    [dword epseudos_ypos],0
  jge    @@jEPSEUDO_SHUT_end
  add    [dword epseudos_ypos],4

  call   do_shutting_sound
  ret
@@jEPSEUDO_SHUT_end:
  mov    [dword epseudos_ypos],0
  call   do_shutting_sound2
  ret
@@jEPSEUDO_ZOOMTE:
  cmp    [dword ISR_pc],20
  jae    @@next_event
  inc    [dword ISR_pc]

  call   epseudos_zoom_dect

  call   do_shipbuzz_sound
  ret
@@jEPSEUDO_ZOOMTE2:
  cmp    [dword ISR_pc],300
  jae    @@next_event
  inc    [dword ISR_pc]

  call   epseudos_zoom_dect
  call   epseudos_zoom_dect2
  ret
endp

proc epseudos_zoom
  mov    ecx,theend1_pal_size
  mov    esi,offset theend1_pal
  mov    edi,[gate_pal]
  add    edi,128*3
  mov    ecx,theend1_pal_size
  rep    movsb

  xor    al,al
  mov    ecx,(128+3)*3
  mov    esi,[gate_pal]
  @WritePalette

  mov    [ISR_event],EPSEUDO_SHUT
  mov    [ISR_pc],0
  mov    eax,offset epseudos_zoom_ISR
  mov    [fg_calc],eax
@@paint:
  cmp    [byte ISR_event],EPSEUDO_SHUT
  jne    @@jEPSEUDO_ZOOMTE

;@@jEPSEUDO_SHUT:
;  call   clear_screen
  mov    edx,[sr_bar_1_pic]
  mov    eax,edx
  add    eax,4
  push   eax
  push   [dword Rendbuff]
  push   1
  push   0
  movzx  eax,[word edx]
  push   eax
  movzx  eax,[word edx+2]
  push   eax
  push   640
  call   RBBitmap
  add    esp,(size RBBitmap_stack)-8

  mov    esi,[dword epseudos_ypos]
  push   esi

  mov    eax,[gate_pic]
  add    eax,4
  push   eax
  push   [dword Rendbuff]
  push   0
  push   esi
  push   640
  push   480/2
  push   640
  call   RBBitmap
  add    esp,(size RBBitmap_stack)-8

  pop    esi

  mov    eax,[gate_pic]
  add    eax,4+(640*240)
  push   eax
  push   [dword Rendbuff]

  push   0
  mov    eax,240
  sub    eax,esi
  push   eax

  push   640
  push   480/2
  push   640
  call   RBBitmap
  add    esp,(size RBBitmap_stack)-8
  jmp    @@endpaint
@@jEPSEUDO_ZOOMTE:
  mov    eax,[gate_pic]
  add    eax,4
  push   eax
  push   [dword Rendbuff]
  push   0
  push   0
  push   640
  push   480
  push   640
  call   RBBitmap
  add    esp,(size RBBitmap_stack)-8

  mov    eax,[theend1_pic]
  add    eax,4
  push   eax
  push   [dword Rendbuff]
  mov    eax,[epseudos_xpos1]
  sar    eax,epseudos_SHIFT
  push   eax
  push   50
  push   320
  push   115
  push   640
  call   RBBitmap_TRANS
  add    esp,(size RBBitmap_stack)-8

  mov    eax,[theend2_pic]
  add    eax,4
  push   eax
  push   [dword Rendbuff]
  mov    eax,[epseudos_xpos2]
  sar    eax,epseudos_SHIFT
  push   eax
  push   310
  push   314
  push   115
  push   640
  call   RBBitmap_TRANS
  add    esp,(size RBBitmap_stack)-8
@@endpaint:

  call   [sync_screen]
  cmp    [byte ISR_event],EPSEUDO_DONE
  je     @@paint2

  call   key_pressed2
  jnc    @@paint
  call   get_key
  cmp    al,27
  je     @@end
  jmp    @@paint
@@paint2:

  cmp    [byte demo_card_type],4
  je     @@nosound
@@wait_until2np:
  cmp    [byte funk_info.sequence_ofs],3bh
  jb     @@wait_until2np
@@nosound:

  mov    ecx,128
@@anim_loop4:
  push   ecx
  @WaitVertend
  mov    edi,[gate_pal]
  mov    ecx,256*3
@@add_comple:
  add    [byte edi],2
  cmp    [byte edi],63
  jbe    @@dont_inc
  mov    [byte edi],63
@@dont_inc:
  inc    edi
  dec    ecx
  jnz    @@add_comple
  mov    esi,[gate_pal]
  mov    eax,0
  mov    ecx,256*3
  @WritePalette
  @WaitVert
  pop    ecx
  dec    ecx
  jnz    @@anim_loop4

  mov    bl,63
@@ddw:
  @WaitVertend
  cli
  mov    edx,03c8h
  out    dx,al
  mov    ecx,768
@@l:
  mov    edx,03c9h
  mov    al,bl
  out    dx,al
  dec    ecx
  jnz    @@l
  sti
  @WaitVert
  @WaitVertend
  @WaitVert
  dec    bl
  jns    @@ddw

@@end:
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
no_vesa_mess          db "Error: No VESA support detected, Demo aborted.",13,10,"$"
no_mem_mess           db "Error: Allocating memory, Demo aborted.",13,10,"$"
no_card_mess          db "Error: No card found, Demo aborted.",13,10,"$"
get_ready_mess        db "Get ready...$"
end_mess              db "$"
end_mess2             db "From Real 2 SuperReal  For Oz96 compo  By Jason Nunn(JsNO) of SuperReal&HORNET"
                      db "SuperReal Production Jan 96   jsno@turtle.apana.org.au,root@superr.apana.org.au"
                      db "32 Rothdale Rd,Moil,NT,0810,Australiahttp://www.cdrom.com/pub/demos/hornet/html$"
main_mess0:
db "Using DOS32 V"
ver_major:
db "0."
ver_minor:
db "00 by Adam Seychell",13,10,"$"

starts_irq_set:
db     02,03,05,07,11,12,15

Start_r2sr:
;  call   debug
  cld
  mov    eax,0EE02h      ; get DOS32 address information
  int    31h
  neg    ebx
  mov    [Zero_Addr],ebx
  add    ebx,0A0000h
  mov    [_0A0000h],ebx
  add    ebx,0B8000h-0A0000h
  mov    [_0B8000h],ebx
  mov    [Environment_Address],edi
  mov    [PSP_Address],esi

  call   calc_data
  call   start_options

  mov    eax,0EE00h
  int    31h
  and    eax,0f0fh
  add    [byte ver_major],ah
  add    [byte ver_minor+1],al
  lea    edx,[main_mess0]
  mov    ah,9
  int    21h

  cmp    [byte demo_card_type],4
  je     @@dont_fnk_detect

  mov    eax,0EE41h                                     ;first things first,
  Int    31h                                            ;DMA memory. Always
  jc     @@mem_alloc_error                              ;alloc it first thing
  mov    [dma_buffer],edx

  mov    al,[demo_prec_type]
  call   FNK_set_sr

  mov    bl,0ffh
  mov    eax,0ffffh
  cmp    [byte demo_card_type],3
  je     @@dntconfcard
  mov    bl,[demo_card_type]
  movzx  eax,[byte demo_irq_type]
  mov    al,[byte eax+starts_irq_set]
  mov    ah,[demo_dma_type]
  inc    ah
@@dntconfcard:
  call   FNK_autodetect
  jc     @@card_not_found
@@dont_fnk_detect:

  mov    bl,11b
  cmp    [byte demo_vbe_type],0
  je     @@do_CheckVbeMode
  cmp    [byte demo_vbe_type],1
  jne    @@dont_so_pc
  xor    bl,01b
@@dont_so_pc:
  cmp    [byte demo_vbe_type],2
  jne    @@do_CheckVbeMode
  xor    bl,11b
@@do_CheckVbeMode:
  call   CheckVbeMode
  jc     @@init_error
  mov    edx,offset get_ready_mess
  mov    ah,9
  int    21h
  mov    cl,200
@@waitabit:         ;so the user can read the detected settings
  @WaitVertEnd
  @WaitVert
  dec    cl
  jnz    @@waitabit

  call   setvbemode

  call   set_IRQ00                                      ;setup screen syncr

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  cmp    [byte demo_card_type],4
  je     @@dont_fnk_init
  mov    eax,[dma_buffer]
  call   FNK_card_init

  mov    cl,100
@@waitabit2:
  @WaitVertEnd
  @WaitVert
  dec    cl
  jnz    @@waitabit2

  mov    eax,offset music
  call   FNK_setup_player
  call   FNK_PLAY
@@dont_fnk_init:

  call   logo_title
  cmp    [last_get_key],27
  je     @@end

  call   ani_title
  cmp    [last_get_key],27
  je     @@end

  call   first
  cmp    [last_get_key],27
  je     @@end

  call   t_traject_init                 ;init foreground scroller

  call   paint_mainbk
  cmp    [last_get_key],27
  je     @@end

  call   arcade_game
  cmp    [last_get_key],27
  je     @@end

  call   zoomend
  cmp    [last_get_key],27
  je     @@end

  call   break_away
  cmp    [last_get_key],27
  je     @@end

  call   do_3d_show
  cmp    [last_get_key],27
  je     @@end

  call   sr3_play
  cmp    [last_get_key],27
  je     @@end

  call   epseudos_zoom
  cmp    [last_get_key],27
  je     @@end

  cmp    [byte demo_card_type],4
  je     @@end
@@fade_music:
  mov    cl,10
@@wab2:
  @WaitVertEnd
  @WaitVert
  dec    cl
  jnz    @@wab2
  dec    [byte funk_info.master_volume]
  jnz    @@fade_music

@@end:
  cmp    [byte demo_card_type],4
  je     @@dont_fnk_deinit
  call   FNK_STOP
  call   FNK_card_deinit                                ;deinit player
@@dont_fnk_deinit:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  call   reset_IRQ00                                    ;desetup screen syncr
  mov    eax,0EE40h                                     ;dealloc DMA memory
  int    31h
@@exit:
  mov    eax,3
  int    10h
  mov    edx,offset end_mess
  mov    ah,9
  int    21h
  mov    edx,offset end_mess2
  mov    ah,9
  int    21h
  mov    edx,offset end_mess
@@message:
  mov    ah,9
  int    21h
  mov    eax,4c00h
  int    21h
@@init_error:
  mov    edx,offset no_vesa_mess
  jmp    @@message
@@mem_alloc_error:
  mov    edx,offset no_mem_mess
  jmp    @@message
@@card_not_found:
  mov    edx,offset no_card_mess
  jmp    @@message
ends

end Start_r2sr
