;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; zoom effect                                                             ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ideal
p386
model flat
stack 1024
codeseg

extrn debug           : near
Zero_Addr             dd ?
Environment_Address   dd ?
PSP_Address           dd ?
_0B8000h              dd ?
_0A0000h              dd ?

; data
include "..\sine.asm"
include "..\vesa_l2.asm"
include "..\r2sr_l.asm"

ISR_event             db ?
ISR_pc                dd ?

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; edx = filename                                                          ;
;                                                                         ;
; returns esi = data                                                      ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc load_f3dfile
  mov    eax,3d00h
  int    21h
  mov    ebx,eax
  mov    eax,4202h
  xor    edx,edx
  int    21h
  push   eax eax
  mov    eax,4200h
  xor    edx,edx
  int    21h
  pop    edx
  mov    eax,0EE42h          ; allocate a DOS32 memory block
  Int    31h                 ;  expects EDX = size; ret EAX=size, EDX->pointer
  mov    esi,edx
  mov    ah,3fh
  pop    ecx
  int    21h
  mov    ah,3eh
  int    21h
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; edx = filename                                                          ;
;                                                                         ;
; returns esi = VGA bitmap, eax = VGA palette                             ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc load_VGAbitmap
  mov    eax,3d00h
  int    21h
  mov    ebx,eax
  mov    eax,4202h
  xor    edx,edx
  int    21h
  push   eax eax
  mov    eax,4200h
  xor    edx,edx
  int    21h
  pop    edx
  mov    eax,0EE42h          ; allocate a DOS32 memory block
  Int    31h                 ;  expects EDX = size; ret EAX=size, EDX->pointer
  mov    esi,edx
  mov    ah,3fh
  pop    ecx
  int    21h
  push   eax
  mov    ah,3eh
  int    21h
  pop    eax
  sub    eax,768
  add    eax,esi
  ret
endp

FONT_SIZE             = 39299
font_pic              dd ?
font_pal:
  db  11, 14, 14, 20, 25, 25, 20, 25, 25, 21, 26, 26
  db  22, 27, 27, 23, 28, 28, 24, 28, 28, 25, 29, 29, 26, 30, 30, 27, 31, 31
  db  27, 32, 32, 28, 32, 32, 29, 33, 33, 30, 34, 34, 31, 35, 35, 32, 35, 35
  db  33, 36, 36, 33, 37, 37, 34, 38, 38, 35, 38, 38, 36, 39, 39, 37, 40, 40
  db  38, 41, 41, 39, 41, 41, 39, 42, 42, 40, 43, 43, 41, 44, 44, 42, 45, 45
  db  43, 45, 45, 44, 46, 46, 45, 47, 47, 46, 48, 48
font_pal_size =$-font_pal

font_fn               db "..\pb\srf.jlf",0

proc load_data2
  lea    edx,[font_fn]
  call   load_VGAbitmap
  mov    [font_pic],esi

  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

f004_filename         db "fract004.sr3",0
f004_no_facets        dd ?
f004_world_ptr        dd ?
f004_pal:
  db   0,  0,  0, 20, 12, 20, 19, 12, 19, 18, 12, 18, 21, 12, 21, 22, 12, 22
  db  23, 12, 23, 24, 12, 24, 25, 12, 25, 27, 12, 27, 31, 12, 31, 35, 12, 35
  db  26, 12, 26, 29, 12, 29, 33, 12, 33, 28, 12, 28, 17, 12, 17, 16, 12, 16
  db  34, 12, 34, 38, 12, 38, 36, 12, 36, 30, 12, 30, 37, 12, 37, 39, 12, 39
  db  39, 12, 40, 42, 12, 44, 38, 12, 39, 15, 12, 15, 14, 12, 14, 32, 12, 32
  db  32, 12, 33, 37, 12, 39, 40, 12, 41, 32, 12, 36, 34, 12, 38, 33, 12, 37
  db  35, 12, 39, 35, 12, 37, 33, 12, 35, 35, 12, 36, 34, 12, 35, 37, 12, 38
  db  36, 12, 37, 36, 12, 39, 35, 12, 38, 42, 12, 46, 41, 12, 45, 37, 12, 41
  db  40, 12, 44, 41, 12, 44, 41, 12, 41, 40, 12, 40
f004_pal_size         = $-f004_pal

f005_filename         db "fract005.sr3",0
f005_no_facets        dd ?
f005_world_ptr        dd ?
f005_pal:
  db   0,  0,  0, 39, 50, 15, 40, 51, 15, 42, 51, 16, 50, 54, 18, 55, 51, 14
  db  56, 48, 13, 56, 45, 12, 56, 39, 12, 56, 30, 12, 56, 20, 12, 54, 29, 14
  db  54, 33, 14, 49, 23, 12, 37, 18, 12, 23, 12, 24, 14, 12, 39, 14, 12, 41
  db  13, 12, 48, 15, 12, 30, 28, 12, 28, 39, 12, 14, 41, 36, 15, 33, 31, 16
  db  18, 36, 18, 12, 31, 20,  7, 26, 21,  2, 22, 22, 51, 40, 15, 53, 47, 16
  db  45, 26, 12, 41, 19, 12, 27, 12, 18, 16, 12, 23, 39, 14, 17, 43, 27, 17
  db  36, 45, 16, 13, 32, 20, 39, 16, 27, 41, 19, 27, 27, 15, 39, 24, 12, 15
  db  29, 16, 19, 29, 43, 17, 38, 34, 26, 42, 27, 25, 36, 12, 24, 28, 16, 28
  db  48, 13, 12, 44, 13, 12, 37, 29, 26, 29, 36, 27, 24, 25, 37, 22, 12, 35
  db  37, 23, 18, 26, 24, 28, 21, 24, 38, 13, 24, 49, 14, 20, 40, 27, 23, 38
  db  40, 44, 14, 13, 20, 48, 40, 14, 23, 42, 16, 23, 37, 39, 19, 13, 24, 45
  db  14, 24, 37, 56, 14, 12, 41, 35, 28, 42, 15, 24, 30, 41, 29, 34, 32, 14
  db  28, 20, 15, 16, 27, 18, 14, 16, 39, 14, 16, 31, 23, 12, 14, 28, 24, 17
  db  36, 48, 16, 32, 25, 15, 23, 25, 26, 42, 38, 16, 33, 47, 15, 29, 45, 15
  db  43, 40, 16, 12, 31, 56, 16, 24, 41, 19, 15, 41, 19, 16, 41, 17, 16, 31
  db  40, 40, 24, 20, 16, 38, 21, 21, 23, 26, 34, 23, 23, 40, 17
f005_pal_size         = $-f005_pal

f001_filename         db "fract001.sr3",0
f001_no_facets        dd ?
f001_world_ptr        dd ?
f001_pal:
  db   0,  0,  0, 12, 37, 56, 27, 44, 41, 41, 42, 27, 56, 40, 12, 56, 39, 12
  db  56, 28, 12, 56, 23, 12, 44, 18, 12, 44, 27, 12, 50, 31, 12, 29, 13, 14
  db  23, 12, 14, 25, 12, 18, 34, 18, 18, 41, 18, 18, 42, 12, 12, 48, 12, 12
  db  56, 48, 12, 34, 19, 12, 28, 12, 27, 33, 12, 39, 48, 18, 39, 54, 20, 24
  db  54, 18, 12, 45, 35, 12, 27, 39, 41, 37, 13, 19, 55, 32, 12, 48, 25, 18
  db  48, 35, 18, 43, 20, 27, 50, 29, 27, 56, 14, 12, 41, 35, 27, 36, 35, 27
  db  12, 44, 56, 12, 48, 56, 21, 12, 18, 37, 12, 12, 47, 22, 32, 37, 12, 27
  db  48, 23, 18, 51, 14, 21, 41, 29, 27, 35, 24, 27, 33, 33, 33, 36, 18, 33
  db  29, 12, 48, 27, 12, 33, 33, 12, 40, 41, 12, 29, 54, 33, 25, 53, 12, 54
  db  55, 14, 41, 56, 29, 27, 12, 29, 56, 16, 24, 56, 20, 21, 56, 23, 21, 48
  db  23, 12, 48, 19, 12, 56, 25, 12, 56, 33, 20, 55, 24, 14, 46, 56, 23, 26
  db  24, 17, 56, 29, 24, 41, 56, 33, 26, 39, 20, 27, 29, 21, 41, 28, 18, 27
  db  37, 27, 37, 39, 27, 41, 31, 16, 48, 27, 25, 56, 15, 16, 56, 14, 14, 56
  db  14, 14, 41, 24, 16, 39, 37, 12, 56, 30, 17, 14, 31, 23, 16, 42, 18, 41
  db  50, 14, 27, 41, 12, 56, 35, 12, 55, 41, 12, 55, 52, 18, 40, 34, 21, 56
  db  43, 12, 43, 48, 12, 56, 14, 12, 12, 23, 12, 35, 15, 27, 30, 23, 12, 29
  db  15, 12, 16, 46, 14, 17, 15, 12, 27
f001_pal_size         = $-f001_pal

sr_bar_1_fn           db "..\pb\sr_bar_1.vga",0
sr_bar_1_pic          dd ?

sr_bar_2_fn           db "..\pb\sr_bar_2.vga",0
sr_bar_2_pic          dd ?

sr_bar_3_fn           db "..\pb\sr_bar_3.vga",0
sr_bar_3_pic          dd ?

sr_bar_pal:
  db              25,  0,  0, 28,  0,  0, 30,  0,  0, 33,  0,  0, 35,  0,  0
  db  38,  0,  0, 40,  0,  0, 43,  0,  0, 46,  0,  0, 48,  0,  0, 51,  0,  0
  db  53,  0,  0, 20,  0, 18
sr_bar_pal_size       = $-sr_bar_pal

proc load_data
;data f3d data 1
  mov    edx,offset f004_filename
  call   load_f3dfile
  mov    eax,[esi]
  mov    [f004_no_facets],eax
  add    esi,4
  mov    [f004_world_ptr],esi

;data f3d data 5
  mov    edx,offset f005_filename
  call   load_f3dfile
  mov    eax,[esi]
  mov    [f005_no_facets],eax
  add    esi,4
  mov    [f005_world_ptr],esi

;data f3d data 1
  mov    edx,offset f001_filename
  call   load_f3dfile
  mov    eax,[esi]
  mov    [f001_no_facets],eax
  add    esi,4
  mov    [f001_world_ptr],esi

;load superreal
  lea    edx,[sr_bar_1_fn]
  call   load_VGAbitmap
  mov    [sr_bar_1_pic],esi

;load superrhip
  lea    edx,[sr_bar_2_fn]
  call   load_VGAbitmap
  mov    [sr_bar_2_pic],esi

;load supercool!
  lea    edx,[sr_bar_3_fn]
  call   load_VGAbitmap
  mov    [sr_bar_3_pic],esi
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
scroll_text:               ;*

db "2400 facets in 386 asm$"

db "listening to the rews",13
db "funky sounds..$"

db "and watching nunnys not",13
db "so hot bitmaps.$"

db "our greetings to$"

db "jase,hornet,turtle,30sc,",13
db "adam seychell,tom v.,",13
db "dickydick,sh0ck,party$"

db "primal,laserdance,jal",13
db "farang,vic,jenkins,mig",13
db "necros,big jim$"

db "and of course the oz96",13
db "organisers!$"

db "thanks for the stag piss",13
db "dickydick!$"

MAX_LETTERS           = 100

struc tletter
  letter              db ?
  x                   dd ?
  y                   dd ?
ends

SHIFT_LETTER          = 8
scroll_pack_buf       tletter MAX_LETTERS dup(<>)
scroll_ptr            dd 0
cletters              dd ?

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                      ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc t_traject_pack ;load next font string
  mov    [cletters],0
  mov    edi,offset scroll_pack_buf
  mov    esi,[scroll_ptr]
  xor    ecx,ecx   ;x pos
  xor    ebx,ebx   ;y pos
@@l:
  movzx  eax,[byte esi+scroll_text]
  mov    [edi+tletter.letter],al
  mov    [edi+tletter.x],ebx
  mov    [edi+tletter.y],ecx
  cmp    al,"$"
  je     @@endpack
  inc    esi
  push   edi
  mov    edi,[font_pic]
  call   get_FNT_size     ;edi = fontdata;ebx = character;returns = eax
  pop    edi
  add    ebx,eax
  add    ebx,2

  cmp    [byte esi+scroll_text-1]," "
  je     @@dont_adv
  add    edi,size tletter
  inc    [cletters]
@@dont_adv:
  cmp    [byte esi+scroll_text],13
  jne    @@l
;nextline
  mov    ebx,0
  add    ecx,60
  inc    esi
  jmp    @@l
@@endpack:
  inc    esi
  mov    [scroll_ptr],esi

  mov    ecx,[cletters]
  mov    edi,offset scroll_pack_buf
  xor    edx,edx
  xor    ebx,ebx
@@l2:
  mov    eax,[edi+tletter.x]
  cmp    eax,ebx
  jle    @@dux
  mov    ebx,eax
@@dux:
  mov    eax,[edi+tletter.y]
  cmp    eax,edx
  jle    @@duy
  mov    edx,eax
@@duy:
  add    edi,size tletter
  dec    ecx
  jnz    @@l2

  shr    ebx,1
  shr    edx,1
  mov    eax,(640/2)-20
  sub    eax,ebx
  mov    ecx,(480/2)-80
  sub    ecx,edx

  mov    edx,[cletters]
  mov    edi,offset scroll_pack_buf
@@l3:
  add    [edi+tletter.x],eax
  add    [edi+tletter.y],ecx
  add    edi,size tletter
  dec    edx
  jnz    @@l3

  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
end_credits_1a        = 1
end_credits_1b        = 2
end_credits_1c        = 3
end_credits_1d        = 4
end_credits_1e        = 5
end_credits_2load     = 6
end_credits_2a        = 7
end_credits_2b        = 8
end_credits_2c        = 9
end_credits_2d        = 10
end_credits_2e        = 11
end_credits_3load     = 12
end_credits_3a        = 13
end_credits_3b        = 14
end_credits_3c        = 15
end_credits_3d        = 16
end_credits_3e        = 17

end_credits_4load     = 18
end_credits_4         = 19
end_credits_4wait     = 20

end_credits_5load     = 21
end_credits_5         = 22
end_credits_5wait     = 23

end_credits_6load     = 24
end_credits_6         = 25
end_credits_6wait     = 26

end_credits_7load     = 27
end_credits_7         = 28
end_credits_7wait     = 29

end_credits_8load     = 30
end_credits_8         = 31

end_credits_DONE      = 32

end_credits_ISR_event db ?
end_credits_ISR_pc    dd ?

end_credits_x         dd ?
end_credits_y         dd ?
end_credits_y_inc     dd ?

proc end_credits_ISR
  cmp    [byte end_credits_ISR_event],end_credits_1a
  je     @@jend_credits_1a
  cmp    [byte end_credits_ISR_event],end_credits_1b
  je     @@jend_credits_1b
  cmp    [byte end_credits_ISR_event],end_credits_1c
  je     @@jend_credits_1c
  cmp    [byte end_credits_ISR_event],end_credits_1d
  je     @@jend_credits_1d
  cmp    [byte end_credits_ISR_event],end_credits_1e
  je     @@jend_credits_1e
  cmp    [byte end_credits_ISR_event],end_credits_2a
  je     @@jend_credits_2a
  cmp    [byte end_credits_ISR_event],end_credits_2b
  je     @@jend_credits_2b
  cmp    [byte end_credits_ISR_event],end_credits_2c
  je     @@jend_credits_1c
  cmp    [byte end_credits_ISR_event],end_credits_2d
  je     @@jend_credits_2d
  cmp    [byte end_credits_ISR_event],end_credits_2e
  je     @@jend_credits_2e
  cmp    [byte end_credits_ISR_event],end_credits_3a
  je     @@jend_credits_2a
  cmp    [byte end_credits_ISR_event],end_credits_3b
  je     @@jend_credits_2b
  cmp    [byte end_credits_ISR_event],end_credits_3c
  je     @@jend_credits_1c
  cmp    [byte end_credits_ISR_event],end_credits_3d
  je     @@jend_credits_2d
  cmp    [byte end_credits_ISR_event],end_credits_3e
  je     @@jend_credits_2e
  cmp    [byte end_credits_ISR_event],end_credits_4
  je     @@jend_credits_4
  cmp    [byte end_credits_ISR_event],end_credits_4wait
  je     @@jend_credits_4wait
  cmp    [byte end_credits_ISR_event],end_credits_5
  je     @@jend_credits_4
  cmp    [byte end_credits_ISR_event],end_credits_5wait
  je     @@jend_credits_4wait
  cmp    [byte end_credits_ISR_event],end_credits_6
  je     @@jend_credits_4
  cmp    [byte end_credits_ISR_event],end_credits_6wait
  je     @@jend_credits_4wait
  cmp    [byte end_credits_ISR_event],end_credits_7
  je     @@jend_credits_4
  cmp    [byte end_credits_ISR_event],end_credits_7wait
  je     @@jend_credits_4wait
  cmp    [byte end_credits_ISR_event],end_credits_8
  je     @@jend_credits_4
  ret
@@next_event:
  mov    [dword end_credits_ISR_pc],0
  inc    [byte end_credits_ISR_event]
  ret
@@jend_credits_1a:
  cmp    [dword end_credits_ISR_pc],600
  jae    @@next_event
  inc    [dword end_credits_ISR_pc]
  mov    eax,[end_credits_y_inc]
  sub    [end_credits_y],eax
  ret
@@jend_credits_1b:
  mov    eax,[end_credits_y_inc]
  sub    [end_credits_y],eax
  sub    [dword end_credits_y_inc],4
  jz     @@next_event
  ret
@@jend_credits_1c:
  cmp    [dword end_credits_ISR_pc],300
  jae    @@next_event
  inc    [dword end_credits_ISR_pc]
  ret
@@jend_credits_1d:
  mov    eax,[end_credits_y_inc]
  add    [end_credits_y],eax
  add    [dword end_credits_y_inc],4
  cmp    [dword end_credits_y_inc],1 shl 8
  je     @@next_event
  ret
@@jend_credits_1e:
  cmp    [dword end_credits_ISR_pc],300
  jae    @@next_event
  inc    [dword end_credits_ISR_pc]
  mov    eax,[end_credits_y_inc]
  add    [end_credits_y],eax
  ret
@@jend_credits_2a:
  cmp    [dword end_credits_ISR_pc],145
  jae    @@next_event
  inc    [dword end_credits_ISR_pc]
  mov    eax,[end_credits_y_inc]
  sub    [end_credits_x],eax
  ret
@@jend_credits_2b:
  mov    eax,[end_credits_y_inc]
  sub    [end_credits_x],eax
  sub    [dword end_credits_y_inc],8
  jz     @@next_event
  ret
@@jend_credits_2c:
  cmp    [dword end_credits_ISR_pc],400
  jae    @@next_event
  inc    [dword end_credits_ISR_pc]
  mov    eax,[end_credits_y_inc]
  sub    [end_credits_x],eax
  ret
@@jend_credits_2d:
  mov    eax,[end_credits_y_inc]
  sub    [end_credits_x],eax
  add    [dword end_credits_y_inc],8
  cmp    [dword end_credits_y_inc],3 shl 8
  je     @@next_event
  ret
@@jend_credits_2e:
  cmp    [dword end_credits_ISR_pc],230
  jae    @@next_event
  inc    [dword end_credits_ISR_pc]
  mov    eax,[end_credits_y_inc]
  sub    [end_credits_x],eax
  ret
@@jend_credits_4:
  cmp    [dword end_credits_ISR_pc],300
  jae    @@next_event
  inc    [dword end_credits_ISR_pc]
  ret
@@jend_credits_4wait:
  cmp    [dword end_credits_ISR_pc],50
  jae    @@next_event
  inc    [dword end_credits_ISR_pc]
  ret
endp

proc end_credits_init
  mov    [dword end_credits_x],0
  mov    [dword end_credits_y],700 shl 8
  mov    [dword end_credits_y_inc],1 shl 8

  call   t_traject_pack
  mov    [end_credits_ISR_event],end_credits_1a
  mov    [end_credits_ISR_pc],0
  ret
endp

proc end_credits
  cmp    [byte end_credits_ISR_event],end_credits_4wait
  je     @@end
  cmp    [byte end_credits_ISR_event],end_credits_5wait
  je     @@end
  cmp    [byte end_credits_ISR_event],end_credits_6wait
  je     @@end
  cmp    [byte end_credits_ISR_event],end_credits_7wait
  je     @@end

  cmp    [byte end_credits_ISR_event],end_credits_2load
  je     @@load2
  cmp    [byte end_credits_ISR_event],end_credits_3load
  je     @@load2
  cmp    [byte end_credits_ISR_event],end_credits_4load
  je     @@load4
  cmp    [byte end_credits_ISR_event],end_credits_5load
  je     @@load4
  cmp    [byte end_credits_ISR_event],end_credits_6load
  je     @@load4
  cmp    [byte end_credits_ISR_event],end_credits_7load
  je     @@load4
  cmp    [byte end_credits_ISR_event],end_credits_8load
  je     @@load4
  cmp    [byte end_credits_ISR_event],end_credits_DONE
  jne    @@display_scroll
@@end:
  ret
@@load2:
  call   t_traject_pack
  inc    [byte end_credits_ISR_event]

  mov    [dword end_credits_x],600 shl 8
  mov    [dword end_credits_y],50 shl 8
  mov    [dword end_credits_y_inc],3 shl 8
  ret
@@load4:
  call   t_traject_pack
  inc    [byte end_credits_ISR_event]
  mov    [dword end_credits_x],0
  mov    [dword end_credits_y],50 shl 8
  ret
@@display_scroll:
  mov    esi,offset scroll_pack_buf
  mov    ebx,[dword end_credits_x]
  mov    ecx,[dword end_credits_y]
  sar    ebx,8
  sar    ecx,8
@@l:
  push   esi ebx ecx
  mov    al,[esi+tletter.letter]
  cmp    al,"$"
  je     @@done_ps
  and    eax,0ffh
  push   eax
  push   [font_pic]
  push   [Rendbuff]
  mov    eax,[esi+tletter.x]
  add    eax,ebx
  push   eax
  mov    eax,[esi+tletter.y]
  add    eax,ecx
  push   eax
  push   640
  call   draw_FNT
  add    esp,(size draw_FNT_stack)-4

  pop    ecx ebx esi
  add    esi,size tletter
  jmp    @@l
  ret
@@done_ps:
  pop    ecx ebx esi
  ret
endp

;TEST_1                = 1
;TEST_DONE             = 2
;
;proc test_i_ISR
;  call   end_credits_ISR
;  ret
;endp
;
;proc test_i
;  mov    al,256-32
;  mov    ecx,font_pal_size
;  mov    esi,offset font_pal
;  @WritePalette
;
;  call   end_credits_init
;
;  mov    [ISR_event],TEST_1
;  mov    [ISR_pc],0
;  mov    eax,offset test_i_ISR
;  mov    [fg_calc],eax
;@@paint:
;  mov    edi,[Rendbuff]
;  add    edi,100*640
;  mov    ecx,(640*380)/4
;  xor    eax,eax
;  rep    stosd
;
;  call   end_credits
;
;  call   [sync_screen]
;  cmp    [byte ISR_event],TEST_DONE
;  je     @@end
;  call   key_pressed2
;  jnc    @@paint
;  call   get_key
;  cmp    al,27
;  je     @@end
;  jmp    @@paint
;@@end:
;  ret
;endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; Triangle blitter                                                         ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
fpoly3_SCRW           = 640
fpoly3_t_clip         dd 100
fpoly3_b_clip         dd 480
fpoly3_l_clip         dd 0
fpoly3_r_clip         dd 640

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
fpoly3_xl_hi          dd ?
fpoly3_xr_hi          dd ?
fpoly3_l_incr         dd ?
fpoly3_r_incr         dd ?
;ebx = ;fpoly3_yt             dd ?
;ecx = ;fpoly3_yb             dd ?

proc fpoly3_trape
  mov    eax,[fpoly3_b_clip]
  cmp    eax,ebx ;[fpoly3_yt]
  jg     @@dcb
  ret
@@dcb:

  mov    eax,[fpoly3_b_clip]
  cmp    eax,ecx ;[fpoly3_yb]
  jg     @@dcb2
  mov    ecx,eax   ;[fpoly3_yb],eax
@@dcb2:

  mov    eax,ecx  ;[fpoly3_yb]
  cmp    eax,[fpoly3_t_clip]
  jg     @@dct
  sub    eax,ebx ;[fpoly3_yt]
  push   eax
  imul   [fpoly3_l_incr]
  add    [fpoly3_xl_hi],eax
  pop    eax
  imul   [fpoly3_r_incr]
  add    [fpoly3_xr_hi],eax
  ret
@@dct:

  mov    eax,ebx ;[fpoly3_yt]
  sub    eax,[fpoly3_t_clip]
  jns    @@dct2
  neg    eax
  add    ebx,eax   ;[fpoly3_yt],eax
  push   eax
  imul   [fpoly3_l_incr]
  add    [fpoly3_xl_hi],eax
  pop    eax
  imul   [fpoly3_r_incr]
  add    [fpoly3_xr_hi],eax
  mov    eax,[fpoly3_t_clip]
  jmp    @@done_dct2
@@dct2:
  add    eax,[fpoly3_t_clip]
@@done_dct2:
;edi = vline
  mov    edx,fpoly3_SCRW
  mul    edx
  mov    edi,eax
  add    edi,[dword Rendbuff]

;ebx >> 16 = edx, ecx << 16 = esi
  mov    eax,ecx  ;[fpoly3_yb]
  sub    eax,ebx  ;[fpoly3_yt]

  mov    edx,[fpoly3_xl_hi]
  mov    esi,[fpoly3_xr_hi]
  mov    ebx,edx
  sar    ebx,16
  mov    ecx,esi
  sar    ecx,16
@@nextline:
  push   eax edi

  cmp    ecx,[fpoly3_l_clip]
  jl     @@doneline
  cmp    ebx,[fpoly3_r_clip]
  jge    @@doneline
  cmp    ecx,[fpoly3_r_clip]
  jle    @@dont_clip_right
  mov    ecx,[fpoly3_r_clip]
@@dont_clip_right:
  cmp    ebx,[fpoly3_l_clip]
  jge    @@dont_clip_left
  mov    ebx,[fpoly3_l_clip]
@@dont_clip_left:

  add    edi,ebx
  sub    ecx,ebx
  jz     @@1pixel
  js     @@doneline

  mov    al,[byte ebp+fpoly3_stack.colour]

  push   ecx
  shr    ecx,2
  jz     @@ignore_32

  mov    ah,al
  shl    eax,16
  mov    al,[byte ebp+fpoly3_stack.colour]
  mov    ah,al

@@paint_x32:
  mov    [edi],eax
  add    edi,4
  dec    ecx
  jnz    @@paint_x32
@@ignore_32:
  pop    ecx                                      ; bytes to write left
  and    cl,3
  jz     @@doneline
@@paint_x8:
  mov    [edi],al
  inc    edi
  dec    cl
  jnz    @@paint_x8
@@doneline:
  pop    edi eax
  add    edi,fpoly3_SCRW
  add    edx,[fpoly3_l_incr]
  add    esi,[fpoly3_r_incr]
  mov    ebx,edx
  sar    ebx,16
  mov    ecx,esi
  sar    ecx,16
  dec    eax
  jg     @@nextline
  mov    [fpoly3_xl_hi],edx
  mov    [fpoly3_xr_hi],esi
  ret
@@1pixel:
  mov    al,[byte ebp+fpoly3_stack.colour]
  mov    [edi],al
  jmp    @@doneline
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
struc fpoly3_stack
  caller              dd ?
  colour              dd ?
  y3                  dd ?
  x3                  dd ?
  y2                  dd ?
  x2                  dd ?
  y1                  dd ?
  x1                  dd ?
ends

;(x2-x1)/(y2-y1)
;
; eax = x2
; ebx = x1
; ecx = y2
; edx = y1
macro @fpoly3_XYs
local @@roundpl
  sub    eax,ebx
  jz     @@roundpl
  sub    ecx,edx
  cdq
  shld   eax,edx,16
  idiv   ecx
@@roundpl:
endm

proc fpoly3
  mov    ebp,esp

;  i = poly_l_clip;
;  if(!( P1.x>=i || P2.x>=i || P3.x>=i )) return;
  mov    eax,[fpoly3_l_clip]
  cmp    eax,[ebp+fpoly3_stack.x1]
  jle    @@hlc_pass
  cmp    eax,[ebp+fpoly3_stack.x2]
  jle    @@hlc_pass
  cmp    eax,[ebp+fpoly3_stack.x3]
  jg     @@end
@@hlc_pass:

;  i = poly_r_clip;
;  if(!( P1.x<=i || P2.x<=i || P3.x<=i )) return;
  mov    eax,[fpoly3_r_clip]
  cmp    eax,[ebp+fpoly3_stack.x1]
  jg     @@hrc_pass
  cmp    eax,[ebp+fpoly3_stack.x2]
  jg     @@hrc_pass
  cmp    eax,[ebp+fpoly3_stack.x3]
  jle    @@end
@@hrc_pass:

;  i = poly_b_clip;
;  if(!( P1.y<=i || P2.y<=i || P3.y<=i )) return;
  mov    eax,[fpoly3_b_clip]
  cmp    eax,[ebp+fpoly3_stack.y1]
  jg     @@hbc_pass
  cmp    eax,[ebp+fpoly3_stack.y2]
  jg     @@hbc_pass
  cmp    eax,[ebp+fpoly3_stack.y3]
  jle    @@end
@@hbc_pass:

;  i = poly_t_clip;
;  if(!( P1.y>=i || P2.y>=i || P3.y>=i )) return;
  mov    eax,[fpoly3_t_clip]
  cmp    eax,[ebp+fpoly3_stack.y1]
  jle    @@htc_pass
  cmp    eax,[ebp+fpoly3_stack.y2]
  jle    @@htc_pass
  cmp    eax,[ebp+fpoly3_stack.y3]
  jg     @@end
@@htc_pass:

;  if(P2.y<P1.y) /* sort by vert pos'n */
;  {
;    temp_v = P1;
;    P1 = P2;
;    P2 = temp_v;
;  }
  mov    ebx,[ebp+fpoly3_stack.y1]
  cmp    ebx,[ebp+fpoly3_stack.y2]
  jle    @@dswap12

  mov    eax,[ebp+fpoly3_stack.x1]
  xchg   eax,[ebp+fpoly3_stack.x2]
  mov    [ebp+fpoly3_stack.x1],eax

  mov    eax,[ebp+fpoly3_stack.y1]
  xchg   eax,[ebp+fpoly3_stack.y2]
  mov    [ebp+fpoly3_stack.y1],eax
@@dswap12:

;  if(P3.y<P1.y)
;  {
;    temp_v = P1;
;    P1 = P3;
;    P3 = temp_v;
;  }
  mov    ebx,[ebp+fpoly3_stack.y1]
  cmp    ebx,[ebp+fpoly3_stack.y3]
  jle    @@dswap31

  mov    eax,[ebp+fpoly3_stack.x1]
  xchg   eax,[ebp+fpoly3_stack.x3]
  mov    [ebp+fpoly3_stack.x1],eax

  mov    eax,[ebp+fpoly3_stack.y1]
  xchg   eax,[ebp+fpoly3_stack.y3]
  mov    [ebp+fpoly3_stack.y1],eax
@@dswap31:

;  if(P3.y<P2.y)
;  {
;    temp_v = P2;
;    P2 = P3;
;    P3 = temp_v;
;  }
  mov    ebx,[ebp+fpoly3_stack.y2]
  cmp    ebx,[ebp+fpoly3_stack.y3]
  jle    @@dswap32

  mov    eax,[ebp+fpoly3_stack.x2]
  xchg   eax,[ebp+fpoly3_stack.x3]
  mov    [ebp+fpoly3_stack.x2],eax

  mov    eax,[ebp+fpoly3_stack.y2]
  xchg   eax,[ebp+fpoly3_stack.y3]
  mov    [ebp+fpoly3_stack.y2],eax
@@dswap32:

;  if(P3.y<poly_t_clip
  mov    eax,[ebp+fpoly3_stack.y3]
  cmp    eax,[fpoly3_t_clip]
  jl     @@end

;                     || P1.y>poly_b_clip) return; /* all above or below clip area */
  mov    eax,[ebp+fpoly3_stack.y1]
  cmp    eax,[fpoly3_b_clip]
  jg     @@end

;  if(P1.y==P2.y&&P2.y==P3.y) return;
;  if(P1.y==P2.y) /* case = 2 (flat top) */
;  {
  mov    eax,[ebp+fpoly3_stack.y2]
  cmp    eax,[ebp+fpoly3_stack.y1]
  jne    @@not_flat_top
  cmp    eax,[ebp+fpoly3_stack.y3]
  je     @@end
;--flat_top -------------------------------------------------------
;    if(P2.x<P1.x)
;    {
;      temp_v = P1;
;      P1 = P2;
;      P2 = temp_v;
;    }
  mov    ebx,[ebp+fpoly3_stack.x1]
  cmp    ebx,[ebp+fpoly3_stack.x2]
  jle    @@ft_dswap32

  mov    eax,[ebp+fpoly3_stack.x1]
  xchg   eax,[ebp+fpoly3_stack.x2]
  mov    [ebp+fpoly3_stack.x1],eax

  mov    eax,[ebp+fpoly3_stack.y1]
  xchg   eax,[ebp+fpoly3_stack.y2]
  mov    [ebp+fpoly3_stack.y1],eax
@@ft_dswap32:

;    s13 = compute_XYslope(P1,P3);
  mov    eax,[ebp+fpoly3_stack.x3]
  mov    ebx,[ebp+fpoly3_stack.x1]
  mov    ecx,[ebp+fpoly3_stack.y3]
  mov    edx,[ebp+fpoly3_stack.y1]
  @fpoly3_XYs
  mov    [fpoly3_l_incr],eax

;    s23 = compute_XYslope(P2,P3);
  mov    eax,[ebp+fpoly3_stack.x3]
  mov    ebx,[ebp+fpoly3_stack.x2]
  mov    ecx,[ebp+fpoly3_stack.y3]
  mov    edx,[ebp+fpoly3_stack.y2]
  @fpoly3_XYs
  mov    [fpoly3_r_incr],eax

;    GZ_trapezoid(P1.x,P2.x,s13,s23,
;                 P1.y,P3.y,
;                 HOLD_OFF);
  mov    eax,[ebp+fpoly3_stack.x1]
  sal    eax,16
  mov    [fpoly3_xl_hi],eax
  mov    eax,[ebp+fpoly3_stack.x2]
  sal    eax,16
  mov    [fpoly3_xr_hi],eax
  mov    ebx,[ebp+fpoly3_stack.y1]
  mov    ecx,[ebp+fpoly3_stack.y3]
  call   fpoly3_trape

  jmp    @@end
;--flat_bottom-----------------------------------------------------
;  else if(P2.y==P3.y) /* case = 1 (flat bottom)*/
;  {
@@not_flat_top:
  cmp    eax,[ebp+fpoly3_stack.y3]
  jne    @@not_flat_bottom

;    if(P3.x<P2.x)
;    {
;      temp_v = P2;
;      P2 = P3;
;      P3 = temp_v;
;    }
  mov    ebx,[ebp+fpoly3_stack.x2]
  cmp    ebx,[ebp+fpoly3_stack.x3]
  jle    @@fb_dswap32

  mov    eax,[ebp+fpoly3_stack.x2]
  xchg   eax,[ebp+fpoly3_stack.x3]
  mov    [ebp+fpoly3_stack.x2],eax

  mov    eax,[ebp+fpoly3_stack.y2]
  xchg   eax,[ebp+fpoly3_stack.y3]
  mov    [ebp+fpoly3_stack.y2],eax
@@fb_dswap32:

;    s12 = compute_XYslope(P1,P2);
  mov    eax,[ebp+fpoly3_stack.x2]
  mov    ebx,[ebp+fpoly3_stack.x1]
  mov    ecx,[ebp+fpoly3_stack.y2]
  mov    edx,[ebp+fpoly3_stack.y1]
  @fpoly3_XYs
  mov    [fpoly3_l_incr],eax

;    s13 = compute_XYslope(P1,P3);
  mov    eax,[ebp+fpoly3_stack.x3]
  mov    ebx,[ebp+fpoly3_stack.x1]
  mov    ecx,[ebp+fpoly3_stack.y2]
  mov    edx,[ebp+fpoly3_stack.y1]
  @fpoly3_XYs
  mov    [fpoly3_r_incr],eax

;    GZ_trapezoid(P1.x,P1.x,s12,s13,
;                 P1.y,P3.y,
;                 HOLD_OFF);
  mov    eax,[ebp+fpoly3_stack.x1]
  sal    eax,16
  mov    [fpoly3_xl_hi],eax
  mov    [fpoly3_xr_hi],eax
  mov    ebx,[ebp+fpoly3_stack.y1]
  mov    ecx,[ebp+fpoly3_stack.y3]
  call   fpoly3_trape

  jmp    @@end
;--free angle------------------------------------------------------
@@not_flat_bottom:
;    s13 = compute_XYslope(P1,P3);
  mov    eax,[ebp+fpoly3_stack.x3]
  mov    ebx,[ebp+fpoly3_stack.x1]
  mov    ecx,[ebp+fpoly3_stack.y3]
  mov    edx,[ebp+fpoly3_stack.y1]
  @fpoly3_XYs
  mov    [@@s13],eax

;    s23 = compute_XYslope(P2,P3);
  mov    eax,[ebp+fpoly3_stack.x3]
  mov    ebx,[ebp+fpoly3_stack.x2]
  mov    ecx,[ebp+fpoly3_stack.y3]
  mov    edx,[ebp+fpoly3_stack.y2]
  @fpoly3_XYs
  mov    [@@s23],eax

;    s12 = compute_XYslope(P1,P2);
  mov    eax,[ebp+fpoly3_stack.x2]
  mov    ebx,[ebp+fpoly3_stack.x1]
  mov    ecx,[ebp+fpoly3_stack.y2]
  mov    edx,[ebp+fpoly3_stack.y1]
  @fpoly3_XYs
  mov    [@@s12],eax

;    if(s12 > s13) /* case = 4 (3rd point on right) */
;    {
  cmp    eax,[@@s13]
  jle    @@3pol

;      GZ_trapezoid(P1.x,P1.x,s13,s12,
;                   P1.y,P2.y,
;                   HOLD_OFF);
  mov    eax,[ebp+fpoly3_stack.x1]
  sal    eax,16
  mov    [fpoly3_xl_hi],eax
  mov    [fpoly3_xr_hi],eax
  mov    eax,[@@s13]
  mov    [fpoly3_l_incr],eax
  mov    eax,[@@s12]
  mov    [fpoly3_r_incr],eax
  mov    ebx,[ebp+fpoly3_stack.y1]
  mov    ecx,[ebp+fpoly3_stack.y2]
  call   fpoly3_trape

;      GZ_trapezoid(  -1,P2.x,s13,s23,
;                   P2.y,P3.y,
;                   HOLD_LEFT);
  mov    eax,[ebp+fpoly3_stack.x2]
  sal    eax,16
  mov    [fpoly3_xr_hi],eax
  mov    eax,[@@s23]
  mov    [fpoly3_r_incr],eax
  mov    ebx,[ebp+fpoly3_stack.y2]
  mov    ecx,[ebp+fpoly3_stack.y3]
  call   fpoly3_trape

  jmp    @@end
@@3pol:
;      GZ_trapezoid(P1.x,P1.x,s12,s13,
;                   P1.y,P2.y,
;                   HOLD_OFF);
  mov    eax,[ebp+fpoly3_stack.x1]
  sal    eax,16
  mov    [fpoly3_xl_hi],eax
  mov    [fpoly3_xr_hi],eax
  mov    eax,[@@s12]
  mov    [fpoly3_l_incr],eax
  mov    eax,[@@s13]
  mov    [fpoly3_r_incr],eax
  mov    ebx,[ebp+fpoly3_stack.y1]
  mov    ecx,[ebp+fpoly3_stack.y2]
  call   fpoly3_trape


;      GZ_trapezoid(P2.x,  -1,s23,s13,
;                   P2.y,P3.y,
;                   HOLD_RIGHT);
  mov    eax,[ebp+fpoly3_stack.x2]
  sal    eax,16
  mov    [fpoly3_xl_hi],eax
  mov    eax,[@@s23]
  mov    [fpoly3_l_incr],eax
  mov    ebx,[ebp+fpoly3_stack.y2]
  mov    ecx,[ebp+fpoly3_stack.y3]
  call   fpoly3_trape

@@end:
  ret
@@s12                 dd ?
@@s13                 dd ?
@@s23                 dd ?
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; coordinate mapper                                                        ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
struc tf3d_point
  x                   dd ?
  y                   dd ?
  z                   dd ?
ends

struc tf3d_p_point
  x                   dd ?
  y                   dd ?
ends

struc tf3d_facet
  colour              db ?
  p1                  tf3d_point <>
  p2                  tf3d_point <>
  p3                  tf3d_point <>
ends

struc tf3d_projd
  colour              db ?
  p1                  tf3d_p_point <>
  p2                  tf3d_p_point <>
  p3                  tf3d_p_point <>
ends

struc tf3d_qsort
  index               dd ?
  Yorder              dd ?
ends

f3d_xangle            dd 0
f3d_yangle            dd 0
f3d_zangle            dd 1024+170

f3d_focus_x           dd 0
f3d_focus_y           dd 0
f3d_focus_z           dd 0

f3d_Distance          dd 800
f3d_postx             dd 640/2
f3d_posty             dd 480/2

f3d_no_facets         dd ?
f3d_qsort_count       dd ?
f3d_world_ptr         dd ?
f3d_projd_ptr         dd ?
f3d_qsort_ptr         dd ?

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc f3d_init
  mov    ecx,[f3d_no_facets]

  mov    eax,size tf3d_projd
  mul    ecx
  mov    edx,eax
  mov    AX,0EE42h
  int    31h
  mov    [f3d_projd_ptr],edx

  mov    eax,size tf3d_qsort
  mul    ecx
  mov    edx,eax
  mov    AX,0EE42h
  int    31h
  mov    [f3d_qsort_ptr],edx
  ret
endp

proc f3d_deinit
  mov    eax,0EE40h
  int    31h
  mov    eax,0EE40h
  int    31h
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;  in:   EBX= X ECX= Y EBP= Z                                              ;
; out:   EBX= X ECX= Y EBP= Z                                              ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc f3d_rotate
; EBX = EBX * cos(f3d_xangle) - ECX * sin(f3d_xangle)
; ECX = EBX * sin(f3d_xangle) + ECX * cos(f3d_xangle)
  mov    eax,[f3d_xangle]
  @find_cosine
  imul   ebx
  shrd   eax,edx,9
  mov    edi,eax
  mov    eax,[f3d_xangle]
  @find_sine
  imul   ecx
  shrd   eax,edx,9
  sub    edi,eax

  mov    eax,[f3d_xangle]
  @find_sine
  imul   ebx
  shrd   eax,edx,9
  mov    esi,eax
  mov    eax,[f3d_xangle]
  @find_cosine
  imul   ecx
  shrd   eax,edx,9
  add    esi,eax

  mov    ebx,edi
  mov    ecx,esi

; EBX = EBX * cos(f3d_yangle) - EBP * sin(f3d_yangle)
; EBP = EBX * sin(f3d_yangle) + EBP * cos(f3d_yangle)
  mov    eax,[f3d_yangle]
  @find_cosine
  imul   ebx
  shrd   eax,edx,9
  mov    edi,eax
  mov    eax,[f3d_yangle]
  @find_sine
  imul   ebp
  shrd   eax,edx,9
  sub    edi,eax

  mov    eax,[f3d_yangle]
  @find_sine
  imul   ebx
  shrd   eax,edx,9
  mov    esi,eax
  mov    eax,[f3d_yangle]
  @find_cosine
  imul   ebp
  shrd   eax,edx,9
  add    esi,eax

  mov    ebx,edi
  mov    ebp,esi

; EBP = EBP * cos(f3d_zangle) - ECX * sin(f3d_zangle)
; ECX = EBP * sin(f3d_zangle) + ECX * cos(f3d_zangle)
  mov    eax,[f3d_zangle]
  @find_cosine
  imul   ebp
  shrd   eax,edx,9
  mov    edi,eax
  mov    eax,[f3d_zangle]
  @find_sine
  imul   ecx
  shrd   eax,edx,9
  sub    edi,eax

  mov    eax,[f3d_zangle]
  @find_sine
  imul   ebp
  shrd   eax,edx,9
  mov    esi,eax
  mov    eax,[f3d_zangle]
  @find_cosine
  imul   ecx
  shrd   eax,edx,9
  add    esi,eax

  mov    ebp,edi
  mov    ecx,esi

  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                           ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
struc f3d_qsort_stack
  bp_r                dd ?
  caller              dd ?
  r                   dd ?
  l                   dd ?
ends

; eax = i
; edx = j
; ecx = x
; esi = sort list
proc f3d_qsort
  push   ebp
  mov    ebp,esp
  push   eax edx
  mov    eax,[ebp+f3d_qsort_stack.l]
  mov    edx,[ebp+f3d_qsort_stack.r]
  mov    ebx,eax
  add    ebx,edx
  shr    ebx,1
  mov    ecx,[esi+ebx*8+tf3d_qsort.Yorder]
@@repeat_loop1:
  cmp    [dword esi+eax*8+tf3d_qsort.Yorder],ecx
  jle    @@find_list_j_loop
  inc    eax
  jmp    @@repeat_loop1
@@find_list_j_loop:
  cmp    ecx,[dword esi+edx*8+tf3d_qsort.Yorder]
  jle    @@fin_retract
  dec    edx
  jmp    @@find_list_j_loop
@@fin_retract:
  cmp    eax,edx
  jg     @@done_sect_sort
  je     @@skip
  mov    edi,[dword esi+eax*8+tf3d_qsort.index]
  mov    ebx,[esi+eax*8+tf3d_qsort.Yorder]
  xchg   edi,[dword esi+edx*8+tf3d_qsort.index]
  xchg   ebx,[esi+edx*8+tf3d_qsort.Yorder]
  mov    [dword esi+eax*8+tf3d_qsort.index],edi
  mov    [esi+eax*8+tf3d_qsort.Yorder],ebx
@@skip:
  inc    eax
  dec    edx
@@done_sect_sort:
  cmp    eax,edx
  jle    @@repeat_loop1
  cmp    [dword ebp+f3d_qsort_stack.l],edx
  jge    @@nt1
  push   [dword ebp+f3d_qsort_stack.l]
  push   edx
  call   f3d_qsort
  add    esp,size f3d_qsort_stack-8
@@nt1:
  cmp    eax,[dword ebp+f3d_qsort_stack.r]
  jge    @@nt2
  push   eax
  push   [dword ebp+f3d_qsort_stack.r]
  call   f3d_qsort
  add    esp,size f3d_qsort_stack-8
@@nt2:
  pop    edx eax ebp
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc f3d_project_world
  mov    ecx,[f3d_no_facets]
  mov    edi,[f3d_world_ptr]
  mov    esi,[f3d_projd_ptr]
  mov    ebx,[f3d_qsort_ptr]
@@project_l:
  push   ecx edi esi ebx

  mov    al,[edi+tf3d_facet.colour]
  mov    [esi+tf3d_projd.colour],al

  mov    [dword @@y_mean],0
  mov    cl,3
@@calc_3:
  push   ecx
  mov    ebx,[edi+tf3d_facet.p1.x]
  mov    ecx,[edi+tf3d_facet.p1.y]
  mov    ebp,[edi+tf3d_facet.p1.z]
  add    ebx,[f3d_focus_x]
  add    ecx,[f3d_focus_y]
  add    ebp,[f3d_focus_z]

  push   esi edi
  call   f3d_rotate
  pop    edi esi
  add    ecx,[f3d_Distance]

  cmp    ecx,0
  jle    @@zeroy

  mov    eax,ebx
  cdq
  shld   edx,eax,8
  sal    eax,8
  idiv   ecx
  add    eax,[f3d_postx]
  mov    [esi+tf3d_projd.p1.x],eax

  mov    eax,ebp
  cdq
  shld   edx,eax,8
  sal    eax,8
  idiv   ecx
  add    eax,[f3d_posty]
  mov    [esi+tf3d_projd.p1.y],eax
  jmp    @@fprojxy
@@zeroy:
  pop    ecx
  pop    ebx esi edi ecx
  jmp    @@zclip_facet
@@fprojxy:
  add    edi,size tf3d_point
  add    esi,size tf3d_p_point

  add    [@@y_mean],ecx

  pop    ecx
  dec    cl
  jnz    @@calc_3

  pop    ebx esi edi ecx

  mov    eax,[@@y_mean]
  mov    [ebx+tf3d_qsort.index],esi
  mov    [ebx+tf3d_qsort.Yorder],eax
  add    ebx,size tf3d_qsort
@@zclip_facet:
  add    edi,size tf3d_facet
  add    esi,size tf3d_projd

  dec    ecx
  jnz    @@project_l

  sub    ebx,[f3d_qsort_ptr]
  shr    ebx,3
  mov    [f3d_qsort_count],ebx
  cmp    ebx,1
  jbe    @@skip

  mov    esi,[f3d_qsort_ptr]
  push   0
  dec    ebx
  push   ebx
  call   f3d_qsort
  add    esp,(size f3d_qsort_stack)-8
@@skip:
  ret
@@y_mean              dd ?
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc f3d_draw_world
  cmp    [dword f3d_qsort_count],0
  je     @@skip
  mov    ecx,[f3d_qsort_count]
  mov    ebx,[f3d_qsort_ptr]
@@draw_l:
  push   ecx ebx
  mov    eax,[ebx+tf3d_qsort.index]
  push   [eax+tf3d_projd.p1.x]
  push   [eax+tf3d_projd.p1.y]
  push   [eax+tf3d_projd.p2.x]
  push   [eax+tf3d_projd.p2.y]
  push   [eax+tf3d_projd.p3.x]
  push   [eax+tf3d_projd.p3.y]
  push   [dword eax+tf3d_projd.colour]
  call   fpoly3
  add    esp,(size fpoly3_stack)-4

  pop    ebx ecx

  add    ebx,size tf3d_qsort
  dec    ecx
  jnz    @@draw_l
@@skip:
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
sr_bar_src            dd ?
sr_bar_tar            dd ?
sr_bar_xl             dd ?
sr_bar_yl             dd ?
sr_bar_xl_inc         dd ?


sr_bar_src2           dd ?
sr_bar_tar2           dd ?

proc paint_sr_bloc
  mov    dl,10
@@sr_bar_lxl:
  mov    eax,[esi]
  mov    [edi],eax
  mov    eax,[esi+4]
  mov    [edi+4],eax
  mov    ax,[esi+8]
  mov    [edi+8],ax
  mov    al,[esi+10]
  mov    [edi+10],al
  add    esi,638
  add    edi,640
  dec    dl
  jnz    @@sr_bar_lxl
  ret
endp

proc paint_sr_bar
  mov    esi,[sr_bar_src]
  mov    edi,[sr_bar_tar]
  call   paint_sr_bloc

  mov    esi,[sr_bar_src2]
  mov    edi,[sr_bar_tar2]
  call   paint_sr_bloc

  dec    [dword sr_bar_xl]
  jz     @@loop_x

  mov    eax,[sr_bar_xl_inc]
  add    [sr_bar_src],eax
  add    [sr_bar_tar],eax

  sub    [sr_bar_src2],eax
  sub    [sr_bar_tar2],eax

  ret
@@loop_x:
  mov    [dword sr_bar_xl],58
  add    [dword sr_bar_src],638*10
  add    [dword sr_bar_tar],640*10

  sub    [dword sr_bar_src2],638*10
  sub    [dword sr_bar_tar2],640*10

  neg    [dword sr_bar_xl_inc]
  dec    [dword sr_bar_yl]
  ret
endp

proc paint_sr_bloc_init
  add    eax,4
  mov    [sr_bar_src],eax
  add    eax,(638*99)-(11+(638*10))
  mov    [sr_bar_src2],eax

  mov    eax,[rendbuff]
  inc    eax
  mov    [sr_bar_tar],eax
  add    eax,(640*99)-(13+(640*10))
  mov    [sr_bar_tar2],eax

  mov    [dword sr_bar_xl],58
  mov    [dword sr_bar_yl],5
  mov    [dword sr_bar_xl_inc],11

  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
F3D_1_ANI1            = 1
F3D_1_ANI2            = 2
F3D_1_ANI4            = 3
F3D_1_ANI5            = 4
F3D_1_DONE            = 5

f3d1_xangle_inc       dd 800h
f3d1_xangle           dd 0
f3d1_zangle           dd 0
f3d1_focus_z          dd 0
f3d1_distance         dd 60000
f3d1_posty            dd 480/2

proc f3d_1_ISR
  call   end_credits_ISR

  cmp    [byte ISR_event],F3D_1_ANI1
  je     @@jF3D_1_ANI1
  cmp    [byte ISR_event],F3D_1_ANI2
  je     @@jF3D_1_ANI2
  cmp    [byte ISR_event],F3D_1_ANI4
  je     @@jF3D_1_ANI4
  cmp    [byte ISR_event],F3D_1_ANI5
  je     @@jF3D_1_ANI5
  ret
@@next_event:
  mov    [dword ISR_pc],0
  inc    [byte ISR_event]
  ret
@@jF3D_1_ANI1:
  cmp    [dword ISR_pc],400
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [dword f3d1_xangle],600h
  mov    eax,[f3d1_distance]
  sar    eax,6
  sub    [f3d1_distance],eax
  ret
@@jF3D_1_ANI2:
  cmp    [dword ISR_pc],500
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [dword f3d1_xangle],600h
  ret
@@jF3D_1_ANI4:
  cmp    [dword ISR_pc],150
  jae    @@next_event
  inc    [dword ISR_pc]
  mov    eax,[f3d1_xangle_inc]
  add    [dword f3d1_xangle],eax
  sub    [dword f3d1_xangle_inc],20h
  ret
@@jF3D_1_ANI5:
  cmp    [dword ISR_pc],460
  jae    @@next_event
  inc    [dword ISR_pc]
  mov    eax,[f3d1_xangle_inc]
  add    [dword f3d1_xangle],eax
  mov    eax,[f3d1_distance]
  sar    eax,6
  add    [f3d1_distance],eax
  inc    [dword f3d1_distance]
  ret
endp

proc f3d_1
  mov    eax,[f004_no_facets]
  mov    [f3d_no_facets],eax
  mov    eax,[f004_world_ptr]
  mov    [f3d_world_ptr],eax

  mov    esi,offset f004_pal
  mov    ecx,f004_pal_size
  xor    al,al
  @WritePalette

  mov    eax,[sr_bar_2_pic]
  call   paint_sr_bloc_init
  call   f3d_init

  mov    [ISR_event],F3D_1_ANI1
  mov    [ISR_pc],0
  mov    eax,offset f3d_1_ISR
  mov    [fg_calc],eax
@@paint:
  cli
  mov    eax,[f3d1_xangle]
  sar    eax,8
  mov    [f3d_xangle],eax
  mov    eax,[f3d1_distance]
  mov    [f3d_distance],eax
  sti

  cmp    [dword sr_bar_yl],0
  jz     @@end_srb
  call   paint_sr_bar
  cmp    [dword sr_bar_yl],0
  jz     @@end_srb
  call   paint_sr_bar
@@end_srb:

  mov    edi,[Rendbuff]
  add    edi,100*640
  mov    ecx,(640*380)/4
  xor    eax,eax
  rep    stosd

  call   f3d_project_world
  call   f3d_draw_world
  call   end_credits

  call   [sync_screen]
  cmp    [byte ISR_event],F3D_1_DONE
  je     @@end
  call   key_pressed2
  jnc    @@paint
  call   get_key
  cmp    al,27
  je     @@end
  jmp    @@paint
@@end:

  call   f3d_deinit
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
F3D_2_ANI1            = 1
F3D_2_ANI2            = 2
F3D_2_ANIWAIT         = 3
F3D_2_ANI4            = 4
F3D_2_ANI4_1          = 5
F3D_2_ANI4_2          = 6
F3D_2_ANI4_3          = 7
F3D_2_ANI5            = 8
F3D_2_ANI6            = 9
F3D_2_DONE            = 10

proc f3d_2_ISR
  call   end_credits_ISR

  cmp    [byte ISR_event],F3D_2_ANI1
  je     @@jF3D_2_ANI1
  cmp    [byte ISR_event],F3D_2_ANI2
  je     @@jF3D_2_ANI2
  cmp    [byte ISR_event],F3D_2_ANIWAIT
  je     @@jF3D_2_ANIWAIT
  cmp    [byte ISR_event],F3D_2_ANI4
  je     @@jF3D_2_ANI4
  cmp    [byte ISR_event],F3D_2_ANI4_1
  je     @@jF3D_2_ANI4_1
  cmp    [byte ISR_event],F3D_2_ANI4_2
  je     @@jF3D_2_ANI4_2
  cmp    [byte ISR_event],F3D_2_ANI4_3
  je     @@jF3D_2_ANI4_3
  cmp    [byte ISR_event],F3D_2_ANI5
  je     @@jF3D_2_ANI5
  cmp    [byte ISR_event],F3D_2_ANI6
  je     @@jF3D_2_ANI6
  ret
@@next_event:
  mov    [dword ISR_pc],0
  inc    [byte ISR_event]
  ret
@@jF3D_2_ANI1:
  cmp    [dword ISR_pc],220
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [dword f3d1_xangle],400h
  mov    eax,[f3d1_distance]
  sar    eax,6
  sub    [f3d1_distance],eax
  ret
@@jF3D_2_ANI2:
  cmp    [dword ISR_pc],140
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [dword f3d1_xangle],400h
  sub    [f3d1_zangle],1
  mov    eax,[f3d1_distance]
  sar    eax,6
  sub    [f3d1_distance],eax
  ret
@@jF3D_2_ANIWAIT:
  cmp    [dword ISR_pc],200
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [dword f3d1_xangle],400h
  ret
@@jF3D_2_ANI4:
  cmp    [dword ISR_pc],140
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [dword f3d1_xangle],400h
  sub    [dword f3d1_zangle],2h
  add    [dword f3d1_distance],20
  add    [dword f3d1_focus_z],10
  ret
@@jF3D_2_ANI4_1:
  cmp    [dword ISR_pc],300
  jae    @@next_event
  inc    [dword ISR_pc]
  sub    [dword f3d1_distance],7
  mov    eax,[f3d1_xangle_inc]
  add    [dword f3d1_xangle],eax
  sub    [dword f3d1_xangle_inc],9h
  sub    [dword f3d1_focus_z],3
  ret
@@jF3D_2_ANI4_2:
  cmp    [dword ISR_pc],500
  jae    @@next_event
  inc    [dword ISR_pc]
  mov    eax,[f3d1_xangle_inc]
  add    [dword f3d1_xangle],eax
  ret
@@jF3D_2_ANI4_3:
  cmp    [dword ISR_pc],150
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [dword f3d1_distance],10
  mov    eax,[f3d1_xangle_inc]
  add    [dword f3d1_xangle],eax
  add    [dword f3d1_xangle_inc],20h
  add    [dword f3d1_focus_z],3
  ret
@@jF3D_2_ANI5:
  cmp    [dword ISR_pc],100
  jae    @@next_event
  inc    [dword ISR_pc]
  mov    eax,[f3d1_xangle_inc]
  add    [dword f3d1_xangle],eax
  sub    [dword f3d1_xangle_inc],40h
  ret
@@jF3D_2_ANI6:
  cmp    [dword ISR_pc],95                ;<=========
  jae    @@next_event
  inc    [dword ISR_pc]
  mov    eax,[f3d1_xangle_inc]
  add    [dword f3d1_xangle],eax

  mov    eax,[f3d1_distance]
  sar    eax,5
  sub    [f3d1_distance],eax
  sub    [dword f3d1_distance],20

  sub    [dword f3d1_focus_z],20
  add    [dword f3d1_posty],1
  ret
endp

proc f3d_2
  mov    eax,[f005_no_facets]
  mov    [f3d_no_facets],eax
  mov    eax,[f005_world_ptr]
  mov    [f3d_world_ptr],eax

  mov    esi,offset f005_pal
  mov    ecx,f005_pal_size
  xor    al,al
  @WritePalette

  mov    eax,[sr_bar_3_pic]
  call   paint_sr_bloc_init
  call   f3d_init

  mov    [f3d1_xangle_inc],400h
  mov    [f3d1_zangle],1024+512
  mov    [f3d1_distance],60000

  mov    [ISR_event],F3D_2_ANI1
  mov    [ISR_pc],0
  mov    eax,offset f3d_2_ISR
  mov    [fg_calc],eax
@@paint:
  cli
  mov    eax,[f3d1_xangle]
  sar    eax,8
  mov    [f3d_xangle],eax
  mov    eax,[f3d1_zangle]
  mov    [f3d_zangle],eax
  mov    eax,[f3d1_distance]
  mov    [f3d_distance],eax
  mov    eax,[f3d1_focus_z]
  mov    [f3d_focus_z],eax
  mov    eax,[f3d1_posty]
  mov    [f3d_posty],eax
  sti

  cmp    [dword sr_bar_yl],0
  jz     @@end_srb
  call   paint_sr_bar
  cmp    [dword sr_bar_yl],0
  jz     @@end_srb
  call   paint_sr_bar
@@end_srb:

  mov    edi,[Rendbuff]
  add    edi,100*640
  mov    ecx,(640*380)/4
  xor    eax,eax
  rep    stosd

  call   f3d_project_world
  call   f3d_draw_world
  call   end_credits

  call   [sync_screen]
  cmp    [byte ISR_event],F3D_2_DONE
  je     @@end
  call   key_pressed2
  jnc    @@paint
  call   get_key
  cmp    al,27
  je     @@end
  jmp    @@paint
@@end:

  call   f3d_deinit
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
F3D_3_ANI1            = 1
F3D_3_ANI2            = 2
F3D_3_ANI3            = 3
F3D_3_DONE            = 4

proc f3d_3_ISR
  call   end_credits_ISR

  cmp    [byte ISR_event],F3D_3_ANI1
  je     @@jF3D_3_ANI1
  cmp    [byte ISR_event],F3D_3_ANI2
  je     @@jF3D_3_ANI2
  cmp    [byte ISR_event],F3D_3_ANI3
  je     @@jF3D_3_ANI3
  ret
@@next_event:
  mov    [dword ISR_pc],0
  inc    [byte ISR_event]
  ret
@@jF3D_3_ANI1:
  cmp    [dword ISR_pc],600
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [dword f3d1_xangle],400h
  mov    eax,[f3d1_distance]
  sar    eax,7
  sub    [f3d1_distance],eax
  ret
@@jF3D_3_ANI2:
  cmp    [dword ISR_pc],900
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [dword f3d1_xangle],400h
  ret
@@jF3D_3_ANI3:
  cmp    [dword ISR_pc],400
  jae    @@next_event
  inc    [dword ISR_pc]
  add    [dword f3d1_xangle],400h
  mov    eax,[f3d1_distance]
  sar    eax,6
  add    [f3d1_distance],eax
  ret
endp

proc f3d_3
  mov    eax,[f001_no_facets]
  mov    [f3d_no_facets],eax
  mov    eax,[f001_world_ptr]
  mov    [f3d_world_ptr],eax

  mov    esi,offset f001_pal
  mov    ecx,f001_pal_size
  xor    al,al
  @WritePalette

  mov    eax,[sr_bar_1_pic]
  call   paint_sr_bloc_init
  call   f3d_init

  mov    [dword f3d1_xangle_inc],800h
  mov    [dword f3d1_xangle],0
  mov    [dword f3d_zangle],1024+170
  mov    [dword f3d_focus_z],0
  mov    [dword f3d1_distance],60000
  mov    [dword f3d_posty],480/2

  mov    [ISR_event],F3D_3_ANI1
  mov    [ISR_pc],0
  mov    eax,offset f3d_3_ISR
  mov    [fg_calc],eax
@@paint:
  cli
  mov    eax,[f3d1_xangle]
  sar    eax,8
  mov    [f3d_xangle],eax
  mov    eax,[f3d1_distance]
  mov    [f3d_distance],eax
  sti

  cmp    [dword sr_bar_yl],0
  jz     @@end_srb
  call   paint_sr_bar
  cmp    [dword sr_bar_yl],0
  jz     @@end_srb
  call   paint_sr_bar
@@end_srb:

  mov    edi,[Rendbuff]
  add    edi,100*640
  mov    ecx,(640*380)/4
  xor    eax,eax
  rep    stosd

  call   f3d_project_world
  call   f3d_draw_world
  call   end_credits

  call   [sync_screen]
  cmp    [byte ISR_event],F3D_3_DONE
  je     @@end
  call   key_pressed2
  jnc    @@paint
  call   get_key
  cmp    al,27
  je     @@end
  jmp    @@paint
@@end:

  call   f3d_deinit
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc sr3_play
  call   totally_clear_screen

  call   end_credits_init

  mov    esi,offset sr_bar_pal
  mov    ecx,sr_bar_pal_size
  mov    al,211
  @WritePalette
  call   f3d_1
  cmp    [last_get_key],27
  je     @@end
  call   f3d_2
  cmp    [last_get_key],27
  je     @@end
  call   f3d_3
@@end:
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
end_mess              db "$"
end_mess2             db "From Real 2 SuperReal             Coded By Jason Nunn (JsNO) of SuperReal/HORNET"
                      db "By Jason Nunn for Oz96               Music by Richard Wickel (The REW)/Nostalgia"
                      db  13,10,13,10
                      db  "LAST PART OF DEMO - (isn't straped in yet..and isn't finished)",13,10,"$"
Start_sr3:
  call   debug
  cld
  mov    ax,0EE02h       ; get DOS32 address information
  int    31h
  neg    ebx
  mov    [Zero_Addr],ebx
  add    ebx,0A0000h
  mov    [_0A0000h],ebx
  add    ebx,0B8000h-0A0000h
  mov    [_0B8000h],ebx
  mov    [Environment_Address],edi
  mov    [PSP_Address],esi

  call   load_data
  call   load_data2

  mov    bl,10b
  call   CheckVbeMode
  jc     @@init_error
  call   setvbemode

  mov    al,256-32
  mov    ecx,font_pal_size
  mov    esi,offset font_pal
  @WritePalette

  call   set_IRQ00
  call   sr3_play
  call   reset_IRQ00

  mov    eax,3
  int    10h

  mov    edx,offset end_mess
  mov    ah,9
  int    21h
  mov    edx,offset end_mess2
  mov    ah,9
  int    21h
  mov    edx,offset end_mess
  mov    ah,9
  int    21h
@@init_error:
  mov    eax,4c00h
  int    21h
ends

end Start_sr3


