		.386
		Ideal
		Jumps
		Model	Tiny,C

		Include	'vesa.inc'
		Include 'gfx.inc'
		Include	'xms.inc'
		Include 'settings.inc'

		CodeSeg
Proc		TimerCallback

		pushf				; Simulate interrupt
		call	[cs:OldTimerCB]

Bjarne:
		cli				; Disable interrupts!
		cmp	[cs:cbBusy],1		; Is the last call finished?
		je	SHORT @@SkipThisOne		; Nope, skip this one
		mov	[cs:cbBusy],1		; Now we're busy!
		sti				; Enable interrupts
		pushad				; Save registers
		push	ds es fs

		mov	ax,[cs:cbDataSeg]
		mov	ds,ax

		cmp	[word cbActive],1		; Are we active?
		jne	SHORT @@IsNotActive			; Nope, skip

		call	PlaybackShowFrame	C,[cbNextFrame]

		inc	[cbNextFrame]
		mov	ax,[cbStopFrame]
		cmp	ax,[cbNextFrame]
		jae	SHORT @@NoFrameOverflow

		mov	ax,[cbStartFrame]
		mov	[cbNextFrame],ax

		inc	[cbCurCount]
		mov	ax,[cbRepeats]
		cmp	ax,-1
		je	SHORT @@RepeatForever
		cmp	ax,[cbCurCount]
		jae	SHORT @@NoCountOverflow
		mov	[word cbActive],0
@@RepeatForever:
@@NoCountOverflow:
@@NoFrameOverflow:
@@IsNotActive:
@@Ending:
		pop	fs es ds			; Restore registers
		popad
		mov	[cs:cbBusy],0
		iret
@@SkipThisOne:
		sti					; Enable interrupts
		iret
EndP		TimerCallback

Public		PlaybackShowFrame
Proc		PlaybackShowFrame
		arg	frame:word


		mov	ax,seg PlaybackBuffer
		mov	fs,ax
		mov	si,offset PlaybackBuffer
		call	XMSGetFrame	C,[frame],fs,si
		test	ax,ax
		jz	SHORT @@Error

		push	VIDMEM
		pop	es

		xor	dx,dx
		call	VesaSetBank	C,dx
		mov	di,[VesaModeWidthInBytes]
		mov	ax,10
		mul	di
		mov	di,ax

		mov	cx,100
@@Loop1:
		push	cx
		mov	cx,160
@@Loop2:
		mov	ax,[fs:si]
		add	si,2
		mov	bx,ax
		shl	eax,16
		mov	ax,bx
		stosd
		stosd
		test	di,di
		jne	@@NoBankSwitch
		inc	dx
		call	VesaSetBank	C,dx
@@NoBankSwitch:
		loop	@@Loop2

		mov	ax,[VesaModeWidthInBytes]
		sub	ax,160*8
		add	di,ax
		jnc	@@NoBankSwitch2
		inc	dx
		call	VesaSetBank	C,dx
@@NoBankSwitch2:
		pop	cx
		loop	@@Loop1

;		mov	cx,(SCREEN_SIZE/SCREEN_BPP)
;@@Loop1:
;		mov	ax,[fs:si]
;		mov	bx,ax
;		shl	eax,16
;		mov	ax,bx
;		stosd
;		stosd
;		test	di,di
;		jne	@@NoBankSwitch
;		inc	dx
;		call	VesaSetBank	C,dx
;@@NoBankSwitch:
;		add	si,4
;
;		loop	@@Loop1


@@Error:
		ret
EndP		PlaybackShowFrame


; Warning! PlaybackStop MUST be called before exiting the program
Public		PlaybackStart
Proc		PlaybackStart	uses es bx si
		arg	startframe:word,stopframe:word,repeats:word
		mov	ax,[startframe]
		mov	[cbStartFrame],ax
		mov	[cbNextFrame],ax
		mov	ax,[stopframe]
		mov	[cbStopFrame],ax
		mov	ax,[repeats]
		mov	[cbRepeats],ax
		xor	ax,ax
		mov	[word cbCurCount],ax	;0
		mov	[word cs:cbBusy],ax	;0
		inc	ax
		mov	[word cbActive],ax	;1
		mov	ax,ds
		mov	[cs:cbDataSeg],ax

		; Get old ISR for interrupt 1Ch
		mov	ax,351Ch
		int	21h
		mov	[cs:OldTimerCBofs],bx
		mov	[cs:OldTimerCBseg],es

		; Set our callback as new ISR
		push	ds
	        mov	dx,offset TimerCallback
		mov	ax,cs
		mov	ds,ax
		mov	ax,251Ch
		int	21h
		pop	ds

		mov	eax,1
		ret
Endp		PlaybackStart

Public		PlaybackStop
Proc		PlaybackStop	uses ax dx
		; Restore old ISR
		push	ds
		mov	dx,[cs:OldTimerCBofs]
		mov	ax,[cs:OldTimerCBseg]
		mov	ds,ax
		mov	ax,251Ch
		int	21h
		pop	ds
		mov	[word cbActive],0
		ret
EndP		PlaybackStop

; Data for callback
cbDataSeg	dw	0
cbBusy		dw	0

label OldTimerCB dword
OldTimerCBofs	dw	0
OldTimerCBseg	dw	0

		DataSeg
		Align 2

cbStartFrame	dw	0
cbStopFrame	dw	0
cbRepeats	dw	0
cbNextFrame	dw	0
cbCurCount	dw	0
public cbActive
cbActive	dw	0

Segment		PlaybackBufferSeg	PARA PRIVATE USE16 'TIMERBUF'
PlaybackBuffer	db	FRAME_SIZE dup(0)
Ends		PlaybackBufferSeg

		end
