;#############################################################################
;#
;# XMS.ASM
;#
;# Purpose:
;#	XMS routines! Only usable in this 4k intro :)
;#
;#############################################################################
		.386
		Ideal
		Jumps
		Model	Tiny,C
		CodeSeg
		Include 'settings.inc'

Struc		FrameEntry
Handle		dw	0
Pointer		dd	0
Ends		FrameEntry

FRAMES_PER_BLOCK = 16
; This function should really be rewritten to support different size of blocks
; instead of constant block size
Public		XMSInit
Proc		XMSInit uses bx cx dx si es

		; Check for XMS
		mov	ax,4300h
		int	2Fh
		cmp	al,80h
		jne	SHORT @@NoXMS

		; Get function address
		mov	ax,4310h
		int	2Fh
		mov	[word XMSControl],bx
		mov	[word XMSControl+2],es

		; Query free memory
		mov	ah,08h
		call	[XMSControl]
		cmp	dx,MEMORY_NEEDED/1024
		jb	SHORT @@NoMemory

		; Start allocating MAX_FRAMES memory blocks all FRAME_SIZE large
		mov	cx,MAX_FRAMES/FRAMES_PER_BLOCK
		mov	si,offset HandleTable
@@AllocLoop:
		mov	ah,09h
		mov	dx,FRAMES_PER_BLOCK*FRAME_SIZE/1024
		call	[XMSControl]
		cmp	ax,0001h
		jne	SHORT @@CantAllocMemory
		; Ok we have memory!
		mov	[si],dx
		add	si,2
		loop	@@AllocLoop

		; Build the frame table
		mov	cx,MAX_FRAMES
		mov	si,offset FrameTable
		xor	ax,ax			; Handle
		xor	edx,edx
@@FrameTableLoop:
		mov	bx,ax
		shr	bx,4			; DIVIDE BY FRAMES_PER_BLOCK!!!!!!
		add	bx,bx
		mov	bx,[HandleTable+bx]
		mov	[si + FrameEntry.Handle],bx
		mov	[si + FrameEntry.Pointer],edx
		inc	ax
		add	edx,FRAME_SIZE
		and	edx,FRAMES_PER_BLOCK*FRAME_SIZE - 1
		add	si,SIZE FrameEntry
		loop	@@FrameTableLoop

		mov	ax,1
		jmp	SHORT @@Exit
@@CantAllocMemory:
		; Aiee! Can't alloc all frames, free up the one we managed to allocate
		call	XMSFree
		jmp	SHORT @@ErrorExit
@@NoMemory:
@@NoXMS:
@@ErrorExit:
		xor	ax,ax
@@Exit:
		ret
EndP		XMSInit

Public		XMSFree
Proc		XMSFree	uses cx dx si
		; Free up all allocated memory
		local	status:word

		mov	[status],1
		mov	cx,MAX_FRAMES/FRAMES_PER_BLOCK
		mov	si,offset HandleTable
@@FreeLoop:
		mov	ah,0Ah
		mov	dx,[si]
		call	[XMSControl]
		test	ax,ax
		jnz	SHORT @@NoError
		mov	[status],0
@@NoError:
		add	si,2
		loop	SHORT @@FreeLoop
		mov	ax,[status]
		ret
EndP		XMSFree

Public		XMSGetFrame
Proc		XMSGetFrame	uses bx cx dx si
		arg	frame:word,bufseg:word,bufofs:word

		mov	bx,[frame]		; Check if we already got the frame
		cmp	bx,MAX_FRAMES
		jae	SHORT @@FrameOutofRange
		; OK, the frame is not in lower mem, and is not out of range,
		; so we have to get it from XMS mem

		; Then copy it
		mov	eax,FRAME_SIZE
		mov	[mLength],eax
		mov	ax,SIZE FrameEntry
		mul	bx
		mov	si,offset FrameTable
		add	si,ax
		mov	bx,[si + FrameEntry.Handle]
		mov	[mSourceHandle],bx
		mov	eax,[si + FrameEntry.Pointer]
		mov	[mSourceOffset],eax

		mov	[mDestHandle],0			; Zero means from <1MB mem
		mov	ax,[bufofs]
		mov	[word mDestOffset],ax
		mov	ax,[bufseg]
		mov	[word mDestOffset+2],ax
		mov	si,offset ExtMemMoveStruct
		mov	ah,0Bh
		call	[XMSControl]
		test	ax,ax
		jz	SHORT @@ErrorOccured
		mov	ax,1
		jmp	SHORT @@Exit
@@ErrorOccured:
		;mov	[XMSErrorByte],bl
@@FrameOutofRange:
		xor	ax,ax
		jmp	SHORT @@Exit
@@GotFrame:
		mov	ax,1
@@Exit:
		ret
EndP		XMSGetFrame

Public		XMSSetFrame
Proc		XMSSetFrame	uses bx si
		arg	frame:word,bufseg:word,bufofs:word

		mov	bx,[frame]
		cmp	bx,MAX_FRAMES
		jae	SHORT @@FrameOutofRange
		; The frame is OK, now copy it
		mov	eax,FRAME_SIZE
		mov	[mLength],eax
		mov	ax,SIZE FrameEntry
		mul	bx
		mov	si,offset FrameTable
		add	si,ax
		mov	bx,[si + FrameEntry.Handle]
		mov	[mDestHandle],bx
		mov	eax,[si + FrameEntry.Pointer]
		mov	[mDestOffset],eax

		mov	[mSourceHandle],0
		mov	ax,[bufofs]
		mov	[word mSourceOffset],ax
		mov	ax,[bufseg]
		mov	[word mSourceOffset+2],ax
		mov	ah,0Bh
		mov	si,offset ExtMemMoveStruct
		call	[XMSControl]
		test	ax,ax
		jz	SHORT @@ErrorOccured
		mov	ax,1
		jmp	SHORT @@Exit
@@ErrorOccured:
@@FrameOutofRange:
		xor	ax,ax
@@Exit:
		ret
EndP		XMSSetFrame

; Internal function, assumes frame number is correct
; WARNING! Only one lock can be valid at any time
;Proc		XMSLockFrame	uses bx dx
;		arg	frame:word
;
;		cmp	[word CurLockedFrame],-1
;		jne	@@AlreadyLocked
;		cmp	[dword CurLockedAdr],-1
;		jne	@@AlreadyLocked
;		mov	bx,[frame]
;		mov	[CurLockedFrame],bx
;		add	bx,bx
;		mov	dx,[HandleTable + bx]
;		mov	ah,0Ch
;		call	[XMSControl]
;		mov	ax,dx		; Return 32 bit address in eax
;		shl	eax,16
;		mov	ax,bx
;		mov	[CurLockedAdr],eax
;@@AlreadyLocked:
;		mov	eax,-1
;		ret
;EndP		XMSLockFrame

;Proc		XMSUnlockFrame	uses dx
;		arg	frame:word
;		mov	dx,[frame]
;		cmp	[CurLockedFrame],dx
;		jne	@@WrongFrame
;		cmp	[word CurLockedFrame],-1
;		je	@@NoLockedFrame
;		cmp	[dword CurLockedAdr],-1
;		je	@@NoLockedAdr
;		mov	ah,0Dh
;		call	[XMSControl]
;		mov	eax,1
;		mov	[word CurLockedFrame],-1
;		mov	[dword CurLockedAdr],-1
;		jmp	@@Exit
;@@NoLockedAdr:
;@@NoLockedFrame:
;@@WrongFrame:
;		xor	eax,eax
;@@Exit:
;		ret
;EndP		XMSUnlockFrame

		DataSeg
		Align 2

XMSControl	dd	0

;CurLockedFrame	dw	-1
;CurLockedAdr	dd	-1

HandleTable	dw	MAX_FRAMES/FRAMES_PER_BLOCK dup(0)

label FrameTable
REPT MAX_FRAMES
		FrameEntry < >
ENDM

;Struc ExtMemMoveStruct

label ExtMemMoveStruct
mLength		dd  0   ; 32-bit number of bytes to transfer
mSourceHandle	dw  0   ; Handle of source block
mSourceOffset	dd  0   ; 32-bit offset into source
mDestHandle	dw  0   ; Handle of destination block
mDestOffset	dd  0   ; 32-bit offset into destination block

;Public XMSErrorByte
;XMSErrorByte	db	0
;Ends        ExtMemMoveStruct
		end
