/*                   ͸
                             PONDER -- the demo        
                                by winghead            
                      Copyright 1996 Joshua C. Shepard 
͵       All Rights Reserved        ͸
͵
 Legal B.S.:                                                                
͵
 This source code is released to you with the permission of the author      
 in order that you might learn from it. You MAY NOT use the source code     
 directly in your own productions, or "rip" the code in any other manner.   
 You are freely encouraged to use the ideas and methods however.            
 The text/poem is also copyrighted by the author. It may not be used in any 
 form other than short quotes :)                                            
;
*/
/////////////////////////////////////////////////////////////////////////////
// function header files
/////////////////////////////////////////////////////////////////////////////
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <math.h>
#include <string.h>

#include <mikmod.h>
#include "real.h"

/////////////////////////////////////////////////////////////////////////////
// data header files:
/////////////////////////////////////////////////////////////////////////////
#include "skypal.h"
#include "skypal2.h"
#include "firepal.h"
#include "raypal.h"
#include "pondrpal.h"
#include "water.h"
#include "fontwid.h"
#include "skullpal.h"
#include "eyepal.h"
#include "matchpal.h"

/////////////////////////////////////////////////////////////////////////////
// macros and constants:
/////////////////////////////////////////////////////////////////////////////
#define BUF_WIDTH 256
#define BUF_HEIGHT 192
#define AVG_CHAR_WIDTH 20
#define BMP_WIDTH 256
#define BMP_HEIGHT 256
#define BMP_CNTR_X (BMP_WIDTH/2)
#define BMP_CNTR_Y (BMP_HEIGHT/2)

#define BUF_CNTR_X (BUF_WIDTH/2)
#define BUF_CNTR_Y (BUG_HEIGHT/2)

#define FieldBits 8
#define FieldSize ( 1 << FieldBits )
#define FieldBytes (FieldSize * FieldSize)

#define RADIX (32 - FieldBits)
#define wrap(n)     (n & (FieldSize-1))
#define MapIndex(x,y)  ((wrap(y) << FieldBits) + wrap(x))

#define Angle360 0x1000
#define AngleMask (Angle360 - 1)
#define Angle180 (Angle360 / 2)
#define Angle90  (Angle360 / 4)
#define Angle60  (Angle360 / 6)
#define Angle45  (Angle360 / 8)
#define Angle30  (Angle360 / 12)
#define ViewAngle (Angle60 / 2)

#define SIN( x ) sinTable[(x) & AngleMask]
#define COS( x ) sinTable[((x) + Angle90) & AngleMask]

#define DefaultPitch (BUF_HEIGHT / 2)
#define YawAccel     (Angle360 / 256)
#define VScale 0xa00;
#define speed 0x200

/////////////////////////////////////////////////////////////////////////////
// external variables (from compiled header files):
/////////////////////////////////////////////////////////////////////////////
extern unsigned char tube_pic[];
extern unsigned char font[];
extern unsigned char font_widths[];
extern unsigned char ponderpic[];
extern unsigned char skullpic[];
extern unsigned char eyepic[];
extern unsigned char matchpic[];

// mikmod variables:
extern LOADER uniload;
extern DRIVER gusdriver,sbdriver,nosnddriver;
UWORD playertimer;

/////////////////////////////////////////////////////////////////////////////
// global variables:
/////////////////////////////////////////////////////////////////////////////
int SCREEN_WIDTH;
int SCREEN_HEIGHT;
unsigned char* buf1;
// sky renderer globals
long sinTable[Angle360];
unsigned char HeightMap[FieldBytes];
unsigned char SkyMap[FieldBytes];
int xOrg = 128L << 16;
int yOrg = 128L << 16;
long Altitude = 220;
int Yaw = Angle90;
int Pitch = DefaultPitch;
// a pointer to the drawing function
void (*ShowPic)( unsigned char* pic );


/////////////////////////////////////////////////////////////////////////////
// interrupt handlers:
/////////////////////////////////////////////////////////////////////////////
// CLOCK TICK HANDLER FOR MIKMOD
void tickhandler( void )
{
    MP_HandleTick();    // play 1 tick of the module
    MD_SetBPM(mp_bpm);
}


/////////////////////////////////////////////////////////////////////////////
// inline asm functions:
/////////////////////////////////////////////////////////////////////////////

void SetVidMode( short );
#pragma aux SetVidMode = \
    "int 10h"            \
    parm [ax];

// PUTS A 256x192 PIC TO THE SCREEN IN LIKET MODE
void ShowPicLiket( unsigned char* pic );
#pragma aux ShowPicLiket = \
    "mov edi, 0xa0000" \
    "mov ecx, 12288" \
    "rep movsd" \
    parm [esi] modify [edi ecx];

void ShowPic256( unsigned char* pic )
{
    ShowPicLiket( pic );
}

// PUTS A 256x200 PIC TO A MODE 13H SCREEN
void ShowPic13h( unsigned char* pic );
#pragma aux ShowPic13h =     \
    "mov edi, 0xa0520"    \
    "mov ebx, 192"        \
  "looper:"               \
    "mov ecx, 64"         \
    "rep movsd"           \
    "add edi, 64"         \
    "dec ebx"             \
    "jnz looper"          \
    parm [esi] modify [ecx edi ebx];

void ShowPic320( unsigned char* pic )
{
    ShowPic13h( pic );
}

// WAITS FOR THE VERTICAL RETRACE
void WaitRetrace();
#pragma aux WaitRetrace = \
     "  mov  dx,03dah"    \
     "looper:     "       \
     "  in   al,dx"       \
     "  and  al,8"        \
     "  jz   looper"      \
     modify [dx al];

// WAITS FOR NO VERTICAL RETRACE
void WaitNoRetrace();
#pragma aux WaitNoRetrace = \
    "  mov dx, 03dah" \
    "looper: " \
    "  in al, dx" \
    "  and al, 8" \
    "  jnz looper" \
    modify [dx al];

// CLEARS A BUFFER (SIZE MUST BE EVENLY DIVSIBLE BY 4)
void ClearBuf( unsigned char* buf, int size );
#pragma aux ClearBuf = \
    "mov eax, 0" \
    "shr ecx, 2" \
    "rep stosd" \
    parm [edi][ecx] modify [eax];

void SetPalReg( int color, int red, int green, int blue);
#pragma aux SetPalReg =     \
    "mov dx, 03c8h"         \
    "out dx, al"            \
    "inc dx"                \
    "mov ax, bx"            \
    "out dx, al"            \
    "mov ax, cx"            \
    "out dx, al"            \
    "mov ax, di"            \
    "out dx, al"            \
    parm [eax][ebx][ecx][edi]   \
    modify [edx];

// COPIES A PALETTE TO ANOTHER PALETTE
void CopyPal( unsigned char* dest, unsigned char* src );
#pragma aux CopyPal = \
    "mov ecx, 192" \
    "rep movsd" \
    parm [edi][esi] modify [ecx];

int CalcOffset( int u, int v );
#pragma aux CalcOffset = \
    "mov ebx, edx"       \
    "shr ebx, 32 - 8"    \
    "shld ebx, ecx, 8"   \
    parm [ecx][edx] value [ebx];


/////////////////////////////////////////////////////////////////////////////
// functions:
/////////////////////////////////////////////////////////////////////////////

// GETS THE VALUES OF ONE PALETTE REGISTER
void GetPalReg( short index, unsigned char* r, unsigned char* g,
    unsigned char* b)
{
    outpw( 0x3c6, 0xff );        //Enable reading
    outpw( 0x3c7, index );       //from register# 'index'
    *r = (unsigned char)inp( 0x3c9 );    //now get the values:
    *g = (unsigned char)inp( 0x3c9 );
    *b = (unsigned char)inp( 0x3c9 );
}

void SetPal( unsigned char* pal )
{
    int count = 0;
    short int r, g, b;
    do
    {
        r = pal[count * 3];
        g = pal[count * 3 + 1];
        b = pal[count * 3 + 2];
        SetPalReg( count, r, g, b );
        count++;
    }
    while( count < 256 );
}

// fades out a section of 16 colors one step
void FadeOutRing( unsigned char* pal, int color1, int step )
{
    int count;
    for( count = color1; count < color1 + 16*3; count++ )
    {
        if( pal[count] > step ) pal[count] -= step;
        if( pal[count+1] > step ) pal[count+1] -= step;
        if( pal[count+2] > step ) pal[count+2] -= step;
    }
    SetPal( pal );
}

// blacks out a section of 16 colors
void BlackOutRing( unsigned char* pal, int color1 )
{
    int count;
    for( count = color1; count < color1 + 16*3; count++ )
    {
        pal[count] = 0;
        pal[count+1] = 0;
        pal[count+2] = 0;
    }
    SetPal( pal );
}

// sets a section of 16 colors to a rgb value
void SetRingColor( unsigned char* pal, int color1, int r, int g, int b )
{
    int count;
    for( count = color1; count < color1 + 16*3; count++ )
    {
        pal[count] = r;
        pal[count+1] = g;
        pal[count+2] = b;
    }
    SetPal( pal );
}

// builds x,y tables for the screen->bitmap translation
// pointers must be pre-allocated BUF_HEIGHT*BUF_WIDTH bytes
void MakeTexMapTables( unsigned char* xmap, unsigned char* ymap )
{
    double x, y, r, xy2, z, t ,l, sd;
    long zc;
    unsigned char col, col2;
    int xp, yp, adr;
    int off;
    unsigned char    i;

    //radius
    r = 50;
    //dist between viewer & screen
    sd = 400;
    adr = 0;

    for ( y=-BUF_HEIGHT/2; y<=(BUF_HEIGHT/2-1); y++ )
    {
        yp = y;
        for ( x=-(BUF_WIDTH/2); x<=(BUF_WIDTH/2 -1); x++ )
        {
            xy2 = fabs(( x * x ) + ( y * y ));
            xy2 = sqrt( xy2 );
            if (xy2 != 0)
              l = r / xy2;
            z = l * sd;
            if (z < 20000)
            {
                if ((x != 0) && (y != 0))
                {
                    t = atan( y / x );
                    t = 256 * t / ( 2 * PI );
                    if ((x <= 0) && (y <= 0))
                      t++;
                    if ((x > 0) && (y > 0))
                      t++;
                    if (x >= 0)
                      t = t+128;
                }

                zc = ceil( z / 4 );
                zc = (int)zc % 256;
                col = zc;
                xmap[((int)y+BUF_HEIGHT/2)*BUF_WIDTH + ((int)x+BUF_WIDTH/2)] = col;

                col = t;
                if ((y == 0) && (x < 0))
                  col = 1;
                ymap[((int)y+BUF_HEIGHT/2)*BUF_WIDTH + ((int)x+BUF_WIDTH/2)] = col;
            }
            else
            {
                col = 0;
                xmap[((int)y+BUF_HEIGHT/2)*BUF_WIDTH + ((int)x+BUF_WIDTH/2)] = col;
                ymap[((int)y+BUF_HEIGHT/2)*BUF_WIDTH + ((int)x+BUF_WIDTH/2)] = col;
            }
            adr++;
        }
    }
}

// builds x,y tables for the screen->bitmap translation, NOT A TUBE
// pointers must be pre-allocated BUF_HEIGHT*BUF_WIDTH bytes
void MakeTexMapTables2( unsigned char* xmap, unsigned char* ymap )
{
    double x, y, r, xy2, z, t ,l, sd;
    long zc;
    unsigned char col, col2;
    int xp, yp, adr;
    int off;
    unsigned char    i;

    //radius
    r = 50;
    adr = 0;

    for ( y=-BUF_HEIGHT/2; y<=(BUF_HEIGHT/2-1); y++ )
    {
        yp = y;
        for ( x=-(BUF_WIDTH/2); x<=(BUF_WIDTH/2 -1); x++ )
        {
            xy2 = fabs(( x * x ) + ( y * y ));
            xy2 = sqrt( xy2 );
            if (xy2 != 0)
              l = r / xy2;
            if ((x != 0) && (y != 0))
            {
                t = atan( y / x );
                t = 256 * t / ( 2 * PI );
                if ((x <= 0) && (y <= 0))
                  t++;
                if ((x > 0) && (y > 0))
                  t++;
                if (x >= 0)
                  t = t+128;
            }

            col = (unsigned char)l % 256;
            xmap[((int)y+BUF_HEIGHT/2)*BUF_WIDTH + ((int)x+BUF_WIDTH/2)] = col;

            col = t;
            if ((y == 0) && (x < 0))
              col = 1;
            ymap[((int)y+BUF_HEIGHT/2)*BUF_WIDTH + ((int)x+BUF_WIDTH/2)] = col;
            adr++;
        }
    }
}

// builds a table of radii for the screen
// pointer must be pre-allocated BUF_HEIGHT*BUF_WIDTH bytes
void MakeRadTable( unsigned char* table, unsigned char* table2, unsigned char* table3 )
{
    double r;
    double x2, y2;
    int rad, rad2;

    // for each point:
    for( int row = 0; row < BUF_HEIGHT; row++ )
    {
        for( int col = 0; col < BUF_WIDTH; col++ )
        {
            // find the distance from the center of the screen at this point:
            x2 = (col-BUF_WIDTH/2) * (col-BUF_WIDTH/2);
            y2 = (row-BUF_HEIGHT/2) * (row-BUF_HEIGHT/2);
            r = sqrt( x2 + y2 );
            rad = (int)ceil( r );
            rad2 = (int)(r * 0.625 );

            table3[row * BUF_WIDTH + col] = (unsigned char)rad2;
            table2[row * BUF_WIDTH + col] = (unsigned char)rad / 10;
            table[row * BUF_WIDTH + col] = (unsigned char)rad / 21;

        }
    }
}

// SET A 256x192 SQUARE ASPECT 50Hz VIDEO MODE. MODE 13H *MUST* BE SET FIRST!
void SetLiketMode( void )
{
    int t;
    outp( 0x3d4, 0x11 );
    t = inp( 0x3d5 );
    outp( 0x3d5, t & 0x7f );
    outp( 0x3c2, 0x63 );
    outp( 0x3d4, 0x00 );
    outp( 0x3d5, 0x50 );
    outp( 0x3D4, 0x1 );
    outp( 0x3D5, 0x3F );
    outp( 0x3D4, 0x2 );
    outp( 0x3D5, 0x40 );
    outp( 0x3D4, 0x3 );
    outp( 0x3D5, 0x8B );
    outp( 0x3D4, 0x4 );
    outp( 0x3D5, 0x41 );
    outp( 0x3D4, 0x5 );
    outp( 0x3D5, 0x3 );
    outp( 0x3D4, 0x6 );
    outp( 0x3D5, 0xF3 );
    outp( 0x3D4, 0x7 );
    outp( 0x3D5, 0xF0 );
    outp( 0x3D4, 0x8 );
    outp( 0x3D5, 0x0 );
    outp( 0x3D4, 0x9 );
    outp( 0x3D5, 0x62 );
    outp( 0x3D4, 0x10 );
    outp( 0x3D5, 0x93 );
    outp( 0x3D4, 0x11 );
    outp( 0x3D5, 0x8C );
    outp( 0x3D4, 0x12 );
    outp( 0x3D5, 0x41 );
    outp( 0x3D4, 0x13 );
    outp( 0x3D5, 0x20 );
    outp( 0x3D4, 0x14 );
    outp( 0x3D5, 0x40 );
    outp( 0x3D4, 0x15 );
    outp( 0x3D5, 0x58 );
    outp( 0x3D4, 0x16 );
    outp( 0x3D5, 0x70 );
    outp( 0x3D4, 0x17 );
    outp( 0x3D5, 0xA3 );
    outp( 0x3C4, 0x1 );
    outp( 0x3C5, 0x1 );
    outp( 0x3C4, 0x3 );
    outp( 0x3C5, 0x0 );
    outp( 0x3C4, 0x4 );
    outp( 0x3C5, 0xE );
    outp( 0x3CE, 0x5 );
    outp( 0x3CF, 0x40 );
    outp( 0x3CE, 0x6 );
    outp( 0x3CF, 0x5 );
}

// WARNING: HANDLES ONLY a - z (LOWER CASE ONLY) and '?' !!!
// WILL *BARF* ON OTHER INPUT :)
void DrawChar( char index, int x, int y, unsigned char* buf )
{
    unsigned char* letter;
    unsigned char color;

    letter = font + index * 28 * 40;
    buf = buf + y * BUF_WIDTH + x;

    for( int row = 0; row < 40; row++ )
    {
        for( int col = 0; col < 28; col++ )
        {
            color = letter[row * 28 + col];
            if( color != 0 ) *buf++ = color;
            else buf++;
        }
        buf += BUF_WIDTH-28;
    }
}

// DRAW THE STRING IN THE VARIABLE WIDTH FONT( WOO HOO! )
void DrawText( char* s, int x, int y, unsigned char* buf )
{
    char index;

    BEGIN:
    while( (index = *s) != 0 )
    {
        if( index == ' ' )
        {
            s++;
            x += 20;
            goto BEGIN;
        }
        else if( index == '?' ) index = 26;
        else index = index - 97;

        DrawChar( index, x, y, buf );
        s++;
        x += font_widths[index];
    }
}

//GET THE CURRENT PALETTE
void GetPalette( unsigned char* pal )
{
    int count;
    // get the current palette:
    for( count = 0; count < 256; count++ )
    {
        GetPalReg( count, &pal[count*3], &pal[count*3+1], &pal[count*3+2] );
    }
}

// SETS THE A PALETTE RANGE (C2 - C2) TO A GRADIENT
void SetFadePalette(int r1, int g1, int b1, int r2, int g2, int b2, int c1,
                    int c2)
{
    int dr, dg, db, r, g, b, count;

    r = r1 << 8;
    g = g1 << 8;
    b = b1 << 8;

    dr = ((r2 - r1) << 8) / (c2 - c1);
    dg = ((g2 - g1) << 8) / (c2 - c1);
    db = ((b2 - b1) << 8) / (c2 - c1);

    outp(0x3c8, c1);

    for (count = c1; count <= c2; count++)
    {
        outp(0x3c9, r >> 8);
        outp(0x3c9, g >> 8);
        outp(0x3c9, b >> 8);

        r += dr;
        g += dg;
        b += db;
    }
}

// FADES THE PALETTE OUT TO BLACK. RETURNS TRUE IF DONE
int FadeOut( unsigned char* pal )
{
    static int i = 0;
    int count;
    if( i < 64 )
    {
        for( count = 0; count < 768; count++ )
        {
            if( pal[count] > 0 ) pal[count]--;
        }
        WaitRetrace();
        SetPal( pal );
        i++;
        return 0;
    }
    else
    {
        i = 0;
        return 1;
    }
}

// FADES IN PROPORTIONATELY. RETURNS TRUE WHEN DONE
int FadeIn( unsigned char* pal )
{
    static unsigned char cur_pal[768];
    int count;
    static int i = 0;
    int j;

    //move all values smoothly to their pal value:
    for( j = 0; j < 256; j++ )
    {
        cur_pal[j*3] = ( pal[j*3] * i / 64 );
        cur_pal[j*3+1] = ( pal[j*3+1] * i / 64 );
        cur_pal[j*3+2] = ( pal[j*3+2] * i / 64 );
    }
    //wait for the vertical retrace, to avoid "snow":
    while( inp( 0x3da ) & 0x08 ){}
    while( !(inp( 0x3da ) & 0x08 )){}

    for( count = 0; count < 256; count++ )
    {
        SetPalReg( count, cur_pal[count*3], cur_pal[count*3+1],
                  cur_pal[count*3+2] );
    }
    i++;
    if( i == 63 )
    {
        i = 0;
        //set all values to pal values:
        for( count = 0; count < 256; count++ )
        {
            SetPalReg( count, pal[count*3], pal[count*3+1], pal[count*3+2] );
        }
        return 1;
    }
    else return 0;
}

// FADES THE PALETTE OUT TO WHITE. RETURNS TRUE IF DONE
int FadeToWhite( unsigned char* pal )
{
    static int i = 0;
    int count;
    if( i < 64 )
    {
        for( count = 0; count < 768; count++ )
        {
            if( pal[count] < 63 ) pal[count]++;
        }
        WaitRetrace();
        SetPal( pal );
        i++;
        return 0;
    }
    else
    {
        i = 0;
        return 1;
    }
}

// RETURNS TRUE IF VOLUME IS ALL THE WAY FADED IN
int FadeMusicIn( void )
{
    if( mp_volume == 100 ) return 1;
    else
    {
        mp_volume++;
        return 0;
    }
}

// RETURNS TRUE IF VOLUME IS ALL THE WAY FADED OUT
int FadeMusicOut( void )
{
    if( mp_volume == 0 ) return 1;
    else
    {
        mp_volume--;
        return 0;
    }
}

// ROTATES AND TILES A BITMAP EVERY OTHER LINE IN DIFFERENT DIRECTIONS AND DIFF COLOR:
void RotateBmp( unsigned char* buf, unsigned char* bmp, mangle angle, real scale )
{
    unsigned char* dest;
    real u, v, row_u, row_v, start_u, start_v;
    real du_col, dv_col, du_row, dv_row;
    int x, y;

    // center of the 256 x 256 bitmap:
    start_u = INT_TO_REAL( BMP_CNTR_X );
    start_v = INT_TO_REAL( BMP_CNTR_Y );

    // calculate the deltas:
    du_col = xGetCos( angle );
    dv_col = xGetSin( angle );

    du_col = Mul( du_col, scale );
    dv_col = Mul( dv_col, scale );

    du_row = -dv_col;
    dv_row = du_col;

    start_u -= BMP_CNTR_X * du_col + BMP_CNTR_Y * du_col;
    start_v -= BMP_CNTR_X * dv_col + BMP_CNTR_Y * dv_col;

    row_u = start_u;
    row_v = start_v;

    dest = buf;
    for( y = 0; y < BUF_HEIGHT; y +=2 )
    {
        u = row_u;
        v = row_v;
        for( x = 0; x < BUF_WIDTH; x++ )
        {
            *dest++ = bmp[(REAL_TO_INT( u ) & 255 ) + (REAL_TO_INT( v ) & 255 ) * 256];
            u += du_col;
            v += dv_col;
        }
        dest += BUF_WIDTH;
        row_u += du_row;
        row_v += dv_row;
    }
    dest = buf + BUF_WIDTH;
    for( y = 1; y < BUF_HEIGHT; y += 2 )
    {
        u = row_u;
        v = row_v;
        for( x = 0; x < BUF_WIDTH; x++ )
        {
            *dest++ = bmp[(REAL_TO_INT( u ) & 255 ) + (REAL_TO_INT( v ) & 255 ) * 256]+128;
            u -= du_row;
            v -= dv_row;
        }
        dest += BUF_WIDTH;
        row_u -= du_col;
        row_v -= dv_col;
    }
}

// INITIALIZE SIN TABLE IN 16.16 FIXED POINT:
void InitSkySinTable( void )
{
    int i;
    for( i = 0; i < Angle180; i++ )
    {
        sinTable[i] = sin((double)i * PI / Angle180) * 0x10000L;
    }

    for( i = Angle180; i < Angle360; i++ )
    {
        sinTable[i] = -sinTable[i - Angle180];
    }
}

char RandomColor(int c, int n, int d)
{
    int p;
    int rand_color = (int)rand() / (RAND_MAX / (n<<1));
    p = (c + n - rand_color) / d - 1;
    if (p > 255)
    {
        p = 255;
    }
    if (p < 0)
    {
        p = 0;
    }
    return p;
}

// RECURSIVE FUNCTION TO CREATE A FRACTAL TERRAIN MAP
void CreateFractalMap( int startx, int starty, int endx, int endy )
{
    int pt1, pt2, pt3, pt4;
    int x2, y2;
    int d;

    // check for need for further recursion:
    if (((endx-startx) < 2) && ((endy-starty) < 2)) return;

    pt1 = HeightMap[MapIndex( startx, starty )];
    pt2 = HeightMap[MapIndex( startx, endy )];
    pt3 = HeightMap[MapIndex( endx, starty )];
    pt4 = HeightMap[MapIndex( endx, endy )];

    x2 = (endx+startx) >> 1;
    y2 = (endy+starty) >> 1;
    d = 5 * (endx - startx + endy - starty) / 3;

    if (HeightMap[MapIndex( startx, y2 )] == 0)
      HeightMap[MapIndex( startx, y2 )] = RandomColor( pt2+pt4, d, 2 );
    if (HeightMap[MapIndex( endx, y2 )] == 0)
      HeightMap[MapIndex( endx, y2 )] = RandomColor( pt3+pt4, d, 2 );
    if (HeightMap[MapIndex( x2, starty )] == 0)
      HeightMap[MapIndex( x2, starty )] = RandomColor( pt1+pt3, d, 2 );
    if (HeightMap[MapIndex( x2, endy )] == 0)
      HeightMap[MapIndex( x2, endy )] = RandomColor( pt1+pt2, d, 2 );

    HeightMap[MapIndex( x2, y2 )] = RandomColor( pt1+pt2+pt3+pt4, d, 4 );

    // recurse for each new 'quadrant':
    CreateFractalMap( startx, starty, x2, y2 );
    CreateFractalMap( x2, starty, endx, y2 );
    CreateFractalMap( startx, y2, x2, endy );
    CreateFractalMap( x2, y2, endx, endy );
}

void AverageMapVals()
{
    int x, y;

    for (x = 0; x < FieldSize; x++)
    {
        for (y = 0; y < FieldSize; y++)
        {
            HeightMap[MapIndex( x, y )] =
              ( HeightMap[MapIndex( x,  y - 1 )] +
               HeightMap[MapIndex( x,  y + 1 )] +
               HeightMap[MapIndex( x - 1,y - 1 )] +
               HeightMap[MapIndex( x - 1,y + 1 )] +
               HeightMap[MapIndex( x + 1,y - 1 )] +
               HeightMap[MapIndex( x + 1,y + 1 )] +
               HeightMap[MapIndex( x - 1,y )] +
               HeightMap[MapIndex( x + 1,y )] ) >> 3;
        }
    }
}

// LOAD THE HEIGHT FIELD DATA:
void InitSkyMapper( void )
{
    int count, row, col;
    printf( "Creating Fractal...\n" );
    CreateFractalMap( 0, 0, FieldSize, FieldSize );
    for( count = 0; count < 5; count++ ) AverageMapVals();
    for( row = 0; row < FieldSize; row++ )
    {
        for( col = 0; col < FieldSize; col++ )
        {
            SkyMap[row * FieldSize + col] =
              (HeightMap[row * FieldSize + col]>>1);
        }
    }
    InitSkySinTable();
}

// SETUP A PALETTE GRADIENT FROM ONE VALUE TO ANOTHER:
void SetPaletteSpread( int r1, int g1, int b1, int r2, int g2, int b2,
                    int c1, int c2 )
{
    int dr, dg, db, r, g, b;

    r = r1 << 8;
    g = g1 << 8;
    b = b1 << 8;

    dr = ((r2 - r1) << 8) / (c2 - c1);
    dg = ((g2 - g1) << 8) / (c2 - c1);
    db = ((b2 - b1) << 8) / (c2 - c1);

    outp(0x3c8, c1);

    for( int count = c1; count <= c2; count++ )
    {
        outp( 0x3c9, r >> 8 );
        outp( 0x3c9, g >> 8 );
        outp( 0x3c9, b >> 8 );

        r += dr;
        g += dg;
        b += db;
    }
}

void CastSkyRay( int col, int horiz, int dx, int dy )
{
    int x, y, z;
    int pixel, offset;
    unsigned char c;

    // point to the top of the column:
    pixel = col;

    // initial coordinates:
    x = xOrg << (16 - FieldBits);
    y = yOrg << (16 - FieldBits);

    while( pixel <= horiz * BUF_WIDTH )
    {
        y += dy;
        x += dx;

        // calculate the offset in the height field
        offset = CalcOffset( x, y );

        c = SkyMap[offset];
        buf1[pixel] = c;  // draw pixel
        pixel += BUF_WIDTH;
    }
}

// ONLY DOES EVERY OTHER PIXEL (EVEN PIXELS)
void CastSkyRay2( int col, int horiz, int dx, int dy )
{
    int x, y, z;
    int pixel, offset;
    unsigned char c;

    // point to the top of the column:
    pixel = col;

    // lets go 2 pixels at a time:
    dx <<= 1;
    dy <<= 1;

    // initial coordinates:
    x = xOrg << (16 - FieldBits);
    y = yOrg << (16 - FieldBits);

    while( pixel < horiz * BUF_WIDTH )
    {
        y += dy;
        x += dx;

        // calculate the offset in the height field
        offset = CalcOffset( x, y );

        c = SkyMap[offset];
        buf1[pixel] = c;  // draw pixel
        pixel += (BUF_WIDTH<<1);
    }
}

// ONLY DOES EVERY OTHER PIXEL (ODD PIXELS), UPSIDE DOWN
void CastSkyRay3( int col, int horiz, int dx, int dy )
{
    int x, y, z;
    int pixel, offset;
    unsigned char c;

    // point to the top of the column:
    pixel = BUF_WIDTH * (BUF_HEIGHT-1) + col;

    // lets go 2 pixels at a time:
    dx <<= 1;
    dy <<= 1;

    // initial coordinates:
    x = xOrg << (16 - FieldBits);
    y = yOrg << (16 - FieldBits);

    while( pixel >= col )
    {
        y += dy;
        x += dx;

        // calculate the offset in the height field
        offset = CalcOffset( x, y );

        c = SkyMap[offset];
        buf1[pixel] = c;  // draw pixel
        pixel -= (BUF_WIDTH<<1);
    }
}


/////////////////////////////////////////////////////////////////////////////
// main routine
/////////////////////////////////////////////////////////////////////////////

void main( int argc, char* argv[] )
{
    unsigned char pal[768];
    unsigned char* tube_x;
    unsigned char* tube_y;
    unsigned char* circ_x;
    unsigned char* circ_y;
    // radii from 0-15
    unsigned char* radii;
    // radii from 0 - 127, that loops from 127 back to 0 (not quite radii)
    unsigned char* radii2;
    unsigned char* radii3;

    unsigned char* screen = (unsigned char*)0xa0000;

    FILE* file;

    int row, col;
    int offs;
    unsigned char x, y;
    int color;
    unsigned char x_off, y_off;
    unsigned char x_off2;
    unsigned char y_off2;
    int color_offs;
    int done;
    int count;

    //get command line argument:
    // if there isn't any, default to tweaked mode
    if( argc < 2 )
    {
        SCREEN_WIDTH = 256;
        SCREEN_HEIGHT = 192;
        ShowPic = ShowPic256;
    }
    // else if the paramter is "13h" use mode 13h
    else if ( strcmp( argv[1], "13h" ) == 0 )
    {
        SCREEN_WIDTH = 320;
        SCREEN_HEIGHT = 200;
        ShowPic = ShowPic320;
    }
    // otherwise exit with a help message
    else
    {
        printf( "In order to run this demo in mode 13h, type 'ponder 13h'\n" );
        printf( "The default is to use a 50Hz 256x192 tweaked mode.\n" );
        return;
    }

    // allocate memory for the data files:
    tube_x = new unsigned char[BUF_WIDTH * BUF_HEIGHT];
    tube_y = new unsigned char[BUF_WIDTH * BUF_HEIGHT];
    circ_x = new unsigned char[BUF_WIDTH * BUF_HEIGHT];
    circ_y = new unsigned char[BUF_WIDTH * BUF_HEIGHT];

    radii = new unsigned char[BUF_WIDTH * BUF_HEIGHT];
    radii2 = new unsigned char[BUF_WIDTH * BUF_HEIGHT];
    radii3 = new unsigned char[BUF_WIDTH * BUF_HEIGHT];
    buf1 = new unsigned char[BUF_WIDTH * BUF_HEIGHT];

    if( !tube_x || !tube_y || !tube_pic || !radii || !radii2 || !radii3 ||
        !circ_x || !circ_y || !buf1 )
    {
        delete tube_x;
        delete tube_y;
        delete circ_x;
        delete circ_y;
        delete radii;
        delete radii2;
        delete radii3;
        delete buf1;
        return;
    }

    // clear buf1
    ClearBuf( buf1, BUF_WIDTH * BUF_HEIGHT );

    // generate tables:
    printf( "Performing heavy calculations, please stand by...\n" );
    MakeTexMapTables( tube_x, tube_y );
    MakeTexMapTables2( circ_x, circ_y );
    MakeRadTable( radii, radii3, radii2 );

    // create the cloud fractal:
    InitSkyMapper();

    // initialize fixed point math tables:
    xInitCosSin();

    // start the music player:
    //MIKMOD stuff://////////////////////////////////////////////////////////
    UNIMOD *mf;
    md_mixfreq      =44100;                     // standard mixing freq
    md_dmabufsize   =10000;                     // standard dma buf size
    md_mode         =DMODE_16BITS|DMODE_STEREO; // standard mixing mode
    md_device       =0;                         // standard device: autodetect
    // Register the loaders we want to use..
    ML_RegisterLoader(&load_uni);

    // Register the drivers we want to use:
    MD_RegisterDriver(&drv_nos);
    MD_RegisterDriver(&drv_ss);
    MD_RegisterDriver(&drv_sb);
    MD_RegisterDriver(&drv_gus);

    MD_RegisterPlayer(tickhandler);
    mp_loop=1;
    mp_volume=0;

    // initialize sound card
    if(!MD_Init())
    {
        printf("\nMusic Driver error: %s.\n",myerr);
        return;
    }

    printf( "\nUsing %s for %d bit %s %s sound at %u Hz\n\n",
           md_driver->Name,
           (md_mode&DMODE_16BITS) ? 16:8,
           (md_mode&DMODE_INTERP) ? "interpolated":"normal",
           (md_mode&DMODE_STEREO) ? "stereo":"mono",
           md_mixfreq );
    mf = ML_LoadFN( "ponder.uni" );
    // didn't work, exit
    if( mf == NULL )
    {
        printf( "MikMod Error: %s\n", myerr );
        exit(0);
    }
    // initialize modplayer to play this module
    MP_Init(mf);
    md_numchn=mf->numchn;
    // End mikmod stuff /////////////////////////////////////////////////////

    // GO!!!
    SetVidMode( 0x13 );
    if( SCREEN_WIDTH == 256 ) SetLiketMode();
    SetPal( skypal );
    GetPalette( pal );

    // fade in to "an"
    DrawText( "an", (BUF_WIDTH - (28*2))/2, (BUF_HEIGHT - (40))/2, buf1 );
    WaitRetrace();
    ShowPic( buf1 );
    CopyPal( pal, skypal );
    while( !FadeIn( pal ) ){ }

    // start playing the module:
    MD_PlayStart();

    // fade out
    CopyPal( pal, skypal );
    while( !FadeOut( pal ) ){ FadeMusicIn(); MD_Update(); }

    // fade in to "Apex"
    CopyPal( pal, ponderpal );
    ShowPic( ponderpic );
    while( !FadeIn( pal ) ){ FadeMusicIn(); MD_Update(); }

    // delay just 3/4 of a sec or so:
    for( count = 0; count < 38; count++ )
    {
        FadeMusicIn();
        MD_Update();
        WaitRetrace();
        WaitNoRetrace();
    }

    // fade out
    GetPalette( pal );
    while( !FadeOut( pal ) ){ FadeMusicIn(); MD_Update(); }

    // fade to "production"
    ClearBuf( buf1, BUF_WIDTH* BUF_HEIGHT );
    DrawText( "production", (BUF_WIDTH - (AVG_CHAR_WIDTH*10))/2,
        (BUF_HEIGHT - (40))/2, buf1 );
    WaitRetrace();
    ShowPic( buf1 );
    CopyPal( pal, skypal );
    while( !FadeIn( pal ) ){ MD_Update(); }

    // fade to black
    GetPalette( pal );
    while( !FadeOut( pal ) ){ MD_Update(); }

    /////////////////////////////////////////////////////////////////////////
    // TUNNEL FADES IN AND "PONDER" APPEARS
    /////////////////////////////////////////////////////////////////////////
    x_off = 0;
    y_off = 0;
    CopyPal( pal, skypal );
    done = 0;
    while( !done )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs];
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
            }
        }
        MD_Update();
        done = FadeIn( pal );
        ShowPic( buf1 );
        x_off += 3;
    }
    // if sound volume not max, set it to max:
    if( mp_volume != 100 ) mp_volume = 100;
    // "ponder"
    for( count = 0; count < 128; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs];
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
            }
        }
        DrawText( "ponder", (BUF_WIDTH - (AVG_CHAR_WIDTH*6))/2,
            (BUF_HEIGHT - (40))/2, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
    }

    /////////////////////////////////////////////////////////////////////////
    // "SUCTION POINT" EFFECT:
    /////////////////////////////////////////////////////////////////////////
    x_off = 0;
    y_off = 0;
    for( count = 0; count < 75; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = radii2[offs];
                y = circ_y[offs];
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x];
            }
        }
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
    }
    // "what do you think"
    for( count = 0; count < 50; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = radii2[offs];
                y = circ_y[offs];
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x];
            }
        }
        DrawText( "what do you", 0, 60, buf1 );
        DrawText( "think", 150, 130, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
    }
    for( count = 0; count < 50; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = radii2[offs];
                y = circ_y[offs];
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x];
            }
        }
        DrawText( "happens", (BUF_WIDTH - (AVG_CHAR_WIDTH*6))/2,
            (BUF_HEIGHT - (40))/2, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
    }
    WaitRetrace();
    for( count = 0; count < 50; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = radii2[offs];
                y = circ_y[offs];
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x];
            }
        }
        DrawText( "when you", (BUF_WIDTH - (AVG_CHAR_WIDTH*8))/2,
            (BUF_HEIGHT - (40))/2, buf1 );
        DrawText( "die?", (BUF_WIDTH - (AVG_CHAR_WIDTH*4))/2, 116, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
    }

    /////////////////////////////////////////////////////////////////////////
    // FLASH SKULL PIC:
    /////////////////////////////////////////////////////////////////////////
    WaitRetrace();
    SetPal( skullpal );
    ShowPic( skullpic );
    // wait a fifth of a sec or so:
    for( count = 0; count < 10; count++ )
    {
        MD_Update();
        WaitRetrace();
        WaitNoRetrace();
    }


    /////////////////////////////////////////////////////////////////////////
    // FIRE TUNNEL:
    /////////////////////////////////////////////////////////////////////////
    ClearBuf( screen, SCREEN_WIDTH * SCREEN_HEIGHT );
    WaitRetrace();
    SetPal( firepal );
    GetPalette( pal );
    while( !FadeIn( pal ) )
    {
        FadeIn( pal );
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs];
                x += x_off;
                y += y_off;
                buf1[offs] = tube_pic[y * 256 + x] + (radii3[offs]);
            }
        }
        DrawText( "do you go to", 3, (BUF_HEIGHT - (40))/2,
                 buf1 );
        DrawText( "hell?", (BUF_WIDTH - (AVG_CHAR_WIDTH*5))/2, 116, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 6;
    }

    /////////////////////////////////////////////////////////////////////////
    // DOUBLE SWIRLY:
    /////////////////////////////////////////////////////////////////////////
    x_off2 = 128;
    y_off2 = 128;
    x_off = 0;
    y_off = 0;
    WaitRetrace();
    ClearBuf( screen, SCREEN_WIDTH * SCREEN_HEIGHT );
    SetPal( skypal );
    for( count = 0; count < 75; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row +=2 )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs]+(xGetSin(radii2[offs]*2)>>11);
                x += x_off;
                y += y_off;
                buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
            }
        }
        for( row = 1; row < BUF_HEIGHT; row +=2 )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs]+(xGetSin(radii2[offs]*2)>>11);
                x -= x_off2;
                y -= y_off2;
                buf1[offs] = tube_pic[x * 256 + y] + (radii[offs]*16);
            }
        }
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
        y_off += 3;
        x_off2 +=3;
        y_off2 = (xGetSin( x_off2 ) >> 10);
        y_off2 += 3;
    }

    // "or heaven?"
    for( count = 0; count < 50; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row +=2 )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs]+(xGetSin(radii2[offs]*2)>>11);
                x += x_off;
                y += y_off;
                buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
            }
        }
        for( row = 1; row < BUF_HEIGHT; row +=2 )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs]+(xGetSin(radii2[offs]*2)>>11);
                x -= x_off2;
                y -= y_off2;
                buf1[offs] = tube_pic[x * 256 + y] + (radii[offs]*16);
            }
        }
        DrawText( "or", 30, 40, buf1 );
        DrawText( "heaven?", 80, 105, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
        y_off += 3;
        x_off2 +=3;
        y_off2 = (xGetSin( x_off2 ) >> 10);
        y_off2 += 3;
    }

    /////////////////////////////////////////////////////////////////////////
    // RAYS SHOOT OUT
    /////////////////////////////////////////////////////////////////////////
    x_off = 0;
    y_off = 0;
    for( count = 0; count < 75; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = circ_x[offs];
                y = circ_y[offs];
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x];
            }
        }
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
    }
    // "Do you see god?"
    for( count = 0; count < 50; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = circ_x[offs];
                y = circ_y[offs];
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x];
            }
        }
        DrawText( "do you see", 10, 70, buf1 );
        DrawText( "god?", 100, 120, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
    }
    // "or do you see"
    for( count = 0; count < 50; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = circ_x[offs];
                y = circ_y[offs];
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x];
            }
        }
        DrawText( "or", 10, 40, buf1 );
        DrawText( "do you see", 10, 100, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
    }

    /////////////////////////////////////////////////////////////////////////
    // BLANK PAGE:
    /////////////////////////////////////////////////////////////////////////
    ClearBuf( buf1, BUF_WIDTH * BUF_HEIGHT );
    DrawText( "nothing?", (BUF_WIDTH - (AVG_CHAR_WIDTH*8))/2,
        (BUF_HEIGHT - 40)/2, buf1 );
    ShowPic( buf1 );
    // fade to black
    GetPalette( pal );
    while( !FadeOut( pal ) ){ MD_Update(); }


    /////////////////////////////////////////////////////////////////////////
    // REVERSING SWIRLER
    /////////////////////////////////////////////////////////////////////////
    WaitRetrace();
    ClearBuf( screen, SCREEN_WIDTH * SCREEN_HEIGHT );
    SetPal( skypal );
    y_off = 0;
    x_off = 0;
    for( count = 0; count < 75; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs]+(xGetSin(radii2[offs]*2)>>11);
                x += x_off;
                y += y_off;
                buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
            }
        }
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
        y_off = (xGetSin( x_off ) >> 10);
    }
    // "what do you see"
    for( count = 0; count < 50; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs]+(xGetSin(radii2[offs]*2)>>11);
                x += x_off;
                y += y_off;
                buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
            }
        }
        DrawText( "what do you", 10, 30, buf1 );
        DrawText( "see", 160, 130, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
        y_off = (xGetSin( x_off ) >> 10);
    }


    /////////////////////////////////////////////////////////////////////////
    // DOUBLE BITMAP ROTATOR/SCALER
    /////////////////////////////////////////////////////////////////////////
    mangle theta;
    for( theta = 0; theta < MANGLE_360>>2; theta++ )
    {
        RotateBmp( buf1, tube_pic, theta, xGetSin( theta ) / 2 +0x9000 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
    }
    for ( ; theta < MANGLE_360>>1; theta++ )
    {
        RotateBmp( buf1, tube_pic, theta, xGetSin( theta ) / 2 +0x9000 );
        DrawText( "in your", 10, 60, buf1 );
        DrawText( "dreams?", 90, 100, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
    }
    for ( ; theta < 192; theta++ )
    {
        RotateBmp( buf1, tube_pic, theta, xGetSin( theta ) / 2 +0x9000 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
    }
    for ( ; theta < 192+50; theta++ )
    {
        RotateBmp( buf1, tube_pic, theta, xGetSin( theta ) / 2 +0x9000 );
        DrawText( "are you mad", 18, (BUF_HEIGHT - 40)/2,
            buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
    }


    /////////////////////////////////////////////////////////////////////////
    // flash eyeball pic
    /////////////////////////////////////////////////////////////////////////
    WaitRetrace();
    SetPal( eyepal );
    ShowPic( eyepic );
    // wait a fifth of a sec or so:
    for( count = 0; count < 10; count++ )
    {
        MD_Update();
        WaitRetrace();
        WaitNoRetrace();
    }


    /////////////////////////////////////////////////////////////////////////
    // DOUBLE U GHOSTLY TUNNEL
    /////////////////////////////////////////////////////////////////////////
    y_off = 0;
    unsigned char yoff2 = 0;
    WaitRetrace();
    ClearBuf( screen, SCREEN_WIDTH * SCREEN_HEIGHT );
    SetPal( skypal );
    for( count = 0; count < 75; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row += 2 )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs];
                x += x_off;
                y += y_off;
                y_off--;
                buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
            }
        }
        for( row = 1; row < BUF_HEIGHT; row += 2 )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs];
                x += x_off;
                y += yoff2;
                yoff2++;
                buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
            }
        }
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
        y_off--;
        yoff2++;
    }
    // "to see such things"
    for( count = 0; count < 75; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row += 2 )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs];
                x += x_off;
                y += y_off;
                y_off--;
                buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
            }
        }
        for( row = 1; row < BUF_HEIGHT; row += 2 )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs];
                x += x_off;
                y += yoff2;
                yoff2++;
                buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
            }
        }
        DrawText( "to see", 20, 20, buf1 );
        DrawText( "such things?", 16, 120, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
        y_off--;
        yoff2++;
    }

    /////////////////////////////////////////////////////////////////////////
    // SKY WITH CLOUDS
    /////////////////////////////////////////////////////////////////////////
    WaitRetrace();
    SetPaletteSpread( 0, 0, 63, 63, 63, 63, 0, 127 );
    GetPalette( pal );
    ClearBuf( buf1, BUF_WIDTH * BUF_HEIGHT );
    long dx, dy;
    int column, angle;
    int i;
    int skyHoriz = BUF_HEIGHT-1;
    unsigned char *d;

    for( count = 0; count < 63; count++ )
    {
        xOrg += speed * COS( Yaw ) >> 8;
        yOrg += speed * SIN( Yaw ) >> 8;

        for( column = 0; column < BUF_WIDTH; column++ )
        {
            angle = (ViewAngle * (BUF_WIDTH- column * 2)) / BUF_WIDTH;
            dx = COS( Yaw + angle) << (RADIX - 16);
            dy = SIN( Yaw + angle) << (RADIX - 16);

            CastSkyRay( column, skyHoriz, dx, dy );
        }

        FadeIn( pal );

        // copy the buffer to the screen:
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
    }
    // "do clouds form images"
    for( count = 0; count < 50; count++ )
    {
        xOrg += speed * COS( Yaw ) >> 8;
        yOrg += speed * SIN( Yaw ) >> 8;

        for( column = 0; column < BUF_WIDTH; column++ )
        {
            angle = (ViewAngle * (BUF_WIDTH- column * 2)) / BUF_WIDTH;
            dx = COS( Yaw + angle) << (RADIX - 16);
            dy = SIN( Yaw + angle) << (RADIX - 16);

            CastSkyRay( column, skyHoriz, dx, dy );
        }

        // copy the buffer to the screen:
        DrawText( "do clouds", 30, 30, buf1 );
        DrawText( "form images", 20, 110, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
    }
    // "behind your eyes"
    for( count = 0; count < 50; count++ )
    {
        xOrg += speed * COS( Yaw ) >> 8;
        yOrg += speed * SIN( Yaw ) >> 8;

        for( column = 0; column < BUF_WIDTH; column++ )
        {
            angle = (ViewAngle * (BUF_WIDTH- column * 2)) / BUF_WIDTH;
            dx = COS( Yaw + angle) << (RADIX - 16);
            dy = SIN( Yaw + angle) << (RADIX - 16);

            CastSkyRay( column, skyHoriz, dx, dy );
        }

        // copy the buffer to the screen:
        DrawText( "behind", 40, 40, buf1 );
        DrawText( "your eyes?", 20, 110, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
    }
    /////////////////////////////////////////////////////////////////////////
    // flash eyeball pic
    /////////////////////////////////////////////////////////////////////////
    WaitRetrace();
    SetPal( eyepal );
    ShowPic( eyepic );
    // wait a fifth of a sec or so:
    for( count = 0; count < 10; count++ )
    {
        MD_Update();
        WaitRetrace();
        WaitNoRetrace();
    }
    // fade sky...
    ClearBuf( screen, SCREEN_WIDTH * SCREEN_HEIGHT );
    WaitRetrace();
    SetPaletteSpread( 0, 0, 63, 63, 63, 63, 0, 127 );
    GetPalette( pal );
    for( count = 0; count < 50; count++ )
    {
        xOrg += speed * COS( Yaw ) >> 8;
        yOrg += speed * SIN( Yaw ) >> 8;

        for( column = 0; column < BUF_WIDTH; column++ )
        {
            angle = (ViewAngle * (BUF_WIDTH- column * 2)) / BUF_WIDTH;
            dx = COS( Yaw + angle) << (RADIX - 16);
            dy = SIN( Yaw + angle) << (RADIX - 16);

            CastSkyRay( column, skyHoriz, dx, dy );
        }

        // fade to black
        FadeOut( pal );
        FadeOut( pal );

        // copy the buffer to the screen:
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
    }

    /////////////////////////////////////////////////////////////////////////
    // WATERY GRAVE:
    /////////////////////////////////////////////////////////////////////////
    ClearBuf( screen, SCREEN_WIDTH * SCREEN_HEIGHT );
    WaitRetrace();
    SetPal( skypal2 );
    y_off = 0;
    for( count = 0; count < 75; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs]+(xGetSin(radii3[offs]*16)>>10);
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x] + (radii3[offs]*16);
            }
        }
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
    }
    // "if you were drowning"
    for( count = 0; count < 75; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs]+(xGetSin(radii3[offs]*16)>>10);
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x] + (radii3[offs]*16);
            }
        }
        DrawText( "if you were", 25, 45, buf1 );
        DrawText( "drowning", 80, 120, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
    }

    /////////////////////////////////////////////////////////////////////////
    // SIN SWIRLER:
    /////////////////////////////////////////////////////////////////////////
    y_off = 0;
    for( count = 0; count < 75; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs]+(xGetSin(radii2[offs])>>8);
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
            }
        }
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
    }
    // "would you cry?"
    for( count = 0; count < 50; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs]+(xGetSin(radii2[offs])>>8);
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
            }
        }
        DrawText( "would you", 60, 40, buf1 );
        DrawText( "cry?", 20, 100, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
    }

    /////////////////////////////////////////////////////////////////////////
    // SKY + ROTATING CLOUDS
    /////////////////////////////////////////////////////////////////////////
    WaitRetrace();
    SetPaletteSpread( 0, 0, 63, 63, 63, 63, 0, 127 );
    for( theta = 0; theta < MANGLE_360>>2; theta++ )
    {
        xOrg += speed * COS( Yaw ) >> 8;
        yOrg += speed * SIN( Yaw ) >> 8;

        for( column = 0; column < BUF_WIDTH; column++ )
        {
            angle = (ViewAngle * (BUF_WIDTH- column * 2)) / BUF_WIDTH;
            dx = COS( Yaw + angle) << (RADIX - 16);
            dy = SIN( Yaw + angle) << (RADIX - 16);

            CastSkyRay2( column, skyHoriz, dx, dy );
            CastSkyRay3( column, skyHoriz, dy, dx );
        }

        // copy the buffer to the screen:
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
    }
    // "if you watched yourself"
    for( theta = 0; theta < MANGLE_360>>2; theta++ )
    {
        xOrg += speed * COS( Yaw ) >> 8;
        yOrg += speed * SIN( Yaw ) >> 8;

        for( column = 0; column < BUF_WIDTH; column++ )
        {
            angle = (ViewAngle * (BUF_WIDTH- column * 2)) / BUF_WIDTH;
            dx = COS( Yaw + angle) << (RADIX - 16);
            dy = SIN( Yaw + angle) << (RADIX - 16);

            CastSkyRay2( column, skyHoriz, dx, dy );
            CastSkyRay3( column, skyHoriz, dy, dx );
        }

        // copy the buffer to the screen:
        DrawText( "if", 20, 20, buf1 );
        DrawText( "you watched", 10, 70, buf1 );
        DrawText( "yourself", 40, 120, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
    }

    /////////////////////////////////////////////////////////////////////////
    // STATIC THING
    /////////////////////////////////////////////////////////////////////////
    WaitRetrace();
    ClearBuf( screen, SCREEN_WIDTH * SCREEN_HEIGHT );
    SetPal( skypal );
    y_off = 0;
    for( count = 0; count < 75; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs];
                x += x_off;
                y += y_off;
                y_off += (xGetSin( x )>>13);
                buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
            }
        }
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
    }
    // "die on tv"
    for( count = 0; count < 16; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs];
                x += x_off;
                y += y_off;
                y_off += (xGetSin( x )>>13);
                buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
            }
        }
        DrawText( "die on", (BUF_WIDTH - (20*6))/2, 40, buf1 );
        DrawText( "tv", (BUF_WIDTH - 40)/2, 112, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
    }
    /////////////////////////////////////////////////////////////////////////
    // FLASH SKULL PIC:
    /////////////////////////////////////////////////////////////////////////
    WaitRetrace();
    SetPal( skullpal );
    ShowPic( skullpic );
    // wait a fifth of a sec or so:
    for( count = 0; count < 10; count++ )
    {
        MD_Update();
        WaitRetrace();
        WaitNoRetrace();
    }

    WaitRetrace();
    ClearBuf( screen, SCREEN_WIDTH * SCREEN_HEIGHT );
    SetPal( skypal );

    for( count = 0; count < 16; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs];
                x += x_off;
                y += y_off;
                y_off += (xGetSin( x )>>13);
                buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
            }
        }
        DrawText( "die on", (BUF_WIDTH - (20*6))/2, 40, buf1 );
        DrawText( "tv", (BUF_WIDTH - 40)/2, 112, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
    }

    /////////////////////////////////////////////////////////////////////////
    // RAYS PLUS SWIRLY
    /////////////////////////////////////////////////////////////////////////
    x_off = 0;
    y_off = 0;
    for( count = 0; count < 75; count++ )
    {
        // draw the "rays"
        for( row = 0; row < BUF_HEIGHT; row += 2 )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = circ_x[offs];
                y = circ_y[offs];
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x] + 128;
            }
        }
        // draw the tube:
        for( row = 1; row < BUF_HEIGHT; row += 2 )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs]+(xGetSin(radii2[offs])>>8);
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
            }
        }
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
    }
    // "would you think"
    for( count = 0; count < 50; count++ )
    {
        // draw the "rays"
        for( row = 0; row < BUF_HEIGHT; row += 2 )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = circ_x[offs];
                y = circ_y[offs];
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x] + 128;
            }
        }
        // draw the tube:
        for( row = 1; row < BUF_HEIGHT; row += 2 )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs]+(xGetSin(radii2[offs])>>8);
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
            }
        }
        DrawText( "would you", 10, 20, buf1 );
        DrawText( "think", 20, 90, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
    }
    // "that was strange"
    for( count = 0; count < 50; count++ )
    {
        // draw the "rays"
        for( row = 0; row < BUF_HEIGHT; row += 2 )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = circ_x[offs];
                y = circ_y[offs];
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x] + 128;
            }
        }
        // draw the tube:
        for( row = 1; row < BUF_HEIGHT; row += 2 )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs]+(xGetSin(radii2[offs])>>8);
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
            }
        }
        DrawText( "that", 20, 40, buf1 );
        DrawText( "was strange?", 20, 120, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
    }

    /////////////////////////////////////////////////////////////////////////
    // DOUBLE SWIRLING RAYS
    /////////////////////////////////////////////////////////////////////////
    WaitRetrace();
    SetPal( raypal );
    y_off = 0;
    for( count = 0; count < 75; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row +=2 )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = circ_x[offs];
                y = circ_y[offs]+(xGetSin(radii2[offs]*2)>>11);
                x += x_off;
                y += y_off;
                buf1[offs] = tube_pic[y * 256 + x];
            }
        }
        // draw the tube:
        for( row = 1; row < BUF_HEIGHT; row += 2 )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = circ_x[offs];
                y = circ_y[offs]+(xGetCos(radii2[offs]*2)>>11);
                x -= x_off;
                y -= y_off;
                buf1[offs] = tube_pic[y * 256 + x] + 16;
            }
        }
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
        y_off += 3;
    }
    // "if you played"
    for( count = 0; count < 50; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row +=2 )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = circ_x[offs];
                y = circ_y[offs]+(xGetSin(radii2[offs]*2)>>11);
                x += x_off;
                y += y_off;
                buf1[offs] = tube_pic[y * 256 + x];
            }
        }
        // draw the tube:
        for( row = 1; row < BUF_HEIGHT; row += 2 )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = circ_x[offs];
                y = circ_y[offs]+(xGetCos(radii2[offs]*2)>>11);
                x -= x_off;
                y -= y_off;
                buf1[offs] = tube_pic[y * 256 + x] + 16;
            }
        }
        DrawText( "if you", 30, 20, buf1 );
        DrawText( "played", 70, 100, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
        y_off += 3;
    }
    // "with fire"
    for( count = 0; count < 50; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row +=2 )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = circ_x[offs];
                y = circ_y[offs]+(xGetSin(radii2[offs]*2)>>11);
                x += x_off;
                y += y_off;
                buf1[offs] = tube_pic[y * 256 + x];
            }
        }
        // draw the tube:
        for( row = 1; row < BUF_HEIGHT; row += 2 )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = circ_x[offs];
                y = circ_y[offs]+(xGetCos(radii2[offs]*2)>>11);
                x -= x_off;
                y -= y_off;
                buf1[offs] = tube_pic[y * 256 + x] + 16;
            }
        }
        DrawText( "with", (BUF_WIDTH - (20*4))/2, 50, buf1 );
        DrawText( "fire", (BUF_WIDTH - (20*4))/2, 130, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
        y_off += 3;
    }

    /////////////////////////////////////////////////////////////////////////
    // SHOW MATCH PIC:
    /////////////////////////////////////////////////////////////////////////
    WaitRetrace();
    SetPal( matchpal );
    ShowPic( matchpic );
    // wait a half sec or so:
    for( count = 0; count < 25; count++ )
    {
        MD_Update();
        WaitRetrace();
        WaitNoRetrace();
    }

    WaitRetrace();
    ClearBuf( screen, SCREEN_WIDTH * SCREEN_HEIGHT );
    SetPal( waterpal );

    /////////////////////////////////////////////////////////////////////////
    // EXPANDING CIRCLES:
    /////////////////////////////////////////////////////////////////////////
    // "would it sound like rain"
    x_off = 0;
    int freq, freq_iter;
    freq_iter = DOUBLE_TO_REAL( 0.08 );
    freq = DOUBLE_TO_REAL( 4.0 );
    for( count = 0; count < 50; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = radii2[offs];
                buf1[offs] = xGetSin( Mul( freq, INT_TO_REAL( x ) )>>16 ) >> 8;
            }
        }
        DrawText( "would it", 40, 20, buf1 );
        DrawText( "sound", 99, 76, buf1 );
        DrawText( "like rain?", 30, 140, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x += x_off;
        freq -= freq_iter;
        x_off--;
    }

    /////////////////////////////////////////////////////////////////////////
    // BACK TO MATCH PIC:
    /////////////////////////////////////////////////////////////////////////
    WaitRetrace();
    SetPal( matchpal );
    ShowPic( matchpic );
    // wait half a sec or so:
    for( count = 0; count < 10; count++ )
    {
        MD_Update();
        WaitRetrace();
        WaitNoRetrace();
    }

    /////////////////////////////////////////////////////////////////////////
    // WASH OUT MATCH PIC:
    /////////////////////////////////////////////////////////////////////////
    for( count = 0; count < 75; count++ )
    {
        for( int ycount = 1; ycount < BUF_HEIGHT-1; ycount++ )
        {
            for( int xcount = 0; xcount < BUF_WIDTH; xcount++ )
            {
                  matchpic[ycount * BUF_WIDTH + xcount] =
                      ( matchpic[ycount * BUF_WIDTH + xcount -1] +
                      matchpic[ycount * BUF_WIDTH + xcount +1] +
                      matchpic[(ycount-1) * BUF_WIDTH + xcount] +
                      matchpic[(ycount+1) * BUF_WIDTH + xcount] ) / 4;
            }
        }
        MD_Update();
        WaitRetrace();
        ShowPic( matchpic );
    }

    // fade to black
    GetPalette( pal );
    while( !FadeOut( pal ) ){ MD_Update(); }

    WaitRetrace();
    ClearBuf( screen, SCREEN_WIDTH * SCREEN_HEIGHT );

    /////////////////////////////////////////////////////////////////////////
    // BACK TO THE TUNNEL, WHICH ENDS:
    /////////////////////////////////////////////////////////////////////////
    // fade in
    CopyPal( pal, skypal );
    done = 0;
    // "if you watched this demo"
    while( !done )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs];
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
            }
        }
        DrawText( "if you", (BUF_WIDTH - (20*6))/2, 21, buf1 );
        DrawText( "watched", (BUF_WIDTH - (20*7))/2, 71, buf1 );
        DrawText( "this demo", (BUF_WIDTH - (20*9))/2, 121, buf1 );
        MD_Update();
        done = FadeIn( pal );
        ShowPic( buf1 );
        x_off += 3;
    }
    // tunnel starts to rotate:
    // "would you"
    for( count = 0; count < 32; count++ )
    {
        // draw the tube:
        for( row = 0; row < BUF_HEIGHT; row++ )
        {
            for( col = 0; col < BUF_WIDTH; col++ )
            {
                offs = row * BUF_WIDTH + col;
                x = tube_x[offs];
                y = tube_y[offs];
                x += x_off;
                buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
            }
        }
        DrawText( "would you", (BUF_WIDTH - (20*9))/2, (BUF_HEIGHT - 40)/2, buf1 );
        MD_Update();
        WaitRetrace();
        ShowPic( buf1 );
        x_off += 3;
        y_off += 3;
    }
    // fade out in 'rings':
    // "ponder"
    color_offs = 0;
	do
	{
		// draw the tube:
		for( row = 0; row < BUF_HEIGHT; row++ )
		{
			for( col = 0; col < BUF_WIDTH; col++ )
			{
				offs = row * BUF_WIDTH + col;
				x = tube_x[offs];
				y = tube_y[offs];
				x += x_off;
				y += y_off;
				buf1[offs] = tube_pic[y * 256 + x] + (radii[offs]*16);
			}
		}
		x_off += 3;
		y_off += 3;

        FadeMusicOut();
        DrawText( "ponder?", (BUF_WIDTH - (AVG_CHAR_WIDTH*7))/2,
            (BUF_HEIGHT - (40))/2, buf1 );
        MD_Update();
		WaitRetrace();
		FadeOutRing( skypal, color_offs, 1 );
		if( color_offs >= 16*3 ) FadeOutRing( skypal, color_offs - 16*3, 1 );
		if( color_offs >= 32*3 ) FadeOutRing( skypal, color_offs - 32*3, 1 );
		if( color_offs >= 48*3 ) FadeOutRing( skypal, color_offs - 48*3, 1 );
		if( color_offs >= 64*3 ) FadeOutRing( skypal, color_offs - 64*3, 2 );
		if( color_offs >= 80*3 ) FadeOutRing( skypal, color_offs - 80*3, 2 );
		if( color_offs >= 96*3 ) FadeOutRing( skypal, color_offs - 96*3, 2 );
		if( color_offs >= 112*3 ) FadeOutRing( skypal, color_offs - 112*3, 2 );
		if( color_offs >= 128*3 ) BlackOutRing( skypal, color_offs - 128*3 );

		color_offs += 16*3;
		ShowPic( buf1 );
	}
	while( color_offs < 767 );


    /////////////////////////////////////////////////////////////////////////
    // END:
    /////////////////////////////////////////////////////////////////////////

    // and then wait another 2 seconds or so
    for( count = 0; count < 100; count++ )
    {
        FadeMusicOut();
        MD_Update();
        WaitRetrace();
        WaitNoRetrace();
    }

    //MIKMOD stuff:///////////////////////////////////
    MD_PlayStop();          // stop playing
    ML_Free(mf);            // and free the module
    MD_Exit();
    //////////////////////////////////////////////////


    // free all allocated memory:
    delete tube_x;
    delete tube_y;
    delete circ_x;
    delete circ_y;
    delete radii;
    delete radii2;
    delete radii3;
    delete buf1;

    // return to text mode
    SetVidMode( 0x03 );

    // print an exit message:
    printf( "\nThank you for watching this 'poetro'\n" );
    printf( "Please read the file \"ponder.nfo\" for information about this demo\n" );
    printf( "\nGreetings go out to:\n" );
    printf( "Dark Avenger\n" );
    printf( "Midnight\n" );
    printf( "White Shadow\n" );
    printf( "Anix\n" );
    printf( "DeathStar\n" );
    printf( "Hasty\n" );
    printf( "Phred\n" );
    printf( "Shaman / Dream Factory\n" );
    printf( "Switch\n" );
    printf( "Xphase\n" );
    printf( "\nSpecial Greetings to:\n" );
    printf( "Daredevil / Tran : for PMODE/W\n" );
    printf( "Liket : for the tweaked 50hz mode\n" );
    printf( "Mikmak : for mikmod\n" );
    printf( "all members of Project Eos\n" );
    printf( "all members of Danaan\n" );
    printf( "and all #coders smart enough to switch to anothernet ;)\n" );
}
