;  A_VT.ASM -- VT interface routines  // A.R-M. 7/93

;  updated for DemoVT 1.51  //  ARM 6/94
;  ("sceptical" comments refer to the original, totally undocumented,
;   DemoVT release... it's grown considerable more understandable
;   since then O;-)


; (this is just VTASM.INC//JCAB translated to assemblable code.
;  Who knows? It might even work! ;-D)


;    JCAB, love the way you document your code!


        IDEAL
        MODEL Compact, Pascal
        P286

STRUC   TChanData
          Period DW ?
          Inst   DB ?
          Vol    DB ?
ENDS

STRUC   SRI
  ; These are modified by DemoVT, and you can read them.
      Semaphores     DB 256 DUP(?)      ; Array of semaphores. You can read or
                                        ; modify them (usually cleaning them).


      ChansTrig      DB  32 DUP(?)      ; == 1 -> channel retriggered a note.
      NumChannels    DB ?               ; Number of channels in the MOD.

      CtrlEntryPoint DD ?               ; Address of ther DemoVT service proc.
      TickCounter    DD ?               ; This one provides some form for you
                                        ; to do timing, incremented at 50Hz.
      RegEntryPoint  DD ?               ; DVT Service taking parm in AX.

      ChansData      TChanData 32 DUP (<>) ; Per-channel info.

      Pos            DB ?               ; Note in the current pattern.
      Seq            DB ?               ; Number of playing pattern.

                     DB 81 DUP(?)      ; Reserved.

  ; These are supposed to be modified by you to tell DemoVT your intentions. :)
                     DB  ?              ; Reserved.
                     DW  ?              ; Reserved.

      JumpNewPos     DB  ?              ; Indicates that you want to jump to
                                        ; another position inside the MOD.
      JumpPosSeq     DB  ?              ; Sequence position to jump to.
      JumpPosNote    DB  ?              ; Note inside the pattern to jump to.

      SoundVolume    DB  ?              ; Put your favourite volume here.
                                        ; You can perform fades and the like.
                                        ; 0-255.
      Abort          DB ?               ; Set to 1 to force DVT to exit after
                                        ; your program exits.

                     DB 248 DUP(?)      ; Reserved.

ENDS



  MagicAX    = 5654h;  {'VT'}
  MagicBX    = 5472h;  {'Tr'}
  MagicCX    = 6163h;  {'ac'}
  MagicXorBX = 6B65h;  {'ke'}
  MagicXorCX = 7220h;  {'r '}


        CODESEG

;       ASSUME:ALL_routines,wreck:ALL_registers  }:-)

PUBLIC InitMusic           ; I guess you call this before anything else...
PUBLIC CallMusic           ; Beats me! Does it start the music or something like that?
PUBLIC VTConnectTimer      ; Probably resets timer counter and starts counting...
PUBLIC VTDisconnectTimer   ; Stops counter from counting, I imagine
PUBLIC VTGetTickCounter    ; Reads counter
PUBLIC VTWaitForStart
PUBLIC VTBeginSync

; Oh, by the way, that's a 50 Hz timer up there...

VTRunInfo  SRI <>

AppIDFound DD 0
DVTRunInfo DD 0
TickVal    DW 0

        PROC InitMusic NEAR
                MOV     AX,MagicAX
                MOV     BX,MagicBX   ; playing it safe, huh?
                MOV     CX,MagicCX   ; hehehe!

                XOR     DI,DI
                MOV     ES,DI

; Oh, oh, if this is an address he's passing, I'm a gonner!

                INT     2Fh
                XOR     DL,DL
                AND     AX,AX
                JNZ     @@no
                CMP     BX,MagicBX XOR MagicXorBX
                JNZ     @@no
                CMP     CX,MagicCX XOR MagicXorCX
                JNZ     @@no

; Man! When this guy want's to make sure, HE MAKES SURE!  =:-o

                INC     DL
                MOV     [word ptr AppIDFound+2],ES
                MOV     [word ptr AppIDFound],DI
                LES     DI,[ES:DI-4]
                MOV     [word ptr DVTRunInfo+2],ES
                MOV     [word ptr DVTRunInfo],DI
        @@no:   MOV     AL,DL

; returns 1 if successful, 0 if not... at least I got this part!

                RET
        ENDP


; As best as I can determine this one here calculates PI to
; a thousand decimals...  }:-D

        PROC CallMusic NEAR
                CMP     [word ptr DVTRunInfo+2],0
                JZ      @@Fin
                LES     SI,[DVTRunInfo]
                PUSH    2
                CALL    [ES:SI+SRI.CtrlEntryPoint]
        @@Fin:
                RET
        ENDP


        PROC VTConnectTimer NEAR
                CMP     [word ptr DVTRunInfo+2],0
                JZ      @@Fin
                LES     SI,[DVTRunInfo]
                PUSH    0
                CALL    [ES:SI+SRI.CtrlEntryPoint]
        @@Fin:
                RET
        ENDP

        PROC VTDisconnectTimer NEAR
                CMP     [word ptr DVTRunInfo+2],0
                JZ      @@Fin
                LES     SI,[DVTRunInfo]
                PUSH    1
                CALL    [ES:SI+SRI.CtrlEntryPoint]
        @@Fin:
                RET
        ENDP

        PROC VTGetTickCounter NEAR
;               XOR     AX,AX
;               XOR     DX,DX
P386
                xor eax,eax
P286
                CMP     [word ptr DVTRunInfo+2],0
                JZ      @@Fin
                LES     SI,[DVTRunInfo]
;                MOV     AX,[WORD PTR ES:SI+SRI.TickCounter]
;                MOV     DX,[WORD PTR ES:(SI+2)+SRI.TickCounter]

; returning values in DX:AX, how gauche!  |-D
P386
                mov     eax, [es:si+SRI.TickCounter]
P286
; ...aaah, that's much better!   ]:-D

        @@Fin:
                RET
        ENDP


        PROC VTBeginSync NEAR
                CMP     [WORD PTR DVTRunInfo+2],0
                JZ      @@Fin
                LES     SI,[DVTRunInfo]
                PUSH    3
                CALL    [ES:SI+SRI.CtrlEntryPoint]
        @@Fin:
                RET
        ENDP
 
        PROC VTWaitForStart NEAR
                CMP     [WORD PTR DVTRunInfo+2],0
                JZ      @@Fin
                CALL    VTGetTickCounter
                XOR     AX,AX
                MOV     [WORD PTR ES:SI+SRI.TickCounter],AX
                MOV     [WORD PTR ES:(SI+2)+SRI.TickCounter],AX
 
                MOV     [TickVal],AX
        @@lp:
                CALL    CallMusic
                CALL    VTGetTickCounter
                SUB     AX,25
                CMP     AX,[TickVal]
                JL      @@lp
 
                XOR     AX,AX
                MOV     [WORD PTR ES:SI+SRI.TickCounter],AX
                MOV     [WORD PTR ES:(SI+2)+SRI.TickCounter],AX
        @@Fin:
                RET
        ENDP


        END

; FINALLY! IT ASSEMBLES!!!

