MagiOhso                cld

                        ; seed the randomness, using the current second.
                        mov al,0x00
                        out 0x70,al
                        in al,0x71
                        mov bl,al
                        ror ebx,8
                        mov al,0x02
                        out 0x70,al
                        in al,0x71
                        mov bl,al
                        ror ebx,8
                        mov al,0x04
                        out 0x70,al
                        in al,0x71
                        mov bl,al
                        ror ebx,8
                        mov al,0x07
                        out 0x70,al
                        in al,0x71
                        mov bl,al
                        mov eax,ebx
                        call SeedRandom

                        mov eax,0x00000000
                        mov edi,0xa0000
                        mov ecx,0x4000
                        rep stosd

                        mov eax,0x00000000
                        mov edi,BubbleBuffer
                        mov ecx,0x4000
                        rep stosd

                        xor al,al
.SetBlue                mov bl,0
                        mov cl,0
                        mov dl,al
                        call SetPalette
                        inc al
                        cmp al,0x40
                        jne .SetBlue

                        mov al,0x40
.SetWhite               mov bl,al
                        and bl,0x3f
                        mov cl,al
                        and cl,0x3f
                        mov dl,63
                        call SetPalette
                        inc al
                        cmp al,0x80
                        jne .SetWhite

                        mov al,0xa0
                        mov bl,0x3f
                        xor cl,cl
                        xor dl,dl
                        call SetPalette

DoMandelbrot            mov dword [DethTime],5

                        mov eax,0x7f7f7f7f
                        mov edi,BubbleBuffer
                        mov ecx,16000
                        rep stosd

                        mov edi,BubbleBuffer
                        xor eax,eax
                        mov ecx,80
                        rep stosd

                        mov edi,BubbleBuffer+320
                        mov ecx,80
                        rep stosd

                        mov edi,BubbleBuffer+199*320
                        mov ecx,80
                        rep stosd

                        mov edi,BubbleBuffer+198*320
                        mov ecx,80
                        rep stosd

                        mov edi,BubbleBuffer+197*320
                        mov ecx,80
                        rep stosd

                        mov edi,BubbleBuffer+196*320
                        mov ecx,80
                        rep stosd

                        mov edi,BubbleBuffer
                        mov ecx,199*320
.clearedgeloop          mov [edi+ecx],dword 0
                        mov [edi+ecx+1],dword 0
                        mov [edi+ecx+318],dword 0
                        mov [edi+ecx+319],dword 0
                        sub ecx,320
                        jnz .clearedgeloop

                        mov esi,BubbleBuffer
                        mov edi,0xa0000
                        mov ecx,16000
                        rep movsd

                        jmp FrameZero
ab                      mov dword [Tick],0

                        call GetRandom
                        cmp eax,0x4000000
                        ja .nostartjulia
                        
                        jmp DoJuliaSet

.nostartjulia           inc dword [FrameCount]
                        finit

                        ; think think think think
                        call GetRandom
                        cmp eax,0xa0000000
                        ja near .checkno
                        mov ecx,10000
                        mov ebp,0xffffffff
                        mov dword [HighestColor],0
                        mov dword [LowestColor],0xff
.thinkloop              dec ecx
                        jz near .thinkdone
                        call GetRandom
                        and eax,127
                        lea ebx,[eax+32]
                        call GetRandom
                        and eax,255
                        add eax,32
                        lea edx,[ebx+ebx*4]
                        shl edx,6
                        mov dl,[BubbleBuffer+edx+eax]
                        cmp dl,[LowestColor]
                        ja .nonewlow
                        mov [LowestColor],dl
.nonewlow               cmp dl,[HighestColor]
                        jb .nonewhigh
                        mov [HighestColor],dl
.nonewhigh              cmp dl,[TargetColor]
                        jb .ohhhh
                        sub dl,[TargetColor]
                        jmp .ahhhh

.ohhhh                  neg dl
                        add dl,[TargetColor]
.ahhhh                  movzx edx,dl
                        cmp edx,ebp
                        ja near .thinkloop
                        mov esi,eax
                        mov edi,ebx
                        mov ebp,edx
                        jmp .thinkloop

.thinkdone              cmp dword [DethTime],0
                        jne .nozoomoutnow

                        inc dword [DethTime]
                        mov eax,[HighestColor]
                        sub eax,[LowestColor]
                        cmp eax,3
                        ja .nozoomoutnow

                        fld qword [ExitSpeed]
                        fstp qword [ZoomInAmount]

.nozoomoutnow           dec dword [DethTime]
                        fld qword [ZoomInAmount]
                        fsub qword [EnterSpeed]
                        fstp qword [ZoomInAmount]

                        sub esi,160
                        jb .xisless
             
                        fld qword [XInc]
                        fld qword [MaxXSpeed]
                        fcomp st1
                        fstsw ax
                        sahf
                        jc .checky
                        fld qword [XAddFor]
                        faddp st1
                        fstp qword [XInc]
                        jmp .checky
             
.xisless                fld qword [XInc]
                        fld qword [MaxXSpeed]
                        fchs
                        fcomp st1
                        fstsw ax
                        sahf
                        jnc .checky
                        fld qword [XAddFor]
                        fsubp st1
                        fstp qword [XInc]
                        jmp .checky
             
.checky                 sub edi,100
                        ja .yisless
                     
                        fld qword [YInc]
                        fld qword [MaxYSpeed]
                        fcomp st1
                        fstsw ax
                        sahf
                        jc .checkno
                        fld qword [YAddFor]
                        faddp st1
                        fstp qword [YInc]
                        jmp .checkno
                     
.yisless                fld qword [YInc]
                        fld qword [MaxYSpeed]
                        fchs
                        fcomp st1 
                        fstsw ax
                        sahf
                        jnc .checkno
                        fld qword [YAddFor]
                        fsubp st1
                        fstp qword [YInc]

.checkno                fld qword [ViewSize]
                        fld1
                        fcompp
                        fstsw ax
                        sahf
                        jnc .nozoombackin

                        fld qword [ZoomInAmount]
                        fld qword [TooFast]
                        fcompp
                        fstsw ax
                        sahf
                        jnc .nozoombackin

                        fld qword [ZoomInAmount]
                        fld qword [ComeBackSpeed]
                        fsubp st1
                        fstp qword [ZoomInAmount]
                        
.nozoombackin           ; end end end end end end

                        fld qword [YPos]
                        fld qword [YInc]
                        fmul qword [ViewSize]
                        fsubp st1
                        fstp qword [YPos]

                        fld qword [XPos]
                        fld qword [XInc]
                        fmul qword [ViewSize]
                        faddp st1
                        fstp qword [XPos]

                        fld qword [ViewSize]
                        fmul qword [ZoomInAmount]
                        fstp qword [ViewSize]

FrameZero               and dword [FrameCount],3
                        cmp dword [FrameCount],0
                        jne near .donewithframe

                        mov edx,198
.nextrow                sub edx,2
                        jz near .donewithframe
                        mov ebx,318

                        ; translate pixel-Y to point-Y
                        mov [temp],edx
                        fild dword [temp]
                        fsub qword [halfy]
                        fmul qword [fourovery]
                        fmul qword [ViewSize]
                        fadd qword [YPos]

.nextpoint              sub ebx,2
                        jnz .notnextrow
                        fstp qword [temp]
                        jmp .nextrow
.notnextrow             mov ecx,127

                        ; translate pixel-X to point-X
                        mov [temp],ebx
                        fild dword [temp]
                        fsub qword [halfx]
                        fmul qword [fouroverx]
                        fmul qword [ViewSize]
                        fadd qword [XPos]

                        fld st1
                        fld st1

.testpointloop          ; ebx = pixel X we are testing
                        ; edx = pixel Y we are testing
                        ; st3 = imaginary part of number to test
                        ; st2 = real part of number to test
                        ; st1 = current-test-imaginary
                        ; st0 = current-test-real

                        ; get zi*zi
                        fld st1
                        fmul st0

                        ; get zr*zr
                        fld st1
                        fmul st0

                        ; get zr*zr - zi*zi + cr
                        fld st0
                        fsub st2
                        fadd st5

                        ; get 2*zr*zi + ci, update zi and zr
                        fld st4
                        fmul st4
                        fadd st0
                        fadd st7
                        fstp st5
                        fstp st3 

                        ; does zr*zr + zi*zi exceed 2, if so then
                        ; this point is not part of the mbrot-set.
                        faddp st1
                        fcomp qword [two]
                        fstsw ax
                        sahf
                        jc .nope

                        ; yes, so we are not part of the set...
                        lea esi,[edx+edx*4]
                        shl esi,6
                        add esi,ebx
                        neg ecx
                        add ecx,127
                        mov [BubbleBuffer+esi+321],cl
                        fstp qword [temp]
                        fstp qword [temp]
                        fstp qword [temp]
                        jmp .nextpoint

.nope                   dec ecx
                        jnz .testpointloop

                        ; this is part of the mbrot-set...
                        lea esi,[edx+edx*4]
                        shl esi,6
                        add esi,ebx
                        mov [BubbleBuffer+esi+321],byte 127
                        fstp qword [temp]
                        fstp qword [temp]
                        fstp qword [temp]
                        jmp .nextpoint

.donewithframe
FrameOne                cmp dword [FrameCount],1
                        jne near .donewithframe

                        mov edx,198
.nextrow                sub edx,2
                        jz near .donewithframe
                        mov ebx,317

                        ; translate pixel-Y to point-Y
                        mov [temp],edx
                        fild dword [temp]
                        fsub qword [halfy]
                        fmul qword [fourovery]
                        fmul qword [ViewSize]
                        fadd qword [YPos]

.nextpoint              sub ebx,2
                        ja .notnextrow
                        fstp qword [temp]
                        jmp .nextrow
.notnextrow             mov ecx,127

                        ; translate pixel-X to point-X
                        mov [temp],ebx
                        fild dword [temp]
                        fsub qword [halfx]
                        fmul qword [fouroverx]
                        fmul qword [ViewSize]
                        fadd qword [XPos]

                        fld st1
                        fld st1

.testpointloop          ; ebx = pixel X we are testing
                        ; edx = pixel Y we are testing
                        ; st3 = imaginary part of number to test
                        ; st2 = real part of number to test
                        ; st1 = current-test-imaginary
                        ; st0 = current-test-real

                        ; get zi*zi
                        fld st1
                        fmul st0

                        ; get zr*zr
                        fld st1
                        fmul st0

                        ; get zr*zr - zi*zi + cr
                        fld st0
                        fsub st2
                        fadd st5

                        ; get 2*zr*zi + ci, update zi and zr
                        fld st4
                        fmul st4
                        fadd st0
                        fadd st7
                        fstp st5
                        fstp st3 

                        ; does zr*zr + zi*zi exceed 2, if so then
                        ; this point is not part of the mbrot-set.
                        faddp st1
                        fcomp qword [two]
                        fstsw ax
                        sahf
                        jc .nope

                        ; yes, so we are not part of the set...
                        lea esi,[edx+edx*4]
                        shl esi,6
                        add esi,ebx
                        neg ecx
                        add ecx,127
                        mov [BubbleBuffer+esi+321],cl
                        fstp qword [temp]
                        fstp qword [temp]
                        fstp qword [temp]
                        jmp .nextpoint

.nope                   dec ecx
                        jnz .testpointloop

                        ; this is part of the mbrot-set...
                        lea esi,[edx+edx*4]
                        shl esi,6
                        add esi,ebx
                        mov [BubbleBuffer+esi+321],byte 127
                        fstp qword [temp]
                        fstp qword [temp]
                        fstp qword [temp]
                        jmp .nextpoint

.donewithframe
FrameTwo                cmp dword [FrameCount],2
                        jne near .donewithframe

                        mov edx,199
.nextrow                sub edx,2
                        jbe near .donewithframe
                        mov ebx,318

                        ; translate pixel-Y to point-Y
                        mov [temp],edx
                        fild dword [temp]
                        fsub qword [halfy]
                        fmul qword [fourovery]
                        fmul qword [ViewSize]
                        fadd qword [YPos]

.nextpoint              sub ebx,2
                        jnz .notnextrow
                        fstp qword [temp]
                        jmp .nextrow
.notnextrow             mov ecx,127

                        ; translate pixel-X to point-X
                        mov [temp],ebx
                        fild dword [temp]
                        fsub qword [halfx]
                        fmul qword [fouroverx]
                        fmul qword [ViewSize]
                        fadd qword [XPos]

                        fld st1
                        fld st1

.testpointloop          ; ebx = pixel X we are testing
                        ; edx = pixel Y we are testing
                        ; st3 = imaginary part of number to test
                        ; st2 = real part of number to test
                        ; st1 = current-test-imaginary
                        ; st0 = current-test-real

                        ; get zi*zi
                        fld st1
                        fmul st0

                        ; get zr*zr
                        fld st1
                        fmul st0

                        ; get zr*zr - zi*zi + cr
                        fld st0
                        fsub st2
                        fadd st5

                        ; get 2*zr*zi + ci, update zi and zr
                        fld st4
                        fmul st4
                        fadd st0
                        fadd st7
                        fstp st5
                        fstp st3 

                        ; does zr*zr + zi*zi exceed 2, if so then
                        ; this point is not part of the mbrot-set.
                        faddp st1
                        fcomp qword [two]
                        fstsw ax
                        sahf
                        jc .nope

                        ; yes, so we are not part of the set...
                        lea esi,[edx+edx*4]
                        shl esi,6
                        add esi,ebx
                        neg ecx
                        add ecx,127
                        mov [BubbleBuffer+esi+321],cl
                        fstp qword [temp]
                        fstp qword [temp]
                        fstp qword [temp]
                        jmp .nextpoint

.nope                   dec ecx
                        jnz .testpointloop

                        ; this is part of the mbrot-set...
                        lea esi,[edx+edx*4]
                        shl esi,6
                        add esi,ebx
                        mov [BubbleBuffer+esi+321],byte 127
                        fstp qword [temp]
                        fstp qword [temp]
                        fstp qword [temp]
                        jmp .nextpoint

.donewithframe
FrameThree              cmp dword [FrameCount],3
                        jne near .donewithframe

                        mov edx,199
.nextrow                sub edx,2
                        jbe near .donewithframe
                        mov ebx,319

                        ; translate pixel-Y to point-Y
                        mov [temp],edx
                        fild dword [temp]
                        fsub qword [halfy]
                        fmul qword [fourovery]
                        fmul qword [ViewSize]
                        fadd qword [YPos]

.nextpoint              sub ebx,2
                        ja .notnextrow
                        fstp qword [temp]
                        jmp .nextrow
.notnextrow             mov ecx,127

                        ; translate pixel-X to point-X
                        mov [temp],ebx
                        fild dword [temp]
                        fsub qword [halfx]
                        fmul qword [fouroverx]
                        fmul qword [ViewSize]
                        fadd qword [XPos]

                        fld st1
                        fld st1

.testpointloop          ; ebx = pixel X we are testing
                        ; edx = pixel Y we are testing
                        ; st3 = imaginary part of number to test
                        ; st2 = real part of number to test
                        ; st1 = current-test-imaginary
                        ; st0 = current-test-real

                        ; get zi*zi
                        fld st1
                        fmul st0

                        ; get zr*zr
                        fld st1
                        fmul st0

                        ; get zr*zr - zi*zi + cr
                        fld st0
                        fsub st2
                        fadd st5

                        ; get 2*zr*zi + ci, update zi and zr
                        fld st4
                        fmul st4
                        fadd st0
                        fadd st7
                        fstp st5
                        fstp st3 

                        ; does zr*zr + zi*zi exceed 2, if so then
                        ; this point is not part of the mbrot-set.
                        faddp st1
                        fcomp qword [two]
                        fstsw ax
                        sahf
                        jc .nope

                        ; yes, so we are not part of the set...
                        lea esi,[edx+edx*4]
                        shl esi,6
                        add esi,ebx
                        neg ecx
                        add ecx,127
                        mov [BubbleBuffer+esi+321],cl
                        fstp qword [temp]
                        fstp qword [temp]
                        fstp qword [temp]
                        jmp .nextpoint

.nope                   dec ecx
                        jnz .testpointloop

                        ; this is part of the mbrot-set...
                        lea esi,[edx+edx*4]
                        shl esi,6
                        add esi,ebx
                        mov [BubbleBuffer+esi+321],byte 127
                        fstp qword [temp]
                        fstp qword [temp]
                        fstp qword [temp]
                        jmp .nextpoint

.donewithframe          mov esi,BubbleBuffer+319
                        mov edi,0xa0000+319
                        mov edx,198
                        xor ecx,ecx
.smoothmore             mov ebx,318
                        add esi,2
                        add edi,2
.where                  xor eax,eax
                        mov al,[esi-320]
                        mov cl,[esi-1]
                        add eax,ecx
                        mov cl,[esi+1]
                        add eax,ecx
                        mov cl,[esi+320]
                        add eax,ecx
                        shl eax,1
                        mov cl,[esi-321]
                        add eax,ecx
                        mov cl,[esi-319]
                        add eax,ecx
                        mov cl,[esi+319]
                        add eax,ecx
                        mov cl,[esi+321]
                        add eax,ecx
                        mov cl,[esi]
                        lea eax,[eax+ecx*4]
                        shr eax,4
                        inc esi
                        stosb
                        dec ebx
                        jnz .where
                        dec edx
                        jnz .smoothmore

.waitfortick            cmp dword [Tick],0
                        je .waitfortick

                        jmp ab

DoJuliaSet              mov eax,0x7f7f7f7f
                        mov edi,BubbleBuffer
                        mov ecx,16000
                        rep stosd

                        mov edi,BubbleBuffer
                        xor eax,eax
                        mov ecx,80
                        rep stosd

                        mov edi,BubbleBuffer+320
                        mov ecx,80
                        rep stosd

                        mov edi,BubbleBuffer+199*320
                        mov ecx,80
                        rep stosd

                        mov edi,BubbleBuffer+198*320
                        mov ecx,80
                        rep stosd

                        mov edi,BubbleBuffer
                        mov ecx,199*320
.clearedgeloop          mov [edi+ecx],dword 0
                        mov [edi+ecx+316],dword 0
                        sub ecx,320
                        jnz .clearedgeloop

                        mov esi,BubbleBuffer
                        mov edi,0xa0000
                        mov ecx,16000
                        rep movsd

                        finit

                        call GetRandom
                        mov [temp],eax
                        fild dword [temp]
                        fdiv qword [TwoTo32nd]
                        fstp qword [JuliaBaseR]

                        call GetRandom
                        mov [temp],eax
                        fild dword [temp]
                        fdiv qword [TwoTo32nd]
                        fstp qword [JuliaBaseI]

                        call GetRandom
                        mov [temp],eax
                        fild dword [temp]
                        fdiv qword [TwoTo32nd]
                        fld st0
                        fmul qword [JuliaBaseR]
                        fldz
                        fcompp
                        fstsw ax
                        sahf
                        jc .nofix3
                        fchs
.nofix3                 fstp qword [JuliaTargetR]

                        call GetRandom
                        mov [temp],eax
                        fild dword [temp]
                        fdiv qword [TwoTo32nd]
                        fld st0
                        fmul qword [JuliaBaseI]
                        fldz
                        fcompp
                        fstsw ax
                        sahf
                        jnc .nofix4
                        fchs
.nofix4                 fstp qword [JuliaTargetI]

loopframes              mov dword [Tick],0

                        fld qword [JuliaBaseR]
                        fcom qword [JuliaTargetR]
                        fstsw ax
                        sahf
                        jnc .needtogoleft

                        fadd qword [JuliaMoveAmount]
                        fstp qword [JuliaBaseR]
                        jmp .testimaginary

.needtogoleft           fsub qword [JuliaMoveAmount]
                        fstp qword [JuliaBaseR]

.testimaginary          fld qword [JuliaBaseI]
                        fcom qword [JuliaTargetI]
                        fstsw ax
                        sahf
                        jnc .needtogoup

                        fadd qword [JuliaMoveAmount]
                        fstp qword [JuliaBaseI]
                        jmp .drawframe

.needtogoup             fsub qword [JuliaMoveAmount]
                        fstp qword [JuliaBaseI]

.drawframe              fld qword [JuliaBaseI]
                        fld qword [JuliaBaseR]
                        inc dword [FrameCount]

.arewethereyet          fld qword [JuliaBaseR]
                        fsub qword [JuliaTargetR]
                        fabs
                        fcomp qword [JuliaMoveAmount]
                        fstsw ax
                        sahf
                        jnc .nopenotthere

                        fld qword [JuliaBaseI]
                        fsub qword [JuliaTargetI]
                        fabs
                        fcomp qword [JuliaMoveAmount]
                        fstsw ax
                        sahf
                        jnc .nopenotthere

                        mov esi,0xa0000
                        mov edi,BubbleBuffer
                        mov ecx,16000
                        rep movsd

                        jmp DoMandelbrot

.nopenotthere
JFrameZero              and dword [FrameCount],3
                        cmp dword [FrameCount],0
                        jne near .donewithframe
                        mov edx,103
.nextrow                sub edx,2
                        jbe near .donewithframe
                        mov ebx,319

                        ; translate pixel-Y to point-Y
                        mov [temp],edx
                        fild dword [temp]
                        fsub qword [halfy]
                        fmul qword [fourovery]
                        fmul qword [InitJuliaVSize]
                        fstp qword [JuliaYPoint]

.nextpoint              sub ebx,2
                        ja .notnextrow
                        jmp .nextrow
.notnextrow             mov ecx,63

                        fld qword [JuliaYPoint]

                        ; translate pixel-X to point-X
                        mov [temp],ebx
                        fild dword [temp]
                        fsub qword [halfx]
                        fmul qword [fouroverx]
                        fmul qword [InitJuliaVSize]

.testpointloop          ; ebx = pixel x
                        ; edx = pixel y
                        ; st3 = Julia-base constant I
                        ; st2 = Julia-base constant R
                        ; st1 = current-test-imaginary
                        ; st0 = current-test-real

                        ; get zi*zi
                        fld st1
                        fmul st0

                        ; get zr*zr
                        fld st1
                        fmul st0

                        ; get zr*zr - zi*zi + cr
                        fld st0
                        fsub st2
                        fadd st5

                        ; get 2*zr*zi + ci, update zi and zr
                        fld st4
                        fmul st4
                        fadd st0
                        fadd st7
                        fstp st5
                        fstp st3 

                        ; does zr*zr + zi*zi exceed 2 (oops, 4), if so then
                        ; this point is not part of the julia-set.
                        faddp st1
                        fcomp qword [two]
                        fstsw ax
                        sahf
                        jc .nope

                        ; yes, so we are not part of the set...
                        lea esi,[edx+edx*4]
                        shl esi,6
                        add esi,ebx
                        neg ecx
                        add ecx,63
                        shl cl,1
                        mov [BubbleBuffer+esi+321],cl
                        fstp qword [temp]
                        fstp qword [temp]
                        jmp .nextpoint

.nope                   dec ecx
                        jnz .testpointloop

                        ; this is part of the julia-set...
                        lea esi,[edx+edx*4]
                        shl esi,6
                        add esi,ebx
                        mov [BubbleBuffer+esi+321],byte 127
                        fstp qword [temp]
                        fstp qword [temp]
                        jmp .nextpoint

.donewithframe
JFrameOne               and dword [FrameCount],3
                        cmp dword [FrameCount],1
                        jne near .donewithframe
                        mov edx,103
.nextrow                sub edx,2
                        jbe near .donewithframe
                        mov ebx,320

                        ; translate pixel-Y to point-Y
                        mov [temp],edx
                        fild dword [temp]
                        fsub qword [halfy]
                        fmul qword [fourovery]
                        fmul qword [InitJuliaVSize]
                        fstp qword [JuliaYPoint]

.nextpoint              sub ebx,2
                        ja .notnextrow
                        jmp .nextrow
.notnextrow             mov ecx,63

                        fld qword [JuliaYPoint]

                        ; translate pixel-X to point-X
                        mov [temp],ebx
                        fild dword [temp]
                        fsub qword [halfx]
                        fmul qword [fouroverx]
                        fmul qword [InitJuliaVSize]

.testpointloop          ; ebx = pixel x
                        ; edx = pixel y
                        ; st3 = Julia-base constant I
                        ; st2 = Julia-base constant R
                        ; st1 = current-test-imaginary
                        ; st0 = current-test-real

                        ; get zi*zi
                        fld st1
                        fmul st0

                        ; get zr*zr
                        fld st1
                        fmul st0

                        ; get zr*zr - zi*zi + cr
                        fld st0
                        fsub st2
                        fadd st5

                        ; get 2*zr*zi + ci, update zi and zr
                        fld st4
                        fmul st4
                        fadd st0
                        fadd st7
                        fstp st5
                        fstp st3 

                        ; does zr*zr + zi*zi exceed 2 (oops, 4), if so then
                        ; this point is not part of the julia-set.
                        faddp st1
                        fcomp qword [two]
                        fstsw ax
                        sahf
                        jc .nope

                        ; yes, so we are not part of the set...
                        lea esi,[edx+edx*4]
                        shl esi,6
                        add esi,ebx
                        neg ecx
                        add ecx,63
                        shl cl,1
                        mov [BubbleBuffer+esi+321],cl
                        fstp qword [temp]
                        fstp qword [temp]
                        jmp .nextpoint

.nope                   dec ecx
                        jnz .testpointloop

                        ; this is part of the julia-set...
                        lea esi,[edx+edx*4]
                        shl esi,6
                        add esi,ebx
                        mov [BubbleBuffer+esi+321],byte 127
                        fstp qword [temp]
                        fstp qword [temp]
                        jmp .nextpoint
.donewithframe
JFrameTwo               and dword [FrameCount],3
                        cmp dword [FrameCount],2
                        jne near .donewithframe
                        mov edx,104
.nextrow                sub edx,2
                        jbe near .donewithframe
                        mov ebx,319

                        ; translate pixel-Y to point-Y
                        mov [temp],edx
                        fild dword [temp]
                        fsub qword [halfy]
                        fmul qword [fourovery]
                        fmul qword [InitJuliaVSize]
                        fstp qword [JuliaYPoint]

.nextpoint              sub ebx,2
                        ja .notnextrow
                        jmp .nextrow
.notnextrow             mov ecx,63

                        fld qword [JuliaYPoint]

                        ; translate pixel-X to point-X
                        mov [temp],ebx
                        fild dword [temp]
                        fsub qword [halfx]
                        fmul qword [fouroverx]
                        fmul qword [InitJuliaVSize]

.testpointloop          ; ebx = pixel x
                        ; edx = pixel y
                        ; st3 = Julia-base constant I
                        ; st2 = Julia-base constant R
                        ; st1 = current-test-imaginary
                        ; st0 = current-test-real

                        ; get zi*zi
                        fld st1
                        fmul st0

                        ; get zr*zr
                        fld st1
                        fmul st0

                        ; get zr*zr - zi*zi + cr
                        fld st0
                        fsub st2
                        fadd st5

                        ; get 2*zr*zi + ci, update zi and zr
                        fld st4
                        fmul st4
                        fadd st0
                        fadd st7
                        fstp st5
                        fstp st3 

                        ; does zr*zr + zi*zi exceed 2 (oops, 4), if so then
                        ; this point is not part of the julia-set.
                        faddp st1
                        fcomp qword [two]
                        fstsw ax
                        sahf
                        jc .nope

                        ; yes, so we are not part of the set...
                        lea esi,[edx+edx*4]
                        shl esi,6
                        add esi,ebx
                        neg ecx
                        add ecx,63
                        shl cl,1
                        mov [BubbleBuffer+esi+321],cl
                        fstp qword [temp]
                        fstp qword [temp]
                        jmp .nextpoint

.nope                   dec ecx
                        jnz .testpointloop

                        ; this is part of the julia-set...
                        lea esi,[edx+edx*4]
                        shl esi,6
                        add esi,ebx
                        mov [BubbleBuffer+esi+321],byte 127
                        fstp qword [temp]
                        fstp qword [temp]
                        jmp .nextpoint
.donewithframe
JFrameThree             and dword [FrameCount],3
                        cmp dword [FrameCount],3
                        jne near .donewithframe
                        mov edx,104
.nextrow                sub edx,2
                        jbe near .donewithframe
                        mov ebx,320

                        ; translate pixel-Y to point-Y
                        mov [temp],edx
                        fild dword [temp]
                        fsub qword [halfy]
                        fmul qword [fourovery]
                        fmul qword [InitJuliaVSize]
                        fstp qword [JuliaYPoint]

.nextpoint              sub ebx,2
                        ja .notnextrow
                        jmp .nextrow
.notnextrow             mov ecx,63

                        fld qword [JuliaYPoint]

                        ; translate pixel-X to point-X
                        mov [temp],ebx
                        fild dword [temp]
                        fsub qword [halfx]
                        fmul qword [fouroverx]
                        fmul qword [InitJuliaVSize]

.testpointloop          ; ebx = pixel x
                        ; edx = pixel y
                        ; st3 = Julia-base constant I
                        ; st2 = Julia-base constant R
                        ; st1 = current-test-imaginary
                        ; st0 = current-test-real

                        ; get zi*zi
                        fld st1
                        fmul st0

                        ; get zr*zr
                        fld st1
                        fmul st0
  
                        ; get zr*zr - zi*zi + cr
                        fld st0
                        fsub st2
                        fadd st5

                        ; get 2*zr*zi + ci, update zi and zr
                        fld st4
                        fmul st4
                        fadd st0
                        fadd st7
                        fstp st5
                        fstp st3 

                        ; does zr*zr + zi*zi exceed 2 (oops, 4), if so then
                        ; this point is not part of the julia-set.
                        faddp st1
                        fcomp qword [two]
                        fstsw ax
                        sahf
                        jc .nope

                        ; yes, so we are not part of the set...
                        lea esi,[edx+edx*4]
                        shl esi,6
                        add esi,ebx
                        neg ecx
                        add ecx,63
                        shl cl,1
                        mov [BubbleBuffer+esi+321],cl
                        fstp qword [temp]
                        fstp qword [temp]
                        jmp .nextpoint

.nope                   dec ecx
                        jnz .testpointloop

                        ; this is part of the julia-set...
                        lea esi,[edx+edx*4]
                        shl esi,6
                        add esi,ebx
                        mov [BubbleBuffer+esi+321],byte 127
                        fstp qword [temp]
                        fstp qword [temp]
                        jmp .nextpoint

.donewithframe          fstp qword [temp]
                        fstp qword [temp]

                        mov edi,BubbleBuffer
                        xor eax,eax
                        mov ecx,80
                        rep stosd

                        mov edi,BubbleBuffer+199*320
                        mov ecx,80
                        rep stosd

                        mov edi,BubbleBuffer
                        mov ecx,199*320
.clearedgeloop          mov [edi+ecx],byte 0
                        mov [edi+ecx+1],byte 0
                        mov [edi+ecx+2],byte 0
                        mov [edi+ecx+3],byte 0
                        mov [edi+ecx+319],byte 0
                        sub ecx,320
                        jnz .clearedgeloop

                        mov esi,BubbleBuffer+319
                        mov edi,0xa0000+319
                        mov edx,100
                        xor ecx,ecx
.smoothmore             mov ebx,318
                        add esi,2
                        add edi,2
.where                  xor eax,eax
                        mov al,[esi-320]
                        mov cl,[esi-1]
                        add eax,ecx
                        mov cl,[esi+1]
                        add eax,ecx
                        mov cl,[esi+320]
                        add eax,ecx
                        shl eax,1
                        mov cl,[esi-321]
                        add eax,ecx
                        mov cl,[esi-319]
                        add eax,ecx
                        mov cl,[esi+319]
                        add eax,ecx
                        mov cl,[esi+321]
                        add eax,ecx
                        mov cl,[esi]
                        lea eax,[eax+ecx*4]
                        shr eax,4
                        inc esi
                        stosb
                        dec ebx
                        jnz .where
                        dec edx
                        jnz .smoothmore

                        sub esi,BubbleBuffer+2
                        add edi,3
.loopoze                mov eax,[0xa0000+esi]
                        bswap eax
                        stosd
                        sub esi,4
                        ja .loopoze

.waitfortick            cmp dword [Tick],0
                        je .waitfortick
                  
                        jmp loopframes

two                     dq 4.0
temp                    dq 0.0
halfx                   dq 160.0
fouroverx               dq 0.0150
halfy                   dq 100.0
fourovery               dq 0.02
XPos                    dq 0.0
YPos                    dq 0.0
ViewSize                dq 1.0
XInc                    dq 0.0
YInc                    dq 0.0
ZoomInAmount            dq 0.99
YUpLimit                dq -1.2
YDownLimit              dq 1.2
XRightLimit             dq 0.7
XLeftLimit              dq -2.0
ZoomInLimit             dq 0.0000000000000001
ZoomOutLimit            dq 1.0
XAddFor                 dq 0.005
MaxXSpeed               dq 0.02
YAddFor                 dq 0.005
MaxYSpeed               dq 0.02
EnterSpeed              dq 0.000005
ExitSpeed               dq 1.10
TooFast                 dq 0.99
ComeBackSpeed           dq 0.02
TargetColor             dd 64
FrameCount              dd 0
HighestColor            dd 0
LowestColor             dd 0
JuliaBaseR              dq 0.0
JuliaBaseI              dq 1.0
JuliaTargetR            dq -2.0
JuliaTargetI            dq -1.0
JuliaYPoint             dq 0.0
JuliaMoveAmount         dq 0.002
InitJuliaVSize          dq 0.60
TwoTo32nd               dq 2200000000.0        ; well, not exactly!
DethTime                dd 0
