// vaftre.c 11/2/1998 - Fractal tree rebounding form left to right

#include <conio.h>
#include <math.h>
#define NUMNODES 64

unsigned char virtual[320*200];

unsigned char pallette[]={0,0,0,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,
                          37,23,21,37,23,21,37,23,21,37,23,21,37,23,21,37,23,23,
                          43,19,31,50,16,44,56,12,63,63,6};

typedef struct {
        int             inistep;
        int             step;
        int             dir;
        float           x;
        float           y;
} PARTICLE;

PARTICLE node[NUMNODES];

/*
 * Function : ClearScreen
 * Purpose  : Clears the screen
 * Input    : Screen Pointer
 * Output   : Nothing
 */
void ClearScreen(unsigned char *buffer);
#pragma aux ClearScreen = \
    "mov    ecx,16000" \
    "cld" \
    "xor    eax,eax" \
    "rep    stosd" \
    parm [edi] \
    modify exact [eax ecx edi];

/*  
 * Function : PutVGA
 * Purpose  : Shows the virtual buffer to the screen
 * Input    : Screen Pointer
 * Output   : Nothing
 */
void PutVGA(unsigned char *buffer);
#pragma aux PutVGA = \
    "mov    edi,0xA0000" \
    "mov    ecx,16000" \
    "cld" \
    "rep    movsd" \
    parm [esi] \
    modify exact [ecx esi edi];

/*
 * Function : SetMode
 * Purpose  : Sets video mode
 * Input    : Mode 
 * Output   : Nothing
 */
void SetMode(int mode);
#pragma aux SetMode = \
    "int    10h" \
    parm [eax] \
    modify exact [eax];

/*
 * Function : SetPal
 * Purpose  : Sets pallette to VGA
 * Input    : pallette pointer
 * Output   : Nothing
 */
void SetPal(unsigned char *buffer);
#pragma aux SetPal = \
    "mov     ecx,768" \
    "xor     eax,eax" \
    "mov     edx,0x3c8" \
    "out     dx,al" \
    "inc     dx" \
    "rep     outsb" \
    "mov     dx,0x3DA" \
    parm [esi] \
    modify exact [ecx eax edx esi];

/*
 * Function : MakeFractal
 * Purpose  : All the work
 * Input    : node pointer, bend angle, screen pointer 
 * Output   : Nothing
 */
void MakeFractal(PARTICLE *node, int angle, unsigned char *virtual)
{
 unsigned char color;
 int curnode,newnode;
 int i,x,y;

 curnode = newnode = color = 0;

       while (newnode<NUMNODES)
        {
            curnode = newnode;

            for (i=0;i<=curnode;i++)
             {
              /* calculate new position of the particle*/
              
              node[i].x  -= cos((node[i].dir * 3.141592)/180);
              node[i].y  -= sin((node[i].dir * 3.141592)/180);

              if(node[i].step>0) node[i].step --;
              else 
               {
                /* Change direction and steps of the current particle */
                
                node[i].dir     = node[i].dir + angle;
                node[i].inistep = node[i].inistep * 2 / 3;
                node[i].step    = node[i].inistep;

                /* Create a new particle */
                
                newnode++;
                if(newnode<NUMNODES) 
                 {
                   node[newnode].x   = node[i].x;
                   node[newnode].y   = node[i].y;
                   node[newnode].dir = node[i].dir + 45;
                   node[newnode].inistep = node[newnode].step = node[i].inistep;
                 }
               }

              x = node[i].x;
              y = node[i].y;
              
              /* Display the current position of the node */ 
              if(x>0 && x<320 && y>0 && y<200) virtual[y*320+x] = color;

             }
            
            color++;
        }
}

void main()
{
 int angle,i;

 cprintf("An example of fractal tree rebounding form left to right !\r\n");
 cprintf("Written by Ivan Daunis <slavinsky@ica.es> '98\r\n");
 cprintf("Press any key ...\r\n");
 getch();
 
 SetMode(0x13);
 SetPal(pallette);

 angle = -90;
 i = 2;

 while(!kbhit())
  {
       ClearScreen(virtual);
       
       /* Inicialitze the first particle
          at the bottom of the screen */
       
       node[0].inistep = node[0].step = 60;
       node[0].x       = 160;
       node[0].y       = 190;
       node[0].dir     = 90;
       
       MakeFractal(node,angle,virtual);
       
       PutVGA(virtual);
       
       angle += i;
       if(angle<-60) i = 2;
       if(angle>15)  i =-2;
  }
 if(getch()==0) getch();
 
 SetMode(0x3);
}
