(*
Lenzing, fading, 32-bit asm, and pcx demo.
This effect demo has been laying around for half
a year and I've finally got around to releasing
it.  Some of it's even commented. :>  The pcx
routines are in pcx.pas which should be
included. If you have a comment, question,
flame, death threat, etc...
Just send it my way via email.

Greets to:
Fellow OutWorlders Decker, Darius, and Belgarion
Karma
Hmaon/Xylme
Cam/Xylme

	ColdStar/Outworlders
	jonnagy@usa.net
*)
{$A+}{$E-}{$G+}{$I-}{$N+}{$Q-}{$R-}{$S-}

USES pcx,crt;
{ GFXx not used because it contains a flaw in the cls32 and sucks in other
	ways. }

CONST
	vidseg:word = $A000;
	MaxDiameter = 96;

TYPE
	Virtual 		= Array [1..64000] of byte;  { The size of the Virtual Screen }
	VirtPtr 		= ^Virtual;                  { Pointer to the virtual screen }
	PalArray		= ARRAY[0..767] of byte;
	TransArray	= ARRAY[0..MaxDiameter*MaxDiameter-1] OF word;
	LenzArray		= ARRAY[0..MaxDiameter*MaxDiameter-1] OF byte;

VAR
	Image 			: VirtPtr;
	ImageSeg		: word;					{ Unfaded background-what you see thru lenz }
	VirScreen		: VirtPtr;
	VirSeg 			: word;         { Fadable background-what you mostly see }
	Palette   	: PalArray;
	FadeDone,
	delaylength,
	e,f,
	g,h,i				: byte;		{ List of anonymouse variables, screw good style }
	xpos,
	ypos				: word;
	xdir,
	ydir		 		: longint;
	ch					: char;

	Scr_Ofs 	: Array[0..199] of Word;	{ Screen offsets according to y value }
	Diameter,
	MagFactor	: word;										{ Lenz Stuff }
	Transformer : TransArray;						{ Lenz Arrays. }
	LenzMask,
	TempTrans,                          { Yes, i do need them all. }
	PutTrans,
	SaveTrans		: LenzArray;

{}

Procedure SetMCGA;ASSEMBLER;  { This procedure gets you into 320x200x256 mode. }
ASM
		 mov        ax,0013h
		 int        10h
END;

{}
Procedure SetText;ASSEMBLER;  { This procedure returns you to text mode.  }
ASM
		 mov        ax,0003h
		 int        10h
END;

{}
Procedure SetUpVirtual(VAR SegPtr:VirtPtr; VAR VirtualSeg:word);
	 { This sets up the memory needed for the virtual screen }
BEGIN
	GetMem (segptr,64000);
	virtualseg := seg (segptr^);
END;

{}
Procedure ShutDown(VAR SegPtr:VirtPtr);
	 { This frees the memory used by the virtual screen }
BEGIN
	FreeMem (SegPtr,64000);
END;

{}

PROCEDURE SetupScreenTable;
VAR Loop1:word;
BEGIN
	For Loop1 := 0 to 199 do
		Scr_Ofs[Loop1] := Loop1 * 320;
END;

{}
PROCEDURE Cls(Where : Word; Col : Byte); ASSEMBLER;
ASM
	 push es
	 mov  cx, (320 * 200) / 4
	 mov  es, [where]
	 xor  di, di
	 mov  al, [col]
	 mov  ah, al
	 mov	bx, ax
	 db		66h,0C1h,0E0h,10h (* shl eax, 16 *)
												(* sets the upper word to ax and sets the lower
													 word to zero *)
	 mov	ax, bx					(* Sets the lower word back *)
	 db   $f3, $66, $ab  (* rep stosd *)
	 pop  es
END;

{}

PROCEDURE Flip(Source, Dest : Word); ASSEMBLER;
ASM
	 push ds
	 mov  ax, [dest]
	 mov  es, ax
	 mov  ax, [source]
	 mov  ds, ax
	 xor  si, si
	 xor  di, di
	 mov  cx, (320 * 200) / 4
	 db   $f3, $66, $a5  (* rep movsd *)
	 pop  ds
END;

{}
Procedure SetColor(Col,Red,Green,Blue : Byte); assembler;
	{ This sets the Red, Green and Blue values of a certain color }
asm
	 mov    dx,3c8h
	 mov    al,col
	 out    dx,al
	 inc    dx
	 mov    al,Red
	 out    dx,al
	 mov    al,Green
	 out    dx,al
	 mov    al,Blue
	 out    dx,al
end;

{}
Procedure GetColor(Col : Byte; VAR Red,Green,Blue : byte);
VAR
	rr,gg,bb:byte;
	{ This gets the Red, Green and Blue values of a certain color }
BEGIN
	ASM
			mov    dx,3c7h
			mov    al,col
			out    dx,al

			add    dx,2

			in     al,dx
			mov    rr, al
			in     al,dx
			mov    gg, al
			in     al,dx
			mov    bb, al
	END;
	Red := rr;
	Green := gg;
	Blue := bb;
END;

{}

PROCEDURE GrabPal(VAR Palette:PalArray);
VAR
	color:byte;
	index:word;
BEGIN
	color := 0;
	index	:= 0;
	WHILE index <> 768 DO
		BEGIN
			GetColor(color,Palette[index],Palette[index+1],Palette[index+2]);
			inc(index,3);
			inc(color);
		END;
END;

{}

PROCEDURE PutPal(VAR Palette:PalArray);
VAR
	color:byte;
	index:word;
BEGIN
	color := 0;
	index	:= 0;
	WHILE index <> 768 DO
		BEGIN
			SetColor(color,Palette[index],Palette[index+1],Palette[index+2]);
			inc(index,3);
			inc(color);
		END;
END;

{}

PROCEDURE BlackOutScreen(color,lastcolor:byte);
{ Simple changing all colors in palette to black. }
VAR
	red,green,blue,change:byte;
BEGIN
	REPEAT
		SetColor(color,0,0,0);
		inc(color);
	UNTIL color = LastColor;
END;

{}

PROCEDURE FadeScreenBlack(color,lastcolor,Mag: byte;VAR Done:byte);
{ Incremental fading of palette entries [color] to [lastcolor].  When
	all palette entries have reached zero, Done is returned with value 0. }
VAR
	red,green,blue,change:byte;
BEGIN
	change := 1;
	REPEAT
		GetColor(color,red,green,blue);
		ASM
			mov		al, Mag
			sub		red, al
			jnc		@redchanged

			mov		red, 0
			jmp		@redzero
@redchanged:
			mov		change, 0
@redzero:
			sub		green, al
			jnc		@greenchanged

			mov		green, 0
			jmp		@greenzero
@greenchanged:
			mov		change, 0
@greenzero:
			sub		blue, al
			jnc		@bluechanged

			mov		blue, 0
			jmp		@bluezero
@bluechanged:
			mov		change, 0
@bluezero:
		END;
		SetColor(color,red,green,blue);
		inc(color);
	UNTIL color = LastColor;
	done := change;
END;

{}

PROCEDURE FadeScreenUp(VAR Palette:PalArray;color,lastcolor,Mag: byte;VAR Done:byte);
{ Increamental fading up.  Done is 0 when all colors are there true value. }
VAR
	red,green,blue,change:byte;
	PalOffset : word;
BEGIN
	change := 1;
	PalOffset := ofs(Palette) + color * 3;
	REPEAT
		GetColor(color,red,green,blue);
		ASM
			mov		di, PalOffset
			mov		al, Mag
			add		red, al
			mov		ah, [di]
			cmp		red, ah
			jl		@redchanged

			mov		red, ah
			jmp		@redzero
@redchanged:
			mov		change, 0
@redzero:
			add		green, al
			mov		ah, [di+1]
			cmp		green, ah
			jl		@greenchanged

			mov		green, ah
			jmp		@greenzero
@greenchanged:
			mov		change, 0
@greenzero:
			add		blue, al
			mov		ah, [di+2]
			cmp		blue, ah
			jl		@bluechanged

			mov		blue, ah
			jmp		@bluezero
@bluechanged:
			mov		change, 0
@bluezero:
			add		di, 3
			mov		PalOffset, di
		END;
		SetColor(color,red,green,blue);
		inc(color);
	UNTIL color = LastColor;
	done := change;
END;

{}

PROCEDURE MakeLenz(Diameter,MagFactor:word);
{ Makes cool magnifying lenz. }
VAR
	r,m,y,
	x,a,b : integer;
	s,z		: real;
BEGIN
	r := Diameter DIV 2;
	s := sqrt(r*r-MagFactor*MagFactor);
	FOR y := -r TO r-1 DO
		BEGIN
			FOR x := -r TO r-1 DO
				BEGIN
					IF (x*x + y*y) >= s*s THEN
						BEGIN
							a := x;
							b := y;
						END
					ELSE
						BEGIN
							z := sqrt(r*r - x*x - y*y);
							a := round(x * MagFactor / real(z));
							b := round(y * MagFactor / real(z));
						END;
					TransFormer[((y+r)*Diameter + (x+r))] := word((r+b)*Diameter + (r+a));
				END;
		END;
END;

{}

PROCEDURE MakeUpSideDown(Diameter:word);ASSEMBLER;
{ Creates a lenz that makes what's in the lenz to be upsidedown. }
ASM
	mov		di, offset TransFormer
	mov		cx, Diameter
	mov		ax, cx
	inc		ax
	mul		cx
	mov		bx, ax
	mov		si, cx
@SetupUSDTransLoop:
	sub		bx, si
	sub		bx, si
	jc		@EndUSDLoop
	mov		cx, si
@MainUSDLoop:
	mov		[di], bx
	add		di, 2
	inc		bx
	dec		cx
	jnz		@MainUSDLoop

	jmp		@SetupUSDTransLoop

@EndUSDLoop:
END;

{}

PROCEDURE MakeReverse(Diameter:word);ASSEMBLER;
{ Reverses whatever's in the lenz.  Very basic. }
ASM
	mov		di, offset TransFormer
	mov		cx, Diameter
	mov		bx, cx
	mov		dx, cx
	mov		si, cx
@MainRevLoop:
	dec		bx
	mov		[di], bx
	add		di, 2
	dec		si
	jnz		@MainRevLoop

	mov		si, cx
	add		bx, cx
	add		bx, cx
	dec		dx
	jnz		@MainRevLoop
END;

{}

PROCEDURE MakeNothing(Diameter:word);ASSEMBLER;
{ This lenz causes no change.  Only useful because we have the background
	fading. 	This is like a spotlight through the fading. }
ASM
	mov		di, offset TransFormer
	mov		cx, Diameter
	mov		dx, cx
	xor		bx, bx
@MakeNothingLoop:
	mov		si, cx
@MainNothingLoop:
	mov		[di], bx
	add		di, 2
	inc		bx
	dec   si
	jnz		@MainNothingLoop
	dec		dx
	jnz		@MakeNothingLoop
END;

{}

PROCEDURE DoTransformation;ASSEMBLER;
{ Uses transformer array to modify SaveTrans and save modification to
	PutTrans. }
ASM
	push	bp
	mov		si, offset SaveTrans
	mov		di, offset PutTrans
	mov		bp, offset TransFormer
	mov		cx, Diameter
	mov		ax, cx
	mul		cx
	mov		cx, ax
@RancDinky:
	mov		bx, ds:[bp]
	mov		al, [si+bx]
	mov		[di], al
	inc		di
	add		bp, 2
	dec		cx
	jnz		@RancDinky
	pop		bp
END;

{}

PROCEDURE SaveLenz(Lenx, Leny:word;LenzOff:word;srcseg:word);ASSEMBLER;
{ Saves area of srcseg at (lenx,leny) to lenz at lenzoff. }
ASM
	push	bp
	mov		ax, ds
	mov		es, ax
	mov		di, LenzOff
	mov		bx, Leny
	shl		bx, 1
	mov 	si, word ptr [Scr_Ofs + bx]
	add 	si, Lenx
	mov		ds, srcseg
	mov		bp, es:Diameter
	mov		bx, 320
	sub		bx, bp
	mov		dx, bp
@SaveLoop:
	mov		cx, bp
	shr		cx, 2
	db   	0F3h, 66h, 0A5h  (* rep movsd *)
	add		si, bx
	dec		dx
	jnz		@SaveLoop
	mov		ax, es
	mov		ds, ax
	pop		bp
END;

{}

PROCEDURE DrawLenz(Lenx, Leny:word;LenzOff:word;srcseg:word);ASSEMBLER;
{ Draws lenz at offset lenzoff to srcseg segment at position (lenx,leny). }
ASM
	push	bp
	mov		si, LenzOff
	mov		es, srcseg
	mov		bx, Leny
	shl		bx, 1
	mov 	di, word ptr [Scr_Ofs + bx]
	add 	di, Lenx
	mov		bp, Diameter
	mov		bx, 320
	sub		bx, bp
	mov		dx, bp
	shr		bp, 2
@DrawLoop:
	mov		cx, bp
	db   	0F3h, 66h, 0A5h  (* rep movsd *)
	add		di, bx
	dec		dx
	jnz		@DrawLoop
	pop		bp
END;

{}

procedure WaitRetrace; assembler;
	{  This waits for a vertical retrace to reduce snow on the screen }
label
	l1, l2;
asm
		mov dx,3DAh
l1:
		in al,dx
		and al,08h
		jnz l1
l2:
		in al,dx
		and al,08h
		jz  l2
end;

PROCEDURE WierdFlip(Source, Dest : Word); ASSEMBLER;
{ This thing reads in 4 bytes and adds 128 to all of them, thereby making
	the bytes use the faded palette.  Then it puts the 4 to dest segment.
	We have a virtual screen that fades. }
ASM
	push	ds
	mov 	ax, dest
	mov 	es, ax
	mov 	ax, source
	mov 	ds, ax
	xor 	si, si
	xor 	di, di
	mov 	cx, (320 * 200) / 4
{	mov		ebx, 80808080h}
	db		66h,0BBh,80h,80h,80h,80h
@WierdCopyLoop:
{	lodsd}
	db		66h,0ADh
{	add		eax, ebx}
	db		66h,03h,0C3h
{	stosd}
	db		66h,0ABh
	loop	@WierdCopyLoop
	pop		ds
END;

PROCEDURE MovePartialPal(source,dest,numcolors:byte);
{ Moves numcolors colors from palette position source to palette
	position dest. }
VAR
	red,blue,green:byte;
BEGIN
	WHILE numcolors <> 0 DO
		BEGIN
			GetColor(source,red,green,blue);
			inc(source);
			SetColor(dest,red,green,blue);
			inc(dest);
			dec(numcolors);
		END;
END;

PROCEDURE MakeLenzMask(Diameter,MagFactor:word);
{ Makes an array of 0's and 1's the size of a lenz in the pattern of a circle.
	This mask tells MaskedDrawLenz to draw the lenzs as a circle. Lenzs are
	really square in memory. }
VAR
	realrad,rad,index:word;
	xindex,yindex:integer;
BEGIN
	realrad := Diameter DIV 2;
	rad := (Diameter-(MagFactor DIV 2)) DIV 2;
	index := 0;
	FOR yindex := 0 TO Diameter-1 DO
		FOR xindex := 0 TO Diameter-1 DO
			BEGIN
				IF sqr(xindex-realrad)+sqr(yindex-realrad) < rad*rad THEN
					LenzMask[index] := 1
				ELSE
					LenzMask[index] := 0;
				inc(index);
			END;
END;

PROCEDURE DrawMaskedLenz(Lenx, Leny:word;srcseg:word);ASSEMBLER;
{ Draws PutLenz to segment srcseg at (lenx,leny). }
ASM
	push	bp
	xor		si, si
	mov		es, srcseg
	mov		bx, Leny
	shl		bx, 1
	mov 	di, word ptr [Scr_Ofs + bx]
	add 	di, Lenx
	mov		bp, Diameter
	mov		bx, 320
	sub		bx, bp
	mov		dx, bp
@DrawMaskedLoop:
	mov		cx, bp
@MainMaskedDrawLoop:
	cmp		byte ptr [LenzMask+si], 0
	je		@PixelMaskedOut
	mov		al, byte ptr [PutTrans+si]
	mov		es:[di], al
@PixelMaskedOut:
	inc		si
	inc		di
	loop	@MainMaskedDrawLoop
	add		di, bx
	dec		dx
	jnz		@DrawMaskedLoop
	pop		bp
END;

PROCEDURE StartScreen;
{ Start screen text.  Unexciting mode 3 text, with a nice fade in and out. }
BEGIN
	GrabPal(Palette);
	waitretrace;
	clrscr;
	BlackOutScreen(0,0);
	textcolor(7);
	writeln('This is Coldstar of the Outworlders with a combo fading');
	writeln('and lenzing effect.');
	write('Use ');
	textcolor(15);
	write('''+''');
	textcolor(7);
	write(' and ');
	textcolor(15);
	write('''-''');
	textcolor(7);
	writeln(' keys to control the speed.');
	writeln('Also, you can press the space bar to toggle lenz methods');
	write('and press ');
	textcolor(15);
	write('''\''');
	textcolor(7);
	writeln(' to halt the lenz.  When it''s stoped you');
	writeln('can use the arrow keys to move it around.');
	REPEAT
		waitretrace;
		delay(8);
		FadeScreenUp(Palette,0,0,1,FadeDone);
	UNTIL FadeDone = 1;
	readkey;
	REPEAT
		waitretrace;
		delay(8);
		FadeScreenBlack(0,0,1,FadeDone);
	UNTIL FadeDone = 1;
END;

BEGIN
	StartScreen;
	SetupVirtual(Image,ImageSeg);
	SetupVirtual(VirScreen,VirSeg);
	SetMcga;
	SetupScreenTable;
{ Note: A Standard pcx is used, but the pcx's palette was set to 128
		using PaintShop pro.  That resampled the palette so the picture only
		uses 128 colors and left the other 128 free for the fading routine. }
	LoadPcx('halfpal.pcx',imageseg,0);
	MovePartialPal(0,128,128);
	GrabPal(Palette);
	WierdFlip(imageseg,virseg);
	Diameter := MaxDiameter;
	MagFactor := 24;
	MakeNothing(Diameter);
	MakeLenzMask(Diameter,MagFactor);
	xdir := 3;
	xpos := 2;
	ydir := 1;
	ypos := 18;
	delaylength := 0;
	e := 0;
	f := 0;
	h := 0;
	ch := #0;
	REPEAT
		SaveLenz(xpos,ypos,ofs(TempTrans),virseg);		{ Save faded background. }
		SaveLenz(xpos,ypos,ofs(SaveTrans),imageseg);	{ Load unfaded 96x96 box. }
		DoTransFormation;															{ Err, do transformation. }
		DrawMaskedLenz(xpos,ypos,virseg);							{ Put unfaded lenz to }
																									{ faded background. }
		waitretrace;
		Flip(virseg,vidseg);														{ Flip background with }
		IF h = 0 THEN																		{ lenz to screen. }
			FadeScreenBlack(128,0,1,FadeDone)
		ELSE
			FadeScreenUp(Palette,128,0,1,FadeDone);
		IF FadeDone = 1 THEN IF h <> 0 THEN h := 0 ELSE h := 1;
		DrawLenz(xpos,ypos,ofs(TempTrans),virseg);	{ Put back faded background }
		IF e = 0 THEN																{ where lenz is. }
			BEGIN
				xpos := xpos + xdir;
				IF (xpos >= 319-diameter) OR (xpos <= 0) THEN
					xdir := -xdir;
				inc(ydir); 							{ Funky thing to make bouncy }
				ypos := ypos + ydir;
				IF (ypos >= 199-diameter) OR (ypos <= 0) THEN
					BEGIN
						ydir := -ydir;
						dec(ydir);
					END;
			END;
		WHILE keypressed DO
			BEGIN
				ch := readkey;
			{ This is kinda cool.  When you hit an arrow key, you get a 0 and then
				the actual arrow scancode. This checks for 0 and reads the arrow
				key pressed. }
				IF ch = #0 THEN
					BEGIN
						ch := readkey;
						CASE ch OF
{up arrow}		#72: IF ypos <> 0 THEN ypos := ypos - 1;
{down arrow}	#80: IF ypos < 199-Diameter THEN ypos := ypos + 1;
{left arrow}	#75: IF xpos <> 0 THEN xpos := xpos - 1;
{right arrow}	#77: IF xpos < 319-Diameter THEN xpos := xpos + 1;
						END;
					END;
				CASE ch OF
					'=','+': IF delaylength > 0 THEN delaylength := delaylength - 1;
					'-': IF delaylength < 100 THEN delaylength := delaylength + 1;
					'\': IF e <> 1 THEN e := 1 ELSE e := 0;
					' ':
						BEGIN
							IF f <> 3 THEN inc(f) ELSE f := 0;
							CASE f OF
								0: MakeNothing(Diameter);
								1: MakeReverse(Diameter);
								2: MakeUpSideDown(Diameter);
								3: MakeLenz(Diameter,MagFactor);
							END;
						END;
				END;
			END;
		delay(delaylength);
	UNTIL ch = #27;
	Shutdown(Image);
	Shutdown(VirScreen);
	SetText;
END.
