;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; palette resampler - By Jason Nunn(JsNO)/SuperReal & Hornet - Nov 95     ;
; Uses DOS32V32       (jsno@turtle.apana.org.au)                          ;
;                                                                         ;
; Written for my Litchfield park piccys ;) (NB/this is a very quick hack) ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ideal
p386
model flat
stack 1000h
codeseg

extrn debug           : near
Zero_Addr             dd ?
Environment_Address   dd ?
PSP_Address           dd ?
_0B8000h              dd ?
_0A0000h              dd ?

filename_in           db "in.vga",0
filename_out          db "out.vga",0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;esi = offset to palette
;ecx = number of color values to write
;al = starting palette register
MACRO @WritePalette
  cli
  mov    edx,03c8h
  out    dx,al
  inc    edx
  rep    outsb
  sti
ENDM

proc display_pic
  mov    eax,3d00h
  int    21h
  jc     @@fileerror
  mov    ebx,eax
  mov    eax,4202h
  xor    edx,edx
  int    21h
  push   eax eax
  mov    eax,4200h
  xor    edx,edx
  int    21h
  pop    edx
  mov    eax,0EE42h
  Int    31h
  mov    esi,edx
  mov    ah,3fh
  pop    ecx
  int    21h
  push   eax
  mov    ah,3eh
  int    21h
  pop    edx
  sub    edx,768
  add    edx,esi

  mov    eax,13h
  int    10h

  mov    ecx,64000/4
  mov    edi,[_0A0000h]
  add    esi,4
@@l:
  mov    eax,[esi]
  mov    [edi],eax
  add    esi,4
  add    edi,4
  dec    ecx
  jnz    @@l

  mov    esi,edx
  mov    ecx,256*3
  xor    al,al
  @WritePalette

  mov    eax,0EE40h
  int    31h

  call   get_key

  mov    eax,3h
  int    10h
  clc
@@fileerror:
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc key_pressed2
  push   esi
  mov    esi,[Zero_Addr]
  add    esi,41ah
  mov    ax,[esi]
  cmp    ax,[word esi+2]
  jne    @@l
  pop    esi
  clc
  ret
@@l:
  movzx  eax,ax
  add    eax,400h
  add    eax,[Zero_Addr]
  mov    ax,[word eax]
  pop    esi
  stc
  ret
endp

last_get_key          db ?

proc get_key
@@l:
  call   key_pressed2
  jnc    @@l
  mov    eax,0
  int    16h
  mov    [last_get_key],al
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Start:
;  call   debug
  cld
  mov    ax,0EE02h       ; get DOS32 address information
  int    31h
  neg    ebx
  mov    [Zero_Addr],ebx
  add    ebx,0A0000h
  mov    [_0A0000h],ebx
  add    ebx,0B8000h-0A0000h
  mov    [_0B8000h],ebx
  mov    [Environment_Address],edi
  mov    [PSP_Address],esi

  mov    edx,offset filename_in
  call   display_pic
  mov    edx,offset filename_out
  call   display_pic

  mov    eax,4c00h
  int    21h
ends

end Start
