/************************************************************************
 *                                                                      *
 *    PlasmDat.C     Generate palette, movement, random data file for   *
 *                         TomsPlas (TPlas.ASM)                        	*
 *                                                                      *
 *		An FPU helps a *lot* on this!  But it's acceptably fast on a		*
 *				386sx-16, given the fact that it need only be run on  		*
 *				average once every 32,000 runs or so of tplas.com.				*
 *                                                                      *
 *		This is revision 1.1 of the data file generator.  It is *NOT*		*
 *				compatible with earlier versions of tplas!  If your version	*
 *				of tplas.com is later than revision 1.1, check the tplas		*
 *				manual to see if this revision of the data file is still		*
 *				applicable!																	*
 *                                                                      *
 ************************************************************************/

#define XDIM   320      /*  change if we change tplas.asm  */
#define VER		1.1

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

/*****  Function Prototypes for C:\PLASDAT.C  *****/
void  main(void);


void  main(void)
	{
	signed int i;
	unsigned int rval;
	long unsigned count;
	int   lead,offset;
	FILE  *fp;

	printf("\nTom's Plasma Data Generation, (C) Tom Dibble 1994\n");
	printf("\tRevision %1.1g\n\n",VER);

	if (!(fp=fopen("TOMSPLASM.DAT","wb")))
		{
		printf("\7Cant open output file TOMSPLASM.DAT\n");
		exit(-1);
		}

	/*  Arbitrary movement for two pointers  */
	/*  Size is 10000*4 = 40,000 bytes  */
	/*  These pointers are the offset from (0,0) on the main function
				from which each of the two overlaid screens is taken.
				The first term defines how the screen is moving horizontally,
				the second how it is moving vertically.  Make sure neither of
				these values is ever negative!  */
	/*  The 'offset' value has the 'lead' value subtracted from it.  I don't
				know why...  */
	/*  Finally, the numbers.  In the term '60+59*cos(...)', the cos()
				term varies between -1 and 1.  Therefore, the whole term
				varies between 1 and 119.  This means that the first
				pixel horizontally are never shown, but the other edge is
				never overrun either.  The 'y' term of this varies
				between 1 and 99.  The last five pixels vertically are
				never shown.  I don't know why this is.

				The numbers themselves ...  changing the numbers within
				the sin() and cos() functions will make the picture
				wobble more (with lower numbers) or less (higher
				numbers).

				Putting more of a difference in the two numbers will
				make the screen change more drastically with each
				update.

            */

   printf("\n\tGenerating Movement Pointers \t==========\b\b\b\b\b\b\b\b\b\b");
   for (count=0;count<10000;count++)
      {
      if(count%1000 == 999)
         printf(">");   /*  ten dots  */

      lead=           60+59.0*cos((double)count/32)
			  +XDIM*(int)(50+49*sin((double)count/16));
      offset=         60+59.0*sin((double)count/21)
			  +XDIM*(int)(50+49*cos((double)count/24))
           -lead;
      fwrite(&lead,2,1,fp);
      fwrite(&offset,2,1,fp);
      }

	/*  And a smooth transition colour lookup table */
	/*  Size is (256*4)*3 =3,072 bytes  */

	printf("\n\tGenerating Color Palette \t==========\b\b\b\b\b\b\b\b\b\b");
	for (i=0; i<256*4; i++)
		{
		if( (i%(102)) == (102)-1)
			printf(">");

		fputc((sin((double)i/20)*sin((double)i/15)*31+31),fp);
		fputc((sin((double)i/35)*sin((double)i/22)*31+31),fp);
		fputc((sin((double)i/13)*sin((double)i/30)*31+31),fp);
		}

	/*  Finally, 64k of random numbers.  */
	randomize();
	printf("\n\tAnd now, Random Values \t\t==========\b\b\b\b\b\b\b\b\b\b");
	for (count=0; count < 0x8000 ; count++)
		{
		if( (count % 3276) == 3275)
			printf(">");   /*  ten dots  */
		rval=rand();
		fwrite(&rval,2,1,fp);
		}

	fclose(fp);
	printf("\nNow, that wasn't so bad ...  was it?\n");
	}

