

;*************************
pile   segment  para stack 'pile'
       dw 256 dup(0)
pile   ends
;*************************

;*************************
donnees segment word public 'donnees'

;---------------------------
palette:
 db 0,0,0,8,8,8,16,16,16,24,24,24
 db 32,32,32,40,40,40,48,48,48,56,56,56

 db 0,0,0,0,0,0,0,0,0,0,0,0
 db 0,0,0,0,0,0,0,0,0,0,0,0


;----------------------------------------------
; Donnes Rouleaux  Mixer

rasta0:
rasta1:
 db 128,127,106,128,25,7
rasta2:
 db 192,63,53,192,12,3
rasta3:
 db 224,31,26,96,6,128,1
rasta4:
 db 240,15,13,176,3,192
rasta5:
 db 248,7,6,88,1,96,128
rasta6:
 db 252,3,3,172,48,192
rasta7:
 db 254,1,1,86,152,224

; Donnes Rouleaux-Bloc  Charger ds les Latches

rastl0:
 db 213,51,15,171,204,240
rastl1:
 db 213,230,248
rastl2:
 db 106,243,252
rastl3:
 db 181,121,254
rastl4:
 db 90,60,255
rastl5:
 db 173,158,127
rastl6:
 db 86,207,63
rastl7:
 db 171,103,31
f_rastl:

;------------------------------------------------

sinus:
 include c:\masm\data\rolosin.dat

sin_point dw 0
;------------------------------------------------

screen dw 0a000h,0a800h
vpage  dw 12,12+32*4*256

;*************************

donnees ends

;*************************
.286
code   segment word public 'code'
       assume  cs:code,ds:donnees,ss:pile

codeur      proc far

            cli                     ; Int Off

;---------  Programme Principal  ---------

            mov    ax,000dh         ; 320x200 16 Couleurs
            int    10h

            mov    ax,seg donnees
            mov    ds,ax

            lea    si,palette
            call   newpal           ; nouvelle palette

;---------  Copier les motifs dans la Video Ram ---------

            mov    ax,0a000h
            mov    es,ax
            mov    dx,3c4h

            lea    si,rastl0
            mov    di,8000
            mov    ax,0102h
            out    dx,ax            ; Plan 1

            mov    cx,(offset f_rastl - offset rastl0)/3
to_latch1:  lodsb
            mov    es:[di+8000h],al ; Page 2
            stosb                   ; Page 1
            add    si,2
            loop   to_latch1

            mov    si,(offset rastl0)+1
            mov    di,8000
            mov    ax,0202h
            out    dx,ax            ; Plan 2

            mov    cx,(offset f_rastl - offset rastl0)/3
to_latch2:  lodsb
            mov    es:[di+8000h],al ; Page 2
            stosb                   ; Page 1
            add    si,2
            loop   to_latch2

            mov    si,(offset rastl0)+2
            mov    di,8000
            mov    ax,0402h
            out    dx,ax            ; Plan 3

            mov    cx,(offset f_rastl - offset rastl0)/3
to_latch3:  lodsb
            mov    es:[di+8000h],al ; Page 2
            stosb                   ; Page 1
            add    si,2
            loop   to_latch3

;----------------------------------------------------------

            mov    ax,seg donnees
            mov    ds,ax
demo:

            call   wait_vbl         ; VSYNC

;        -- Swap   Screens --

            mov    ax,screen
            mov    bx,screen+2
            mov    screen+2,ax
            mov    screen,bx

            mov    dx,3d4h
            mov    ax,vpage+2
            out    dx,ax
            mov    bx,vpage
            mov    vpage+2,bx
            mov    vpage,ax

            mov    ax,1000h
            call   color

;         ----- Affichage des Rasters -----

            mov    ax,screen        ; cran logique
            mov    es,ax

            mov    dx,3c4h          ; Clear 1re ligne
            mov    ax,0f02h
            out    dx,ax
            xor    di,di
            xor    ax,ax
            mov    cx,20
            rep    stosw

            lea    bp,sinus         ; pointe sur la table
            add    bp,sin_point     ; + offset

            xor    di,di            ; di=0


;       ---    Barres+Copies  ---

           rept   17

            push   ds               ; sauve segment donnes
            push   di               ; sauve offset

            add    di,ds:[bp]       ; + offset sinus
            mov    bx,ds:2[bp]      ; BX = Dcalage sinus
            add    bp,4*4           ; prpare sinus suivant

            call   rouleaux         ; afficher bout de rouleau
            pop    di               ; rcupre offset

            mov    cx,40*4
            mov    si,di
            add    di,40
            rep    movsb            ; copie 4 lignes de Rasters

            pop    ds               ; rcupre segment donnes
            mov    ax,0005h         ; Mode Read 0/Write 0
            out    dx,ax            ; (DX=3CEh)

            mov    di,si            ; se repositionne au dbut de la ligne

           endm

;      --   Dernire Ligne  --

            push   ds               ; sauve segment donnes
            push   di               ; sauve offset

            add    di,ds:[bp]       ; + offset sinus
            mov    bx,ds:2[bp]      ; BX = Dcalage sinus
            add    bp,4*4           ; prpare sinus suivant

            call   rouleaux         ; afficher bout de rouleau
            pop    di               ; rcupre offset

            mov    cx,40*7
            mov    si,di
            add    di,40
            rep    movsb            ; copie 7 lignes de Rasters

;         ---- Symtrie ----

            mov    di,si            ; se repositionne au dbut de la ligne

            sub    si,40*11
            mov    cx,40*4          ; 1
            rep    movsb

           rept   16
            sub    si,40*8          ; ...
            mov    cx,40*4
            rep    movsb
           endm

;         ------------------

            pop    ds               ; rcupre segment donnes
            mov    ax,0005h         ; Mode Read 0/Write 0
            out    dx,ax            ; (DX=3CEh)

;         -------------------

            xor    ax,ax
            call   color

            add    sin_point,4*3    ; Incrmenter Sinus
            and    sin_point,2047

;         -------------------


            in     al,60h           ; test if space bar
            cmp    al,39h
            jne    demo

;         -------------------

            sti                     ; Int On

            mov    ax,0003h         ; Mode Text
            int    10h

            mov    ax,4c00h         ; Exit
            int    21h

codeur      endp

;---------  Procdures  ----------

newpal     proc   near

            mov    dx,3c8h          ; DAC Port
            xor    cl,cl

           rept   16

            mov    al,cl
            out    dx,al            ; N Couleur
            inc    dl

            outsb                   ; Poker RGB Values
            outsb
            outsb

            dec    dl
            inc    cl               ; N=N+1

           endm

            ret

newpal     endp

wait_vbl   proc   near              ; pour attendre la VBL
            mov    dx,03dah
            in     al,dx
            jmp    $+2
            test   al,08h
            jz     V_Ready
V_Not_Ready:		
            in     al,dx
            jmp    $+2
            test   al,08h
            jz     V_Not_Ready
V_Ready:
            in     al,dx
            jmp    $+2
            test   al,08h
            jz     V_Ready
            ret

wait_vbl   endp


; -------- Code Gnr ---------

rouleaux   proc   near

; ES:DI    = Destination
; BX       = Dcalage*8

           add    bx,offset rolo_table

           mov    si,cs:2[bx]       ; Datas AND/OR
           mov    cx,cs:4[bx]       ; Datas Blok

           jmp    word ptr cs:[bx]  ; Jump to Adr Routine

rolo_table:
 dw offset rolo0,offset rasta0,8000+(offset rastl0-offset rastl0)/3,0
 dw offset rolo1,offset rasta1,8000+(offset rastl1-offset rastl0)/3,0
 dw offset rolo2,offset rasta2,8000+(offset rastl2-offset rastl0)/3,0
 dw offset rolo3,offset rasta3,8000+(offset rastl3-offset rastl0)/3,0
 dw offset rolo4,offset rasta4,8000+(offset rastl4-offset rastl0)/3,0
 dw offset rolo5,offset rasta5,8000+(offset rastl5-offset rastl0)/3,0
 dw offset rolo6,offset rasta6,8000+(offset rastl6-offset rastl0)/3,0
 dw offset rolo7,offset rasta7,8000+(offset rastl7-offset rastl0)/3,0

rolo0:
 mov dx,3c4h
 mov ax,0f02h
 out dx,ax
 mov si,cx
 mov ax,es
 mov ds,ax
 mov dl,0ceh
 mov ax,0105h
 out dx,ax
 movsb
 movsb
 ret

rolo1:
 mov bx,di
 mov dx,3c4h
 mov ax,0f02h
 out dx,ax
 mov dl,0ceh
 mov ax,0803h
 out dx,ax
 mov al,es:[di]
 movsb
 inc di
 mov al,es:[di]
 movsb
 mov di,bx
 mov ax,1003h
 out dx,ax
 mov dl,0c4h
 mov ax,0102h
 out dx,ax
 mov al,es:[di]
 movsb
 inc di
 mov al,es:[di]
 movsb
 mov di,bx
 inc dl
 mov al,02h
 out dx,al
 mov al,es:[di]
 movsb
 mov di,bx
 mov al,04h
 out dx,al
 mov al,es:[di]
 movsb
 mov di,bx
 mov si,cx
 mov ax,es
 mov ds,ax
 mov al,0fh
 out dx,al
 mov dl,0ceh
 mov ax,0003h
 out dx,ax
 mov ax,0105h
 out dx,ax
 inc di
 movsb
 ret

rolo2:
 mov bx,di
 mov dx,3c4h
 mov ax,0f02h
 out dx,ax
 mov dl,0ceh
 mov ax,0803h
 out dx,ax
 mov al,es:[di]
 movsb
 inc di
 mov al,es:[di]
 movsb
 mov di,bx
 mov ax,1003h
 out dx,ax
 mov dl,0c4h
 mov ax,0102h
 out dx,ax
 mov al,es:[di]
 movsb
 inc di
 mov al,es:[di]
 movsb
 mov di,bx
 inc dl
 mov al,02h
 out dx,al
 mov al,es:[di]
 movsb
 mov di,bx
 mov al,04h
 out dx,al
 mov al,es:[di]
 movsb
 mov di,bx
 mov si,cx
 mov ax,es
 mov ds,ax
 mov al,0fh
 out dx,al
 mov dl,0ceh
 mov ax,0003h
 out dx,ax
 mov ax,0105h
 out dx,ax
 inc di
 movsb
 ret

rolo3:
 mov bx,di
 mov dx,3c4h
 mov ax,0f02h
 out dx,ax
 mov dl,0ceh
 mov ax,0803h
 out dx,ax
 mov al,es:[di]
 movsb
 inc di
 mov al,es:[di]
 movsb
 mov di,bx
 mov ax,1003h
 out dx,ax
 mov dl,0c4h
 mov ax,0102h
 out dx,ax
 mov al,es:[di]
 movsb
 inc di
 mov al,es:[di]
 movsb
 mov di,bx
 inc dl
 mov al,02h
 out dx,al
 mov al,es:[di]
 movsb
 inc di
 mov al,es:[di]
 movsb
 mov di,bx
 mov al,04h
 out dx,al
 mov al,es:[di]
 movsb
 mov di,bx
 mov si,cx
 mov ax,es
 mov ds,ax
 mov al,0fh
 out dx,al
 mov dl,0ceh
 mov ax,0003h
 out dx,ax
 mov ax,0105h
 out dx,ax
 inc di
 movsb
 ret

rolo4:
 mov bx,di
 mov dx,3c4h
 mov ax,0f02h
 out dx,ax
 mov dl,0ceh
 mov ax,0803h
 out dx,ax
 mov al,es:[di]
 movsb
 inc di
 mov al,es:[di]
 movsb
 mov di,bx
 mov ax,1003h
 out dx,ax
 mov dl,0c4h
 mov ax,0102h
 out dx,ax
 mov al,es:[di]
 movsb
 inc di
 mov al,es:[di]
 movsb
 mov di,bx
 inc dl
 mov al,02h
 out dx,al
 mov al,es:[di]
 movsb
 inc di
 mov al,es:[di]
 movsb
 mov di,bx
 mov al,04h
 out dx,al
 mov di,bx
 mov si,cx
 mov ax,es
 mov ds,ax
 mov al,0fh
 out dx,al
 mov dl,0ceh
 mov ax,0003h
 out dx,ax
 mov ax,0105h
 out dx,ax
 inc di
 movsb
 ret

rolo5:
 mov bx,di
 mov dx,3c4h
 mov ax,0f02h
 out dx,ax
 mov dl,0ceh
 mov ax,0803h
 out dx,ax
 mov al,es:[di]
 movsb
 inc di
 mov al,es:[di]
 movsb
 mov di,bx
 mov ax,1003h
 out dx,ax
 mov dl,0c4h
 mov ax,0102h
 out dx,ax
 mov al,es:[di]
 movsb
 inc di
 mov al,es:[di]
 movsb
 mov di,bx
 inc dl
 mov al,02h
 out dx,al
 mov al,es:[di]
 movsb
 inc di
 mov al,es:[di]
 movsb
 mov di,bx
 mov al,04h
 out dx,al
 add di,2
 mov al,es:[di]
 movsb
 mov di,bx
 mov si,cx
 mov ax,es
 mov ds,ax
 mov al,0fh
 out dx,al
 mov dl,0ceh
 mov ax,0003h
 out dx,ax
 mov ax,0105h
 out dx,ax
 inc di
 movsb
 ret

rolo6:
 mov bx,di
 mov dx,3c4h
 mov ax,0f02h
 out dx,ax
 mov dl,0ceh
 mov ax,0803h
 out dx,ax
 mov al,es:[di]
 movsb
 inc di
 mov al,es:[di]
 movsb
 mov di,bx
 mov ax,1003h
 out dx,ax
 mov dl,0c4h
 mov ax,0102h
 out dx,ax
 mov al,es:[di]
 movsb
 inc di
 mov al,es:[di]
 movsb
 mov di,bx
 inc dl
 mov al,02h
 out dx,al
 add di,2
 mov al,es:[di]
 movsb
 mov di,bx
 mov al,04h
 out dx,al
 add di,2
 mov al,es:[di]
 movsb
 mov di,bx
 mov si,cx
 mov ax,es
 mov ds,ax
 mov al,0fh
 out dx,al
 mov dl,0ceh
 mov ax,0003h
 out dx,ax
 mov ax,0105h
 out dx,ax
 inc di
 movsb
 ret

rolo7:
 mov bx,di
 mov dx,3c4h
 mov ax,0f02h
 out dx,ax
 mov dl,0ceh
 mov ax,0803h
 out dx,ax
 mov al,es:[di]
 movsb
 inc di
 mov al,es:[di]
 movsb
 mov di,bx
 mov ax,1003h
 out dx,ax
 mov dl,0c4h
 mov ax,0102h
 out dx,ax
 mov al,es:[di]
 movsb
 inc di
 mov al,es:[di]
 movsb
 mov di,bx
 inc dl
 mov al,02h
 out dx,al
 add di,2
 mov al,es:[di]
 movsb
 mov di,bx
 mov al,04h
 out dx,al
 add di,2
 mov al,es:[di]
 movsb
 mov di,bx
 mov si,cx
 mov ax,es
 mov ds,ax
 mov al,0fh
 out dx,al
 mov dl,0ceh
 mov ax,0003h
 out dx,ax
 mov ax,0105h
 out dx,ax
 inc di
 movsb
 ret



rouleaux   endp

; ------------------------------

color     proc near

; AX
          mov  dx,3c8h
          out  dx,ax
          inc  dl
          mov  al,ah
          out  dx,al
          out  dx,al
          ret

color     endp


code       ends
           end   codeur
 ;************************












