model large
.386

.stack

.data
include demo1.inc
include demo1.pal
include demo1.txt
textcount   dw  0
loopcount   db  0
count       db  0
sonicadr    dw  4952h    
soniccnt    db  0
sonicctr    db  1
sonicdel    dw  90
sonicflg    db  0
sonicfrm    dw  0
sonicpos    dw  120
sonicprt    db  0
startadr    db  ?
effectnum   db  0
	    db  ?
effect      db  1,50h,2,060h,0e6h,3,50h,5,3,26,4,3,0,6,7,060h,0e6h,1,00
	    db  2,0b0h,0e6h,3,0,6,3,26,4,3,50h,5
	    db  7,0b0h,0e6h,1,0,0ffh
rasterstore db  0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0, 0,0,0 
	    db  0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0, 0,0,0
	    db  0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0, 0,0,0
	    db  0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0
	    db  0,0,0,  0,0,0,  0,0,0,  0,0,0,  0,0,0  
rasterbkgnd db  63,0,0, 61,0,0, 59,0,0, 58,0,0, 56,0,0, 54,0,0, 52,0,0
	    db  50,0,0, 49,0,0, 47,0,0, 45,0,0, 43,0,0, 41,0,0, 40,0,0, 38,0,0 
	    db  36,0,0, 34,0,0, 32,0,0, 31,0,0, 29,0,0, 27,0,0, 25,0,0 
	    db  23,0,0, 22,0,0, 20,0,0, 18,0,0, 16,0,0, 14,0,0, 13,0,0
	    db  11,0,0, 09,0,0, 07,0,0, 05,0,0, 04,0,0, 02,0,0
rasterpal   db  0,0,60,  0,0,54,  0,0,48,  0,0,42,  0,0,36  ;Raster 1 Pal
	    db  0,0,30, 0,0,24, 0,0,18, 0,0,12, 0,0,06
rasterpos   db  1
rasterback  db  1
rastersine  db  0,1,3,5,8,11,14,17,20,22,24,25,25,24,22,20,17,14,11,8,5,3,1,0
rastercol1  db  1,1,1,1,1,01,01,01,01,01,01,01,01,00,00,00,00,00,00,0,0,0,0,0
rasterwatr  db  0,64h,0c8h,64h,0,64h,0c8h,64h,0       
	    db  0,64h,0c8h,64h,0,64h,0c8h,64h,0       
	    db  0,64h,0c8h,64h,0,64h,0c8h,64h,0       
	    db  0,64h,0c8h,64h,0,64h,0c8h,64h,0       
	    db  0,64h,0c8h,64h,0,64h,0c8h,64h,0       
	    db  0,64h,0c8h,64h,0,64h,0c8h,64h,0       
	    db  0,64h,0c8h,64h,0,64h,0c8h,64h,0       
	    db  0,64h,0c8h,64h,0,64h,0c8h,64h,0       
counter     db  1
waterctr    db  0
watercnt    db  1
musiccnt    db  1
FRAME     = 799              ; Time between two interrupts is 97.5%
				; of total frame time - the interrupt comes
				; somewhat _before_ the Vertical Retrace
				; actually starts.
OldTmr       dd ?
TmrVal       dw ?               ; count to the timer chip
DOSTmrCnt    dw ?               ; counter used in calling the old timer

.fardata
include demo2.inc
include demo3.inc
sonicbkg    db  1872 dup (0)

.code main
.startup
	cli
	in   al,21h
	push ax
	mov  al,11111110b
	out  21h,al
	
	in   al,0a1h
	push ax
	mov  al,11111111b
	out  0a1h,al
	sti
	
	mov  ax,13h
	int  10h

	mov  dx,03ceh      ;turns off odd/even
	mov  al,5
	out  dx,al
	inc  dx
	in   al,dx
	and  al,11101111b
	out  dx,al
	dec  dx

	mov  al,6
	out  dx,al
	inc  dx
	in   al,dx
	and  al,11111101b
	out  dx,al
 
	mov  dx,03c4h      ;disables chain 4.
	mov  al,4
	out  dx,al
	inc  dx
	in   al,dx
	and  al,11110111b
	or   al,4
	out  dx,al


	mov  ax,0a000h     ;clear screen
	sub  di,di
	mov  es,ax
	mov  cx,0ffffh
	mov  ax,di
	rep  stosw

	
	mov  dx,03d4h      
	mov  al,14h        ;enables dword addressing
	out  dx,al
	inc  dx
	in   al,dx
	and  al,10111111b
	out  dx,al
	dec  dx
 
	mov  al,17h        ;enables byte addressing
	out  dx,al
	inc  dx
	in   al,dx
	or   al,01000000b
	out  dx,al

	mov  dx,03d4h      ;split screen line 64
	mov  al,18h
	out  dx,al
	inc  dx
	mov  al,64
	out  dx,al

	dec  dx
	mov  al,07
	out  dx,al
	inc  dx
	in   al,dx
	and  al,11101111b
	out  dx,al
	dec  dx

	mov  al,09
	out  dx,al
	inc  dx
	in   al,dx
	and  al,10111111b
	out  dx,al

	dec  dx            ;set start address of top
	mov  al,0ch
	out  dx,al
	inc  dx
	mov  al,0d8h
	out  dx,al
	dec  dx
	mov  al,0dh
	out  dx,al
	inc  dx
	mov  al,50h
	out  dx,al

	mov  dx,03d4h   ;Unprotect first 8 regs of 03d4h
	mov  al,11h
	out  dx,al
	inc  dx
	in   al,dx
	and  al,127
	out  dx,al

	mov     ax,musicseg            ; adr. AdLib Player
	mov     cs:Player[2],ax
	mov     ah,6
	call    PlayM
	jnc     NO_CARD_PRESENT
	mov     BYTE PTR cs:[PlayM],0C3h ; RET
NO_CARD_PRESENT:
	mov     ah,0                ; init music
	mov     bx,musicseg
	mov     cx,2538
	call    PlayM
	mov     ah,2
	mov     bx,0
	call    PlayM
	
	call zeropal
	call InitVRServer
	mov  ax,0a000h      
	mov  es,ax
	call putpic
	call putpal 
keywait:mov  dx,60h
	in   al,dx
	cmp  al,1
	jne  keywait
ending:
	call RemoveVRServer 
	 
	 mov     ah,2
	 mov     bx,0
	 call    PlayM              ; Stop Music

	
	pop  ax
	out  0a1h,al
	
	pop  ax
	out  21h,al
	
	mov  ax,0003h
	int  10h

.exit
	
VR:     cli
	mov  si,OFFSET rasterstore
	mov  dx,03d4h
	mov  al,13h
	out  dx,al
	inc  dl
	mov  al,160
	out  dx,al
	
	mov  dl,0c8h
	mov  al,0
	out  dx,al
	inc  dl
	out  dx,al
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
        mov cx,16
horiz1: in al,dx
	test al,1
	jnz horiz1
horiz2: in al,dx
	test al,1
	jz horiz2
loop    horiz1

	mov cx,35
loop1:  
	mov  dl,0c8h
	mov  al,0
	out  dx,al
	mov  dl,0c9h
	outsb
	outsb

	mov  dl,0dah
horiz:  in al,dx
	test al,1
	jz horiz
	
	mov  dl,0c9h
	lodsb
	out  dx,al
	test al,al
	je   nocolor
	     
	mov  al,rasterback
	test al,al
	je   nocolor
	sub  si,3
	outsb
	outsb
	outsb
	jmp skipit
nocolor:mov al,cl
	shl al,1
	and al,63
	sub al,2
	out dx,al
	push ax
	mov  al,0
	out  dx,al
	pop  ax
	out dx,al
       
skipit: mov  dl,0dah
horiza: in al,dx
	test al,1
	jnz horiza
horizb: in al,dx
	test al,1
	jz horizb
		
loop    loop1

	
	mov dl,0c8h
	mov al,0
	out dx,al
	inc dl
	mov al,12
	out dx,al
	out dx,al
	
	mov dl,0dah
horiz1a:in al,dx
	test al,1
	jz horiz1a
	
	mov dl,0c9h
	mov al,32
	out dx,al
	mov  al,0
	out  dx,al
	out  dx,al
	out  dx,al
	
        mov dl,0dah
horiz1b:in al,dx
        test al,1
        jnz horiz1b
horiz1c:in al,dx
        test al,1
        jz horiz1c

horiz7b:in al,dx
        test al,1
        jnz horiz7b
horiz7c:in al,dx
        test al,1
        jz horiz7c

;horiz7a:in al,dx
;        test al,1
;        jnz horiz7a
	
	mov  dl,0d4h
	mov  al,13h
	out  dx,al
	inc  dl
	mov  al,100
	out  dx,al
     
	call scrolltext
	
	dec  sonicctr
	jne  after
	mov  sonicctr,6
normrun:
	inc  sonicfrm
	cmp  sonicfrm,5
	jne  gdrm
	mov  sonicfrm,1
gdrm:   dec  sonicpos
	jne  norest
	mov  sonicpos,120
	mov  sonicdel,120
norest: mov  gs,sonicfrm
	call putbkg
	mov  gs,sonicpos
	push sonicfrm
	mov  sonicpos,66
	mov  sonicfrm,9
	call putson
	pop  sonicfrm
	mov  sonicpos,gs
	call putson

after:  inc  counter
	cmp  counter,3
	jne  endlp
	mov  counter,0

rastpal:push es
	mov  ax,ds
	mov  di,OFFSET rasterstore ;Clears Raster storage area
	mov  es,ax
	mov  si,OFFSET rasterbkgnd
	mov  cx,26
rep     movsd
	movsb
storrst:
	inc  byte ptr rasterpos
	mov  si,OFFSET rasterpal
update: mov  al,byte ptr rasterpos
	cmp  al,24
	jne  store
	sub  al,al
	mov  byte ptr rasterpos,al     
store:  mov  di,OFFSET rasterstore
	mov  bl,byte ptr rasterpos
	mov  al,byte ptr rastercol1[bx]
	mov  rasterback,al
	mov  bl,byte ptr rastersine[bx]
	mov  ax,bx
	shl  ax,1
	add  ax,bx
	add  di,ax
	mov  cx,30
rep     movsb
	pop  es
endlp:  sti        
	ret

PreVR: 
	cli
	mov dx,03c8h
	mov al,0
	out dx,al
	mov dx,03c9h
	mov al,10
	out dx,al
	out dx,al
	
	mov dx,03dah
horiz3a:in al,dx
	test al,1
	jz horiz3a
	
	mov  al,31
	mov  dx,03c9h
	out  dx,al
       
	mov dx,03dah
horiz3b:in al,dx
	test al,1
	jnz horiz3b
horiz3c:in al,dx
	test al,1
	jz horiz3c
	
	dec  watercnt
	jne  nochnge
	mov  watercnt,6
	inc  waterctr
	cmp  waterctr,8
	jne  nochnge
	mov  waterctr,0ffh
	
	
nochnge:mov cx,55
water:  mov  dx,03d4h
	mov  al,13h
	out  dx,al
	mov  bx,cx
	
	mov dx,03dah
horiz4a:in al,dx
	test al,1
	jz horiz4a 
	
	add  bl,waterctr
	mov  al,rasterwatr[bx]
	mov  dx,03d5h
	out  dx,al
	
	mov dx,03dah
horiz4b:in al,dx
	test al,1
	jnz horiz4b

horiz4c:in al,dx
	test al,1
	jz horiz4c
loop    water

	mov dx,03c8h
	sub al,al
	out dx,al
	mov dx,03c9h
	sub al,al
	out dx,al
	out dx,al
	
	
	mov dx,03dah
horiz5: in al,dx
	test al,1
	jz horiz5 
	
	mov dx,03c9h
	sub al,al
	out dx,al
	
	mov  dx,03d4h
	mov  al,13h
	out  dx,al
	inc  dx
	mov  al,64h           
	out  dx,al

       mov dx,03dah
horiz5a:in al,dx
	test al,1
	jnz horiz5a
horiz5b:in al,dx
	test al,1
	jz horiz5b
	sti
	ret

scrolltext:
	mov  ax,seg letter
	mov  ds,ax
	sub  bx,bx
	mov  bl,effectnum
	inc  effectnum
	mov  al,byte ptr effect[bx]
	cmp  al,1
	jne  not1
	inc  bl
	mov  ah,byte ptr effect[bx]
	call setst        
	inc  effectnum
	ret
not1:   cmp  al,2
	jne  not2
	inc  bl
	mov  di,word ptr effect[bx]
	call txt
	add  effectnum,2
	ret
not2:   cmp  al,3
	jne  not3
	inc  bl
	mov  al,byte ptr effect[bx]
	inc  effectnum
	mov  count,al
	ret
not3:   cmp  al,4
	jne  not4
	dec  count
	je   nocompare
	dec  effectnum
	ret
not4:   cmp  al,5
	jne  not5
	dec  count
	je   skip
	dec  effectnum
skip:   call scroll  
	ret
not5:   cmp  al,6
	jne  not6
	inc  count
	cmp  count,50h
	je   skip2
	dec  effectnum
skip2:  call scroll
	ret
not6:   cmp  al,7
	jne  not7
	inc  bl
	mov  di,word ptr effect[bx]
	call del
	add  effectnum,2
	ret
not7:   cmp  al,0ffh
	jne  nocompare
	mov  ax,0
	mov  effectnum,0
nocompare:
	ret
scroll: mov  bl,count
	mov  dx,03d4h
	mov  al,0dh
	out  dx,al
	mov  al,bl
	inc  dx
	out  dx,al
	ret

del:    
	push es
	mov  ax,0a000h
	mov  es,ax
	mov  dx,03c4h
	mov  ax,0f02h
	out  dx,ax
	mov  dl,25
	mov  eax,0000h
dellp1: mov  cl,20
rep     stosd
	add  di,80
	dec  dl
	jne  dellp1
	pop  es
	ret

setst:  mov  dx,03d4h
	mov  al,0dh
	out  dx,al
	inc  dx
	mov  al,ah
	out  dx,al
	ret


txt:    
	push es
	mov  ax,0a000h
	mov  es,ax
	push di 
	mov  loopcount,13
txtloop:
	mov  bx,textcount
	inc  textcount
	mov  al,text1[bx]
	test al,al
	jne  char
	mov  textcount,0
	jmp  txtloop
char:   
	sub  al,32
	sub  ah,ah
	mov  cx,24*25
	mul  cx
	mov  si,ax
	
	mov  dx,03c4h
	mov  ax,0102h
	out  dx,ax
	pop  di
	push di
	mov  cx,25
txtlp1: movsd
	movsw
	add  di,154
	loop txtlp1
	
	mov  ax,0202h
	out  dx,ax
	pop  di
	push di
	mov  cx,25
txtlp2: movsd
	movsw
	add  di,154
	loop txtlp2
	
	mov  ax,0402h
	out  dx,ax
	pop  di
	push di
	mov  cx,25
txtlp3: movsd
	movsw
	add  di,154
	loop txtlp3
	
	mov  ax,0802h
	out  dx,ax
	pop  di
	add  di,6
	push di
	sub  di,6
	mov  cx,25
txtlp4: movsd    
	movsw
	add  di,154
	loop txtlp4
	
	dec  BYTE PTR loopcount
	jne  txtloop
	pop  di
	pop  es
	ret
	
putpic: push ds
	mov  ax,seg PICTURE
	mov  ds,ax
	mov  si,offset PICTURE
	mov  di,3220
	mov  bx,55
	
	mov  dx,03c4h
	mov  ax,0102h
	out  dx,ax
picloop1:  
	mov  cx,10
rep     movsd
	movsw
	add  di,158
	dec  bx
	jne  picloop1
	
	mov  di,3220
	mov  bx,55
	mov  ax,0202h
	out  dx,ax
picloop2:  
	mov  cx,10
rep     movsd
	movsw
	add  di,158
	dec  bx
	jne  picloop2
	
	mov  di,3220
	mov  bx,55
	mov  ax,0402h
	out  dx,ax
picloop3:  
	mov  cx,10
rep     movsd
	movsw
	add  di,158
	dec  bx
	jne  picloop3

	mov  di,3220
	mov  bx,55
	mov  ax,0802h
	out  dx,ax
picloop4:  
	mov  cx,10
rep     movsd
	movsw
	add  di,158
	dec  bx
	jne  picloop4
	pop  ds
	ret
	

putpal: mov  si,offset palette
	mov  dx,03c8h
	mov  al,0
	out  dx,al
	inc  dx
	mov  cx,768
palloop:outsb
	loop palloop
	ret

zeropal:
	mov  dx,03c8h
	mov  al,0
	out  dx,al
	inc  dx
	mov  cx,768
	mov  al,0
rep     out  dx,al
	ret

putson: push es
	push ds 
	mov  ax,0a000h
	mov  es,ax
	mov  ax,sonicadr
	add  ax,sonicpos
	mov  fs,ax
	mov  di,fs
	mov  si,offset SONIC
	mov  ax,sonicfrm
	mov  cx,1560
	mul  cx
	add  si,ax
	mov  ax,seg SONIC
	mov  ds,ax
	
	mov  bx,39
	mov  dx,03c4h
	mov  ax,0102h
	out  dx,ax
sonloop1:  
	mov  cx,10
ptlp1:  lodsb
	cmp  al,0
	je   noplt1
	stosb
	jmp  nopt1
noplt1: inc  di
nopt1:  loop ptlp1
	add  di,190
	dec  bx
	jne  sonloop1
	
	mov  di,fs
	mov  bx,39
	mov  ax,0202h
	out  dx,ax
sonloop2:  
	mov  cx,10
ptlp2:  lodsb
	cmp  al,0
	je   noplt2
	stosb
	jmp  nopt2 
noplt2: inc  di
nopt2:  loop ptlp2
	add  di,190
	dec  bx
	jne  sonloop2

	mov  di,fs
	mov  bx,39
	mov  ax,0402h
	out  dx,ax
sonloop3:  
	mov  cx,10
ptlp3:  lodsb
	cmp  al,0
	je   noplt3
	stosb
	jmp  nopt3
noplt3: inc  di
nopt3:  loop ptlp3
	add  di,190
	dec  bx
	jne  sonloop3
	
	mov  di,fs
	mov  bx,39
	mov  ax,0802h
	out  dx,ax
sonloop4:  
	mov  cx,10
ptlp4:  lodsb
	cmp  al,0
	je   noplt4
	stosb
	jmp  nopt4 
noplt4: inc  di
nopt4:  loop ptlp4
	add  di,190
	dec  bx
	jne  sonloop4
	pop  ds
sonref: 
	push  ds
	mov  ax,sonicadr
	add  ax,sonicpos
	add  ax,11400
	mov  fs,ax
	mov  di,fs
	mov  si,offset SONIC
	mov  ax,sonicfrm
	mov  cx,1560
	mul  cx
	add  si,ax
	mov  ax,seg SONIC
	mov  ds,ax
	
	mov  dx,03c4h
	mov  ax,0102h
	out  dx,ax
	mov  bx,19
sonrefloop1:  
	mov  cx,10
ptlp5:  lodsb
	cmp  al,0
	je   noplt5
	stosb
	jmp  nopt5 
noplt5: inc  di
nopt5:  loop ptlp5
	sub  di,210
	add  si,10
	dec  bx
	jne  sonrefloop1
	add  si,10        
	
	mov  di,fs
	mov  ax,0202h
	out  dx,ax
	mov  bx,19
sonrefloop2:  
	mov  cx,10
ptlp6:  lodsb
	cmp  al,0
	je   noplt6
	stosb
	jmp  nopt6 
noplt6: inc  di
nopt6:  loop ptlp6
	sub  di,210
	add  si,10
	dec  bx
	jne  sonrefloop2
	add  si,10     
	
	mov  di,fs
	mov  ax,0402h
	out  dx,ax
	mov  bx,19
sonrefloop3:  
	mov  cx,10
ptlp7:  lodsb
	cmp  al,0
	je   noplt7
	stosb
	jmp  nopt7 
noplt7: inc  di
nopt7:  loop ptlp7
	sub  di,210
	add  si,10
	dec  bx
	jne  sonrefloop3
	add  si,10     
	
	mov  di,fs
	mov  ax,0802h
	out  dx,ax
	mov  bx,19
sonrefloop4:  
	mov  cx,10
ptlp8:  lodsb
	cmp  al,0
	je   noplt8
	stosb
	jmp  nopt8 
noplt8: inc  di
nopt8:  loop ptlp8
	sub  di,210
	add  si,10
	dec  bx
	jne  sonrefloop4
	pop  ds
	pop  es
	ret     

putbkg: push es
	push ds 
	mov  ax,0a000h
	mov  es,ax
	mov  ax,sonicadr
	add  ax,sonicpos
	mov  fs,ax
	mov  di,fs
	mov  si,offset SONIC
	add  si,15600
	mov  ax,seg SONIC
	mov  ds,ax
	
	mov  bx,39
	mov  dx,03c4h
	mov  ax,0102h
	out  dx,ax
putbkgloop1:  
	mov  cx,3
rep     movsd
	add  di,188
	dec  bx
	jne  putbkgloop1
	
	mov  di,fs
	mov  bx,39
	mov  ax,0202h
	out  dx,ax
putbkgloop2:  
	mov  cx,3
rep     movsd
	add  di,188
	dec  bx
	jne  putbkgloop2

	mov  di,fs
	mov  bx,39
	mov  ax,0402h
	out  dx,ax
putbkgloop3:  
	mov  cx,3
rep     movsd
	add  di,188
	dec  bx
	jne  putbkgloop3
	
	mov  di,fs
	mov  bx,39
	mov  ax,0802h
	out  dx,ax
putbkgloop4:  
	mov  cx,3
rep     movsd
	add  di,188
	dec  bx
	jne  putbkgloop4
	pop  ds
bkgref: 
	push  ds
	mov  ax,sonicadr
	add  ax,sonicpos
	add  ax,11400
	mov  fs,ax
	mov  di,fs
	mov  si,offset SONIC
	mov  ax,sonicfrm
	add  si,15600
	mov  ax,seg SONIC
	mov  ds,ax
	
	mov  dx,03c4h
	mov  ax,0102h
	out  dx,ax
	mov  bx,19
bkgrefloop1:  
	mov  cx,3
rep     movsd
	sub  di,212
	add  si,10
	dec  bx
	jne  bkgrefloop1
	add  si,10        
	
	mov  di,fs
	mov  ax,0202h
	out  dx,ax
	mov  bx,19
bkgrefloop2:  
	mov  cx,3
rep     movsd
	sub  di,212
	add  si,10
	dec  bx
	jne  bkgrefloop2
	add  si,10     
	
	mov  di,fs
	mov  ax,0402h
	out  dx,ax
	mov  bx,19
bkgrefloop3:  
	mov  cx,3
rep     movsd
	sub  di,212
	add  si,10
	dec  bx
	jne  bkgrefloop3
	add  si,10     
	
	mov  di,fs
	mov  ax,0802h
	out  dx,ax
	mov  bx,19
bkgrefloop4:  
	mov  cx,3
rep     movsd
	sub  di,212
	add  si,10
	dec  bx
	jne  bkgrefloop4
	pop  ds
	pop  es
	ret     

WaitNextVR  MACRO             ; wait for NEXT Vertical Retrace
LOCAL   w1, w2        
	mov     dx,03DAh
w1:     in      al,dx           ; wait for a non-retrace period
	test    al,8
	jnz     w1

w2:     in      al,dx
	test    al,8            ; wait for retrace
	jz      w2
ENDM

Timer:           ; the actual timer routine

	push    ax
	push    bx
	push    cx
	push    dx
	push    si                      ; save normal 8086 registers
	push    di
	push    bp
	push    ds
	push    es

	mov     al,20h                  ; send End Of Interrupt signal
	out     20h,al                  ; to PIC

	mov     dx,seg letter                 ; point DS to proper data segment
	mov     ds,dx

	mov     dx,03DAh
@@wnvr: in      al,dx                   ; wait until we are _not_ in a
	test    al,8                    ; retrace (just to make sure...)
        jnz     @@wnvr

	call    PreVR                   ; call the Pre-VR function

	mov     bx,TmrVal             ; count for timer chip

	mov     dx,03DAh
@@wvr:  in      al,dx                   ; wait for the retrace
	test    al,8
	jz      @@wvr

	mov     al,30h                  ; counter mode 0 - interrupt on
	out     43h,al                  ; terminal count
	mov     al,bl
	out     40h,al                  ; set timer count and restart timer
	mov     al,bh
	out     40h,al

	call    VR         ; call the VR function

	clc
	
	mov     ah,3                ; play music
	call    PlayM
	 
        mov     ax,TmrVal
        add     DOSTmrCnt,ax          ; add timer count to DOS timer count
        jnc     @@noDOSTmr              ; if carry set (count 65536), call
					; DOS timer
        pushf
        call    [OldTmr]              ; call old timer
	 
@@noDOSTmr:
	pop     es
	pop     ds
	pop     bp
	pop     di
	pop     si                      ; restore saved registers
	pop     dx
	pop     cx
	pop     bx
	pop     ax

	iret

InitVRServer:

	push    ds

	mov     ax,3508h                ; save old interrupt 8 vector
	int     21h
	mov     word ptr OldTmr,bx
	mov     word ptr OldTmr+2,es

	mov     ax,seg Timer
	mov     ds,ax
	mov     dx,offset Timer         ; set new timer interrupt
	mov     ax,2508h
	int     21h
	
	pop     ds

	call    SyncVRServer           ; synchronize timer to display refresh

	ret

SyncVRServer:

	cli                             ; disable interrupts for maximum
					; accuracy
@@read:
	WaitNextVR                      ; wait for next Vertical Retrace

	mov     al,36h
	out     43h,al
	sub     al,al                   ; reset the timer
	out     40h,al
	out     40h,al


	WaitNextVR                      ; wait for next Vertical Retrace

	sub     al,al
	out     43h,al
	in      al,40h
	mov     ah,al
	in      al,40h                  ; read timer count - time between
	xchg    al,ah                   ; two Vertical Retraces
	neg     ax
	mov     TmrVal,ax


	WaitNextVR                      ; wait for next Vertical Retrace

	mov     al,36h
	out     43h,al
	sub     al,al                   ; reset timer again
	out     40h,al
	out     40h,al


	WaitNextVR                      ; wait...

	sub     al,al
	out     43h,al
	in      al,40h
	mov     ah,al                   ; and read the timer count again
	in      al,40h
	xchg    al,ah
	neg     ax

	mov     dx,ax

	sub     dx,TmrVal
	cmp     dx,2                    ; If the difference between the two
	jg      @@read                  ; values read was >2, read again.
	cmp     dx,-2
	jl      @@read

	mov     bx,FRAME            ; Time between two interrupts is
	mul     bx                      ; FRAMETIME/10 % of the total time
	mov     bx,1000                 ; between two Vertical Retraces.
	div     bx

	shr     ax,1
	mov     TmrVal,ax             ; timer chip count

	mov     bx,TmrVal

	WaitNextVR                      ; wait for Vertical Retrace

	mov     al,30h                  ; counter mode 0 - interrupt on
	out     43h,al                  ; terminal count
	mov     al,bl                   ; Restart timer with the new speed
	out     40h,al                  ; right after the beginning of the
	mov     al,bh                   ; Retrace.
	out     40h,al

	mov     DOSTmrCnt,0           ; count used in calling the old timer

	mov     al,20h                  ; send EOI signal to the PIC
	out     20h,al

	sti                             ; enable ints

	ret

RemoveVRServer:

	cli                             ; disable interrupts

	mov     al,36h                  ; DOS default timer mode
	out     43h,al
	sub     al,al                   ; set timer count to 65536 - 18.2Hz
	mov     al,0FFh                 ; (DOS default)
	out     40h,al
	out     40h,al

	push    ds
	mov     ax,2508h
	mov     dx,word ptr OldTmr        ; restore old timer int
	mov     ds,word ptr OldTmr+2
	int     21h
	pop     ds

	mov     al,20h                  ; send EOI signal to PIC
	out     20h,al

	mov     al,36h                  ; DOS default timer mode
	out     43h,al
	sub     al,al                   ; set timer count to 65536 - 18.2Hz
	mov     al,0FFh                 ; (DOS default)
	out     40h,al
	out     40h,al

	sti                             ; enable interrupts
	ret

PlayM:  nop
	call DWORD PTR cs:[Player]
	ret

Player    DW     0,0

ends main 

musicseg segment para use32 
;include alibi.inc
include driver.inc
include song.inc
ends musicseg

end
