model large
.386

.stack

.data
include krazy1.inc
include krazy2.inc
include one.inc
include palette.inc
include chaos2.inc
include font.inc
include text.inc
FRAME     = 585               ; Time between two interrupts is 97.5%
				; of total frame time - the interrupt comes
				; somewhat _before_ the Vertical Retrace
				; actually starts.
OldTmr       dd ?
TmrVal       dw ?               ; count to the timer chip
DOSTmrCnt    dw ?               ; counter used in calling the old timer
textcount    dw 0
scroll       db 0
scrdel       db 5
loopc        db 0
logo         dw 48016
lightbar1    db 32,10,10,10,10,10,10,10,10,10,10,10
lightbar2    db 15,37,15,15,15,15,15,15,15,15,15,37
lightbar3    db 20,20,42,20,20,20,20,20,20,20,42,20
lightbar4    db 25,25,25,47,25,25,25,25,25,47,25,25
lightbar5    db 20,20,20,20,42,20,20,20,42,20,20,20
lightbar6    db 15,15,15,15,15,37,15,37,15,15,15,15
lightbar7    db 10,10,10,10,10,10,32,10,10,10,10,10
count        dw 0
delay        db 7
staddr       dw 48000,48642,48964,48966,48968,48650,48012
	     dw 48654,48976,48978,48980,48662,48024
	     dw 48666,48988,48990,48992,48674,48036
	     dw 48678,49000,49002,49004,48686,48048
	     dw 48690,49012,49014,49016,48698,48060
	     dw 48702,49024,49026,49028,48710,48072
	     dw 48714,49036,49038,49040,48722,48084
	     dw 48722,49040,49038,49036,48714,48072
	     dw 48710,49028,49026,49024,48702,48060
	     dw 48698,49016,49014,49012,48690,48048
	     dw 48686,49004,49002,49000,48678,48036
	     dw 48674,48992,48990,48988,48666,48024
	     dw 48662,48980,48978,48976,48654,48012
	     dw 48650,48968,48966,48964,48642
stcount      dw 0
stdelay      db 7
mcount       dw 2
mdelay       db 1
magcount     db 0
magvals      db 4,6,8,10,12,14,16,18,20
	     db 22,24,26,28,30,32,34,36,38
	     db 40,42,44,46,48,50,52,54,56,58
	     db 60,62,64,66,68,70,72,74,76,78,80,78,76,74,72,70,68
	     db 66,64,62,60,58,56,54,52,50
	     db 48,46,44,42,40,38,36,34,32,30,28,26
	     db 24,22,20,18,16,14,12,10,8,6
rastbar      db 0,9,19,30,41,52,63
midbar1      db 00,00,00,00,00,00,00,13,27,39,51,63,00,00,00,00,00
midbar2      db 00,00,00,00,00,00,00,13,27,39,51,63,00,00,00,00,00
midbar3      db 63,63,63,63,42,42,42,13,27,39,51,63,63,63,63,63,42
.code main     
.startup
	cli
	in   al,21h
	push ax
	mov  al,11111110b
	out  21h,al
	
	in   al,0a1h
	push ax
	mov  al,11111111b
	out  0a1h,al
	sti
	
	mov  ax,13h
	int  10h

	mov  dx,03ceh      ;turns off odd/even
	mov  al,5
	out  dx,al
	inc  dx
	in   al,dx
	and  al,11101111b
	out  dx,al
	dec  dx

	mov  al,6
	out  dx,al
	inc  dx
	in   al,dx
	and  al,11111101b
	out  dx,al
 
	mov  dx,03c4h      ;disables chain 4.
	mov  al,4
	out  dx,al
	inc  dx
	in   al,dx
	and  al,11110111b
	or   al,4
	out  dx,al


	mov  ax,0a000h     ;clear screen
	sub  di,di
	mov  es,ax
	mov  cx,0ffffh
	mov  ax,di
	rep  stosw

	
	mov  dx,03d4h      
	mov  al,14h        ;enables dword addressing
	out  dx,al
	inc  dx
	in   al,dx
	and  al,10111111b
	out  dx,al
	dec  dx
 
	mov  al,17h        ;enables byte addressing
	out  dx,al
	inc  dx
	in   al,dx
	or   al,01000000b
	out  dx,al

	mov  dx,03d4h      ;split screen line 128
	mov  al,18h
	out  dx,al
	inc  dx
	mov  al,140
	out  dx,al

	dec  dx
	mov  al,07
	out  dx,al
	inc  dx
	in   al,dx
	and  al,11101111b
	out  dx,al
	dec  dx

	mov  al,09
	out  dx,al
	inc  dx
	in   al,dx
	and  al,10111111b
	out  dx,al

	dec  dx            ;set start address of top
	mov  al,0ch
	out  dx,al
	inc  dx
	mov  al,0bbh
	out  dx,al
	dec  dx
	mov  al,0dh
	out  dx,al
	inc  dx
	mov  al,080h            
	out  dx,al

	mov  dx,03d4h   ;Unprotect first 8 regs of 03d4h
	mov  al,11h
	out  dx,al
	inc  dx
	in   al,dx
	and  al,127
	out  dx,al

	mov  dx,03d4h
	mov  al,13h
	out  dx,al
	inc  dl
	mov  al,80
	out  dx,al
	
	mov     ax,musicseg            ; adr. AdLib Player
	mov     cs:Player[2],ax
	mov     ah,6
	call    PlayM
	jnc     NO_CARD_PRESENT
	mov     BYTE PTR cs:[PlayM],0C3h ; RET
NO_CARD_PRESENT:
	mov     ah,0                ; init music
	mov     bx,musicseg
	mov     cx,2390
	call    PlayM
	mov     ah,2
	mov     bx,0
	call    PlayM
	
	call zeropal
	call InitVRServer
	call putpal
	call putpic1
	call putpic2
	call putpic3
	call putchaos
keywait:mov  dx,60h
	in   al,dx
	cmp  al,1
	jne  keywait
ending:
	call RemoveVRServer 
	 
	 mov     ah,2
	 mov     bx,0
	 call    PlayM              ; Stop Music

	
	pop  ax
	out  0a1h,al
	
	pop  ax
	out  21h,al
	
	mov  ax,0003h
	int  10h

.exit
	
VR:     cli
	mov  bx,count
        mov  cx,42
clear:  mov  dx,03c8h
	mov  al,0
	out  dx,al
	inc  dl
	out  dx,al
	out  dx,al

	mov  dl,0dah
horiza :in   al,dx
	test al,1
	jz   horiza 
	
	mov  dl,0c9h
	sub  al,al
	out  dx,al

	mov  dl,0dah
horizb :in   al,dx
	test al,1
	jnz  horizb 
	mov  dl,0dah
horizc :in   al,dx
	test al,1
	jz   horizc
loop    clear        

	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,13
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizba:in   al,dx
	test al,1
	jz   horizba 
	
	mov  dl,0c9h
	mov  al,13
	out  dx,al

	mov  dl,0dah
horizbb:in   al,dx
	test al,1
	jnz  horizbb 
	mov  dl,0dah
horizbc:in   al,dx
	test al,1
	jz   horizbc

	mov  cx,3
bar1:        
	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,lightbar1[bx]
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horiz1a:in   al,dx
	test al,1
	jz   horiz1a 
	
	mov  dl,0c9h
	mov  al,lightbar1[bx]
	out  dx,al

	mov  dl,0dah
horiz1b:in   al,dx
	test al,1
	jnz  horiz1b 
	mov  dl,0dah
horiz1c:in   al,dx
	test al,1
	jz   horiz1c

loop    bar1
	
	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,15
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizca:in   al,dx
	test al,1
	jz   horizca 
	
	mov  dl,0c9h
	mov  al,15
	out  dx,al

	mov  dl,0dah
horizcb:in   al,dx
	test al,1
	jnz  horizcb 
	mov  dl,0dah
horizcc:in   al,dx
	test al,1
	jz   horizcc

	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,0
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizda:in   al,dx
	test al,1
	jz   horizda 
	
	mov  dl,0c9h
	mov  al,0
	out  dx,al

	mov  dl,0dah
horizdb:in   al,dx
	test al,1
	jnz  horizdb 
	mov  dl,0dah
horizdc:in   al,dx
	test al,1
	jz   horizdc
	
	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,17
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizea:in   al,dx
	test al,1
	jz   horizea 
	
	mov  dl,0c9h
	mov  al,17
	out  dx,al

	mov  dl,0dah
horizeb:in   al,dx
	test al,1
	jnz  horizeb 
	mov  dl,0dah
horizec:in   al,dx
	test al,1
	jz   horizec
	
	mov  cx,4
bar2:        
	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,lightbar2[bx]
	out  dx,al
	out  dx,al

	mov  dl,0dah
horiz3a:in   al,dx
	test al,1
	jz   horiz3a 
	
	mov  dl,0c9h
	mov  al,lightbar2[bx]
	out  dx,al

	mov  dl,0dah
horiz3b:in   al,dx
	test al,1
	jnz  horiz3b 
	mov  dl,0dah
horiz3c:in   al,dx
	test al,1
	jz   horiz3c

loop    bar2
	
	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,26
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizfa:in   al,dx
	test al,1
	jz   horizfa 
	
	mov  dl,0c9h
	mov  al,26
	out  dx,al

	mov  dl,0dah
horizfb:in   al,dx
	test al,1
	jnz  horizfb 
	mov  dl,0dah
horizfc:in   al,dx
	test al,1
	jz   horizfc

	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,00
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizga:in   al,dx
	test al,1
	jz   horizga 
	
	mov  dl,0c9h
	mov  al,00
	out  dx,al

	mov  dl,0dah
horizgb:in   al,dx
	test al,1
	jnz  horizgb 
	mov  dl,0dah
horizgc:in   al,dx
	test al,1
	jz   horizgc

	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,22
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizha:in   al,dx
	test al,1
	jz   horizha 
	
	mov  dl,0c9h
	mov  al,22
	out  dx,al

	mov  dl,0dah
horizhb:in   al,dx
	test al,1
	jnz  horizhb 
	mov  dl,0dah
horizhc:in   al,dx
	test al,1
	jz   horizhc

	
	mov  cx,9
bar3:        
	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,lightbar3[bx]
	out  dx,al
	out  dx,al

	mov  dl,0dah
horiz2a:in   al,dx
	test al,1
	jz   horiz2a 
	
	mov  dl,0c9h
	mov  al,lightbar3[bx]
	out  dx,al

	mov  dl,0dah
horiz2b:in   al,dx
	test al,1
	jnz  horiz2b 
	mov  dl,0dah
horiz2c:in   al,dx
	test al,1
	jz   horiz2c

loop    bar3
	
	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,26
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizia:in   al,dx
	test al,1
	jz   horizia 
	
	mov  dl,0c9h
	mov  al,26
	out  dx,al

	mov  dl,0dah
horizib:in   al,dx
	test al,1
	jnz  horizib 
	mov  dl,0dah
horizic:in   al,dx
	test al,1
	jz   horizic
	
	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,0
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizja:in   al,dx
	test al,1
	jz   horizja 
	
	mov  dl,0c9h
	mov  al,0
	out  dx,al

	mov  dl,0dah
horizjb:in   al,dx
	test al,1
	jnz  horizjb 
	mov  dl,0dah
horizjc:in   al,dx
	test al,1
	jz   horizjc

	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,31
	out  dx,al
	out  dx,al
	
	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,31
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizka:in   al,dx
	test al,1
	jz   horizka 
	
	mov  dl,0c9h
	mov  al,31
	out  dx,al

	mov  dl,0dah
horizkb:in   al,dx
	test al,1
	jnz  horizkb 
	mov  dl,0dah
horizkc:in   al,dx
	test al,1
	jz   horizkc

	mov  cx,15 ;16
bar4:  
	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,lightbar4[bx]
	out  dx,al
	out  dx,al

	mov  dl,0dah
horiz4a:in   al,dx
	test al,1
	jz   horiz4a 
	
	mov  dl,0c9h
	mov  al,lightbar4[bx]
	out  dx,al

	mov  dl,0dah
horiz4b:in   al,dx
	test al,1
	jnz  horiz4b 
	mov  dl,0dah
horiz4c:in   al,dx
	test al,1
	jz   horiz4c

loop    bar4
	
	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,31
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizla:in   al,dx
	test al,1
	jz   horizla 
	
	mov  dl,0c9h
	mov  al,31
	out  dx,al

	mov  dl,0dah
horizlb:in   al,dx
	test al,1
	jnz  horizlb 
	mov  dl,0dah
horizlc:in   al,dx
	test al,1
	jz   horizlc

	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,0 
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizma:in   al,dx
	test al,1
	jz   horizma 
	
	mov  dl,0c9h
	mov  al,0 
	out  dx,al

	mov  dl,0dah
horizmb:in   al,dx
	test al,1
	jnz  horizmb 
	mov  dl,0dah
horizmc:in   al,dx
	test al,1
	jz   horizmc

	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,31
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizna:in   al,dx
	test al,1
	jz   horizna 
	
	mov  dl,0c9h
	mov  al,31
	out  dx,al

	mov  dl,0dah
horiznb:in   al,dx
	test al,1
	jnz  horiznb 
	mov  dl,0dah
horiznc:in   al,dx
	test al,1
	jz   horiznc

	mov  cx,9
bar7:        
	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,lightbar5[bx]
	out  dx,al
	out  dx,al

	mov  dl,0dah
horiz7a:in   al,dx
	test al,1
	jz   horiz7a 
	
	mov  dl,0c9h
	mov  al,lightbar5[bx]
	out  dx,al

	mov  dl,0dah
horiz7b:in   al,dx
	test al,1
	jnz  horiz7b 
	mov  dl,0dah
horiz7c:in   al,dx
	test al,1
	jz   horiz7c

loop    bar7
	
	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,26
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizoa:in   al,dx
	test al,1
	jz   horizoa 
	
	mov  dl,0c9h
	mov  al,26
	out  dx,al

	mov  dl,0dah
horizob:in   al,dx
	test al,1
	jnz  horizob 
	mov  dl,0dah
horizoc:in   al,dx
	test al,1
	jz   horizoc

	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,0
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizpa:in   al,dx
	test al,1
	jz   horizpa 
	
	mov  dl,0c9h
	mov  al,0
	out  dx,al

	mov  dl,0dah
horizpb:in   al,dx
	test al,1
	jnz  horizpb 
	mov  dl,0dah
horizpc:in   al,dx
	test al,1
	jz   horizpc

	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,22
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizqa:in   al,dx
	test al,1
	jz   horizqa 
	
	mov  dl,0c9h
	mov  al,22
	out  dx,al

	mov  dl,0dah
horizqb:in   al,dx
	test al,1
	jnz  horizqb 
	mov  dl,0dah
horizqc:in   al,dx
	test al,1
	jz   horizqc

	
	mov  cx,4
bar8:        
	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,lightbar6[bx]
	out  dx,al
	out  dx,al

	mov  dl,0dah
horiz8a:in   al,dx
	test al,1
	jz   horiz8a 
	
	mov  dl,0c9h
	mov  al,lightbar6[bx]
	out  dx,al

	mov  dl,0dah
horiz8b:in   al,dx
	test al,1
	jnz  horiz8b 
	mov  dl,0dah
horiz8c:in   al,dx
	test al,1
	jz   horiz8c

loop    bar8
	
	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,17
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizra:in   al,dx
	test al,1
	jz   horizra 
	
	mov  dl,0c9h
	mov  al,17
	out  dx,al

	mov  dl,0dah
horizrb:in   al,dx
	test al,1
	jnz  horizrb 
	mov  dl,0dah
horizrc:in   al,dx
	test al,1
	jz   horizrc

	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,0 
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizsa:in   al,dx
	test al,1
	jz   horizsa 
	
	mov  dl,0c9h
	mov  al,0 
	out  dx,al

	mov  dl,0dah
horizsb:in   al,dx
	test al,1
	jnz  horizsb 
	mov  dl,0dah
horizsc:in   al,dx
	test al,1
	jz   horizsc

	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,15
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizta:in   al,dx
	test al,1
	jz   horizta 
	
	mov  dl,0c9h
	mov  al,15
	out  dx,al

	mov  dl,0dah
horiztb:in   al,dx
	test al,1
	jnz  horiztb 
	mov  dl,0dah
horiztc:in   al,dx
	test al,1
	jz   horiztc

	mov  cx,3
bar9:        
	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,lightbar7[bx]
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horiz9a:in   al,dx
	test al,1
	jz   horiz9a 
	
	mov  dl,0c9h
	mov  al,lightbar7[bx]
	out  dx,al

	mov  dl,0dah
horiz9b:in   al,dx
	test al,1
	jnz  horiz9b 
	mov  dl,0dah
horiz9c:in   al,dx
	test al,1
	jz   horiz9c

loop    bar9
	
	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,13
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizua:in   al,dx
	test al,1
	jz   horizua 
	
	mov  dl,0c9h
	mov  al,13
	out  dx,al

	mov  dl,0dah
horizub:in   al,dx
	test al,1
	jnz  horizub 
	mov  dl,0dah
horizuc:in   al,dx
	test al,1
	jz   horizuc

	mov  dl,0c8h
	sub  al,al
	out  dx,al
	inc  dl
	mov  al,0
	out  dx,al
	out  dx,al
	
	mov  dl,0dah
horizaa:in   al,dx
	test al,1
	jz   horizaa 
	
	mov  dl,0c9h
	mov  al,0
	out  dx,al

	mov  dl,0dah
horizab:in   al,dx
	test al,1
	jnz  horizab 
	mov  dl,0dah
horizac:in   al,dx
	test al,1
	jz   horizac

	dec  delay
	jne  goon
	mov  delay,7
	inc  count
	cmp  count,12
	jne  goon
	mov  count,0
goon:   dec  stdelay
	cmp  stdelay,0
	jne  goon2
	mov  stdelay,7
	inc  stcount
	mov  bx,stcount
	cmp  bx,84
	jne  setaddr
	mov  stcount,0
	sub  bx,bx
setaddr:shl  bx,1
	mov  cx,staddr[bx]
	mov  dx,03d4h      ;set start address of top
	mov  al,0ch
	out  dx,al
	inc  dx
	mov  al,ch
	out  dx,al
	dec  dx
	mov  al,0dh
	out  dx,al
	inc  dx
	mov  al,cl            
	out  dx,al
goon2:  dec  scrdel
	cmp  scrdel,0
	jne  goon3
	mov  scrdel,5
	inc  scroll
	cmp  scroll,5
	jne  goon3
	mov  scroll,0
	inc  textcount
	;call txt
goon3:  sti
endlp:  ret

PreVR: 
	cli
	dec  mdelay
	cmp  mdelay,0
	jne  mag
	mov  mdelay,5
	inc  mcount
	cmp  mcount,76
	jne  mag
	mov  mcount,0
mag:    mov  bx,mcount
	mov  cl,magvals[bx]
magloop:mov  dl,0dah
horzma: in   al,dx
	test al,1
	jz   horzma 
	
	mov  dl,0dah
horzmb: in   al,dx
	test al,1
	jnz  horzmb 
	mov  dl,0dah
horzmc: in   al,dx
	test al,1
	jz   horzmc
loop    horzma

	mov  magcount,9
maglp:  ;mov  cx,2      
	mov  dl,0dah
horzm1a:in   al,dx
	test al,1
	jz   horzm1a 
	
	mov  dl,0d4h
	mov  ax,0013h
	out  dx,ax
	
	mov  dl,0dah
horzm1b:in   al,dx
	test al,1
	jnz  horzm1b 
horzm1c:in   al,dx
	test al,1
	jz   horzm1c
	
;       loop horzm1a       
	
	dec  magcount
	cmp  magcount,0
	jne  maglp
	
	mov  cx,4
	mov  dl,0dah
horzm3a:in   al,dx
	test al,1
	jz   horzm3a 
       
	mov  dl,0d4h
	mov  ax,0f013h
	out  dx,ax
       
	mov  dl,0dah
horzm3b:in   al,dx
	test al,1
	jnz  horzm3b 
	mov  dl,0dah
horzm3c:in   al,dx
	test al,1
	jz   horzm3c
	
	loop horzm3a

	mov  bx,mcount
	mov  cl,81
	sub  cl,magvals[bx]
	mov  dl,0dah
horzm4a: in   al,dx
	test al,1
	jz   horzm4a 
	
	mov  dl,0d4h
	mov  ax,05013h
	out  dx,ax
	
	mov  dl,0dah
horzm4b: in   al,dx
	test al,1
	jnz  horzm4b 
	mov  dl,0dah
horzm4c: in   al,dx
	test al,1
	jz   horzm4c
loop    horzm4a
	
	mov  dx,03c8h
	mov  al,0
	out  dx,al
	inc  dl
	mov  bx,cx
	mov  al,63
	out  dx,al
	sub  al,al
	out  dx,al

	mov  dl,0dah
horz1a :in   al,dx
	test al,1
	jz   horz1a 
	
	mov  dl,0c9h
	sub  al,al
	out  dx,al
       
	mov  dl,0dah
horz1b :in   al,dx
	test al,1
	jnz  horz1b 
	mov  dl,0dah
horz1c :in   al,dx
	test al,1
	jz   horz1c

	mov  dx,03c8h
	mov  al,0
	out  dx,al
	inc  dl
	mov  bx,cx
	mov  al,52          
	out  dx,al
	sub  al,al
	out  dx,al

	mov  dl,0dah
horzza :in   al,dx
	test al,1
	jz   horzza 
	
	mov  dl,0c9h
	sub  al,al
	out  dx,al

	mov  dl,0dah
horzzb :in   al,dx
	test al,1
	jnz  horzzb 
	mov  dl,0dah
horzzc :in   al,dx
	test al,1
	jz   horzzc
	
	mov  dx,03c8h
	mov  al,0
	out  dx,al
	inc  dl
	mov  bx,cx
	mov  al,41          
	out  dx,al
	sub  al,al
	out  dx,al

	mov  dl,0dah
horzxa :in   al,dx
	test al,1
	jz   horzxa 
	
	mov  dl,0c9h
	sub  al,al
	out  dx,al
	
	mov  dl,0dah
horzxb :in   al,dx
	test al,1
	jnz  horzxb 
	mov  dl,0dah
horzxc :in   al,dx
	test al,1
	jz   horzxc
	
	mov  dx,03c8h
	mov  al,0
	out  dx,al
	inc  dl
	mov  bx,cx
	mov  al,30          
	out  dx,al
	sub  al,al
	out  dx,al

	mov  dl,0dah
horzya :in   al,dx
	test al,1
	jz   horzya 
	
	mov  dl,0c9h
	sub  al,al
	out  dx,al

	mov  dl,0dah
horzyb :in   al,dx
	test al,1
	jnz  horzyb 
	mov  dl,0dah
horzyc :in   al,dx
	test al,1
	jz   horzyc
	
	mov  dx,03c8h
	mov  al,0
	out  dx,al
	inc  dl
	mov  bx,cx
	mov  al,19          
	out  dx,al
	sub  al,al
	out  dx,al

	mov  dl,0dah
horzwa :in   al,dx
	test al,1
	jz   horzwa 
	
	mov  dl,0c9h
	sub  al,al
	out  dx,al

	mov  dl,0dah
horzwb :in   al,dx
	test al,1
	jnz  horzwb 
	mov  dl,0dah
horzwc :in   al,dx
	test al,1
	jz   horzwc
	
	mov  dx,03c8h
	mov  al,0
	out  dx,al
	inc  dl
	mov  bx,cx
	mov  al,9          
	out  dx,al
	sub  al,al
	out  dx,al

	mov  dl,0dah
horzva :in   al,dx
	test al,1
	jz   horzva 
	
	mov  dl,0c9h
	sub  al,al
	out  dx,al
	
	mov  dl,0d4h
	mov  al,13h
	out  dx,al
	inc  dx
	mov  al,80
	add  al,scroll
	out  dx,al

	mov  dl,0dah
horzvb :in   al,dx
	test al,1
	jnz  horzvb 
	mov  dl,0dah
horzvc :in   al,dx
	test al,1
	jz   horzvc
	
	mov  dx,03c8h
	sub  al,al
	out  dx,al
	inc  dl
	sub  al,al
	out  dx,al
	out  dx,al

	mov  dl,0dah
horzb1a:in   al,dx
	test al,1
	jz   horzb1a 
       
	mov  dl,0c9h
	sub  al,al
	out  dx,al
	
	mov  dl,0d4h
	mov  ax,5013h
	out  dx,ax
	
	mov  dl,0dah
horzb1b:in   al,dx
	test al,1
	jnz  horzb1b 
	mov  dl,0dah
horzb1c:in   al,dx
	test al,1
	jz   horzb1c
       
	mov  cx,16
barmid: mov  bx,cx
	mov  dx,03c8h
	mov  al,0
	out  dx,al
	inc  dl
	mov  al,midbar1[bx]
	out  dx,al
	mov  al,midbar2[bx]
	out  dx,al

	mov  dl,0dah
horz2a :in   al,dx
	test al,1
	jz   horz2a 
	
	mov  dl,0c9h
	mov  al,midbar3[bx]
	out  dx,al

	mov  dl,0dah
horz2b :in   al,dx
	test al,1
	jnz  horz2b 
	mov  dl,0dah
horz2c :in   al,dx
	test al,1
	jz   horz2c
loop    barmid
	
	mov  dx,03c8h
	sub  al,al
	out  dx,al
	inc  dl
	sub  al,al
	out  dx,al
	out  dx,al

	mov  dl,0dah
horzb2a:in   al,dx
	test al,1
	jz   horzb2a 
       
	mov  dl,0c9h
	mov  al,63
	out  dx,al
	
	mov  dl,0dah
horzb2b:in   al,dx
	test al,1
	jnz  horzb2b 
	mov  dl,0dah
horzb2c:in   al,dx
	test al,1
	jz   horzb2c
       
	mov  cx,6
barbot: mov  dx,03c8h
	mov  al,0
	out  dx,al
	inc  dl
	mov  bx,cx
	mov  al,rastbar[bx]
	out  dx,al
	sub  al,al
	out  dx,al

	mov  dl,0dah
horz3a :in   al,dx
	test al,1
	jz   horz3a 
	
	mov  dl,0c9h
	sub  al,al
	out  dx,al

	mov  dl,0dah
horz3b :in   al,dx
	test al,1
	jnz  horz3b 
	mov  dl,0dah
horz3c :in   al,dx
	test al,1
	jz   horz3c
loop    barbot
	
	mov  dx,03c8h
	sub  al,al
	out  dx,al
	inc  dl
	sub  al,al
	out  dx,al
	out  dx,al

	mov  dl,0dah
horzb3a:in   al,dx
	test al,1
	jz   horzb3a 
       
	mov  dl,0c9h
	sub  al,al
	out  dx,al
	
	mov  dl,0d4h
	mov  al,13h
	out  dx,al
	inc  dx
	mov  al,80
	sub  al,scroll
	out  dx,al

	mov  dl,0dah
horzb3b:in   al,dx
	test al,1
	jnz  horzb3b 
	mov  dl,0dah
horzb3c:in   al,dx
	test al,1
	jz   horzb3c
	
	mov  dl,0dah
horzb4a:in   al,dx
	test al,1
	jz   horzb4a 
       
	mov  dl,0d4h
	mov  al,13h
	out  dx,al
	inc  dx
	mov  al,80
	out  dx,al
	
	mov  dl,0dah
horzb4b:in   al,dx
	test al,1
	jnz  horzb4b 
	mov  dl,0dah
horzb4c:in   al,dx
	test al,1
	jz   horzb4c
      
	sti
	ret

putpal: mov  si,offset palette
	mov  dx,03c8h
	mov  al,0
	out  dx,al
	inc  dx
	mov  cx,768
palloop:outsb
	loop palloop
	ret

zeropal:
	mov  dx,03c8h
	mov  al,0
	out  dx,al
	inc  dx
	mov  cx,768
	mov  al,0
rep     out  dx,al
	ret

putpic1: 
	push ds
	mov  ax,0a000h      
	mov  es,ax
	mov  ax,seg PICT1
	mov  ds,ax
	mov  si,offset PICT1
	mov  di,logo
	mov  bx,70
	
	mov  dx,03c4h
	mov  ax,0102h
	out  dx,ax
pic1loop1:  
	mov  cx,8
rep     movsd
	movsw
	movsb
	add  di,125
	dec  bx
	jne  pic1loop1
	
	mov  di,logo  
	mov  bx,70
	mov  ax,0202h
	out  dx,ax
pic1loop2:  
	mov  cx,8
rep     movsd
	movsw
	movsb
	add  di,125
	dec  bx
	jne  pic1loop2
	
	mov  di,logo  
	mov  bx,70    
	mov  ax,0402h
	out  dx,ax
pic1loop3:  
	mov  cx,8
rep     movsd
	movsw
	movsb
	add  di,125
	dec  bx
	jne  pic1loop3

	mov  di,logo  
	mov  bx,70
	mov  ax,0802h
	out  dx,ax
pic1loop4:  
	mov  cx,8
rep     movsd
	movsw
	movsb
	add  di,125
	dec  bx
	jne  pic1loop4
	pop  ds
	ret

putpic2: 
	push ds
	mov  ax,0a000h      
	mov  es,ax
	mov  ax,seg PICT2
	mov  ds,ax
	mov  si,offset PICT2
	mov  di,logo
	add  di,3875
	mov  bx,60
	
	mov  dx,03c4h
	mov  ax,0102h
	out  dx,ax
pic2loop1:  
	mov  cx,8
rep     movsd
	movsw
	add  di,126
	dec  bx
	jne  pic2loop1
	
	mov  di,logo
	add  di,3875 
	mov  bx,60
	mov  ax,0202h
	out  dx,ax
pic2loop2:  
	mov  cx,8
rep     movsd
	movsw
	add  di,126
	dec  bx
	jne  pic2loop2
	
	mov  di,logo
	add  di,3875 
	mov  bx,60    
	mov  ax,0402h
	out  dx,ax
pic2loop3:  
	mov  cx,8
rep     movsd
	movsw
	add  di,126
	dec  bx
	jne  pic2loop3

	mov  di,logo
	add  di,3875 
	mov  bx,60
	mov  ax,0802h
	out  dx,ax
pic2loop4:  
	mov  cx,8
rep     movsd
	movsw
	add  di,126
	dec  bx
	jne  pic2loop4
	pop  ds
	ret

putpic3: 
	push ds
	mov  ax,0a000h      
	mov  es,ax
	mov  ax,seg PICT3
	mov  ds,ax
	mov  si,offset PICT3
	mov  di,logo
	add  di,80
	mov  bx,70
	
	mov  dx,03c4h
	mov  ax,0102h
	out  dx,ax
pic3loop1:  
	mov  cx,11
rep     movsd
	movsw
	add  di,114
	dec  bx
	jne  pic3loop1
	
	mov  di,logo
	add  di,80 
	mov  bx,70
	mov  ax,0202h
	out  dx,ax
pic3loop2:  
	mov  cx,11
rep     movsd
	movsw
	add  di,114
	dec  bx
	jne  pic3loop2
	
	mov  di,logo
	add  di,80 
	mov  bx,70    
	mov  ax,0402h
	out  dx,ax
pic3loop3:  
	mov  cx,11
rep     movsd
	movsw
	add  di,114
	dec  bx
	jne  pic3loop3

	mov  di,logo
	add  di,80 
	mov  bx,70
	mov  ax,0802h
	out  dx,ax
pic3loop4:  
	mov  cx,11
rep     movsd
	movsw
	add  di,114
	dec  bx
	jne  pic3loop4
	pop  ds
	ret

putchaos:
	push ds
	mov  ax,0a000h      
	mov  es,ax
	mov  ax,seg CHAOS2   
	mov  ds,ax
	mov  si,offset CHAOS2  
	mov  di,7539
	mov  bx,40
	
	mov  dx,03c4h
	mov  ax,0102h
	out  dx,ax
rast1loop1:  
	mov  cx,10
rep     movsd
	movsw
	add  di,118
	dec  bx
	jne  rast1loop1
	
	mov  di,7539
	mov  bx,40
	mov  ax,0202h
	out  dx,ax
rast1loop2:  
	mov  cx,10
rep     movsd
	movsw
	add  di,118
	dec  bx
	jne  rast1loop2
	
	mov  di,7539  
	mov  bx,40    
	mov  ax,0402h
	out  dx,ax
rast1loop3:  
	mov  cx,10
rep     movsd
	movsw
	add  di,118
	dec  bx
	jne  rast1loop3

	mov  di,7539  
	mov  bx,40
	mov  ax,0802h
	out  dx,ax
rast1loop4:  
	mov  cx,10
rep     movsd
	movsw
	add  di,118
	dec  bx
	jne  rast1loop4
	pop  ds
	ret

txt:    
	mov  ax,0a000h
	mov  es,ax
	mov  loopc,0
	mov  di,15840
textc:  push di 
nxtchar:mov  bx,cx
	add  bx,textcount
	mov  al,text[bx]
	test al,al
	jne  justdi
	mov  textcount,0
	jmp  nxtchar

justdi: sub  al,32
	sub  ah,ah
	mov  cx,16*15
	mul  cx
	mov  si,ax
	add  si,offset font
	mov  dx,03c4h
	mov  ax,0102h
	out  dx,ax
	pop  di
	push di
	mov  cx,15
txtlp1: movsd
	add  di,156
	loop txtlp1
	
	mov  ax,0202h
	out  dx,ax
	pop  di
	push di
	mov  cx,15
txtlp2: movsd
	add  di,156
	loop txtlp2
	
	mov  ax,0402h
	out  dx,ax
	pop  di
	push di
	mov  cx,15
txtlp3: movsd
	add  di,156
	loop txtlp3
	
	mov  ax,0802h
	out  dx,ax
	pop  di
	add  di,4
	push di
	sub  di,4
	mov  cx,15
txtlp4: movsd    
	add  di,156
	loop txtlp4
	
	pop  di
	inc  loopc
	cmp  loopc,21
	jne  textc
	ret

WaitNextVR  MACRO             ; wait for NEXT Vertical Retrace
LOCAL   w1, w2        
	mov     dx,03DAh
w1:     in      al,dx           ; wait for a non-retrace period
	test    al,8
	jnz     w1

w2:     in      al,dx
	test    al,8            ; wait for retrace
	jz      w2
ENDM

Timer:           ; the actual timer routine

	push    ax
	push    bx
	push    cx
	push    dx
	push    si                      ; save normal 8086 registers
	push    di
	push    bp
	push    ds
	push    es

	mov     al,20h                  ; send End Of Interrupt signal
	out     20h,al                  ; to PIC

	mov     dx,seg TmrVal           ; point DS to proper data segment
	mov     ds,dx

	mov     dx,03DAh
@@wnvr: in      al,dx                   ; wait until we are _not_ in a
	test    al,8                    ; retrace (just to make sure...)
	jnz     @@wnvr

	call    PreVR                   ; call the Pre-VR function
	
	mov     bx,TmrVal             ; count for timer chip
	
	mov     dx,03DAh
@@wvr:  in      al,dx                   ; wait for the retrace
	test    al,8
	jz      @@wvr

	mov     al,30h                  ; counter mode 0 - interrupt on
	out     43h,al                  ; terminal count
	mov     al,bl
	out     40h,al                  ; set timer count and restart timer
	mov     al,bh
	out     40h,al
	
	call    VR         ; call the VR function

	clc
	;mov     ah,3                ; play music
	;call DWORD PTR cs:[Player]
	
	
	
	;mov     ax,TmrVal
	;add     DOSTmrCnt,ax          ; add timer count to DOS timer count
	;jnc     @@noDOSTmr              ; if carry set (count 65536), call
					; DOS timer
	pushf
	call    [OldTmr]              ; call old timer
	 
@@noDOSTmr:
	pop     es
	pop     ds
	pop     bp
	pop     di
	pop     si                      ; restore saved registers
	pop     dx
	pop     cx
	pop     bx
	pop     ax

	iret

InitVRServer:

	push    ds

	mov     ax,3508h                ; save old interrupt 8 vector
	int     21h
	mov     word ptr OldTmr,bx
	mov     word ptr OldTmr+2,es

	mov     ax,seg Timer
	mov     ds,ax
	mov     dx,offset Timer         ; set new timer interrupt
	mov     ax,2508h
	int     21h
	
	pop     ds

	call    SyncVRServer           ; synchronize timer to display refresh

	ret

SyncVRServer:

	cli                             ; disable interrupts for maximum
					; accuracy
@@read:
	WaitNextVR                      ; wait for next Vertical Retrace

	mov     al,36h
	out     43h,al
	sub     al,al                   ; reset the timer
	out     40h,al
	out     40h,al


	WaitNextVR                      ; wait for next Vertical Retrace

	sub     al,al
	out     43h,al
	in      al,40h
	mov     ah,al
	in      al,40h                  ; read timer count - time between
	xchg    al,ah                   ; two Vertical Retraces
	neg     ax
	mov     TmrVal,ax


	WaitNextVR                      ; wait for next Vertical Retrace

	mov     al,36h
	out     43h,al
	sub     al,al                   ; reset timer again
	out     40h,al
	out     40h,al


	WaitNextVR                      ; wait...

	sub     al,al
	out     43h,al
	in      al,40h
	mov     ah,al                   ; and read the timer count again
	in      al,40h
	xchg    al,ah
	neg     ax

	mov     dx,ax

	sub     dx,TmrVal
	cmp     dx,2                    ; If the difference between the two
	jg      @@read                  ; values read was >2, read again.
	cmp     dx,-2
	jl      @@read

	mov     bx,FRAME            ; Time between two interrupts is
	mul     bx                      ; FRAMETIME/10 % of the total time
	mov     bx,1000                 ; between two Vertical Retraces.
	div     bx

	shr     ax,1
	mov     TmrVal,ax             ; timer chip count

	mov     bx,TmrVal

	WaitNextVR                      ; wait for Vertical Retrace

	mov     al,30h                  ; counter mode 0 - interrupt on
	out     43h,al                  ; terminal count
	mov     al,bl                   ; Restart timer with the new speed
	out     40h,al                  ; right after the beginning of the
	mov     al,bh                   ; Retrace.
	out     40h,al

	mov     DOSTmrCnt,0           ; count used in calling the old timer

	mov     al,20h                  ; send EOI signal to the PIC
	out     20h,al

	sti                             ; enable ints

	ret

RemoveVRServer:

	cli                             ; disable interrupts

	mov     al,36h                  ; DOS default timer mode
	out     43h,al
	sub     al,al                   ; set timer count to 65536 - 18.2Hz
	mov     al,0FFh                 ; (DOS default)
	out     40h,al
	out     40h,al

	push    ds
	mov     ax,2508h
	mov     dx,word ptr OldTmr        ; restore old timer int
	mov     ds,word ptr OldTmr+2
	int     21h
	pop     ds

	mov     al,20h                  ; send EOI signal to PIC
	out     20h,al

	mov     al,36h                  ; DOS default timer mode
	out     43h,al
	sub     al,al                   ; set timer count to 65536 - 18.2Hz
	mov     al,0FFh                 ; (DOS default)
	out     40h,al
	out     40h,al

	sti                             ; enable interrupts
	ret

PlayM:  call DWORD PTR cs:[Player]
rtn:    ret

Player    DW     0,0

ends main 

musicseg segment para use32 
include alibi.inc
ends musicseg

end
