// Star.h
//
// Copyright (C) 1998 by David A Henry (VuLgAr UnIcOrN)
// dhenry@bigfoot.com

#ifndef STAR_H
#define STAR_H

class CStar  
{
public:
	CStar(void);
	~CStar(void);
	// resets static members
	void reset(void);
	// undraws the star and calcs new pos and redraws
	void update(CDC* pDC, const CRect& rect);
	// zeroes the x / y values of star
	void restartHorizontal(void);
	void restartVertical(void);
	// generates a random number between 0 and cap-1
	inline unsigned int CStar::getRandomNumber(unsigned int cap = 2);
	// gets and sets
	void setReverse(bool inReverse);
	bool getReverse(void) const;
	void setVertical(bool inVertical);
	bool getVertical(void) const;
	void setRed(bool inRed);
	bool getRed(void) const;
	void setGreen(bool inGreen);
	bool getGreen(void) const;
	void setBlue(bool inBlue);
	bool getBlue(void) const;
	void setSmooth(bool inSmooth);
	bool getSmooth(void) const;
private:
	// perform the actual drawing / undrawing of the star
	// called from update
	void draw(CDC* pDC, unsigned int r, unsigned int g, unsigned int b, bool change = true);
	// the position of this star
	unsigned int x;
	unsigned int y;
	// this is used to control the brightness of the star
	// it also controls the speed of the star and the size of the star
	// because they are all related... the further back a star is the
	// dimmer and slower and smaller it will be
	unsigned int lightSpeedSize;
	bool first;
	// these are static flags for ALL stars. This does not work too well
	// with multiple views... maybe this should be in the view!?
	static bool reverse; // reverse the direction of the stars
	static bool vertical; // go up and down instead of left and right
	static bool red; // draw stars with a red hue
	static bool green; // draw stars with a green hue
	static bool blue; // draw stars with a blue hue
	static bool smooth; // use a diffrent movement algoritim for moving the stars
						// it is smother but slower
};

// resets all the static variables
// should be called when the doc closes
inline void CStar::reset(void)
{
	this->reverse = false;
	this->vertical = false;
	this->red = false;
	this->green = false;
	this->blue = false;
	this->smooth = false;
}

inline unsigned int CStar::getRandomNumber(unsigned int cap /*=2*/)
{
	return unsigned int((double(::rand())/RAND_MAX)*cap);
}

inline void CStar::setReverse(bool inReverse)
{
	this->reverse = inReverse;
}

inline bool CStar::getReverse(void) const
{
	return this->reverse;
}

inline void CStar::setVertical(bool inVertical)
{
	this->vertical = inVertical;
}

inline bool CStar::getVertical(void) const
{
	return this->vertical;
}

inline void CStar::setRed(bool inRed)
{
	this->red = inRed;
}

inline bool CStar::getRed(void) const
{
	return this->red;
}

inline void CStar::setGreen(bool inGreen)
{
	this->green = inGreen;
}

inline bool CStar::getGreen(void) const
{
	return this->green;
}

inline void CStar::setBlue(bool inBlue)
{
	this->blue = inBlue;
}

inline bool CStar::getBlue(void) const
{
	return this->blue;
}

inline void CStar::setSmooth(bool inSmooth)
{
	this->smooth = inSmooth;
}

inline bool CStar::getSmooth(void) const
{
	return this->smooth;
}

#endif // STAR_H
