{--------------------------------------------------------------------}
{ Real-Time-Plasma in textmode                                       }
{ Coded by Sir [HS] of BiokilL                                      }
{ E-Mail: h0sieber@rks.harz.ni.schule.de                             }
{ BiokilL Demogroup WWW-Homepage:                                    }
{ http://www.rks.harz.ni.schule.de/~t0quetsc/BKL.html                }
{--------------------------------------------------------------------}
{$S-}

uses CRT;

const BR=80;
      H =50;
      DE=100;
      MO=$3;

var TAB           :array[1..2,0..255]of byte;
    X,Y           :byte;
    A,AA,B,BB,C   :byte;
    PO            :pointer;
    SP            :word;

{------------------------------------------------------------------------}
{                                                INITPLASMA              }
{------------------------------------------------------------------------}
procedure INITPLASMA;
BEGIN
  getmem(PO,4000);
  fillchar(PO^,4000,0);
  SP:=seg(PO^);
  for X:=0 to 255 do begin
    TAB[1,X]:=round(sin(2*pi*X/255)*128)+128;
    TAB[2,X]:=round(cos(2*pi*X/255)*128)+128;
  END;
  A:=20;
  B:=80;
END;
{------------------------------------------------------------------------}
{                                                DOPLASMA                }
{------------------------------------------------------------------------}
procedure DOPLASMA;
var OFFSS         :word;
    ABSTAND       :byte;
BEGIN
  ASM
    sub  A,1
    add  B,2
  END;
  for Y:=0 to H-1 do begin
    AA:=TAB[1,(Y+A) mod 255];
    BB:=TAB[1,B mod 255];
    X:=0;
    repeat;
      C:=TAB[1,(X+AA) mod 255]+TAB[2,(Y+BB) mod 255];
      C:=C mod 16;
      OFFSS:=(Y*BR+X)shl 1;
      mem[$b800:OFFSS]:=219;
      mem[$b800:OFFSS+1]:=C;
      inc(X);
    until X>=BR;
  END;
END;
{------------------------------------------------------------------------}
{                                                MAIN                    }
{------------------------------------------------------------------------}
BEGIN
  ASM
    mov  ah,00h
    mov  al,MO
    int  10h

    mov  ax,1112h
    mov  bl,0h
    int  10h
  END;
  INITPLASMA;

  repeat
    DOPLASMA;
    delay(DE);
  until keypressed;

  textmode(3);
  dispose(PO);
END.
