#include <stdio.h>
#include <math.h>


//transparent LUT
unsigned char transparent[256][256];

void make_transLUT(unsigned char *pal)
{
    int i,j,k,error,best_match,index;
    float trans = .5,how_close;
    float Trans_RED,Trans_GREEN,Trans_BLUE;
    float red[256],green[256],blue[256];


    //strip out rgb components into separate arrays
    for(index=i=0;i<768;i+=3)
    {
	red[index] = pal[i];
	green[index] = pal[i+1];
	blue[index] = pal[i+2];
	index++;
    }

    for(i=0;i<256;i++)
    {
	for(j=0;j<256;j++)
	{
	    printf("Processing Row: %d Column: %d\r",i,j);

	    //calculate transparent color
	    Trans_RED = red[i]*trans+red[j]*(1-trans);
	    Trans_GREEN = green[i]*trans+green[j]*(1-trans);
	    Trans_BLUE = blue[i]*trans+blue[j]*(1-trans);

	    //set error to impossible value
	    error = 256000;
	    best_match = 0;
	    for(k=0;k<256;k++)
	    {
		//calculate space between color that we want (Trans) and the
		//current color in the palette (k)
		how_close = sqrt((Trans_RED - red[k]) * (Trans_RED - red[k]) +
			          (Trans_GREEN - green[k]) * (Trans_GREEN - green[k]) +
				  (Trans_BLUE - blue[k]) * (Trans_BLUE - blue[k]));
	        if(how_close < error)
		{
		    best_match = k;
		    error = how_close;
		}
	    }
	    //best_match is the closest color to (Trans) in the palette
	    // j=foreground index i=background index
	    transparent[j][i] = best_match;
	}
    }
}



void main(void)
{
	unsigned char pal[768];
	int x,y;
	FILE *fp;
	
        //read palette in
	fp = fopen("picture.pal","rb");
     	fread(pal,sizeof(unsigned char),768,fp);
	fclose(fp);

	printf("Making trans LUT...\n");
	make_transLUT(pal);
	
        printf("Writing to disk...\n");

        //open a file to write to
	fp = fopen("picture.lut","wb");
	if(fp == NULL) printf("couldnt open file\n");
	for(y=0;y<256;y++)
	 for(x=0;x<256;x++)
          fwrite(&transparent[x][y],sizeof(unsigned char),1,fp);
	fclose(fp);
}
