/* Real quickie on 2d array indexing:
   int array2d[30][30];

   to get to row 5 column 16 normally you do
   x = array2d[5][16]

   I like to do this:
   x = arra2d[16*30+5]

   I do it for 2 reasons:
   1. sometimes watcom blows up if i make 2d arrays too big
   2. if your 2d array widths are powers of 2 you can shift
      (oldest optimization known to man...)
*/

#include <stdio.h>
#include <conio.h>

#define PALETTE_MASK 0x3C6
#define PALETTE_REGISTER_RD 0x3C7
#define PALETTE_REGISTER_WR 0x3C8
#define PALETTE_DATA 0x3C9

#define plot_pixel(x,y,color) buffer[((y<<8) + (y<<6)) + x] = color
#define get_pixel(x,y) buffer[((y<<8) + (y<<6)) + x]


typedef struct RGB_color_typ
		{
			unsigned char red;
			unsigned char green;
			unsigned char blue;
		} RGB_color, *RGB_color_ptr;

unsigned char  *video_buffer = (char *)0x0a0000;
unsigned char  *buffer = (char *) 0x0a0000;

void Set_Video_Mode(void);
#pragma aux Set_Video_Mode = \
	"mov eax,013h"\
	"int 10h" \
	modify [eax];

void Set_Text_Mode(void);
#pragma aux Set_Text_Mode = \
	"mov eax,003h"       \
	"int 10h " \
	modify [eax];

void Set_Palette_Register(int index, RGB_color_ptr color)
{
	outp(PALETTE_MASK,0xff);
	outp(PALETTE_REGISTER_WR,index);
	outp(PALETTE_DATA,color->red);
	outp(PALETTE_DATA,color->green);
	outp(PALETTE_DATA,color->blue);
}


void load_palette(unsigned char palette[768])
{
  RGB_color pal;
  int i;
  for(i=0;i<768;i+=3)
  {
   pal.red = palette[i];  pal.green = palette[i+1]; pal.blue = palette[i+2];
   Set_Palette_Register(i/3,(RGB_color_ptr)&pal);
  }
}

main()
{
    unsigned char *trans,*dbl_buf,*picture,*bitmap,pal[768];

    FILE *fp;
    int x,y,x2;

    fp = fopen("picture.lut","rb");
    if(fp == NULL)
    {
      printf("Unable to open picture.lut\n");
      exit(1);
    }

    //malloc necessary size
    trans = (unsigned char *) malloc (sizeof(unsigned char)*256*256);

    //load the LUT into memory
    for(y=0;y<256;y++)
     for(x=0;x<256;x++)
      fread(&trans[y*256+x],1,1,fp);
    fclose(fp);

    //malloc memory for picture
    picture = (unsigned char *) malloc(sizeof(unsigned char)*64000);


    //malloc memory for double buffer
    dbl_buf = (unsigned char *) malloc(sizeof(unsigned char)*64000);

    //malloc memory for bitmap to be scrolled across screen
    bitmap = (unsigned char *) malloc(sizeof(unsigned char)*25*110);

    //load the picture into memory and its palette
    fp = fopen("picture.raw","rb");
    fread(picture,sizeof(unsigned char),64000,fp);
    fclose(fp);

    //use mode 13h
    Set_Video_Mode();

    //load the palette into the VGA registers
    fp = fopen("picture.pal","rb");
    fread(pal,1,768,fp);
    fclose(fp);
    load_palette(pal);

    buffer = picture;

    // strip out a bitmap from the upper left corner of the picture
    // 110x25
    for(y=0;y<25;y++)
     for(x=0;x<110;x++)
      bitmap[y*110+x] = get_pixel(x+1,y);

    buffer = dbl_buf;
    for(x2=0;x2<319-110;x2++)
    {
	//copy picture to boudble buffer
	memcpy(dbl_buf,picture,64000);

	//plot the transparent color using the LUT writing to
	//double buffer
	//trans[FOREGROUND][BACKGROUND]
	for(y=0;y<25;y++)
	 for(x=0;x<110;x++)
	  plot_pixel(x2+x,y+25,trans[bitmap[y*110+x] + picture[(y+25)*320+x2+x]*256]);
	//                          ^^^^^^^^^^^^^^^^   ^^^^^^^^^^^^^^^^^^^^
	//                          foreground color   background color
	//				  row                column
	//blast to screen
	memcpy(video_buffer,dbl_buf,64000);
    }

    //back into text mode 03h
    getch();
    Set_Text_Mode();
}



