program crunch_animation; {(c) 1996 by Daniel Vollmer}
const NumFrames:word=18;
      InpRes=4;
      OutRes:byte=InpRes;
      InName='test\new-';
      OutName='beet';
type frametype=array[1..(256 div InpRes)*(256 div InpRes)] of byte;
var frame:^frametype;

procedure readframe(Name:string;ccc:word);
var
   f:file;
   s:string;
begin
     getmem(frame,sizeof(frametype));
     str(ccc+1,s);
     assign(f,Name+s+'.'+'raw');

     reset(f,1);
     BlockRead(f,frame^,sizeof(frametype));
     close(f);
end;

{procedure makepic;
const
     Size=8;
     Num=256 div Size;
     Shi=3;

function getpix(x,y:byte):byte;
var c,c2:word;
    l:longint;
begin
     l:=0;
     for c:=0 to Size-1 do for c2:=0 to Size-1 do
     inc(l,mem[vseg:(y shl shi+c) shl 8+x shl shi+c2]);
     getpix:=l div (Size*Size div 2);
end;

var
   f:file;
   c,c2:word;
   s:string;
   b:byte;
begin
     str(cc,s);
     assign(f,'..\anim\Test.'+s);
     rewrite(f,1);
     for c:=0 to Num-1 do for c2:=0 to Num-1 do begin
         b:=getpix(c2,c);
         BlockWrite(f,b,1);
     end;
     close(f);
end;}

function getmarker(a:frametype):byte;
var c:word;
    r:array[0..255] of word;
    num:byte;
    high:word;
begin
     fillchar(r,sizeof(r),0);
     for c:=1 to (256 div InpRes)*(256 div InpRes) do inc(r[a[c]]);
     high:=65535;num:=255;
     for c:=0 to 255 do if r[c]<=high then begin
         high:=r[c];
         num:=c;
     end;
     getmarker:=num;
end;

procedure compress(ff:frametype;Name:string;ccc:word);
var num,lastbyte,nowbyte,marker,te:byte;
    c,counter:Word;
    f:file;
    s:string;
begin
     marker:=getmarker(ff);
     str(ccc,s);

     assign(f,Name+'.'+s);
     rewrite(f,1);
     BlockWrite(f,OutRes,sizeof(byte));
     if (OutRes=128) or (OutRes=64) then begin
        BlockWrite(f,ff,sizeof(FrameType));
        close(f);
        exit;
     end;

     BlockWrite(f,marker,sizeof(byte));
     lastbyte:=ff[1];
     num:=0;
     counter:=1;
     repeat
          nowbyte:=ff[counter];
          inc(counter);
          if counter>sizeof(frametype) then begin
             if nowbyte=lastbyte then inc(num);
             if (num>3) or (LastByte=Marker) then begin
                 BlockWrite(f,marker,sizeof(byte));
                 BlockWrite(f,num,sizeof(byte));
                 BlockWrite(f,LastByte,sizeof(byte));
             end else for c:=1 to Num do BlockWrite(f,LastByte,sizeof(byte));
          end else if nowbyte=lastbyte then begin
             inc(num);
             if num=255 then begin
                BlockWrite(f,marker,sizeof(byte));
                BlockWrite(f,num,sizeof(byte));
                BlockWrite(f,LastByte,sizeof(byte));
                Num:=0;
             end;
          end else begin
              if (num>3) or (LastByte=Marker) then begin
                 BlockWrite(f,marker,sizeof(byte));
                 BlockWrite(f,num,sizeof(byte));
                 BlockWrite(f,LastByte,sizeof(byte));
              end else for c:=1 to Num do BlockWrite(f,LastByte,sizeof(byte));
              num:=1;
              lastbyte:=nowbyte;
          end;
     until counter>sizeof(frametype);
     freemem(frame,sizeof(frametype));
     close(f);
end;

var c,w:word;
    f,f2:file;
    s:string;
begin
     for c:=0 to NumFrames do begin
         readframe(InName,c);
         compress(frame^,'Temp',c);
     end;
     assign(f,OutName+'.ani');
     rewrite(f,1);
     BlockWrite(f,NumFrames,sizeof(word));
     for c:=0 to NumFrames do begin
         str(c,s);
         assign(f2,'Temp.'+s);
         reset(f2,1);
         w:=filesize(f2);
         close(f2);
         BlockWrite(f,w,sizeof(word));
     end;
     getmem(frame,sizeof(frametype));
     for c:=0 to NumFrames do begin
         str(c,s);
         assign(f2,'Temp.'+s);
         reset(f2,1);
         BlockRead(f2,frame^,filesize(f2));
         BlockWrite(f,frame^,filesize(f2));
         close(f2);
         assign(f2,'Temp.'+s);
         erase(f2);
     end;
     freemem(frame,sizeof(frametype));
     close(f);
end.