unit DFFS2;               { Daniel`s fabolous file-system Version 2.54 !! }
interface                 { (c) 1996 by Daniel Vollmer }
uses SupPack;
{{$DEFINE debug}
const
d2_key : byte = 0;
{$IFDEF debug} d2_messages : boolean = false; {$ENDIF}
d2_MaxFiles=64;
d2_Header = 'DFFS2';
d2_Version = '2.54';
{$i dffs2.inc} {ansi-header}
type
    Enh_File = record
                     Name         : string[18];
                     Crunched     : boolean;
                     Size         : longint;
                     OrgSize      : longint;
                     Offset       : longint;
               end;
    IndexType =  array[1..d2_MaxFiles] of Enh_File;
    BuffType  =  array[1..65535] of byte;
var
   d2_NumofFiles : byte;
   d2_Index      : ^IndexType;
{----------------------------------------------------------------------------}
function  Init_Dat( Name : string):boolean;
{ Initialisiert DAT-File und allokiert Speicher etc.  }
function  FileExists(dname : string) : boolean;
{ File da ? (Bei 0 Bytes Gre FileExists:=false!)    }
function  Num( Name : String ) : byte;
{ Gibt Nummer des Files (oder 0) zurueck...           }
procedure PrintLogo;
{ Mmmmmhhhh... Logo halt :) thx to KRASh...           }
procedure CloseDffS;
{ Close DAT-File und GiveBack Mem                     }
procedure dir(YSize:byte);
{ Hmm... dir halt :)                                  }
procedure ReadFile2Disk( Name : string; NewName : string );
{ Schreibt (& entpackt) File auf Disk als NewName     }
function ReadFile2Ram( Name : string;HowMuchAlloc:Word):pointer;
{ Schreibt (& entpackt) File ins RAM und gibt Pointer }
procedure WriteFile2DAT( Name : string; NewName : string );
{ Hngt File ans DAT-File an...                       }
{----------------------------------------------------------------------------}

implementation

{----------------------------------------------------------------------------}

var
   d2_Buffer     : ^BuffType;
   d2_CrunchBuff : ^BuffType;
   d2_p          : ^BuffType;
   d2_Jump       : longint;
   d2_ReadPos    : word;
   d2_ReadLeft   : word;
   d2_WritePos   : word;
   d2_DatFile    : file;
   d2_WorkFile   : file;
   d2_infile     : file;
   d2_outfile    : file;

{----------------------------------------------------------------------------}

function FileExists(dname : string) : boolean;
var dumf : file;
begin;
  {$I-}
  FileExists:=false;
  assign(dumf,dname);
  reset(dumf,1);
  if IOResult = 0 then begin
    if FileSize(dumf)>0 then FileExists:=true;
    close(dumf);
  end;
end;

{----------------------------------------------------------------------------}

function Init_Dat( Name : string):boolean;
var
DosName1 : string;
Head     : array[1..length(d2_Header)] of char;
begin
     GetMem(d2_Index,sizeof(IndexType));
     GetMem(d2_Buffer,sizeof(BuffType));
     DosName1 := Name + '.DAT';
     assign(d2_DatFile, DosName1);
     if FileExists(Dosname1) then begin
        reset(d2_DatFile,1);
        BlockRead(d2_DatFile,Head,sizeof(Head));
        if Head=d2_Header then begin
           BlockRead(d2_DatFile,d2_Jump,sizeof(LongInt));
           seek(d2_DatFile,d2_Jump);
           BlockRead(d2_DatFile,d2_NumOfFiles,sizeof(Byte));
           BlockRead(d2_DatFile,d2_Index^,sizeof(Enh_File)*d2_NumOfFiles);
           Init_Dat:=true;
        end else begin
{$IFDEF debug}  if d2_messages then writeln('Init_Dat: Wrong Header!'); {$ENDIF}
          close(d2_DatFile);
          halt(1);
        end;
     end else begin
        rewrite(d2_DatFile,1);
        d2_NumOfFiles := 0;
        d2_Jump := length(d2_Header)+sizeof(LongInt);
        Init_Dat:=false;
     end;
end;

{----------------------------------------------------------------------------}

procedure CloseDffS;
begin
     freemem(d2_Buffer,sizeof(BuffType));
     freemem(d2_Index,sizeof(IndexType));
     close(d2_DatFile);
end;

{----------------------------------------------------------------------------}

procedure dir(YSize:byte);
var
Counter : word;
begin
     for Counter := 1 to d2_NumOfFiles do
     with d2_Index^[Counter] do begin
          write(Counter,'. Name: ',Name,', Size: ',OrgSize,' Bytes');
          if crunched then writeln(' [',Size,' Bytes crunched].') else writeln('.');
          if counter mod (YSize-1)=0 then
          asm
             mov ah, $07
             int $21
          end; {readkey}
     end;
end;

{----------------------------------------------------------------------------}

function Num(Name:String):byte;
var
Counter : word;
Res:byte;
begin
     Res:=0;
     Counter:=1;
     repeat
           if d2_Index^[Counter].Name = Name then Res := Counter;
           inc(Counter);
     until (Counter>d2_NumOfFiles) or (Res=Counter-1);
{$IFDEF debug} if d2_messages then if Res=0 then writeln('Num: File `',Name,'` not in DAT-File!'); {$ENDIF}
     Num:=Res;
end;

{----------------------------------------------------------------------------}

procedure PrintLogo;assembler;
asm
   mov     cx,50*160/2
   mov     ax,$0720 {lightgray space}
   push    $b800
   pop     es
   xor     di,di
   rep     stosw
   xor     di,di
   mov     si,offset ImageData
   MOV     CX,ImageData_Length
   JCXZ    @Done
   MOV     DX,DI
   XOR     AX,AX
   CLD
@LOOPA:
   LODSB
   CMP     AL,32
   JC      @ForeGround
   STOSW
@Next:
   LOOP   @LOOPA
   JMP    @Done
@ForeGround:
   CMP     AL,16
   JNC     @BackGround
   AND     AH,0F0H
   OR      AH,AL
   JMP     @Next
@BackGround:
   CMP     AL,24
   JZ      @NextLine
   JNC     @FlashBitToggle
   SUB     AL,16
   ADD     AL,AL
   ADD     AL,AL
   ADD     AL,AL
   ADD     AL,AL
   AND     AH,8FH
   OR      AH,AL
   JMP     @Next
@NextLine:
   ADD     DX,160
   MOV     DI,DX
   JMP     @Next
@FlashBitToggle:
   CMP     AL,27
   JC      @MultiOutput
   JNZ     @Next
   XOR     AH,128
   JMP     @Next
@MultiOutput:
   CMP     AL,25
   MOV     BX,CX
   LODSB
   MOV     CL,AL
   MOV     AL,32
   JZ      @StartOutput
   LODSB
   DEC     BX
@StartOutput:
   XOR     CH,CH
   INC     CX
   REP STOSW
   MOV     CX,BX
   DEC     CX
   LOOPNZ  @LOOPA
@Done:
   mov     dx,(ImageData_Depth+1) shl 8
   xor     bh,bh
   mov     ah,02h
   int     10h
end;


{----------------------------------------------------------------------------}

procedure UpdateDat;
var
Counter : word;
Head    : array[1..length(d2_Header)] of char;
begin
     d2_Index^[1].Offset := Length(d2_Header)+sizeof(LongInt);
     for Counter := 1 to d2_NumOfFiles-1 do
     d2_Index^[Counter+1].Offset:=d2_Index^[Counter].Offset+d2_Index^[Counter].Size;
     Head:=d2_Header;
     d2_Jump:=d2_Index^[d2_NumOfFiles].Offset+d2_Index^[d2_NumOfFiles].Size;
     reset(d2_DatFile,1);
     BlockWrite(d2_DatFile,Head,sizeof(Head));
     BlockWrite(d2_DatFile,d2_Jump,sizeof(LongInt));
     seek(d2_DatFile,d2_Jump);
     BlockWrite(d2_DatFile,d2_NumOfFiles,sizeof(Byte));
     BlockWrite(d2_DatFile,d2_Index^,sizeof(Enh_File)*d2_NumOfFiles);
end;


{----------------------------------------------------------------------------}
Function ReadProc(u: Pointer; Var Buffer; Var Size: Word): Integer; Far;
Begin
  BlockRead (d2_infile, Buffer, Size, Size) ;
  ReadProc := PACK_NOERR;
End ;

Function WriteProc(u: Pointer; Var Buffer; Size: Word): Integer; Far;
Begin
  BlockWrite (d2_outfile, buffer, Size) ;
  writeproc := PACK_NOERR;
End ;

Function RamReadProc(u: Pointer; Var Buffer; Var Size: Word): Integer; Far;
Begin
  if d2_ReadLeft>=Size then move(d2_Buffer^[d2_ReadPos],Buffer,Size)
  else begin
      move(d2_Buffer^[d2_ReadPos],Buffer,d2_ReadLeft);
      Size:=d2_ReadLeft;
  end;
  dec(d2_ReadLeft,Size);
  inc(d2_ReadPos,Size);
  RamReadProc := PACK_NOERR;
End ;

Function RamWriteProc(u: Pointer; Var Buffer; Size: Word): Integer; Far;
Begin
  move(Buffer,d2_p^[d2_WritePos],Size);
  inc(d2_WritePos,Size);
  RamWriteProc := PACK_NOERR;
End ;

{----------------------------------------------------------------------------}

procedure ReadFile2Disk( Name : string; NewName : string );
var
Len     : word;
Counter : word;
begin
     if Num(Name)<>0 then begin
        with d2_Index^[Num(Name)] do begin
             if crunched then assign(d2_WorkFile,'DFFS2.$$$') else assign(d2_WorkFile,NewName);
             if not FileExists(NewName) then begin
                rewrite(d2_WorkFile,1);
                seek(d2_DatFile, Offset);
                for Len := 1 to Size div sizeof(BuffType) do begin
                    BlockRead(d2_DatFile, d2_Buffer^, sizeof(BuffType));
                    for Counter:=1 to sizeof(BuffType) do d2_Buffer^[Counter] := d2_Buffer^[Counter] xor d2_Key;
                    BlockWrite(d2_WorkFile, d2_Buffer^, sizeof(BuffType));
                end;
                BlockRead(d2_DatFile, d2_Buffer^, Size mod sizeof(BuffType));
                for  Counter:=1 to Size mod sizeof(BuffType) do d2_Buffer^[Counter] := d2_Buffer^[Counter] xor d2_Key;
                BlockWrite(d2_WorkFile, d2_Buffer^, Size mod sizeof(BuffType));
                Close(d2_WorkFile);
                if crunched then begin
                   Counter:=decode_mem_req;
                   getmem(d2_CrunchBuff,Counter);
                   Assign(d2_InFile,'DFFS2.$$$');
                   Reset(d2_InFile, 1);
                   Assign(d2_OutFile, NewName);
                   Rewrite(d2_OutFile, 1);
                   do_decode (Nil, readproc, writeproc, d2_CrunchBuff);
                   freemem(d2_CrunchBuff,Counter);
                   Close(d2_OutFile);
                   Close(d2_InFile);
                end;
             end {$IFDEF debug} else if d2_messages then writeln('ReadFile2Disk: File `',NewName,'` already exists!') {$ENDIF};
        end;
     end;
     if fileexists('DFFS2.$$$') then begin
        Assign(d2_WorkFile,'DFFS2.$$$');
        Erase(d2_WorkFile);
     end;
end;

{----------------------------------------------------------------------------}

function ReadFile2Ram( Name : string;HowMuchAlloc:Word):pointer;
var
Counter    : word;
begin
     with d2_Index^[Num(Name)] do begin
          seek(d2_DatFile, Offset);
          BlockRead(d2_DatFile, d2_Buffer^, Size);
          for Counter:=1 to Size do d2_Buffer^[Counter] := d2_Buffer^[Counter] xor d2_Key;
          getmem(d2_p,HowMuchAlloc);
          if crunched then begin
             Counter:=decode_mem_req;
             getmem(d2_CrunchBuff,Counter);
             d2_ReadPos:=1;
             d2_WritePos:=1;
             d2_ReadLeft:=Size;
             do_decode (Nil, ramreadproc, ramwriteproc, d2_CrunchBuff);
             freemem(d2_CrunchBuff,Counter);
          end else move(d2_Buffer^,d2_p^,Size);
          ReadFile2Ram:=d2_p;
          d2_p:=nil;
     end;
end;

{----------------------------------------------------------------------------}

procedure WriteFile2DAT( Name : string; NewName : string );
var
Counter : word;
NumRead,NumWrit :word;
begin
     assign(d2_WorkFile,Name);
     if not FileExists(Name) then
     {$IFDEF debug} begin if d2_messages then Writeln('WriteFile2DAT: File to append not found!'); end {$ENDIF}
     else begin
          Counter:=decode_mem_req;
          getmem(d2_CrunchBuff,Counter);
          inc(d2_NumOfFiles);
          d2_Index^[d2_NumOfFiles].Name := NewName;
          Assign(d2_InFile,Name);
          Reset(d2_InFile, 1);
          Assign(d2_OutFile,'DFFS2.$$$');
          Rewrite(d2_OutFile, 1);
          do_encode (Nil, readproc, writeproc, d2_CrunchBuff);
          freemem(d2_CrunchBuff,Counter);
          if filesize(d2_Outfile) < filesize(d2_infile) then begin
             d2_Index^[d2_NumOfFiles].Size := FileSize(d2_outfile);
             d2_Index^[d2_NumOfFiles].Crunched := true;
             Assign(d2_WorkFile,'DFFS2.$$$');
          end else begin
             d2_Index^[d2_NumOfFiles].Size := FileSize(d2_infile);
             d2_Index^[d2_NumOfFiles].Crunched := false;
             Assign(d2_WorkFile,Name);
          end;
          d2_Index^[d2_NumOfFiles].OrgSize:=FileSize(d2_infile);
          close(d2_InFile);
          close(d2_OutFile);
          reset(d2_WorkFile,1);
          seek(d2_DatFile, d2_Jump);
          repeat
                 BlockRead(d2_WorkFile, d2_Buffer^, sizeof(BuffType), NumRead);
                 for Counter:=1 to NumRead do d2_Buffer^[Counter] := d2_Buffer^[Counter] xor d2_Key;
                 BlockWrite(d2_DatFile, d2_Buffer^, NumRead, NumWrit);
          until (NumRead = 0) or ( NumWrit <> NumRead);
          Close(d2_WorkFile);
          UpdateDat;
          if fileexists('DFFS2.$$$') then begin
             Assign(d2_WorkFile,'DFFS2.$$$');
             Erase(d2_WorkFile);
          end;
     end;
end;

{----------------------------------------------------------------------------}
begin
     PrintLogo;
end.