// These packing routines are based on the LZHUF.C program by
// Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

#include <suppack.h>
#include <suppack.hpp>
#include <stddef.h>

// The two functions below are called from the packing library and redirect
// read/write functions to the C++ object. userdata is used to store
// the this pointer.

static int far pascal read(void far* userdata, char far *buffer,unsigned far* size) {
  return ((packing*)userdata)->read(buffer,size);
}

static int far pascal write(void far* userdata, char far* buffer, unsigned size) {
  return ((packing*)userdata)->write(buffer,size);
}

int packing::do_encode() {
  // Allocate buffer for data:
  char* workbuffer=new char[encode_mem_req()];
  if(workbuffer==NULL) return PACK_NO_MEM;

  // Start packing:
  int a=::do_encode(this,::read,::write,workbuffer);

  // Erase the buffer and return:
  delete workbuffer;
  return a;
}