{  These packing routines are based on the LZHUF.C program by
   Haruyasu Yoshizaki. Copyright (C) 1995 Christian Worm.

   This file holds the Pascal unit which makes the OOP interface for
   the assembler library.
}

Unit SupOPack;

Interface

Const
  { Declare errorcodes. Note that negative errorcodes are reserved
    for use by library.
  }
  PACK_NOERR=0;
  PACK_EOD=-1;

Type
  { The following object makes the interface for the (un)packer: }

  Packing=Object
    Function Read(Var Buffer:Byte; Var Size:Word):Integer;Virtual;
    { This function should read Size bytes to Buffer. In Size the number of
      bytes actually read should be stored. Should return PACK_NOERR or a
      possitive errorcode.
    }

    Function Write(Var Buffer:Byte; Size:Word):Integer;Virtual;
    { This function should write Size bytes from Buffer. Should return
      PACK_NOERR or a possitive errorcode.
    }

    Function DoDeCode:Integer;
    { This function does the unpacking. It returns PACK_NOERR if the
      unpacking were succesfull and returns PACK_EOD if the entier block
      of packed data couldn't be read. It returns PACK_NO_MEM if there
      isn't enough free-store memory. Returns the same as the read/write
      functions if they return an error code.
    }

    Function DoEnCode:Integer;
    { This starts packing. Returns as DoDeCoode (cannot return  PACK_EOD) }
  end;

{----------------------------------------------------------------------------}

Implementation

Uses SupPack;

Type
  PackPoint=^Packing;

Function ReadFunc(u:Pointer; Var Buffer: Byte; Var Size: Word): Integer; Far;
Begin
  ReadFunc:=PackPoint(u)^.Read(Buffer,Size);
End;

Function WriteFunc(u:Pointer; Var Buffer: Byte; Size: Word): Integer; Far;
Begin
  WriteFunc:=PackPoint(u)^.Write(Buffer,Size);
End;

Function Packing.DoDeCode:Integer;
Var
  m:Pointer;
Begin
  GetMem(m,DeCode_Mem_Req);
  DoDeCode:=Do_DeCode(Addr(self),ReadFunc,WriteFunc,m);
  FreeMem(m,DeCode_Mem_Req);
End;

Function Packing.DoEnCode:Integer;
Var
  m:Pointer;
Begin
  GetMem(m,EnCode_Mem_Req);
  DoEnCode:=Do_EnCode(addr(self),ReadFunc,WriteFunc,m);
  FreeMem(m,EnCode_Mem_Req);
End;

Function Packing.Read(Var Buffer:Byte; Var Size:Word):Integer;
Begin
  RunError(211);
End;

Function Packing.Write(Var Buffer:Byte; Size:Word):Integer;
Begin
  RunError(211);
End;

End.
