{$M 16384,395459,655360}
{----------------------------------------------------------------------------}
program tex_env_bump_mapping;                 {dffs2 version}
uses crt,dos,dffs2;                           {(c) 1996 Daniel Vollmer}
{----------------------------------------------------------------------------}
const
   MaxPoints            = 1023;
   MaxPolys             = 1985;
   MaxLinesPP           = 4;
   HowMuch              = MaxLinesPP+12;
   AddX       : Word    = 1;
   ColorAdd   : Byte    = 0;
{----------------------------------------------------------------------------}
type
   ConvertP = array[1..MaxPoints,1..HowMuch] of Word;
   Matrix   = array [1..3, 1..3] of LongInt;
   Screen   = array[1..65535] of Byte;
   ZB       = array[1..65535] of ShortInt;
   Punkt    = record
                    x,y,z     : LongInt;
              end;
   PolyData = array[1..MaxLinesPP] of Word;
   Poly     = record
                    NumEdg       : Byte;                         { 1}
                    Data         : PolyData;                     { 8}
                    OriginNormal : Punkt;                        {12}
                    Normal       : Punkt;                        {12}
              end;                                               {->33}
   PolyType = array[1..MaxPolys] of Poly;
   Point    = record
                    OrgPoints    : Punkt;           {12}
                    Temp         : Punkt;           {12}
                    PNormals     : Punkt;           {12}
                    PointNormals : Punkt;           {12}
                    EnvCos       : Record
                                       X, Y: Word   { 4}
                                   End;
                    Coords       : record
                                         x,y,z     : integer;
                                   end;             { 8}
                    Dummy        : LongInt;         { 4}
                    Dummy2       : Word;
              end;                                  {->64}
   PointType = array[1..MaxPoints] of Point;
   ObjectType  =  record
                        Polys                      : ^PolyType;
                        Points                     : ^PointType;
                        LPoints                    : Word;
                        LPolys                     : Word;
                        allocated                  : boolean;
                        XOffs                      : Word;
                        YOffs                      : Word;
                        XOffs3D                    : LongInt;
                        YOffs3D                    : LongInt;
                        ZOffs3D                    : LongInt;
                        Dist                       : LongInt;
                  end;
   PaletteType = array[0..127,0..255] of byte;
{----------------------------------------------------------------------------}
var
   T                          : ObjectType;
   sint,cost                  : array[-511..511] of LongInt;
   v_screen,EnvTex,TexMap     : ^Screen;
   PalConv                    : ^PaletteType;
   ZBuffer                    : ^ZB;
   VSeg,EnvSeg,ZSeg,
   PSeg,MapSeg                : Word;
   AngleX                     : Word;
   RotMatrix                  : Matrix;
   MinY, MaxY                 : integer;
   X_Data                     : Array [0..199] Of Record
                                      X1,X2:integer;
                                      dummy,dummy2:Word; {dummies wegen selben pointers wie EnvTable! }
                                end;
   Z_Data                     : Array [0..199] Of Record
                                      Z1,Z2:Integer;
                                      Dummy,dummy2:Word;
                                end;
   EnvironmentTable           : Array [0..199] Of Record
                                      X1, Y1, X2, Y2: Word;
                                End;
   TextureTable               : Array [0..199] Of Record
                                      X1, Y1, X2, Y2: Word;
                                End;
{----------------------------------------------------------------------------}
   Dub                        : boolean;
   twocol                     : boolean;
   Pics: LongInt;
   H,M,S,Hun:Word;
{----------------------------------------------------------------------------}
Function LSqrt (A: LongInt): LongInt; External;
Function LAdd (A, B: LongInt): LongInt; External;
Function LSub (A, B: LongInt): LongInt; External;
Function LDiv (A, B: LongInt): LongInt; External;
Function LMul (A, B: LongInt): LongInt; External;
Function LQuad (A: LongInt): LongInt; External;
Function LTrunc (A: LongInt): integer; External;
procedure RotierePunkte (var X1, X2: LongInt;Count,Size:Word); External;
procedure SetMatrix (A,B,C:Integer); External;
procedure TransPunkte (var Obj:ObjectType;Count:Word); external;
procedure CalcEnvCos( var PointN:LongInt;Count:Word); external;
{$L calc.obj}
{----------------------------------------------------------------------------}
procedure retrace; external;
procedure switch(source,dest:Word); external;
procedure cls(segm:Word;col:Byte); external;
procedure dopal(c,r,g,b:Byte); external;
procedure ShadedXLines; external;
procedure prepxdata; external;
procedure EnvLine (var StartP:Word;P1, P2: Word;num,numed:byte); external;
{$L graph.obj}
{----------------------------------------------------------------------------}
procedure initarrays(var Obj:ObjectType);
var c1,c2,c3,found:Word;
    den,te1,te2,te3:LongInt;
    PointInFace:^ConvertP;
begin
     with Obj do begin
          getmem(PointInFace,LPoints*HowMuch*sizeof(word));
          for c1:=1 to LPolys do begin
              with Polys^[c1] do begin
                   te1:=LSub (
                   LMul (LSub (Points^[data[1]].OrgPoints.y, Points^[data[2]].OrgPoints.y),
                         LSub (Points^[data[1]].OrgPoints.z, Points^[data[3]].OrgPoints.z)),
                   LMul (LSub (Points^[data[1]].OrgPoints.z, Points^[data[2]].OrgPoints.z),
                         LSub (Points^[data[1]].OrgPoints.y, Points^[data[3]].OrgPoints.y)));

                   te2:=LSub (
                   LMul (LSub (Points^[data[1]].OrgPoints.z, Points^[data[2]].OrgPoints.z),
                         LSub (Points^[data[1]].OrgPoints.x, Points^[data[3]].OrgPoints.x)),
                   LMul (LSub (Points^[data[1]].OrgPoints.x, Points^[data[2]].OrgPoints.x),
                         LSub (Points^[data[1]].OrgPoints.z, Points^[data[3]].OrgPoints.z)));

                   te3:=LSub (
                   LMul (LSub (Points^[data[1]].OrgPoints.x, Points^[data[2]].OrgPoints.x),
                         LSub (Points^[data[1]].OrgPoints.y, Points^[data[3]].OrgPoints.y)),
                   LMul (LSub (Points^[data[1]].OrgPoints.y, Points^[data[2]].OrgPoints.y),
                         LSub (Points^[data[1]].OrgPoints.x, Points^[data[3]].OrgPoints.x)));

                   den:=LSqrt(LAdd(LAdd(LQuad(te1),LQuad(te2)),LQuad(te3)));
                   if den<>0 then begin
                      OriginNormal.x:=ldiv(te1,den);
                      OriginNormal.y:=ldiv(te2,den);
                      OriginNormal.z:=ldiv(te3,den);
                   end else begin
                       OriginNormal.x:=0;
                       OriginNormal.y:=0;
                       OriginNormal.z:=0;
                   end;
              end;
          end;

          for c1:=1 to LPoints do begin
              found:=0;
              for c2:=1 to LPolys do begin
                  with Polys^[c2] do
                  for c3:=1 to NumEdg do if data[c3]=c1 then begin
                      inc(Found);
                      PointInFace^[c1,found]:=c2
                  end;
              end;
              PointInFace^[c1,HowMuch]:=found
          end;

          for c1:=1 to LPoints do begin
              with Points^[c1] do begin
                   te2:=PointInFace^[c1,HowMuch];te2:=te2*65535;
                   te1:=Polys^[PointInFace^[c1,1]].OriginNormal.x;
                   for c2:=2 to PointInFace^[c1,HowMuch] do te1:=LAdd(te1,Polys^[PointInFace^[c1,c2]].OriginNormal.x);
                   pNormals.x:= LDiv(te1,te2);
                   te1:=Polys^[PointInFace^[c1,1]].OriginNormal.y;
                   for c2:=2 to PointInFace^[c1,HowMuch] do te1:=LAdd(te1,Polys^[PointInFace^[c1,c2]].OriginNormal.y);
                   pNormals.y:= LDiv(te1,te2);
                   te1:=Polys^[PointInFace^[c1,1]].OriginNormal.z;
                   for c2:=2 to PointInFace^[c1,HowMuch] do te1:=LAdd(te1,Polys^[PointInFace^[c1,c2]].OriginNormal.z);
                   pNormals.z:= LDiv(te1,te2);
                   den:=LSqrt (LAdd(LAdd(LQuad(pNormals.x),LQuad(pNormals.y)),LQuad(pNormals.z)));
                   if den<>0 then begin
                      pNormals.x:=LDiv (pNormals.x,den);
                      pNormals.y:=LDiv (pNormals.y,den);
                      pNormals.z:=LDiv (pNormals.z,den);
                   end else begin
                       pNormals.x:=0;
                       pNormals.y:=0;
                       pNormals.z:=0;
                   end;
              end;
          end;
          freemem(PointInFace,LPoints*HowMuch*sizeof(word));
     end;
end;
{----------------------------------------------------------------------------}
procedure setOffsets(var Obj:ObjectType);
begin
     with Obj do begin
          allocated:=false;
          Dist := 128;
          XOffs := 160;
          YOffs := 100;
          XOffs3D := 0;
          YOffs3D := 0;
          ZOffs3D := 40 shl 16;
     end;
end;
{----------------------------------------------------------------------------}
procedure FreeObject(var Obj:ObjectType);
begin
     if Obj.allocated then begin
        freemem(Obj.polys, Obj.LPolys * sizeof(poly));
        freemem(Obj.points, Obj.LPoints * sizeof(point));
        Obj.allocated:=false;
     end;
end;
{----------------------------------------------------------------------------}
procedure readobj(var Obj:ObjectType;name:string);
var c,cc,ccc,chk:word;
    pp:^Screen;
begin
     with Obj do begin
          if Num(Name+'.666')=0 then begin
             asm
                mov  ax,3
                int  10h
             end;
             writeln('Object File not found!');
	          halt(1);
          end;

          pp:=ReadFile2Ram(name+'.666',d2_Index^[Num(name+'.666')].orgsize);
          LPoints:=MemW[seg(pp^):ofs(pp^)];
          LPolys:=MemW[seg(pp^):ofs(pp^)+2];
          Chk:=MemW[seg(pp^):ofs(pp^)+4];
          if chk<>Swap(LPoints xor LPolys) then begin;
             asm
                mov  ax,3
                int  10h
             end;
             writeln('Object Checksum Error!');
	          halt(1);
          end;
          if allocated then freeobject(obj);
          getmem(points,LPoints * sizeof(point));
          getmem(polys,LPolys * sizeof(poly));
          allocated:=true;
          ccc:=7;
          for c:=1 to LPoints do
              for cc:=0 to sizeof(Punkt)-1 do begin
                  mem[seg(Points^[c].OrgPoints):ofs(Points^[c].OrgPoints)+cc]:=pp^[ccc];
                  inc(ccc);
              end;

          for c:=1 to LPolys do
              for cc:=0 to ((MaxLinesPP*SizeOf(Word))+1)-1 do begin
                  mem[seg(Polys^[c].NumEdg):ofs(Polys^[c].NumEdg)+cc]:=pp^[ccc];
                  inc(ccc);
              end;
          freemem(pp,d2_Index^[Num(name+'.666')].orgsize);
     end;
     initarrays(Obj);
end;
{----------------------------------------------------------------------------}
procedure askem;
var b:Char;bi:ShortInt;c:Byte;
begin
     Textcolor(LightMagenta);
     write('Double Object (Y/N) ? ');
     Textcolor(Green);
     gotoxy(16,10);write('Y/N');
     gotoxy(23,10);
     Textcolor(LightBlue);
     b:=readkey; if upcase(b)='Y' then Dub:=true else Dub:=false;
     if Dub then writeln('Y') else writeln('N');
     Textcolor(LightMagenta);
     gotoxy(1,11);
     write('Two Colors (Y/N) ? ');
     Textcolor(Green);
     gotoxy(13,11);write('Y/N');
     gotoxy(20,11);
     Textcolor(LightBlue);
     b:=readkey; if upcase(b)='Y' then twocol:=true else twocol:=false;
     if twocol then writeln('Y') else writeln('N');
end;

procedure read4096(var p:Screen;Name:string);
var c,cc,ccc,cccc,b2:word;
    b:byte;pp:^Screen;
begin
     pp:=ReadFile2Ram(Name,4096);
     c:=1;
     cccc:=4095;
     cc:=0;
     b2:=1;
     while cc<256 do begin
     ccc:=0;
     while (c<cccc) and (ccc<=127) do begin
         b:=pp^[b2];dec(b,118);
         p[1+(cc shl 8+ccc)]:=b;
         p[1+(cc shl 8+ccc)+1]:=b;
         inc(c,2);
         inc(ccc,2);
         inc(b2);
     end;
     for cc:=cc to cc+4 do
         move(p[1+(cc shl 8)],p[1+((cc+1) shl 8)],128);
     end;
     freemem(pp,4096);
end;

procedure setup;
var c,cc:Word;angle:real;c2:integer;
    f:file;
begin
     askem;
     getmem(v_screen, sizeof(screen));
     VSeg := seg(v_screen^);
     cls(VSeg,0);
     getmem(ZBuffer, sizeof(ZB));
     ZSeg := seg(ZBuffer^);
     getmem(PalConv, 32768);
     if ofs(PalConv^)<>0 then PalConv:=ptr(seg(palConv^)+1,0);
     PSeg := seg(PalConv^);
     for c:=0 to 9 do begin
         for cc:=0 to 100 do if (Round((c*28)*(cc/355)))>0
         then PalConv^[c,cc]:=Round((c*28)*(cc/355)) shr 1
         else PalConv^[c,cc]:=0;
         for cc:=101 to 127 do if Round((c*28)*(cc/(355-((cc-101)/0.26)))+((cc-101)/1.6875)+((cc-101)/27*(9-c)*4))<127
         then PalConv^[c,cc]:=Round((c*28)*(cc/(355-((cc-101)/0.26)))+((cc-101)/1.6875)+((cc-101)/27*(9-c)*4)) shr 1
         else PalConv^[c,cc]:=63;
     end;
     for c2 := -511 to 511 do begin
         sint[c2] := round(65535*sin(c2 * pi / 256));
         cost[c2] := round(65535*cos(c2 * pi / 256));
     end;
     Init_Dat('dan');
     d2_Key:=122;
     readobj(t,'BOINGTOR');
     getmem(TexMap, 32768);
     if ofs(TexMap^)<>0 then TexMap:=ptr(seg(TexMap^)+1,0);
     MapSeg := seg(TExMap^);
     read4096(TexMap^,'TEXTURE.002');
     EnvTex:=readFile2ram('128X256.RAW',32768);
     EnvSeg:=seg (EnvTex^);
     CloseDffs;
     asm
        mov ax,13h
        int 10h
     end;
     for c:=0 to 100 do dopal(c,c div 9,c div 13,c div 2);
     for c:=0 to 26 do dopal(c+101,10+(c*2),8+(c*2),(c+101)div 2);
     for c:=0 to 100 do dopal(c+128,c div 2,c div 13,c div 2);
     for c:=0 to 26 do dopal(c+101+128,(c+101)div 2,8+(c*2),(c+101)div 2);
end;
{----------------------------------------------------------------------------}
procedure shutdown;
var H2, M2, S2, Hun2: Word;
    Seks: Real;
    f:file;
begin
     GetTime (H2, M2, S2, Hun2);
     Seks:=60*(M2-Integer(M))+S2-Integer(S)+((Hun2-Integer(Hun))/100);
     TextMode(CO80);
     Writeln;
     WriteLn( Pics, ' pics painted with ',t.LPoints,' Points and ',t.LPolys,' Polys...');
     if seks >0 then WriteLn ((Pics/Seks):4:1, ' Frames per second!');
     writeln('Free Mem: ',MemAvail,' Biggest Block: ',MaxAvail);
     writeln(#13+#10+'Lil'' Bump/Distortion try featuring DFFS Version ',d2_Version,'!');
     writeln('(C) 1996 by Daniel Vollmer...');
     freemem(v_screen, sizeof(screen));
     freemem(ZBuffer, sizeof(ZB));
     freemem(EnvTex, 32768);
     freemem(TexMap, 32768);
     freemem(PalConv, 32768);
     freeobject(t);
     while keypressed do readkey;
end;
{----------------------------------------------------------------------------}
procedure rotatedraw(var Obj:ObjectType);
var c,c2:Word;
    tt,tt2:longint;
begin
     with Obj do begin
          RotierePunkte(points^[1].OrgPoints.x,points^[1].Temp.x, LPoints,sizeof(Point));
          RotierePunkte(points^[1].PNormals.x,points^[1].PointNormals.x, LPoints,sizeof(Point));
          RotierePunkte(polys^[1].OriginNormal.x,polys^[1].Normal.x, LPolys,sizeof(Poly));
          for c:=1 to LPoints do begin
              tt:=(sint[((pics shl 6)+(c shl 7)) and 511]{ shl 1});
              points^[c].Temp.x:=LAdd(points^[c].Temp.x,tt);
              points^[c].Temp.y:=LAdd(points^[c].Temp.y,(cost[((pics shl 5)+(c shl 6)) and 511]{ shl 1}));
              points^[c].Temp.z:=LAdd(points^[c].Temp.z,tt shl 1);
              tt:=(sint[((pics shl 3)+(c shl 7)) and 511] div 4);
              tt2:=LAdd(points^[c].PointNormals.x,tt);
              if tt2>65535 then points^[c].PointNormals.x:=65535
              else if tt2<-65535 then points^[c].PointNormals.x:=-65535
              else points^[c].PointNormals.x:=tt2;
              tt2:=LSub(points^[c].PointNormals.y,tt);
              if tt2>65535 then points^[c].PointNormals.y:=65535
              else if tt2<-65535 then points^[c].PointNormals.y:=-65535
              else points^[c].PointNormals.y:=tt2;
          end;
          TransPunkte(Obj,LPoints);
          CalcEnvCos(points^[1].PointNormals.x, LPoints);
          for c := 1 to LPolys do with polys^[c] do begin
              if normal.z<13107 then begin
                 prepxdata;
                 for c2:=1 to NumEdg-1 do EnvLine (points^[1].EnvCos.X,
                                                   data[c2],data[c2+1],c2,NumEdg);
                 EnvLine (points^[1].EnvCos.x,data[NUmEdg],data[1],NumEdg,NumEdg);
                 if twocol then if odd(c) then ColorAdd:=128 else ColorAdd:=0 else ColorAdd:=0;
                 shadedxlines;
              end;
          end;
     end;
end;
{----------------------------------------------------------------------------}
begin
  setoffsets(t);
  Pics:=0;
  setup;
  coloradd:=0;
  GetTime (H, M, S, Hun);
  repeat
         cls(VSeg,0);
         cls(ZSeg, 127);
         ANgleX:= (ANgleX+AddX) and 511;
         SetMatrix ( AngleX, (AngleX+AngleX) and 511,-AngleX );
         rotatedraw(t);
         if Dub then begin
            SetMatrix ( -(AngleX+AngleX) and 511, AngleX, ((AngleX+AngleX) and 511));
            rotatedraw(t);
         end;
         switch(VSeg,$a000);
         Inc (Pics);
  until port[$60]=1;
  shutdown;
end.
