{ͻ
 Program      : SKY.PAS                                                     
 Author       : Sebastian Schuberth aka Saint (email: saint@freepage.de)    
 Description  : Moving clouds in the sky (max. 3 layers, don't know why)    
Ķ
 Created on   : <unknown>                                                   
 Last revised : 02.06.1998                                                  
}

{ Hi there,                                                                 }

{ I hope this source code is of some interesst to you. Maybe you even learn }
{ something of it or get some ideas. You may even use exactly this source   }
{ your productions, but please be fair and credit me and send some greets.  }

{ Yours, Saint. }

Program Sky;

{$M 4096,0,64000}       { Stack can be quite small, but we need heap space }
                        { for at least one screen buffer (320x200=64000).  }

{ $DEFINE SHOW_MOVEMENT}

Uses
  CRT,Segment;

Const
  Layers=2;             { Number of sky layers. }
  Screen=Ptr($A000,0);  { Pointer to video segment. }

Type
  PScreen=^TScreen;     { Screen definition for easy handling. }
  TScreen=Array[0..199,0..319] Of Byte;

  TSkyLayer=Record      { Variables for a layer: }
    Segment:Word;       { DOS segment of texture,      }
    PosX,PosY,          { current position in texture, }
    IncX,IncY:Word;     { increment, depends on layer  }
  End;                  { (lower clouds move faster).  }

Var
  x,y:Word;             { Used for loops. }
  Buffer:PScreen;       { Pointer to our screen buffer. }
  Layer:Array[0..Layers-1] Of TSkyLayer;  { Array of layers. }
  Angle,                                  { Defines the x-movement of sky, }
  Dist:Array[0..99,0..319] Of Byte;       { defines the y-movement of sky. }
                                          { Set SHOW_MOVEMENT to see what }
                                          { I mean (the arrays work as an }
                                          { index to the texture like in  }
                                          { the tunnel effect).           }

Procedure SetVideoMode(Mode:Byte); Assembler;
{ Switch to given video mode. }
Asm
  xor    ah,ah
  mov    al,[Mode]
  int    10h
End;

Procedure ScreenClear(Color:Byte); Assembler;
{ Clear the screen "Buffer" points to with the given color. }
Asm
  les    di,[Buffer]

  mov    dl,[Color]
  mov    dh,dl

  { shrd   eax,edx,16 }
  DB     66h,0Fh,0ACh,0D0h,10h

  mov    ax,dx
  mov    cx,320*200/4

  { rep    stosd }
  DB     0F3h,66h,0ABh
End;

Procedure ScreenCopy(Source,Dest:PScreen); Assembler;
{ Copy a screen to another. }
Asm
  push   ds

  lds    si,[Source]
  les    di,[Dest]

  mov    cx,320*200/4

  { rep    movsd }
  DB     0F3h,66h,0A5h

  pop    ds
End;

Procedure SetColor(Color,r,g,b:Byte); Assembler;
{ Set palette entry "Color" to the given values. }
Asm
  mov    dx,03C8h
  mov    al,[Color]
  out    dx,al

  inc    dx

  mov    al,[r]
  out    dx,al

  mov    al,[g]
  out    dx,al

  mov    al,[b]
  out    dx,al
End;

Procedure CalcSky(Factor:Word);
{ Calculate the texture index arrays. I happend to come across the formulas }
{ when I was playing around a little bit. }
Var
  x,y,Color:Word;
Begin
  For y:=0 To 99 Do
    FillChar(Dist[y,0],320,Round(Ln(100-y)*(Factor DIV 2)));

  For y:=0 To 99 Do Begin
    For x:=0 To 159 Do Begin
      Color:=(x*Factor) DIV (159-y);
      Angle[y,x+160]:=Color+Factor;
      Color:=((159-x)*Factor) DIV (159-y);
      Angle[y,x]:=Factor-Color-1;
    End;
  End;
End;

Procedure ShowSkyPixel(LastLayer:Word);
{ Checks which layer to take for the current pixel (skips layers where the }
{ pixel is defined transparent (>=152). Holla! This is recursive!}
Var
  xm,ym:Word;
Begin
  SegBuffer:=Layer[LastLayer].Segment;
  xm:=Angle[y,x]+Layer[LastLayer].PosX;
  ym:=Dist[y,x]+Layer[LastLayer].PosY;

  If (LastLayer>0) And (SegGetPixel(xm,ym)<152) Then
    ShowSkyPixel(LastLayer-1)
  Else Buffer^[y,x]:=SegGetPixel(xm,ym);
End;

Begin
  CalcSky(128);  { Play around with that value. It affects the sky's detail. }

  New(Buffer);        { Alloc screen buffer on heap. }
  ScreenClear(0);     { Clear the buffer, since it contains mud on start. }
  SetVideoMode($13);  { Switch to mode 13h (320x200x8). }

  {$IFDEF SHOW_MOVEMENT}  { Display the texture index arrays on screen. }
    Move(Angle,Mem[$A000:0],320*100);
    ReadKey;
    Move(Dist,Mem[$A000:0],320*100);
    ReadKey;
  {$ENDIF}

  For x:=1 To 127 Do  { Set up a nice sky-like palette. }
    SetColor(x,11+x DIV 6,11+x DIV 6,48+x DIV 8);
  For x:=128 To 255 Do
    SetColor(x,x DIV 4,x DIV 4,63);

  Randomize;          { Init random generator for plasma. }
  For x:=0 To Layers-1 Do Begin
    SegAlloc(Layer[x].Segment);  { Get new texture segment. }
    Layer[x].PosX:=0;    { Initial position is 0. }
    Layer[x].PosY:=0;
    Layer[x].IncX:=x+1;  { Speed of movement depends on layer. }
    Layer[x].IncY:=x+1;

    SegPlasma(1,255);    { Generate a plasma which may contain colors from }
  End;                   { 1 to 255. }

  Repeat
    For y:=0 To 99 Do
      For x:=0 To 319 Do
        ShowSkyPixel(Layers-1);  { Draw the sky pixels (in virtual screen). }

    ScreenCopy(Buffer,Screen);   { Copy virtual screen to screen segment. }

    For x:=0 To Layers-1 Do With Layer[x] Do Begin
      Inc(PosX,IncX);            { Move each layer. }
      Inc(PosY,IncY);
    End;
  Until KeyPressed;  { Quit when a key is pressed and  }
  ReadKey;           { remove that key from the queue. }

  For x:=0 To Layers-1 Do SegFree(Layer[x].Segment); { Free all layers and }
  Dispose(Buffer);                                   { the virtual screen. }

  SetVideoMode($03);  { Switch back to good old 80x25 text mode. }
End.