;================================ Exemple de programme 3D
;================================ Gouraud, Mapping, Phong

;================================ (C) 1995,96 SM Karibou

GOURAUD=0
TEXTURE=1
TEXTUREL=2
PHONG=3
AMBIANT=4
FMAP=5
BUMP=6

;

locals
.386p
.MODEL FLAT,PASCAL
.STACK 100h
.DATA
;
NBRPTS      Equ 410
NBRFACES    Equ 718

align 4
include face.dd

;

extrn Tex:near
extrn BumpMap:near

include ltable.db
include phongmap.db

include pal1.db
include pal2.db

;

Angle               dd   0
TZ                  dd   0
conf                db   0
motion              db   0
blur                db   1
DrawProc            dd   offset DrawTriG

VideoSize           dd   64000
VideoMode           dd   0
ScreenHeight        dd   200

mess db 0Ah,0Ah,'(C) 1996, SM Karibou/GMF (bruneto@efrei.fr)',0Dh,0Ah,'Thanks to Trap ][ for the vesa manager (besson@efrei.fr).','$'

TableTex            dd 16 dup(offset Tex)
TableBump           dd 16 dup(offset BumpMap)

;
.DATA?
align 4
VRot    dd   NBRPTS*3      dup (?)   ;= Point Rotats
VFaces  dd   NBRFACES      dup (?)   ;= Tablo des faces visibles
Prj     dw   NBRPTS*2      dup (?)   ;= Point Projet en 2D
NVRot   dd   NBRPTS*3      dup (?)   ;= Normales rotated (Phong only)
align 4
Buffer  db   480000        dup (?)
align 4
Shade   db   NBRPTS        dup (?)   ;= Tablo des eclairage (Gouraud)



;
.CODE

Setpal proc Near

       lea esi,palette
       cmp conf,GOURAUD
       je @@ok
       cmp conf,PHONG
       je @@ok
       cmp conf,BUMP
       je @@ok2

       lea esi,tex+256*256
@@ok:
       mov dx,3c8h
       xor al,al
       out dx,al
       inc dx
       mov ecx,768
       rep outsb
       ret
@@ok2:
      lea esi,palette2
      jmp @@ok
SetPal endp

;

include \asm\lib\vrserver\FrmCount.inc
include \asm\util.mac
include \asm\lib\vesa\vesa.ash

include 3dshell.ash
include backface.ash
include 3d.ash
include filler.ash

;

Start:
	WatcomStart
        Print 'SMK3D V0.2 (C) 1996, SMKaribou/Genital Male-Function'
        Print '(SVGA 640*480 - VBE 1.2 or + required)'
        Print '0, 1, 2, 3, 4, 5, 6, +, -, *, SPACE to play with the face.'
        xor ah,ah
        int 16h

        Call InitSort,NBRFACES
	jc @@zobj
	Call InitTransform,NBRPTS
	jc @@zobj

	;======== Translation
	mov ClipMinx,0
	mov clipmaxx,319
	mov clipminy,0
	mov clipmaxy,199
	mov scanline,320

        mov scanmultiplier,offset mul320
	Call videoinit,320,200,8

	Call SetPal

	in al,21h
	or al,10b
	out 21h,al

        Call InitFrameCount

@@BigLoop:
	;============================ Virage des faces caches
        ;VblWait
        ;Set1Color 0,63,0,0
    lea esi,Face2_Face
	lea edi,VFaces
    mov _PtsOfs,offset Face2_Vertex
    mov _NFOfs,offset Face2_NFace
	Call RemoveHiddenFaces,angle,angle,angle,0,0,TZ,NBRFACES
   ;     VblWait
   ;     Set1Color 0,0,63,0
	;============================= Transformation Selective des Pts
	cmp _FacesVisibles,0
	je @@Likit

    mov _VertxOfs,offset Face2_Vertex
	mov _VrotOfs,offset VROT
	mov _ProjOfs,offset Prj
	mov _VFaceOfs,offset VFaces

	cmp conf,PHONG
	jl @@Gouro
	cmp conf,FMAP
	je @@fm
    mov _VNOfs,offset Face2_NVertex7
	mov _VNRotOfs,offset NVRot
	Call TTransformPts2,angle,angle,angle,0,0,TZ,_FacesVisibles
	jmp @@fix
@@fm:
    mov _VNOfs,offset Face2_NVertex7
	mov _VNRotOfs,offset NVRot
	Call TTransformPts3,angle,angle,angle,0,0,TZ,_FacesVisibles
	jmp @@fix
@@Gouro:
    mov _VNOfs,offset Face2_NVertex12
	mov _ShadeOfs,offset Shade
	cmp conf,TEXTUREL
	je @@gouzi
    Call TTransformPts,angle,angle,angle,0,0,TZ,_FacesVisibles,dword ptr Face2_struc[12]
	jmp @@fix
@@gouzi:
	Call TTransformPts,angle,angle,angle,0,0,TZ,_FacesVisibles,8
@@fix:
	;============================ Tri des faces restantes
  ;      Set1Color 0,0,0,0
        dec _FacesVisibles
	lea esi,Vfaces
	lea edi,VRot
	Call RadixSort,_FacesVisibles
	;inc _FacesVisibles
        or ecx,ecx
        jz @@likit
        mov _FacesVisibles,ecx
        ;Set1Color 0,0,0,0

	;============================ Affichage des faces visibles
        Call WriteNbrFrame
        ;VblWait
        ;Set1Color 0,63,0,0

	mov ecx,_FacesVisibles
	lea ebx,VFaces

	mov TexOfs,offset TableTex
    mov TexPts,offset Face2_TriTex      ;==== Mapping & Mapping lighted & Bump

    mov eax,dword ptr Face2_struc[12]   ;==== Gouraud
	mov ColDec,eax

	mov ColMap,offset Shade             ;==== Gouraud et texture eclaire
	mov LTable,Offset Tex_LightTable    ;==== Texture eclaire

	cmp conf,PHONG
	jl @@loop

	mov TexOfs,offset PhongMap_PhongTable ;= Phong & Bump
	mov ColMap,offset NVRot               ;= Phong & Bump
	mov LTable,offset TableBump           ;= Bump

	cmp conf,PHONG
	je @@Loop
	cmp conf,BUMP
	je @@Loop
	mov TexOfs,Offset Tex          ;=== Static Phong
@@Loop:
	mov BufOfs,offset Buffer
	mov esi,[ebx]
	lea edi,Prj
	push ebx
	push ecx

	Call DrawProc

	pop ecx
	pop ebx
	add ebx,4
	dec ecx
	jnz @@Loop
        ;Set1Color 0,0,0,0
        Call VideoAff,offset Buffer

	cmp conf,AMBIANT
	je @@bouba
	cmp conf,TEXTURE
	je @@bouba
	cmp conf,TEXTUREL
	je @@bouba
	jmp @@kit

@@bouba:
	xor eax,eax
	lea edi,buffer
	mov esi,offset Tex
	mov edx,200
@@o:
	mov ecx,256/4
	rep movsd

        mov ecx,Scanline
        sub ecx,256
        shr ecx,2
	rep stosd
	dec edx
	jnz @@o

        mov eax,ScreenHeight
        sub eax,200
        cdq
        mul ScanLine
        shr eax,2
        mov ecx,eax
        xor eax,eax
	rep stosd
	jmp @@likit
@@kit:
	test motion,1
	jne @@lipu

	xor eax,eax
	lea edi,buffer
	mov ecx,VideoSize
        shr ecx,2
        rep stosd
	jmp @@likit
@@lipu:
	inc blur
	test blur,1
	jnz @@likit
	lea edi,buffer
	mov ecx,VideoSize
@@olip:
	shr byte ptr es:[edi],1
	inc edi
	dec ecx
	jnz @@olip

@@likit:
	add angle,4
	and angle,511

	in al,60h
	cmp al,74   ;'-'
	jne @@plus
	sub TZ,5
        jmp @@BigLoop
@@plus:
	cmp al,78  ;'+'
	jne @@0
	add TZ,5
        jmp @@BigLoop
@@0:
	cmp al,82
	jne @@1
	mov conf,GOURAUD
	mov DrawProc,offset DrawTriG
	Call SetPal
        jmp @@BigLoop
@@1:
	cmp al,79
	jne @@2
	mov conf,TEXTURE
	mov DrawProc,offset DrawTriM
	Call SetPal
        jmp @@BigLoop
@@2:
	cmp al,80
	jne @@3
	mov conf,TEXTUREL
	mov DrawProc,offset DrawTriML
	Call SetPal
        jmp @@BigLoop
@@3:
	cmp al,81
	jne @@4
	mov conf,PHONG
	mov DrawProc,offset DrawTriP
	Call SetPal
        jmp @@BigLoop
@@4:
	cmp al,75
	jne @@5
	mov conf,AMBIANT
	mov DrawProc,offset DrawTriP
	Call SetPal
        jmp @@BigLoop
@@5:
	cmp al,76
	jne @@6
	mov conf,FMAP
	mov DrawProc,offset DrawTriP
	Call SetPal
        jmp @@BigLoop
@@6:
	cmp al,77
	jne @@etoile
	mov conf,BUMP
	mov DrawProc,offset DrawTriB
	Call SetPal
        jmp @@BigLoop
@@etoile:
	cmp al,55
	jne @@space
	xor motion,1
        jmp @@BigLoop
@@space:
        cmp al,57
        jne @@esc
        xor videomode,1

        test videomode,1
        jnz @@SVGA640

        mov _PCenterX,160
	mov _PCenterY,100
	mov _XZoom,100h
	mov _YZoom,100h

        mov ClipMinx,0
	mov clipmaxx,319
	mov clipminy,0
	mov clipmaxy,199
	mov scanline,320

        mov scanmultiplier,offset mul320

	Call videoinit,320,200,8

        Mov VideoSize,64000
        mov ScreenHeight,200
        Call SetPal
        jmp @@BigLoop
@@SVGA640:

        mov _PCenterX,320
	mov _PCenterY,240
	mov _XZoom,200h
	mov _YZoom,200h+60h

        mov ClipMinx,0
	mov ClipMaxX,639
	mov clipminy,0
	mov clipmaxy,479
	mov scanline,640

        mov scanmultiplier,offset mul640

	Call videoinit,640,480,8

        Mov VideoSize,480000
        mov ScreenHeight,480

        Call SetPal
        jmp @@BigLoop
@@esc:
	dec al
	jnz @@BigLoop

        Call RemoveVRserver

	in al,21h
	and al,11111101b
	out 21h,al

	mov ax,3
	int 10h

       Call UnInitTransform
       Call UnInitSort
@@zobj:
	mov ah,9
	lea edx,mess
	int 21h
	.EXIT

end Start
