;=============================== Triangle Gouraud
;=============================== (C) 1995, SM Karibou

;=============================== Creation : 01/12/95
;=============================== Revision : 10/02/96

;= Entre:
;=        DS:ESI    Pointeur sur la liste des sommet du polygone (termine par la couleur) (dwords)
;=        DS:EDI    Pointeur sur la liste des points 2D (words)
;=        DS:ColMap Tableau des intensits de lumiere (1 bytes/pt)
;=        DS:ColDec Decalage couleur (gestion multicolore)
;=        DS:BufOfs Pointeur sur le buffer recevant le zoli dessin

; Constantes 

;CODEGEN=1                              ; Code genere ?
MAXSCANLINE=1024			; Taille maximum ke peut gerer la routine

;

.386p
locals
.MODEL FLAT
.CODE

GLOBAL DrawTriG:near
GLOBAL ColMap:DWORD
GLOBAL BufOfs:DWORD
GLOBAL ColDec:DWORD
GLOBAL ClipMinX:DWord
GLOBAL ClipMaxX:DWord
GLOBAL ClipMinY:DWord
GLOBAL ClipMaxY:DWord
GLOBAL ScanLine:DWord
GLOBAL ScanMultiplier:DWord

;

;============================ Nescessaire pour code genere
IFDEF CODEGEN
PutLabel Macro ld
         Line&ld:
endm

PutO Macro ld
     dd offset Line&ld
endm
align 4
JmpTable:
dd 0
I=MAXSCANLINE
rept MAXSCANLINE
     PutO %I
     I=I-1
endm
ENDIF
;
.DATA?
align 4
Y1          dd  ?       ;==== Sommet le plus haut de l'ecran
Y2          dd  ?
Y3          dd  ?

NY1         dd  ?       ;==== Numero des sommet dans la face
NY2         dd  ?
NY3         dd  ?

X2mX1A      dd  ?       ;==== Bah c'est marke dessus
X2mX1B      dd  ?

Hauteur1    dd  ?       ;==== Hauteur
Hauteur2    dd  ?

Delta1      dd  ?       ;==== Delta des eux cots
Delta2      dd  ?

CX1         dd  ?       ;==== Current X  1=Gauche 2=droit
CX2         dd  ?

CurrentY    dd  ?       ;==== Ligne Courante

_o          dd  ?       ;==== Tampon

WhatRoutine dd  ?       ;==== Routine de remplissage courante

;==================== Gouraud

C1          dd  ?       ;==== Couleur courante sur les cots
C2          dd  ?

EdgeStepCol1 dd  ?       ;==== Increment sur le cote
EdgeStepCol2 dd  ?

_IncCol     dd  ?       ;==== Increment interne

_CurCol     dd  ?       ;==== Tampon couleur de ligne

C2mC1A      dd  ?
C2mC1B      dd  ?

_Col        dd  ?       ; Gestion Multicolore

.CODE
;
DrawPartNC Proc Near;Macro
         push esi edi

@@DrawLoop:
         mov eax,CX1
         mov ecx,CX2
         sar eax,16
         sar ecx,16

         ;====================== Clipping Y
       	 mov edx,CLIPMAXY
	     mov ebx,CLIPMINY
	     cmp CurrentY,edx
         jg SlowExit
         cmp CurrentY,ebx
         jl @@Step

         sub ecx,eax
         jng @@Step

IFNDEF CODEGEN
         mov edi,bufOfs
         add edi,eax

         mov edx,_IncCol
         mov eax,C1

@@ZeLoop:
                  mov [edi],ah
                  add eax,edx
                  inc edi
                  dec ecx
                  jnz @@ZeLoop
ELSE
         mov edi,bufOfs
         add edi,eax

         mov edx,_IncCol
         mov eax,C1
         jmp dword ptr jmptable[ecx*4]

         I=1
         rept MAXSCANLINE
              PutLabel %I
                  mov [edi],ah
                  add eax,edx
                  inc edi
         I=I+1
         endm
ENDIF

@@Step:
         mov ecx,Delta1
         mov edx,Delta2
         add CX1,ecx
         add CX2,edx

         ;=================== Gouraud
         mov eax,EdgeStepCol1
         add C1,eax

         mov edx,Scanline
         inc CurrentY
         add BufOfs,edx
         dec Hauteur1
         jnz @@DrawLoop

         pop edi esi
         ret
DrawPartNC endp

DrawPartC Proc Near;Macro
         push esi edi

@@DrawLoop:
         mov eax,CX1
         mov ecx,CX2
         mov ebx,C1
         sar eax,16
         sar ecx,16
         mov _CurCol,ebx

         ;====================== Clipping Y
       	 mov edx,CLIPMAXY
	     mov ebx,CLIPMINY
	     cmp CurrentY,edx
         jg SlowExit
         cmp CurrentY,ebx
         jl @@Step

         ;== Full Clip X ?
         cmp eax,ClipMaxX
         jg @@Step
         cmp ecx,ClipMinX
         jl @@Step

         ;====== Clipping
         cmp ecx,ClipMaxX
         jle @@Noclipright
         mov ecx,ClipMaxX
@@NoclipRight:
         cmp eax,ClipMinX
         jge @@NoClipLeft
         mov ebx,ClipMinX         ;========== Clipping Gauche
         sub ebx,eax

         mov eax,_IncCol
         cdq
         imul ebx
         add _CurCol,eax

         mov eax,ClipMinx
@@NoClipLeft:

         sub ecx,eax
         jng @@Step

         mov edi,bufOfs
         add edi,eax

         mov edx,_IncCol
         mov eax,_CurCol

@@ZeLoop:
                  mov [edi],ah
                  add eax,edx
                  inc edi
                  dec ecx
                  jnz @@ZeLoop
@@Step:
         mov ecx,Delta1
         mov edx,Delta2
         add CX1,ecx
         add CX2,edx

         ;=================== Gouraud
         mov eax,EdgeStepCol1
         add C1,eax

         mov edx,Scanline
         inc CurrentY
         add BufOfs,edx
         dec Hauteur1
         jnz @@DrawLoop

         pop edi esi
         ret
DrawPartC endp

;

GetCoord Macro

         mov ebx,[esi+eax*4]
         mov _o,esi
         mov esi,ColMap
         movzx edx,byte ptr [esi+ebx]
         add edx,_Col
         mov esi,_o
         movsx eax,word ptr [edi+ebx*4+2]
endm

;
isClipped Macro
       local @@zob1,@@Zob2
       cmp eax,CLIPMAXX
           jng @@Zob1
           mov WhatRoutine,offset DrawPartC
           jmp @@Zob2
@@Zob1:
           cmp eax,CLIPMinX
           jnl @@Zob2
           mov WhatRoutine,offset DrawPartC
@@Zob2:
endm


;
CalcInc Macro
        local @@lm,@@noclac

         mov ebx,Delta1
         sub ebx,Delta2
         jnz @@noclac

         mov _IncCol,0
         jmp @@lm
@@noclac:

         mov eax,EdgeStepCol1
         sub eax,EdgeStepCol2
         cdq
         shl eax,16
         idiv ebx

         mov _IncCol,eax

@@lm:

endm

;

DrawTriG  Proc Near

         mov WhatRoutine,offset DrawPartNC
         ;======================= Tri des Y
         mov Ny1,0
         mov Ny2,1
         mov Ny3,2

         mov ebx,[esi]
         movsx edx,word ptr [edi+ebx*4]

         mov ebx,[esi+4]
         movsx ecx,word ptr [edi+ebx*4]

         mov ebx,[esi+8]
         movsx ebp,word ptr [edi+ebx*4]

         cmp edx,ecx
         jl @@Ok1
         xchg edx,ecx
         mov eax,NY1
         xchg NY2,eax
         mov NY1,eax
@@Ok1:
         cmp edx,ebp
         jl @@Ok2
         xchg edx,ebp
         mov eax,NY1
         xchg NY3,eax
         mov NY1,eax

@@Ok2:
         cmp ecx,ebp
         jl @@Ok3
         xchg ecx,ebp
         mov eax,NY2
         xchg NY3,eax
         mov NY2,eax
@@Ok3:
         mov y1,edx             ;===== Y1 pt le plus haut sur l'ecran
         mov y2,ecx
         mov y3,ebp

         cmp edx,ebp
         jge @@FastExit

         ;================= Turbo Clip Y
         cmp ebp,CLIPMINY
         jl @@FastExit
         cmp edx,CLIPMAXY
         jg @@FastExit

         ;================= O dans le buffer ?
         mov CurrentY,edx
         Call ScanMultiplier
         add BufOfs,edx

         ;===================== Chargement Couleur Face
         mov ebx,[esi+12]
         mov ecx,ColDec
         shl ebx,cl
         mov _Col,ebx

         ;================ Calcul des Hauteur
         mov eax,y2
         sub eax,y1
         jz @@TriPlat     ;=== Tri Plat
         mov Hauteur1,eax

         mov eax,y3
         sub eax,y1
         jz @@FastExit    ;=== Tri merdik
         mov hauteur2,eax

         ;=============== Recupere donne X2
         mov eax,ny2
         GetCoord
         mov X2mX1A,eax
         mov C2mC1A,edx

         IsClipped

         ;=============== Recupere donne X1
         mov eax,ny1
         GetCoord
         sub X2mX1A,eax
         sub C2mC1A,edx

         isClipped

         ;=============== Init
         shl eax,16
         mov CX1,eax
         mov CX2,eax
         shl edx,8
         mov C1,edx

         ;=============== DeltaX  1 -> 2
         mov eax,X2mX1A
         cdq
         shl eax,16
         idiv Hauteur1
         mov Delta1,eax

         ;================ Recupere donne X3
         mov eax,ny3
         GetCoord
         mov X2mX1B,eax
         mov C2mC1B,edx

         IsClipped

         ;================ Recupere donne X1
         mov eax,ny1
         GetCoord
         sub X2mX1B,eax
         sub C2mC1B,edx

         ;=============== DeltaX 1 -> 3
         mov eax,X2mX1B
         cdq
         shl eax,16
         idiv Hauteur2
         mov Delta2,eax

         ;=============== Calcul de l'increment de couleur du triangle
         mov eax,C2mC1A
         cdq
         shl eax,8
         idiv hauteur1
         mov EdgeStepCol1,eax

         mov eax,C2mC1B
         cdq
         shl eax,8
         idiv hauteur2
         mov EdgeStepCol2,eax

         ;=============== Determination du sens du triangle
         mov eax,Delta2
         cmp Delta1,eax
         jl @@lom
         xchg Delta1,eax
         mov Delta2,eax

         mov eax,EdgeStepCol1
         xchg eax,EdgeStepCol2
         mov EdgeStepCol1,eax
@@lom:

         ;============== Setting Hauteur
         mov eax,hauteur1       ;=== Hauteur1 est le cote le moins long
         cmp eax,hauteur2
         jl @@h
         xchg eax,hauteur2
         mov hauteur1,eax
@@h:
         ;============= Calcul de L'incrment Interne
         CalcInc

         ;====================== Premiere Partie du triangle
         Call WhatRoutine
@@Part2:
         ;===== Hauteur 2 -> 3
         mov eax,y3
         sub eax,y2
         jz @@FastExit     ;=== Tri Plat en bas
         mov Hauteur1,eax

         ;======== Recupere donne X3
         mov eax,ny3
         GetCoord
         mov X2mX1A,eax
         mov C2mC1A,edx

         ;======== Recupere donne X2
         mov eax,ny2
         GetCoord
         sub X2mX1A,eax
         sub C2mC1A,edx

         ;=============== DeltaX 2 -> 3
         mov eax,X2mX1A
         cdq
         shl eax,16
         idiv Hauteur1

         ;===== Ou met-je ce Delta ? + Calcul second Increment Gouraud eventuel
         cmp eax,Delta1
         jl @@lok
         mov Delta1,eax

         mov eax,C2mC1A
         cdq
         shl eax,8
         idiv Hauteur1
         mov EdgeStepCol1,eax

         mov eax,CX1
         add eax,8000h
         xor ax,ax
         mov CX1,eax

         jmp @@lop
@@lok:
         mov Delta2,eax

         mov eax,CX2
         add eax,8000h
         xor ax,ax
         mov CX2,eax

@@lop:
         ;====================== Deuxieme Partie du triangle
         Call WhatRoutine

@@FastExit:
         ret

SlowExit:
         pop edi esi
         pop eax
         ret

@@TriPlat:
         ;================ Calcul des Hauteur
         mov eax,y3
         sub eax,y1
         jz @@FastExit     ;=== Tri Bizarre
         mov Hauteur1,eax
         mov hauteur2,eax

         ;================ Recupere donne X3
         mov eax,ny3
         GetCoord
         mov X2mX1A,eax
         mov X2mX1B,eax
         mov C2mC1A,edx
         mov C2mC1B,edx

         IsClipped

         ;================ Recupere donne X1
         mov eax,ny1
         GetCoord
         sub X2mX1A,eax
         sub C2mC1A,edx

         IsClipped

         ;=============== Init
         shl eax,16
         mov CX1,eax
         shl edx,8
         mov C1,edx

         ;================ DeltaX 1 -> 3
         mov eax,X2mX1A
         cdq
         shl eax,16
         idiv Hauteur1
         mov Delta1,eax

         ;================ Recupere donne X2
         mov eax,ny2
         GetCoord
         sub X2mX1B,eax
         sub C2mC1B,edx

         IsClipped

         ;================ Init
         shl eax,16
         mov CX2,eax
         shl edx,8
         mov C2,edx

         ;================ DeltaX 2 -> 3
         mov eax,X2mX1B
         cdq
         shl eax,16
         idiv Hauteur1
         mov Delta2,eax

         ;=============== Calcul de l'increment de couleur du triangle
         mov eax,C2mC1A
         cdq
         shl eax,8
         mov ebx,hauteur1
         idiv ebx
         mov EdgeStepCol1,eax

         mov eax,C2mC1B
         cdq
         shl eax,8
         idiv ebx
         mov EdgeStepCol2,eax

         ;=============== Determination du sens du triangle
         mov ecx,C2mC1A

         mov eax,Delta2
         cmp Delta1,eax
         jnl @@lom2

         xchg Delta1,eax
         mov Delta2,eax

         mov eax,EdgeStepCol1
         xchg eax,EdgeStepCol2
         mov EdgeStepCol1,eax
@@lom2:
         mov eax,CX2
         cmp eax,CX1
         jg @@hjk
         mov eax,CX1
         xchg CX2,eax
         mov CX1,eax

         mov eax,C2
         mov C1,eax
@@hjk:
         ;============= Calcul de L'incrment Interne
         CalcInc

         ;====================== Dessin
         Call WhatRoutine
         ret
DrawTriG endp

;

end
