;=============================== Triangle Phong
;=============================== (C) 1995, SM Karibou

;=============================== Creation : 01/12/95
;=============================== Revision : 16/12/95

;= Entre:
;=        DS:ESI    Pointeur sur la liste des sommet du polygone (termine par la couleur)
;=        DS:EDI    Pointeur sur la liste des points 2D
;=        DS:ColMap Tableau des normales aux points
;=        DS:TexOfs offset de la texture phong
;=        DS:BufOfs Pointeur sur le buffer recevant le zoli dessin



; Constantes 

MAXSCANLINE=1024				; Taille maximum ke peut gerer la routine

;

.386p
locals
.MODEL FLAT
.CODE

GLOBAL DrawTriP:near
GLOBAL ColMap:DWORD
GLOBAL TexOfs:DWORD
GLOBAL BufOfs:DWORD
GLOBAL ClipMinX:DWord
GLOBAL ClipMaxX:DWord
GLOBAL ClipMinY:DWord
GLOBAL ClipMaxY:DWord
GLOBAL ScanLine:DWord
GLOBAL ScanMultiplier:DWord

;

;============================ Nescessaire pour code genere

PutLabel Macro ld
         Line&ld:
endm

PutO Macro ld
     dd offset Line&ld
endm
align 4
JmpTable:
dd 0
I=MAXSCANLINE
rept MAXSCANLINE
     PutO %I
     I=I-1
endm

;
.DATA?
align 4
Y1          dd  ?       ;==== Sommet le plus haut de l'ecran
Y2          dd  ?
Y3          dd  ?

NY1         dd  ?       ;==== Numero des sommet dans la face
NY2         dd  ?
NY3         dd  ?

X2mX1A      dd  ?       ;==== Bah c'est marke dessus
X2mX1B      dd  ?

Hauteur1    dd  ?       ;==== Hauteur
Hauteur2    dd  ?

Delta1      dd  ?       ;==== Delta des eux cots
Delta2      dd  ?

CX1         dd  ?       ;==== Current X  1=Gauche 2=droit
CX2         dd  ?

CurrentY    dd  ?       ;==== Ligne Courante

WhatRoutine dd  ?       ;==== Routine de remplissage courante

_o          dd  ?       ;==== Tampon

;==================== Mapping

Xt1          dd  ?       ;==== Coord de mapping courante sur les cots
Yt1          dd  ?
Xt2          dd  ?
Yt2          dd  ?

StepX1       dd  ?       ;==== Increment sur le cote
StepY1       dd  ?
StepX2       dd  ?
StepY2       dd  ?

_IncX        dd  ?       ;==== Increment interne
_IncY        dd  ?

_CurX        dd  ?       ;==== Tampon
_CurY        dd  ?

Xt2mXt1A     dd  ?
Yt2mYt1A     dd  ?
Xt2mXt1B     dd  ?
Yt2mYt1B     dd  ?

.CODE
;
DrawPartC Proc Near;Macro
         push esi edi

@@DrawLoop:
         mov eax,CX1
         mov ecx,CX2
         mov ebx,Xt1
         mov edx,Yt1
         sar eax,16
         sar ecx,16
         mov _CurX,ebx
         mov _CurY,edx

         ;====================== Clipping Y
       	 mov edx,CLIPMAXY
	     mov ebx,CLIPMINY
	     cmp CurrentY,edx
         jg SlowExit
         cmp CurrentY,ebx
         jl @@Step

         ;== Full Clip X ?
         cmp eax,ClipMaxX
         jg @@Step
         cmp ecx,ClipMinX
         jl @@Step

         ;====== Clipping
         cmp ecx,ClipMaxX
         jle @@Noclipright
         mov ecx,ClipMaxX
@@NoclipRight:
         cmp eax,ClipMinX
         jge @@NoClipLeft
         mov ebx,ClipMinX         ;========== Clipping Gauche
         sub ebx,eax

         mov eax,_IncX
         cdq
         imul ebx
         add _CurX,eax

         mov eax,_IncY
         cdq
         imul ebx
         add _CurY,eax

         mov eax,ClipMinx
@@NoClipLeft:

         sub ecx,eax
         jng @@Step

         mov edi,bufOfs
         add edi,eax

         mov ebx,_IncY
         mov dword ptr [@@Automodif2+2],ebx

         mov esi,TexOfs

         mov eax,_CurX
         mov edx,_CurY
         mov ebp,_IncX
         xor ebx,ebx
@@ZeLoop:
              mov bl,ah
              mov bh,dh

              add eax,ebp

              mov bh,byte ptr [esi+ebx]
@@Automodif2:
              add edx,12345687h

              mov [edi],bh

              inc edi
              dec ecx
              jnz @@Zeloop
@@Step:
         mov ecx,Delta1
         mov edx,Delta2
         add CX1,ecx
         add CX2,edx

         ;=================== Mapping
         mov eax,StepX1
         mov ebx,StepY1
         add Xt1,eax
         add Yt1,ebx

         mov edx,Scanline
         inc CurrentY
         add BufOfs,edx
         dec Hauteur1
         jnz @@DrawLoop

         pop edi esi
         ret
DrawPartC endp

DrawPartNC Proc Near;Macro
         push esi edi

@@DrawLoop:
         mov eax,CX1
         mov ecx,CX2
         sar eax,16
         sar ecx,16

         ;====================== Clipping Y
       	 mov edx,CLIPMAXY
	     mov ebx,CLIPMINY
	     cmp CurrentY,edx
         jg SlowExit
         cmp CurrentY,ebx
         jl @@Step

         sub ecx,eax
         jng @@Step

         mov edi,bufOfs
         add edi,eax

         mov ebx,ecx
         mov esi,TexOfs
         mov eax,Xt1
         mov edx,Yt1
         mov ebp,_IncX
         mov ecx,_IncY

         jmp dword ptr jmptable[ebx*4]

         I=1
         rept MAXSCANLINE
           PutLabel %I
              mov bl,ah
              mov bh,dh

              add eax,ebp

              mov bh,byte ptr [esi+ebx]

              add edx,ecx

              mov [edi],bh

              inc edi
              I=I+1
         endm

@@Step:
         mov ecx,Delta1
         mov edx,Delta2
         add CX1,ecx
         add CX2,edx

         ;=================== Mapping
         mov eax,StepX1
         mov ebx,StepY1
         add Xt1,eax
         add Yt1,ebx

         mov edx,Scanline
         inc CurrentY
         add BufOfs,edx
         dec Hauteur1
         jnz @@DrawLoop

         pop edi esi
         ret
DrawPartNC endp

;
isClipped Macro
       local @@zob1,@@Zob2
       cmp eax,CLIPMAXX
           jng @@Zob1
           mov WhatRoutine,offset DrawPartC
           jmp @@Zob2
@@Zob1:
           cmp eax,CLIPMinX
           jnl @@Zob2
           mov WhatRoutine,offset DrawPartC
@@Zob2:
endm

;

GetCoord Macro
         mov ebx,[esi+eax*4]
         movsx eax,word ptr [edi+ebx*4+2]

         mov _o,esi
         mov esi,ColMap
         mov edx,ebx
         shl edx,2
         shl ebx,3
         add ebx,edx
         mov edx,dword ptr [esi+ebx]
         mov ebp,dword ptr [esi+ebx+4]
         mov esi,_o
endm

;
CalcInc Macro
        local @@lm,@@noclac

         mov ebx,Delta1
         sub ebx,Delta2
         jnz @@noclac

         mov _IncX,0
         mov _IncY,0
         jmp @@lm
@@noclac:

         mov eax,StepX1
         sub eax,StepX2
         cdq
         shl eax,16
         idiv ebx

         mov _IncX,eax

         mov eax,StepY1
         sub eax,StepY2
         cdq
         shl eax,16
         idiv ebx

         mov _IncY,eax
@@lm:

endm

;

DrawTriP  Proc Near

         mov WhatRoutine,offset DrawPartNC

         ;======================= Tri des Y
         mov Ny1,0
         mov Ny2,1
         mov Ny3,2

         mov ebx,[esi]
         movsx edx,word ptr [edi+ebx*4]

         mov ebx,[esi+4]
         movsx ecx,word ptr [edi+ebx*4]

         mov ebx,[esi+8]
         movsx ebp,word ptr [edi+ebx*4]

         cmp edx,ecx
         jl @@Ok1
         xchg edx,ecx
         mov eax,NY1
         xchg NY2,eax
         mov NY1,eax
@@Ok1:
         cmp edx,ebp
         jl @@Ok2
         xchg edx,ebp
         mov eax,NY1
         xchg NY3,eax
         mov NY1,eax

@@Ok2:
         cmp ecx,ebp
         jl @@Ok3
         xchg ecx,ebp
         mov eax,NY2
         xchg NY3,eax
         mov NY2,eax
@@Ok3:
         mov y1,edx             ;===== Y1 pt le plus haut sur l'ecran
         mov y2,ecx
         mov y3,ebp

         cmp edx,ebp
         jge @@FastExit

         ;================= Turbo Clip Y
         cmp ebp,CLIPMINY
         jl @@FastExit
         cmp edx,CLIPMAXY
         jg @@FastExit

         ;================= O dans le buffer ?
         mov CurrentY,edx
         Call ScanMultiplier
         add BufOfs,edx

         ;================ Calcul des Hauteur
         mov eax,y2
         sub eax,y1
         jz @@TriPlat     ;=== Tri Plat
         mov Hauteur1,eax

         mov eax,y3
         sub eax,y1
         jz @@FastExit    ;=== Tri merdik
         mov hauteur2,eax

         ;=============== Recupere donne X2
         mov eax,ny2
         GetCoord
         mov X2mX1A,eax
         mov Xt2mXt1A,edx
         mov Yt2mYt1A,ebp

         IsClipped

         ;=============== Recupere donne X1
         mov eax,ny1
         GetCoord
         sub X2mX1A,eax
         sub Xt2mXt1A,edx
         sub Yt2mYt1A,ebp

         IsClipped

         ;=============== Init
         shl eax,16
         mov CX1,eax
         mov CX2,eax
         shl edx,8
         shl ebp,8
         mov Xt1,edx
         mov Yt1,ebp

         ;=============== DeltaX  1 -> 2
         mov eax,X2mX1A
         cdq
         shl eax,16
         idiv Hauteur1
         mov Delta1,eax

         ;================ Recupere donne X3
         mov eax,ny3
         GetCoord
         mov X2mX1B,eax
         mov Xt2mXt1B,edx
         mov Yt2mYt1B,ebp

         IsClipped

         ;================ Recupere donne X1
         mov eax,ny1
         GetCoord
         sub X2mX1B,eax
         sub Xt2mXt1B,edx
         sub Yt2mYt1B,ebp

         ;=============== DeltaX 1 -> 3
         mov eax,X2mX1B
         cdq
         shl eax,16
         idiv Hauteur2
         mov Delta2,eax

         ;=============== Calcul de l'increment de couleur du triangle
         mov eax,Xt2mXt1A
         cdq
         shl eax,8
         idiv hauteur1
         mov StepX1,eax

         mov eax,Yt2mYt1A
         cdq
         shl eax,8
         idiv hauteur1
         mov StepY1,eax

         mov eax,Xt2mXt1B
         cdq
         shl eax,8
         idiv hauteur2
         mov StepX2,eax

         mov eax,Yt2mYt1B
         cdq
         shl eax,8
         idiv hauteur2
         mov StepY2,eax

         ;=============== Determination du sens du triangle
         mov eax,Delta2
         cmp Delta1,eax
         jl @@lom
         xchg Delta1,eax
         mov Delta2,eax

         mov eax,StepX1
         xchg eax,StepX2
         mov StepX1,eax
         mov eax,StepY1
         xchg eax,StepY2
         mov StepY1,eax
@@lom:
         ;============== Setting Hauteur
         mov eax,hauteur1       ;=== Hauteur1 est le cote le moins long
         cmp eax,hauteur2
         jl @@h
         xchg eax,hauteur2
         mov hauteur1,eax
@@h:
         ;============= Calcul de L'incrment Interne
         CalcInc

         ;====================== Premiere Partie du triangle
         Call WhatRoutine
@@Part2:
         ;===== Hauteur 2 -> 3
         mov eax,y3
         sub eax,y2
         jz @@FastExit     ;=== Tri Plat en bas
         mov Hauteur1,eax

         ;======== Recupere donne X3
         mov eax,ny3
         GetCoord
         mov X2mX1A,eax
         mov Xt2mXt1A,edx
         mov Yt2mYt1A,ebp

         ;======== Recupere donne X2
         mov eax,ny2
         GetCoord
         sub X2mX1A,eax
         sub Xt2mXt1A,edx
         sub Yt2mYt1A,ebp

         ;=============== DeltaX 2 -> 3
         mov eax,X2mX1A
         cdq
         shl eax,16
         idiv Hauteur1

         ;===== Ou met-je ce Delta ? + Calcul second Increment Gouraud eventuel
         cmp eax,Delta1
         jl @@lok
         mov Delta1,eax

         mov eax,Xt2mXt1A
         cdq
         shl eax,8
         idiv Hauteur1
         mov StepX1,eax

         mov eax,Yt2mYt1A
         cdq
         shl eax,8
         idiv Hauteur1
         mov StepY1,eax

         mov eax,CX1
         add eax,8000h
         xor ax,ax
         mov CX1,eax

         jmp @@lop
@@lok:
         mov Delta2,eax

         mov eax,CX2
         add eax,8000h
         xor ax,ax
         mov CX2,eax

@@lop:
         ;====================== Deuxieme Partie du triangle
         Call WhatRoutine

@@FastExit:
         ret

SlowExit:
         pop edi esi
         pop eax
         ret

@@TriPlat:
         ;================ Calcul des Hauteur
         mov eax,y3
         sub eax,y1
         jz @@FastExit     ;=== Tri Bizarre
         mov Hauteur1,eax
         mov hauteur2,eax

         ;================ Recupere donne X3
         mov eax,ny3
         GetCoord
         mov X2mX1A,eax
         mov X2mX1B,eax
         mov Xt2mXt1A,edx
         mov Xt2mXt1B,edx
         mov Yt2mYt1A,ebp
         mov Yt2mYt1B,ebp

         IsClipped

         ;================ Recupere donne X1
         mov eax,ny1
         GetCoord
         sub X2mX1A,eax
         sub Xt2mXt1A,edx
         sub Yt2mYt1A,ebp

         IsClipped

         ;=============== Init
         shl eax,16
         mov CX1,eax
         shl edx,8
         shl ebp,8
         mov Xt1,edx
         mov Yt1,ebp

         ;================ DeltaX 1 -> 3
         mov eax,X2mX1A
         cdq
         shl eax,16
         idiv Hauteur1
         mov Delta1,eax

         ;================ Recupere donne X2
         mov eax,ny2
         GetCoord
         sub X2mX1B,eax
         sub Xt2mXt1B,edx
         sub Yt2mYt1B,ebp

         IsClipped

         ;================ Init
         shl eax,16
         mov CX2,eax
         shl edx,8
         shl ebp,8
         mov Xt2,edx
         mov Yt2,ebp

         ;================ DeltaX 2 -> 3
         mov eax,X2mX1B
         cdq
         shl eax,16
         idiv Hauteur1
         mov Delta2,eax

         ;=============== Calcul de l'increment de couleur du triangle
         mov eax,Xt2mXt1A
         cdq
         shl eax,8
         mov ebx,hauteur1
         idiv ebx
         mov StepX1,eax

         mov eax,Yt2mYt1A
         cdq
         shl eax,8
         idiv ebx
         mov StepY1,eax

         mov eax,Xt2mXt1B
         cdq
         shl eax,8
         idiv ebx
         mov StepX2,eax

         mov eax,Yt2mYt1B
         cdq
         shl eax,8
         idiv ebx
         mov StepY2,eax

         ;=============== Determination du sens du triangle
         mov eax,Delta2
         cmp Delta1,eax
         jnl @@lom2

         xchg Delta1,eax
         mov Delta2,eax

         mov eax,StepX1
         xchg eax,StepX2
         mov StepX1,eax
         mov eax,StepY1
         xchg eax,StepY2
         mov StepY1,eax

@@lom2:
         mov eax,CX2
         cmp eax,CX1
         jg @@hjk
         mov eax,CX1
         xchg CX2,eax
         mov CX1,eax

         mov eax,Xt2
         mov ebx,Yt2
         mov Xt1,eax
         mov Yt1,ebx
@@hjk:
         ;============= Calcul de L'incrment Interne
         CalcInc

         ;====================== Dessin
         Call WhatRoutine
         ret
DrawTriP endp

;

end
