
locals

;DOS32=1                   ; Compatibilit DOS32 ?

;NOPASS=1                   ; Dcommentez ceci pour ne plus avoir d'emmerde avec Smartdrv


FRAMETIME = 975                 ; Time between two interrupts is 97.5%
				; of total frame time - the interrupt comes
				; somewhat _before_ the Vertical Retrace
				; actually starts.

;

WaitNextVR MACRO                ; wait for NEXT Vertical Retrace
LOCAL   @@w1, @@w2
	mov     dx,03DAh
@@w1:
	in      al,dx           ; wait for a non-retrace period
	test    al,8
	jnz     @@w1

@@w2:
	in      al,dx
	test    al,8            ; wait for retrace
	jz      @@w2
ENDM

;

.DATA?
OldTmr      DF  ?               ; pointer to old timer interrupt

TmrVal      DW  ?               ; count to the timer chip
DOSTmrCnt   DW  ?               ; counter used in calling the old timer

PreVRFunct  DD  ?               ; pointer to the routine to be called
			         ;  BEFORE the Vertical Retrace
VRFunct     DD  ?               ; routine to be called IN the VR

IsVbl       dd  ?               ; Est ce k'il y a une Vbl En ce moment ?

;
.CODE
Timer PROC near

    pusha
    push    ds
    push    es
    push    fs
    push    gs

    cli

    mov ax,_DATA       ; Recharge Descripteur DATA
    mov ds,ax

	mov     dx,03DAh
@@wnvr:
	in      al,dx           ; wait until we are _not_ in a
        test    al,8             ; retrace (just to make sure...)
        jnz  @@wnvr

        call    PreVRFunct       ; call the Pre-VR function


        mov dx,3dah
@@VblShort:
        in al,dx
        test al,8
        jz @@VblShort

        inc IsVbl

       mov  bx,[TmrVal]        ; count for timer chip
       mov  al,30h             ; counter mode 0 - interrupt on
       out  43h,al             ; terminal count
       mov  al,bl
       out  40h,al             ; set timer count and restart timer
       mov  al,bh
       out  40h,al

       call    VRFunct          ; call the VR function

IFNDEF NOPASS
       mov  ax,TmrVal
       add  DOSTmrCnt,ax        ; add timer count to DOS timer count
       jnc  @@noDOSTmr          ; if carry set (count 65536), call
		                ; DOS timer
       pushfd
       call OldTmr              ; call old timer
@@noDOSTmr:
ENDIF

    mov al,20h                  ; send End Of Interrupt signal
    out 20h,al                  ; to PIC

        sti
        pop     gs
        pop     fs
	pop     es
	pop     ds
	popa
        nop                       ;==== Pour eviter le bug des 386
	iret
Timer endp

;


InitVRServer PROC near
	     ARG PPreVRFunct : DWORD, PVRFunct : DWORD


    ;********** Hook Timer inerrupt ( IRQ 0 ) just for fun ****************
IFDEF DOS32
	mov     bl,8                      ;Save IRQ 0 interrupt vector
	mov     ax,204h
	int     31h
ELSE
        push es
        mov ax,3508h
        int 21h
	mov     dword ptr OldTMR , ebx
	mov     word ptr OldTMR+4, es
        pop es
ENDIF
	mov eax,PPreVRFunct               ; set pointer to Pre-VR function
	mov PreVRFunct,eax

	mov eax,PVRFunct                  ; set pointer to VR function
	mov VRFunct,eax
IFDEF DOS32
	mov     bl,8                      ; Set the new IRQ 0 vector
	mov     edx,offset timer          ; See below
	mov     cx,cs                     ; CS:EDX = selector:offset
	mov     ax,205h
	int     31h
ELSE
        push ds
        push cs
        pop ds
        mov ax,2508h
        mov edx,offset Timer
        int 21h
        pop ds
ENDIF

	call    SyncVRServer              ; synchronize timer to display refresh

	ret
InitVRServer endp

;

SyncVRServer Proc near
     cli                                  ; disable interrupts for maximum
					  ; accuracy
@@read:
	WaitNextVr                        ; wait for next Vertical Retrace

	mov     al,36h
	out     43h,al
	xor     al,al                     ; reset the timer
	out     40h,al
	out     40h,al

	WaitNextVR                        ; wait for next Vertical Retrace

	xor     al,al
	out     43h,al
	in      al,40h
	mov     ah,al
	in      al,40h                    ; read timer count - time between
	xchg    al,ah                     ; two Vertical Retraces
	neg     ax
	mov     [TmrVal],ax

	WaitNextVR                        ; wait for next Vertical Retrace

	mov     al,36h
	out     43h,al
	xor     al,al                     ; reset timer again
	out     40h,al
	out     40h,al

	WaitNextVR                        ; wait...

	xor     al,al
	out     43h,al
	in      al,40h
	mov     ah,al                     ; and read the timer count again
	in      al,40h
	xchg    al,ah
	neg     ax

	mov     dx,ax

	sub     dx,[TmrVal]
	cmp     dx,2                     ; If the difference between the two
	jg      @@read                   ; values read was >2, read again.
	cmp     dx,-2
	jl      @@read

	mov     bx,FRAMETIME                  ; Time between two interrupts is
	mul     bx                            ; FRAMETIME/10 % of the total time
	mov     bx,1000                       ; between two Vertical Retraces.
	div     bx

	shr         ax,1
	mov     [TmrVal],ax                   ; timer chip count

	mov     bx,[TmrVal]

	WaitNextVR                            ; wait for Vertical Retrace

	mov     al,30h                        ; counter mode 0 - interrupt on
	out     43h,al                        ; terminal count
	mov     al,bl                         ; Restart timer with the new speed
	out     40h,al                        ; right after the beginning of the
	mov     al,bh                         ; Retrace.
	out     40h,al

	mov     [DOSTmrCnt],0                 ; count used in calling the old timer

	mov     al,20h                        ; send EOI signal to the PIC
	out     20h,al

	sti                                   ; enable ints

	ret
ENDP

;

RemoveVRServer PROC

	mov     al,36h                  ; DOS default timer mode
	out     43h,al
	xor     al,al                   ; set timer count to 65536 - 18.2Hz
	mov     al,0FFh                 ; (DOS default)
	out     40h,al
	out     40h,al

IFDEF DOS32
	mov     bl,8                    ; Set the new IRQ 0 vector
	mov     edx,dword ptr OldTMR    ; See below
	mov     cx,word ptr OldTMR+4    ; CS:EDX = selector:offset
	mov     ax,205h
	int     31h
ELSE
        push ds
        mov ax,2508h
        lds edx,oldtmr
        int 21h
        pop ds

ENDIF

	mov     al,36h                  ; DOS default timer mode
	out     43h,al
	xor     al,al                   ; set timer count to 65536 - 18.2Hz
	mov     al,0FFh                 ; (DOS default)
	out     40h,al
	out     40h,al

	ret
ENDP

;

;============= Change les fonctions appeles
ResetVRFct Proc Near
              arg PF,VF:DWord
              cli

              mov eax,PF               ; set pointer to Pre-VR function
              mov PreVRFunct,eax

              mov eax,VF                ; set pointer to VR function
              mov VRFunct,eax
              sti
              ret
ResetVRFct endp

;

;==== Reinitialise le serveur
ResetVRServer Proc Near

              Call SyncVRServer
              ret
ResetVRServer endp

;

