// STARGATE.CPP
// Rex Deathstar/WaterLogic
// Copyright (C) 1995
// Released on 21st February 1996
//
//
// Question : How to make a texture-mapped wormhole that moves??
// Answer :
// 1) draw a cone or a tube (with perspective)
// 2) calculate which texture coordinates (U/V) apply to each pixel of
//    the cone/tube that was drawn on the screen
// 3) save these texture coordinates into a table
// 4) to draw a frame, plot the texel pointed to by the table onto the screen
// 5) to make it move, apply displacement in your texture coordinates
//
// This is cheap and easy wormhole. But it's perspective-corrected, though
// it can't be modified realtime, coz it uses a table.
//
// Question : How did I do it?
// Answer :
// I saw many such effect in Assembly 94's 4Kb intros. I really wondered how
// they did it. I noticed that the wormhole didn't change, so it must be a
// sort of pre-calculated table. So I searched thru my maths textbooks on
// how to draw a 'wormhole'. But it only taught me sphere and cylinders.
// So I thought a cylinder seen in 3D sure looks like a wormhole!
// But a straight cylinder looks so lame as so many people has done it, thus
// I bent the cylinder.
// So how did I make it textured? By unifying the cylinder volume coordinates
// (x,y,z) into range of 0.0 ... 1.0, you can apply planar texture mapping
// just by using these values multiplied by the texture coordinate range
// (0...255 usually).
//
// Question : Why did I release this source code?
// Answer :
// Seeing some people talking about making wormholes by drawing circles and
// inverse mapping the radii is interesting. I thought they didn't realise
// this method is slow and introduces 'holes' in the wormhole as the drawing
// can never be continuous. Plus, using SQRT in a realtime loop is a -very-
// bad idea :)
//
// Also, I've done wormholes that can change shape at realtime, so I dun have
// to worry people using this code against me! HAHAHHA! :)
//
// Question : So what do I want in return?
// Answer :
// Nothing much, I just hope everyone can improve. I look forward to
// The Scene 96. And I wish by then the -average- standard of the local demos
// would have surpassed Pureness by quite a bit. I'm not saying that Pureness
// is the 'de-facto' standard or whatever, but improving beyond it is the idea
// of this scene thing right? Furthermore, there has been ONE full year since
// TS95, there is no reason for the scene not expanding, attracting more
// interest and attention, and spawning new groups, making more demos.
// To ANYONE reading this, I invite you to Developer's Site BBS. We are
// trying to make this BBS the official gathering place for all local demo
// people, and you can help by joining us there, now. Call : 561-0237
//
// Question : So what do I -NOT- want in return?
// Answer :
// I dun wish to see people using this code, modify it, and call it their own.
// Telling me that your code was -based- on this (or anybody else's) and
// was re-written completely (like photostating using pen and pencil)
// is pure CRAP. I ain't stupid, and so are the others. There's already been
// cases of such act, and there's potential for more. But I hope this can
// change. Anyway, why use a ONE year OLD code, and lag behind others by
// one full YEAR!? Certainly you have more brains than that right?
// Ah, this doesn't apply to this piece of code, but for EVERY generous coder
// that willingly gave away their codes, for the benefits of others who wish
// to learn. Dun spoil this healthy cycle, please.
//
// Greets : (this time to local guys only :)

// Valki : orange and apple? Which do you like?

// Zane : attitude can sometimes be so cool to have... :)

// ChaoS : dun study too hard!

// FxKidd : bet you've learnt alot the past year huh? people get more complex
// as they get older. :)

// KoL : you're a nice guy, but sometimes you should let others voice their
// opinions, and consider them.

// PeiSin : Mistier Hearts? :) Want the MTV?

// PowerSurge : great intro, best local intro I've seen!

// Constellation : you guys are young and has great potential, keep it up!

// Morbid : multi-talents! btw, that 18-bit thing is abit slow, 3ins/pixel

// FluidMotion : that's the name of Valhalla's intro, u like it so much??

// Nicholas : animation craze! :) so when's our deal due??

// BlackMagic : nice to have a new comer, and see u at TS96! Man, you sound
// like your demo is gonna rock!! :)

// Victor : u no scener? nevermind! code a Winbloz demo! :)

// Tangent : NS sux huh? expecting some cool asm stuff from u! btw, that
// x^n idea was neat :)

// Renegade : maybe you're not local, but nevermind. just to let you know
// that attending TS96 would be a nice thing to do. But since you declared
// in Fidonet that you're not entering TS96, why leave a backdoor giving
// yourself room to 'change your mind'? Not a man of your words? I'm not going
// to be happy that you guys pull out, coz it's the loss of the scene. I
// enjoy competition, only if it's fair, square and friendship first. But
// since you have to take it so hard (people know the facts, but they just
// didn't say it out), I thought maybe it's not nice to make people face
// reality in such a harsh way, sorry... I wish I could change your mind
// about entering TS96, but that's like asking you to hit youself in the face,
// since you made it so clear to everyone! :(
// And, the organising committee sure closed one of their eyes when nobody
// represented you (since you were absent) at the party, and I thought that
// was one of the rules? Or did Roy change the rules for you?? Hmm...

// Pandemonium : the past is past, but the future is made from the past.
// an effort must be made to make others believe the change is truthful.
// Trust takes 10 years to build, but can be broken in a second. You have
// great skills, and I regret unable to work with you.
//
// Did I forget anyone?? Write me a flame mail if I did! :)

// Last notes : I know the code is messy, it has no comments, but please
// understand. :)

// Use '+','-','/','*' on your keypad to make the wormhole move

#pragma inline
asm .486P

#include <dos.h>
#include <process.h>
#include <conio.h>
#include <math.h>
#include <stdio.h>
#include "realinit.c"

#define	rad		0.01745329
#define	CONE_SIZE_Y	150.0
#define	CONE_SIZE_X	215.0
#define	CONE_SIZE_Z	1000.0



unsigned int texture_buffer,texture_lut;
unsigned int far *lut;
	char far *VRAM=(char far*)MK_FP(0xa000,0x0000);

	char 	palette[256][3];
unsigned int 	idx1,idx2,velocity;
unsigned long	idx;
	char	texture,dud;
	int	a,n,sx,sy,tx,ty,dummy;
	float	theta,x,y,u,v,phi,tempx,tempy,tempz;

asm texture_file db 'height.dat',0
asm stargate_file db 'STARGATE.DAT',0

void graphics();
void text();
void load_stargate();
void save_stargate();
void load_texture();
void build_lut();
void do_wormhole();


void main()
{
	if( allocmem(4096,&texture_buffer) != -1 ) exit(1);
	if( allocmem(8000,&texture_lut) != -1 ) exit(1);

	if(_virtual86()) { puts("Machine in V86 mode!"); exit(1); }
	INITCPU32();

	load_texture();
	graphics();
	load_stargate();

	idx1=0;

MAIN_LOOP:;
	while(!kbhit())
	do_wormhole();

	dummy=getch();
	if(dummy=='/')
	{ asm add byte ptr velocity,1
	  goto MAIN_LOOP; }

	if(dummy=='*')
	{ asm sub byte ptr velocity,1
	  goto MAIN_LOOP; }

	if(dummy=='+')
	{ asm add byte ptr [velocity+1],1
	  goto MAIN_LOOP; }

	if(dummy=='-')
	{ asm sub byte ptr [velocity+1],1
	  goto MAIN_LOOP; }



	text();
}
//-----------
void graphics()
{
asm mov ax,13h
asm int 10h

for(a=0; a<256; a++)
{
palette[a][0]=63*a/256 *.4;	//0.4
palette[a][1]=63*a/256 *.3;	//0.3
palette[a][2]=63*a/256 *1.0;
}

asm	mov dx,0x3c8
asm	xor ax,ax
asm	out dx,al
asm	inc dx
asm 	lea si,palette
asm	mov cx,768
asm	cld
asm	rep outsb
}
//------------
void text()
{
asm mov ax,3
asm int 10h
}
//------------
void	load_texture()
{
	asm	mov	ax,0x3d00
	asm	lea	dx,texture_file
	asm	int	0x21
	asm	mov	bp,ax
	asm	push	ds
	asm	mov	ds,texture_buffer
	asm	mov	bx,bp
	asm	mov	cx,0x8000
	asm	mov	ah,0x3f
	asm	xor	dx,dx
	asm	int	0x21
	asm	mov	bx,bp
	asm	mov	cx,0x8000
	asm	mov	ah,0x3f
	asm	mov	dx,0x8000
	asm	int	0x21
	asm	pop	ds
	asm	mov	bx,bp
	asm	mov	ah,0x3e
	asm	int	0x21
}
//------------
void	load_stargate()
{
	asm	mov	ax,0x3d02
	asm	lea	dx,[stargate_file]
	asm	int	0x21
	asm	jc	rebuild
	asm	mov	bp,ax

	asm	push	ds
	asm	mov	ds,[texture_lut]
	asm	mov	cx,4
	load_loop:
	asm	push	cx
	asm	mov	bx,bp
	asm	mov	cx,32000
	asm	mov	ah,0x3f
	asm	xor	dx,dx
	asm	int	0x21
	asm	mov	ax,ds
	asm	add	ax,2000
	asm	mov	ds,ax
	asm	pop	cx
	asm	loop	load_loop
	asm	pop	ds
	asm	mov	bx,bp
	asm	mov	ah,0x3e
	asm	int	0x21
	asm	jmp	done

	rebuild:;
	build_lut();

	done:;
}
//----------------
void	save_stargate()
{
	asm	mov	ax,0x3c00
	asm	lea	dx,[stargate_file]
	asm	int	0x21
	asm	mov	bp,ax

	asm	push	ds
	asm	mov	ds,[texture_lut]
	asm	mov	cx,4
	save_loop:
	asm	bswap	ecx
	asm	mov	bx,bp
	asm	mov	cx,32000
	asm	mov	ah,0x40
	asm	xor	dx,dx
	asm	int	0x21
	asm	mov	ax,ds
	asm	add	ax,2000
	asm	mov	ds,ax
	asm	bswap	ecx
	asm	loop	save_loop
	asm	pop	ds

	asm	mov	bx,bp
	asm	mov	ah,0x3e
	asm	int	0x21
}

//------------
void	build_lut()
{
	float	step_y,step_x,noise;


	for(y=100.0; y>0; y-=step_y)
	for(x=100.0; x>0; x-=step_x)
	{
	step_x=0.065+(0.4*y/100);
	step_y=0.065+(0.4*y/100);

	tx = x/100.0*256.0*1;		// tx= (0..1) * size of texture
	ty = y/100.0*256.0*1;		// ty= (0..1) * size of texture

	u=x/100.0;
	v=y/100.0;

	theta=u*360.0*rad;
	phi  =v;


	idx1=ty*256+tx;
	asm mov es,texture_buffer
	asm mov di,idx1
	asm mov al,es:[di]
	asm mov texture,al

	//texture*=(1.0-v);	// decreasing intensity

	//noise=1-(sin(3.6*y*rad)/6);

tempx=CONE_SIZE_X*cos(theta);
tempy=CONE_SIZE_Y*sin(theta);
tempz=CONE_SIZE_Z*phi;

sx=tempx * 150/(tempz + 150) + 160;
//sx=(tempx*cos(phi*30*rad)+tempz*sin(phi*30*rad)) * 150/(tempz+150)+160;
sy=(tempy*cos(phi*45*rad)+tempz*sin(phi*45*rad)) * 150/(tempz+150)+100;




		if(sy<200 && sy>=0 && sx<320 && sx>=0)
		{
		*(VRAM + (sy*320+sx) )=texture;

		asm mov fs,[texture_lut]
		asm xor edi,edi
		asm mov di,[sy]
		asm mov dx,di
		asm shl dx,8
		asm shl di,6
		asm add di,dx
		asm add di,[sx]
		asm shl edi,1
		asm mov ax,[idx1]
		asm mov fs:[edi],ax

		}



	}


	save_stargate();

}
//-------------
void	do_wormhole()
{
	asm mov dx,0x3da
	vr1:
	asm in al,dx
	asm test al,8
	asm jz vr1

	asm movzx esi,word ptr [texture_lut]
	asm shl esi,4
	asm mov edi,0xa0000
	asm mov fs,[texture_buffer]
	asm mov dx,[idx1]

	asm mov cx,64000/16
	asm push ds
	asm xor ax,ax
	asm mov ds,ax
	lut_seg1:
	asm i=0
	asm j=0
	asm rept 4
	asm mov bx,[esi+6+i]
	asm add bx,dx
	asm mov bp,[esi+4+i]
	asm add bp,dx
	asm mov al,fs:[bx]
	asm mov ah,fs:[bp]

	asm mov bx,dx
	asm add bx,[esi+i]
	asm mov bp,dx
	asm add bp,[esi+2+i]
	asm bswap eax
	asm mov al,fs:[bx]
	asm mov ah,fs:[bp]

	asm mov [edi+j],eax

	asm i=i+8
	asm j=j+4
	asm endm

	asm add edi,4*4
	asm add esi,8*4

	asm dec cx
	asm jz done_one_frame
	asm jmp far ptr lut_seg1

	done_one_frame:
	asm pop ds
	asm mov ax,[velocity]
	asm add [idx1],ax

}

