// Play_rec.cpp

// Plays or records sound files with the Sound Blaster.
// This is a test program to demonstrate using the sound class.

// Written by Christopher M. Box (1993)
// Memory allocation code was drawn from the SBF DACDMA program

#define DMA_BUF_SIZE 32000U
#define ALLOCATE ((2*DMA_BUF_SIZE) + 65536L)

#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <alloc.h>
#include <dos.h>
#include <io.h>

#include "sndclass.h"

#define Dirstring (dir==PLAY ? "Play" : "Record")

void inc_arg(int &argc, char **&argv) {
	++argv;
	if (--argc < 1) {
		cprintf("play_rec [-r] [-s sample rate] sample_file\r\n");
		cprintf("-r: Record instead of play\r\n");
		exit(1);
	}
}

int main(int argc, char **argv) {
	unsigned sr=10000;         // Default sample rate
	int dir = PLAY;

	inc_arg(argc, argv);

	if (! strcmp(*argv, "-r")) {
		dir = RECORD;
		inc_arg(argc, argv);
	}
	if (! strcmp(*argv, "-s")) {
		inc_arg(argc, argv);
		sr = atoi(*argv);        // Works for unsigned ints too
		inc_arg(argc, argv);
	}

	SoundDevice *sdev;
	sdev = new SbDevice;	     // This could also be created statically
	if (! sdev -> install_ok()) exit(1);

// Open/create the file.
	int handle;
	if (dir == RECORD) {
		handle = _creat(*argv, 0);
	} else {
		handle = _open(*argv, 1);
	}
	if (handle < 0) {
		cprintf("Could not open sample file '%s'\r\n",*argv);
		exit(1);
	}

// Obtain an aligned 64K memory buffer for the DMA functions
	byte far *raw = (byte far *) farmalloc(ALLOCATE);
	if (! raw) {
		cprintf("Not enough memory available - an extra %uK needed.\r\n",
			((unsigned int)(ALLOCATE-farcoreleft()))/1024+1);
		exit(1);
	}
	long physical = ((long)FP_OFF(raw)) + (((long)FP_SEG(raw)) << 4);
	long aligned_physical = (physical+0x0FFFFL) & 0xF0000L;
	byte far *buf = (byte far *)
		MK_FP((unsigned )((aligned_physical >> 4) & 0xFFFF),0);

// Now simply call the Sound Device functions to record/play the file.
	sdev -> set_rate(sr,dir);
	cprintf("%sing sample at %uHz\r\n",Dirstring, sdev -> get_rate());
	cprintf("Press 'p' to pause.\r\n");
	sdev -> file_dma(handle,buf,DMA_BUF_SIZE,0,dir);
	_close(handle);
	farfree(raw);
	cprintf("Done.\r\n");
	return 0;
}