
#ifndef  __MODULE_H__
#define  __MODULE_H__

//Ŀ
//                                                                           
// SOCOM 1.0                                                                 
//                                                                           
// Module - Header file                                                      
//                                                                           
// (c) 1995 P.Lindh                                                          
//                                                                           
//

#include <stdio.h>
#include <socom\socom.h>
#include <socom\sample.h>

//Ŀ
//                                                                           
// Class specification                                                       
//                                                                           
//

class Module
{

 public:

   // Constructor
   Module( char* fileName );

   // Copy constructor
   Module( const Module& aMod );

   // Destructor
   virtual ~Module( void );

   // Assignment operator
   Module& operator =( const Module& aMod );

   // Get current master volume
   int   GetMasterVolume( void ) const;

   // Load module into memory
   virtual int LoadModule( void ) = 0;

   // Set current master volume
   void  SetMasterVolume( int mVolume );

 protected:

   Sample*  mySamples;
   ubyte**  myPatterns;
   FILE*    myFP;
   ulong    myPatSize;
   ulong    myPatNote;
   int      myNumPat;
   int      myNumChn;
   int      myNumSmp;
   int      mySongLen;
   int      myMasterVolume;
   int      myModType;
   bool     myPlayFlag;
   ubyte    myOrders[128];
   ubyte    myPanPos[32];

   // Allocate memory for patterns
   int   AllocPatterns( void );

   // Calculate number of patterns in module
   void  CalcNumPats( void );

   // Deallocate all memory used up by the module
   void  Clear( void );

   // Copy an object
   void  Copy( const Module& aMod );

   // Start playing module
   void  StartPlay( void );

   // Stop playing module
   void  StopPlay( void );

   friend class Gravis;
};


#endif   // __MODULE_H__
