
//Ŀ
//                                                                           
// SOCOM 1.0                                                                 
//                                                                           
// Sample - Implementation                                                   
//                                                                           
// (c) 1995 P.Lindh                                                          
//                                                                           
//

#include <string.h>
#include <socom\sample.h>

//Ŀ
//                                                                           
// Constructor                                                               
//                                                                           
//

Sample::Sample( void )
{
   myAddress = 0;
   myStatus  = SOC_OK;

   Clear();
}

//Ŀ
//                                                                           
// Copy constructor                                                          
//                                                                           
//

Sample::Sample( const Sample& aSample )
{
   Copy( aSample );
}

//Ŀ
//                                                                           
// Destructor                                                                
//                                                                           
//

Sample::~Sample( void )
{
   Clear();
}

//Ŀ
//                                                                           
// Assignment operator                                                       
//                                                                           
//

Sample& Sample::operator =( const Sample& aSample )
{
   Clear();
   Copy( aSample );

   return *this;
}

//Ŀ
//                                                                           
// Check status of loaded sample                                             
//                                                                           
//

int   Sample::CheckStatus( void ) const
{
   return myStatus;
}

//Ŀ
//                                                                           
// Clear sample                                                              
//                                                                           
//

void  Sample::Clear( void )
{
   if ( myAddress != 0 )      // if it is an address there, must deallocate
   {
      delete [] myAddress;

      myAddress = 0;
   }

   myRepPos     = 0;
   myRepEnd     = 0;
   myAddress    = 0;
   mySampleMode = 0;
   myGravisLoc  = 0;
}

//Ŀ
//                                                                           
// Copy a sample                                                             
//                                                                           
//

void  Sample::Copy( const Sample& aSample )
{
   myGravisLoc  = aSample.myGravisLoc;
   myRepPos     = aSample.myRepPos;
   myRepEnd     = aSample.myRepEnd;
   myLength     = aSample.myLength;
   myPeriod     = aSample.myPeriod;
   myFineTune60 = aSample.myFineTune60;
   myVolume     = aSample.myVolume;
   mySampleMode = aSample.mySampleMode;
   myStatus     = aSample.myStatus;

   myAddress = new ubyte [myLength];

   if ( myAddress != 0 )
   {
      memcpy( myAddress, aSample.myAddress, myLength );
   }
}

