
#ifndef  __SAMPLE_H__
#define  __SAMPLE_H__

//Ŀ
//                                                                           
// SOCOM 1.0                                                                 
//                                                                           
// Sample - Header file                                                      
//                                                                           
// (c) 1995 P.Lindh                                                          
//                                                                           
//

#include <socom\socom.h>

//Ŀ
//                                                                           
// Class specification                                                       
//                                                                           
//

class Sample
{

 public:

   // Constructor
   Sample( void );

   // Copy constructor
   Sample( const Sample& aSample );

   // Destructor
   virtual ~Sample( void );

   // Assignment operator
   Sample& operator =( const Sample& aSample );

   // Check status of loaded sample
   virtual int CheckStatus( void ) const;

 protected:

   ubyte*   myAddress;           // sample location in system RAM
   ulong    myGravisLoc;         // gravis DRAM location
   ulong    myRepPos;            // repeat position
   ulong    myRepEnd;            // repeat end position
   ulong    myLength;            // sample length
   int      myPeriod;            // sample period
   int      myFineTune60;        // fine tune * 60
   int      myStatus;            // sample status
   ubyte    myVolume;            // volume
   ubyte    mySampleMode;        // mode bits

   // Clear sample
   void  Clear( void );

   // Copy a sample
   void  Copy( const Sample& aSample );

   friend class Gravis;
   friend class MOD;
   friend class DSM;
   friend class Channel;
};

#endif   // __SAMPLE_H__
