
#ifndef  __SOCOM_TABLES_H__
#define  __SOCOM_TABLES_H__

//Ŀ
//                                                                           
// SOCOM                                                                     
//                                                                           
// Data tables structures and definitions                                    
//                                                                           
// (c) 1995 P.Lindh                                                          
//                                                                           
//

#include <socom\socom.h>

//Ŀ
//                                                                           
// Definitions for IRQ controller                                            
//                                                                           
//

#define  OCR1     0x20     // 8259-1 operation control register
#define  IMR1     0x21     // 8259-1 mask register
#define  OCR2     0xA0     // 8259-2 operation control register
#define  IMR2     0xA1     // 8259-2 mask register
#define  EOI      0x20     // general end of interrupt code

//Ŀ
//                                                                           
// Definitions for DMA controller                                            
//                                                                           
//

//Ŀ
//                                                                           
// DMA controller #1 (8-bit controller)                                      
//                                                                           
//

#define  DMA1_STAT   0x08     // read status register
#define  DMA1_WCMD   0x08     // write command register
#define  DMA1_WREQ   0x09     // write request register
#define  DMA1_SNGL   0x0A     // write single bit register
#define  DMA1_MODE   0x0B     // write mode register
#define  DMA1_CLRFF  0x0C     // clear byte ptr flip/flop
#define  DMA1_MCLR   0x0D     // master clear register
#define  DMA1_CLRM   0x0E     // clear mask register
#define  DMA1_WRTALL 0x0F     // write all mask register

//Ŀ
//                                                                           
// DMA controller #2 (16-bit controller)                                     
//                                                                           
//

#define  DMA2_STAT   0xD0     // read status register
#define  DMA2_WCMD   0xD0     // write command register
#define  DMA2_WREQ   0xD2     // write request register
#define  DMA2_SNGL   0xD4     // write single bit register
#define  DMA2_MODE   0xD6     // write mode register
#define  DMA2_CLRFF  0xD8     // clear byte ptr flip/flop
#define  DMA2_MCLR   0xDA     // master clear register
#define  DMA2_CLRM   0xDC     // clear mask register
#define  DMA2_WRTALL 0xDE     // write all mask register

#define  DMA0_ADDR   0x00     // chan 0 base adddress
#define  DMA0_CNT    0x01     // chan 0 base count
#define  DMA1_ADDR   0x02     // chan 1 base adddress
#define  DMA1_CNT    0x03     // chan 1 base count
#define  DMA2_ADDR   0x04     // chan 2 base adddress
#define  DMA2_CNT    0x05     // chan 2 base count
#define  DMA3_ADDR   0x06     // chan 3 base adddress
#define  DMA3_CNT    0x07     // chan 3 base count
#define  DMA4_ADDR   0xC0     // chan 4 base adddress
#define  DMA4_CNT    0xC2     // chan 4 base count
#define  DMA5_ADDR   0xC4     // chan 5 base adddress
#define  DMA5_CNT    0xC6     // chan 5 base count
#define  DMA6_ADDR   0xC8     // chan 6 base adddress
#define  DMA6_CNT    0xCA     // chan 6 base count
#define  DMA7_ADDR   0xCC     // chan 7 base adddress
#define  DMA7_CNT    0xCE     // chan 7 base count

#define  DMA0_PAGE   0x87     // chan 0 page register (refresh)
#define  DMA1_PAGE   0x83     // chan 1 page register
#define  DMA2_PAGE   0x81     // chan 2 page register
#define  DMA3_PAGE   0x82     // chan 3 page register
#define  DMA4_PAGE   0x8F     // chan 4 page register (unusable)
#define  DMA5_PAGE   0x8B     // chan 5 page register
#define  DMA6_PAGE   0x89     // chan 6 page register
#define  DMA7_PAGE   0x8A     // chan 7 page register

#define  DMA_DECREMENT  0x20  // mask to make DMA hardware go backwards

/* Bits for dma flags location */
#define DMA_USED  0x0001
#define DMA_PENDING 0x0002
#define TWO_FLAG  0x0004
#define REV_FLAG  0x0008
#define CALIB_COUNT  0x0010

#define ULTRA_PRESENT   0x0001      /* show this card is present */
#define  DRAM_DMA_BUSY  0x0002      /* show this channels dram dma is busy */
#define ADC_DMA_BUSY 0x0004      /* show we are busy recording */
#define DRAM_DMA_NOWAIT 0x0008      /* show we didn't wait last time */
#define ADC_DMA_NOWAIT  0x0010      /* show we didn't wait last time */

#define READ_DMA     1
#define WRITE_DMA    2
#define INDEF_READ      3  /* auto init record */
#define INDEF_WRITE     4  /* auto init record */

//Ŀ
//                                                                           
// Data structure representing one hardware IRQ line                         
//                                                                           
//

struct IRQLine
{
   ubyte latch;
   ubyte mask;
   ubyte spec_eoi;
   ubyte ocr;
   ubyte imr;
};

//Ŀ
//                                                                           
// Data structure representing one DMA channel                               
//                                                                           
//

struct DMAChan
{
   ubyte latch;
   ubyte disable;       // bits to disable DMA channel
   ubyte enable;        // bits to enable DMA channel
   ubyte page;          // page port location
   ubyte addr;          // addr port location
   ubyte count;         // count port location
   ubyte single;        // single mode port location
   ubyte mode;          // mode port location
   ubyte clrff;         // clear flip-flop port location
   ubyte write;         // bits for write transfer
   ubyte read;          // bits for read transfer
};


#endif   // __SOCOM_TABLES_H__
