/*
    Example 1

    This example just shows you how to allocate, reallocate and free
    thru the FXVM Manager's API.

    WARNING: If you are running this example from within the Borland IDE
    your computer _might_ crash. (the IDE does strange stuff with intr's)

*/

#include <conio.h>
#include <stdlib.h>
#include <dos.h>

#include "..\source.c\_fxapi.h"

#define  BIGBUFFER 8096000L /* our _eight_ megabyte buffer */

//[ Data ]

static char *windows[] =
{
  "DOS",
  "Windows/386 2.x",
  "Windows 3.x in Enhanced mode",
  "Windows 4.x in Enhanced mode",
  "Windows/386 2.x",
  "Windows 3.1+ in Standard mode",
  "Windows 3.0 in Standard mode"
  "Windows95"
  "Windows NT"
};

static char *protmode[] =
{
  "Real Mode (V86)",
  "Protected Mode",
  "Protected mode via MS-Windows Enhanced"
};

static char *cputypes[] =
{
  "8086"  ,
  "80186" ,
  "80286" ,
  "80386" ,
  "80486" ,
  "80586"
};

static char *fputypes[] =
{
  "None"    ,
  "Unknown" ,
  "80287"   ,
  "80387"
};

static char *dosextender[] =
{
  "None (DOS RealMode)",
  "ERGO OS286",
  "ERGO OS386",
  "PHARLAP|386"
};

//[ Code ]

int main( void )
{
    fxvmm_buffertype *bigbuf_handle = NULL ;

    if( !_fxvmm_open_api() )
     {
       fprintf( stderr , "\n\rFatal: Failed to initialize FXVM Manager - aborting");
       exit( -1 );
     }

    fprintf( stderr , FXVMM_BANNER "\n\r" , _fxvmm_vermajor() , _fxvmm_verminor() );

    switch( fxvmm_cputype )
     {
       case FXVMM_8086_CPU   :
       case FXVMM_80186_CPU  :
       case FXVMM_80286_CPU  :
                               fprintf( stderr , "\n\rSorry FXVMM requires a 386+ processor to run");
                               exit( -1 );
     }


    fprintf( stderr , "\n\r Detected CPU : %s", cputypes[fxvmm_cputype]        );
    fprintf( stderr , "\n\r Detected FPU : %s", fputypes[fxvmm_fputype]        );
    fprintf( stderr , "\n\r Running in   : %s", protmode[fxvmm_protmode]       );
    fprintf( stderr , "\n\r Running On   : %s", windows[fxvmm_windows]         );
    fprintf( stderr , "\n\r DOS Extender : %s\n\r", dosextender[fxvmm_dosextender] );

    /* setup memory allocation strategy */

    _fxvmm_set_strategy( fxvmm_strat_xms_handle , FXVMM_PRIORITY1 );
    _fxvmm_set_strategy( fxvmm_strat_ems_handle , FXVMM_PRIORITY2 );
    _fxvmm_set_strategy( fxvmm_strat_vrt_handle , FXVMM_PRIORITY3 );
    _fxvmm_set_strategy( fxvmm_strat_dos_handle , FXVMM_PRIORITY4 );

    /* Allocate our memory pool */

    if( ( bigbuf_handle = _fxvmm_alloc( (long)BIGBUFFER ) ) == NULL )
            fprintf( stderr, "\n\rWarning: Failed to allocate a block of %lu bytes !" , (long)BIGBUFFER );

    fprintf( stderr , "\n\rJust allocated 8 Megabytes of free space ...");
    fprintf( stderr , "\n\rNow hit any key to reallocate it to 16 Megabytes, or [ESC] to abort");

    if( getch() == 0x1b )
     {
       if( !_fxvmm_close_api() )
           fprintf( stderr , "\n\r*Warning* - Memory on this system has been corrupted !");

       exit( 0 );
     }

    /* Re-allocate our memory pool */

    if( ( bigbuf_handle = _fxvmm_realloc( bigbuf_handle, (long)BIGBUFFER*2L ) ) == NULL )
            fprintf( stderr, "\n\rWarning: Failed to allocate a block of %lu bytes !" , (long)BIGBUFFER*2L );

    fprintf( stderr , "\n\rJust allocated 16 Megabytes of free space ...");
    fprintf( stderr , "\n\rNow hit any key to reallocate it to 1024 *bytes*");

    getch();

    /* Re-allocate our memory pool */

    if( ( bigbuf_handle = _fxvmm_realloc( bigbuf_handle, 1024L ) ) == NULL )
            fprintf( stderr, "\n\rWarning: Failed to allocate a block of %lu bytes !" , 1024L );

    /* Free our memory pool */

    _fxvmm_free( bigbuf_handle );

    if( !_fxvmm_close_api() )
       fprintf( stderr , "\n\r*Warning* - Memory on this system has been corrupted !");
    else
       fprintf( stderr , "\n\rFXVM Manager closed down properly\n\r");

 return( 0 );

}

