/*
    Example 2

    This example shows you how to allocate a number of memory pools,
    write data to them, and read data from them thru the FXVM Manager's API.

    WARNING: If you are running this example from within the Borland IDE
    your computer _might_ crash. (the IDE does strange stuff with intr's)

*/

#include <conio.h>
#include <io.h>
#include <time.h>
#include <dir.h>
#include <string.h>
#include <stdlib.h>
#include <alloc.h>
#include <math.h>
#include <dos.h>

#pragma inline  /* A bit of inline assembly */

#define  MAXFRAME 40

#define  MAXPICX  320
#define  MAXPICY  200
#define  PICSIZE  64000L

#include "..\source.c\_fxapi.h"

unsigned char far picture[PICSIZE];

/* prototype */

char make_julia( int num );

//[ Data ]

static char *windows[] =
{
  "DOS",
  "Windows/386 2.x",
  "Windows 3.x in Enhanced mode",
  "Windows 4.x in Enhanced mode",
  "Windows/386 2.x",
  "Windows 3.1+ in Standard mode",
  "Windows 3.0 in Standard mode"
  "Windows95"
  "Windows NT"
};

static char *protmode[] =
{
  "Real Mode (V86)",
  "Protected Mode",
  "Protected mode via MS-Windows Enhanced"
};

static char *cputypes[] =
{
  "8086"  ,
  "80186" ,
  "80286" ,
  "80386" ,
  "80486" ,
  "80586"
};

static char *fputypes[] =
{
  "None"    ,
  "Unknown" ,
  "80287"   ,
  "80387"
};

static char *dosextender[] =
{
  "None (DOS RealMode)",
  "ERGO OS286",
  "ERGO OS386",
  "PHARLAP|386"
};

//[ Code ]

/*
   A very simple routine for creating a julia mandelbrot
   last minute thing, could be made nice by making a uniform
   palette (i.e. for example a gradient red,green and blue)
   and adjusted variables, so that the julia would zoom in ...
   if you have the time ... try it !
*/

char make_julia( int num )
{
  register unsigned int m , n;
  int count ;
  float r0, r1, i0, i1, zreal, zimag, zimag2, ztemp, zsize;
  float cr, ci, zrsqr, zisqr;

  fprintf( stderr,"\rGenerating picture %u of %u - hit [ESC] to abort...." , num , MAXFRAME );

  r0 = -2.0   ;
  r1 =  3.3   ;
  i0 =  3.5   ;
  i1 = -1.5   - (num/8);
  cr =  0.32  + (num/18);
  ci =  0.043 + (num/12);

  _fmemset( picture , ((num)%63) + 30 , PICSIZE );

  for( n = 0U ; n < 200U ; n++ )
    {
      if( kbhit() )
          if( getch() == 0x1b )
               return( 0 );

      zimag2 = i0 + ((i1-i0)*n)/200U;

      for( m = 0 ; m < 320U ; m++ )
       {
         zreal = r0 + ((r1-r0)*m)/200U ;
         zimag = zimag2;

         zrsqr = zreal*zreal;
         zisqr = zimag*zimag;

         for( count = zsize = 0; ((count < 256) && (zsize < 4.0)); count++ )
           {
             ztemp = zreal;
             zreal = zrsqr - zisqr + cr;
             zimag = 2*ztemp*zimag + ci;
             zrsqr = zreal*zreal;
             zisqr = zimag*zimag;
             zsize = zrsqr + zisqr;
           }

           picture[(m+80) + ((n << 8) + (n << 6))] = (((count + num)%63) + 30);
     }
   }

 return( 1 );

}

int main( void )
{
    unsigned int  loop = 0U   ;

    fxvmm_buffertype  *movie[MAXFRAME] = { NULL } ;

    /*
       The _fxvmm_markstack() function marks our DOS stacksize, it hooks
       the (local) function _fxvmm_exitstack() to the atexit() function,
       so that it gets called after a exit() statement
       Note: The purpose of this function lies more in the development
       area of developing applications, it's not really intended to be
       implemented in any 'distributed' applications.
    */

    _fxvmm_markstack(); /* Mark the stack - FIRST EXECUTABLE STATEMENT ! */

    if( !_fxvmm_open_api() )
     {
       fprintf( stderr , "\n\rFatal: Failed to initialize FXVM Manager - aborting");
       exit( -1 );
     }

    fprintf( stderr , FXVMM_BANNER , _fxvmm_vermajor() , _fxvmm_verminor() );

    switch( fxvmm_cputype )
     {
       case FXVMM_8086_CPU   :
       case FXVMM_80186_CPU  :
       case FXVMM_80286_CPU  :
                               fprintf( stderr , "\n\rSorry FXVMM requires a 386+ processor to run");
                               exit( -1 );
     }

    fprintf( stderr , "\n\r Detected CPU : %s", cputypes[fxvmm_cputype]        );
    fprintf( stderr , "\n\r Detected FPU : %s", fputypes[fxvmm_fputype]        );
    fprintf( stderr , "\n\r Running in   : %s", protmode[fxvmm_protmode]       );
    fprintf( stderr , "\n\r Running On   : %s", windows[fxvmm_windows]         );
    fprintf( stderr , "\n\r DOS Extender : %s\n\r", dosextender[fxvmm_dosextender] );

    /* display all memory avalailable to the FXVMM API */

    _fxvmm_display_allmem();

    /* setup memory allocation strategy */

    _fxvmm_set_strategy( fxvmm_strat_xms_handle , FXVMM_PRIORITY1 );
    _fxvmm_set_strategy( fxvmm_strat_ems_handle , FXVMM_PRIORITY2 );
    _fxvmm_set_strategy( fxvmm_strat_vrt_handle , FXVMM_PRIORITY3 );
    _fxvmm_set_strategy( fxvmm_strat_dos_handle , FXVMM_PRIORITY4 );

    fprintf( stderr ,"\n\r\n\rFor this next test, we will generate %u julia pictures, wich will be" , MAXFRAME );
    fprintf( stderr ,"\n\rstored into a dynamic FXVMM memory pool, after we have created the");
    fprintf( stderr ,"\n\r%u pictures, we will blit them directly to screen wich will _blaze_ !\n\r" , MAXFRAME );
    fprintf( stderr ,"\n\r(note that %u screen equals %lu bytes !)\n\r" , MAXFRAME , (unsigned long)(MAXFRAME*PICSIZE) );

    fprintf( stderr ,"\n\rHit any key to start generating the pictures ...");

    getch();

    for( loop = 0U ; loop < MAXFRAME ; loop++ )
     {
      if( ( movie[loop] = _fxvmm_alloc( PICSIZE ) ) == NULL )
          fprintf( stderr, "\n\rWarning: Failed to allocate a block of %lu bytes !" , PICSIZE);

        if( !make_julia( loop ) ) /* make a julia picture */
            {
              fprintf( stderr , "\n\rAborted ...");

              if( !_fxvmm_close_api() )
                  fprintf( stderr , "\n\r*Warning* - Memory on this system has been corrupted !");

              exit( -1 );
            }

       _fxvmm_abswrite( movie[loop] , 0U , picture , PICSIZE );
     }

    asm pusha            ;   /* Go into video mode */
    asm mov   ax,0x13    ;
    asm int   0x10       ;
    asm popa             ;

    /* copy it directly to video memory */

   while( !kbhit() )
    for( loop = 0U ; loop < MAXFRAME ; loop++ )
       _fxvmm_absread( MK_FP(0xA000,0x0000) , movie[loop] , 0U , PICSIZE );

    getch();

    asm pusha         /* Go back to text mode */
    asm mov ax,0x03
    asm int 0x10
    asm popa

    /* Free the memory pool */

    for( loop = 0U ; loop < MAXFRAME ; loop++ )
        _fxvmm_free( movie[loop] );

    /* Close down API */

    if( !_fxvmm_close_api() )
       fprintf( stderr , "\n\r*Warning* - Memory on this system has been corrupted !");
    else
       fprintf( stderr , "\n\rFXVM Manager closed down properly\n\r");

 return( 0 );

}

