; 386POWER INCLUDE FILE
; VIRTUAL 80x86 REGISTER IMAGE
global   V86eax:dword, V86ebx:dword, V86ecx:dword, V86edx:dword
global   V86esi:dword, V86edi:dword, V86ebp:dword
global   V86ah:byte, V86al:byte, V86bh:byte, V86bl:byte
global   V86ch:byte, V86cl:byte, V86dh:byte, V86dl:byte
global   V86ax:word, V86bx:word, V86cx:word, V86dx:word
global   V86si:word, V86di:word, V86bp:word
global   V86ds:word, V86es:word, V86fs:word, V86gs:word

; GLOBAL VARS
global   _SelCode:word, _SelData:word, _SelZero:word, _LoMemBase:dword
global   _LoMemTop:dword, _HiMemBase:dword, _HiMemTop:dword, _PSPBase:dword
global   _Code16Base:dword, _Code32Base:dword

; _386Return is a pointer (into low memory) to the first exit message
; _386Terminator is the default  exit message
global   _386Return:dword, _386Terminator:byte

; these two are POINTERS to the routines needed
; to set protected mode irq handlers
; call them with:
; BL = IRQ number
; EDX = offset of the routine into code32 segment
global _GetIRQ:dword, _SetIRQ:dword
; similar to the get/set irq these routines enable or disable
; the IRQ LINE on the Programmable Interrupt Controller
; call them with:
; bl = IRQ number
; al = IRQ flag status (0 = enabled, 1= disabled)
global _GetIRQMask:near, _SetIRQMask:near

; 386 MANager type ( 0=VCPI, 1=DPMI)
global   _386Man:byte

; routines to allocate memory
; IN: eax= size
;
; OUT: if CARRY_FLAG clear then 
;               eax = offset of allocated block (code32 relative)
;      else
;               not enough memory available
;
; _GetLoMem tries to allocate memory into dos ram (the first 640k)
; _GetHiMem tries to allocate memory into extended ram (beyound the 1st mega)
; _GetMem   tries first dos, then extended ram
global   _GetMem:near, _GetLoMem:near, _GetHiMem:near

; terminates program, sets text mode 03h and restores all interrupt handlers
global   _Exit:near 

; THE FOLLOWING TABLE IS LOCATED IN THE CODE16 SEGMENT
; it contains the "old" interrupt handlers
; (the handlers you call when you execute INT 33h from protected mode)
; it is visible so the virtual 80x86 bimodal irq servers can
; call the "old" interrupt handlers when they chain them
global   _OldInt:dword

@rlp    macro reg, ptr
        mov &reg,&ptr     ; Convert linear pointer to code32 pointer
        sub &reg,_Code32Base
endm

@php    macro reg, ptr
        mov &reg,&ptr     ; Convert code32 pointer to linear pointer
        add &reg,_Code32Base
endm

@outb   macro   val
        mov al,&val  ; Output a byte to DX
        out dx,al
endm

@outw   macro   val
        mov ax,&val  ; Output a word to DX
        out dx,ax
endm

@gif    macro
        mov ax,902h  ; Get interrupt flag status
        int 31h
endm

@gifc   macro
        mov ax,0900h ; Get interrupt flag status and clear
        int 31h
endm

@gifs   macro
        mov ax,0901h ; Get interrupt flag status and set
        int 31h
endm

@gifal  macro
        mov ah,09 ; Get interrupt flag status and set to AL (0=clear, 1=set)
        int 31h
endm

@hisize macro
        mov eax,_HiMemBase
        sub eax,_HiMemTop
endm

@losize macro
        mov eax,_LoMemBase
        sub eax,_LoMemTop
endm
        
IS_VCPI  = 0
IS_DPMI  = 1
                         
LOWMIN           = 256      ; minimum free low memory (in K)
EXTMIN           = 128      ; minimum free extended memory (in K)

STACKSIZE        = 0FFFh   ; total stack size in paragraphs (nearly 64k)
STACKSLOT        = 0200h   ; stack slot space in paragraphs (8 K) this means
                           ; a max. of 8 nested mode switch are allowed
CR = 13
LF = 10

