include 386video.inc

code32 segment para public use32
       assume cs:code32,ds:code32
;----------------------------------------------------------------------------
; void Set1Palette    al =  palette entry
;                    edx = bit 0..7   red
;                          bit 8..15  green
;                          bit 16..23 blue 
;                          bit 24..31 non utilizzati
;

		public  _Set1Palette
_Set1Palette:
                ; al = palette index
                ; edx = (XBGR)
                push eax
                push ebx
                push edx
                mov  ebx,edx
		mov     dx,DACWRITE
		cli
                out     dx,al  ; index
		inc	dx
                mov     al,bl
                out     dx,al  ; Red
                mov     al,bh
                shr     ebx,16
                out     dx,al  ; Green
                mov     al,bl
                out     dx,al  ; Blue
		sti
                pop edx
                pop ebx
                pop eax
		ret

;----------------------------------------------------------------------------
; void Set256Palette( byte far palette[256][3] )
;
		public  _Set256Palette
                
_Set256Palette:
                ; esi = palette pointer
                pushad
                mov     ecx,256
		mov     dx,STATUS
                cli
into_vretrace:
		in      al,dx
                test    al,IS_VSYNC
		jnz     into_vretrace
outof_vretrace:
		in      al,dx
                test    al,IS_VSYNC
		jz      outof_vretrace
                ; now a full vretrace interval is available
                 
		mov     dx,DACWRITE
                xor     eax,eax
		out	dx,al
		inc	dx
             nextp:   
                mov al,[esi]
                out dx,al
                inc esi
                mov al,[esi]
                out dx,al
                inc esi
                mov al,[esi]
                out dx,al
                inc esi
                loop nextp
                sti
                popad
		ret

code32  ends

        END
