; 386POWER example program #1.

        .386p
        jumps

code32  segment para public use32
        assume cs:code32, ds:code32

include 386power.inc
include 386video.inc
include 386mouse.inc
include 386file.inc
include 386arg.inc
include pix.inc
include pcx.inc
include picture.inc
include chario.inc
include pattern.inc

public  _Main
        align byte
Picture dd 0        
Sprite  dd 0
Pattern dd 0
MouPat  dd 0
MouN    dd 0
PatBase dd 0

Pcxname db  'TED.PCX',0
Fntname db  'CHARSET.CBF',0

Tilname  dd offset tilfname
tilfname db  'TILES.TBF',0

NumTiles dd 0  ; number of tiles loaded

flippy dd 0
floppy dd 0


; map description structure
MAPPA dd (XTILES*YTILES*2) dup(0)

ShowBar:
        pushad
        
        mov ecx,NumTiles
        sub ecx,MouN
        cmp ecx,10
        jb fullh
        mov ecx,10
fullh:
        mov edi,_ScoBase
        mov esi,MouPat 
        mov eax,160
        mov edx,1
hblit:        
        call _PutHPat
        add eax,16
        add esi,TILESIZE
        loop hblit
        popad
        ret
        
ShowUp:
        pushad
        mov esi,_ActiveBase
        mov edi,_ViewBase
        
        mov eax,159
        mov edx,90
        mov ecx,1
        mov ebx,4
gooo:        
        call _Scr2Scr
        sub eax,2
        jle showed
        sub edx,2
        jle showed
        inc ecx
        add ebx,4
        jmp short gooo
showed:        
        popad
        ret
        
epcx    db 'No TED.PCX file found!',CR,LF,'$'
echar   db 'No GREEN.CBF font file found!',CR,LF,'$'
etile   db 'No TILES.TBF font file found!',CR,LF,'$'

inputs  db 12 dup(0)
        
titlepcx  db '   Tiled Background Editor',0

_Main:  sti

        call _SetGameMode
        call _InstallRKB
        call _ArgInit
        ; load title screen
        mov esi,offset Pcxname 
        call _PcxLoad          
        mov _386Return, offset epcx
        cmp _PcxDecoded,0
        je Bye
        call ShowUp
        call _PageFlip

        
        ; load font file
        mov edi,_LoMemBase
        mov _386Return, offset echar
        mov _CHRFNT,edi        ;
        mov esi,offset Fntname ; load font into low memory
        call _LoFLoad          ;
        jc Bye
        add edi,eax        ; update memory base
        mov _LoMemBase,edi ;        
        
        mov edi,_ScoBase
        mov eax,0
        mov edx,2
        mov ebx, offset titlepcx
        call _PutString
        
        ; get the mouse cursor image from TED.PCX
        mov esi,_ViewBase
        mov eax,0
        mov edx,0
        mov ecx,4  ; 16 pixels = 4 nudget
        mov ebx,13 ; pixels
        mov edi,_LoMemBase
        mov Picture,edi
        call _GetPic
        ; compile it to TRLE bitmap format
        mov  Sprite,edi
        mov  esi,Picture
        call _Pic2Spt
        mov _LoMemBase,edi ; set new _LoMemBase
        
        mov edi,_LoMemBase
        mov _386Return,offset etile
        mov PatBase,edi         ; load number of fonts into low memory
        mov MouPat,edi          ; initial pattern is pattern 0
        mov MouN,0              ; pattern index 0
        call _ArgFile
        cmp byte ptr [esi],0 
        je no_tile_override
        mov Tilname,esi
no_tile_override:        
        mov esi,Tilname
        call _LoFLoad           ;
        jc Bye
        mov edi,_LoMemBase      ;
        add edi,eax             ;
        mov _LoMemBase,eax      ;
        
        mov edx,0          ;  How many tiles loaded ?
        mov ebx,TILESIZE   ;
        div ebx            ;
        mov NumTiles,eax   ;
        
        ; initialize MAP
        mov edi,offset MAPPA
        mov ecx,XTILES*YTILES
        mov eax,PatBase ; first pattern is always the "zero pattern"
minit:
        mov [edi],eax
        add edi,8
        loop minit
        
        call _MouseReset
        mov V86cx,155
        mov V86dx,75
        call _MouseSet
        mov V86cx,0
        mov V86dx,304
        call _MouseXRange
        mov V86dx,169
        call _MouseYRange
remap:        
        mov ecx,_TimerTicks
        mov flippy,ecx
        mov edi,_ScoBase
        mov eax,0
        mov edx,0
        mov ecx,80
        mov ebx,18
        mov esi,02020202h
        call _Block
        mov esi,offset MAPPA
        call ShowBar
tiloop: 
        call _DisplayStart
        call _PutMap
        call _MouseRead
        mov ecx,0 ; xincr
        mov ebx,0 ; yincr
        cmp V86cx,2
        jae via
        mov ecx,-8
via:    cmp V86cx,302
        jb col
        mov ecx,8
col:    cmp V86dx,2
        jae vento
        mov ebx,-6
vento:  cmp V86dx,167
        jb film
        mov ebx,6
film:   
        pushad
        movzx eax,V86cx
        movzx edx,V86dx
        mov esi,Sprite
        mov edi,_ActiveBase
        mov ebx,0
        call _PutSpt
        popad
        ; now check if the current position has to be replaced with MouPat
        cmp V86bx,0
        je nomoupress
        pushad
        movzx edi,V86cx
        add eax,edi
        movzx esi,V86dx
        add edx,esi
        mov ecx,eax
        mov ebx,THEIGHT
        mov eax,edx ; y
        shr ecx,5  ; x/32
        mov edx,0
        div ebx
        ;eax = tile row
        mov edx,(XTILES*8)
        mov ebp,MouPat
        mul edx
        mov [eax+ecx*8+ offset MAPPA],ebp
        popad
nomoupress:
        
        call _PageFlip
        
        pushad
        mov edx,2
        shr eax,5
        mov edi,_ScoBase
        mov cl,0 ; clear pix
        call _Pix
        popad        
        
        ; change position
        add eax,ecx
        add edx,ebx
        ; check if it's a correct position
        cmp eax,(VXWIDTH-DXWIDTH)
        jl  dnx
        mov eax,(VXWIDTH-DXWIDTH)
        mov ecx,0
        jmp short okx
dnx:    cmp eax,0
        jg  okx
        mov eax,0
        mov ecx,0
okx:    
        cmp edx,(VYHEIGHT-RYHEIGHT)
        jl  dny
        mov edx,(VYHEIGHT-RYHEIGHT)
        mov ebx,0
        jmp short oky
dny:    cmp edx,0
        jg  oky
        mov edx,0
        mov ebx,0
oky:    
        pushad
        mov edx,2
        shr eax,5
        mov edi,_ScoBase
        mov cl,15 ;set pix
        call _Pix
        mov eax,flippy
        mov ebx,_TimerTicks
        mov floppy,eax
        mov flippy,ebx
        sub ebx,eax
        ja zoks
        mov ebx,1
zoks:
        mov edx,0
        mov eax,1193180
        div ebx
        mov ebx,eax
        mov eax,0
        mov edx,4
        call _PutHex        
        popad
        
        mov edi,offset _RKB
        
        pushad
        cmp byte ptr [edi+_LEFT],KPRESSED ; has been pressed & released ?
        jne noleft
        mov byte ptr [edi+_LEFT],0 ; reset key
        cmp MouN,0
        je  noleft
        dec MouN
        sub MouPat,TILESIZE
        call ShowBar
        jmp short noright
noleft:
        cmp byte ptr [edi+_RIGHT],KPRESSED ; has been pressed & released ?
        jne noright
        mov byte ptr [edi+_RIGHT],0 ; reset key
        mov eax,NumTiles
        dec eax
        cmp eax,MouN
        jb  noright
        inc MouN
        add MouPat,TILESIZE
        call ShowBar        
noright:popad                

        cmp byte ptr [edi+_F2],KPRESSED
        je mapload
        
        cmp byte ptr [edi+_F3],KPRESSED
        je mapsave
        
        cmp byte ptr [edi+_ESC],KPRESSED
        jne tiloop
        call _RestoreTextMode
        mov _386Return,offset _386Terminator
Bye:        
        jmp _Exit

mapname db 30 dup(0)

load  db 'LOAD FILE?',0
save  db 'SAVE FILE?',0

gimmename:
        push ebx
        mov edi,_ScoBase
        mov eax,0
        mov edx,0
        mov ecx,80
        mov ebx,18
        mov esi,02020202h
        call _Block
        mov eax,0
        mov edx,4
        pop ebx
        call _PutString
        mov ecx,30
        mov ebx,offset mapname
        mov eax,10*8
        call _GetString
        ret
        
mapsave:
        mov byte ptr [edi+_F3],0
        pushad
sretry:        
        mov ebx,offset save
        call gimmename
        mov ecx,XTILES*YTILES
        mov ebx,PatBase
        mov esi,offset MAPPA
        mov edi,TILESIZE
indica:        
        mov eax,[esi]
        mov edx,0
        sub eax,ebx
        div edi
        mov [esi],eax
        add esi,8
        loop indica
        
        mov eax,XTILES*YTILES*8
        mov edi,offset MAPPA
        mov esi, offset mapname
        call _FSave
        
        jc sretry ; if error, retry
        mov ecx,XTILES*YTILES
        mov ebx,PatBase
        mov esi,offset MAPPA
        mov edi,TILESIZE
punta:        
        mov eax,[esi]
        mul edi
        add eax,ebx
        mov [esi],eax
        add esi,8
        loop punta
        popad
        jmp remap
        
errload db 'WRONG FILE, PRESS & RELEASE SPACE...',0

ferror: 
        mov edi,_ScoBase
        mov eax,0
        mov edx,0
        mov ecx,80
        mov ebx,18
        mov esi,02020202h
        mov eax,8
        mov edx,4
        mov ebx, offset errload
        call _PutString
        
        mov edi,offset _RKB
        mov byte ptr [edi+ _SPACEBAR],0
waitspace:        
        call _WaitKey
        cmp byte ptr [edi+ _SPACEBAR],KPRESSED
        jne waitspace
        mov byte ptr [edi+ _SPACEBAR],0        
        popad
        jmp remap
        
mapload:
        mov byte ptr [edi+_F2],0
        pushad
lretry:        
        mov ebx,offset load
        call gimmename

        mov esi, offset mapname
        mov al,0 ; read from file
        call _FOpen
        jc ferror
        call _FSize
        cmp eax,XTILES*YTILES*8
        je okey
        call _FClose
        jmp ferror
okey:        
        mov eax,XTILES*YTILES*8
        mov edi,offset MAPPA
        call _FRead
        call _FClose
        mov ecx,XTILES*YTILES
        mov ebx,PatBase
        mov esi,offset MAPPA
        mov edi,TILESIZE
lpunta:        
        mov eax,[esi]
        mul edi
        add eax,ebx
        mov [esi],eax
        add esi,8
        loop lpunta
nolretry:        
        popad
        jmp remap
        
code32  ends
        end

